/*
 * Decompiled with CFR 0.152.
 */
package model.storage;

import java.util.ArrayList;
import java.util.List;
import model.Column;
import model.ModelIdentifier;
import model.storage.Query;
import model.storage.Storage;
import model.util.SourceResult;

public abstract class ColumnStorage
extends Storage {
    public static void insert(Column col) {
        Query query = new Query("INSERT INTO #.columns       (id, title, type, width, color, default_show_title, on_off,         popup_text, datapacks_id, overlay_pos, overlay_id, deleted)       VALUES (NULL, :title, :type, :width, :color,         :default_show_title, :on_off, :popup_text,         :datapacks_id, :overlay_pos, :overlay_id, :deleted)");
        query.useDatabase(col.getIdentifier().getDatabase());
        query.setString("title", col.getTitle());
        query.setString("type", ModelIdentifier.getTypeName(col.getIdentifier().getType()));
        query.setDouble("width", col.getWidth());
        query.setString("color", col.getColor().toString());
        query.setBoolean("default_show_title", col.isShowTitle());
        query.setBoolean("on_off", col.isOnOff());
        query.setString("popup_text", col.getPopupText());
        query.setInt("datapacks_id", col.getDatapackIdentifier().getId());
        query.setInt("overlay_pos", col.getOverlayPos());
        query.setBoolean("deleted", col.isColumnDeleted());
        if (col.getOverlayId() != 0) {
            query.setInt("overlay_id", col.getOverlayId());
        } else {
            query.setNull("overlay_id");
        }
        query.executeUpdate();
        query.close();
    }

    public static void update(Column col) {
        Query query = new Query("UPDATE #.columns       SET title = :title, width = :width,         color = :color,         default_show_title = :default_show_title,         on_off = :on_off, popup_text = :popup_text,         overlay_id = :overlay_id,         overlay_pos = :overlay_pos,         datapacks_id = :datapack_id       WHERE id = :id");
        query.useDatabase(col.getIdentifier().getDatabase());
        query.setString("title", col.getTitle());
        query.setDouble("width", col.getWidth());
        query.setString("color", col.getColor().toString());
        query.setBoolean("default_show_title", col.isShowTitle());
        query.setBoolean("on_off", col.isOnOff());
        query.setString("popup_text", col.getPopupText());
        query.setNull("overlay_id");
        if (col.getOverlayId() != 0) {
            query.setInt("overlay_id", col.getOverlayId());
        }
        query.setInt("overlay_pos", col.getOverlayPos());
        query.setInt("datapack_id", col.getDatapackIdentifier().getId());
        query.setInt("id", col.getColumnIdentifier().getId());
        query.executeUpdate();
        query.close();
    }

    public static void load(List<SourceResult> results, ModelIdentifier id) {
        ArrayList<ModelIdentifier> ids = new ArrayList<ModelIdentifier>();
        ids.add(id);
        ColumnStorage.load(results, ids);
    }

    public static List<SourceResult> load(List<ModelIdentifier> ids) {
        return new ArrayList<SourceResult>();
    }

    public static void load(List<SourceResult> results, List<ModelIdentifier> ids) {
        Query query = new Query("SELECT '#' AS database, color, title, on_off,         overlay_id, overlay_pos, popup_text,         default_show_title, width, datapacks_id,        deleted, last_modified, creation_date       FROM #.columns       WHERE id = :id         AND NOT deleted         AND overlay_id IS NULL");
        for (int i = 0; i < ids.size(); ++i) {
            ModelIdentifier id = ids.get(i);
            query.useDatabase(id.getDatabase());
            query.setInt("id", id.getId());
            results.get(i).putAll(query.executeQuery().get(0));
        }
        query.close();
    }
}

