/*
 * Decompiled with CFR 0.152.
 */
package model.storage;

import java.util.ArrayList;
import java.util.List;
import model.FaciesColumn;
import model.FaciesData;
import model.ModelIdentifier;
import model.storage.DataStorage;
import model.storage.Query;
import model.util.SourceResult;

public class FaciesDataStorage
extends DataStorage {
    public static void insert(FaciesData data) {
        Query query = new Query("INSERT INTO #.facies_data       (id, data_id, facies_columns_id, pattern, label, series_label, members, linetype,        deleted)       VALUES (NULL, :data_id, :facies_columns_id, :pattern, :label, :series_label, :members, :linetype, \t             :deleted)");
        query.useDatabase(data.getIdentifier().getDatabase());
        query.setInt("data_id", data.getDataIdentifier().getId());
        query.setInt("facies_columns_id", data.getColumn().getIdentifier().getId());
        query.setString("pattern", data.getPattern());
        query.setString("label", data.getLabel());
        query.setString("series_label", data.getSeriesLabel());
        query.setString("members", data.getMembers());
        query.setInt("linetype", data.getLineType());
        query.setBoolean("deleted", data.isDeleted());
        query.executeUpdate();
        query.close();
    }

    public static void update(FaciesData data) {
        Query query = new Query("UPDATE #.facies_data       SET facies_columns_id = :facies_column_id, pattern = :pattern,         label = :label, series_label = :series_label, members = :members, linetype = :linetype,       WHERE id = :id");
        query.useDatabase(data.getIdentifier().getDatabase());
        query.setInt("id", data.getIdentifier().getId());
        query.setInt("facies_column_id", data.getColumn().getIdentifier().getId());
        query.setString("pattern", data.getPattern());
        query.setString("label", data.getLabel());
        query.setString("series_label", data.getSeriesLabel());
        query.setString("members", data.getMembers());
        query.setInt("linetype", data.getLineType());
        query.executeUpdate();
        query.close();
    }

    public static List<SourceResult> load(List<ModelIdentifier> ids) {
        ArrayList<SourceResult> results = new ArrayList();
        results = DataStorage.load(ids);
        Query query = new Query("SELECT id, label,                deleted, last_modified, creation_date      FROM #.facies_data       WHERE data_id = :id");
        for (int i = 0; i < ids.size(); ++i) {
            ModelIdentifier id = ids.get(i);
            query.useDatabase(id.getDatabase());
            query.setInt("id", id.getId());
            ((SourceResult)results.get(i)).putAll(query.executeQuery().get(0));
        }
        query.close();
        return results;
    }

    public static List<SourceResult> findByAge(FaciesColumn col, double top, double bottom) {
        Query query = new Query("SELECT '#' AS database, data.id       FROM #.data as data         JOIN #.facies_data as faciesdata ON ( data.id = faciesdata.data_id )       WHERE faciesdata.facies_columns_id = :facies_column_id         AND data.begin_age >= :begin_age         AND data.end_age <= :end_age         AND NOT data.deleted        AND NOT faciesdata.deleted");
        query.useDatabase(col.getIdentifier().getDatabase());
        query.setInt("facies_column_id", col.getIdentifier().getId());
        query.setDouble("begin_age", top);
        query.setDouble("end_age", bottom);
        return query.executeQuery();
    }
}

