/*
 * Decompiled with CFR 0.152.
 */
package model.storage;

import java.util.ArrayList;
import java.util.List;
import model.ModelIdentifier;
import model.PointColumn;
import model.PointData;
import model.storage.DataStorage;
import model.storage.Query;
import model.util.SourceResult;

public class PointDataStorage
extends DataStorage {
    public static void insert(PointData data) {
        Query query = new Query("INSERT INTO #.point_data       (id, data_id, point_columns_id, x_value, age_value, deleted)       VALUES (NULL, :data_id, :point_column_id, :x_value, :age_value, :deleted)");
        query.useDatabase(data.getIdentifier().getDatabase());
        query.setInt("point_column_id", data.getColumn().getIdentifier().getId());
        query.setInt("data_id", data.getDataIdentifier().getId());
        query.setDouble("x_value", data.getxValue());
        query.setDouble("age_value", data.getAgeValue());
        query.setBoolean("deleted", data.isDeleted());
        query.executeUpdate();
        query.close();
    }

    public static void update(PointData data) {
        Query query = new Query("UPDATE #.point_data       SET point_columns_id = :point_column_id,         x_value = :x_value, age_value = :age_value       WHERE id = :id");
        query.useDatabase(data.getIdentifier().getDatabase());
        query.setInt("id", data.getIdentifier().getId());
        query.setInt("point_column_id", data.getColumn().getIdentifier().getId());
        query.setDouble("x_value", data.getxValue());
        query.setDouble("age_value", data.getAgeValue());
        query.executeUpdate();
        query.close();
    }

    public static List<SourceResult> load(List<ModelIdentifier> ids) {
        ArrayList<SourceResult> results = new ArrayList();
        results = DataStorage.load(ids);
        Query query = new Query("SELECT id, x_value, age_value, deleted, last_modified, creation_date       FROM #.point_data       WHERE data_id = :id");
        for (int i = 0; i < ids.size(); ++i) {
            ModelIdentifier id = ids.get(i);
            query.useDatabase(id.getDatabase());
            query.setInt("id", id.getId());
            ((SourceResult)results.get(i)).putAll(query.executeQuery().get(0));
        }
        query.close();
        return results;
    }

    public static List<SourceResult> findByAge(PointColumn col, double top, double bottom) {
        Query query = new Query("SELECT '#' AS database, data.id       FROM #.data as data         JOIN #.point_data as pointdata ON ( data.id = pointdata.data_id )       WHERE pointdata.point_columns_id = :point_column_id         AND data.begin_age >= :begin_age         AND data.end_age <= :end_age         AND NOT data.deleted        AND NOT pointdata.deleted");
        query.useDatabase(col.getIdentifier().getDatabase());
        query.setInt("point_column_id", col.getIdentifier().getId());
        query.setDouble("begin_age", top);
        query.setDouble("end_age", bottom);
        List<SourceResult> results = query.executeQuery();
        query.close();
        return results;
    }
}

