/*
 * Decompiled with CFR 0.152.
 */
package model.storage;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import managers.DatabaseManager;
import managers.ErrorManager;
import model.util.SourceResult;

public class Query {
    private Map<String, List> paramPosition;
    private Map<String, Data> data;
    private Map<List<String>, PreparedStatement> stats;
    private List<String> databases;
    private String query;

    public Query(String query) {
        this.query = query;
        this.paramPosition = new HashMap<String, List>();
        this.data = new HashMap<String, Data>();
        this.stats = new HashMap<List<String>, PreparedStatement>();
        this.databases = new ArrayList<String>();
    }

    public void setNull(String param) {
        this.data.put(param, new Data(null, 0));
    }

    public void setString(String param, String value) {
        this.data.put(param, new Data(value, 1));
    }

    public void setInt(String param, int value) {
        this.data.put(param, new Data(value, 2));
    }

    public void setDouble(String param, double value) {
        this.data.put(param, new Data(value, 3));
    }

    public void setBoolean(String param, boolean value) {
        this.data.put(param, new Data(value, 4));
    }

    public void useDatabase(String db) {
        this.databases.clear();
        this.databases.add(db);
    }

    public void useDatabases(List<String> dbs) {
        this.databases.clear();
        this.databases.addAll(dbs);
    }

    public void useRegisteredDatabases() {
        this.databases.clear();
        this.databases.addAll(DatabaseManager.getInstance().getRegisteredDatabases());
    }

    public boolean execute() {
        this.makeStatement();
        try {
            return this.stats.get(this.databases).execute();
        }
        catch (SQLException e) {
            ErrorManager.getInstance().exception(e, "Could not execute database query");
            return false;
        }
    }

    public List<SourceResult> executeQuery() {
        List<SourceResult> results;
        this.makeStatement();
        try {
            ResultSet resultSet = this.stats.get(this.databases).executeQuery();
            results = SourceResult.translateResultSet(resultSet);
            resultSet.close();
        }
        catch (SQLException e) {
            ErrorManager.getInstance().exception(e, "Could not execute database query");
            return new ArrayList<SourceResult>();
        }
        return results;
    }

    public int executeUpdate() {
        this.makeStatement();
        try {
            return this.stats.get(this.databases).executeUpdate();
        }
        catch (SQLException e) {
            ErrorManager.getInstance().exception(e, "Could not execute database query");
            return -1;
        }
    }

    private void makeStatement() {
        if (!this.stats.containsKey(this.databases)) {
            String tmp_query = this.parse();
            try {
                PreparedStatement stat = DatabaseManager.getInstance().getConnection().prepareStatement(tmp_query);
                this.stats.put(this.databases, stat);
            }
            catch (SQLException e) {
                ErrorManager.getInstance().exception(e, "Could not prepare database query");
                return;
            }
        }
        for (Map.Entry<String, Data> entry : this.data.entrySet()) {
            switch (entry.getValue().getType()) {
                case 0: {
                    this.internalSetNull(entry.getKey());
                    break;
                }
                case 1: {
                    this.internalSetString(entry.getKey(), (String)entry.getValue().getData());
                    break;
                }
                case 2: {
                    this.internalSetInt(entry.getKey(), (Integer)entry.getValue().getData());
                    break;
                }
                case 3: {
                    this.internalSetDouble(entry.getKey(), (Double)entry.getValue().getData());
                    break;
                }
                case 4: {
                    this.internalSetBoolean(entry.getKey(), (Boolean)entry.getValue().getData());
                }
            }
        }
    }

    private void internalSetNull(String param) {
        List positions = this.paramPosition.get(param);
        if (positions == null) {
            return;
        }
        for (Integer pos : positions) {
            try {
                this.stats.get(this.databases).setNull(pos, 0);
            }
            catch (SQLException e) {
                ErrorManager.getInstance().exception(e, "Could not set database query data");
                return;
            }
        }
    }

    private void internalSetString(String param, String value) {
        List positions = this.paramPosition.get(param);
        if (positions == null) {
            return;
        }
        for (Integer pos : positions) {
            try {
                this.stats.get(this.databases).setString(pos, value);
            }
            catch (SQLException e) {
                ErrorManager.getInstance().exception(e, "Could not set database query data");
                return;
            }
        }
    }

    private void internalSetInt(String param, int value) {
        List positions = this.paramPosition.get(param);
        if (positions == null) {
            return;
        }
        for (Integer pos : positions) {
            try {
                this.stats.get(this.databases).setInt(pos, value);
            }
            catch (SQLException e) {
                ErrorManager.getInstance().exception(e, "Could not set database query data");
                return;
            }
        }
    }

    private void internalSetDouble(String param, double value) {
        List positions = this.paramPosition.get(param);
        if (positions == null) {
            return;
        }
        for (Integer pos : positions) {
            try {
                this.stats.get(this.databases).setDouble(pos, value);
            }
            catch (SQLException e) {
                ErrorManager.getInstance().exception(e, "Could not set database query data");
                return;
            }
        }
    }

    private void internalSetBoolean(String param, Boolean value) {
        List positions = this.paramPosition.get(param);
        if (positions == null) {
            return;
        }
        for (Integer pos : positions) {
            try {
                this.stats.get(this.databases).setBoolean(pos, value);
            }
            catch (SQLException e) {
                ErrorManager.getInstance().exception(e, "Could not set database query data");
                return;
            }
        }
    }

    private String parse() {
        int positionCounter = 1;
        String q = this.query;
        q = this.expandQuery(q);
        Pattern paramPattern = Pattern.compile("(?<=[^\\\\]):\\w+");
        Matcher paramMatcher = paramPattern.matcher(q);
        while (paramMatcher.find()) {
            String param = paramMatcher.toMatchResult().group(0);
            ArrayList<Integer> position = this.paramPosition.get(param = param.replaceFirst(":", ""));
            if (position == null) {
                position = new ArrayList<Integer>();
                this.paramPosition.put(param, position);
            }
            position.add(positionCounter++);
            q = q.substring(0, paramMatcher.start()) + "?" + q.substring(paramMatcher.end());
            paramMatcher.reset(q);
        }
        q.replaceAll("\\:", ":");
        return q;
    }

    private String expandQuery(String query) {
        String expandedQuery = "";
        if (this.databases.isEmpty()) {
            this.useRegisteredDatabases();
        }
        for (String database : this.databases) {
            expandedQuery = expandedQuery.concat(query.replaceAll("#", database));
            expandedQuery = expandedQuery.concat(" UNION ");
        }
        expandedQuery = expandedQuery.replaceFirst("UNION $", "");
        return expandedQuery;
    }

    public void close() {
        try {
            for (Map.Entry<List<String>, PreparedStatement> entry : this.stats.entrySet()) {
                entry.getValue().close();
                this.stats.remove(entry.getKey());
            }
        }
        catch (SQLException e) {
            ErrorManager.getInstance().exception(e, "Could not close database statement");
            return;
        }
    }

    private class Data {
        private int type;
        private Object data;
        private static final int NULL = 0;
        private static final int STRING = 1;
        private static final int INT = 2;
        private static final int DOUBLE = 3;
        private static final int BOOLEAN = 4;

        public Data(Object data, int type) {
            this.type = type;
            this.data = data;
        }

        public Object getData() {
            return this.data;
        }

        public void setData(Object data) {
            this.data = data;
        }

        public int getType() {
            return this.type;
        }

        public void setType(int type) {
            this.type = type;
        }
    }
}

