/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge.svg12;

import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.Messages;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.ScriptingEnvironment;
import org.apache.batik.bridge.svg12.SVG12BridgeContext;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.AbstractElement;
import org.apache.batik.dom.events.EventSupport;
import org.apache.batik.dom.svg12.SVGGlobal;
import org.apache.batik.dom.svg12.XBLEventSupport;
import org.apache.batik.dom.util.DOMUtilities;
import org.apache.batik.dom.util.TriplyIndexedTable;
import org.apache.batik.script.Interpreter;
import org.apache.batik.script.Window;
import org.w3c.dom.Element;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;

public class SVG12ScriptingEnvironment
extends ScriptingEnvironment {
    public static final String HANDLER_SCRIPT_DESCRIPTION = "SVG12ScriptingEnvironment.constant.handler.script.description";
    protected TriplyIndexedTable handlerScriptingListeners;

    public SVG12ScriptingEnvironment(BridgeContext bridgeContext) {
        super(bridgeContext);
    }

    protected void addDocumentListeners() {
        this.domNodeInsertedListener = new DOMNodeInsertedListener();
        this.domNodeRemovedListener = new DOMNodeRemovedListener();
        this.domAttrModifiedListener = new DOMAttrModifiedListener();
        AbstractDocument abstractDocument = (AbstractDocument)this.document;
        XBLEventSupport xBLEventSupport = (XBLEventSupport)abstractDocument.initializeEventSupport();
        xBLEventSupport.addImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeInserted", this.domNodeInsertedListener, false);
        xBLEventSupport.addImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeRemoved", this.domNodeRemovedListener, false);
        xBLEventSupport.addImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMAttrModified", this.domAttrModifiedListener, false);
    }

    protected void removeDocumentListeners() {
        AbstractDocument abstractDocument = (AbstractDocument)this.document;
        XBLEventSupport xBLEventSupport = (XBLEventSupport)abstractDocument.initializeEventSupport();
        xBLEventSupport.removeImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeInserted", this.domNodeInsertedListener, false);
        xBLEventSupport.removeImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeRemoved", this.domNodeRemovedListener, false);
        xBLEventSupport.removeImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMAttrModified", this.domAttrModifiedListener, false);
    }

    protected void addScriptingListenersOn(Element element) {
        String string = element.getNamespaceURI();
        String string2 = element.getLocalName();
        if ("http://www.w3.org/2000/svg".equals(string) && "handler".equals(string2)) {
            Object object;
            AbstractElement abstractElement = (AbstractElement)element.getParentNode();
            String string3 = element.getAttributeNS("http://www.w3.org/2001/xml-events", "event");
            String string4 = "http://www.w3.org/2001/xml-events";
            if (string3.indexOf(58) != -1) {
                object = DOMUtilities.getPrefix(string3);
                string3 = DOMUtilities.getLocalName(string3);
                string4 = ((AbstractElement)element).lookupNamespaceURI((String)object);
            }
            object = new HandlerScriptingEventListener(string4, string3, (AbstractElement)element);
            abstractElement.addEventListenerNS(string4, string3, (EventListener)object, false, null);
            if (this.handlerScriptingListeners == null) {
                this.handlerScriptingListeners = new TriplyIndexedTable();
            }
            this.handlerScriptingListeners.put(string4, string3, element, object);
        }
        super.addScriptingListenersOn(element);
    }

    protected void removeScriptingListenersOn(Element element) {
        String string = element.getNamespaceURI();
        String string2 = element.getLocalName();
        if ("http://www.w3.org/2000/svg".equals(string) && "handler".equals(string2)) {
            Object object;
            AbstractElement abstractElement = (AbstractElement)element.getParentNode();
            String string3 = element.getAttributeNS("http://www.w3.org/2001/xml-events", "event");
            String string4 = "http://www.w3.org/2001/xml-events";
            if (string3.indexOf(58) != -1) {
                object = DOMUtilities.getPrefix(string3);
                string3 = DOMUtilities.getLocalName(string3);
                string4 = ((AbstractElement)element).lookupNamespaceURI((String)object);
            }
            object = (EventListener)this.handlerScriptingListeners.put(string4, string3, element, null);
            abstractElement.removeEventListenerNS(string4, string3, (EventListener)object, false);
        }
        super.removeScriptingListenersOn(element);
    }

    public Window createWindow(Interpreter interpreter, String string) {
        return new Global(interpreter, string);
    }

    protected class Global
    extends ScriptingEnvironment.Window
    implements SVGGlobal {
        public Global(Interpreter interpreter, String string) {
            super(SVG12ScriptingEnvironment.this, interpreter, string);
        }

        public void startMouseCapture(EventTarget eventTarget, boolean bl, boolean bl2) {
            ((SVG12BridgeContext)SVG12ScriptingEnvironment.this.bridgeContext.getPrimaryBridgeContext()).startMouseCapture(eventTarget, bl, bl2);
        }

        public void stopMouseCapture() {
            ((SVG12BridgeContext)SVG12ScriptingEnvironment.this.bridgeContext.getPrimaryBridgeContext()).stopMouseCapture();
        }
    }

    protected class HandlerScriptingEventListener
    implements EventListener {
        protected String eventNamespaceURI;
        protected String eventType;
        protected AbstractElement handlerElement;

        public HandlerScriptingEventListener(String string, String string2, AbstractElement abstractElement) {
            this.eventNamespaceURI = string;
            this.eventType = string2;
            this.handlerElement = abstractElement;
        }

        public void handleEvent(Event event) {
            Element element = (Element)((Object)event.getCurrentTarget());
            String string = this.handlerElement.getTextContent();
            if (string.length() == 0) {
                return;
            }
            DocumentLoader documentLoader = SVG12ScriptingEnvironment.this.bridgeContext.getDocumentLoader();
            AbstractDocument abstractDocument = (AbstractDocument)this.handlerElement.getOwnerDocument();
            int n = documentLoader.getLineNumber(this.handlerElement);
            String string2 = Messages.formatMessage(SVG12ScriptingEnvironment.HANDLER_SCRIPT_DESCRIPTION, new Object[]{abstractDocument.getDocumentURI(), this.eventNamespaceURI, this.eventType, new Integer(n)});
            String string3 = this.handlerElement.getAttributeNS(null, "contentScriptType");
            if (string3.length() == 0) {
                Element element2 = element;
                while (!(element2 == null || "http://www.w3.org/2000/svg".equals(element2.getNamespaceURI()) && "svg".equals(element2.getLocalName()))) {
                    element2 = SVGUtilities.getParentElement(element2);
                }
                if (element2 == null) {
                    return;
                }
                string3 = element2.getAttributeNS(null, "contentScriptType");
            }
            SVG12ScriptingEnvironment.this.runEventHandler(string, event, string3, string2);
        }
    }

    protected class DOMAttrModifiedListener
    extends ScriptingEnvironment.DOMAttrModifiedListener {
        protected DOMAttrModifiedListener() {
            super(SVG12ScriptingEnvironment.this);
        }

        public void handleEvent(Event event) {
            super.handleEvent(EventSupport.getUltimateOriginalEvent(event));
        }
    }

    protected class DOMNodeRemovedListener
    extends ScriptingEnvironment.DOMNodeRemovedListener {
        protected DOMNodeRemovedListener() {
            super(SVG12ScriptingEnvironment.this);
        }

        public void handleEvent(Event event) {
            super.handleEvent(EventSupport.getUltimateOriginalEvent(event));
        }
    }

    protected class DOMNodeInsertedListener
    extends ScriptingEnvironment.DOMNodeInsertedListener {
        protected DOMNodeInsertedListener() {
            super(SVG12ScriptingEnvironment.this);
        }

        public void handleEvent(Event event) {
            super.handleEvent(EventSupport.getUltimateOriginalEvent(event));
        }
    }
}

