/*
 * Decompiled with CFR 0.152.
 */
package util;

import datastore.BlockSeriesMetaColumn;
import datastore.DataColumn;
import datastore.Datapoint;
import datastore.Datastore;
import datastore.EventColumn;
import datastore.FreehandColumn;
import datastore.PointColumn;
import datastore.RangeColumn;
import datastore.TransectColumn;
import datastore.ZoneColumn;
import gui.ExtensionFileFilter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.tree.TreeNode;
import managers.DatabaseManager;
import model.BlankColumn;
import model.BlockColumn;
import model.BlockData;
import model.ChronColumn;
import model.ChronData;
import model.Column;
import model.Data;
import model.Datapack;
import model.EventData;
import model.FaciesColumn;
import model.FaciesData;
import model.FreehandImageData;
import model.FreehandPoint;
import model.FreehandPolygonData;
import model.PointData;
import model.RangeColumn;
import model.RangeData;
import model.SequenceColumn;
import model.SequenceData;
import model.TransectLine;
import model.TransectPolygonData;
import model.TransectTextData;
import util.FileUtils;

public class Converter
implements ActionListener {
    private static File datapack;
    private static File database;
    private static Datapack dp;
    private static String connectedDB;
    private static JProgressBar progressBar;
    private static JButton startButton;
    private static JFrame frame;
    private static Container pane;
    private static int progress;
    private static JFileChooser packChooser;
    private static JFileChooser baseChooser;
    private static JTextArea task;
    private static Thread thread;
    public static boolean running;
    private static double lastAge;
    public String dbNameStr = null;

    @Override
    public void actionPerformed(ActionEvent evt) {
        String dbFilePath = null;
        if (packChooser.getSelectedFile() == null || baseChooser.getSelectedFile() == null) {
            if (packChooser.getSelectedFile() != null) {
                if (this.dbNameStr == null) {
                    return;
                }
                dbFilePath = baseChooser.getCurrentDirectory().getAbsolutePath();
            } else {
                return;
            }
        }
        if (running) {
            thread.stop();
            DatabaseManager.getInstance().endTransaction();
            this.setFileSelection(true);
            JOptionPane.showMessageDialog(null, "Conversion Cancelled");
            return;
        }
        this.setFileSelection(false);
        if (dbFilePath == null && this.dbNameStr == null) {
            database = new File(FileUtils.appendExtension(baseChooser.getSelectedFile().getAbsolutePath(), "sqlite"));
        } else {
            String dbFileName = dbFilePath + "/" + this.dbNameStr + ".sqlite";
            File dbFile = new File(dbFileName);
            baseChooser.setSelectedFile(dbFile);
            database = new File(dbFile.getAbsolutePath().toString());
        }
        thread = new Thread(){

            @Override
            public void run() {
                try {
                    DatabaseManager sqlite = DatabaseManager.getInstance();
                    sqlite.createNewDatabase(database.getPath());
                    for (File dp : packChooser.getSelectedFiles()) {
                        datapack = new File(FileUtils.appendExtension(dp.getAbsolutePath(), "txt"));
                        progressBar.setValue(progress = 0);
                        Converter.this.tabDelimtedToDatabase(datapack, database);
                    }
                    JOptionPane.showMessageDialog(null, "Conversion Complete");
                }
                catch (MalformedURLException ex) {
                    JOptionPane.showMessageDialog(null, ex.toString());
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(null, ex.toString());
                    ex.printStackTrace();
                }
                Converter.this.setFileSelection(true);
            }
        };
        thread.start();
    }

    private void setFileSelection(boolean yes) {
        running = !yes;
        if (running) {
            startButton.setText("Cancel");
        } else {
            startButton.setText("Start");
        }
        this.setEnabledRecursive(packChooser, yes);
        this.setEnabledRecursive(baseChooser, yes);
    }

    private void setEnabledRecursive(Container cont, boolean yes) {
        cont.setEnabled(yes);
        for (Component comp : cont.getComponents()) {
            if (comp instanceof Container) {
                this.setEnabledRecursive((Container)comp, yes);
                continue;
            }
            comp.setEnabled(yes);
        }
    }

    public static void main(String[] args) {
        running = false;
        Converter conv = new Converter();
        conv.initGUI();
    }

    public static List<Component> getAllComponents(Container c) {
        Component[] comps = c.getComponents();
        ArrayList<Component> compList = new ArrayList<Component>();
        for (Component comp : comps) {
            compList.add(comp);
            if (!(comp instanceof Container)) continue;
            compList.addAll(Converter.getAllComponents((Container)comp));
        }
        return compList;
    }

    public void initGUI() {
        packChooser = new JFileChooser();
        ExtensionFileFilter txt = new ExtensionFileFilter();
        txt.setDescription("TSCreator datapacks (*.txt)");
        txt.addExtension("txt", true);
        packChooser.setFileFilter(txt);
        packChooser.setControlButtonsAreShown(false);
        packChooser.setMultiSelectionEnabled(true);
        packChooser.setDragEnabled(true);
        JTextArea dpText = new JTextArea();
        dpText.append("Choose datapack to convert below.");
        dpText.setBackground(Color.LIGHT_GRAY);
        dpText.setEditable(false);
        JPanel packPanel = new JPanel(new BorderLayout());
        packPanel.add((Component)dpText, "First");
        packPanel.add((Component)packChooser, "Last");
        baseChooser = new JFileChooser();
        baseChooser.setDialogType(1);
        ExtensionFileFilter db = new ExtensionFileFilter();
        db.setDescription("SQLite database (*.sqlite)");
        db.addExtension("sqlite", true);
        baseChooser.setFileFilter(db);
        baseChooser.setControlButtonsAreShown(false);
        List<Component> baseChooserComps = Converter.getAllComponents(baseChooser);
        for (Component c : baseChooserComps) {
            if (!(c instanceof JTextField)) continue;
            final JTextField dbTextField = (JTextField)c;
            dbTextField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent e) {
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    Converter.this.dbNameStr = dbTextField.getText();
                    System.out.println(Converter.this.dbNameStr);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                }
            });
        }
        JTextArea dbText = new JTextArea();
        dbText.append("Choose where to save database below.");
        dbText.setBackground(Color.LIGHT_GRAY);
        dbText.setEditable(false);
        JPanel tmp = new JPanel(new BorderLayout());
        JPanel basePanel = new JPanel(new BorderLayout());
        basePanel.add((Component)dbText, "First");
        basePanel.add((Component)baseChooser, "Last");
        task = new JTextArea(10, 90);
        task.setEditable(false);
        startButton = new JButton("Start");
        startButton.addActionListener(this);
        progressBar = new JProgressBar(0, 100);
        progressBar.setStringPainted(true);
        progressBar.setVisible(true);
        frame = new JFrame("TSC Converter");
        frame.setLayout(new BorderLayout());
        frame.setDefaultCloseOperation(3);
        pane = frame.getContentPane();
        pane.add((Component)packPanel, "Before");
        pane.add((Component)basePanel, "After");
        tmp.add((Component)new JScrollPane(task), "First");
        tmp.add((Component)startButton, "Before");
        tmp.add((Component)progressBar, "Center");
        pane.add((Component)tmp, "Last");
        frame.pack();
        frame.setVisible(true);
    }

    public void tabDelimtedToDatabase(File ts, File db) throws MalformedURLException, Exception {
        Datastore ds = new Datastore();
        datapack = ts;
        database = db;
        DatabaseManager sqlite = DatabaseManager.getInstance();
        connectedDB = sqlite.createNewDatabase(db.getPath());
        if (connectedDB == null) {
            task.insert("|---- Error opening database ----|\n", 0);
            return;
        }
        DataColumn.FileInfo fileInfo = new DataColumn.FileInfo();
        fileInfo.workingDir = ts.getParentFile().toString();
        fileInfo.baseURL = new URL("file:" + ts.getParentFile().getAbsolutePath());
        fileInfo.loadPath = ts.getAbsolutePath();
        fileInfo.resource = false;
        fileInfo.ensureTrailingSlashes();
        ds.load(fileInfo);
        this.transferDatapack(ds);
        Iterator<DataColumn> iter = ds.currentSubRoot.getSubColumns();
        progressBar.setMaximum(this.countColumns(ds));
        task.insert("|---- Starting " + ts.getName() + " ----|\n", 0);
        sqlite.startTransaction();
        while (iter.hasNext()) {
            DataColumn dc = iter.next();
            this.transferAllColumns(dc);
        }
        sqlite.endTransaction();
        task.insert("|---- Finished " + ts.getName() + " ----|\n", 0);
    }

    private int countColumns(Datastore ds) {
        Iterator<DataColumn> iter = ds.currentSubRoot.getSubColumns();
        int ret = 0;
        while (iter.hasNext()) {
            DataColumn dc = iter.next();
            ret += this.countRecursion(dc) + 1;
        }
        return ret;
    }

    private int countRecursion(TreeNode node) {
        int ret = node.getChildCount();
        DataColumn dcol = (DataColumn)node;
        if (ret >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                ret += this.countRecursion(n);
            }
        }
        return ret;
    }

    private int transferDatapack(Datastore ds) throws SQLException, ClassNotFoundException {
        dp = new Datapack(connectedDB);
        dp.setName(datapack.getName());
        dp.setAgeUnits(ds.getCurrentUnits().getName());
        String intervalColumn = "";
        for (String s : ds.getCurrentUnits().getIntervalColNames()) {
            intervalColumn = intervalColumn + s + "\t";
        }
        dp.setDefaultChronostrat(ds.defaultColorScheme.toString());
        dp.save();
        Datapack.Factory.getByIdentifier(dp.getIdentifier());
        return dp.getIdentifier().getId();
    }

    private void transferAllColumns(TreeNode node) {
        DataColumn dcol = (DataColumn)node;
        this.transferColumn(dcol);
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                this.transferAllColumns(n);
            }
        }
    }

    private void saveOverlays(DataColumn dcol, int columnId) {
        int i;
        Iterator it;
        if (dcol.overlays != null) {
            it = dcol.overlays.iterator();
            i = 1;
            while (it.hasNext()) {
                this.saveColumn((DataColumn)it.next(), columnId, i++);
            }
        }
        if (dcol.underlays != null) {
            it = dcol.underlays.iterator();
            i = -1;
            while (it.hasNext()) {
                this.saveColumn((DataColumn)it.next(), columnId, i--);
            }
        }
    }

    private void transferOverlay(Column col, int overlayId, int overlayPos) {
        col.setOverlayId(overlayId);
        col.setOverlayPos(overlayPos);
    }

    private void transferColumn(DataColumn dcol) {
        task.insert("Converting: " + dcol.getName() + "\n", 0);
        int columnId = this.saveColumn(dcol, 0, 0);
        this.saveOverlays(dcol, columnId);
        progressBar.setValue(++progress);
        progressBar.repaint();
    }

    private int saveColumn(DataColumn dcol, int parentId, int overlayPos) {
        if (dcol instanceof ZoneColumn && !(dcol.getColParent() instanceof BlockSeriesMetaColumn)) {
            BlockColumn col = this.blockColumnTransfer((ZoneColumn)dcol);
            this.transferOverlay(col, parentId, overlayPos);
            ArrayList<BlockData> bds = this.blockDataTransfer(col, (ZoneColumn)dcol);
            col.save();
            for (BlockData bd : bds) {
                bd.save();
            }
            return col.getColumnIdentifier().getId();
        }
        if (dcol instanceof datastore.RangeColumn) {
            RangeColumn col = this.rangeColumnTransfer((datastore.RangeColumn)dcol);
            this.transferOverlay(col, parentId, overlayPos);
            ArrayList<RangeData> bds = this.rangeDataTransfer(col, (datastore.RangeColumn)dcol);
            col.save();
            for (RangeData bd : bds) {
                bd.save();
            }
            return col.getColumnIdentifier().getId();
        }
        if (dcol instanceof BlockSeriesMetaColumn && ((BlockSeriesMetaColumn)dcol).PATTERN_TITLE.equals("Chron")) {
            ChronColumn col = this.chronColumnTransfer((BlockSeriesMetaColumn)dcol);
            this.transferOverlay(col, parentId, overlayPos);
            ArrayList<ChronData> cds = this.chronDataTransfer(col, (BlockSeriesMetaColumn)dcol);
            col.save();
            for (ChronData cd : cds) {
                cd.save();
            }
            return col.getColumnIdentifier().getId();
        }
        if (dcol instanceof PointColumn) {
            model.PointColumn col = this.pointColumnTransfer((PointColumn)dcol);
            this.transferOverlay(col, parentId, overlayPos);
            ArrayList<PointData> pds = this.pointDataTransfer(col, (PointColumn)dcol);
            col.save();
            for (PointData pd : pds) {
                pd.save();
            }
            return col.getColumnIdentifier().getId();
        }
        if (dcol instanceof EventColumn) {
            model.EventColumn col = this.eventColumnTransfer((EventColumn)dcol);
            this.transferOverlay(col, parentId, overlayPos);
            ArrayList<EventData> eds = this.eventDataTransfer(col, (EventColumn)dcol);
            col.save();
            for (EventData ed : eds) {
                ed.save();
            }
            return col.getColumnIdentifier().getId();
        }
        if (dcol instanceof BlockSeriesMetaColumn && ((BlockSeriesMetaColumn)dcol).PATTERN_TITLE.equals("Facies")) {
            FaciesColumn col = this.faciesColumnTransfer((BlockSeriesMetaColumn)dcol);
            this.transferOverlay(col, parentId, overlayPos);
            List<FaciesData> cds = this.faciesDataTransfer(col, (BlockSeriesMetaColumn)dcol);
            col.save();
            for (FaciesData cd : cds) {
                cd.save();
            }
            return col.getColumnIdentifier().getId();
        }
        if (dcol.getClass().toString().equalsIgnoreCase("class datastore.DataColumn")) {
            BlankColumn bcol = this.blankColumnTransfer(dcol);
            this.transferOverlay(bcol, parentId, overlayPos);
            bcol.save();
            return bcol.getColumnIdentifier().getId();
        }
        if (dcol instanceof datastore.SequenceColumn) {
            SequenceColumn scol = this.sequenceColumnTransfer((datastore.SequenceColumn)dcol);
            this.transferOverlay(scol, parentId, overlayPos);
            ArrayList<SequenceData> sds = this.sequenceDataTransfer(scol, (datastore.SequenceColumn)dcol);
            scol.save();
            for (SequenceData sd : sds) {
                sd.save();
            }
            return scol.getColumnIdentifier().getId();
        }
        if (dcol instanceof TransectColumn) {
            model.TransectColumn col = this.transectColumnTransfer((TransectColumn)dcol);
            this.transferOverlay(col, parentId, overlayPos);
            List<TransectPolygonData> tds = this.transectDataTransfer(col, (TransectColumn)dcol);
            col.save();
            for (TransectPolygonData td : tds) {
                td.save();
            }
            List<TransectTextData> tts = this.transectTextsTransfer(col, (TransectColumn)dcol);
            for (TransectTextData tt : tts) {
                tt.save();
            }
            return col.getColumnIdentifier().getId();
        }
        if (dcol instanceof FreehandColumn) {
            model.FreehandColumn col = this.freehandColumnTransfer((FreehandColumn)dcol);
            this.transferOverlay(col, parentId, overlayPos);
            ArrayList<FreehandImageData> ims = new ArrayList<FreehandImageData>();
            ArrayList<FreehandPolygonData> pys = new ArrayList<FreehandPolygonData>();
            for (FreehandColumn.Primitive p : ((FreehandColumn)dcol).primitives) {
                if (p instanceof FreehandColumn.Image) {
                    ims.add(this.freehandImageDatatransfer(col, (FreehandColumn.Image)p));
                    continue;
                }
                if (!(p instanceof FreehandColumn.Polygon)) continue;
                pys.add(this.freehandPolygonDataTransfer(col, (FreehandColumn.Polygon)p));
            }
            col.save();
            for (FreehandImageData im : ims) {
                im.save();
            }
            for (FreehandPolygonData py : pys) {
                py.save();
            }
            return col.getColumnIdentifier().getId();
        }
        return 0;
    }

    private String toStringNotNull(Object obj) {
        if (obj == null) {
            return "default";
        }
        return obj.toString();
    }

    private int convertLineStyle(int ls) {
        switch (ls) {
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
        }
        return 1;
    }

    private void columnTransfer(Column col, DataColumn dcol) {
        col.setColor(this.toStringNotNull(dcol.color));
        col.setDatapack(dp);
        col.setOnOff(dcol.selected);
        col.setPopupText(dcol.popup);
        col.setShowTitle(dcol.drawTitle);
        col.setTitle(dcol.name);
        col.setWidth(dcol.getMyWidth());
    }

    private void dataTransfer(Data dat, Datapoint dp) {
        dat.setEndAge(dp.baseAge);
        dat.setPopup(dp.popup);
        dat.setPriority(dp.priority);
        if (dp.uncertainty != null) {
            dat.setUncertainty(dp.uncertainty);
        }
        dat.setBeginAge(lastAge);
        lastAge = dp.baseAge;
    }

    private BlockColumn blockColumnTransfer(ZoneColumn col) {
        BlockColumn bcol = new BlockColumn(connectedDB);
        this.columnTransfer(bcol, col);
        return bcol;
    }

    private ArrayList<BlockData> blockDataTransfer(BlockColumn col, ZoneColumn zcol) {
        Iterator dataPoints = zcol.getData();
        ArrayList<BlockData> bds = new ArrayList<BlockData>();
        int i = 0;
        while (dataPoints.hasNext()) {
            ZoneColumn.ZCDatapoint rdp = (ZoneColumn.ZCDatapoint)dataPoints.next();
            BlockData bd = new BlockData(col, connectedDB);
            this.dataTransfer(bd, rdp);
            bd.setColor(this.toStringNotNull(rdp.color));
            bd.setLabel(rdp.label);
            bd.setLineStyle(this.convertLineStyle(rdp.lineType));
            bds.add(bd);
            ++i;
        }
        return bds;
    }

    private RangeColumn rangeColumnTransfer(datastore.RangeColumn col) {
        RangeColumn rcol = new RangeColumn(connectedDB);
        this.columnTransfer(rcol, col);
        return rcol;
    }

    private ArrayList<RangeData> rangeDataTransfer(RangeColumn col, datastore.RangeColumn rcol) {
        Iterator dataPoints = rcol.getData();
        ArrayList<RangeData> bds = new ArrayList<RangeData>();
        int i = 0;
        while (dataPoints.hasNext()) {
            RangeColumn.RCDatapoint rdp = (RangeColumn.RCDatapoint)dataPoints.next();
            RangeData bd = new RangeData(col, connectedDB);
            this.dataTransfer(bd, rdp);
            bd.setLabel(rdp.label);
            bd.setAbundance(rdp.type);
            bds.add(bd);
            ++i;
        }
        return bds;
    }

    private ChronColumn chronColumnTransfer(BlockSeriesMetaColumn col) {
        ChronColumn ccol = new ChronColumn(connectedDB);
        this.columnTransfer(ccol, col);
        ccol.setSeriesWidth(col.getMyWidth());
        if (col.color == null) {
            ccol.setColor("default");
        } else {
            ccol.setColor(col.color.toString());
        }
        ccol.setSeriesWidth(col.getMyWidth());
        ccol.setDatapack(dp);
        return ccol;
    }

    private ArrayList<ChronData> chronDataTransfer(ChronColumn col, BlockSeriesMetaColumn ccol) {
        Iterator dataPoints = ccol.getData();
        ArrayList<ChronData> cds = new ArrayList<ChronData>();
        int i = 0;
        while (dataPoints.hasNext()) {
            Datapoint dat = (Datapoint)dataPoints.next();
            ChronData cd = new ChronData(col, connectedDB);
            this.dataTransfer(cd, dat);
            cd.setLabel(dat.label);
            cd.setPolarity(dat.value.toString());
            cds.add(cd);
            ++i;
        }
        return cds;
    }

    private model.PointColumn pointColumnTransfer(PointColumn col) {
        model.PointColumn pcol = new model.PointColumn(connectedDB);
        this.columnTransfer(pcol, col);
        pcol.setFillColor(this.toStringNotNull(col.fillColor));
        pcol.setLine(col.drawLine);
        pcol.setRangeHigh(col.maxWindow);
        pcol.setRangeLow(col.minWindow);
        pcol.setSmoothed(col.drawSmooth);
        return pcol;
    }

    private ArrayList<PointData> pointDataTransfer(model.PointColumn col, PointColumn pcol) {
        Iterator dataPoints = pcol.getData();
        ArrayList<PointData> pds = new ArrayList<PointData>();
        int i = 0;
        while (dataPoints.hasNext()) {
            Datapoint dat = (Datapoint)dataPoints.next();
            PointData pd = new PointData(col, connectedDB);
            this.dataTransfer(pd, dat);
            pd.setxValue(Double.parseDouble(dat.value.toString()));
            pd.setAgeValue(dat.baseAge);
            pds.add(pd);
            ++i;
        }
        return pds;
    }

    private model.EventColumn eventColumnTransfer(EventColumn col) {
        model.EventColumn ecol = new model.EventColumn(connectedDB);
        this.columnTransfer(ecol, col);
        return ecol;
    }

    private ArrayList<EventData> eventDataTransfer(model.EventColumn col, EventColumn ecol) {
        Iterator dataPoints = ecol.getData();
        ArrayList<EventData> eds = new ArrayList<EventData>();
        int i = 0;
        while (dataPoints.hasNext()) {
            Datapoint dat = (Datapoint)dataPoints.next();
            EventData ed = new EventData(col, connectedDB);
            this.dataTransfer(ed, dat);
            ed.setLabel(dat.label);
            ed.setType(dat.value.toString());
            ed.setLineStyle(this.convertLineStyle(dat.lineType));
            eds.add(ed);
            ++i;
        }
        return eds;
    }

    private BlankColumn blankColumnTransfer(DataColumn col) {
        BlankColumn bcol = new BlankColumn(connectedDB);
        this.columnTransfer(bcol, col);
        return bcol;
    }

    private SequenceColumn sequenceColumnTransfer(datastore.SequenceColumn col) {
        SequenceColumn scol = new SequenceColumn(connectedDB);
        this.columnTransfer(scol, col);
        if (col.type == 2) {
            scol.setTrend(true);
        } else {
            scol.setTrend(false);
        }
        return scol;
    }

    private ArrayList<SequenceData> sequenceDataTransfer(SequenceColumn col, datastore.SequenceColumn scol) {
        Iterator dataPoints = scol.getData();
        ArrayList<SequenceData> sds = new ArrayList<SequenceData>();
        int i = 0;
        while (dataPoints.hasNext()) {
            Datapoint dat = (Datapoint)dataPoints.next();
            SequenceData sd = new SequenceData(col, connectedDB);
            this.dataTransfer(sd, dat);
            sd.setLabel(dat.label);
            if (dat.direction.equalsIgnoreCase("SB")) {
                sd.setSequenceBoundry(true);
            } else {
                sd.setSequenceBoundry(false);
            }
            sd.setSeverity(this.convertSeverity(dat));
            sds.add(sd);
            ++i;
        }
        return sds;
    }

    private String convertSeverity(Datapoint dp) {
        double severity = Double.parseDouble(dp.value.toString());
        if (severity == 0.75 || severity == 1.0) {
            return "major";
        }
        if (severity == 0.5 || severity == 0.66) {
            return "medium";
        }
        if (severity == 0.25 || severity == 0.33) {
            return "minor";
        }
        return "";
    }

    private FaciesColumn faciesColumnTransfer(BlockSeriesMetaColumn col) {
        FaciesColumn fcol = new FaciesColumn(connectedDB);
        this.columnTransfer(fcol, col);
        fcol.setSeriesWidth(col.getMyWidth());
        if (col.color == null) {
            fcol.setColor("default");
        } else {
            fcol.setColor(col.color.toString());
        }
        fcol.setSeriesWidth(col.getMyWidth());
        fcol.setDatapack(dp);
        return fcol;
    }

    private List<FaciesData> faciesDataTransfer(FaciesColumn col, BlockSeriesMetaColumn ccol) {
        Iterator dataPoints = ccol.getData();
        ArrayList<FaciesData> cds = new ArrayList<FaciesData>();
        int i = 0;
        while (dataPoints.hasNext()) {
            Datapoint dat = (Datapoint)dataPoints.next();
            FaciesData cd = new FaciesData(col, connectedDB);
            this.dataTransfer(cd, dat);
            cd.setPattern(dat.value.toString());
            cd.setLabel(dat.label);
            cd.setSeriesLabel(dat.series);
            cd.setMembers(dat.member);
            cd.setLineType(dat.lineType);
            cds.add(cd);
            ++i;
        }
        return cds;
    }

    private model.TransectColumn transectColumnTransfer(TransectColumn col) {
        model.TransectColumn tcol = new model.TransectColumn(connectedDB);
        this.columnTransfer(tcol, col);
        return tcol;
    }

    private List<TransectPolygonData> transectDataTransfer(model.TransectColumn col, TransectColumn tcol) {
        Vector ps = tcol.polygons;
        ArrayList<TransectPolygonData> tds = new ArrayList<TransectPolygonData>();
        int len = ps.size();
        for (int i = 0; i < len; ++i) {
            TransectColumn.Polygon p = (TransectColumn.Polygon)ps.get(i);
            TransectPolygonData td = new TransectPolygonData(col, connectedDB);
            td.setPopup(p.popup);
            this.transectDataLinesTransfer(td, p);
            tds.add(td);
        }
        return tds;
    }

    private List<TransectTextData> transectTextsTransfer(model.TransectColumn col, TransectColumn tcol) {
        Vector tls = tcol.textLabels;
        ArrayList<TransectTextData> tts = new ArrayList<TransectTextData>();
        for (TransectColumn.TextLabel tl : tls) {
            TransectTextData tt = new TransectTextData(col, connectedDB);
            tt.setTitle(tl.text.getOriginalString());
            tt.setWidthPos(tl.point.x);
            tt.setAgePos(tl.point.y);
            tt.setStyle(tl.font.getSVGStyle());
            tt.setSpread(tl.ageSpread);
            tt.setWidth(tl.widthFrac);
            tts.add(tt);
        }
        return tts;
    }

    private void transectDataLinesTransfer(TransectPolygonData td, TransectColumn.Polygon p) {
        for (TransectColumn.Line l : p.lines) {
            double x1 = l.a.x;
            double x2 = l.b.x;
            double y1 = l.a.y;
            double y2 = l.b.y;
            String type = l.getDatafileStyle();
            TransectLine line = new TransectLine(connectedDB);
            line.setStartAge(y1);
            line.setEndAge(y2);
            line.setStartWidth(x1);
            line.setEndWidth(x2);
            td.addLine(line);
        }
    }

    private model.FreehandColumn freehandColumnTransfer(FreehandColumn col) {
        model.FreehandColumn fcol = new model.FreehandColumn(connectedDB);
        this.columnTransfer(fcol, col);
        return fcol;
    }

    private FreehandImageData freehandImageDatatransfer(model.FreehandColumn col, FreehandColumn.Image i) {
        FreehandImageData fid = new FreehandImageData(col, connectedDB);
        fid.setEndAge(i.baseAge);
        fid.setImage(i.getImageFilename());
        fid.setPopup(i.popup);
        fid.setBeginAge(i.topAge);
        return fid;
    }

    private FreehandPolygonData freehandPolygonDataTransfer(model.FreehandColumn col, FreehandColumn.Polygon p) {
        FreehandPolygonData pyd = new FreehandPolygonData(col, connectedDB);
        pyd.setEndAge(p.baseAge);
        pyd.setClosed(p.closed);
        pyd.setPopup(p.popup);
        this.freehandPointDataTransfer(pyd, p);
        return pyd;
    }

    private void freehandPointDataTransfer(FreehandPolygonData pyd, FreehandColumn.Polygon p) {
        for (FreehandColumn.Polygon.Point point : p.points) {
            double width_pos = point.x;
            double age_pos = point.y;
            FreehandPoint pnt = new FreehandPoint(pyd, connectedDB);
            pnt.setPolygon(pyd);
            pnt.setWidthPos(width_pos);
            pnt.setAgePos(age_pos);
            pyd.addPoint(pnt);
        }
    }

    static {
        lastAge = 0.0;
    }
}

