/*
 * Decompiled with CFR 0.152.
 */
package gui;

import datastore.ChronColumn;
import datastore.Coloring;
import datastore.DataColumn;
import datastore.MetaColumn;
import datastore.PatternManager;
import datastore.RangeColumn;
import datastore.RootColumn;
import gui.LinkProcessor;
import gui.RichText;
import gui.Settings;
import gui.StringWrappingInfo;
import gui.TSCFont;
import gui.TSCreator;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.geom.Rectangle2D;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.apache.batik.dom.events.DOMMouseEvent;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.batik.transcoder.image.JPEGTranscoder;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.apache.batik.transcoder.svg2svg.SVGTranscoder;
import org.apache.fop.svg.PDFTranscoder;
import org.w3c.dom.CDATASection;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.svg.SVGDocument;
import path.ResPath;
import util.Base64;
import util.Debug;
import util.FileUtils;
import util.HTMLPreprocessor;
import util.NumberUtils;
import util.Vector2D;

public class ImageGenerator {
    public static final int pixPerCm = 30;
    public RootColumn rootCol;
    public Settings settings;
    public Settings settingsRefFamilyTree;
    public DOMImplementation impl;
    public SVGDocument doc;
    public Element svgRoot;
    public Element patternRoot;
    public Element timeline;
    public Element timelabel;
    public PatternManager patMan;
    public SVGGraphics2D g;
    public LinkProcessor linkProc = null;
    protected String svgNS;
    protected Element curElement;
    protected Stack groupings;
    protected int clipPathNum = 0;
    public static int gradNum = 0;
    protected boolean allowNegatives;
    protected double canvasWidth;
    protected double canvasHeight;
    public static final int TEXT_SIZE = 20;
    public static final String BORDER_STYLE = "stroke-width:" + Settings.BORDER_WIDTH + "; fill: none; stroke: black;";
    public static final String TIMELINE_STYLE = "stroke: red; stroke-opacity: 0.5;";
    public static final String TIMELINE_LABEL_STYLE = "font-family: verdana; fill: red; fill-opacity: 0.7;";
    public static final String CP_MARKER_STYLE = "fill-opacity: 0.7; r: 7;";
    public static final String CP_MODEL_STYLE = "r: 7;";
    public static final String CP_PLOT_POPUP_BOX_STYLE = "fill: black; stroke: none; fill-opacity: 0.6;";
    public static final String CP_PLOT_POPUP_TEXT_STYLE = "fill: white; font-family: verdana;";
    public static String line_color = "gray";
    public static String model_color = "black";
    public static String marker_color = "gray";
    public static final int TOP = 1;
    public static final int CENTER = 2;
    public static final int BOTTOM = 3;
    public static final int PREFERRED = 4;
    public static final int BOTTOM_RIGHT = 8;
    public static final int TOP_LEFT = 9;
    public static final int ONLY_TEXT = 10;
    public static final int TEXT_AND_BACKGROUND = 12;
    public static final int POINT_RECT = 1;
    public static final int POINT_ROUND = 2;
    public static final int POINT_TICK = 3;
    public static final int POINT_DIMENSION = 4;
    public static final int SOLID_LINE = 1;
    public static final int DASHED_LINE = 2;
    public static final int DOTTED_LINE = 3;
    public static final double CONTROL_POINT_LENGTH = 0.4;
    public static final double MAX_CONTROL_POINT_LENGTH = 10.0;
    public static final double MIN_CONTROL_POINT_LENGTH = 0.001;
    private HashMap<EventTarget, RangeColumn.RangePoint> branchNodeList = null;
    public DataColumn interval_column = null;
    protected Vector popups;
    public double extraColumnWidth = 0.0;

    public static boolean includesBackground(int i) {
        return i == 12;
    }

    public ImageGenerator(RootColumn col, Settings s, PatternManager patMan) {
        this.rootCol = col;
        this.settings = s;
        this.settingsRefFamilyTree = s;
        this.patMan = patMan;
        this.reset();
    }

    public final void reset() {
        this.impl = SVGDOMImplementation.getDOMImplementation();
        this.svgNS = "http://www.w3.org/2000/svg";
        this.doc = (SVGDocument)this.impl.createDocument(this.svgNS, "svg", null);
        this.doc.setDocumentURI("file:/temp/whatever.svg");
        this.g = new SVGGraphics2D(this.doc);
        this.groupings = new Stack();
        this.popups = new Vector();
        this.curElement = this.svgRoot = this.doc.getDocumentElement();
        this.loadPatterns();
    }

    public void loadPatterns() {
        this.patternRoot = this.pushGrouping();
        ChronColumn.setupPatterns(this);
        this.popGrouping();
    }

    public void setAllowNegatives(boolean tf) {
        this.allowNegatives = tf;
    }

    public boolean getAllowNegatives() {
        return this.allowNegatives;
    }

    public static void write(SVGDocument doc, Writer w) throws TranscoderException {
        SVGTranscoder st = new SVGTranscoder();
        TranscoderOutput to = new TranscoderOutput(w);
        TranscoderInput ti = new TranscoderInput(doc);
        st.transcode(ti, to);
    }

    public void write(Writer w) throws TranscoderException {
        ImageGenerator.write(this.doc, w);
    }

    public static void writePDF(SVGDocument doc, OutputStream os) throws TranscoderException {
        JOptionPane optionPane = new JOptionPane("SVG file saved, saving to PDF next.\nClick \"OK\" to continue.", 1, -1);
        JDialog messageBox = null;
        if (!TSCreator.NODE_MODE) {
            messageBox = optionPane.createDialog("Saving ...");
            messageBox.setVisible(true);
        }
        try {
            PDFTranscoder pt = new PDFTranscoder();
            TranscoderOutput to = new TranscoderOutput(os);
            TranscoderInput ti = new TranscoderInput(doc);
            pt.addTranscodingHint(PDFTranscoder.KEY_HEIGHT, Float.valueOf(2500.0f));
            pt.transcode(ti, to);
            os.flush();
            os.close();
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            System.exit(-1);
        }
        if (messageBox != null) {
            messageBox.setVisible(false);
        }
    }

    public void writePDF(OutputStream os) throws TranscoderException {
        ImageGenerator.writePDF(this.doc, os);
    }

    public static void writePNG(SVGDocument doc, OutputStream os, int width, int height) throws TranscoderException {
        PNGTranscoder pngTrans = new PNGTranscoder();
        pngTrans.addTranscodingHint(PNGTranscoder.KEY_WIDTH, new Float(width));
        pngTrans.addTranscodingHint(PNGTranscoder.KEY_HEIGHT, new Float(height));
        pngTrans.addTranscodingHint(ImageTranscoder.KEY_BACKGROUND_COLOR, Color.white);
        TranscoderOutput to = new TranscoderOutput(os);
        TranscoderInput ti = new TranscoderInput(doc);
        pngTrans.transcode(ti, to);
    }

    public void writePNG(OutputStream os, int width, int height) throws TranscoderException {
        ImageGenerator.writePNG(this.doc, os, width, height);
    }

    public static void writeJPG(SVGDocument doc, OutputStream os, int width, int height) throws TranscoderException {
        JPEGTranscoder pngTrans = new JPEGTranscoder();
        pngTrans.addTranscodingHint(JPEGTranscoder.KEY_WIDTH, new Float(width));
        pngTrans.addTranscodingHint(JPEGTranscoder.KEY_HEIGHT, new Float(height));
        pngTrans.addTranscodingHint(JPEGTranscoder.KEY_QUALITY, new Float(1.0f));
        pngTrans.addTranscodingHint(ImageTranscoder.KEY_BACKGROUND_COLOR, Color.white);
        TranscoderOutput to = new TranscoderOutput(os);
        TranscoderInput ti = new TranscoderInput(doc);
        pngTrans.transcode(ti, to);
    }

    public void writeJPG(OutputStream os, int width, int height) throws TranscoderException {
        ImageGenerator.writeJPG(this.doc, os, width, height);
    }

    public void setCanvasSize(double width, double height) {
        this.svgRoot.setAttributeNS(null, "onload", "Init(evt)");
        this.svgRoot.setAttributeNS(null, "width", this.round(width / 30.0) + "cm");
        this.svgRoot.setAttributeNS(null, "height", this.round(height / 30.0) + "cm");
        this.svgRoot.setAttributeNS(null, "viewBox", "0 0 " + this.round(width) + " " + this.round(height));
        this.canvasWidth = width;
        this.canvasHeight = height;
    }

    public Element pushGrouping() {
        this.groupings.push(this.curElement);
        Element newG = this.doc.createElementNS(this.svgNS, "g");
        this.curElement.appendChild(newG);
        this.curElement = newG;
        return newG;
    }

    protected Element pushElement(Element e) {
        this.groupings.push(this.curElement);
        this.curElement = e;
        return e;
    }

    public void popGrouping() {
        this.curElement = (Element)this.groupings.pop();
    }

    public String pushClipPath() {
        String id = "clipPath" + this.clipPathNum++;
        this.pushClipPath(id);
        return id;
    }

    public void pushClipPath(String id) {
        this.groupings.push(this.curElement);
        Element newCP = this.doc.createElementNS(this.svgNS, "clipPath");
        newCP.setAttribute("id", id);
        this.curElement.appendChild(newCP);
        this.curElement = newCP;
    }

    public void setClipPath(String id) {
        this.curElement.setAttribute("clip-path", "url(#" + id + ")");
    }

    public void popGradient() {
        this.popGrouping();
    }

    public String pushGradient() {
        String id = "grad" + ++gradNum;
        this.pushGradient(id);
        return id;
    }

    public void pushGradient(String id) {
        this.groupings.push(this.curElement);
        Element newLG = this.doc.createElementNS(this.svgNS, "linearGradient");
        newLG.setAttribute("id", id);
        this.curElement.appendChild(newLG);
        this.curElement = newLG;
    }

    public Element setStop(double post, String style) {
        Element stop = this.doc.createElementNS(this.svgNS, "stop");
        stop.setAttributeNS(null, "offset", this.round(post));
        if (style != null) {
            stop.setAttributeNS(null, "style", style);
        }
        this.curElement.appendChild(stop);
        return stop;
    }

    public void pushPattern(String id, double width, double height) {
        this.groupings.push(this.curElement);
        Element newPattern = this.doc.createElementNS(this.svgNS, "pattern");
        newPattern.setAttributeNS(null, "id", id);
        newPattern.setAttributeNS(null, "x", "0");
        newPattern.setAttributeNS(null, "y", "0");
        newPattern.setAttributeNS(null, "width", this.round(width));
        newPattern.setAttributeNS(null, "height", this.round(height));
        newPattern.setAttributeNS(null, "patternUnits", "userSpaceOnUse");
        this.patternRoot.appendChild(newPattern);
        this.curElement = newPattern;
        this.setAllowNegatives(true);
    }

    public void addPattern(Element pattern) {
        Element patternCopy = this.addElementCopy(pattern);
        this.patternRoot.appendChild(patternCopy);
    }

    public void popPattern() {
        this.curElement = (Element)this.groupings.pop();
        if (this.curElement.getNodeName().compareToIgnoreCase("pattern") != 0) {
            this.setAllowNegatives(false);
        }
    }

    public void popClipPath() {
        this.popGrouping();
    }

    public FontMetrics getFontMetrics(TSCFont f) {
        return this.g.getFontMetrics(f.getFont());
    }

    public Rectangle2D getStringBounds(TSCFont f, String s) {
        return this.getFontMetrics(f).getStringBounds(s, this.g);
    }

    public Rectangle2D getStringBounds(StringWrappingInfo swi) {
        Rectangle2D.Double size = new Rectangle2D.Double();
        size.width = swi.getWidth();
        size.height = swi.getHeight();
        return size;
    }

    protected String round(double d) {
        if (d == 0.0) {
            return "0";
        }
        if (!this.allowNegatives && d < 0.0) {
            return "0";
        }
        String s = Double.toString(d += 5.0E-6);
        int end = Math.min(s.length(), s.indexOf(46) + 6);
        if (end < s.length()) {
            s = s.substring(0, end);
        }
        return s;
    }

    public Element createCrossPlotGroup(double minAge, double maxAge, double minDepth, double maxDepth) {
        Element group = this.doc.createElementNS(this.svgNS, "g");
        group.setAttributeNS(null, "id", "CrossPlot");
        group.setAttributeNS(null, "CdtType", "0");
        group.setAttributeNS(null, "minAge", this.round(minAge));
        group.setAttributeNS(null, "maxAge", this.round(maxAge));
        group.setAttributeNS(null, "minDepth", this.round(minDepth));
        group.setAttributeNS(null, "maxDepth", this.round(maxDepth));
        this.curElement.appendChild(group);
        this.createCrossplotLimitingBox();
        this.createCPLinesGroup();
        this.createCPTimeLabelsGroup();
        this.createCPTimeLinesGroup();
        this.createFADGroup();
        this.createLADGroup();
        this.createCPMarkersGroup();
        this.createCPPointsGroup();
        this.createCrossplotPopupGroup();
        return group;
    }

    public Element createCPPointsGroup() {
        Element group = this.doc.createElementNS(this.svgNS, "g");
        group.setAttributeNS(null, "id", "CrossPlotModels");
        Element cpGroup = this.doc.getElementById("CrossPlot");
        group.setAttributeNS(null, "fill-color", model_color);
        group.setAttributeNS(null, "style", CP_MODEL_STYLE);
        group.setAttributeNS(null, "visibility", "visible");
        group.setAttributeNS(null, "type", "0");
        cpGroup.appendChild(group);
        return group;
    }

    public Element createCPMarkersGroup() {
        Element group = this.doc.createElementNS(this.svgNS, "g");
        group.setAttributeNS(null, "id", "CrossPlotMarkers");
        Element cpGroup = this.doc.getElementById("CrossPlot");
        group.setAttributeNS(null, "style", CP_MARKER_STYLE);
        group.setAttributeNS(null, "fill-color", marker_color);
        group.setAttributeNS(null, "visibility", "visible");
        group.setAttributeNS(null, "type", "0");
        cpGroup.appendChild(group);
        return group;
    }

    public Element createFADGroup() {
        Element group = this.doc.createElementNS(this.svgNS, "g");
        group.setAttributeNS(null, "id", "CrossPlotFADLines");
        group.setAttributeNS(null, "stroke", "black");
        group.setAttributeNS(null, "visibility", "visible");
        Element cpGroup = this.doc.getElementById("CrossPlot");
        cpGroup.appendChild(group);
        return group;
    }

    public Element createLADGroup() {
        Element group = this.doc.createElementNS(this.svgNS, "g");
        group.setAttributeNS(null, "id", "CrossPlotLADLines");
        group.setAttributeNS(null, "stroke", "black");
        group.setAttributeNS(null, "visibility", "visible");
        Element cpGroup = this.doc.getElementById("CrossPlot");
        cpGroup.appendChild(group);
        return group;
    }

    public Element createCPLinesGroup() {
        Element group = this.doc.createElementNS(this.svgNS, "g");
        group.setAttributeNS(null, "id", "CrossPlotLines");
        group.setAttributeNS(null, "stroke", line_color);
        group.setAttributeNS(null, "visibility", "visible");
        Element cpGroup = this.doc.getElementById("CrossPlot");
        cpGroup.appendChild(group);
        return group;
    }

    public Element createCPTimeLinesGroup() {
        Element group = this.doc.createElementNS(this.svgNS, "g");
        group.setAttributeNS(null, "id", "CrossPlotTimeLines");
        Element cpGroup = this.doc.getElementById("CrossPlot");
        group.setAttributeNS(null, "style", TIMELINE_STYLE);
        group.setAttributeNS(null, "stroke-width", "1");
        group.setAttributeNS(null, "visibility", "visible");
        cpGroup.appendChild(group);
        return group;
    }

    public Element createCPTimeLabelsGroup() {
        Element group = this.doc.createElementNS(this.svgNS, "g");
        group.setAttributeNS(null, "id", "CrossPlotTimeLabels");
        Element cpGroup = this.doc.getElementById("CrossPlot");
        group.setAttributeNS(null, "style", TIMELINE_LABEL_STYLE);
        group.setAttributeNS(null, "font-size", Integer.toString(20));
        group.setAttributeNS(null, "visibility", "visible");
        cpGroup.appendChild(group);
        return group;
    }

    public Element createCrossplotLimitingBox() {
        Element cpGroup = this.doc.getElementById("CrossPlot");
        Element box = this.doc.createElementNS(this.svgNS, "rect");
        box.setAttributeNS(null, "id", "CrossplotLimitingBox");
        box.setAttributeNS(null, "fill", "none");
        box.setAttributeNS(null, "stroke", "red");
        box.setAttributeNS(null, "stroke-width", "2");
        box.setAttributeNS(null, "x", "0");
        box.setAttributeNS(null, "y", "0");
        box.setAttributeNS(null, "width", "0");
        box.setAttributeNS(null, "height", "0");
        box.setAttributeNS(null, "visibility", "visible");
        cpGroup.appendChild(box);
        return box;
    }

    public Element createCrossplotPopupGroup() {
        Element group = this.doc.createElementNS(this.svgNS, "g");
        Element cpGroup = this.doc.getElementById("CrossPlot");
        group.setAttributeNS(null, "id", "CrossplotPopup");
        group.setAttributeNS(null, "visibility", "hidden");
        group.setAttributeNS(null, "showPopup", "false");
        Element box = this.doc.createElementNS(this.svgNS, "rect");
        box.setAttributeNS(null, "id", "CrossplotPopupBox");
        box.setAttributeNS(null, "style", CP_PLOT_POPUP_BOX_STYLE);
        box.setAttributeNS(null, "x", "0");
        box.setAttributeNS(null, "y", "0");
        box.setAttributeNS(null, "rx", "3");
        box.setAttributeNS(null, "ry", "3");
        box.setAttributeNS(null, "width", "0");
        box.setAttributeNS(null, "height", "0");
        group.appendChild(box);
        Element text = this.doc.createElementNS(this.svgNS, "text");
        text.setAttributeNS(null, "id", "CrossplotPopupText");
        text.setAttributeNS(null, "id", "CrossplotPopupText");
        text.setAttributeNS(null, "style", CP_PLOT_POPUP_TEXT_STYLE);
        text.setAttributeNS(null, "font-size", Integer.toString(20));
        text.setAttributeNS(null, "x", Integer.toString(20));
        text.setAttributeNS(null, "y", Integer.toString(30));
        Element title = this.doc.createElementNS(this.svgNS, "tspan");
        title.setAttributeNS(null, "id", "PopupTextTitle");
        title.appendChild(this.doc.createTextNode(""));
        title.setAttributeNS(null, "font-weight", "bold");
        title.setAttributeNS(null, "x", Integer.toString(20));
        text.appendChild(title);
        Element note = this.doc.createElementNS(this.svgNS, "tspan");
        note.setAttributeNS(null, "id", "PopupTextNote");
        note.appendChild(this.doc.createTextNode(""));
        note.setAttributeNS(null, "x", Integer.toString(20));
        note.setAttributeNS(null, "dy", Double.toString(30.0));
        text.appendChild(note);
        group.appendChild(text);
        cpGroup.appendChild(group);
        return group;
    }

    public Element drawTimeLine(double x1, double y1, double x2, double y2, double minY, double maxY, double topAge, double baseAge, double vertScale, String style) {
        Element line = this.doc.createElementNS(this.svgNS, "line");
        line.setAttributeNS(null, "id", "timeline");
        line.setAttributeNS(null, "x1", this.round(x1));
        line.setAttributeNS(null, "y1", this.round(y1));
        line.setAttributeNS(null, "x2", this.round(x2));
        line.setAttributeNS(null, "y2", this.round(y2));
        line.setAttributeNS(null, "minY", this.round(minY));
        line.setAttributeNS(null, "maxY", this.round(maxY));
        line.setAttributeNS(null, "topAge", this.round(topAge));
        line.setAttributeNS(null, "baseAge", this.round(baseAge));
        line.setAttributeNS(null, "vertScale", this.round(vertScale));
        Element line_up = this.doc.createElementNS(this.svgNS, "line");
        line_up.setAttributeNS(null, "id", "timeline_up");
        line_up.setAttributeNS(null, "x1", this.round(x1));
        line_up.setAttributeNS(null, "y1", this.round(y1));
        line_up.setAttributeNS(null, "x2", this.round(x2));
        line_up.setAttributeNS(null, "y2", this.round(y2));
        line_up.setAttributeNS(null, "minY", this.round(minY));
        line_up.setAttributeNS(null, "maxY", this.round(maxY));
        line_up.setAttributeNS(null, "topAge", this.round(topAge));
        line_up.setAttributeNS(null, "baseAge", this.round(baseAge));
        line_up.setAttributeNS(null, "vertScale", this.round(vertScale));
        Element line_down = this.doc.createElementNS(this.svgNS, "line");
        line_down.setAttributeNS(null, "id", "timeline_down");
        line_down.setAttributeNS(null, "x1", this.round(x1));
        line_down.setAttributeNS(null, "y1", this.round(y1));
        line_down.setAttributeNS(null, "x2", this.round(x2));
        line_down.setAttributeNS(null, "y2", this.round(y2));
        line_down.setAttributeNS(null, "minY", this.round(minY));
        line_down.setAttributeNS(null, "maxY", this.round(maxY));
        line_down.setAttributeNS(null, "topAge", this.round(topAge));
        line_down.setAttributeNS(null, "baseAge", this.round(baseAge));
        line_down.setAttributeNS(null, "vertScale", this.round(vertScale));
        if (style != null) {
            line.setAttributeNS(null, "style", style);
        }
        this.curElement.appendChild(line);
        this.curElement.appendChild(line_up);
        this.curElement.appendChild(line_down);
        return line;
    }

    public void removeTimeline() {
        this.timeline = this.doc.getElementById("timeline");
        this.timelabel = this.doc.getElementById("TimeLineLabel");
        this.curElement.removeChild(this.timelabel);
        this.curElement.removeChild(this.timeline);
    }

    public void addTimeline() {
        this.curElement.appendChild(this.timelabel);
        this.curElement.appendChild(this.timeline);
    }

    public Element drawTimeLabel() {
        Element label = this.doc.createElementNS(this.svgNS, "text");
        Text t = this.doc.createTextNode("0");
        label.setAttributeNS(null, "id", "TimeLineLabel");
        label.setAttributeNS(null, "x", "0");
        label.setAttributeNS(null, "y", "0");
        label.setAttributeNS(null, "style", "fill-opacity: 0;");
        label.appendChild(t);
        this.curElement.appendChild(label);
        Element labelup = this.doc.createElementNS(this.svgNS, "text");
        Text tup = this.doc.createTextNode("0");
        labelup.setAttributeNS(null, "id", "TimeLineLabelUp");
        labelup.setAttributeNS(null, "x", "0");
        labelup.setAttributeNS(null, "y", "0");
        labelup.setAttributeNS(null, "style", "fill-opacity: 0;");
        labelup.appendChild(tup);
        this.curElement.appendChild(labelup);
        Element labeldown = this.doc.createElementNS(this.svgNS, "text");
        Text tdown = this.doc.createTextNode("0");
        labeldown.setAttributeNS(null, "id", "TimeLineLabelDown");
        labeldown.setAttributeNS(null, "x", "0");
        labeldown.setAttributeNS(null, "y", "0");
        labeldown.setAttributeNS(null, "style", "fill-opacity: 0;");
        labeldown.appendChild(tdown);
        this.curElement.appendChild(labeldown);
        return label;
    }

    public Element drawTimeLineX(double x1, double y1, double x2, double y2, double minX, double maxX, double topAge, double baseAge, double vertScale, String style) {
        Element line = this.doc.createElementNS(this.svgNS, "line");
        line.setAttributeNS(null, "id", "timelineX");
        line.setAttributeNS(null, "x1", this.round(x1));
        line.setAttributeNS(null, "y1", this.round(y1));
        line.setAttributeNS(null, "x2", this.round(x2));
        line.setAttributeNS(null, "y2", this.round(y2));
        line.setAttributeNS(null, "minX", this.round(minX));
        line.setAttributeNS(null, "maxX", this.round(maxX));
        line.setAttributeNS(null, "topAge", this.round(topAge));
        line.setAttributeNS(null, "baseAge", this.round(baseAge));
        line.setAttributeNS(null, "topLimit", this.round(topAge));
        line.setAttributeNS(null, "baseLimit", this.round(baseAge));
        line.setAttributeNS(null, "vertScale", this.round(vertScale));
        Element cpGroup = this.doc.getElementById("CrossPlotTimeLines");
        cpGroup.appendChild(line);
        return line;
    }

    public Element drawTimeLabelX() {
        Element label = this.doc.createElementNS(this.svgNS, "text");
        Text t = this.doc.createTextNode("0");
        label.setAttributeNS(null, "id", "TimeLineLabelX");
        label.setAttributeNS(null, "x", "0");
        label.setAttributeNS(null, "y", "0");
        label.appendChild(t);
        Element cpGroup = this.doc.getElementById("CrossPlotTimeLabels");
        cpGroup.appendChild(label);
        return label;
    }

    public Element drawTimeLineY(double x1, double y1, double x2, double y2, double minY, double maxY, double topAge, double baseAge, double vertScale, String style) {
        Element line = this.doc.createElementNS(this.svgNS, "line");
        line.setAttributeNS(null, "id", "timelineY");
        line.setAttributeNS(null, "x1", this.round(x1));
        line.setAttributeNS(null, "y1", this.round(y1));
        line.setAttributeNS(null, "x2", this.round(x2));
        line.setAttributeNS(null, "y2", this.round(y2));
        line.setAttributeNS(null, "minY", this.round(minY));
        line.setAttributeNS(null, "maxY", this.round(maxY));
        line.setAttributeNS(null, "topAge", this.round(topAge));
        line.setAttributeNS(null, "baseAge", this.round(baseAge));
        line.setAttributeNS(null, "topLimit", this.round(topAge));
        line.setAttributeNS(null, "baseLimit", this.round(baseAge));
        line.setAttributeNS(null, "vertScale", this.round(vertScale));
        Element cpGroup = this.doc.getElementById("CrossPlotTimeLines");
        cpGroup.appendChild(line);
        return line;
    }

    public Element drawTimeLabelY() {
        Element label = this.doc.createElementNS(this.svgNS, "text");
        Text t = this.doc.createTextNode("0");
        label.setAttributeNS(null, "id", "TimeLineLabelY");
        label.setAttributeNS(null, "x", "0");
        label.setAttributeNS(null, "y", "0");
        label.appendChild(t);
        Element cpGroup = this.doc.getElementById("CrossPlotTimeLabels");
        cpGroup.appendChild(label);
        return label;
    }

    public Element drawLine(double x1, double y1, double x2, double y2, String style) {
        Element line = this.doc.createElementNS(this.svgNS, "line");
        line.setAttributeNS(null, "x1", this.round(x1));
        line.setAttributeNS(null, "y1", this.round(y1));
        line.setAttributeNS(null, "x2", this.round(x2));
        line.setAttributeNS(null, "y2", this.round(y2));
        if (style != null) {
            line.setAttributeNS(null, "style", style);
        }
        this.curElement.appendChild(line);
        return line;
    }

    public Element drawLineYear(double x1, double y1, double x2, double y2, String style, double baseY) {
        return this.drawLine(x1, (y1 - this.settings.topAge) * this.settings.unitsPerMY + baseY, x2, (y2 - this.settings.topAge) * this.settings.unitsPerMY + baseY, style);
    }

    public Element drawImage(double x, double y, double width, double height, URL url, String preserveAspectRatio) {
        return this.drawImage(x, y, width, height, url.toString(), preserveAspectRatio);
    }

    public Element drawImage(double x, double y, double width, double height, String imagePath, String preserveAspectRatio) {
        Element image = this.doc.createElementNS(this.svgNS, "image");
        image.setAttributeNS(null, "x", this.round(x));
        image.setAttributeNS(null, "y", this.round(y));
        image.setAttributeNS(null, "width", this.round(width));
        image.setAttributeNS(null, "height", this.round(height));
        if (imagePath == null || imagePath.equals("")) {
            Debug.print("Image path is empty!");
            return null;
        }
        Debug.print("drawing image: " + imagePath);
        String filename = imagePath.toString();
        String extension = FileUtils.getExtension(filename);
        String mime = null;
        image.setAttributeNS(null, "id", FileUtils.getName(filename));
        if (extension == null) {
            return null;
        }
        if (extension.compareToIgnoreCase("png") == 0) {
            mime = "image/png";
        } else if (extension.compareToIgnoreCase("jpg") == 0 || extension.compareToIgnoreCase("jpeg") == 0 || extension.compareToIgnoreCase("jpe") == 0) {
            mime = "image/jpeg";
        } else if (extension.compareToIgnoreCase("svg") == 0) {
            mime = "image/svg+xml";
        }
        if (mime == null) {
            Debug.print("Unable to determine mime type for image " + imagePath);
            return null;
        }
        try {
            image.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", "data:" + mime + ";base64," + Base64.encodeFromFile(filename));
            this.curElement.appendChild(image);
            return image;
        }
        catch (Exception e) {
            Debug.print("Unable to set attribute on image or append child on image " + imagePath);
            return null;
        }
    }

    public Element drawRect(double x, double y, double width, double height, String style) {
        Element rect = this.doc.createElementNS(this.svgNS, "rect");
        rect.setAttributeNS(null, "x", this.round(x));
        rect.setAttributeNS(null, "y", this.round(y));
        rect.setAttributeNS(null, "width", this.round(width));
        rect.setAttributeNS(null, "height", this.round(height));
        if (style != null) {
            rect.setAttributeNS(null, "style", style);
        }
        this.curElement.appendChild(rect);
        return rect;
    }

    public Element drawCircleYear(double x1, double y1, double baseY, double radius, String style, RangeColumn.RangePoint point, boolean childOff) {
        Element circ = this.doc.createElementNS(this.svgNS, "circle");
        circ.setAttributeNS(null, "cx", this.round(x1));
        circ.setAttributeNS(null, "cy", this.round((y1 - this.settings.topAge) * this.settings.unitsPerMY + baseY));
        circ.setAttributeNS(null, "r", this.round(radius));
        if (style != null) {
            circ.setAttributeNS(null, "style", style);
        }
        if (childOff) {
            Element animate = this.doc.createElementNS(this.svgNS, "animate");
            animate.setAttributeNS(null, "attributeType", "CSS");
            animate.setAttributeNS(null, "attributeName", "fill");
            animate.setAttributeNS(null, "values", "white; red; black; yellow");
            animate.setAttributeNS(null, "dur", "1s");
            animate.setAttributeNS(null, "repeatCount", "indefinite");
            circ.appendChild(animate);
        }
        EventTarget targ = (EventTarget)((Object)circ);
        targ.addEventListener("click", new ClickListener(), false);
        if (this.branchNodeList == null) {
            this.branchNodeList = new HashMap();
        }
        this.branchNodeList.put(targ, point);
        this.curElement.appendChild(circ);
        return circ;
    }

    public Element drawCrossYear(double x1, double y1, double baseY, double radius, String style, RangeColumn.RangePoint point, boolean childOff) {
        double cx = x1;
        double cy = (y1 - this.settings.topAge) * this.settings.unitsPerMY + baseY;
        double angle = 0.7853981633974483;
        double p_1_x_1 = cx + radius * Math.cos(angle);
        double p_1_y_1 = cy + radius * Math.sin(angle);
        double p_2_x_1 = cx - radius * Math.cos(angle);
        double p_2_y_1 = cy - radius * Math.sin(angle);
        Element line1 = this.drawLine(p_1_x_1, p_1_y_1, p_2_x_1, p_2_y_1, style);
        double p_3_x_1 = cx + radius * Math.cos(angle);
        double p_3_y_1 = cy - radius * Math.sin(angle);
        double p_4_x_1 = cx - radius * Math.cos(angle);
        double p_4_y_1 = cy + radius * Math.sin(angle);
        Element line2 = this.drawLine(p_3_x_1, p_3_y_1, p_4_x_1, p_4_y_1, style);
        return null;
    }

    public Element drawCircle(double x, double y, double radius, String style) {
        Element circ = this.doc.createElementNS(this.svgNS, "circle");
        circ.setAttributeNS(null, "cx", this.round(x));
        circ.setAttributeNS(null, "cy", this.round(y));
        circ.setAttributeNS(null, "r", this.round(radius));
        if (style != null) {
            circ.setAttributeNS(null, "style", style);
        }
        this.curElement.appendChild(circ);
        return circ;
    }

    public Element drawRectYear(double x, double y, double width, double height, String style, double baseY) {
        return this.drawRect(x, (y - this.settings.topAge) * this.settings.unitsPerMY + baseY, width, height * this.settings.unitsPerMY, style);
    }

    public Element drawPolygon(double[] x, double[] y, String style, String popup, DataColumn.FileInfo colFileInfo) {
        Element e = this.drawPolygon(x, y, style);
        if (popup != null) {
            this.doPopupThings(e, popup, colFileInfo);
        }
        return e;
    }

    public Element drawArrowWithPolygon(double[] x, double[] y, String style, double baseY) {
        for (int i = 0; i < y.length; ++i) {
            y[i] = (y[i] - this.settings.topAge) * this.settings.unitsPerMY + baseY;
        }
        Element e = this.drawPolygon(x, y, style);
        return e;
    }

    public Element drawPolygon(double[] x, double[] y, String style) {
        int numPoints = Math.min(x.length, y.length);
        if (numPoints == 2) {
            return this.drawLine(x[0], y[0], x[1], y[1], style);
        }
        if (numPoints < 2) {
            return null;
        }
        Element line = this.doc.createElementNS(this.svgNS, "polygon");
        String points = "";
        for (int i = 0; i < numPoints; ++i) {
            points = points + this.round(x[i]) + "," + this.round(y[i]) + " ";
        }
        line.setAttributeNS(null, "points", points);
        if (style != null) {
            line.setAttributeNS(null, "style", style);
        }
        this.curElement.appendChild(line);
        return line;
    }

    public Element drawPolyline(double[] x, double[] y, String style) {
        int numPoints = Math.min(x.length, y.length);
        if (numPoints == 2) {
            return this.drawLine(x[0], y[0], x[1], y[1], style);
        }
        if (numPoints < 2) {
            return null;
        }
        Element line = this.doc.createElementNS(this.svgNS, "polyline");
        String points = "";
        for (int i = 0; i < numPoints; ++i) {
            points = points + this.round(x[i]) + "," + this.round(y[i]) + " ";
        }
        line.setAttributeNS(null, "points", points);
        if (style != null) {
            line.setAttributeNS(null, "style", style);
        }
        this.curElement.appendChild(line);
        return line;
    }

    public Element drawSmoothVerticalPolyline(double[] x, double[] y, boolean[] lineTo, String style) {
        int numPoints = Math.min(x.length, y.length);
        if (numPoints == 2) {
            return this.drawLine(x[0], y[0], x[1], y[1], style);
        }
        if (numPoints < 2) {
            return null;
        }
        Element line = this.doc.createElementNS(this.svgNS, "path");
        String points = "M" + this.round(x[0]) + "," + this.round(y[0]);
        for (int i = 1; i < numPoints; ++i) {
            if (lineTo[i]) {
                points = points + " L" + this.round(x[i]) + "," + this.round(y[i]);
                continue;
            }
            double[] c1 = this.getControlPointForVerticalCurves(x, y, lineTo, i - 1, 1);
            double[] c2 = this.getControlPointForVerticalCurves(x, y, lineTo, i, -1);
            points = points + " C" + this.round(c1[0]) + "," + this.round(c1[1]) + " " + this.round(c2[0]) + "," + this.round(c2[1]) + " " + this.round(x[i]) + "," + this.round(y[i]);
        }
        line.setAttributeNS(null, "d", points);
        if (style != null) {
            line.setAttributeNS(null, "style", style);
        }
        this.curElement.appendChild(line);
        return line;
    }

    protected double[] getControlPointForVerticalCurves(double[] x, double[] y, boolean[] lineTo, int i, int dir) {
        double derivative;
        double[] ret = new double[2];
        if (i == 0 || lineTo[i]) {
            Vector2D v = this.getControlPoint(x, y, lineTo, i, dir, false, true);
            ret[1] = v.y;
            ret[0] = v.x;
            return ret;
        }
        if (i >= x.length - 1 || lineTo[i]) {
            Vector2D v = this.getControlPoint(x, y, lineTo, i, dir, false, true);
            ret[1] = v.y;
            ret[0] = v.x;
            return ret;
        }
        double prevx = x[i - 1];
        double prevy = y[i - 1];
        double nextx = x[i + 1];
        double nexty = y[i + 1];
        double prevdiff = prevx - x[i];
        double nextdiff = nextx - x[i];
        if (prevdiff * nextdiff > 0.0) {
            derivative = Double.POSITIVE_INFINITY;
        } else {
            derivative = (nextx - prevx) / (nexty - prevy);
            double derivativeNext = (nextx - x[i]) / (nexty - y[i]);
            double derivativePrev = (x[i] - prevx) / (y[i] - prevy);
            if (derivative < 0.0) {
                derivative = Math.max(derivative, derivativeNext);
            }
            if (derivative > 0.0) {
                derivative = Math.max(derivative, derivativePrev);
            }
        }
        if (dir > 0) {
            if (Double.isInfinite(derivative)) {
                ret[1] = y[i] * 0.6 + y[i + 1] * 0.4;
                ret[0] = x[i];
            } else {
                Vector2D v = this.getControlPoint(x, y, lineTo, i, dir, false, true);
                ret[1] = v.y;
                ret[0] = v.x;
            }
        } else if (Double.isInfinite(derivative)) {
            ret[1] = y[i] * 0.6 + y[i - 1] * 0.4;
            ret[0] = x[i];
        } else {
            Vector2D v = this.getControlPoint(x, y, lineTo, i, dir, false, true);
            ret[1] = v.y;
            ret[0] = v.x;
        }
        return ret;
    }

    public Element drawSmoothPolyline(double[] x, double[] y, boolean[] sharp, String style, boolean closed) {
        int numPoints = Math.min(x.length, y.length);
        if (numPoints == 2) {
            return this.drawLine(x[0], y[0], x[1], y[1], style);
        }
        if (numPoints < 2) {
            return null;
        }
        Element line = this.doc.createElementNS(this.svgNS, "path");
        String points = "M" + this.round(x[0]) + "," + this.round(y[0]);
        for (int i = 1; i < numPoints || closed && i <= numPoints; ++i) {
            Vector2D c1 = this.getControlPoint(x, y, sharp, i - 1, 1, closed, false);
            Vector2D c2 = this.getControlPoint(x, y, sharp, i % numPoints, -1, closed, false);
            points = points + " C" + this.round(c1.x) + "," + this.round(c1.y) + " " + this.round(c2.x) + "," + this.round(c2.y) + " " + this.round(x[i % numPoints]) + "," + this.round(y[i % numPoints]);
        }
        if (closed) {
            points = points + "z";
        }
        line.setAttributeNS(null, "d", points);
        if (style != null) {
            line.setAttributeNS(null, "style", style);
        }
        this.curElement.appendChild(line);
        return line;
    }

    protected Vector2D getControlPoint(double[] x, double[] y, boolean[] sharpA, int i, int dir, boolean closed, boolean forVertical) {
        Vector2D end2;
        Vector2D end1;
        boolean sharp = sharpA[i];
        if (i == 0 && !closed) {
            dir = 1;
            sharp = true;
        }
        if (i == x.length - 1 && !closed) {
            dir = -1;
            sharp = true;
        }
        int previ = (i - 1 + x.length) % x.length;
        int nexti = (i + 1) % x.length;
        Vector2D prev = new Vector2D(x[previ] - x[i], y[previ] - y[i]);
        Vector2D next = new Vector2D(x[nexti] - x[i], y[nexti] - y[i]);
        double prevLength = prev.length();
        double nextLength = next.length();
        if (NumberUtils.isEqual(prevLength, 0.0)) {
            prev = new Vector2D(0.0, 1.0);
            prevLength = 1.0;
        }
        if (NumberUtils.isEqual(nextLength, 0.0)) {
            next = new Vector2D(1.0, 0.0);
            nextLength = 1.0;
        }
        if (sharp) {
            if (dir > 0) {
                next.setLength(Math.min(nextLength * 0.4, 10.0));
                next.add(x[i], y[i]);
                return next;
            }
            prev.setLength(Math.min(prevLength * 0.4, 10.0));
            prev.add(x[i], y[i]);
            return prev;
        }
        prev.normalize();
        next.normalize();
        Vector2D mid = prev.addR(next);
        if (mid.length() > 0.01) {
            mid.normalize();
            mid.perpSlope();
            end1 = mid;
            end2 = new Vector2D(end1);
            end2.mul(-1.0);
        } else {
            Vector2D minus = new Vector2D(next);
            minus.mul(-1.0);
            end1 = minus.addR(prev);
            end2 = new Vector2D(end1);
            end2.mul(-1.0);
        }
        if (prev.dotProduct(end1) > 0.0) {
            end1.setLength(this.getControlPointLength(prev, next, prevLength, nextLength, forVertical));
            end2.setLength(this.getControlPointLength(next, prev, nextLength, prevLength, forVertical));
            end1.add(x[i], y[i]);
            end2.add(x[i], y[i]);
            if (dir > 0) {
                return end2;
            }
            return end1;
        }
        end2.setLength(this.getControlPointLength(prev, next, prevLength, nextLength, forVertical));
        end1.setLength(this.getControlPointLength(next, prev, nextLength, prevLength, forVertical));
        end1.add(x[i], y[i]);
        end2.add(x[i], y[i]);
        if (dir > 0) {
            return end1;
        }
        return end2;
    }

    protected double getControlPointLength(Vector2D thisSeg, Vector2D otherSeg, double thisSegLength, double otherSegLength, boolean forVertical) {
        double thisSegL = Math.max(thisSeg.length(), 1.0E-4);
        double otherSegL = Math.max(otherSeg.length(), 1.0E-4);
        double cos = Math.abs(thisSeg.dotProduct(otherSeg) / (thisSegL * otherSegL));
        if (!forVertical && cos < 0.5) {
            cos = 1.0 - cos;
        }
        double ret = Math.min(Math.max(thisSegLength * 0.4 * cos, 0.001), 10.0);
        return ret;
    }

    public void drawPoints(double[] x, double[] y, int type, boolean[] shouldDraw, Color c) {
        int numPoints = Math.min(x.length, y.length);
        if (numPoints < 1) {
            return;
        }
        if (c == null) {
            c = Color.black;
        }
        this.pushGrouping();
        block4: for (int i = 0; i < numPoints; ++i) {
            if (shouldDraw != null && !shouldDraw[i]) continue;
            switch (type) {
                case 1: {
                    this.drawRect(x[i] - 2.0, y[i] - 2.0, 4.0, 4.0, "stroke-width: 0; fill: " + Coloring.getStyleRGB(c) + ";");
                    continue block4;
                }
                case 2: {
                    this.drawCircle(x[i], y[i], 2.0, "stroke-width: 0; fill: " + Coloring.getStyleRGB(c) + ";");
                    continue block4;
                }
                default: {
                    this.drawLine(x[i] - 2.0, y[i], x[i] + 2.0, y[i], "stroke-width: 1; stroke: " + Coloring.getStyleRGB(c) + "");
                    this.drawLine(x[i], y[i] - 2.0, x[i], y[i] + 2.0, "stroke-width: 1; stroke: " + Coloring.getStyleRGB(c) + "");
                }
            }
        }
        this.popGrouping();
    }

    public static double getYFromYear(double y, double baseY, Settings settings) {
        return (y - settings.topAge) * settings.unitsPerMY + baseY;
    }

    public StringWrappingInfo wrapString(String s, double windowWidth, TSCFont fontToUse, DataColumn.FileInfo fileInfo) {
        StringWrappingInfo swi = new StringWrappingInfo(this.g);
        swi.wrapString(new RichText(s, fileInfo), windowWidth, fontToUse);
        return swi;
    }

    public StringWrappingInfo getSWI(RichText s, TSCFont fontToUse, int orientation) {
        return new StringWrappingInfo(this.g, s, fontToUse, orientation);
    }

    public StringWrappingInfo getSWI(String s, TSCFont fontToUse, int orientation, DataColumn.FileInfo fileInfo) {
        return new StringWrappingInfo(this.g, new RichText(s, fileInfo), fontToUse, orientation);
    }

    public StringWrappingInfo getSWIOneLine(String s, TSCFont fontToUse, int orientation, DataColumn.FileInfo fileInfo) {
        StringWrappingInfo ret = new StringWrappingInfo(this.g, new RichText(s, fileInfo), fontToUse, orientation);
        ret.makeOneLine();
        return ret;
    }

    public Element drawString(StringWrappingInfo swi, double startx, double starty, double width, double height, int verticalPlacement) {
        return this.drawString(swi, startx, starty, width, height, verticalPlacement, starty, 10, null);
    }

    public Element drawString(StringWrappingInfo swi, double startx, double starty, double width, double height, int verticalPlacement, double prefLoc) {
        return this.drawString(swi, startx, starty, width, height, verticalPlacement, prefLoc, 10, null);
    }

    public Element drawStringabsolute(StringWrappingInfo swi, double startx, double starty, double baseY, double width, double height, int verticalPlacement, Color color) {
        starty = (starty - this.settings.topAge) * this.settings.unitsPerMY + baseY;
        return this.drawString(swi, startx, starty, width, height, verticalPlacement, starty, 12, color);
    }

    public Element drawString(StringWrappingInfo swi, double startx, double starty, double width, double height, int verticalPlacement, double prefLoc, int background, Color backgroundColor) {
        String color;
        double drawWidth;
        double verticalTop;
        Element text = null;
        Element textParent = this.curElement;
        double translateX = 0.0;
        double translateY = 0.0;
        double swiHeight = swi.getHeight();
        double swiWidth = swi.getWidth();
        switch (verticalPlacement) {
            case 2: {
                verticalTop = starty + (height - swiHeight) / 2.0;
                break;
            }
            case 3: {
                verticalTop = starty + height - swiHeight;
                break;
            }
            case 8: {
                verticalTop = starty + height - swiHeight;
                break;
            }
            case 1: 
            case 9: {
                verticalTop = starty;
                break;
            }
            case 4: {
                verticalTop = prefLoc - swiHeight / 2.0;
                if (verticalTop < starty) {
                    verticalTop = starty;
                    break;
                }
                if (!(verticalTop + swiHeight > starty + height)) break;
                verticalTop = starty + height - swiHeight;
                break;
            }
            default: {
                return null;
            }
        }
        translateX = startx;
        translateY = verticalTop;
        switch (swi.getRotateDegrees()) {
            case 90: {
                drawWidth = swiHeight;
                translateX += swiWidth + (width - swiWidth) / 2.0;
                translateY -= swiHeight;
                break;
            }
            case 180: {
                drawWidth = width;
                translateX += swiWidth;
                translateY -= swiHeight;
                break;
            }
            case 270: {
                drawWidth = swiHeight;
                translateX += (width - swiWidth) / 2.0;
                translateY += swiHeight;
                break;
            }
            default: {
                drawWidth = width;
            }
        }
        String baseTransform = "";
        baseTransform = swi.getRotateDegrees() != 0 ? "translate(" + this.round(translateX) + ", " + this.round(translateY) + ") rotate(" + swi.getRotateDegrees() + ", " + this.round(0.0) + ", " + this.round(0.0) + ") " : "translate(" + this.round(translateX) + ", " + this.round(translateY) + ") ";
        if (ImageGenerator.includesBackground(background)) {
            // empty if block
        }
        text = this.doc.createElementNS(this.svgNS, "text");
        text.setAttributeNS(null, "x", this.round(0.0));
        text.setAttributeNS(null, "y", this.round(0.0));
        text.setAttributeNS(null, "transform", baseTransform);
        String style = "";
        if (swi.font != null) {
            style = style + swi.font.getSVGStyle();
        }
        style = (color = this.getTextColor(backgroundColor)) == "" ? style + " fill: " + swi.font.getSVGStyle() + ";" : style + " fill: " + color + ";";
        text.setAttributeNS(null, "style", style);
        double y = 0.0;
        for (int i = 0; i < swi.getNumLines(); ++i) {
            double x = verticalPlacement == 9 ? 0.0 : (verticalPlacement == 8 ? drawWidth - swi.widths[i] : (drawWidth - swi.widths[i]) / 2.0);
            if (i != 0) {
                y += swi.descents[i - 1];
            }
            y += swi.lineHeights[i] - swi.descents[i];
            RichText.Line line = swi.s.getLine(i);
            for (int j = 0; j < line.elements.size(); ++j) {
                RichText.Element elem = (RichText.Element)line.elements.get(j);
                if (elem instanceof RichText.ImageTag) {
                    RichText.ImageTag imgTag = (RichText.ImageTag)elem;
                    if (imgTag.toString().contains("humerosa")) {
                        System.out.println();
                    }
                    if (!imgTag.isValid) continue;
                    String preserveAspectRatio = "none";
                    Element curElementSave = this.curElement;
                    this.curElement = textParent;
                    Element imgElement = this.drawImage(x, y - imgTag.aboveText, imgTag.width, imgTag.height, imgTag.source, preserveAspectRatio);
                    if (imgElement != null) {
                        imgElement.setAttributeNS(null, "transform", baseTransform);
                    }
                    this.curElement = curElementSave;
                    x += imgTag.width;
                    continue;
                }
                if (!(elem instanceof RichText.StringElement)) continue;
                Element tspan = this.doc.createElementNS(this.svgNS, "tspan");
                tspan.setAttributeNS(null, "x", this.round(x));
                tspan.setAttributeNS(null, "y", this.round(y));
                Text t = this.doc.createTextNode(elem.visibleString());
                this.pushElement(tspan);
                int numPops = 1;
                for (RichText.BeginTagElement beginTag : ((RichText.StringElement)elem).openTags) {
                    Element tagE = this.doc.createElementNS(this.svgNS, beginTag.tagName);
                    if (beginTag.styleChanges != null) {
                        tagE.setAttribute("style", beginTag.styleChanges);
                    }
                    Iterator attribIter = beginTag.attributes.keySet().iterator();
                    while (attribIter.hasNext()) {
                        String key = attribIter.next().toString();
                        String value = beginTag.attributes.get(key).toString();
                        if (this.linkProc != null && LinkProcessor.shouldProcess(beginTag.tagName, key)) {
                            value = this.linkProc.processLink(value);
                        }
                        tagE.setAttributeNS("http://www.w3.org/1999/xlink", key, value);
                    }
                    this.curElement.appendChild(tagE);
                    this.pushElement(tagE);
                    ++numPops;
                }
                this.curElement.appendChild(t);
                for (int k = 0; k < numPops; ++k) {
                    this.popGrouping();
                }
                text.appendChild(tspan);
                x += elem.width;
            }
        }
        if (ImageGenerator.includesBackground(background) && backgroundColor != null) {
            Element outline = this.addElementCopy(text, true);
            String outlineStyle = "";
            if (swi.font != null) {
                outlineStyle = outlineStyle + swi.font.getSVGStyleNoColor();
            }
            outlineStyle = outlineStyle + " fill: none; stroke: " + Coloring.getColorStyle(backgroundColor) + "; stroke-width: 4; stroke-linecap:butt; stroke-linejoin:round;";
            outline.setAttributeNS(null, "style", outlineStyle);
        }
        this.curElement.appendChild(text);
        return text;
    }

    public Element drawString(StringWrappingInfo swi, double startx, double starty, double width, double height, int verticalPlacement, double prefLoc, int background, Color backgroundColor, boolean resize) {
        String color;
        double drawWidth;
        double verticalTop;
        Element text = null;
        Element textParent = this.curElement;
        double translateX = 0.0;
        double translateY = 0.0;
        double swiHeight = swi.getHeight();
        double swiWidth = swi.getWidth();
        switch (verticalPlacement) {
            case 2: {
                verticalTop = starty + (height - swiHeight) / 2.0;
                break;
            }
            case 3: {
                verticalTop = starty + height - swiHeight;
                break;
            }
            case 8: {
                verticalTop = starty + height - swiHeight;
                break;
            }
            case 1: 
            case 9: {
                verticalTop = starty;
                break;
            }
            case 4: {
                verticalTop = prefLoc - swiHeight / 2.0;
                if (verticalTop < starty) {
                    verticalTop = starty;
                    break;
                }
                if (!(verticalTop + swiHeight > starty + height)) break;
                verticalTop = starty + height - swiHeight;
                break;
            }
            default: {
                return null;
            }
        }
        translateX = startx;
        translateY = verticalTop;
        switch (swi.getRotateDegrees()) {
            case 90: {
                drawWidth = swiHeight;
                translateX += swiWidth + (width - swiWidth) / 2.0;
                translateY -= swiHeight;
                break;
            }
            case 180: {
                drawWidth = width;
                translateX += swiWidth;
                translateY -= swiHeight;
                break;
            }
            case 270: {
                drawWidth = swiHeight;
                translateX += (width - swiWidth) / 2.0;
                translateY += swiHeight;
                break;
            }
            default: {
                drawWidth = width;
            }
        }
        String baseTransform = "";
        baseTransform = swi.getRotateDegrees() != 0 ? "translate(" + this.round(translateX) + ", " + this.round(translateY) + ") rotate(" + swi.getRotateDegrees() + ", " + this.round(0.0) + ", " + this.round(0.0) + ") " : "translate(" + this.round(translateX) + ", " + this.round(translateY) + ") ";
        if (ImageGenerator.includesBackground(background)) {
            // empty if block
        }
        text = this.doc.createElementNS(this.svgNS, "text");
        text.setAttributeNS(null, "x", this.round(0.0));
        text.setAttributeNS(null, "y", this.round(0.0));
        text.setAttributeNS(null, "transform", baseTransform);
        String style = "";
        if (swi.font != null) {
            style = style + swi.font.getSVGStyle();
        }
        style = (color = this.getTextColor(backgroundColor)) == "" ? style + " fill: " + swi.font.getSVGStyle() + ";" : style + " fill: " + color + ";";
        text.setAttributeNS(null, "style", style);
        double y = 0.0;
        for (int i = 0; i < swi.getNumLines(); ++i) {
            double x = verticalPlacement == 9 ? 0.0 : (verticalPlacement == 8 ? drawWidth - swi.widths[i] : (drawWidth - swi.widths[i]) / 2.0);
            if (i != 0) {
                y += swi.descents[i - 1];
            }
            y += swi.lineHeights[i] - swi.descents[i];
            RichText.Line line = swi.s.getLine(i);
            for (int j = 0; j < line.elements.size(); ++j) {
                RichText.Element elem = (RichText.Element)line.elements.get(j);
                if (elem instanceof RichText.ImageTag) {
                    RichText.ImageTag imgTag = (RichText.ImageTag)elem;
                    if (imgTag.toString().contains("humerosa")) {
                        System.out.println();
                    }
                    if (!imgTag.isValid) continue;
                    String preserveAspectRatio = "none";
                    Element curElementSave = this.curElement;
                    this.curElement = textParent;
                    Element imgElement = this.drawImage(x - imgTag.width / 128.0, y - imgTag.aboveText - imgTag.height / 128.0, imgTag.width / 2.0, imgTag.height, imgTag.source, preserveAspectRatio);
                    if (imgElement != null) {
                        imgElement.setAttributeNS(null, "transform", baseTransform);
                    }
                    this.curElement = curElementSave;
                    x += imgTag.width;
                    continue;
                }
                if (!(elem instanceof RichText.StringElement)) continue;
                Element tspan = this.doc.createElementNS(this.svgNS, "tspan");
                tspan.setAttributeNS(null, "x", this.round(x));
                tspan.setAttributeNS(null, "y", this.round(y));
                Text t = this.doc.createTextNode(elem.visibleString());
                this.pushElement(tspan);
                int numPops = 1;
                for (RichText.BeginTagElement beginTag : ((RichText.StringElement)elem).openTags) {
                    Element tagE = this.doc.createElementNS(this.svgNS, beginTag.tagName);
                    if (beginTag.styleChanges != null) {
                        tagE.setAttribute("style", beginTag.styleChanges);
                    }
                    Iterator attribIter = beginTag.attributes.keySet().iterator();
                    while (attribIter.hasNext()) {
                        String key = attribIter.next().toString();
                        String value = beginTag.attributes.get(key).toString();
                        if (this.linkProc != null && LinkProcessor.shouldProcess(beginTag.tagName, key)) {
                            value = this.linkProc.processLink(value);
                        }
                        tagE.setAttributeNS("http://www.w3.org/1999/xlink", key, value);
                    }
                    this.curElement.appendChild(tagE);
                    this.pushElement(tagE);
                    ++numPops;
                }
                this.curElement.appendChild(t);
                for (int k = 0; k < numPops; ++k) {
                    this.popGrouping();
                }
                text.appendChild(tspan);
                x += elem.width;
            }
        }
        if (ImageGenerator.includesBackground(background) && backgroundColor != null) {
            Element outline = this.addElementCopy(text, true);
            String outlineStyle = "";
            if (swi.font != null) {
                outlineStyle = outlineStyle + swi.font.getSVGStyleNoColor();
            }
            outlineStyle = outlineStyle + " fill: none; stroke: " + Coloring.getColorStyle(backgroundColor) + "; stroke-width: 4; stroke-linecap:butt; stroke-linejoin:round;";
            outline.setAttributeNS(null, "style", outlineStyle);
        }
        this.curElement.appendChild(text);
        return text;
    }

    public Element drawString(String s, double x, double y, String style) {
        Element text = this.doc.createElementNS(this.svgNS, "text");
        text.setAttributeNS(null, "x", this.round(x));
        text.setAttributeNS(null, "y", this.round(y));
        if (style != null) {
            text.setAttributeNS(null, "style", style);
        }
        Text t = this.doc.createTextNode(s);
        text.appendChild(t);
        this.curElement.appendChild(text);
        return text;
    }

    public static String replace(String s, String pat, String rep) {
        StringBuilder result = new StringBuilder();
        int start = 0;
        int end = 0;
        while ((end = s.indexOf(pat, start)) >= 0) {
            result.append(s.substring(start, end));
            result.append(rep);
            start = end + pat.length();
        }
        result.append(s.substring(start));
        return result.toString();
    }

    public Element drawStringYear(String s, double x, double y, String style, double baseY) {
        return this.drawString(s, x, (y - this.settings.topAge) * this.settings.unitsPerMY + baseY, style);
    }

    public Element drawStringYearPlusOffsetNoClip(String s, double x, double year, double offset, String style, double baseY) {
        double y = (year - this.settings.topAge) * this.settings.unitsPerMY + baseY + offset;
        if (y < baseY + offset) {
            y = baseY + offset;
        }
        return this.drawString(s, x, y, style);
    }

    public String getTextColor(Color c) {
        if (c == null) {
            return "";
        }
        double grey = (double)c.getRed() * 0.3 + (double)c.getGreen() * 0.59 + (double)c.getBlue() * 0.11;
        if (grey > 120.0) {
            return "";
        }
        return "white";
    }

    public String getTextColor(String backgroundStyle) {
        if (backgroundStyle == null) {
            return "black";
        }
        Pattern pat = Pattern.compile("(color|fill):\\s*[^\\;]*\\;");
        Matcher matcher = pat.matcher(backgroundStyle);
        if (!matcher.find()) {
            return "black";
        }
        String match = matcher.group();
        String color = match.replaceFirst("color:", "").replaceFirst("fill:", "").replaceAll(";", "").trim();
        Color c = Coloring.getColorFromStyle(color);
        return this.getTextColor(c);
    }

    public void addDeclaration(String d) {
    }

    public void addElement(Element e) {
        this.curElement.appendChild(e);
    }

    public Element addElementCopy(Element orig) {
        return this.addElementCopy(orig, false);
    }

    public Element addElementCopy(Element orig, boolean copyText) {
        Node n;
        Element e = this.doc.createElementNS(this.svgNS, orig.getTagName());
        NamedNodeMap nnm = orig.getAttributes();
        for (int i = 0; i < nnm.getLength(); ++i) {
            Node n2 = nnm.item(i);
            if (n2.getNodeType() != 2) continue;
            String name = n2.getNodeName();
            String value = n2.getNodeValue();
            e.setAttribute(name, value);
        }
        if (copyText) {
            NodeList nl = orig.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                n = nl.item(i);
                if (n.getNodeType() != 3) continue;
                String text = n.getNodeValue();
                Text textnode = this.doc.createTextNode(text);
                e.appendChild(textnode);
            }
        }
        NodeList nl = orig.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            Element backup = this.curElement;
            this.curElement = e;
            this.addElementCopy((Element)n, copyText);
            this.curElement = backup;
        }
        this.curElement.appendChild(e);
        return e;
    }

    public SVGDocument drawImage() throws NoColumnsToDrawException, Exception {
        double borderWidth = Settings.BORDER_WIDTH;
        double halfBorderWidth = borderWidth / 2.0;
        double timeLineMinY = 0.0;
        double timeLineMaxY = 0.0;
        double canvasWidth = 0.0;
        double canvasHeight = 0.0;
        String nameOfFirstRoot = null;
        boolean noRootsSelected = true;
        Set patternUsageHolder = null;
        if (this.patMan != null) {
            patternUsageHolder = this.patMan.getPatternUsageHolder();
        }
        Settings settingsBackup = this.settings;
        RangeColumn.clearErrMsgFT();
        Iterator<DataColumn> subRootIter = this.rootCol.getSubColumns();
        while (subRootIter.hasNext()) {
            Settings subSettings;
            DataColumn dc = subRootIter.next();
            if (!(dc instanceof MetaColumn)) continue;
            MetaColumn subRoot = (MetaColumn)dc;
            if (!subRoot.isSelected()) {
                if (nameOfFirstRoot != null) continue;
                nameOfFirstRoot = subRoot.getName();
                continue;
            }
            noRootsSelected = false;
            this.settings = subSettings = settingsBackup.getReadOnlySettings(subRoot.unit);
            double dataHeight = Math.abs(subSettings.topAge - subSettings.baseAge) * subSettings.unitsPerMY;
            double xOffset = canvasWidth;
            double colWidth = subRoot.getWidth(subSettings, this, dataHeight);
            if (!RangeColumn.consolidatedPlottingErrs.equals("")) {
                String tempStore = RangeColumn.consolidatedPlottingErrs;
                RangeColumn.consolidatedPlottingErrs = "";
                throw new Exception(tempStore);
            }
            double colHeaderHeight = subRoot.getHeaderHeight(subSettings, this);
            if (dataHeight == 0.0) continue;
            subRoot.setVariableColoring(subSettings);
            subRoot.drawData(this, xOffset + borderWidth, borderWidth + colHeaderHeight + borderWidth, colWidth, dataHeight, subSettings);
            colWidth = subRoot.getWidth(subSettings, this, dataHeight);
            subRoot.drawHeader(this, xOffset + borderWidth, borderWidth, colWidth, colHeaderHeight, subSettings);
            if (RangeColumn.exceptionHandling) {
                RangeColumn.exceptionHandling = false;
                throw new Exception("Error in datapack: There are many reasons which can trigger this exception.\n 1. A range can have child nodes declared but the range points (start/end points) are absent.\n This message is for FamilyTree plotting.\n Sorry I couldn't pin-point the range which causes this exception.");
            }
            subRoot.drawFooter(this, xOffset + halfBorderWidth, colHeaderHeight + dataHeight + 2.0 * borderWidth, colWidth + borderWidth, subSettings);
            this.drawRect(xOffset + halfBorderWidth, halfBorderWidth, borderWidth + colWidth + halfBorderWidth - 1.0, borderWidth + colHeaderHeight + borderWidth + dataHeight + halfBorderWidth - 1.0, BORDER_STYLE);
            this.drawLine(xOffset, borderWidth + colHeaderHeight + halfBorderWidth, xOffset + borderWidth + colWidth + borderWidth, borderWidth + colHeaderHeight + halfBorderWidth, BORDER_STYLE);
            double subWidth = colWidth + 2.0 * borderWidth + 1.0;
            this.extraColumnWidth = this.extraColumnWidth != 0.0 ? this.extraColumnWidth + 2.0 * borderWidth + 1.0 : 0.0;
            double subHeight = colHeaderHeight + dataHeight + 3.0 * borderWidth + 1.0 + (this.settings.enChartLegend ? subRoot.FOOTER_HEIGHT : 0.0);
            canvasWidth += subWidth + this.extraColumnWidth;
            this.extraColumnWidth = 0.0;
            if (subRootIter.hasNext()) {
                canvasWidth += Settings.SUB_IMAGE_SPACING;
            }
            canvasHeight = Math.max(canvasHeight, subHeight);
            timeLineMinY = Math.max(timeLineMinY, borderWidth + colHeaderHeight + halfBorderWidth);
            timeLineMaxY = colHeaderHeight + dataHeight + 3.0 * borderWidth + 1.0;
            this.drawTimeLine(0.0, timeLineMinY, subWidth, timeLineMinY, timeLineMinY, timeLineMaxY, this.settings.topAge, this.settings.baseAge, this.settings.unitsPerMY, null);
            this.drawTimeLabel();
        }
        if (!RangeColumn.errMsg.equals("")) {
            RangeColumn.errorFamilyTree(RangeColumn.errMsg);
        }
        if (canvasWidth < 4.0) {
            throw new NoColumnsToDrawException(nameOfFirstRoot, noRootsSelected);
        }
        this.setCanvasSize(canvasWidth, canvasHeight);
        this.settings = settingsBackup;
        if (this.settings.doPopups) {
            this.addMouseOverTexts(this.settings);
            this.addMouseOverStaticStuff();
        }
        this.addBrowserScript();
        this.addMouseOverTimeLine();
        if (this.patMan != null) {
            this.patMan.writePatternsToIG(this, patternUsageHolder);
        }
        return this.doc;
    }

    public ColumnDrawInfo drawColumn(DataColumn subRoot, Settings subSettings, double xOffset, double yOffset, boolean drawBoundingBox) {
        double borderWidth = Settings.BORDER_WIDTH;
        double dataHeight = (subSettings.baseAge - subSettings.topAge) * subSettings.unitsPerMY;
        double colWidth = subRoot.getWidth(subSettings, this, dataHeight);
        double colHeaderHeight = subRoot.getHeaderHeight(subSettings, this);
        double halfBorderWidth = borderWidth / 2.0;
        subRoot.setVariableColoring(subSettings);
        subRoot.drawHeader(this, xOffset + borderWidth, borderWidth, colWidth, colHeaderHeight, subSettings);
        double dataTopY = borderWidth + colHeaderHeight + borderWidth;
        subRoot.drawData(this, xOffset + borderWidth, dataTopY, colWidth, dataHeight, subSettings);
        if (drawBoundingBox) {
            this.drawRect(xOffset + halfBorderWidth, halfBorderWidth, borderWidth + colWidth + halfBorderWidth - 1.0, borderWidth + colHeaderHeight + borderWidth + dataHeight + halfBorderWidth - 1.0, BORDER_STYLE);
        }
        this.drawLine(xOffset, borderWidth + colHeaderHeight + halfBorderWidth, xOffset + borderWidth + colWidth + borderWidth, borderWidth + colHeaderHeight + halfBorderWidth, BORDER_STYLE);
        if (this.settings.doPopups) {
            this.addMouseOverTexts(this.settings);
            this.addMouseOverStaticStuff();
        }
        this.addBrowserScript();
        this.addMouseOverCrossPlot();
        double subWidth = colWidth + 2.0 * borderWidth + 1.0;
        double subHeight = colHeaderHeight + dataHeight + 3.0 * borderWidth + 1.0;
        ColumnDrawInfo ret = new ColumnDrawInfo();
        ret.width = subWidth;
        ret.height = subHeight;
        ret.dataTopY = dataTopY;
        ret.dataHeight = dataHeight;
        return ret;
    }

    public SVGDocument getDocument() {
        return this.doc;
    }

    public PopupInfo addPopup(RichText text, DataColumn.FileInfo colFileInfo) {
        PopupInfo pi = new PopupInfo(text, colFileInfo);
        this.popups.add(pi);
        return pi;
    }

    public void appendPopupAttributes(Element node, String spawnerID, String popupID) {
        node.setAttributeNS(null, "onmouseover", "doMOHover(evt, '" + spawnerID + "', '" + popupID + "')");
        node.setAttributeNS(null, "onmouseout", "doMOOut(evt)");
        node.setAttributeNS(null, "onclick", "doMOClick(evt, '" + spawnerID + "', '" + popupID + "')");
        node.setAttributeNS(null, "id", spawnerID);
        node.setAttributeNS(null, "opacity", "0");
    }

    public void doPopupThings(String text, DataColumn.FileInfo colFileInfo) {
        this.doPopupThings(this.curElement, text, colFileInfo);
    }

    public void doPopupThings(String text, DataColumn.FileInfo colFileInfo, RangeColumn rCol) {
        this.doPopupThings(this.curElement, text, colFileInfo, rCol);
    }

    public void doPopupThings(Element node, String text, DataColumn.FileInfo colFileInfo) {
        if (node == null || text == null || text.length() == 0) {
            return;
        }
        PopupInfo pi = this.addPopup(new RichText(text, true, colFileInfo), colFileInfo);
        this.appendPopupAttributes(node, pi.spawnerID, pi.id);
    }

    public void doPopupThings(Element node, String text, DataColumn.FileInfo colFileInfo, RangeColumn rCol) {
        if (node == null || text == null || text.length() == 0) {
            return;
        }
        PopupInfo pi = this.addPopup(new RichText(text, true, colFileInfo, rCol), colFileInfo);
        this.appendPopupAttributes(node, pi.spawnerID, pi.id);
    }

    public void addMouseOverTexts(Settings settings) {
        for (int i = 0; i < this.popups.size(); ++i) {
            PopupInfo pi = (PopupInfo)this.popups.get(i);
            StringWrappingInfo swi = this.getSWI(pi.text, settings.fonts.getFont(6), 1);
            Element t = this.doc.createElement("text");
            t.setAttributeNS(null, "id", pi.id);
            t.setAttributeNS(null, "visibility", "hidden");
            t.setAttributeNS(null, "popuptext", swi.s.orig);
            if (pi.colFileInfo != null && pi.colFileInfo.baseURL != null) {
                t.setAttributeNS(null, "docbase", pi.colFileInfo.baseURL.toString());
            }
            this.curElement.appendChild(t);
        }
    }

    public void addMouseOverStaticStuff() {
        this.addMouseOverScript();
    }

    public void addMouseOverScript() {
        Element script = this.doc.createElementNS(this.svgNS, "script");
        script.setAttributeNS(null, "type", "text/ecmascript");
        script.appendChild(this.getScript(ResPath.getPath("CrossplotJS.mouseOverText")));
        this.svgRoot.insertBefore(script, this.svgRoot.getFirstChild());
    }

    public void addBrowserScript() {
        Element fix = this.doc.createElementNS(this.svgNS, "script");
        fix.setAttributeNS(null, "type", "text/ecmascript");
        fix.appendChild(this.getScript(ResPath.getPath("CrossplotJS.browserfix")));
        this.svgRoot.insertBefore(fix, this.svgRoot.getFirstChild());
    }

    public void addMouseOverTimeLine() {
        Element script = this.doc.createElementNS(this.svgNS, "script");
        script.setAttributeNS(null, "type", "text/ecmascript");
        script.appendChild(this.getScript(ResPath.getPath("CrossplotJS.chartTools")));
        this.svgRoot.insertBefore(script, this.svgRoot.getFirstChild());
    }

    public void addMouseOverCrossPlot() {
        Element script = this.doc.createElementNS(this.svgNS, "script");
        script.setAttributeNS(null, "type", "text/ecmascript");
        script.appendChild(this.getScript(ResPath.getPath("CrossplotJS.crossplotTools")));
        this.svgRoot.insertBefore(script, this.svgRoot.getFirstChild());
    }

    private CDATASection getScript(String filepath) {
        CDATASection t = null;
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(FileUtils.getInputStream(filepath)));
            String str = null;
            String script = "\n";
            while ((str = in.readLine()) != null) {
                script = script + str + "\n";
            }
            t = this.doc.createCDATASection(script);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return t;
    }

    public static class ColumnDrawInfo {
        public double width;
        public double height;
        public double dataTopY;
        public double dataHeight;
    }

    public static class NoColumnsToDrawException
    extends Exception {
        public String nameOfFirstRoot;
        public boolean noRootsSelected = false;

        public NoColumnsToDrawException(String nameOfFirstRoot, boolean noRootsSelected) {
            super(NoColumnsToDrawException.makeMessage(nameOfFirstRoot, noRootsSelected));
            this.nameOfFirstRoot = nameOfFirstRoot;
            this.noRootsSelected = noRootsSelected;
        }

        protected static String makeMessage(String nameOfFirstRoot, boolean noRootsSelected) {
            String message = "There is nothing to display because no columns are selected to be drawn.";
            if (noRootsSelected) {
                message = message + "\nNote that no root column ";
                if (nameOfFirstRoot != null) {
                    message = message + "(eg. \"" + nameOfFirstRoot + "\") ";
                }
                message = message + "is selected.";
            }
            return message;
        }
    }

    public class ClickListener
    implements EventListener {
        @Override
        public void handleEvent(Event evt) {
            DOMMouseEvent elEvt = (DOMMouseEvent)evt;
            EventTarget clickedElement = evt.getTarget();
            RangeColumn.RangePoint point = (RangeColumn.RangePoint)ImageGenerator.this.branchNodeList.get(clickedElement);
            short rightLeft = elEvt.getButton();
            if (rightLeft == 0) {
                if (point.childRange.branchedAsLeftOrRight != null) {
                    if (point.childRange.branchedAsLeftOrRight == "left") {
                        RangeColumn.circleDrawingLeftOrRight.put(point.rcd.branchTo, "left");
                    } else {
                        RangeColumn.circleDrawingLeftOrRight.put(point.rcd.branchTo, "right");
                    }
                }
                boolean setResetBranch = point.childRange.getNotIncludeBranch();
                point.setResetIncludeBranch(setResetBranch);
                point.rcd.branchClicked = true;
                ImageGenerator.this.settingsRefFamilyTree.tsObj.generateImage();
            } else if (rightLeft == 2) {
                int xCoordinate = elEvt.getClientX();
                int yCoordinate = elEvt.getClientY();
                point.handlePopUps(xCoordinate, yCoordinate);
            }
        }
    }

    public static class PopupInfo {
        static int count = 0;
        public RichText text;
        public String id;
        public String spawnerID;
        DataColumn.FileInfo colFileInfo;

        public PopupInfo(RichText t, DataColumn.FileInfo colFileInfo) {
            this.text = colFileInfo != null ? new RichText(HTMLPreprocessor.findAndFixDatapackLinks(t.getSourceText(), colFileInfo), colFileInfo) : t;
            this.id = "id" + count;
            this.spawnerID = "spawner" + count;
            ++count;
            this.colFileInfo = colFileInfo;
        }
    }
}

