/*
 * Decompiled with CFR 0.152.
 */
package gui.crossplot;

import datastore.Coloring;
import datastore.DataColumn;
import datastore.Datapoint;
import datastore.Datastore;
import datastore.EventColumn;
import datastore.RootColumn;
import datastore.ZoneColumn;
import datastore.searchresults.EventResults;
import datastore.searchresults.Searchpoint;
import gui.ImageGenerator;
import gui.SearchDataPack;
import gui.crossplot.Coordinate2D;
import gui.crossplot.CrossplotAutoPlotSettings;
import gui.crossplot.CrossplotSettings;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JOptionPane;
import javax.swing.tree.TreeNode;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.svg.SVGDocument;
import util.CSVReader;

public class Crossplot {
    public static final String[] MARKER_POINT_COLUMN_TYPES = new String[]{"EVENT", "ZONE"};
    public static final String[] MODEL_POINT_COLUMN_TYPES = new String[]{"EVENT", "ZONE"};
    public static final String[] MARKER_POINT_TYPES = new String[]{"CIRCLE", "RECT", "BASE(FAD)", "TOP(LAD)"};
    public static final String[] MODEL_POINT_TYPES = new String[]{"CIRCLE", "RECT"};
    public static ArrayList<String> MARKER_COLUMN_NAMES = new ArrayList();
    public static ArrayList<String> MARKER_COLUMN_LIST = new ArrayList();
    public static ArrayList<String> MARKER_NAME_LIST = new ArrayList();
    public static CrossplotSettings crossplotSettings;
    public static CrossplotAutoPlotSettings autoPlotSettings;
    public SVGDocument svgDoc = null;
    public Datastore data = null;
    public ArrayList<Coordinate2D> age_depth_markers = new ArrayList();
    public ArrayList<Coordinate2D> age_depth_models = new ArrayList();
    public ArrayList<Coordinate2D> tempMarker = new ArrayList();
    public ArrayList<Coordinate2D> tempModel = new ArrayList();
    public Element timeLineX = null;
    public Element timeLineY = null;
    public Element timeLabelX = null;
    public Element timeLabelY = null;
    public Element crossplotGroup = null;
    public Element markerGroup = null;
    public Element lineGroup = null;
    public Element modelGroup = null;
    public Element fadGroup = null;
    public Element ladGroup = null;
    public Element timelineGroup = null;
    public Element timelabelsGroup = null;
    public Element popupGroup = null;
    public Element limitingBox = null;
    public int minX = 0;
    public int maxX = 0;
    public double scaleX = 0.0;
    public double topAgeX = 0.0;
    public double baseAgeX = 0.0;
    public double topLimitX = 0.0;
    public double baseLimitX = 0.0;
    public int minY = 0;
    public int maxY = 0;
    public double scaleY = 0.0;
    public double topAgeY = 0.0;
    public double baseAgeY = 0.0;
    public double topLimitY = 0.0;
    public double baseLimitY = 0.0;
    public double topX = 0.0;
    public double baseX = 0.0;
    public double topY = 0.0;
    public double baseY = 0.0;
    public SearchDataPack searchData = null;
    public static boolean myOCx;
    public static boolean myOCy;

    public Crossplot() {
    }

    public Crossplot(Datastore data, SVGDocument svgDoc) {
        this.data = data;
        this.searchData = new SearchDataPack();
        this.setDocument(svgDoc);
    }

    public void setDocument(SVGDocument svgDoc) {
        this.svgDoc = svgDoc;
        this.update();
    }

    public void setDatastore(Datastore data) {
        this.data = data;
    }

    public void update() {
        this.updateElements();
        this.updateLimits();
        this.updateSVG();
    }

    public void updateElements() {
        this.timeLineX = this.svgDoc.getElementById("timelineX");
        this.timeLabelX = this.svgDoc.getElementById("TimeLineLabelX");
        this.timeLineY = this.svgDoc.getElementById("timelineY");
        this.timeLabelY = this.svgDoc.getElementById("TimeLineLabelY");
        this.crossplotGroup = this.svgDoc.getElementById("CrossPlot");
        this.markerGroup = this.svgDoc.getElementById("CrossPlotMarkers");
        this.lineGroup = this.svgDoc.getElementById("CrossPlotLines");
        this.modelGroup = this.svgDoc.getElementById("CrossPlotModels");
        this.fadGroup = this.svgDoc.getElementById("CrossPlotFADLines");
        this.ladGroup = this.svgDoc.getElementById("CrossPlotLADLines");
        this.minX = (int)Math.round(Double.parseDouble(this.timeLineX.getAttribute("minX")));
        this.maxX = (int)Math.round(Double.parseDouble(this.timeLineX.getAttribute("maxX")));
        this.scaleX = Double.parseDouble(this.timeLineX.getAttribute("vertScale"));
        this.topAgeX = Double.parseDouble(this.timeLineX.getAttribute("topAge"));
        this.baseAgeX = Double.parseDouble(this.timeLineX.getAttribute("baseAge"));
        this.minY = (int)Math.round(Double.parseDouble(this.timeLineY.getAttribute("minY")));
        this.maxY = (int)Math.round(Double.parseDouble(this.timeLineY.getAttribute("maxY")));
        this.scaleY = Double.parseDouble(this.timeLineY.getAttribute("vertScale"));
        this.topAgeY = Double.parseDouble(this.timeLineY.getAttribute("topAge"));
        this.baseAgeY = Double.parseDouble(this.timeLineY.getAttribute("baseAge"));
        this.timelineGroup = this.svgDoc.getElementById("CrossPlotTimeLines");
        this.timelabelsGroup = this.svgDoc.getElementById("CrossPlotTimeLabels");
        this.popupGroup = this.svgDoc.getElementById("CrossplotPopup");
        this.limitingBox = this.svgDoc.getElementById("CrossplotLimitingBox");
    }

    public void updateSVG() {
        int i;
        for (i = 0; i < this.age_depth_markers.size(); ++i) {
            this.addMarker(this.age_depth_markers.get(i));
        }
        for (i = 0; i < this.age_depth_models.size(); ++i) {
            this.addModel(this.age_depth_models.get(i));
        }
    }

    public void updateAgeDepthPoints() {
        this.updateMarkersList();
        this.updateModelsList();
    }

    public void clearAllPoints() {
        this.age_depth_markers.clear();
        this.age_depth_models.clear();
        this.tempMarker.clear();
        this.tempModel.clear();
        if (crossplotSettings != null) {
            crossplotSettings.clearAll();
            crossplotSettings.dispose();
        }
    }

    public void updateLimits() {
        boolean isTopX = false;
        boolean isTopY = false;
        boolean isBaseX = false;
        boolean isBaseY = false;
        this.topX = this.topAgeX;
        this.baseX = this.baseAgeX;
        this.topY = this.topAgeY;
        this.baseY = this.baseAgeY;
        for (int i = 0; i < this.age_depth_models.size(); ++i) {
            Coordinate2D currModel = this.age_depth_models.get(i);
            if (currModel.age > this.topAgeX && currModel.depth < this.topAgeY) {
                this.topX = currModel.age;
                isTopX = true;
            }
            if (currModel.age <= this.topAgeX && currModel.depth >= this.topAgeY) {
                this.topY = currModel.depth;
                isTopY = true;
            }
            if (currModel.age < this.baseAgeX && currModel.depth > this.baseAgeY) {
                this.baseX = currModel.age;
                isBaseX = true;
            }
            if (!(currModel.age >= this.baseAgeX) || !(currModel.depth <= this.baseAgeY)) continue;
            this.baseY = currModel.depth;
            isBaseY = true;
        }
        this.topLimitX = !isTopX ? this.topAgeX : this.topX;
        this.baseLimitX = !isBaseX ? this.baseAgeX : this.baseX;
        this.topLimitY = !isTopY ? this.topAgeY : this.topY;
        this.baseLimitY = !isBaseY ? this.baseAgeY : this.baseY;
        this.timeLineX.setAttribute("topLimit", Double.toString(this.topLimitX));
        this.timeLineX.setAttribute("baseLimit", Double.toString(this.baseLimitX));
        this.timeLineY.setAttribute("topLimit", Double.toString(this.topLimitY));
        this.timeLineY.setAttribute("baseLimit", Double.toString(this.baseLimitY));
    }

    public void updateMarkersList() {
        this.tempMarker.clear();
        for (int i = 0; i < this.age_depth_markers.size(); ++i) {
            Coordinate2D currModel = this.age_depth_markers.get(i);
            if (!(currModel.age >= this.topAgeX) || !(currModel.age <= this.baseAgeX) || !(currModel.depth >= this.topAgeY) || !(currModel.depth <= this.baseAgeY)) continue;
            this.tempMarker.add(currModel);
        }
        this.age_depth_markers.removeAll(this.tempMarker);
        if (this.markerGroup == null) {
            return;
        }
        NodeList points = this.markerGroup.getChildNodes();
        for (int i = 0; i < points.getLength(); ++i) {
            Coordinate2D newMarker;
            Element curPoint = (Element)points.item(i);
            if (curPoint.getAttribute("columnType").equals("0")) {
                newMarker = new Coordinate2D(curPoint.getAttribute("id"), Integer.parseInt(curPoint.getAttribute("cx")), Integer.parseInt(curPoint.getAttribute("cy")), Double.parseDouble(curPoint.getAttribute("age")), Double.parseDouble(curPoint.getAttribute("depth")), curPoint.getAttribute("comment"), curPoint.getAttribute("fill"), Integer.parseInt(curPoint.getAttribute("type")), Integer.parseInt(curPoint.getAttribute("columnType")));
                this.age_depth_markers.add(newMarker);
                continue;
            }
            if (curPoint.getAttribute("columnType").equals("1")) {
                newMarker = new Coordinate2D(curPoint.getAttribute("id"), Integer.parseInt(curPoint.getAttribute("x")), Integer.parseInt(curPoint.getAttribute("y")), Double.parseDouble(curPoint.getAttribute("age")), Double.parseDouble(curPoint.getAttribute("depth")), curPoint.getAttribute("comment"), curPoint.getAttribute("fill"), Integer.parseInt(curPoint.getAttribute("type")), Integer.parseInt(curPoint.getAttribute("columnType")));
                this.age_depth_markers.add(newMarker);
                continue;
            }
            newMarker = new Coordinate2D(curPoint.getAttribute("id"), Integer.parseInt(curPoint.getAttribute("cx")), Integer.parseInt(curPoint.getAttribute("cy")), Double.parseDouble(curPoint.getAttribute("age")), Double.parseDouble(curPoint.getAttribute("depth")), curPoint.getAttribute("comment"), curPoint.getAttribute("fill"), Integer.parseInt(curPoint.getAttribute("type")), 0);
            this.age_depth_markers.add(newMarker);
        }
        Collections.sort(this.age_depth_markers);
    }

    public void addMarker(Coordinate2D cdt) {
        int x = this.convertAgeToX(cdt.age);
        int y = this.convertDepthToY(cdt.depth);
        String id = "dot(" + x + "," + y + ")";
        this.addMarker(id, x, y, cdt.age, cdt.depth, cdt.comment, cdt.fill, cdt.type, cdt.columnType);
    }

    public void addMarker(double age, double depth, String comment, String fill, int type, int columnType) throws Exception {
        int x = this.convertAgeToX(age);
        int y = this.convertDepthToY(depth);
        if (myOCy) {
            y = this.convertDepthToY(-depth);
        }
        double myDepth = -depth;
        comment = comment.isEmpty() ? "This is an age-depth marker" : comment;
        String id = "dot(" + x + "," + y + ")";
        if (age < this.topAgeX || age > this.baseAgeX) {
            String msg = "The marker with age : " + age + " is out of range.";
            throw new Exception(msg);
        }
        if (myOCy) {
            if (myDepth < this.topAgeY || myDepth > this.baseAgeY) {
                String msg = "The marker with depth : " + myDepth + " is out of range.";
                throw new Exception(msg);
            }
        } else if (!myOCy && (depth < this.topAgeY || depth > this.baseAgeY)) {
            String msg = "The marker with depth : " + depth + " is out of range.";
            throw new Exception(msg);
        }
        if (myOCy) {
            this.addMarker(id, x, y, age, myDepth, comment, fill, type, columnType);
        } else {
            this.addMarker(id, x, y, age, depth, comment, fill, type, columnType);
        }
        this.updateMarkersList();
    }

    public void addMarker(String id, int x, int y, double age, double depth, String comment, String fill, int type, int columnType) {
        Element dot = this.svgDoc.getElementById(id);
        if (dot != null || age < this.topAgeX || depth < this.topAgeY || age > this.baseAgeX || depth > this.baseAgeY) {
            return;
        }
        if (columnType == 0) {
            dot = this.svgDoc.createElementNS("http://www.w3.org/2000/svg", "circle");
            dot.setAttributeNS(null, "id", "dot(" + x + "," + y + ")");
            dot.setAttributeNS(null, "onclick", "pointClicked(evt)");
            dot.setAttributeNS(null, "onmouseover", "showPopup(evt)");
            dot.setAttributeNS(null, "onmouseout", "hidePopup(evt)");
            dot.setAttributeNS(null, "cx", Integer.toString(x));
            dot.setAttributeNS(null, "cy", Integer.toString(y));
            dot.setAttributeNS(null, "r", Integer.toString(3));
            dot.setAttributeNS(null, "stroke", "black");
            dot.setAttributeNS(null, "stroke-width", Integer.toString(2));
            dot.setAttributeNS(null, "age", "" + age);
            dot.setAttributeNS(null, "depth", "" + depth);
            dot.setAttributeNS(null, "comment", comment.isEmpty() ? "This is an \"Age/Depth Marker\"" : comment);
            dot.setAttributeNS(null, "fill", fill.isEmpty() ? ImageGenerator.marker_color : fill);
            dot.setAttributeNS(null, "fill-color", fill.isEmpty() ? ImageGenerator.marker_color : fill);
            dot.setAttributeNS(null, "type", "" + Integer.toString(type));
            dot.setAttributeNS(null, "columnType", "" + Integer.toString(columnType));
        } else if (columnType == 1) {
            dot = this.svgDoc.createElementNS("http://www.w3.org/2000/svg", "rect");
            dot.setAttributeNS(null, "id", "dot(" + x + "," + y + ")");
            dot.setAttributeNS(null, "onclick", "pointClicked(evt)");
            dot.setAttributeNS(null, "onmouseover", "showPopup(evt)");
            dot.setAttributeNS(null, "onmouseout", "hidePopup(evt)");
            dot.setAttributeNS(null, "x", Integer.toString(x));
            dot.setAttributeNS(null, "y", Integer.toString(y));
            dot.setAttributeNS(null, "cx", Integer.toString(x));
            dot.setAttributeNS(null, "cy", Integer.toString(y));
            dot.setAttributeNS(null, "stroke", "black");
            dot.setAttributeNS(null, "stroke-widht", Integer.toString(1));
            dot.setAttributeNS(null, "age", "" + age);
            dot.setAttributeNS(null, "depth", "" + depth);
            dot.setAttributeNS(null, "comment", comment.isEmpty() ? "This is an \"Age/Depth Marker\"" : comment);
            dot.setAttributeNS(null, "fill", fill.isEmpty() ? ImageGenerator.marker_color : fill);
            dot.setAttributeNS(null, "fill-color", fill.isEmpty() ? ImageGenerator.marker_color : fill);
            dot.setAttributeNS(null, "type", "" + Integer.toString(type));
            dot.setAttributeNS(null, "columnType", "" + Integer.toString(columnType));
            dot.setAttributeNS(null, "height", Integer.toString(10));
            dot.setAttributeNS(null, "width", Integer.toString(10));
        }
        this.markerGroup.appendChild(dot);
    }

    public void updateModelsList() {
        this.tempModel.clear();
        for (int i = 0; i < this.age_depth_models.size(); ++i) {
            Coordinate2D currModel = this.age_depth_models.get(i);
            if (!(currModel.age >= this.topAgeX) || !(currModel.age <= this.baseAgeX) || !(currModel.depth >= this.topAgeY) || !(currModel.depth <= this.baseAgeY)) continue;
            this.tempModel.add(currModel);
        }
        this.age_depth_models.removeAll(this.tempModel);
        if (this.modelGroup == null) {
            return;
        }
        NodeList points = this.modelGroup.getChildNodes();
        for (int i = 0; i < points.getLength(); ++i) {
            Coordinate2D newModel;
            Element curPoint = (Element)points.item(i);
            double myAge = Double.parseDouble(curPoint.getAttribute("age"));
            double myDepth = Double.parseDouble(curPoint.getAttribute("depth"));
            if (myOCx) {
                myAge = -myAge;
            }
            if (myOCy) {
                myDepth = -myDepth;
            }
            if (curPoint.getAttribute("columnType").equals("0")) {
                newModel = new Coordinate2D(curPoint.getAttribute("id"), Integer.parseInt(curPoint.getAttribute("cx")), Integer.parseInt(curPoint.getAttribute("cy")), Double.parseDouble(curPoint.getAttribute("age")), Double.parseDouble(curPoint.getAttribute("depth")), curPoint.getAttribute("comment"), curPoint.getAttribute("fill"), Integer.parseInt(curPoint.getAttribute("type")), Integer.parseInt(curPoint.getAttribute("columnType")));
                this.age_depth_models.add(newModel);
                continue;
            }
            if (curPoint.getAttribute("columnType").equals("1")) {
                newModel = new Coordinate2D(curPoint.getAttribute("id"), Integer.parseInt(curPoint.getAttribute("x")), Integer.parseInt(curPoint.getAttribute("y")), Double.parseDouble(curPoint.getAttribute("age")), Double.parseDouble(curPoint.getAttribute("depth")), curPoint.getAttribute("comment"), curPoint.getAttribute("fill"), Integer.parseInt(curPoint.getAttribute("type")), Integer.parseInt(curPoint.getAttribute("columnType")));
                this.age_depth_models.add(newModel);
                continue;
            }
            newModel = new Coordinate2D(curPoint.getAttribute("id"), Integer.parseInt(curPoint.getAttribute("cx")), Integer.parseInt(curPoint.getAttribute("cy")), Double.parseDouble(curPoint.getAttribute("age")), Double.parseDouble(curPoint.getAttribute("depth")), curPoint.getAttribute("comment"), curPoint.getAttribute("fill"), Integer.parseInt(curPoint.getAttribute("type")), 0);
            this.age_depth_models.add(newModel);
        }
        Collections.sort(this.age_depth_models);
    }

    public void addModel(Coordinate2D cdt) {
        int x = this.convertAgeToX(cdt.age);
        int y = this.convertDepthToY(cdt.depth);
        String id = "dot(" + x + ")";
        this.addModel(id, x, y, cdt.age, cdt.depth, cdt.comment, cdt.fill, cdt.type, cdt.columnType);
    }

    public void addModel(double age, double depth, String comment, String fill, int type, int columnType) throws Exception {
        Coordinate2D p2;
        int x = this.convertAgeToX(age);
        int y = this.convertDepthToY(depth);
        if (myOCy) {
            y = this.convertDepthToY(-depth);
        }
        double myDepth = -depth;
        comment = comment.isEmpty() ? "This is an \"Age/Depth Model\"" : comment;
        String id = "dot(" + x + ")";
        Coordinate2D p1 = this.getPrevPointAgeIndex(x) != -1 ? this.age_depth_models.get(this.getPrevPointAgeIndex(x)) : null;
        Coordinate2D coordinate2D = p2 = this.getNextPointAgeIndex(x) != -1 ? this.age_depth_models.get(this.getNextPointAgeIndex(x)) : null;
        if (p2 != null && y > p2.y || p1 != null && y < p1.y) {
            String msg = "The model with age : " + age + " can have only depth in the range (" + p1.depth + "," + p2.depth + ").";
            throw new Exception(msg);
        }
        if (age < this.topAgeX || age > this.baseAgeX) {
            String msg = "The model with age : " + age + " is out of range.";
            throw new Exception(msg);
        }
        if (myOCy) {
            if (myDepth < this.topAgeY || myDepth > this.baseAgeY) {
                String msg = "The model with depth : " + myDepth + " is out of range. (1)";
                throw new Exception(msg);
            }
        } else if (!myOCy && (depth < this.topAgeY || depth > this.baseAgeY)) {
            String msg = "The model with depth : " + depth + " is out of range. (2)";
            throw new Exception(msg);
        }
        if (myOCy) {
            this.addModel(id, x, y, age, myDepth, comment, fill, type, columnType);
        } else {
            this.addModel(id, x, y, age, depth, comment, fill, type, columnType);
        }
        this.updateModelsList();
    }

    public void addModel(String id, int x, int y, double age, double depth, String comment, String fill, int type, int columnType) {
        Element dot = this.svgDoc.getElementById(id);
        if (dot != null || age < this.topAgeX || depth < this.topAgeY || age > this.baseAgeX || depth > this.baseAgeY) {
            return;
        }
        if (columnType == 0) {
            dot = this.svgDoc.createElementNS("http://www.w3.org/2000/svg", "circle");
            dot.setAttributeNS(null, "id", id);
            dot.setAttributeNS(null, "onclick", "pointClicked(evt)");
            dot.setAttributeNS(null, "onmouseover", "showPopup(evt)");
            dot.setAttributeNS(null, "onmouseout", "hidePopup(evt)");
            dot.setAttributeNS(null, "cx", Integer.toString(x));
            dot.setAttributeNS(null, "cy", Integer.toString(y));
            dot.setAttributeNS(null, "r", Integer.toString(3));
            dot.setAttributeNS(null, "stroke", "black");
            dot.setAttributeNS(null, "stroke-width", Integer.toString(2));
            dot.setAttributeNS(null, "age", "" + age);
            dot.setAttributeNS(null, "depth", "" + depth);
            dot.setAttributeNS(null, "comment", comment.isEmpty() ? "This is an \"Age/Depth Model\"" : comment);
            dot.setAttributeNS(null, "fill", fill.isEmpty() ? ImageGenerator.model_color : fill);
            dot.setAttributeNS(null, "fill-color", fill.isEmpty() ? ImageGenerator.model_color : fill);
            dot.setAttributeNS(null, "type", "" + Integer.toString(type));
            dot.setAttributeNS(null, "columnType", "" + columnType);
        } else if (columnType == 1) {
            dot = this.svgDoc.createElementNS("http://www.w3.org/2000/svg", "rect");
            dot.setAttributeNS(null, "id", "dot(" + x + "," + y + ")");
            dot.setAttributeNS(null, "onclick", "pointClicked(evt)");
            dot.setAttributeNS(null, "onmouseover", "showPopup(evt)");
            dot.setAttributeNS(null, "onmouseout", "hidePopup(evt)");
            dot.setAttributeNS(null, "x", Integer.toString(x));
            dot.setAttributeNS(null, "y", Integer.toString(y));
            dot.setAttributeNS(null, "cx", Integer.toString(x));
            dot.setAttributeNS(null, "cy", Integer.toString(y));
            dot.setAttributeNS(null, "stroke", "black");
            dot.setAttributeNS(null, "stroke-widht", Integer.toString(1));
            dot.setAttributeNS(null, "age", "" + age);
            dot.setAttributeNS(null, "depth", "" + depth);
            dot.setAttributeNS(null, "comment", comment.isEmpty() ? "This is an \"Age/Depth Marker\"" : comment);
            dot.setAttributeNS(null, "fill", fill.isEmpty() ? ImageGenerator.marker_color : fill);
            dot.setAttributeNS(null, "fill-color", fill.isEmpty() ? ImageGenerator.marker_color : fill);
            dot.setAttributeNS(null, "type", "" + Integer.toString(type));
            dot.setAttributeNS(null, "columnType", "" + Integer.toString(columnType));
            dot.setAttributeNS(null, "height", Integer.toString(10));
            dot.setAttributeNS(null, "width", Integer.toString(10));
        }
        this.modelGroup.appendChild(dot);
    }

    public int getPrevPointAgeIndex(int x) {
        int i = 0;
        for (i = 0; i < this.age_depth_models.size(); ++i) {
            if (this.age_depth_models.get((int)i).x < x || this.age_depth_models.size() <= 0) continue;
            return i - 1;
        }
        return i == 0 ? -1 : this.age_depth_models.size() - 1;
    }

    public int getNextPointAgeIndex(int x) {
        int i = 0;
        for (i = 0; i < this.age_depth_models.size(); ++i) {
            if (this.age_depth_models.get((int)i).x == x && i < this.age_depth_models.size() - 1) {
                return i + 1;
            }
            if (this.age_depth_models.get((int)i).x <= x) continue;
            return i;
        }
        return -1;
    }

    public int convertAgeToX(double age) {
        int x = 0;
        x = this.minX + (age > this.topAgeX ? (int)Math.round((age - this.topAgeX) * this.scaleX) : 0);
        x = x > this.maxX ? this.maxX : x;
        return x;
    }

    public int convertDepthToY(double depth) {
        int y = 0;
        y = this.minY + (depth > this.topAgeY ? (int)Math.round((depth - this.topAgeY) * this.scaleY) : 0);
        y = y > this.maxY ? this.maxY : y;
        return y;
    }

    public void saveToFile(String filename) throws Exception {
        int i;
        this.updateAgeDepthPoints();
        Date d = new Date();
        BufferedWriter fw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), "UTF-8"));
        fw.write("COMMENT\tformat version: 1.5\nCOMMENT\tdate: " + d + "\n\n");
        fw.write("\n\nCOMMENT\tAGE-DEPTH MARKER POINTS.\n");
        fw.write("\nCDTINFO\tAGE\tDEPTH\tNOTE\tCOLOR\tTYPE\n");
        for (i = 0; i < this.age_depth_markers.size(); ++i) {
            double myAgeMk = this.age_depth_markers.get((int)i).age;
            double myDepthMk = this.age_depth_markers.get((int)i).depth;
            if (myOCx) {
                myAgeMk = -myAgeMk;
            }
            if (myOCy) {
                myDepthMk = -myDepthMk;
            }
            fw.write("MARKER\t" + myAgeMk + "\t" + myDepthMk + "\t\"" + this.age_depth_markers.get((int)i).comment + "\"\t" + this.age_depth_markers.get((int)i).fill + "\t" + MARKER_POINT_TYPES[this.age_depth_markers.get((int)i).type] + "\n");
        }
        fw.write("COMMENT\tAGE-DEPTH MODEL POINTS.\n");
        fw.write("\nCDTINFO\tAGE\tDEPTH\tNOTE\tCOLOR\tTYPE\n");
        for (i = 0; i < this.age_depth_models.size(); ++i) {
            double myAgeMdl = this.age_depth_models.get((int)i).age;
            double myDepthMdl = this.age_depth_models.get((int)i).depth;
            if (myOCx) {
                myAgeMdl = -myAgeMdl;
            }
            if (myOCy) {
                myDepthMdl = -myDepthMdl;
            }
            fw.write("MODEL\t" + myAgeMdl + "\t" + myDepthMdl + "\t\"" + this.age_depth_models.get((int)i).comment + "\"\t" + this.age_depth_models.get((int)i).fill + "\t" + MODEL_POINT_TYPES[this.age_depth_models.get((int)i).type] + "\n");
        }
        fw.write("\n\n");
        fw.close();
    }

    public void loadFromFile(String filename) throws Exception {
        String[] value;
        this.age_depth_markers = new ArrayList();
        this.age_depth_models = new ArrayList();
        HashMap<String, Integer> info = new HashMap<String, Integer>();
        CSVReader reader = new CSVReader(new InputStreamReader((InputStream)new FileInputStream(filename), "UTF-8"), '\t');
        this.update();
        while ((value = reader.readNext()) != null) {
            int i;
            int columnType;
            int i2;
            int type;
            String color;
            String note;
            double depth;
            String rowType = value[0];
            if (rowType.equalsIgnoreCase("COMMENT")) continue;
            if (rowType.equalsIgnoreCase("CDTINFO")) {
                for (int i3 = 1; i3 < value.length; ++i3) {
                    info.put(value[i3], i3);
                }
                continue;
            }
            if (info != null && rowType.equalsIgnoreCase("MARKER")) {
                double age = Double.parseDouble(value[(Integer)info.get("AGE")]);
                depth = Double.parseDouble(value[(Integer)info.get("DEPTH")]);
                note = value[(Integer)info.get("NOTE")].replaceAll("^\"|\"$", "") + "\"";
                color = value[(Integer)info.get("COLOR")];
                type = 0;
                for (i2 = 0; i2 < MARKER_POINT_TYPES.length; ++i2) {
                    if (!value[(Integer)info.get("TYPE")].equalsIgnoreCase(MARKER_POINT_TYPES[i2])) continue;
                    type = i2;
                    break;
                }
                columnType = 0;
                for (i = 0; i < MARKER_POINT_COLUMN_TYPES.length; ++i) {
                    if (!value[(Integer)info.get("TYPE")].equalsIgnoreCase(MARKER_POINT_COLUMN_TYPES[i])) continue;
                    columnType = i;
                    break;
                }
                this.addMarker(age, depth, note, color, type, columnType);
                continue;
            }
            if (info == null || !rowType.equalsIgnoreCase("MODEL")) continue;
            double age = Double.parseDouble(value[(Integer)info.get("AGE")]);
            depth = Double.parseDouble(value[(Integer)info.get("DEPTH")]);
            note = value[(Integer)info.get("NOTE")].replaceAll("^\"|\"$", "") + "\"";
            color = value[(Integer)info.get("COLOR")];
            type = 0;
            for (i2 = 0; i2 < MODEL_POINT_TYPES.length; ++i2) {
                if (!value[(Integer)info.get("TYPE")].equalsIgnoreCase(MODEL_POINT_TYPES[i2])) continue;
                type = i2;
                break;
            }
            columnType = 0;
            for (i = 0; i < MODEL_POINT_COLUMN_TYPES.length; ++i) {
                if (!value[(Integer)info.get("TYPE")].equalsIgnoreCase(MODEL_POINT_COLUMN_TYPES[i])) continue;
                columnType = i;
                break;
            }
            this.addModel(age, depth, note, color, type, columnType);
        }
    }

    public void autoPlot() {
        RootColumn ageRoot = null;
        RootColumn depthRoot = null;
        Iterator<DataColumn> rootIter = this.data.rootColumn.getSubColumns();
        while (rootIter.hasNext()) {
            RootColumn currRoot = (RootColumn)rootIter.next();
            if (!currRoot.unit.equals("ma")) {
                depthRoot = currRoot;
            } else if (currRoot.unit.equals("ma")) {
                ageRoot = currRoot;
            }
            if (ageRoot == null || depthRoot == null) continue;
            break;
        }
        if (ageRoot != null && depthRoot != null) {
            this.compareAgeAndDepthColumns(ageRoot, depthRoot);
        }
    }

    public void autoPlot(DataColumn ageColumn, DataColumn depthColumn) {
        int matchedDataPoints = 0;
        int columnType = 0;
        if (ageColumn == null || depthColumn == null) {
            this.autoPlot();
            return;
        }
        if (ageColumn.getName().equalsIgnoreCase(depthColumn.getName())) {
            return;
        }
        if (ageColumn instanceof EventColumn && depthColumn instanceof EventColumn) {
            columnType = 0;
        } else if (ageColumn instanceof ZoneColumn && depthColumn instanceof ZoneColumn) {
            columnType = 1;
        }
        if (MARKER_COLUMN_NAMES.isEmpty()) {
            MARKER_COLUMN_NAMES.add("Select a Column");
        }
        for (Datapoint ageData : ageColumn.getData(this.topX, this.baseX)) {
            for (Datapoint depthData : depthColumn.getData(this.topY, this.baseY)) {
                String comment;
                int type = 0;
                String ageType = (String)ageData.value;
                String depthType = (String)depthData.value;
                if (columnType == 0 && ageData.label.equalsIgnoreCase(depthData.label) && ageType.trim().equalsIgnoreCase(depthType.trim())) {
                    try {
                        if (ageType.trim().equalsIgnoreCase("fad")) {
                            type = 1;
                        } else if (ageType.trim().equalsIgnoreCase("lad")) {
                            type = 2;
                        }
                        comment = ageData.label;
                        this.addMarker(ageData.baseAge, depthData.baseAge, comment, Coloring.getCSScolor(ageColumn.guiColor.oneColor), type, columnType);
                        if (!MARKER_COLUMN_NAMES.contains(ageColumn.getName())) {
                            MARKER_COLUMN_NAMES.add(ageColumn.getName());
                        }
                        MARKER_COLUMN_LIST.add(ageColumn.getName());
                        MARKER_NAME_LIST.add(comment);
                        ++matchedDataPoints;
                        continue;
                    }
                    catch (Exception e) {
                        String message = "Caught an exception at event \"" + ageData.label + "\"\n" + e.getLocalizedMessage();
                        JOptionPane.showMessageDialog(null, message, "Data Error", 0);
                        this.clearAllPoints();
                        return;
                    }
                }
                if (columnType != true || ageData.label == null || !ageData.label.equalsIgnoreCase(depthData.label)) continue;
                try {
                    comment = ageData.label;
                    this.addMarker(ageData.baseAge, depthData.baseAge, comment, Coloring.getCSScolor(ageColumn.guiColor.oneColor), 1, columnType);
                    if (!MARKER_COLUMN_NAMES.contains(ageColumn.getName())) {
                        MARKER_COLUMN_NAMES.add(ageColumn.getName());
                    }
                    MARKER_COLUMN_LIST.add(ageColumn.getName());
                    MARKER_NAME_LIST.add(comment);
                    ++matchedDataPoints;
                }
                catch (Exception e) {
                    String message = "Caught an exception at event \"" + ageData.label + "\"\n" + e.getLocalizedMessage();
                    JOptionPane.showMessageDialog(null, message, "Data Error", 0);
                    this.clearAllPoints();
                    return;
                }
            }
        }
    }

    public void compareAgeAndDepthColumns(DataColumn ageRoot, DataColumn depthRoot) {
        DataColumn ageNode;
        DataColumn depthNode = depthRoot;
        if (depthNode.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = depthNode.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                this.compareAgeAndDepthColumns(ageRoot, (DataColumn)n);
            }
        }
        if ((ageNode = ageRoot).getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = ageNode.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                this.compareAgeAndDepthColumns((DataColumn)n, depthRoot);
            }
        }
        if (ageRoot instanceof EventColumn && depthRoot instanceof EventColumn) {
            this.autoPlot(ageRoot, depthRoot);
        }
        if (ageRoot instanceof ZoneColumn && depthRoot instanceof ZoneColumn && ageRoot.name != "Facies Label" && ageRoot.name != "Facies" && ageRoot.name != "Series Facies" && depthRoot.name != "Facies Label" && depthRoot.name != "Facies" && depthRoot.name != "Series Facies" && ageRoot.name != "Series Label" && depthRoot.name != "Series Label") {
            this.autoPlot(ageRoot, depthRoot);
        }
    }

    private void checkAllColumns(TreeNode node) {
        DataColumn dcol = (DataColumn)node;
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                this.checkAllColumns(n);
            }
        }
        if (dcol instanceof EventColumn) {
            for (Datapoint dataPoint : dcol.getData(this.topY, this.baseY)) {
                System.out.println("Data Label-------------------------" + dataPoint.label);
                if (this.searchData == null) {
                    this.searchData = new SearchDataPack();
                }
                if (this.searchData == null || !this.searchData.search(this.data, dataPoint.label, false)) continue;
                System.out.println("Found results for -------------------------" + dataPoint.label);
                for (int i = 0; i < this.searchData.eventResults.size(); ++i) {
                    EventResults result = this.searchData.eventResults.get(i);
                    for (int j = 0; j < result.event.size(); ++j) {
                        Searchpoint point = result.event.get(j);
                        String dataType = (String)dataPoint.value;
                        if (dcol.name.equalsIgnoreCase(point.vectorHier.lastElement())) continue;
                        int type = 0;
                        if (point.Qualifier.toString().equalsIgnoreCase("lad") && dataType.trim().equalsIgnoreCase("fad")) {
                            type = 1;
                        } else if (point.Qualifier.toString().equalsIgnoreCase("lad") && dataType.trim().equalsIgnoreCase("lad")) {
                            type = 2;
                        }
                        int columnType = 0;
                        if (point.columnType.equalsIgnoreCase("0") && dataType.trim().equalsIgnoreCase("0")) {
                            columnType = 0;
                        } else if (point.columnType.equalsIgnoreCase("1") && dataType.trim().equalsIgnoreCase("1")) {
                            columnType = 1;
                        }
                        try {
                            String comment = dataPoint.label;
                            this.addMarker(Double.parseDouble(point.baseAge), dataPoint.baseAge, comment, Coloring.getCSScolor(dcol.guiColor.oneColor), type, columnType);
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
        }
    }

    static {
        myOCx = false;
        myOCy = false;
    }
}

