/*
 * Decompiled with CFR 0.152.
 */
package gui.editor;

import datastore.editor.DataSeries;
import datastore.editor.DatapointTableModel;
import datastore.editor.GroupingSteward;
import gui.ModifyTextField;
import gui.editor.ColumnDataEditor;
import gui.editor.SpreadSheet;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.table.JTableHeader;

public class GroupingPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    Vector groupings = new Vector();
    DataSeries data = null;
    ColumnDataEditor editor;
    JPanel emptyPanel = new JPanel();

    public GroupingPanel(DataSeries data, ColumnDataEditor editor) {
        this.data = data;
        this.editor = editor;
        super.setSize(super.getPreferredSize());
    }

    public void add(GroupingSteward g) {
        Grouping gr = new Grouping(g);
        this.add(gr);
    }

    public void add(Grouping g) {
        super.remove(this.emptyPanel);
        this.groupings.add(g);
        super.add(g);
        super.add(this.emptyPanel);
    }

    public void insert(Grouping g, Grouping where) {
        int j;
        int i = this.groupings.indexOf(where);
        if (i < 0) {
            return;
        }
        for (j = i; j < this.groupings.size(); ++j) {
            super.remove((JPanel)this.groupings.get(j));
        }
        super.remove(this.emptyPanel);
        this.groupings.insertElementAt(g, i);
        for (j = i; j < this.groupings.size(); ++j) {
            super.add((JPanel)this.groupings.get(j));
        }
        super.add(this.emptyPanel);
        super.setSize(super.getPreferredSize());
        this.doLayout();
        this.validate();
        this.repaint();
    }

    public void delete(Grouping g) {
        this.groupings.remove(g);
        super.remove(g);
        super.setSize(super.getPreferredSize());
        this.doLayout();
        this.validate();
        this.repaint();
    }

    public class Grouping
    extends JPanel {
        private static final long serialVersionUID = 1L;
        GroupingBar bar;
        SpreadSheet sheet;
        JTableHeader header;
        GroupingSteward stew;

        public Grouping(GroupingSteward g) {
            this.stew = g;
            this.bar = new GroupingBar();
            DatapointTableModel model = new DatapointTableModel(g);
            this.sheet = new SpreadSheet(model);
            this.sheet.enableRowInsertRemove();
            this.sheet.addFocusListener(GroupingPanel.this.editor);
            this.sheet.setExtraMenuActions(GroupingPanel.this.editor.getSheetActions());
            model.registerEditorsAndRenderers(this.sheet);
            this.header = this.sheet.getTableHeader();
            this.setBorder(BorderFactory.createEmptyBorder(0, 0, 15, 0));
            this.setLayout(new BoxLayout(this, 1));
            this.add(this.bar);
            this.add(Box.createRigidArea(new Dimension(0, 5)));
            this.add(this.header);
            this.add(this.sheet);
            if (GroupingPanel.this.editor.sheetInFocus == null) {
                this.sheet.requestFocus();
            }
        }

        public void createNewGroupingHere() {
            GroupingSteward newStew = GroupingPanel.this.data.createGroupingAt(this.stew, null);
            Grouping g = new Grouping(newStew);
            GroupingPanel.this.insert(g, this);
        }

        public class GroupingBar
        extends JToolBar
        implements ActionListener {
            private static final long serialVersionUID = 1L;
            public ModifyTextField titleTF = new ModifyTextField(true, true);
            public JButton deleteB = new JButton("Delete Block");
            public JButton moveUp = new JButton("Up");
            public JButton moveDown = new JButton("Down");
            public JButton newB = new JButton("New Block Here");

            public GroupingBar() {
                this.titleTF.addActionListener(this);
                this.deleteB.addActionListener(this);
                this.newB.addActionListener(this);
                this.moveUp.addActionListener(this);
                this.moveDown.addActionListener(this);
                this.titleTF.setToolTipText("This text appears in the series label column next to all the datapoints in this block.");
                this.deleteB.setToolTipText("Delete all data up to the next block.");
                this.newB.setToolTipText("Create a new block and put it right before this one.");
                this.moveUp.setToolTipText("Move this block before the previous one.");
                this.moveDown.setToolTipText("Move this block after the next one.");
                this.add(this.titleTF);
                this.addSeparator();
                this.add(this.newB);
                this.addSeparator();
                this.add(this.deleteB);
                this.titleTF.setText(Grouping.this.stew.getTitle());
                this.doLayout();
                Dimension d = this.getPreferredSize();
                d.width = Integer.MAX_VALUE;
                this.setMaximumSize(d);
                this.setFloatable(false);
            }

            @Override
            public void actionPerformed(ActionEvent ae) {
                Object source = ae.getSource();
                if (source == this.titleTF) {
                    Grouping.this.stew.setTitle(this.titleTF.getText());
                } else if (source == this.newB) {
                    Grouping.this.createNewGroupingHere();
                } else if (source == this.deleteB) {
                    if (GroupingPanel.this.data.getNumGroupings() == 1) {
                        Grouping.this.createNewGroupingHere();
                    }
                    Grouping.this.stew.delete();
                    GroupingPanel.this.data.removeGrouping(Grouping.this.stew);
                    GroupingPanel.this.delete(Grouping.this);
                } else if (source == this.moveUp) {
                    GroupingPanel.this.data.moveGrouping(Grouping.this.stew, -1);
                } else if (source == this.moveDown) {
                    GroupingPanel.this.data.moveGrouping(Grouping.this.stew, 1);
                }
            }
        }
    }
}

