/*
 * Decompiled with CFR 0.152.
 */
package model;

import java.util.ArrayList;
import java.util.List;
import model.Column;
import model.EventData;
import model.ModelIdentifier;
import model.storage.EventColumnStorage;
import model.storage.Storage;
import model.util.SourceResult;

public class EventColumn
extends Column {
    private ModelIdentifier identifier = null;
    private boolean deleted = false;
    private String creationDate = "";
    private String lastModified = "";

    public EventColumn(String database) {
        super(database);
        this.setIdentifier(new ModelIdentifier(0, database, 8));
    }

    public EventColumn(ModelIdentifier id, SourceResult result) {
        super(result);
        this.setIdentifier(id);
        this.setDeleted(result.getBool("deleted"));
        this.setCreationDate(result.getString("creationDate"));
        this.setLastModified(result.getString("lastModified"));
    }

    @Override
    public ModelIdentifier getIdentifier() {
        return this.identifier;
    }

    @Override
    public final void setIdentifier(ModelIdentifier identifier) {
        this.identifier = identifier;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public final void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public String getLastModified() {
        return this.lastModified;
    }

    private void setLastModified(String lastModified) {
        this.lastModified = lastModified;
    }

    public String getCreationDate() {
        return this.creationDate;
    }

    private void setCreationDate(String creationDate) {
        this.creationDate = creationDate;
    }

    @Override
    public void save() {
        super.save();
        if (this.identifier == null) {
            return;
        }
        if (this.identifier.getId() == 0) {
            EventColumnStorage.insert(this);
            this.getIdentifier().setId(Storage.getLastInsertId().getInt("id"));
        } else {
            EventColumnStorage.update(this);
        }
    }

    public List<EventData> getDataByAge(double top, double bottom) {
        return EventData.Factory.getByAge(this, top, bottom);
    }

    public static class Factory {
        public static List<EventColumn> getByTitle(String title) {
            List<SourceResult> results = EventColumnStorage.findByTitle(title);
            List<ModelIdentifier> ids = ModelIdentifier.Factory.translateSourceResult(results, 8);
            return Factory.getByIdentifiers(ids);
        }

        public static EventColumn getByIdentifier(ModelIdentifier id) {
            List<Object> eventColumns = new ArrayList();
            ArrayList<ModelIdentifier> ids = new ArrayList<ModelIdentifier>();
            ids.add(id);
            eventColumns = Factory.getByIdentifiers(ids);
            if (eventColumns.isEmpty()) {
                return null;
            }
            return (EventColumn)eventColumns.get(0);
        }

        public static List<EventColumn> getByIdentifiers(List<ModelIdentifier> ids) {
            ArrayList<EventColumn> eventColumns = new ArrayList<EventColumn>();
            List<SourceResult> results = EventColumnStorage.load(ids);
            for (int i = 0; i < results.size(); ++i) {
                eventColumns.add(new EventColumn(ids.get(i), results.get(i)));
            }
            return eventColumns;
        }
    }
}

