/*
 * Decompiled with CFR 0.152.
 */
package model;

import java.util.ArrayList;
import java.util.List;
import model.Column;
import model.Data;
import model.EventColumn;
import model.LineStyles;
import model.ModelIdentifier;
import model.storage.EventDataStorage;
import model.storage.Storage;
import model.util.SourceResult;

public class EventData
extends Data {
    private ModelIdentifier identifier = null;
    private String label = "";
    private int lineStyle = 0;
    private String type = "";
    private boolean deleted = false;
    private String creationDate = "";
    private String lastModified = "";

    public EventData() {
    }

    public EventData(EventColumn c, String database) {
        super((Column)c, database);
        this.setIdentifier(new ModelIdentifier(0, database, 9));
    }

    public EventData(EventColumn c, ModelIdentifier id, SourceResult result) {
        super((Column)c, result);
        this.setIdentifier(id);
        this.setLabel(result.getString("label"));
        this.setLineStyle(LineStyles.getLabel(result.getString("linestyle")));
        this.setType(result.getString("type"));
        this.setDeleted(result.getBool("deleted"));
        this.setCreationDate(result.getString("creationDate"));
        this.setLastModified(result.getString("lastModified"));
    }

    @Override
    public void save() {
        super.save();
        if (this.identifier == null) {
            return;
        }
        if (this.identifier.getId() == 0) {
            EventDataStorage.insert(this);
            this.getIdentifier().setId(Storage.getLastInsertId().getInt("id"));
        } else {
            EventDataStorage.update(this);
        }
    }

    public final void setIdentifier(ModelIdentifier identifier) {
        this.identifier = identifier;
    }

    @Override
    public ModelIdentifier getIdentifier() {
        return this.identifier;
    }

    public String getLabel() {
        return this.label;
    }

    public final void setLabel(String label) {
        this.label = label;
    }

    public int getLineStyle() {
        return this.lineStyle;
    }

    public final void setLineStyle(int linestyle) {
        this.lineStyle = linestyle;
    }

    public String getType() {
        return this.type;
    }

    public final void setType(String type) {
        this.type = type;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public final void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public String getLastModified() {
        return this.lastModified;
    }

    private void setLastModified(String lastModified) {
        this.lastModified = lastModified;
    }

    public String getCreationDate() {
        return this.creationDate;
    }

    private void setCreationDate(String creationDate) {
        this.creationDate = creationDate;
    }

    public static class Factory {
        public static EventData getByIdentifier(EventColumn c, ModelIdentifier id) {
            List<Object> blockData = new ArrayList();
            ArrayList<ModelIdentifier> ids = new ArrayList<ModelIdentifier>();
            ids.add(id);
            blockData = Factory.getByIdentifiers(c, ids);
            if (blockData.isEmpty()) {
                return null;
            }
            return (EventData)blockData.get(0);
        }

        public static List<EventData> getByIdentifiers(EventColumn c, List<ModelIdentifier> ids) {
            ArrayList<EventData> eventData = new ArrayList<EventData>();
            List<SourceResult> results = EventDataStorage.load(ids);
            for (int i = 0; i < results.size(); ++i) {
                eventData.add(new EventData(c, ids.get(i), results.get(i)));
            }
            return eventData;
        }

        public static List<EventData> getByAge(EventColumn c, double top, double bottom) {
            List<SourceResult> results = EventDataStorage.findByAge(c, top, bottom);
            List<ModelIdentifier> ids = ModelIdentifier.Factory.translateSourceResult(results, 9);
            return Factory.getByIdentifiers(c, ids);
        }
    }
}

