/*
 * Decompiled with CFR 0.152.
 */
package model.storage;

import java.util.ArrayList;
import java.util.List;
import model.ModelIdentifier;
import model.RangeColumn;
import model.RangeData;
import model.storage.DataStorage;
import model.storage.Query;
import model.util.SourceResult;

public class RangeDataStorage
extends DataStorage {
    public static void insert(RangeData data) {
        Query query = new Query("INSERT INTO #.range_data       (id, data_id, range_columns_id, label, abundance,        color, deleted)       VALUES (NULL, :data_id, :range_column_id, :label, :abundance,         :color, :deleted)");
        query.useDatabase(data.getIdentifier().getDatabase());
        query.setInt("range_column_id", data.getColumn().getIdentifier().getId());
        query.setInt("data_id", data.getDataIdentifier().getId());
        query.setString("label", data.getLabel());
        query.setString("abundance", data.getAbundance());
        query.setString("color", data.getColor());
        query.setBoolean("deleted", data.isDeleted());
        query.executeUpdate();
        query.close();
    }

    public static void update(RangeData data) {
        Query query = new Query("UPDATE #.range_data       SET range_columns_id = :range_column_id, label = :label,         abundance = :abundance, color = :color       WHERE id = :id");
        query.useDatabase(data.getIdentifier().getDatabase());
        query.setInt("id", data.getIdentifier().getId());
        query.setInt("block_column_id", data.getColumn().getIdentifier().getId());
        query.setString("label", data.getLabel());
        query.setString("abundance", data.getAbundance());
        query.setString("color", data.getColor());
        query.executeUpdate();
        query.close();
    }

    public static List<SourceResult> load(List<ModelIdentifier> ids) {
        ArrayList<SourceResult> results = new ArrayList();
        results = DataStorage.load(ids);
        Query query = new Query("SELECT label, abundance, color,                deleted, last_modified, creation_date       FROM #.range_data       WHERE data_id = :id");
        for (int i = 0; i < ids.size(); ++i) {
            ModelIdentifier id = ids.get(i);
            query.useDatabase(id.getDatabase());
            query.setInt("id", id.getId());
            ((SourceResult)results.get(i)).putAll(query.executeQuery().get(0));
        }
        query.close();
        return results;
    }

    public static List<SourceResult> findByAge(RangeColumn col, double top, double bottom) {
        Query query = new Query("SELECT '#' AS database, data.id       FROM #.data as data         JOIN #.range_data as rangedata ON ( data.id = rangedata.data_id )       WHERE rangedata.range_columns_id = :range_column_id         AND data.begin_age >= :begin_age         AND data.end_age <= :end_age         AND NOT data.deleted         AND NOT rangedata.deleted");
        query.useDatabase(col.getIdentifier().getDatabase());
        query.setInt("range_column_id", col.getIdentifier().getId());
        query.setDouble("begin_age", top);
        query.setDouble("end_age", bottom);
        List<SourceResult> results = query.executeQuery();
        query.close();
        return results;
    }
}

