/*
 * Decompiled with CFR 0.152.
 */
package model.storage;

import java.util.ArrayList;
import java.util.List;
import model.ModelIdentifier;
import model.TransectLine;
import model.TransectPolygonData;
import model.storage.Query;
import model.util.SourceResult;

public class TransectLineStorage {
    public static void insert(TransectLine data) {
        Query query = new Query("INSERT INTO #.transect_lines       (id, transect_polygons_id, type, width_start,         width_stop, age_start, age_stop, deleted)       VALUES (NULL, :transect_polygons_id, :type, :width_start,         :width_stop, :age_start, :age_stop, :deleted)");
        query.useDatabase(data.getIdentifier().getDatabase());
        query.setInt("transect_polygons_id", data.getPolygon().getIdentifier().getId());
        query.setString("type", data.getType());
        query.setDouble("width_start", data.getStartWidth());
        query.setDouble("width_end", data.getEndWidth());
        query.setDouble("age_start", data.getStartAge());
        query.setDouble("age_end", data.getEndAge());
        query.setBoolean("deleted", data.isDeleted());
        query.executeUpdate();
        query.close();
    }

    public static void update(TransectLine data) {
        Query query = new Query("UPDATE #.transect_lines       SET transect_polygons_id = :transect_polygons_id,         type = :type, width_start = :width_start,         width_end = :width_end, age_start = :age_start,         age_end = :age_end       WHERE id = :id");
        query.useDatabase(data.getIdentifier().getDatabase());
        query.setInt("id", data.getIdentifier().getId());
        query.setInt("transect_polygons_id", data.getPolygon().getIdentifier().getId());
        query.setString("type", data.getType());
        query.setDouble("width_start", data.getStartWidth());
        query.setDouble("width_end", data.getEndWidth());
        query.setDouble("age_start", data.getStartAge());
        query.setDouble("age_end", data.getEndAge());
        query.executeUpdate();
        query.close();
    }

    public static List<SourceResult> load(List<ModelIdentifier> ids) {
        ArrayList<SourceResult> results = new ArrayList<SourceResult>();
        Query query = new Query("SELECT start_age, end_age, start_width,              end_width, type, deleted, last_modified, creation_date             FROM #.transect_lines             WHERE id = :id");
        for (int i = 0; i < ids.size(); ++i) {
            ModelIdentifier id = ids.get(i);
            query.useDatabase(id.getDatabase());
            query.setInt("id", id.getId());
            results.addAll(query.executeQuery());
        }
        query.close();
        return results;
    }

    public static List<SourceResult> findByPolygon(TransectPolygonData polygon) {
        Query query = new Query("SELECT '#' AS database, id             FROM #.transect_lines             WHERE transect_polygons_id = :transect_polygons_id");
        query.useDatabase(polygon.getIdentifier().getDatabase());
        query.setInt("transect_lines", polygon.getIdentifier().getId());
        List<SourceResult> results = query.executeQuery();
        query.close();
        return results;
    }
}

