/*
 * Decompiled with CFR 0.152.
 */
package datastore;

import java.awt.Color;
import java.util.ArrayList;

public class Datapoint {
    public static final int SOLID_LINE = 1;
    public static final int DASHED_LINE = 2;
    public static final int DOTTED_LINE = 3;
    public static final int WAVY_LINE = 4;
    public double baseAge = 0.0;
    public boolean isAgeInteger = false;
    public String label = "";
    public Object value = null;
    public Object parameter = null;
    public String direction = null;
    public String popup = null;
    public String SeriesPopup = null;
    public String member = null;
    public int priority = 0;
    public String uncertainty = null;
    public int lineType = 1;
    public String series = "";
    public String pattern = "";
    public String section = null;
    public boolean breaker = false;
    protected static int serial = 0;
    protected int mySerial;
    public Color color = Color.BLACK;
    public ArrayList<String> synonyms = null;

    public Datapoint() {
        this.mySerial = serial++;
    }

    public Datapoint(double age) {
        this.baseAge = age;
        this.mySerial = serial++;
    }

    public Datapoint(Datapoint other) {
        this.label = other.label;
        this.baseAge = other.baseAge;
        this.priority = other.priority;
        this.lineType = other.lineType;
        this.breaker = other.breaker;
        this.series = other.series;
        this.popup = other.popup;
        this.value = other.value;
        this.parameter = other.parameter;
        this.direction = other.direction;
        this.mySerial = serial++;
    }

    public Datapoint copy() {
        Datapoint ret = new Datapoint(this);
        return ret;
    }

    public String toString() {
        return this.label;
    }

    public static class LabelComparator
    extends Comparator
    implements java.util.Comparator<Datapoint> {
        @Override
        public int compare(Datapoint arg0, Datapoint arg1) {
            Datapoint left = arg0;
            Datapoint right = arg1;
            if (left == null || right == null) {
                return 0;
            }
            if (left.label == null || right.label == null) {
                return super.compare(arg0, arg1);
            }
            int ret = left.label.compareToIgnoreCase(right.label);
            if (ret == 0) {
                return super.compare(arg0, arg1);
            }
            return ret;
        }
    }

    public static class Comparator
    implements java.util.Comparator<Datapoint> {
        @Override
        public int compare(Datapoint arg0, Datapoint arg1) {
            Datapoint left = arg0;
            Datapoint right = arg1;
            if (left == null || right == null) {
                return 0;
            }
            double result = left.baseAge - right.baseAge;
            if (result == 0.0 || result > 0.0 && result < 1.0E-6 || result < 0.0 && result > -1.0E-6) {
                return left.mySerial - right.mySerial;
            }
            if (result < 0.0) {
                return -1;
            }
            return 1;
        }
    }
}

