/*
 * Decompiled with CFR 0.152.
 */
package datastore;

import datastore.Coloring;
import datastore.DataColumn;
import datastore.MetaColumn;
import datastore.Unit;
import gui.FontManager;
import gui.ImageGenerator;
import gui.Settings;
import java.awt.Color;
import java.awt.Font;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import path.ResPath;
import util.Debug;
import util.FileUtils;
import util.ProgramInfo;

public class RootColumn
extends MetaColumn {
    public static double HEADER_HEIGHT_MULTIPLIER = 2.0;
    public static double LOGO_HEIGHT_MULTIPLIER = 3.0;
    public static Color HEADER_BGCOLOR = Color.WHITE;
    private double adjustedHeight;

    public RootColumn(String name, Unit unit) {
        super(name);
        this.unit = unit;
        this.adjustedHeight = this.myOwnHeaderHeight * LOGO_HEIGHT_MULTIPLIER;
    }

    public RootColumn(RootColumn other) {
        super(other.name);
        this.unit = other.unit;
        this.adjustedHeight = this.myOwnHeaderHeight * LOGO_HEIGHT_MULTIPLIER;
        this.subColumns.addAll(other.subColumns);
    }

    public RootColumn getChildRoot(Unit qUnit) {
        for (DataColumn dc : this.subColumns) {
            if (!(dc instanceof RootColumn)) continue;
            RootColumn rc = (RootColumn)dc;
            if (!rc.unit.equals(qUnit)) continue;
            return rc;
        }
        return null;
    }

    public DataColumn getFirstChildCol() {
        return (DataColumn)this.subColumns.elementAt(0);
    }

    @Override
    public JPanel getOptionsPanel() {
        if (this.unit != null) {
            return super.getOptionsPanel();
        }
        if (this.optionsPanel == null) {
            this.optionsPanel = new JPanel();
        }
        return this.optionsPanel;
    }

    @Override
    public void drawHeader(ImageGenerator ig, double startx, double starty, double width, double height, Settings settings) {
        String bgStyle = "stroke-width: 0; fill: " + Coloring.getStyleRGB(HEADER_BGCOLOR) + ";";
        URL tsLogo = this.getLogoPath(ResPath.getJarSafeResourceURL("logos.default_tscreator"));
        URL companyLogo = this.getLogoPath(ResPath.getJarSafeResourceURLFromRootlessPath(ProgramInfo.get("TSC_ICON_FILENAME")));
        this.adjustedHeight = this.myOwnHeaderHeight * HEADER_HEIGHT_MULTIPLIER;
        boolean drawImage = false;
        if (tsLogo != null) {
            drawImage = true;
        }
        if (companyLogo == null) {
            companyLogo = tsLogo;
        }
        if (this.myWidth < 0.0) {
            this.myWidth = this.getWidth(settings, ig, height);
        }
        if (this.myHeaderHeight < 0.0) {
            this.myHeaderHeight = this.getHeaderHeight(settings, ig);
        }
        ig.drawRect(startx, starty, width, height, bgStyle);
        FontManager cfr_ignored_0 = settings.fonts;
        Font headerFont = settings.fonts.getFont(0).getFont();
        int fontLength = this.name.length() * headerFont.getSize();
        ig.drawString(this.nameWrap, startx, starty, width, this.adjustedHeight, 3);
        double imageSize = this.myOwnHeaderHeight * LOGO_HEIGHT_MULTIPLIER;
        double minimumHeight = imageSize * 2.0 + (double)fontLength;
        double imagePadding = imageSize * 0.1;
        if (width > minimumHeight && tsLogo != null) {
            ig.drawImage(startx + imagePadding, starty + imagePadding, imageSize - imagePadding, imageSize - imagePadding, tsLogo.toString(), null);
            ig.drawImage(width - imageSize - imagePadding, starty + imagePadding, imageSize - imagePadding, imageSize - imagePadding, companyLogo.toString(), null);
        }
        super.drawHeader(ig, startx, starty + this.adjustedHeight, width, height - this.adjustedHeight, settings);
    }

    @Override
    public double getHeaderHeight(Settings settings, ImageGenerator ig) {
        return super.getHeaderHeight(settings, ig) + this.myOwnHeaderHeight * LOGO_HEIGHT_MULTIPLIER;
    }

    public URL getLogoPath(URL gif_url) {
        InputStream svg_stream;
        String gif_string = gif_url.toString();
        URL svg_url = null;
        try {
            svg_url = new URL(gif_string.substring(0, gif_string.length() - 3) + "svg");
            svg_stream = FileUtils.getInputStream(svg_url.toString());
        }
        catch (Exception e) {
            svg_stream = null;
        }
        if (svg_stream != null) {
            return svg_url;
        }
        URL png_url = null;
        InputStream png_stream = null;
        try {
            png_url = new URL(gif_string.substring(0, gif_string.length() - 3) + "png");
            png_stream = FileUtils.getInputStream(png_url.toString());
        }
        catch (Exception e) {
            png_stream = null;
        }
        if (png_stream != null) {
            return png_url;
        }
        InputStream gif_stream = null;
        File png_converted_file = null;
        URL png_converted_url = null;
        try {
            gif_stream = FileUtils.getInputStream(gif_url.toString());
        }
        catch (Exception e) {
            gif_stream = null;
        }
        if (gif_stream != null) {
            try {
                png_converted_file = File.createTempFile("converted_gif", ".png");
                File temp_gif_file = File.createTempFile("copy_of_gif", ".gif");
                FileOutputStream outstream = new FileOutputStream(temp_gif_file);
                byte[] buf = new byte[1024];
                int num_bytes_read = 0;
                while ((num_bytes_read = gif_stream.read(buf)) > 0) {
                    outstream.write(buf, 0, num_bytes_read);
                }
                outstream.close();
                BufferedImage image = ImageIO.read(temp_gif_file);
                ImageIO.write((RenderedImage)image, "png", png_converted_file);
                png_converted_url = png_converted_file.toURI().toURL();
            }
            catch (Exception ex) {
                Debug.print("Unable to convert gif file to png.  Exception was: " + ex.toString());
                return null;
            }
            Debug.print("Converted gif " + gif_url.toString() + " to png " + png_converted_url.toString());
            return png_converted_url;
        }
        Debug.print("gif_image_path " + gif_url.toString() + " does not exist!");
        return null;
    }
}

