/*
 * Decompiled with CFR 0.152.
 */
package datastore;

import datastore.BlockSeriesMetaColumn;
import datastore.Datapoint;
import datastore.Datastore;
import datastore.RootColumn;
import datastore.Unit;
import gui.Settings;
import gui.settings.SelectedTimes;
import gui.settings.TimesPanel;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.tree.TreeNode;

public class SmartScaleColumn {
    public String fcID = null;
    public Unit fcUnit = null;
    public double fcTop = 0.0;
    public double fcBase = 0.0;
    public int[] scaleArray = null;

    public SmartScaleColumn setSmartColumn(RootColumn root, TimesPanel yTimes, Settings settings, Datastore ds) {
        SmartScaleColumn smartScaleCol = new SmartScaleColumn();
        SelectedTimes sT = new SelectedTimes(yTimes, true);
        Settings setting = Settings.getReadOnlySettings(ds, yTimes.unit, sT, null);
        this.getFaciesColumnDepthRange(root, setting, smartScaleCol);
        this.createSmartScale(smartScaleCol);
        return smartScaleCol;
    }

    private void getFaciesColumnDepthRange(RootColumn rootCol, Settings settings, SmartScaleColumn smartScale) {
        BlockSeriesMetaColumn bsmCol = null;
        Enumeration<TreeNode> e = rootCol.preorderEnumeration();
        double curBase = settings.baseAge;
        while (e.hasMoreElements()) {
            TreeNode col = e.nextElement();
            if (!(col instanceof BlockSeriesMetaColumn)) continue;
            bsmCol = (BlockSeriesMetaColumn)col;
            if (bsmCol.PATTERN_TITLE == "Facies") break;
            bsmCol = null;
        }
        if (bsmCol == null) {
            return;
        }
        smartScale.fcID = bsmCol.id.substring(bsmCol.id.indexOf(":") + 1);
        smartScale.fcUnit = bsmCol.unit;
        Iterator iter = bsmCol.getDrawingData();
        Datapoint tempDP = (Datapoint)iter.next();
        smartScale.fcTop = tempDP.breaker ? tempDP.baseAge : settings.topAge;
        while (iter.hasNext()) {
            tempDP = (Datapoint)iter.next();
            curBase = tempDP.baseAge;
        }
        smartScale.fcBase = curBase;
    }

    /*
     * Unable to fully structure code
     */
    private void createSmartScale(SmartScaleColumn smartScaleCol) {
        division = new int[]{1, 2, 5};
        prevNum = 0;
        prevDiv = 0;
        while (true) {
            for (i = 0; i < division.length; ++i) {
                currNum = (int)(smartScaleCol.fcBase - smartScaleCol.fcTop) / division[i];
                if (currNum >= 30 && currNum <= 40) {
                    this.createScaleArray(division[i], currNum + 1, smartScaleCol);
                    return;
                }
                if (prevNum > 40 && currNum < 30) {
                    this.createScaleArray(prevDiv, prevNum + 1, smartScaleCol);
                    return;
                }
                if (prevNum == 0 && currNum == 0) {
                    this.createScaleArray(1, (int)(smartScaleCol.fcBase - smartScaleCol.fcTop + 1.0), smartScaleCol);
                    return;
                }
                prevNum = currNum;
                prevDiv = division[i];
            }
            j = 0;
            while (true) {
                if (j >= division.length) ** continue;
                division[j] = division[j] * 10;
                ++j;
            }
            break;
        }
    }

    private void createScaleArray(int division, int num, SmartScaleColumn ssCol) {
        ScaleInfo scaleInfo = this.getScaleInfo(division, (int)ssCol.fcTop);
        ssCol.scaleArray = new int[num];
        if (scaleInfo.numZeroDivision != 0 && scaleInfo.numDigitTop - scaleInfo.numDigitDivision > 0) {
            int start;
            String str = Integer.toString((int)ssCol.fcTop).substring(0, scaleInfo.numDigitTop - scaleInfo.numDigitDivision);
            if (str.length() == 0) {
                str = "0";
            }
            ssCol.scaleArray[0] = start = (int)Math.pow(10.0, scaleInfo.numDigitDivision) * Integer.parseInt(str) + scaleInfo.smartValue * (int)Math.pow(10.0, scaleInfo.numZeroDivision);
        } else {
            int myStarter;
            ssCol.scaleArray[0] = -1.0 * ssCol.fcTop > -1.0 * ssCol.fcBase ? (myStarter = (int)ssCol.fcBase * -1) : 0;
        }
        for (int i = 1; i < num; ++i) {
            ssCol.scaleArray[i] = ssCol.scaleArray[i - 1] + division;
        }
    }

    private ScaleInfo getScaleInfo(int divValue, int rangeValue) {
        ScaleInfo scaleInfo = new ScaleInfo();
        scaleInfo.smartValue = this.findSmartValue(divValue, rangeValue);
        while (divValue > 0 && divValue % 10 == 0) {
            scaleInfo.numZeroDivision++;
            divValue /= 10;
        }
        scaleInfo.numDigitDivision = scaleInfo.numZeroDivision + 1;
        while (rangeValue > 0) {
            rangeValue /= 10;
            scaleInfo.numDigitTop++;
        }
        return scaleInfo;
    }

    private int findSmartValue(int divValue, int rangeValue) {
        int num = 0;
        while (divValue > 0) {
            if (divValue % 10 == 0) {
                divValue /= 10;
                ++num;
                continue;
            }
            divValue %= 10;
            break;
        }
        while (num > 0) {
            rangeValue /= 10;
            if (num == 1) {
                rangeValue %= 10;
                break;
            }
            --num;
        }
        if (divValue == 2) {
            switch (rangeValue) {
                case 0: {
                    return 0;
                }
                case 1: 
                case 2: {
                    return 2;
                }
                case 3: 
                case 4: {
                    return 4;
                }
                case 5: 
                case 6: {
                    return 6;
                }
                case 7: 
                case 8: {
                    return 8;
                }
                case 9: {
                    return 10;
                }
            }
        } else if (divValue == 5) {
            switch (rangeValue) {
                case 0: 
                case 1: 
                case 2: {
                    return 0;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    return 5;
                }
                case 9: {
                    return 10;
                }
            }
        } else {
            return rangeValue;
        }
        return num;
    }

    private class ScaleInfo {
        private int numZeroDivision = 0;
        private int numDigitDivision = 0;
        private int numDigitTop = 0;
        private int smartValue = 0;

        private ScaleInfo() {
        }
    }
}

