/*
 * Decompiled with CFR 0.152.
 */
package datastore.ages;

import datastore.ages.AgeConverter;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import util.NumberUtils;

public class InterpolateAgeConverter
extends AgeConverter {
    protected List<Waypoint> waypoints = new Vector<Waypoint>();
    protected boolean cacheStale = false;
    protected double[] keyCache = null;
    protected double[] valueCache = null;

    public void addWayPoint(double inAge, double outAge) {
        Waypoint w = new Waypoint();
        w.in = inAge;
        w.out = outAge;
        this.waypoints.add(w);
        this.cacheStale = true;
    }

    protected void updateCache() {
        if (this.waypoints.size() == 0) {
            this.valueCache = null;
            this.keyCache = null;
            return;
        }
        this.keyCache = new double[this.waypoints.size()];
        this.valueCache = new double[this.waypoints.size()];
        Collections.sort(this.waypoints);
        Iterator<Waypoint> entryIter = this.waypoints.iterator();
        int i = 0;
        while (entryIter.hasNext()) {
            Waypoint entry = entryIter.next();
            this.keyCache[i] = entry.in;
            this.valueCache[i] = entry.out;
            ++i;
        }
        this.cacheStale = false;
    }

    @Override
    public double convertAge(double inAge, int direction) {
        if (this.cacheStale) {
            this.updateCache();
        }
        if (this.keyCache == null) {
            return inAge;
        }
        if (this.keyCache.length == 1) {
            return inAge + this.keyCache[0];
        }
        if (inAge < this.keyCache[0]) {
            double slope = (this.valueCache[0] - this.valueCache[1]) / (this.keyCache[0] - this.keyCache[1]);
            return this.valueCache[0] - slope * (this.keyCache[0] - inAge);
        }
        if (inAge > this.keyCache[this.keyCache.length - 1]) {
            int last = this.keyCache.length - 1;
            double slope = (this.valueCache[last] - this.valueCache[last - 1]) / (this.keyCache[last] - this.keyCache[last - 1]);
            return this.valueCache[last] + slope * (inAge - this.keyCache[last]);
        }
        int below = 0;
        int above = this.keyCache.length - 1;
        int pivot = this.keyCache.length / 2;
        while (above - below > 1) {
            if (NumberUtils.isEqual(inAge, this.keyCache[pivot])) {
                if (pivot < this.keyCache.length - 1 && NumberUtils.isEqual(this.keyCache[pivot], this.keyCache[pivot + 1])) {
                    if (direction > 0) {
                        return this.valueCache[pivot + 1];
                    }
                    return this.valueCache[pivot];
                }
                if (pivot > 0 && NumberUtils.isEqual(this.keyCache[pivot], this.keyCache[pivot - 1])) {
                    if (direction > 0) {
                        return this.valueCache[pivot];
                    }
                    return this.valueCache[pivot - 1];
                }
                return this.valueCache[pivot];
            }
            if (inAge > this.keyCache[pivot]) {
                below = pivot;
            } else {
                above = pivot;
            }
            pivot = (above + below) / 2;
        }
        double slope = (this.valueCache[above] - this.valueCache[below]) / (this.keyCache[above] - this.keyCache[below]);
        double outAge = this.valueCache[below] + slope * (inAge - this.keyCache[below]);
        if (!NumberUtils.isEqual(this.valueCache[above], this.valueCache[below] + slope * (this.keyCache[above] - this.keyCache[below]))) {
            System.err.println("I can't add!!");
        }
        return outAge;
    }

    @Override
    public List<AgeConverter.Gap> getGaps() {
        Vector<AgeConverter.Gap> gaps = null;
        if (this.cacheStale) {
            this.updateCache();
        }
        if (this.keyCache == null || this.keyCache.length <= 1) {
            return null;
        }
        for (int i = 1; i < this.keyCache.length; ++i) {
            if (i < 1 || !NumberUtils.isEqual(this.keyCache[i], this.keyCache[i - 1])) continue;
            AgeConverter.Gap g = new AgeConverter.Gap();
            g.gapKey = this.keyCache[i];
            g.gapValueBase = this.valueCache[i];
            g.gapValueTop = this.valueCache[i - 1];
            if (g.gapValueTop > g.gapValueBase) {
                g.gapValueBase = this.valueCache[i - 1];
                g.gapValueTop = this.valueCache[i];
            }
            if (gaps == null) {
                gaps = new Vector<AgeConverter.Gap>();
            }
            gaps.add(g);
        }
        return gaps;
    }

    public String checkForErrors() {
        if (this.cacheStale) {
            this.updateCache();
        }
        if (this.keyCache == null || this.keyCache.length <= 1) {
            return null;
        }
        for (int i = 1; i < this.keyCache.length; ++i) {
            if (this.valueCache[i] < this.valueCache[i - 1]) {
                return "The converted ages are not monotonically increasing: " + this.keyCache[i - 1] + "=>" + this.valueCache[i - 1] + " should be smaller than " + this.keyCache[i] + "=>" + this.valueCache[i];
            }
            if (i < 2 || !NumberUtils.isEqual(this.keyCache[i], this.keyCache[i - 2])) continue;
            return "The in-value " + this.keyCache[i] + " appears more than twice.";
        }
        return null;
    }

    public String checkForErrors(boolean isOutcrop) {
        if (this.cacheStale) {
            this.updateCache();
        }
        if (this.keyCache == null || this.keyCache.length <= 1) {
            return null;
        }
        for (int i = 1; i < this.keyCache.length; ++i) {
            if (this.valueCache[i] < this.valueCache[i - 1] && !isOutcrop) {
                return "The converted ages are not monotonically increasing: " + this.keyCache[i - 1] + "=>" + this.valueCache[i - 1] + " should be smaller than " + this.keyCache[i] + "=>" + this.valueCache[i];
            }
            if (i < 2 || !NumberUtils.isEqual(this.keyCache[i], this.keyCache[i - 2])) continue;
            return "The in-value " + this.keyCache[i] + " appears more than twice.";
        }
        return null;
    }

    protected static class Waypoint
    implements Comparable {
        double in;
        double out;

        protected Waypoint() {
        }

        public int compareTo(Object arg) {
            if (!(arg instanceof Waypoint)) {
                return 0;
            }
            Waypoint w = (Waypoint)arg;
            double diff = this.in - w.in;
            if (NumberUtils.isEqual(diff, 0.0)) {
                diff = this.out - w.out;
            }
            if (diff == 0.0) {
                return 0;
            }
            if (diff < 0.0) {
                return -1;
            }
            return 1;
        }
    }
}

