/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.FontManager;
import gui.Language;
import gui.ModifyTextField;
import gui.SpringUtilities;
import gui.TSCFont;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.SpringLayout;

public class FontOptions
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected FontManager fm;
    protected JPanel addPanel = this;

    public FontOptions(FontManager fm) {
        this.fm = fm;
        this.setLayout(new BoxLayout(this, 1));
    }

    public JPanel getAddPanel() {
        return this.addPanel;
    }

    public JPanel addNestedAddPanel() {
        JPanel oldAddPanel = this.addPanel;
        this.addPanel = new JPanel();
        oldAddPanel.add(this.addPanel);
        return this.addPanel;
    }

    public void addOptions(int[] relevantFonts, boolean bindToBottom, boolean enInheritable) {
        JPanel p = new JPanel(new SpringLayout());
        p.add(new JLabel(Language.translate("Change Font", true)));
        p.add(new JLabel(""));
        p.add(new JLabel(Language.translate("Font Face", true)));
        p.add(new JLabel(Language.translate("Size", true)));
        p.add(new JLabel());
        p.add(new JLabel());
        p.add(new JLabel(Language.translate("Color", true)));
        p.add(new JLabel());
        for (int i = 0; i < relevantFonts.length; ++i) {
            new SingleFontOptions(this.fm, relevantFonts[i], p, enInheritable);
        }
        SpringUtilities.makeCompactGrid(p, relevantFonts.length + 1, 8, 5, 5, 5, 5, bindToBottom);
        this.addPanel.add(p);
    }

    public class SingleFontOptions
    implements ActionListener,
    MouseListener {
        public FontManager fm;
        public int whichFont;
        public TSCFont chosenFont;
        JCheckBox overrideDefaultCB;
        JCheckBox inheritableCB;
        JComboBox fontNameCB;
        ModifyTextField fontSizeTF;
        JToggleButton boldCB;
        JToggleButton italicCB;
        JLabel preview;
        boolean enInheritable = true;
        JPanel textColor;

        public SingleFontOptions(FontManager fm, int whichFont, JComponent comp, boolean enInheritable) {
            this.fm = fm;
            this.whichFont = whichFont;
            this.enInheritable = enInheritable;
            this.chosenFont = new TSCFont(fm.getFont(whichFont));
            String label = FontManager.fontFunctions[whichFont];
            this.overrideDefaultCB = new JCheckBox(Language.translate(label, true) + ": ");
            this.inheritableCB = new JCheckBox(Language.translate("Inheritable", true));
            String[] fontFamilies = new String[]{"Arial", "Courier", "Verdana"};
            this.fontNameCB = new JComboBox<String>(fontFamilies);
            Dimension d = this.fontNameCB.getPreferredSize();
            d.width = 100;
            this.fontNameCB.setMaximumSize(d);
            int selIndex = 0;
            for (int i = 0; i < fontFamilies.length; ++i) {
                if (!fontFamilies[i].equals(this.chosenFont.getFamily())) continue;
                selIndex = i;
                break;
            }
            this.fontNameCB.setSelectedIndex(selIndex);
            this.fontNameCB.addActionListener(this);
            this.fontSizeTF = new ModifyTextField(true, true);
            d = this.fontSizeTF.getPreferredSize();
            d.width = 40;
            this.fontSizeTF.setPreferredSize(d);
            this.fontSizeTF.setMaximumSize(d);
            this.fontSizeTF.setText("" + fm.getFont(whichFont).getSizeInt());
            this.fontSizeTF.addActionListener(this);
            this.boldCB = new JToggleButton("B");
            this.boldCB.setSelected(fm.getFont(whichFont).isBold());
            this.boldCB.setFont(new Font("Times", 1, 12));
            this.boldCB.addActionListener(this);
            this.italicCB = new JToggleButton("I");
            this.italicCB.setSelected(fm.getFont(whichFont).isItalic());
            this.italicCB.setFont(new Font("Times", 2, 12));
            this.italicCB.addActionListener(this);
            this.textColor = new JPanel();
            d = this.textColor.getPreferredSize();
            d.width = 20;
            this.textColor.setPreferredSize(d);
            this.textColor.setMaximumSize(d);
            this.textColor.setBackground(this.chosenFont.getColor());
            JPanel panel = new JPanel(new SpringLayout());
            this.preview = new JLabel(Language.translate("Sample text", true));
            d = this.fontSizeTF.getPreferredSize();
            d.width = 100;
            panel.setPreferredSize(d);
            panel.add(this.preview);
            comp.add(this.overrideDefaultCB);
            comp.add(this.inheritableCB);
            comp.add(this.fontNameCB);
            comp.add(this.fontSizeTF);
            comp.add(this.boldCB);
            comp.add(this.italicCB);
            comp.add(this.textColor);
            comp.add(panel);
            this.preview.setFont(this.chosenFont.getFont());
            this.preview.setForeground(this.chosenFont.getColor());
            this.overrideDefaultCB.addActionListener(this);
            if (fm.chosenFonts[whichFont] == null) {
                this.overrideDefaultCB.setSelected(false);
                this.setEnabled(false);
            } else {
                this.overrideDefaultCB.setSelected(true);
                this.setEnabled(true);
            }
            this.inheritableCB.addActionListener(this);
            if (fm.inheritable[whichFont] || !enInheritable) {
                this.inheritableCB.setSelected(true);
                fm.inheritable[whichFont] = true;
            } else {
                this.inheritableCB.setSelected(false);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Color textColorChoice;
            Color initColor = Color.BLACK;
            if (this.fm.getFont(this.whichFont).getColor() != null) {
                initColor = this.fm.getFont(this.whichFont).getColor();
            }
            if ((textColorChoice = JColorChooser.showDialog(this.textColor, "Choose Font Color", initColor)) != null) {
                initColor = textColorChoice;
            }
            this.textColor.setBackground(initColor);
            this.chosenFont.setColor(initColor);
            this.preview.setForeground(initColor);
            this.fm.setFont(this.whichFont, this.chosenFont);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Object source = ae.getSource();
            if (source == this.fontNameCB) {
                this.chosenFont.family = (String)this.fontNameCB.getSelectedItem();
                this.fm.setFont(this.whichFont, this.chosenFont);
            } else if (source == this.fontSizeTF) {
                try {
                    this.chosenFont.size = Double.parseDouble(this.fontSizeTF.getText());
                }
                catch (Exception e) {
                    this.chosenFont.size = 1.0;
                }
                this.fm.setFont(this.whichFont, this.chosenFont);
            } else if (source == this.boldCB) {
                int type = this.chosenFont.getStyle();
                type = this.boldCB.isSelected() ? (type |= 1) : (type &= 0xFFFFFFFE);
                this.chosenFont.setStyle(type);
                this.fm.setFont(this.whichFont, this.chosenFont);
            } else if (source == this.italicCB) {
                int type = this.chosenFont.getStyle();
                type = this.italicCB.isSelected() ? (type |= 2) : (type &= 0xFFFFFFFD);
                this.chosenFont.setStyle(type);
                this.fm.setFont(this.whichFont, this.chosenFont);
            } else if (source == this.overrideDefaultCB) {
                if (!this.overrideDefaultCB.isSelected()) {
                    this.fm.resetFont(this.whichFont);
                    this.setEnabled(false);
                } else {
                    this.fm.setFont(this.whichFont, this.chosenFont);
                    this.setEnabled(true);
                }
            } else if (source == this.inheritableCB) {
                this.fm.inheritable[this.whichFont] = this.inheritableCB.isSelected();
            }
            this.preview.setFont(this.fm.getFont(this.whichFont).getFont());
        }

        public final void setEnabled(boolean en) {
            this.inheritableCB.setEnabled(en && this.enInheritable);
            this.fontNameCB.setEnabled(en);
            this.fontSizeTF.setEnabled(en);
            this.boldCB.setEnabled(en);
            this.italicCB.setEnabled(en);
            this.textColor.setEnabled(en);
            if (en) {
                this.textColor.addMouseListener(this);
            } else {
                this.textColor.removeMouseListener(this);
            }
        }
    }
}

