/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import util.Debug;
import util.HTMLPreprocessor;

public class HTMLViewerDialog
extends JFrame {
    private static final long serialVersionUID = 1L;
    private Desktop desktop = Desktop.getDesktop();
    private URL base;

    public HTMLViewerDialog(String title, String file, int width, int height) {
        this(title, file, width, height, "text/html");
    }

    public HTMLViewerDialog(String title, String file, int width, int height, String contentType) {
        JEditorPane htmlPane = new JEditorPane();
        htmlPane.setEditable(false);
        if (contentType != null) {
            htmlPane.setContentType(contentType);
        } else {
            htmlPane.setContentType("text/html");
        }
        ((HTMLDocument)htmlPane.getDocument()).setBase(HTMLPreprocessor.getGlobalBaseDirectory());
        this.base = ((HTMLDocument)htmlPane.getDocument()).getBase();
        try {
            htmlPane.setText(HTMLPreprocessor.process(file));
            Document doc = htmlPane.getDocument();
            doc.putProperty("stream", null);
        }
        catch (Exception e) {
            Debug.critical("Unable to set text for new HTML pane.  Exception was: " + e.toString());
        }
        htmlPane.setPreferredSize(new Dimension(width, height));
        htmlPane.addHyperlinkListener(new Hyperactive());
        this.setTitle(title);
        JScrollPane scrollPane = new JScrollPane(htmlPane);
        this.getContentPane().add(scrollPane);
        Rectangle visible = htmlPane.getVisibleRect();
        visible.y = 0;
        scrollPane.scrollRectToVisible(visible);
        this.pack();
    }

    class Hyperactive
    implements HyperlinkListener {
        Hyperactive() {
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                JEditorPane pane = (JEditorPane)e.getSource();
                if (e instanceof HTMLFrameHyperlinkEvent) {
                    HTMLFrameHyperlinkEvent evt = (HTMLFrameHyperlinkEvent)e;
                    HTMLDocument doc = (HTMLDocument)pane.getDocument();
                    doc.processHTMLFrameHyperlinkEvent(evt);
                } else {
                    try {
                        URI uri;
                        Document doc = pane.getDocument();
                        doc.putProperty("stream", null);
                        ((HTMLDocument)pane.getDocument()).setBase(HTMLViewerDialog.this.base);
                        HyperlinkEvent hevt = e;
                        if (hevt.getURL().toString().contains("contact_form")) {
                            try {
                                uri = new URI("https://timescalecreator.org/contactus/contactus.php");
                                Desktop.getDesktop().browse(uri);
                            }
                            catch (IOException ioe) {
                                ioe.printStackTrace();
                            }
                        }
                        if (hevt.getURL().toString().contains("joggEmail")) {
                            try {
                                uri = URI.create("mailto:jogg@purdue.edu");
                                Desktop.getDesktop().mail(uri);
                            }
                            catch (IOException ioe) {
                                ioe.printStackTrace();
                            }
                        }
                        if (hevt.getURL().toString().contains("aultEmail")) {
                            try {
                                uri = URI.create("mailto:ault@purdue.edu");
                                Desktop.getDesktop().mail(uri);
                            }
                            catch (IOException ioe) {
                                ioe.printStackTrace();
                            }
                        }
                        if (hevt.getURL().toString().contains("forum")) {
                            try {
                                uri = new URI("https://timescalecreator.org/forum/forum.php");
                                Desktop.getDesktop().browse(uri);
                            }
                            catch (IOException ioe) {
                                ioe.printStackTrace();
                            }
                        }
                        if (hevt.getURL().toString().contains("Overview_MakingSimpleDatapacks_6Aug2017.pdf")) {
                            try {
                                uri = new URI("https://timescalecreator.org/manual/TSC_Tour_Exercises_28Aug2017.pdf");
                                Desktop.getDesktop().browse(uri);
                                HTMLViewerDialog.this.dispose();
                            }
                            catch (IOException ioe) {
                                ioe.printStackTrace();
                            }
                        }
                        if (hevt.getURL().toString().contains("jump_to_download")) {
                            try {
                                uri = new URI("https://timescalecreator.org/download/download.php");
                                Desktop.getDesktop().browse(uri);
                                HTMLViewerDialog.this.dispose();
                            }
                            catch (IOException ioe) {
                                ioe.printStackTrace();
                            }
                        }
                        if (hevt.getURL().toString().contains("tscreator_homepage")) {
                            try {
                                uri = new URI("https://timescalecreator.org/index/index.php");
                                Desktop.getDesktop().browse(uri);
                                HTMLViewerDialog.this.dispose();
                            }
                            catch (IOException ioe) {
                                ioe.printStackTrace();
                            }
                        }
                        if (hevt.getURL().toString().contains("sample_datafile_text.html")) {
                            try {
                                uri = new URI("https://timescalecreator.org/resources/sample_datafile_text.html");
                                Desktop.getDesktop().browse(uri);
                            }
                            catch (IOException ioe) {
                                ioe.printStackTrace();
                            }
                        }
                        if (hevt.getURL().toString().contains("sample_datafile_table.html")) {
                            try {
                                uri = new URI("https://timescalecreator.org/resources/sample_datafile_table.html");
                                Desktop.getDesktop().browse(uri);
                            }
                            catch (IOException ioe) {
                                ioe.printStackTrace();
                            }
                        }
                    }
                    catch (Throwable t) {
                        t.printStackTrace(System.out);
                    }
                }
            }
        }
    }
}

