/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.Stats;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class LASConverter {
    LASConverter() {
    }

    public List<String> readfile(String filename) {
        String lines = "";
        try {
            FileReader in = new FileReader(filename);
            BufferedReader br = new BufferedReader(in);
            ArrayList<String> contentList = new ArrayList<String>();
            while ((lines = br.readLine()) != null) {
                contentList.add(" " + lines);
            }
            in.close();
            return contentList;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<String> getUnits(List<String> contentList) {
        ArrayList<String> units = new ArrayList<String>();
        int j = 0;
        for (int i = 0; i < contentList.size(); ++i) {
            if (!contentList.get(i).contains("#-") || !contentList.get(i + 1).toLowerCase().contains("depth.") && !contentList.get(i + 1).toLowerCase().contains("dept.") || !contentList.get(i + 2).contains(".")) continue;
            j = i;
            while (!contentList.get(j).contains("~")) {
                if (contentList.get(++j).contains("#")) continue;
                units.add(contentList.get(j));
            }
        }
        units.remove(units.size() - 1);
        ArrayList<String> unitsFinal = new ArrayList<String>();
        for (int i = 0; i < units.size(); ++i) {
            String temp = ((String)units.get(i)).split("\\:")[0].replaceAll("\\d", "");
            unitsFinal.add(temp.replaceAll("\\s", ""));
        }
        return unitsFinal;
    }

    public String getAgeUnit(String ageUnitString) {
        if (ageUnitString.contains(".")) {
            ArrayList<String> ageUnitList = new ArrayList<String>(Arrays.asList(ageUnitString.split("\\.")));
            String ageUnit = "";
            ageUnit = ((String)ageUnitList.get(1)).equalsIgnoreCase("M") || ((String)ageUnitList.get(1)).equalsIgnoreCase("meters") ? "meters" : (((String)ageUnitList.get(1)).equalsIgnoreCase("FT") || ((String)ageUnitList.get(1)).equalsIgnoreCase("feet") || ((String)ageUnitList.get(1)).equalsIgnoreCase("F") ? "feet" : (String)ageUnitList.get(1));
            return ageUnit;
        }
        return null;
    }

    public List<List<String>> fileProcessing(List<String> contentList, List<String> header) {
        ArrayList<String> contentListm = new ArrayList<String>();
        for (String i : contentList) {
            i = " " + i + " ";
            contentListm.add(i);
        }
        ArrayList<List<String>> fileList = new ArrayList<List<String>>();
        int headerLength = header.size();
        for (int i = 0; i < contentList.size(); ++i) {
            if (i <= headerLength) continue;
            ArrayList<String> tokens = new ArrayList<String>(Arrays.asList(contentList.get(i).split("\\s+")));
            tokens.remove(0);
            fileList.add(tokens);
        }
        return fileList;
    }

    public List<Integer> getMaxPoint(List<List<String>> fileList) {
        int i;
        int i2;
        ArrayList<Integer> maxPoints = new ArrayList<Integer>();
        ArrayList<Double> medianList = new ArrayList<Double>();
        ArrayList<Double> stdevList = new ArrayList<Double>();
        ArrayList<Double> rawList = new ArrayList<Double>();
        ArrayList<Double> corrList = new ArrayList<Double>();
        ArrayList<Double> corrListFinal = new ArrayList<Double>();
        int col = fileList.get(0).size();
        int row = fileList.size();
        for (int i3 = 0; i3 < col - 1; ++i3) {
            for (int j = 0; j < row; ++j) {
                if (!(Double.parseDouble(fileList.get(j).get(i3 + 1)) > 0.0)) continue;
                rawList.add(Double.parseDouble(fileList.get(j).get(i3 + 1)));
            }
            medianList.add(Stats.median(rawList));
            stdevList.add(Stats.stdev(rawList));
            rawList.clear();
        }
        ArrayList reconListLong = new ArrayList();
        for (i2 = 0; i2 < col - 1; ++i2) {
            ArrayList<Double> reconList = new ArrayList<Double>();
            for (int j = 0; j < row; ++j) {
                if (!(Double.parseDouble(fileList.get(j).get(i2 + 1)) < (Double)medianList.get(i2) + 2.0 * (Double)stdevList.get(i2)) || !(Double.parseDouble(fileList.get(j).get(i2 + 1)) > 0.0)) continue;
                reconList.add(Double.parseDouble(fileList.get(j).get(i2 + 1)));
            }
            reconListLong.add(reconList);
        }
        medianList.clear();
        stdevList.clear();
        for (i2 = 0; i2 < reconListLong.size(); ++i2) {
            for (int j = 0; j < ((List)reconListLong.get(i2)).size(); ++j) {
                corrList.add((Double)((List)reconListLong.get(i2)).get(j));
            }
            medianList.add(Stats.median(corrList));
            stdevList.add(Stats.stdev(corrList));
            corrList.clear();
        }
        ArrayList reconListLongFinal = new ArrayList();
        for (i = 0; i < reconListLong.size(); ++i) {
            ArrayList reconList = new ArrayList();
            for (int j = 0; j < ((List)reconListLong.get(i)).size(); ++j) {
                if (!((Double)((List)reconListLong.get(i)).get(j) < (Double)medianList.get(i) + 2.0 * (Double)stdevList.get(i))) continue;
                reconList.add(((List)reconListLong.get(i)).get(j));
            }
            reconListLongFinal.add(reconList);
        }
        medianList.clear();
        stdevList.clear();
        for (i = 0; i < reconListLongFinal.size(); ++i) {
            for (int j = 0; j < ((List)reconListLongFinal.get(i)).size(); ++j) {
                corrListFinal.add((Double)((List)reconListLongFinal.get(i)).get(j));
            }
            medianList.add(Stats.median(corrListFinal));
            stdevList.add(Stats.stdev(corrListFinal));
            corrListFinal.clear();
        }
        for (i = 0; i < medianList.size(); ++i) {
            maxPoints.add((int)(2.0 * ((Double)medianList.get(i) + 2.0 * (Double)stdevList.get(i))));
        }
        return maxPoints;
    }

    public void writeFile(List<List<String>> fileList, String outputFile, List<String> units, String ageUnit, List<String> titles, List<String> widths, List<String> colors, List<String> points, List<String> lines, List<String> fills, List<String> lows, List<String> highs, List<String> smootheds, double top, double base, double scale, String title) {
        try {
            int i;
            PrintWriter writer = new PrintWriter(outputFile);
            String outputStream = "";
            String unitString = "";
            int row = fileList.size();
            int col = fileList.get(0).size();
            units.remove(0);
            List<Object> gapIndices = new ArrayList();
            boolean p = false;
            ArrayList<Integer> highsInt = new ArrayList<Integer>();
            for (String i2 : highs) {
                highsInt.add(Integer.parseInt(i2));
            }
            for (i = 0; i < units.size(); ++i) {
                unitString = units.get(i) + "\t";
            }
            gapIndices = this.getGaps(fileList, highsInt, row, col);
            outputStream = outputStream + "age units:\t" + ageUnit + "\r\n";
            outputStream = outputStream + "SetTop:\t" + top + "\r\n";
            outputStream = outputStream + "SetBase:\t" + base + "\r\n";
            outputStream = outputStream + "SetScale:\t" + scale + "\r\n";
            outputStream = outputStream + "chart title:\t" + title + "\r\n\r\n";
            outputStream = outputStream + title + "\t:\t" + unitString + "\r\n";
            for (i = 0; i < col - 1; ++i) {
                p = false;
                outputStream = outputStream + "\r\n";
                outputStream = outputStream + titles.get(i) + "\tpoint\t" + widths.get(i) + "\t" + colors.get(i) + "\r\n";
                outputStream = outputStream + points.get(i) + "\t" + lines.get(i) + "\t" + fills.get(i) + "\t" + lows.get(i) + "\t" + highs.get(i) + "\t" + smootheds.get(i);
                outputStream = outputStream + "\r\n";
                for (int j = 0; j < row; ++j) {
                    if (gapIndices.contains(j - 1) && Double.parseDouble(fileList.get(j - 1).get(i + 1)) > (double)((Integer)highsInt.get(i)).intValue()) {
                        outputStream = outputStream + "\t" + fileList.get(j).get(0) + "\t" + fileList.get(j).get(i + 1) + "\tgap\r\n";
                        continue;
                    }
                    if (!(Double.parseDouble(fileList.get(j).get(i + 1)) < (double)((Integer)highsInt.get(i)).intValue())) continue;
                    outputStream = outputStream + "\t" + fileList.get(j).get(0) + "\t" + fileList.get(j).get(i + 1) + "\r\n";
                }
            }
            writer.println(outputStream);
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<Integer> getGaps(List<List<String>> fileList, List<Integer> maxPoints, int row, int col) {
        ArrayList<Integer> outOfBoundIndices = new ArrayList<Integer>();
        HashSet<Integer> hs = new HashSet<Integer>();
        for (int i = 0; i < col - 1; ++i) {
            for (int j = 0; j < row; ++j) {
                if (!(Double.parseDouble(fileList.get(j).get(i + 1)) > (double)maxPoints.get(i).intValue())) continue;
                outOfBoundIndices.add(j);
            }
        }
        outOfBoundIndices.add(0);
        int maxLength = 14;
        int count = 0;
        ArrayList<Integer> gapIndices = new ArrayList<Integer>();
        block2: for (int i = 0; i < outOfBoundIndices.size(); ++i) {
            count = 0;
            for (int j = 0; j < outOfBoundIndices.size() - i; ++j) {
                if (count < maxLength) {
                    if ((Integer)outOfBoundIndices.get(i + j) != (Integer)outOfBoundIndices.get(i) + j) continue block2;
                    ++count;
                    continue;
                }
                if ((Integer)outOfBoundIndices.get(i + j) == (Integer)outOfBoundIndices.get(i) + j) continue;
                gapIndices.add((Integer)outOfBoundIndices.get(i + j - 1));
                count = 0;
            }
        }
        hs.addAll(gapIndices);
        gapIndices.clear();
        gapIndices.addAll(hs);
        Collections.sort(gapIndices);
        return gapIndices;
    }

    public List<String> getHeader(List<String> contentList) {
        ArrayList<String> headerList = new ArrayList<String>();
        for (int i = 0; i < contentList.size() && !contentList.get(i).contains("~A"); ++i) {
            headerList.add(contentList.get(i));
        }
        return headerList;
    }

    public double getTop(List<String> header) {
        double top = 0.0;
        String start = "";
        Pattern ptrn = Pattern.compile("\\w+(\\d+(\\.\\d*)?)\\w+");
        for (String i : header) {
            if (!i.contains("STRT")) continue;
            Matcher matcher = ptrn.matcher(i);
            matcher.find();
            start = matcher.group();
            break;
        }
        top = (double)Math.round(Double.parseDouble(start) * 100.0) / 100.0;
        return top;
    }

    public double getBase(List<String> header) {
        double base = 0.0;
        String end = "";
        Pattern ptrn = Pattern.compile("\\w+(\\d+(\\.\\d*)?)\\w+");
        for (String i : header) {
            if (!i.contains("STOP")) continue;
            Matcher matcher = ptrn.matcher(i);
            System.out.println(i);
            matcher.find();
            end = matcher.group();
            break;
        }
        base = (double)Math.round(Double.parseDouble(end) * 100.0) / 100.0;
        return base;
    }

    public double getScale(double top, double base) {
        double scale = 40.0 / (base - top);
        scale = (scale = (double)Math.round(scale * 100.0) / 100.0) < 0.05 ? 0.05 : scale;
        System.out.println(scale);
        return scale;
    }

    public int getColumnCount(List<String> units) {
        if (units.size() - 1 <= 0) {
            return 0;
        }
        int size = units.size() - 1;
        return units.size() - 1;
    }
}

