/*
 * Decompiled with CFR 0.152.
 */
package gui;

import datastore.PatternManager;
import gui.ActionDialog;
import gui.ExtensionFileFilter;
import gui.ImageGenerator;
import gui.TSCSVGCanvas;
import gui.TSCSVGScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import org.apache.batik.swing.gvt.GVTTreeRendererAdapter;
import org.apache.batik.swing.gvt.GVTTreeRendererEvent;
import org.w3c.dom.svg.SVGDocument;
import util.FileUtils;

public class PatternViewer
extends JFrame {
    private static final long serialVersionUID = 1L;
    protected PatternManager patMan;
    TSCSVGCanvas displayCanvas;
    TSCSVGScrollPane displayCanvasPane;
    SVGDocument doc;
    final Object docLock = new Object();
    private JPanel theContentPane = null;
    private JPanel infoPanel = null;
    private JLabel jLabel = null;
    private JButton saveSVG = null;
    private JToggleButton howToEdit = null;
    private JPanel jPanel = null;
    private JLabel howToLabel = null;
    private JPanel displayPanel = null;

    public PatternViewer(PatternManager patMan) {
        this.patMan = patMan;
        this.initialize();
    }

    private void initialize() {
        this.setSize(644, 314);
        this.setContentPane(this.getTheContentPane());
        this.setTitle("Pattern Viewer");
    }

    private JPanel getTheContentPane() {
        if (this.theContentPane == null) {
            BorderLayout borderLayout = new BorderLayout();
            borderLayout.setHgap(0);
            borderLayout.setVgap(0);
            this.theContentPane = new JPanel();
            this.theContentPane.setLayout(borderLayout);
            this.theContentPane.add((Component)this.getJPanel(), "North");
            this.theContentPane.add((Component)this.getDisplayPanel(), "Center");
        }
        return this.theContentPane;
    }

    private JPanel getInfoPanel() {
        if (this.infoPanel == null) {
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 3;
            gridBagConstraints3.insets = new Insets(0, 10, 0, 0);
            gridBagConstraints3.gridy = 0;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.gridy = 0;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.insets = new Insets(0, 10, 0, 0);
            gridBagConstraints.gridy = 0;
            this.jLabel = new JLabel();
            this.jLabel.setText("Save this as an SVG file:");
            this.infoPanel = new JPanel();
            this.infoPanel.setLayout(new GridBagLayout());
            this.infoPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.infoPanel.add((Component)this.jLabel, gridBagConstraints1);
            this.infoPanel.add((Component)this.getSaveSVG(), gridBagConstraints);
            this.infoPanel.add((Component)this.getHowToEdit(), gridBagConstraints3);
        }
        return this.infoPanel;
    }

    private JButton getSaveSVG() {
        if (this.saveSVG == null) {
            this.saveSVG = new JButton();
            this.saveSVG.setText("Save as SVG...");
            this.saveSVG.setEnabled(false);
            this.saveSVG.addActionListener(new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent e) {
                    JFileChooser chooser = new JFileChooser();
                    ExtensionFileFilter eff = new ExtensionFileFilter();
                    eff.setDescription("SVG file (*.svg)");
                    eff.addExtension("svg", true);
                    chooser.setFileFilter(eff);
                    int returnVal = chooser.showSaveDialog(PatternViewer.this);
                    if (returnVal == 0) {
                        ActionDialog ad = new ActionDialog("Saving Pattern SVG...");
                        ad.setVisible(true);
                        String absolutePath = FileUtils.appendExtension(chooser.getSelectedFile().getAbsolutePath(), "svg");
                        try {
                            OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(absolutePath), "UTF-8");
                            Object object = PatternViewer.this.docLock;
                            synchronized (object) {
                                ImageGenerator.write(PatternViewer.this.doc, fw);
                            }
                            fw.close();
                        }
                        catch (Exception ex) {
                            JOptionPane.showMessageDialog(PatternViewer.this, ex.getMessage(), "Error writing pattern SVG", 0);
                        }
                        catch (OutOfMemoryError oome) {
                            JOptionPane.showMessageDialog(PatternViewer.this, "Out of memory!", "Error writing pattern SVG", 0);
                        }
                        ad.setVisible(false);
                    }
                }
            });
        }
        return this.saveSVG;
    }

    private JToggleButton getHowToEdit() {
        if (this.howToEdit == null) {
            this.howToEdit = new JToggleButton();
            this.howToEdit.setText("How to Edit Patterns");
            this.howToEdit.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    PatternViewer.this.howToLabel.setVisible(PatternViewer.this.howToEdit.isSelected());
                    PatternViewer.this.doLayout();
                }
            });
        }
        return this.howToEdit;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.howToLabel = new JLabel();
            this.howToLabel.setText("<html><p>First, save as SVG. Open the resulting file in an editing program such as Adobe Illustrator.</p><p>Notice that your editor's pattern selector lists all TSCreator patterns. To create a new pattern, use your editor to draw a new pattern and add it to your editor's pattern list. Save as SVG and use File->Add Patterns to import into TSCreator. Use this dialog to make sure your patterns were loaded.</p><p><strong>NOTE: </strong> You DO NOT have to draw a box with your pattern like those below. ONLY the patterns listed in your editor's pattern list (along with their names) will be picked up by TSCreator.</p></html>");
            this.howToLabel.setVisible(false);
            this.howToLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new BorderLayout());
            this.jPanel.add((Component)this.getInfoPanel(), "North");
            this.jPanel.add((Component)this.howToLabel, "Center");
        }
        return this.jPanel;
    }

    private JPanel getDisplayPanel() {
        if (this.displayPanel == null) {
            this.displayPanel = new JPanel();
            this.displayPanel.setLayout(new BorderLayout());
            this.displayPanel.setName("displayPanel");
            this.displayCanvas = new TSCSVGCanvas();
            this.displayCanvasPane = new TSCSVGScrollPane(this.displayCanvas);
            this.displayPanel.add(this.displayCanvasPane);
            Thread drawerThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = PatternViewer.this.docLock;
                    synchronized (object) {
                        PatternViewer.this.doc = PatternViewer.this.patMan.generatePatternList();
                        PatternViewer.this.displayCanvas.setDocument(PatternViewer.this.patMan.generatePatternList());
                        PatternViewer.this.displayCanvasPane.resetTransform();
                        PatternViewer.this.displayCanvas.addGVTTreeRendererListener(new GVTTreeRendererAdapter(){

                            @Override
                            public void gvtRenderingPrepare(GVTTreeRendererEvent e) {
                                PatternViewer.this.displayCanvas.removeGVTTreeRendererListener(this);
                                PatternViewer.this.displayCanvasPane.resetTransform();
                                PatternViewer.this.displayCanvasPane.recenter();
                            }

                            @Override
                            public void gvtRenderingCompleted(GVTTreeRendererEvent e) {
                            }

                            @Override
                            public void gvtRenderingFailed(GVTTreeRendererEvent e) {
                            }
                        });
                    }
                    PatternViewer.this.saveSVG.setEnabled(true);
                }
            };
            drawerThread.start();
        }
        return this.displayPanel;
    }
}

