/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.RichText;
import gui.TSCFont;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.HashMap;
import org.apache.batik.svggen.SVGGraphics2D;

public class StringWrappingInfo {
    public RichText s;
    public double[] widths;
    public double[] lineHeights;
    public double[] descents;
    public FontMetrics fm;
    public TSCFont font = null;
    public TSCFont origFont;
    protected double scaleFactor = 1.0;
    public SVGGraphics2D g;
    protected int orientation = 1;
    public boolean cleanBreaks = true;
    public static final int DEG0 = 1;
    public static final int NORMAL = 1;
    public static final int VERTICAL = 4;
    public static final int DEG90 = 2;
    public static final int DEG180 = 3;
    public static final int DEG270 = 4;

    public StringWrappingInfo(SVGGraphics2D graphics) {
        this.g = graphics;
        this.s = new RichText("", null);
    }

    public StringWrappingInfo(SVGGraphics2D graphics, RichText string, TSCFont fontToUse, int orientation) {
        this.g = graphics;
        this.font = this.origFont = fontToUse;
        this.fm = this.g.getFontMetrics(fontToUse.getFont());
        this.s = string;
        this.orientation = orientation;
    }

    public StringWrappingInfo(StringWrappingInfo other) {
        this(other.g, new RichText(other.s), other.origFont, other.orientation);
    }

    public boolean isHorizontal() {
        return this.orientation == 1 || this.orientation == 3;
    }

    public boolean isVertical() {
        return this.orientation == 2 || this.orientation == 4;
    }

    public int getRotateDegrees() {
        switch (this.orientation) {
            case 2: {
                return 90;
            }
            case 3: {
                return 180;
            }
            case 4: {
                return 270;
            }
        }
        return 0;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int newOrientation) {
        this.orientation = newOrientation;
    }

    public void flipOrientation() {
        if (this.isHorizontal()) {
            this.setOrientation(4);
        } else {
            this.setOrientation(1);
        }
    }

    public void makeOneLine() {
        RichText.Line l1 = this.s.getLine(0);
        if (l1 == null) {
            return;
        }
        this.widths = new double[1];
        this.lineHeights = new double[1];
        this.descents = new double[1];
        l1.calculateBounds(this.fm, this.g, false);
        this.widths[0] = l1.width;
        this.lineHeights[0] = l1.getHeight();
        this.descents[0] = l1.descent;
        while (this.s.getNumLines() > 1) {
            this.s.lines.remove(this.s.getNumLines() - 1);
        }
    }

    public void useOriginalLineBreaks() {
        this.s.restore();
        this.s.splitOnNewlines(-1.0, this.fm, this.g);
        this.calcLineBounds();
    }

    public double getHeight() {
        if (this.s == null) {
            return 0.0;
        }
        if (this.isVertical()) {
            return this.getMaxStringWidth();
        }
        if (this.s.getNumLines() == 1 && this.s.getVis(0).trim().length() == 0) {
            return 0.0;
        }
        if (this.s.getNumLines() == 0) {
            return 0.0;
        }
        return this.getHeightsSum();
    }

    protected double getHeightsSum() {
        double h = 0.0;
        for (int i = 0; i < this.s.getNumLines(); ++i) {
            h += this.s.getLine(i).getHeight();
        }
        return h;
    }

    public double getWidth() {
        if (this.s == null) {
            return 0.0;
        }
        if (this.isVertical()) {
            return this.getHeightsSum();
        }
        return this.getMaxStringWidth();
    }

    public double getMaxStringWidth() {
        if (this.s == null) {
            return 0.0;
        }
        double maxWidth = 0.0;
        for (int i = 0; i < this.widths.length; ++i) {
            if (!(this.widths[i] > maxWidth)) continue;
            maxWidth = this.widths[i];
        }
        return maxWidth;
    }

    public int getNumLines() {
        if (this.s == null) {
            return 0;
        }
        return this.s.getNumLines();
    }

    public double getFontSize() {
        return this.font.getSize();
    }

    public double getFontHeight() {
        return this.fm.getHeight();
    }

    protected void setFontSize(int newSize) {
        if (this.font == this.origFont) {
            this.font = new TSCFont(this.origFont);
        }
        this.font.setSize(newSize);
        this.fm = this.g.getFontMetrics(this.font.getFont());
        this.calcLineBounds();
    }

    public void scale(double factor) {
        double newFontSize = this.getFontSize() * factor;
        this.scaleNonText(factor);
        this.scaleFactor *= factor;
        this.setFontSize((int)newFontSize);
    }

    protected void scaleNonText(double factor) {
        for (int i = 0; i < this.s.getNumLines(); ++i) {
            RichText.Line line = this.s.getLine(i);
            line.scaleNonText(factor);
        }
    }

    public void rewrap(double windowWidth) {
        if (this.isVertical()) {
            this.rewrapVertical(windowWidth);
            return;
        }
        this.s.restore();
        this.scaleNonText(this.scaleFactor);
        if (windowWidth < 1.0E-6) {
            this.widths = new double[1];
            this.widths[0] = 0.0;
            this.lineHeights = new double[1];
            this.lineHeights[0] = 0.0;
            this.descents = new double[1];
            this.descents[0] = 0.0;
            this.cleanBreaks = true;
            return;
        }
        this.calcLineBounds();
        this.s.splitOnNewlines(-1.0, this.fm, this.g);
        if (this.s.getNumLines() == 1 && this.widths[0] < windowWidth) {
            return;
        }
        RichText.CutInfo cutinfo = new RichText.CutInfo();
        for (int i = 0; i < this.s.getNumLines(); ++i) {
            RichText.Line line = this.s.getLine(i);
            int cutPoint = line.getVisibleString().length();
            String cut = line.getVisibleString();
            double cutWidth = line.width;
            while (cutWidth > windowWidth && cutPoint > 1) {
                int lastIndex = RichText.getLastBreak(cut, cut.length());
                if (lastIndex < 0) {
                    --cutPoint;
                    this.cleanBreaks = false;
                } else {
                    cutPoint = lastIndex;
                }
                line.getCutInfo(cutPoint, cutinfo, null, this.fm, (Graphics)this.g);
                cutWidth = cutinfo.width;
                cut = cutinfo.visibleString;
            }
            if (!(cutWidth < line.width)) continue;
            line.splitVisibleLine(cutPoint, true, i == 0, this.fm, this.g);
        }
        this.calcLineBounds();
    }

    protected void calcLineBounds() {
        this.widths = new double[this.s.getNumLines()];
        this.lineHeights = new double[this.s.getNumLines()];
        this.descents = new double[this.s.getNumLines()];
        for (int i = 0; i < this.s.getNumLines(); ++i) {
            RichText.Line line = this.s.getLine(i);
            line.calculateBounds(this.fm, this.g, i != 0);
            this.widths[i] = line.width;
            this.lineHeights[i] = line.getHeight();
            this.descents[i] = line.descent;
        }
    }

    protected void rewrapVertical(double windowWidth) {
        this.s.restore();
        this.scaleNonText(this.scaleFactor);
        this.calcLineBounds();
        this.s.splitOnNewlines(windowWidth, this.fm, this.g);
        if (this.s.getNumLines() == 1 && this.lineHeights[0] < windowWidth) {
            this.calcLineBounds();
            return;
        }
        HashMap<RichText.Line, Boolean> noSplit = new HashMap<RichText.Line, Boolean>();
        for (int i = 0; i < this.s.getNumLines(); ++i) {
            noSplit.put(this.s.getLine(i), false);
        }
        double totalHeight = this.getHeightsSum();
        while (true) {
            int splitLine = -1;
            double maxLength = 0.0;
            for (int i = 0; i < this.s.getNumLines(); ++i) {
                String l;
                RichText.Line line = this.s.getLine(i);
                Object o = noSplit.get(line);
                if (o != null && ((Boolean)o).booleanValue() || (l = this.s.getVis(i)).length() <= 2 || !(line.width > maxLength)) continue;
                splitLine = i;
                maxLength = line.width;
            }
            if (splitLine == -1) break;
            RichText.Line line = this.s.getLine(splitLine);
            int cutPoint = line.getVisibleString().length() / 2;
            if ((cutPoint = line.getLastBreak(cutPoint)) < 0) {
                cutPoint = line.getBreak(line.getVisibleString().length() / 2 - 1);
            }
            if (cutPoint < 0) {
                noSplit.put(line, true);
                continue;
            }
            if (line.splitVisibleLine(cutPoint, true, splitLine == 0, this.fm, this.g) != null) continue;
            noSplit.put(line, true);
        }
        this.calcLineBounds();
    }

    public void wrap(double width) {
        this.rewrap(width);
    }

    public StringWrappingInfo wrapString(RichText input, double windowWidth, TSCFont fontToUse) {
        this.font = this.origFont = fontToUse;
        this.fm = this.g.getFontMetrics(fontToUse.getFont());
        this.s = input;
        this.rewrap(windowWidth);
        return this;
    }

    public String toString() {
        String ret = "";
        if (this.s == null) {
            return ret;
        }
        for (int i = 0; i < this.s.getNumLines(); ++i) {
            if (ret.length() > 0) {
                ret = ret + "\n";
            }
            String l = this.s.getVis(i);
            ret = ret + l.replaceAll("\n", "").replaceAll("\r", "");
        }
        return ret;
    }
}

