/*
 * Decompiled with CFR 0.152.
 */
package gui;

import datastore.Coloring;
import java.awt.Color;
import java.awt.Font;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class TSCFont {
    protected String family;
    protected double size;
    protected int style;
    protected Color color;

    public TSCFont(String family, int type, double size, Color color) {
        this.family = family;
        this.size = size;
        this.style = type;
        this.color = color;
    }

    public TSCFont(TSCFont other) {
        this(other.family, other.style, other.size, other.color);
    }

    public TSCFont(TSCFont other, double scale) {
        this(other.family, other.style, other.size * scale, other.color);
    }

    public TSCFont(String svgStyle) {
        this.family = "Arial";
        this.size = 12.0;
        this.style = 0;
        this.color = Color.BLACK;
        this.setSVGStyle(svgStyle);
    }

    public Font getFont() {
        return new Font(this.family, this.style, this.getSizeInt());
    }

    public boolean equals(TSCFont other) {
        return this.family.equals(other.family) && this.size == other.size && this.style == other.style && this.color == other.color;
    }

    public String getSVGStyle() {
        String ret = "font-family: " + this.family + "; font-size: " + this.getSizeInt() + "px;";
        if (this.isItalic()) {
            ret = ret + " font-style: italic;";
        }
        if (this.isBold()) {
            ret = ret + " font-weight: bold;";
        }
        ret = ret + Coloring.getFillStyle(this.getColor());
        return ret;
    }

    public String getSVGStyleNoColor() {
        String ret = "font-family: " + this.family + "; font-size: " + this.getSizeInt() + "px;";
        if (this.isItalic()) {
            ret = ret + " font-style: italic;";
        }
        if (this.isBold()) {
            ret = ret + " font-weight: bold;";
        }
        return ret;
    }

    public final void setSVGStyle(String svgStyle) {
        StringTokenizer st = new StringTokenizer(svgStyle, ";");
        while (st.hasMoreTokens()) {
            String style = st.nextToken();
            StringTokenizer st2 = new StringTokenizer(style, ":");
            try {
                String key = st2.nextToken().trim();
                String value = st2.nextToken().trim();
                if (key.compareToIgnoreCase("font-family") == 0) {
                    this.family = value;
                    continue;
                }
                if (key.compareToIgnoreCase("font-size") == 0) {
                    this.size = Double.parseDouble(value);
                    continue;
                }
                if (key.compareToIgnoreCase("font-style") == 0) {
                    if (value.compareToIgnoreCase("italic") != 0) continue;
                    this.style |= 2;
                    continue;
                }
                if (key.compareToIgnoreCase("font-weight") == 0) {
                    if (value.compareToIgnoreCase("bold") != 0) continue;
                    this.style |= 1;
                    continue;
                }
                if (key.compareToIgnoreCase("fill") != 0) continue;
                this.color = Coloring.getColorFromStyle(value);
            }
            catch (NoSuchElementException noSuchElementException) {
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public String getFamily() {
        return this.family;
    }

    public int getStyle() {
        return this.style;
    }

    public Color getColor() {
        return this.color;
    }

    public void setStyle(int newStyle) {
        this.style = newStyle;
    }

    public void setColor(Color newColor) {
        this.color = newColor;
    }

    public boolean isBold() {
        return (this.style & 1) == 1;
    }

    public boolean isItalic() {
        return (this.style & 2) == 2;
    }

    public double getSize() {
        return this.size;
    }

    public int getSizeInt() {
        int ret = (int)Math.floor(this.size);
        if (ret < 1) {
            return 1;
        }
        return ret;
    }

    public double scale(double factor) {
        this.size *= factor;
        if (this.size < 0.0) {
            this.size = 1.0;
        }
        return this.size;
    }

    public double setSize(double size) {
        this.size = size;
        if (size < 0.0) {
            size = 1.0;
        }
        return this.size;
    }
}

