/*
 * Decompiled with CFR 0.152.
 */
package gui.crossplot;

import datastore.Coloring;
import datastore.DataColumn;
import datastore.Datastore;
import datastore.EventColumn;
import datastore.RootColumn;
import datastore.RulerColumn;
import datastore.SmartScaleColumn;
import datastore.Unit;
import gui.ErrorHandler;
import gui.ImageGenerator;
import gui.Language;
import gui.Settings;
import gui.TSCAction;
import gui.TSCSVGViewPanel;
import gui.TSCreator;
import gui.crossplot.Crossplot;
import gui.crossplot.CrossplotAutoPlotOptions;
import gui.crossplot.CrossplotConverter;
import gui.settings.SelectedTimes;
import gui.settings.TimesPanel;
import gui.settings.TimesSelectChangeListener;
import gui.tree.CheckboxTreeCellEditor;
import gui.tree.CheckboxTreeCellRenderer;
import gui.tree.DataColumnTreeNode;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Dimension2D;
import java.util.Iterator;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGDocument;
import path.ResPath;
import util.FileUtils;

public class CrossplotFrame
extends JFrame
implements ActionListener,
ItemListener,
TimesSelectChangeListener,
TreeSelectionListener,
MouseListener {
    protected Datastore ds;
    protected Settings settings;
    private JSplitPane mainSplit;
    private JPanel xTabPanel;
    private JPanel yTabPanel;
    private JPanel colTabPanel;
    private JPanel xjPanel1;
    private JSeparator jSeparator1;
    private JComboBox xSourceCB;
    private JLabel xSourceLabel;
    private JPanel xSourcePanel;
    private TimesPanel xTimes;
    private JPanel displayPanel;
    private JPanel yjPanel1;
    private JPanel crossPlotRadios;
    private JTabbedPane xyTabs;
    private JPanel dataSelectPanel;
    private JComboBox ySourceCB;
    private TSCSVGViewPanel svgTemplateView;
    private JToolBar selectToolbar;
    private JLabel ySourceLabel;
    private JPanel ySourcePanel;
    private TimesPanel yTimes;
    public JPanel markerPanel;
    public JPanel modelPanel;
    public JPanel linePanel;
    public JComboBox modelType;
    public JComboBox markerType;
    public boolean enCrossplotBG = false;
    public JCheckBox crossplotBG;
    public TSCAction generateSVG = new TSCAction(this, Language.translate("Generate", true), null, Language.translate("Generate an SVG image of this crossplot.", true));
    public TSCAction convAndGen = new TSCAction(this, Language.translate("Depth->Age", true), null, Language.translate("Converts and generates Depth model(datapack) to Age model(datapack).", true));
    public TSCAction autoPlot = new TSCAction(this, Language.translate("Auto Plot", true), null, Language.translate("Generates the chart with the selected age and depth columns.", true));
    public TSCAction clearPoints = new TSCAction(this, Language.translate("Clear All", true), null, Language.translate("Clears out the models and markers from the plot.", true));
    public static final String BG_STYLE = "stroke-width: 2; fill: white; stroke: black; opacity : 1.0";
    public static final String BG_STYLE_EN = "stroke-width: 2; fill: white; stroke: black; opacity : 0.5";
    public ImageGenerator ig;
    public static Crossplot crossplot;
    public CrossplotConverter crossplotConv;
    public DataColumn.FileInfo convFileInfo;
    private TSCreator tsc;
    private JTree zoneTree;
    public CrossplotAutoPlotOptions autoplotOptions;
    public JTextField xSource;
    public JTextField ySource;
    public JButton addX;
    public JButton addY;
    public JButton resetCols;
    public DataColumn ageColumn;
    public DataColumn depthColumn;
    public SmartScaleColumn smartScaleColumn;

    public CrossplotFrame() {
        crossplot = new Crossplot();
        this.crossplotConv = new CrossplotConverter();
        this.initGUI();
    }

    public CrossplotFrame(TSCreator tsc) {
        this();
        this.tsc = tsc;
        this.ds = TSCreator.db;
        this.settings = TSCreator.settings;
        this.settings.repaint();
        crossplot.setDatastore(this.ds);
        this.populate();
        this.updateZoneTree();
        this.xTimes.topMYRadio.setSelected(true);
        this.xTimes.topStage.setEnabled(false);
        this.xTimes.topStageRadio.setEnabled(false);
        this.xTimes.baseMYRadio.setSelected(true);
        this.xTimes.baseStage.setEnabled(false);
        this.xTimes.baseStageRadio.setEnabled(false);
        this.yTimes.topMYRadio.setSelected(true);
        this.yTimes.topStage.setEnabled(false);
        this.yTimes.topStageRadio.setEnabled(false);
        this.yTimes.baseMYRadio.setSelected(true);
        this.yTimes.baseStage.setEnabled(false);
        this.yTimes.baseStageRadio.setEnabled(false);
    }

    private void initGUI() {
        try {
            GraphicsEnvironment e = GraphicsEnvironment.getLocalGraphicsEnvironment();
            this.setDefaultCloseOperation(2);
            this.setExtendedState(this.getExtendedState() | 6);
            this.setTitle(Language.translate("Crossplot", true));
            this.mainSplit = new JSplitPane();
            this.getContentPane().add((Component)this.mainSplit, "Center");
            this.mainSplit.setPreferredSize(new Dimension(661, 319));
            this.mainSplit.setDividerLocation(400);
            this.dataSelectPanel = new JPanel();
            this.mainSplit.add((Component)this.dataSelectPanel, "left");
            this.dataSelectPanel.setLayout(new BorderLayout());
            this.selectToolbar = new JToolBar();
            this.dataSelectPanel.add((Component)this.selectToolbar, "First");
            this.selectToolbar.setFloatable(false);
            this.xyTabs = new JTabbedPane();
            this.dataSelectPanel.add((Component)this.xyTabs, "Center");
            this.xTabPanel = new JPanel();
            BorderLayout xTabPanelLayout = new BorderLayout();
            this.xyTabs.addTab(Language.translate("X axis (Age-only)", true), null, new JScrollPane(this.xTabPanel), null);
            this.xTabPanel.setLayout(xTabPanelLayout);
            this.xjPanel1 = new JPanel();
            BoxLayout xjPanel1Layout = new BoxLayout(this.xjPanel1, 1);
            this.xjPanel1.setLayout(xjPanel1Layout);
            this.xTabPanel.add((Component)this.xjPanel1, "Center");
            this.xjPanel1.setMinimumSize(new Dimension(380, 300));
            this.xSourcePanel = new JPanel();
            BoxLayout sourcePanelLayout = new BoxLayout(this.xSourcePanel, 0);
            this.xSourcePanel.setLayout(sourcePanelLayout);
            this.xjPanel1.add(this.xSourcePanel);
            this.xSourcePanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 10, 5));
            this.xSourceLabel = new JLabel();
            this.xSourcePanel.add(this.xSourceLabel);
            this.xSourceLabel.setText(Language.translate("source:", true));
            DefaultComboBoxModel<String> xSourceCBModel = new DefaultComboBoxModel<String>(new String[]{"Item One", "Item Two"});
            this.xSourceCB = new JComboBox();
            this.xSourcePanel.add(this.xSourceCB);
            this.xSourceCB.setModel(xSourceCBModel);
            this.xSourceCB.addItemListener(this);
            this.xSourceCB.setEnabled(false);
            this.jSeparator1 = new JSeparator();
            this.xjPanel1.add(this.jSeparator1);
            this.xTimes = new TimesPanel(this, null);
            this.xjPanel1.add(this.xTimes);
            this.xTimes.setMinimumSize(new Dimension(0, 0));
            this.xTimes.topMY.setText("0");
            this.xTimes.baseMY.setText("0");
            this.xTimes.skipEmptyColumnsCheck.setEnabled(false);
            this.xTimes.unitsPerMaTF.setText("1");
            this.yTabPanel = new JPanel();
            BorderLayout yTabPanelLayout = new BorderLayout();
            this.xyTabs.addTab(Language.translate("Y axis (Age/Depth)", true), null, new JScrollPane(this.yTabPanel), null);
            this.yTabPanel.setLayout(yTabPanelLayout);
            this.yjPanel1 = new JPanel();
            BoxLayout yjPanel1Layout = new BoxLayout(this.yjPanel1, 1);
            this.yjPanel1.setLayout(yjPanel1Layout);
            this.yTabPanel.add((Component)this.yjPanel1, "Center");
            this.yjPanel1.setMinimumSize(new Dimension(380, 300));
            this.ySourcePanel = new JPanel();
            sourcePanelLayout = new BoxLayout(this.ySourcePanel, 0);
            this.ySourcePanel.setLayout(sourcePanelLayout);
            this.yjPanel1.add(this.ySourcePanel);
            this.ySourcePanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 10, 5));
            this.ySourceLabel = new JLabel();
            this.ySourcePanel.add(this.ySourceLabel);
            this.ySourceLabel.setText(Language.translate("source:", true));
            DefaultComboBoxModel<String> ySourceCBModel = new DefaultComboBoxModel<String>(new String[]{"Item One", "Item Two"});
            this.ySourceCB = new JComboBox();
            this.ySourcePanel.add(this.ySourceCB);
            this.ySourceCB.setModel(ySourceCBModel);
            this.ySourceCB.addItemListener(this);
            this.jSeparator1 = new JSeparator();
            this.yjPanel1.add(this.jSeparator1);
            this.yTimes = new TimesPanel(this, null);
            this.yjPanel1.add(this.yTimes);
            this.yTimes.setMinimumSize(new Dimension(0, 0));
            this.yTimes.topMY.setText("0");
            this.yTimes.baseMY.setText("0");
            this.yTimes.skipEmptyColumnsCheck.setEnabled(false);
            this.yTimes.unitsPerMaTF.setText("1");
            this.colTabPanel = new JPanel();
            this.xyTabs.addTab(Language.translate("Columns", true), null, this.colTabPanel, null);
            this.colTabPanel.setLayout(new BorderLayout());
            this.crossPlotRadios = new JPanel();
            this.dataSelectPanel.add((Component)this.crossPlotRadios, "Last");
            this.crossPlotRadios.setLayout(new BoxLayout(this.crossPlotRadios, 1));
            JToolBar panel1 = new JToolBar();
            panel1.setLayout(new FlowLayout());
            this.crossPlotRadios.add(panel1);
            panel1.add(this.generateSVG);
            panel1.add(this.convAndGen);
            panel1.add(this.autoPlot);
            panel1.add(this.clearPoints);
            this.convAndGen.setEnabled(false);
            this.autoPlot.setEnabled(false);
            this.clearPoints.setEnabled(false);
            JPanel selPanel = new JPanel();
            this.crossPlotRadios.add(selPanel);
            selPanel.setLayout(new BorderLayout());
            selPanel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            this.autoplotOptions = new CrossplotAutoPlotOptions(null, this);
            selPanel.add(this.autoplotOptions);
            int y = 0;
            JPanel panel = new JPanel();
            this.crossPlotRadios.add(panel);
            panel.setLayout(new GridBagLayout());
            panel.setBackground(Color.white);
            GridBagConstraints c = new GridBagConstraints();
            int x = 0;
            x = 0;
            this.addX = new JButton(Language.translate("Select Age Column", true));
            c.fill = 1;
            c.gridx = x++;
            c.gridy = ++y;
            c.weighty = 0.0;
            c.gridwidth = 1;
            panel.add((Component)this.addX, c);
            this.addX.addActionListener(this);
            this.addX.setEnabled(false);
            this.xSource = new JTextField(Language.translate("\"select an age column\"", true));
            this.xSource.setColumns(30);
            c.fill = 1;
            c.gridx = x;
            c.gridy = y++;
            c.weighty = 0.0;
            c.gridwidth = 3;
            panel.add((Component)this.xSource, c);
            this.xSource.setEditable(false);
            x += 3;
            x = 0;
            this.addY = new JButton(Language.translate("Select Depth Column", true));
            c.fill = 1;
            c.gridx = x++;
            c.gridy = y;
            c.weighty = 0.0;
            c.gridwidth = 1;
            panel.add((Component)this.addY, c);
            this.addY.addActionListener(this);
            this.addY.setEnabled(false);
            this.ySource = new JTextField(Language.translate("\"select a depth column\"", true));
            this.ySource.setColumns(30);
            c.fill = 1;
            c.gridx = x;
            c.gridy = y++;
            c.weighty = 0.0;
            c.gridwidth = 3;
            panel.add((Component)this.ySource, c);
            this.ySource.setEditable(false);
            x += 3;
            x = 0;
            this.resetCols = new JButton(Language.translate("Reset the age and depth columns", true));
            c.fill = 1;
            c.gridx = x++;
            c.gridy = y++;
            c.weighty = 0.0;
            c.gridwidth = 4;
            panel.add((Component)this.resetCols, c);
            this.resetCols.addActionListener(this);
            this.resetCols.setEnabled(false);
            JLabel label = new JLabel(Language.translate("Enable stage background for crossplot", true), 4);
            label.setFont(new Font("Arial", 1, 14));
            c.fill = 256;
            c.gridx = 0;
            c.gridy = y;
            c.gridwidth = 3;
            c.gridheight = 1;
            c.weightx = 1.0;
            c.weighty = 0.0;
            panel.add((Component)label, c);
            this.crossplotBG = new JCheckBox();
            this.crossplotBG.setSelected(this.enCrossplotBG);
            c.fill = 256;
            c.gridx = 3;
            c.gridy = y++;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.weightx = 1.0;
            c.weighty = 0.0;
            panel.add((Component)this.crossplotBG, c);
            this.crossplotBG.addActionListener(this);
            label = new JLabel(Language.translate("Crossplot Color Options", true), 0);
            label.setFont(new Font("Arial", 1, 18));
            c.fill = 256;
            c.gridx = 0;
            c.gridy = y++;
            c.gridwidth = 4;
            c.gridheight = 1;
            c.weightx = 1.0;
            c.weighty = 0.0;
            label = new JLabel(Language.translate("Model Color:", true), 0);
            c.fill = 256;
            c.gridx = 0;
            c.gridy = y;
            c.gridwidth = 2;
            c.gridheight = 1;
            c.weightx = 1.0;
            c.weighty = 0.0;
            ImageIcon icon = FileUtils.getImageIcon(ResPath.getPath("icons.closed"));
            JLabel label2 = new JLabel();
            label2.setIcon(icon);
            c.fill = 256;
            c.gridx = 2;
            c.gridy = y;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.weightx = 1.0;
            c.weighty = 0.0;
            this.modelPanel = new JPanel();
            c.fill = 256;
            c.gridx = 3;
            c.gridy = y++;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.weightx = 1.0;
            c.weighty = 0.0;
            this.modelPanel.setBackground(Color.black);
            this.modelPanel.setBorder(BorderFactory.createEtchedBorder(0));
            this.modelPanel.addMouseListener(this);
            label = new JLabel(Language.translate("Marker Color:", true), 0);
            c.fill = 256;
            c.gridx = 0;
            c.gridy = y;
            c.gridwidth = 2;
            c.gridheight = 1;
            c.weightx = 1.0;
            c.weighty = 0.0;
            icon = FileUtils.getImageIcon(ResPath.getPath("icons.open"));
            label2 = new JLabel();
            label2.setIcon(icon);
            c.fill = 256;
            c.gridx = 2;
            c.gridy = y;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.weightx = 1.0;
            c.weighty = 0.0;
            this.markerPanel = new JPanel();
            c.fill = 256;
            c.gridx = 3;
            c.gridy = y++;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.weightx = 1.0;
            c.weighty = 0.0;
            this.markerPanel.setBackground(Color.lightGray);
            this.markerPanel.setBorder(BorderFactory.createEtchedBorder(0));
            this.markerPanel.addMouseListener(this);
            label = new JLabel(Language.translate("Line Color:", true), 0);
            c.fill = 256;
            c.gridx = 0;
            c.gridy = y;
            c.gridwidth = 2;
            c.gridheight = 1;
            c.weightx = 1.0;
            c.weighty = 0.0;
            icon = FileUtils.getImageIcon(ResPath.getPath("icons.hide"));
            label2 = new JLabel();
            label2.setIcon(icon);
            c.fill = 256;
            c.gridx = 2;
            c.gridy = y;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.weightx = 1.0;
            c.weighty = 0.0;
            this.linePanel = new JPanel();
            c.fill = 256;
            c.gridx = 3;
            c.gridy = y++;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.weightx = 1.0;
            c.weighty = 0.0;
            this.linePanel.setBackground(Color.gray);
            this.linePanel.setBorder(BorderFactory.createEtchedBorder(0));
            this.linePanel.addMouseListener(this);
            label = new JLabel(Language.translate("Crossplot Point Options", true), 0);
            label.setFont(new Font("Arial", 1, 18));
            c.fill = 256;
            c.gridx = 0;
            c.gridy = y++;
            c.gridwidth = 4;
            c.gridheight = 1;
            c.weightx = 1.0;
            c.weighty = 0.0;
            label = new JLabel(Language.translate("Model Type:", true), 0);
            c.fill = 256;
            c.gridx = 0;
            c.gridy = y;
            c.gridwidth = 2;
            c.gridheight = 1;
            c.weightx = 1.0;
            c.weighty = 0.0;
            icon = FileUtils.getImageIcon(ResPath.getPath("icons.closed"));
            label2 = new JLabel();
            label2.setIcon(icon);
            c.fill = 256;
            c.gridx = 2;
            c.gridy = y;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.weightx = 1.0;
            c.weighty = 0.0;
            this.modelType = new JComboBox<String>(Crossplot.MODEL_POINT_TYPES);
            c.fill = 256;
            c.gridx = 3;
            c.gridy = y++;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.weightx = 1.0;
            c.weighty = 0.0;
            this.modelType.addActionListener(this);
            label = new JLabel(Language.translate("Marker Types:", true), 0);
            c.fill = 256;
            c.gridx = 0;
            c.gridy = y;
            c.gridwidth = 2;
            c.gridheight = 1;
            c.weightx = 1.0;
            c.weighty = 0.0;
            icon = FileUtils.getImageIcon(ResPath.getPath("icons.open"));
            label2 = new JLabel();
            label2.setIcon(icon);
            c.fill = 256;
            c.gridx = 2;
            c.gridy = y;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.weightx = 1.0;
            c.weighty = 0.0;
            this.markerType = new JComboBox<String>(Crossplot.MARKER_POINT_TYPES);
            c.fill = 256;
            c.gridx = 3;
            c.gridy = y++;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.weightx = 1.0;
            c.weighty = 0.0;
            this.markerType.addActionListener(this);
            label = new JLabel(Language.translate("Crossplot Key Configurations", true), 0);
            label.setFont(new Font("Arial", 1, 18));
            c.fill = 256;
            c.gridx = 0;
            c.gridy = y++;
            c.gridwidth = 4;
            c.gridheight = 1;
            c.weightx = 1.0;
            c.weighty = 0.0;
            panel.add((Component)label, c);
            JPanel keysPanel = new JPanel();
            c.fill = 10;
            c.gridx = 0;
            c.gridy = y;
            c.gridwidth = 5;
            c.gridheight = 4;
            c.weightx = 1.0;
            c.weighty = 0.0;
            panel.add((Component)keysPanel, c);
            keysPanel.setBackground(Color.white);
            keysPanel.setLayout(new BoxLayout(keysPanel, 1));
            JLabel label2g = new JLabel("", 0);
            keysPanel.add(label2g);
            JLabel label2b = new JLabel(Language.translate("Hitting key 'O' toggles btwn. markers/models.", true), 2);
            label2b.setFont(new Font("Arial", 0, 15));
            keysPanel.add(label2b);
            JLabel label2c = new JLabel("", 0);
            keysPanel.add(label2c);
            JLabel label2h = new JLabel(Language.translate("Hitting key 'X' locks/unlocks the vertical Age line.", true), 0);
            label2h.setFont(new Font("Arial", 0, 15));
            keysPanel.add(label2h);
            JLabel label2i = new JLabel("", 0);
            keysPanel.add(label2i);
            JLabel label2j = new JLabel(Language.translate("Hitting key 'Y' locks/unlocks the horizontal Depth line.", true), 0);
            label2j.setFont(new Font("Arial", 0, 15));
            keysPanel.add(label2j);
            JLabel label2k = new JLabel("", 0);
            keysPanel.add(label2k);
            JLabel label2l = new JLabel(Language.translate("Hitting key 'P' enables/disables the Popups.", true), 0);
            label2l.setFont(new Font("Arial", 0, 15));
            keysPanel.add(label2l);
            JLabel label2m = new JLabel("", 0);
            keysPanel.add(label2m);
            this.displayPanel = new JPanel();
            BorderLayout displayPanelLayout = new BorderLayout();
            this.mainSplit.add((Component)this.displayPanel, "right");
            this.displayPanel.setLayout(displayPanelLayout);
            this.svgTemplateView = new TSCSVGViewPanel(true);
            this.displayPanel.add((Component)this.svgTemplateView, "Center");
            this.pack();
            this.setSize(800, 700);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        DataColumn col = null;
        Object o = this.zoneTree.getLastSelectedPathComponent();
        SmartScaleColumn ssCol = new SmartScaleColumn();
        if (source == null) {
            return;
        }
        if (source == this.generateSVG) {
            System.out.println(Language.translate("Generating crossplot SVG...", true));
            if (this.svgTemplateView.crossplot != null) {
                crossplot.updateAgeDepthPoints();
            }
            SourceItem y = (SourceItem)this.ySourceCB.getSelectedItem();
            this.smartScaleColumn = ssCol.setSmartColumn(y.root, this.yTimes, this.settings, this.ds);
            this.generateSVGTemplate();
            this.generateSVG.setText(Language.translate("Gen/Apply", true));
            this.generateSVG.setDescription(Language.translate("generate chart or apply changes to the crossplot", true));
        }
        if (source == this.convAndGen) {
            try {
                if (TSCreator.depthFile != null) {
                    this.crossplotConv.autoConvertAndSave();
                    this.tsc.loadDatapackFile(this.crossplotConv.convFile);
                    System.out.println("Generating crossplot SVG...");
                    if (crossplot != null) {
                        crossplot.updateAgeDepthPoints();
                    }
                    this.generateSVGTemplate();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (source == this.clearPoints) {
            crossplot.clearAllPoints();
            this.generateSVGTemplate();
        }
        if (source == this.markerType) {
            CrossplotFrame.crossplot.markerGroup.setAttribute("type", Integer.toString(this.markerType.getSelectedIndex()));
        }
        if (source == this.modelType) {
            CrossplotFrame.crossplot.modelGroup.setAttribute("type", Integer.toString(this.modelType.getSelectedIndex()));
        }
        if (source == this.crossplotBG) {
            this.enCrossplotBG = this.crossplotBG.isSelected();
        }
        if (o instanceof DataColumn) {
            col = (DataColumn)o;
        }
        if (o instanceof DataColumnTreeNode) {
            col = ((DataColumnTreeNode)o).col;
        }
        if (source == this.addX && col != null) {
            this.xSource.setText(col.getName());
            this.ageColumn = col;
        }
        if (source == this.addY && col != null) {
            this.ySource.setText(col.getName());
            this.depthColumn = col;
        }
        if (source == this.autoPlot && crossplot != null) {
            crossplot.updateAgeDepthPoints();
            crossplot.autoPlot(this.ageColumn, this.depthColumn);
        }
        if (source == this.resetCols) {
            this.ageColumn = null;
            this.depthColumn = null;
            this.xSource.setText("\"select an age column\"");
            this.ySource.setText("\"select a depth column\"");
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        SourceItem si;
        if (e.getSource() == this.xSourceCB) {
            SourceItem si2 = (SourceItem)this.xSourceCB.getSelectedItem();
            if (si2 != null) {
                this.xTimes.populate(this.ds, si2.root.unit);
            }
        } else if (e.getSource() == this.ySourceCB && (si = (SourceItem)this.ySourceCB.getSelectedItem()) != null) {
            this.yTimes.populate(this.ds, si.root.unit);
            SelectedTimes st = this.settings.timesSelections.get(si.root.unit);
            this.yTimes.topMY.setText(Double.toString(st.topAge));
            this.yTimes.baseMY.setText(Double.toString(st.baseAge));
            this.yTimes.unitsPerMaTF.setText(Double.toString(st.vertScale));
        }
    }

    public final void populate() {
        this.xSourceCB.removeAllItems();
        this.ySourceCB.removeAllItems();
        if (this.ds == null || this.ds.rootColumn == null) {
            return;
        }
        SourceItem first = null;
        SourceItem second = null;
        Iterator<DataColumn> unitIter = this.ds.rootColumn.getSubColumns();
        while (unitIter.hasNext()) {
            String curUnit;
            String iterUnit;
            RootColumn root = (RootColumn)unitIter.next();
            SelectedTimes st = this.settings.timesSelections.get(root.unit);
            SourceItem item = new SourceItem();
            item.name = root.unit.toString() + " (" + root.getName() + ")";
            item.root = root;
            this.xSourceCB.addItem(item);
            this.ySourceCB.addItem(item);
            if (first == null) {
                first = item;
                if (st == null) continue;
                this.xTimes.topMY.setText(Double.toString(st.topAge));
                this.xTimes.baseMY.setText(Double.toString(st.baseAge));
                this.xTimes.unitsPerMaTF.setText(Double.toString(st.vertScale));
                continue;
            }
            if (second != null || !(iterUnit = root.unit.toString()).equals(curUnit = this.settings.getIndexTitle()) && !curUnit.equalsIgnoreCase("MA") || st == null) continue;
            second = item;
            this.yTimes.topMY.setText(Double.toString(st.topAge));
            this.yTimes.baseMY.setText(Double.toString(st.baseAge));
            this.yTimes.unitsPerMaTF.setText(Double.toString(st.vertScale));
        }
        if (second != null) {
            this.ySourceCB.setSelectedItem(second);
        }
    }

    public void generateSVGTemplate() {
        SVGDocument doc;
        ImageGenerator derp = new ImageGenerator(this.ds.rootColumn, TSCreator.settings, this.ds.patMan);
        SourceItem xAxis = (SourceItem)this.xSourceCB.getSelectedItem();
        SourceItem yAxis = (SourceItem)this.ySourceCB.getSelectedItem();
        if (xAxis == null) {
            ErrorHandler.messageBox(Language.translate("Please select an X axis", true), "Bad Sources", 3);
            return;
        }
        if (yAxis == null) {
            ErrorHandler.messageBox(Language.translate("Please select a Y axis", true), "Bad Sources", 3);
            return;
        }
        SelectedTimes xST = new SelectedTimes(this.xTimes, true);
        SelectedTimes yST = new SelectedTimes(this.yTimes, true);
        RootColumn rcx = derp.rootCol.getChildRoot(xAxis.root.unit);
        RootColumn rcy = derp.rootCol.getChildRoot(yAxis.root.unit);
        if (!xST.isValid && !rcx.isOutcrop || xST.isValid && rcx.isOutcrop) {
            xST.error = rcx.isOutcrop ? "Top depth must be older than base depth!" : "Base age must be older than top age!";
            ErrorHandler.messageBox(xST.error, Language.translate("Invalid X axis options", true), 3);
            return;
        }
        if (rcx.isOutcrop) {
            xST.topAge = -xST.topAge;
            xST.baseAge = -xST.baseAge;
            Crossplot.myOCx = true;
        }
        if (!yST.isValid && !rcy.isOutcrop || yST.isValid && rcy.isOutcrop) {
            yST.error = rcy.isOutcrop ? "Top depth must be older than base depth!" : "Base age must be older than top age!";
            ErrorHandler.messageBox(yST.error, Language.translate("Invalid Y axis options", true), 3);
            return;
        }
        if (rcy.isOutcrop) {
            yST.topAge = -yST.topAge;
            yST.baseAge = -yST.baseAge;
            Crossplot.myOCy = true;
        }
        if ((doc = this.generateSVGDoc(xAxis.root, xST, yAxis.root, yST)) == null) {
            ErrorHandler.messageBox(Language.translate("There was an unknown error generating the crossplot!", true), Language.translate("Error generating", true), 3);
            return;
        }
        this.svgTemplateView.setDocument(doc);
        crossplot.setDocument(doc);
        this.svgTemplateView.setCrossplot(crossplot);
        this.crossplotConv.setCrossplot(crossplot);
        this.crossplotConv.setCrossplotFrame(this);
        this.convAndGen.setEnabled(true);
        this.autoPlot.setEnabled(true);
        this.clearPoints.setEnabled(true);
    }

    protected SVGDocument generateSVGDoc(RootColumn xColIn, SelectedTimes xST, RootColumn yColIn, SelectedTimes yST) {
        ImageGenerator.line_color = Coloring.getCSScolor(this.linePanel.getBackground());
        ImageGenerator.model_color = Coloring.getCSScolor(this.modelPanel.getBackground());
        ImageGenerator.marker_color = Coloring.getCSScolor(this.markerPanel.getBackground());
        this.ig = new ImageGenerator(null, null, this.ds.patMan);
        this.ig.setAllowNegatives(true);
        double halfBorderWidth = Settings.BORDER_WIDTH / 2.0;
        double borderWidth = Settings.BORDER_WIDTH;
        Set patternUsageHolder = null;
        if (this.ig.patMan != null) {
            patternUsageHolder = this.ig.patMan.getPatternUsageHolder();
        }
        RootColumn xCol = new RootColumn(xColIn);
        RootColumn yCol = new RootColumn(yColIn);
        xCol.setDS(this.ds);
        yCol.setDS(this.ds);
        DataColumn firstX = xCol.getColumnByIndex(0);
        if (firstX instanceof RulerColumn) {
            xCol.removeColumn(0);
        }
        RulerColumn xRuler = new RulerColumn(xCol.unit, true);
        xRuler.setName("");
        xCol.insertColumn(xRuler, 0);
        DataColumn firstY = yCol.getColumnByIndex(0);
        if (firstY instanceof RulerColumn) {
            yCol.removeColumn(0);
        }
        RulerColumn yRuler = new RulerColumn(yCol.unit, false);
        yRuler.setName("");
        yCol.addColumn(yRuler);
        xCol.updateMinMaxAgesMetaOnly();
        xCol.grayOutIfEmpty(xST.topAge, xST.baseAge, true);
        yCol.updateMinMaxAgesMetaOnly();
        yCol.grayOutIfEmpty(yST.topAge, yST.baseAge, true);
        Element yGroup = this.ig.pushGrouping();
        Settings ySettings = Settings.getReadOnlySettings(this.ds, this.yTimes.unit, yST, null);
        ySettings.doPopups = false;
        this.ig.settings = ySettings;
        ImageGenerator.ColumnDrawInfo yDims = this.ig.drawColumn(yCol, ySettings, 0.0, 0.0, false);
        this.ig.drawLine(yDims.width - halfBorderWidth, yDims.dataTopY, yDims.width - halfBorderWidth, yDims.dataTopY + yDims.dataHeight, ImageGenerator.BORDER_STYLE);
        this.ig.drawLine(halfBorderWidth, yDims.dataTopY, halfBorderWidth, yDims.dataTopY + yDims.dataHeight, ImageGenerator.BORDER_STYLE);
        this.ig.drawLine(halfBorderWidth, yDims.dataTopY + yDims.dataHeight, yDims.width - halfBorderWidth, yDims.dataTopY + yDims.dataHeight, ImageGenerator.BORDER_STYLE);
        this.ig.popGrouping();
        Element xGroup = this.ig.pushGrouping();
        Settings xSettings = Settings.getReadOnlySettings(this.ds, this.xTimes.unit, xST, null);
        xSettings.doPopups = false;
        this.ig.settings = xSettings;
        ImageGenerator.ColumnDrawInfo xDims = this.ig.drawColumn(xCol, xSettings, 0.0, 0.0, false);
        this.ig.drawLine(xDims.width - halfBorderWidth, xDims.dataTopY, xDims.width - halfBorderWidth, xDims.dataTopY + xDims.dataHeight, ImageGenerator.BORDER_STYLE);
        this.ig.drawLine(halfBorderWidth, xDims.dataTopY, halfBorderWidth, xDims.dataTopY + xDims.dataHeight, ImageGenerator.BORDER_STYLE);
        this.ig.drawLine(halfBorderWidth, xDims.dataTopY + xDims.dataHeight, xDims.width - halfBorderWidth, xDims.dataTopY + xDims.dataHeight, ImageGenerator.BORDER_STYLE);
        Iterator iter = xCol.subColumns.iterator();
        DataColumn intervalCol = null;
        if (this.enCrossplotBG) {
            block2: while (iter.hasNext()) {
                DataColumn col = (DataColumn)iter.next();
                if (intervalCol != null || col.unit == null) continue;
                String[] intervalColNames = col.unit.getIntervalColNames();
                for (int i = 0; intervalColNames != null && i < intervalColNames.length; ++i) {
                    try {
                        intervalCol = this.ds.getColumnByName(col.unit, intervalColNames[i]);
                        if (intervalCol == null) continue;
                        continue block2;
                    }
                    catch (Exception e) {
                        System.out.println(e.getMessage());
                    }
                }
            }
            intervalCol.drawData(this.ig, -yDims.height, xDims.dataTopY, yDims.height, xDims.dataHeight, xSettings);
        }
        String xtransform = "translate(" + (yDims.width - xDims.dataTopY) + ", " + xDims.width + ") rotate(-90) ";
        xGroup.setAttributeNS(null, "transform", xtransform);
        this.ig.popGrouping();
        String ytransform = "translate(0," + (xDims.width - yDims.dataTopY) + ")";
        yGroup.setAttributeNS(null, "transform", ytransform);
        this.ig.setCanvasSize(yDims.width + xDims.height, yDims.dataHeight + xDims.width);
        this.ig.svgRoot.setAttributeNS(null, "onload", "Init(evt)");
        Dimension canvasDim = this.getSize();
        Dimension docSize = this.svgTemplateView.displayCanvasPane.getImageBounds().getSize();
        double sx = (double)canvasDim.width / ((Dimension2D)docSize).getWidth();
        double sy = (double)canvasDim.height / ((Dimension2D)docSize).getHeight();
        double scale = Math.min(sx, sy);
        if (this.ig.doc != null) {
            this.ig.doc.getDocumentElement().setAttribute("doc-scale", Double.toString(scale));
        }
        this.ig.drawRect(yDims.width, xDims.width, xDims.height - xDims.dataTopY, yDims.height - yDims.dataTopY, this.enCrossplotBG ? BG_STYLE_EN : BG_STYLE);
        this.ig.createCrossPlotGroup(xST.topAge, xST.baseAge, yST.topAge, yST.baseAge);
        this.ig.drawTimeLineY(0.0, xDims.width, yDims.width + xDims.height - xDims.dataTopY, xDims.width, xDims.width, xDims.width + yDims.height - yDims.dataTopY, yST.topAge, yST.baseAge, yST.vertScale * 30.0, "stroke: red; stroke-opacity: 0.5;");
        this.ig.drawTimeLabelY();
        this.ig.drawTimeLineX(yDims.width, 0.0, yDims.width, xDims.width + yDims.height - yDims.dataTopY, yDims.width, yDims.width + xDims.height - xDims.dataTopY, xST.topAge, xST.baseAge, xST.vertScale * 30.0, "stroke: red; stroke-opacity: 0.5;");
        this.ig.drawTimeLabelX();
        if (this.ig.patMan != null) {
            this.ig.patMan.writePatternsToIG(this.ig, patternUsageHolder);
        }
        return this.ig.getDocument();
    }

    private void updateZoneTree() {
        if (this.zoneTree == null) {
            this.zoneTree = new JTree(this.ds.getCrossplotTreeModel());
            this.zoneTree.setCellRenderer(new CheckboxTreeCellRenderer());
            this.zoneTree.setCellEditor(new CheckboxTreeCellEditor(this.zoneTree));
            this.zoneTree.setEditable(true);
            this.zoneTree.getSelectionModel().setSelectionMode(1);
            this.zoneTree.addTreeSelectionListener(this);
            this.zoneTree.setRowHeight(0);
        }
        this.colTabPanel.add(new JScrollPane(this.zoneTree));
    }

    @Override
    public void timesChanged(int type, Unit affectedUnit) {
        TimesPanel tp = this.settings.timesPanels.get(affectedUnit);
        if (this.yTimes.topStage.isFocusOwner() || this.yTimes.baseStage.isFocusOwner()) {
            this.yTimes.topStageRadio.setSelected(true);
            this.yTimes.baseStageRadio.setSelected(true);
            tp.topStageRadio.setSelected(true);
            tp.baseStageRadio.setSelected(true);
            tp.topStage.setSelectedIndex(this.yTimes.topStage.getSelectedIndex());
            tp.baseStage.setSelectedIndex(this.yTimes.baseStage.getSelectedIndex());
        } else if (this.yTimes.topMY.isFocusOwner() || this.yTimes.baseMY.isFocusOwner()) {
            tp.topMYRadio.setSelected(true);
            tp.topMY.setText(this.yTimes.topMY.getText());
            tp.baseMYRadio.setSelected(true);
            tp.baseMY.setText(this.yTimes.baseMY.getText());
        } else if (this.xTimes.topStage.isFocusOwner() || this.xTimes.baseStage.isFocusOwner()) {
            this.xTimes.topStageRadio.setSelected(true);
            this.xTimes.baseStageRadio.setSelected(true);
            tp.topStageRadio.setSelected(true);
            tp.baseStageRadio.setSelected(true);
            tp.topStage.setSelectedIndex(this.xTimes.topStage.getSelectedIndex());
            tp.baseStage.setSelectedIndex(this.xTimes.baseStage.getSelectedIndex());
        } else if (this.xTimes.topMY.isFocusOwner() || this.xTimes.baseMY.isFocusOwner()) {
            tp.topMYRadio.setSelected(true);
            tp.topMY.setText(this.xTimes.topMY.getText());
            tp.baseMYRadio.setSelected(true);
            tp.baseMY.setText(this.xTimes.baseMY.getText());
        } else if (this.xTimes.unitsPerMaTF.isFocusOwner()) {
            tp.unitsPerMaTF.setText(this.xTimes.unitsPerMaTF.getText());
        } else if (this.yTimes.unitsPerMaTF.isFocusOwner()) {
            tp.unitsPerMaTF.setText(this.yTimes.unitsPerMaTF.getText());
        }
        this.settings.timesChanged(type, affectedUnit);
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        if (e.getSource() == this.zoneTree) {
            DataColumn col = null;
            Object o = this.zoneTree.getLastSelectedPathComponent();
            if (o instanceof DataColumn) {
                col = (DataColumn)o;
            }
            if (o instanceof DataColumnTreeNode) {
                col = ((DataColumnTreeNode)o).col;
            }
            this.settings.curSelectDC = col;
            this.settings.updateZoneSelectRadios();
            if (col != null && col instanceof EventColumn) {
                this.addX.setEnabled(true);
                this.addY.setEnabled(true);
            } else {
                this.addX.setEnabled(false);
                this.addY.setEnabled(false);
            }
            this.resetCols.setEnabled(true);
            this.autoplotOptions.setColumn(col);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        String color;
        if (e.getSource() == this.linePanel) {
            color = ImageGenerator.line_color;
            Color lineColor = JColorChooser.showDialog(this.linePanel, "Choose Line Color", Color.gray);
            if (lineColor != null) {
                this.linePanel.setBackground(lineColor);
                color = Coloring.getCSScolor(lineColor);
            }
            CrossplotFrame.crossplot.lineGroup.setAttribute("stroke", color);
        }
        if (e.getSource() == this.modelPanel) {
            color = ImageGenerator.model_color;
            Color modelColor = JColorChooser.showDialog(this.modelPanel, "Choose Line Color", Color.gray);
            if (modelColor != null) {
                this.modelPanel.setBackground(modelColor);
                color = Coloring.getCSScolor(modelColor);
            }
            CrossplotFrame.crossplot.modelGroup.setAttributeNS(null, "fill-color", color);
        }
        if (e.getSource() == this.markerPanel) {
            color = ImageGenerator.marker_color;
            Color markerColor = JColorChooser.showDialog(this.markerPanel, "Choose Line Color", Color.gray);
            if (markerColor != null) {
                this.markerPanel.setBackground(markerColor);
                color = Coloring.getCSScolor(markerColor);
            }
            CrossplotFrame.crossplot.markerGroup.setAttributeNS(null, "fill-color", color);
        }
    }

    protected static class SourceItem {
        String name;
        RootColumn root;

        protected SourceItem() {
        }

        public String toString() {
            return this.name;
        }
    }
}

