/*
 * Decompiled with CFR 0.152.
 */
package gui.tree;

import datastore.DataColumn;
import gui.tree.DataColumnTreeNode;
import gui.tree.DataColumnTreePanel;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.JTree;
import javax.swing.event.CellEditorListener;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreePath;

public class CheckboxTreeCellEditor
implements TreeCellEditor {
    JTree tree;

    public CheckboxTreeCellEditor(JTree t) {
        this.tree = t;
    }

    @Override
    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row) {
        DataColumnTreePanel panel;
        if (value instanceof DataColumn) {
            DataColumn node = (DataColumn)value;
            panel = node.panel;
            System.out.println("Using DataColumn in tree EDITOR.");
        } else if (value instanceof DataColumnTreeNode) {
            DataColumnTreeNode node = (DataColumnTreeNode)value;
            panel = node.panel;
        } else {
            System.out.println("Using NULL in tree EDITOR.");
            return null;
        }
        return panel;
    }

    @Override
    public void cancelCellEditing() {
    }

    @Override
    public boolean stopCellEditing() {
        return true;
    }

    @Override
    public Object getCellEditorValue() {
        return this;
    }

    @Override
    public boolean isCellEditable(EventObject evt) {
        int row;
        TreePath path;
        MouseEvent mevt;
        if (evt instanceof MouseEvent && (mevt = (MouseEvent)evt).getClickCount() == 1 && (path = this.tree.getPathForRow(row = this.tree.getRowForLocation(mevt.getX(), mevt.getY()))) != null) {
            DataColumnTreePanel panel = null;
            Object o = path.getLastPathComponent();
            if (o instanceof DataColumnTreeNode) {
                panel = ((DataColumnTreeNode)o).panel;
            }
            Rectangle nodeBounds = this.tree.getRowBounds(row);
            Point p = mevt.getPoint();
            p.x -= nodeBounds.x;
            p.y -= nodeBounds.y;
            if (panel.willThisCheck(p)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean shouldSelectCell(EventObject evt) {
        int row;
        TreePath path;
        MouseEvent mevt;
        if (evt instanceof MouseEvent && (mevt = (MouseEvent)evt).getClickCount() == 1 && (path = this.tree.getPathForRow(row = this.tree.getRowForLocation(mevt.getX(), mevt.getY()))) != null) {
            DataColumnTreePanel panel = null;
            Object o = path.getLastPathComponent();
            if (o instanceof DataColumnTreeNode) {
                panel = ((DataColumnTreeNode)o).panel;
            }
            Rectangle nodeBounds = this.tree.getRowBounds(row);
            Point p = mevt.getPoint();
            p.x -= nodeBounds.x;
            p.y -= nodeBounds.y;
            if (panel.willThisCheck(p)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void addCellEditorListener(CellEditorListener cl) {
    }

    @Override
    public void removeCellEditorListener(CellEditorListener cl) {
    }
}

