/*
 * Decompiled with CFR 0.152.
 */
package managers;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import managers.ErrorManager;
import model.storage.Query;
import util.FileUtils;
import util.JavaVMOptions;
import util.ProgramInfo;

public class DatabaseManager {
    private static DatabaseManager instance = null;
    private Connection conn = null;
    private List<String> registeredDatabases = new ArrayList<String>();

    private DatabaseManager() {
        try {
            Class.forName("org.sqlite.JDBC");
            this.conn = DriverManager.getConnection("jdbc:sqlite:");
            Statement stat = this.conn.createStatement();
            stat.execute("PRAGMA foreign_keys = ON");
            stat.execute("PRAGMA syncronous = OFF");
            stat.close();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static DatabaseManager getInstance() {
        if (instance == null) {
            instance = new DatabaseManager();
            return instance;
        }
        return instance;
    }

    public Connection getConnection() {
        return this.conn;
    }

    public List<String> getRegisteredDatabases() {
        ArrayList<String> tmp = new ArrayList<String>();
        tmp.addAll(this.registeredDatabases);
        return tmp;
    }

    public String createNewDatabase(String path) {
        try {
            String blankDBFilePath = ProgramInfo.get("TSC_BASE_SQLITE_DATABASE");
            if (JavaVMOptions.isJar()) {
                try {
                    FileUtils fu = new FileUtils();
                    fu.ExportResource(blankDBFilePath, path);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                FileUtils.copyFile(new File(blankDBFilePath), new File(path));
            }
        }
        catch (IOException e) {
            ErrorManager.getInstance().exception(e, "Could not copy base database");
            return null;
        }
        String db = this.registerDatabase(path);
        Query q = new Query("INSERT INTO #.versions (type, version) VALUES ('tscreator', :version)");
        q.useDatabase(db);
        q.setString("version", "HardCoded-1.0");
        q.executeUpdate();
        return db;
    }

    public String registerDatabase(String path) {
        String newDb = "db" + this.registeredDatabases.size();
        try {
            PreparedStatement stat = this.conn.prepareStatement("ATTACH ? AS ?");
            stat.setString(1, path);
            stat.setString(2, newDb);
            stat.execute();
            stat.close();
        }
        catch (SQLException e) {
            ErrorManager.getInstance().exception(e, "Was unable to register new database");
            return null;
        }
        this.registeredDatabases.add(newDb);
        return newDb;
    }

    public boolean unRegisterDatabases() {
        for (String database : this.registeredDatabases) {
            try {
                PreparedStatement stat = this.conn.prepareStatement("DETACH ?");
                stat.setString(1, database);
                stat.execute();
            }
            catch (SQLException e) {
                ErrorManager.getInstance().exception(e, "Could not detach database");
                return false;
            }
        }
        this.registeredDatabases.clear();
        return true;
    }

    public boolean startTransaction() {
        if (this.conn == null) {
            return false;
        }
        try {
            this.conn.createStatement().execute("BEGIN TRANSACTION");
        }
        catch (SQLException e) {
            ErrorManager.getInstance().exception(e, "Could not start database transaction");
            return false;
        }
        return true;
    }

    public boolean endTransaction() {
        if (this.conn == null) {
            return false;
        }
        try {
            this.conn.createStatement().execute("END TRANSACTION");
        }
        catch (SQLException e) {
            ErrorManager.getInstance().exception(e, "Could not end database transaction");
            return false;
        }
        return true;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }
}

