/*
 * Decompiled with CFR 0.152.
 */
package map;

import datastore.Datastore;
import gui.TSCAction;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import map.LegendCircle;
import map.MapCircle;
import map.MapPanel;

public class MapFrame
extends JFrame
implements ActionListener,
MouseWheelListener {
    private int PREFERRED_WIDTH = 680;
    private int PREFERRED_HEIGHT = 600;
    public boolean adjustText = true;
    BufferedImage mapImage;
    MapPanel mapPanel;
    JScrollPane scrollPane;
    private TSCAction generateAction = null;
    private JButton generateAndKeepOpenButton = null;
    private JButton generateFaciesMap = null;
    private JLabel baseLabel;
    JTextField myBaseField;
    private String myMap;

    public MapFrame(int appWidth, int appHeight, Datastore ds, String mapName) {
        Point newDimensions = this.setMyFrameSize(appWidth, appHeight);
        appWidth = newDimensions.x;
        appHeight = newDimensions.y;
        this.PREFERRED_WIDTH = newDimensions.x;
        this.PREFERRED_HEIGHT = newDimensions.y + 35;
        this.setTitle("Map Viewer");
        this.setSize(this.PREFERRED_WIDTH, this.PREFERRED_HEIGHT);
        this.setBackground(Color.gray);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        this.getContentPane().add(panel);
        this.myMap = mapName;
        this.mapPanel = new MapPanel(appWidth, appHeight, ds, true);
        this.mapPanel.loadMap(mapName);
        this.scrollPane = new JScrollPane(this.mapPanel);
        this.scrollPane.getViewport().add(this.mapPanel);
        this.scrollPane.addMouseWheelListener(this);
        this.scrollPane.setWheelScrollingEnabled(false);
        panel.add((Component)this.mapPanel, "Center");
        JPanel optionPanel = new JPanel();
        optionPanel.setLayout(new BorderLayout());
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        JButton zoomOut = new JButton("Zoom out");
        zoomOut.setActionCommand("zoomOut");
        zoomOut.addActionListener(this);
        buttonPanel.add(zoomOut);
        JButton zoomIn = new JButton("Zoom in");
        zoomIn.setActionCommand("zoomIn");
        zoomIn.addActionListener(this);
        buttonPanel.add(zoomIn);
        JButton reset = new JButton("Reset Zoom");
        reset.setActionCommand("resetZoom");
        reset.addActionListener(this);
        buttonPanel.add(reset);
        JPanel generatePanel = new JPanel();
        generatePanel.setLayout(new FlowLayout());
        JButton generateAndKeepOpenButton = new JButton("Generate");
        generateAndKeepOpenButton.setActionCommand("generateAndKeepOpenButton");
        generateAndKeepOpenButton.addActionListener(this);
        generatePanel.add(generateAndKeepOpenButton);
        JButton generateFaciesMap = new JButton("Facies Map");
        generateFaciesMap.setActionCommand("generateFaciesMap");
        generateFaciesMap.addActionListener(this);
        generatePanel.add(generateFaciesMap);
        JPanel legendPanel = new JPanel();
        legendPanel.setLayout(new FlowLayout());
        LegendCircle bt = new LegendCircle(MapCircle.COLOR_INFORMATIONAL);
        legendPanel.add(bt);
        legendPanel.add(new JLabel("Informational"));
        bt = new LegendCircle(MapCircle.COLOR_SELECTED);
        legendPanel.add(bt);
        legendPanel.add(new JLabel("Selected"));
        bt = new LegendCircle(MapCircle.COLOR_AVAILABLE);
        legendPanel.add(bt);
        legendPanel.add(new JLabel("Available"));
        bt = new LegendCircle(MapCircle.COLOR_NO_INTERVAL_DATA);
        legendPanel.add(bt);
        legendPanel.add(new JLabel("No Data In Time Interval."));
        optionPanel.add((Component)buttonPanel, "North");
        optionPanel.add((Component)generatePanel, "Center");
        optionPanel.add((Component)legendPanel, "South");
        panel.add((Component)optionPanel, "North");
        JPanel southPanel = new JPanel(new FlowLayout());
        southPanel.setBorder(BorderFactory.createTitledBorder("Instructions"));
        Dimension x = new Dimension(100, 100);
        southPanel.setPreferredSize(x);
        JScrollPane instructionPane = new JScrollPane(southPanel, 22, 30);
        instructionPane.createHorizontalScrollBar();
        instructionPane.getViewport().add(southPanel);
        this.addWindowFocusListener(new WindowAdapter(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                MapFrame.this.mapPanel.resetSelected();
                MapFrame.this.mapPanel.repaint();
            }
        });
    }

    public MapFrame(int appWidth, int appHeight, Datastore ds, String mapName, double myStart, double myEnd) {
        JSlider mySlider;
        Point newDimensions = this.setMyFrameSize(appWidth, appHeight);
        appWidth = newDimensions.x;
        appHeight = newDimensions.y;
        this.PREFERRED_WIDTH = newDimensions.x;
        this.PREFERRED_HEIGHT = newDimensions.y + 60;
        this.setTitle("Map Viewer");
        this.setSize(this.PREFERRED_WIDTH, this.PREFERRED_HEIGHT);
        this.setBackground(Color.gray);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        this.getContentPane().add(panel);
        this.myMap = mapName;
        this.mapPanel = new MapPanel(appWidth, appHeight, ds, false);
        this.mapPanel.loadMap(mapName);
        this.scrollPane = new JScrollPane(this.mapPanel);
        this.scrollPane.getViewport().add(this.mapPanel);
        this.scrollPane.addMouseWheelListener(this);
        this.scrollPane.setWheelScrollingEnabled(false);
        panel.add((Component)this.mapPanel, "Center");
        JPanel optionPanel = new JPanel();
        optionPanel.setLayout(new BorderLayout());
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        JButton zoomOut = new JButton("Zoom out");
        zoomOut.setActionCommand("zoomOut");
        zoomOut.addActionListener(this);
        buttonPanel.add(zoomOut);
        JButton zoomIn = new JButton("Zoom in");
        zoomIn.setActionCommand("zoomIn");
        zoomIn.addActionListener(this);
        buttonPanel.add(zoomIn);
        JButton reset = new JButton("Reset Zoom");
        reset.setActionCommand("resetZoom");
        reset.addActionListener(this);
        buttonPanel.add(reset);
        JButton generateAndKeepOpenButton = new JButton("Generate");
        generateAndKeepOpenButton.setActionCommand("generateAndKeepOpenButton");
        generateAndKeepOpenButton.addActionListener(this);
        buttonPanel.add(generateAndKeepOpenButton);
        JPanel basePanel = new JPanel();
        JLabel baseLabel = new JLabel("Age: ");
        basePanel.add(baseLabel);
        this.myBaseField = new JTextField(5);
        String timeString = Double.toString(myStart);
        basePanel.add(this.myBaseField);
        this.myBaseField.setText(timeString);
        JLabel dotLabel = new JLabel("Dot Size: ");
        basePanel.add(dotLabel);
        int minSize = 0;
        int maxSize = 12;
        final JSlider sizeSlider = new JSlider(0, minSize, maxSize, minSize);
        int sizeMinor = 1;
        int sizeMajor = 4;
        int sizeLabelVal = 4;
        sizeSlider.setMinorTickSpacing(sizeMinor);
        sizeSlider.setMajorTickSpacing(sizeMajor);
        sizeSlider.setPaintTicks(true);
        sizeSlider.setPaintLabels(true);
        sizeSlider.setLabelTable(sizeSlider.createStandardLabels(sizeLabelVal));
        sizeSlider.setPreferredSize(new Dimension(200, 35));
        basePanel.add(sizeSlider);
        sizeSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                int szValue;
                MapFrame.this.mapPanel.myDotSize = szValue = sizeSlider.getValue();
                MapFrame.this.mapPanel.resetSelected();
                MapFrame.this.mapPanel.repaint();
            }
        });
        JPanel sliderPanel = new JPanel();
        sliderPanel.setLayout(new FlowLayout());
        JLabel sliderLabel = new JLabel("Age Slider: ");
        sliderPanel.add(sliderLabel);
        int startRound = (int)Math.floor(myStart);
        int endRound = (int)Math.ceil(myEnd);
        if (myStart < 0.0) {
            startRound = 0;
        }
        while (startRound % 100 != 0) {
            --startRound;
        }
        while (endRound % 100 != 0) {
            ++endRound;
        }
        if (myStart < (double)startRound) {
            mySlider = new JSlider(0, startRound, endRound, (int)Math.floor(startRound));
            String readjustTime = Double.toString(startRound);
            this.myBaseField.setText(readjustTime);
        } else {
            mySlider = new JSlider(0, startRound, endRound, (int)Math.floor(myStart));
        }
        int myMinor = 10;
        int myMajor = 50;
        int myLabelVal = 100;
        if ((myStart >= 1000.0 || myEnd >= 1000.0) && myEnd - myStart > 1100.0) {
            myMinor = 100;
            myMajor = 500;
            myLabelVal = 1000;
        }
        mySlider.setMinorTickSpacing(myMinor);
        mySlider.setMajorTickSpacing(myMajor);
        mySlider.setPaintTicks(true);
        mySlider.setPaintLabels(true);
        mySlider.setLabelTable(mySlider.createStandardLabels(myLabelVal));
        mySlider.setPreferredSize(new Dimension(350, 35));
        sliderPanel.add(mySlider);
        mySlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                double value;
                MapFrame.this.mapPanel.myBase = value = (double)mySlider.getValue();
                String sValue = Double.toString(value);
                if (MapFrame.this.adjustText) {
                    MapFrame.this.myBaseField.setText(sValue);
                }
                MapFrame.this.adjustText = true;
                MapFrame.this.mapPanel.resetSelected();
                MapFrame.this.mapPanel.repaint();
            }
        });
        this.myBaseField.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent arg0) {
            }

            @Override
            public void keyReleased(KeyEvent arg0) {
                String derp = MapFrame.this.myBaseField.getText();
                MapFrame.this.mapPanel.myBase = Double.parseDouble(derp);
                MapFrame.this.adjustText = false;
                mySlider.setValue((int)MapFrame.this.mapPanel.myBase);
                MapFrame.this.mapPanel.resetSelected();
                MapFrame.this.mapPanel.repaint();
            }

            @Override
            public void keyTyped(KeyEvent arg0) {
            }
        });
        optionPanel.add((Component)buttonPanel, "North");
        optionPanel.add((Component)basePanel, "Center");
        optionPanel.add((Component)sliderPanel, "South");
        panel.add((Component)optionPanel, "North");
        JPanel southPanel = new JPanel(new FlowLayout());
        southPanel.setBorder(BorderFactory.createTitledBorder("Instructions"));
        Dimension x = new Dimension(100, 100);
        southPanel.setPreferredSize(x);
        JScrollPane instructionPane = new JScrollPane(southPanel, 22, 30);
        instructionPane.createHorizontalScrollBar();
        instructionPane.getViewport().add(southPanel);
        this.addWindowFocusListener(new WindowAdapter(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                MapFrame.this.mapPanel.resetSelected();
                MapFrame.this.mapPanel.repaint();
            }
        });
    }

    public final Point setMyFrameSize(int appWidth, int appHeight) {
        while (appWidth > 1000 || appHeight > 1000) {
            appWidth = (int)((double)appWidth * 0.75);
            appHeight = (int)((double)appHeight * 0.75);
        }
        while (appWidth < 500 || appHeight < 500) {
            appWidth = (int)((double)appWidth * 1.5);
            appHeight = (int)((double)appHeight * 1.5);
        }
        if (Toolkit.getDefaultToolkit().getScreenSize().width < appWidth || Toolkit.getDefaultToolkit().getScreenSize().height < appHeight) {
            appWidth = (int)((double)appWidth * 0.75);
            appHeight = (int)((double)appHeight * 0.75);
        }
        return new Point(appWidth, appHeight);
    }

    public void setMapGenerateAction(TSCAction a) {
        this.generateAction = a;
        this.mapPanel.setMapGenerateAction(this.generateAction);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        String source = evt.getActionCommand();
        if (source.equals("zoomIn")) {
            this.mapPanel.zoom(true);
        }
        if (source.equals("zoomOut") && this.mapPanel.getMapScale() > 1.0) {
            this.mapPanel.zoom(false);
        }
        if (source.equals("resetZoom")) {
            this.setSize(this.PREFERRED_WIDTH, this.PREFERRED_HEIGHT);
            this.mapPanel.resetZoom();
        }
        if (source.equals("generateAndKeepOpenButton")) {
            this.generateAction.actionPerformed(null);
        }
        if (source.equals("generateFaciesMap")) {
            this.mapPanel.newFaciesWindow(this.myMap);
        }
        if (source.equals("Close")) {
            this.mapPanel.closeTooltip();
            this.dispose();
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        int notches = e.getWheelRotation();
        if (notches < 0) {
            // empty if block
        }
    }
}

