/*
 * Decompiled with CFR 0.152.
 */
package map;

import datastore.Datastore;
import gui.TSCAction;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import map.MapFrame;
import map.MapInformation;

public class MapListPanel
extends JPanel {
    private Datastore ds;
    private MapFrame mf;
    private TSCAction generateAction = null;

    public MapListPanel(Datastore ds, TSCAction a) {
        this.ds = ds;
        this.add(new JLabel("No data yet added."));
        this.setLayout(new BoxLayout(this, 1));
    }

    private void updateParentMaps(MapInformation mi, ArrayList<MapInformation> mapsList) {
        if (mi.parentName != null) {
            this.updateParentMaps(this.ds.getMap(mi.parentName), mapsList);
        }
        if (mapsList.indexOf(mi) >= 0) {
            return;
        }
        mapsList.add(mi);
    }

    public void updateMapData() {
        this.removeAll();
        int rowCount = 0;
        boolean isLeft = true;
        Iterator it = this.ds.getMapIterator();
        ArrayList<MapInformation> mapList = new ArrayList<MapInformation>();
        while (it.hasNext()) {
            MapInformation mi = (MapInformation)it.next();
            this.updateParentMaps(mi, mapList);
        }
        for (MapInformation mi : mapList) {
            MapListing ml = new MapListing(mi, isLeft);
            this.add(ml);
            isLeft = !isLeft;
            ++rowCount;
        }
    }

    public void setMapGenerateAction(TSCAction a) {
        this.generateAction = a;
    }

    class MapListing
    extends JPanel
    implements MouseListener {
        Color defaultColor;
        MapInformation mapInformation;

        MapListing(MapInformation mi, boolean isLeft) {
            this.setLayout(new BoxLayout(this, 0));
            this.mapInformation = mi;
            ImageIcon ic = new ImageIcon(mi.imageName);
            Image img = this.getScaledImage(ic.getImage(), ic.getIconWidth(), ic.getIconHeight());
            JLabel imageIcon = new JLabel(new ImageIcon(img));
            imageIcon.setAlignmentX(0.5f);
            JLabel descriptionLabel = new JLabel("<html>" + mi.description + "</html>", 0);
            Font xx = descriptionLabel.getFont();
            int fontHeight = descriptionLabel.getFontMetrics(xx).getHeight();
            int stringWidth = descriptionLabel.getFontMetrics(xx).stringWidth(descriptionLabel.getText());
            int linesCount = (int)Math.floor(stringWidth / (descriptionLabel.getWidth() + 1));
            linesCount = Math.max(1, linesCount + 2);
            descriptionLabel.setPreferredSize(new Dimension(100, (fontHeight + 2) * linesCount));
            TitledBorder titledBorder = new TitledBorder(mi.mapName);
            if (isLeft) {
                this.add(imageIcon);
                this.add(new JPanel().add(Box.createRigidArea(new Dimension(10, 10))));
                this.add(descriptionLabel);
            } else {
                titledBorder.setTitleJustification(3);
                this.add(descriptionLabel);
                this.add(imageIcon);
            }
            this.setBorder(titledBorder);
            this.addMouseListener(this);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            System.out.println("Mouse Clicked");
            BufferedImage image = null;
            try {
                image = ImageIO.read(new File(this.mapInformation.imageName));
            }
            catch (IOException ex) {
                System.out.println("FATAL ERROR: could not load map image.");
                ex.printStackTrace();
                System.exit(1);
            }
            MapListPanel.this.mf = new MapFrame(image.getWidth(), image.getHeight(), MapListPanel.this.ds, this.mapInformation.mapName);
            MapListPanel.this.mf.setMapGenerateAction(MapListPanel.this.generateAction);
            MapListPanel.this.mf.setLocationRelativeTo(null);
            MapListPanel.this.mf.setVisible(true);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (this.defaultColor == null) {
                this.defaultColor = this.getBackground();
            }
            this.setBackground(Color.YELLOW);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.setBackground(this.defaultColor);
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        private Image getScaledImage(Image srcImg, int w, int h) {
            while (w > 200 || h > 200) {
                w = (int)((double)w * 0.75);
                h = (int)((double)h * 0.75);
            }
            BufferedImage resizedImg = new BufferedImage(w, h, 1);
            Graphics2D g2 = resizedImg.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g2.drawImage(srcImg, 0, 0, w, h, null);
            g2.dispose();
            return resizedImg;
        }
    }
}

