/*
 * Decompiled with CFR 0.152.
 */
package map;

import gui.ErrorHandler;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.HashMap;
import map.MapCoordinates;

public class MapRectangularCoordinates
extends MapCoordinates {
    public Point2D.Double upperLeft;
    public Point2D.Double lowerRight;

    @Override
    public void parseCoordinates(HashMap<String, Integer> header, String[] values) {
        double lon = Double.parseDouble(values[header.get("UPPER LEFT LON")]);
        double lat = Double.parseDouble(values[header.get("UPPER LEFT LAT")]);
        this.upperLeft = new Point2D.Double(lon, lat);
        lon = Double.parseDouble(values[header.get("LOWER RIGHT LON")]);
        lat = Double.parseDouble(values[header.get("LOWER RIGHT LAT")]);
        this.lowerRight = new Point2D.Double(lon, lat);
    }

    @Override
    public void parseCoordinates(HashMap<String, Integer> header, String[] values, int lineNumber, String fileName) {
        try {
            double lon = 0.0;
            if (header.get("UPPER LEFT LONG") != null) {
                lon = Double.parseDouble(values[header.get("UPPER LEFT LONG")]);
            } else if (header.get("UPPER LEFT LON") != null) {
                lon = Double.parseDouble(values[header.get("UPPER LEFT LON")]);
            }
            double lat = Double.parseDouble(values[header.get("UPPER LEFT LAT")]);
            this.upperLeft = new Point2D.Double(lon, lat);
            if (header.get("LOWER RIGHT LONG") != null) {
                lon = Double.parseDouble(values[header.get("LOWER RIGHT LONG")]);
            } else if (header.get("UPPER LEFT LON") != null) {
                lon = Double.parseDouble(values[header.get("LOWER RIGHT LON")]);
            }
            lat = Double.parseDouble(values[header.get("LOWER RIGHT LAT")]);
            this.lowerRight = new Point2D.Double(lon, lat);
        }
        catch (NullPointerException e) {
            String exceptionMessage = "Expected \"UPPER LEFT LON\", \"UPPER LEFT LAT\", \"LOWER RIGHT LON\" OR \"LOWER RIGHT LAT\" on line " + String.valueOf(lineNumber + "\n") + "In file: " + fileName;
            String exceptionMessageTitle = "Invalid Header Error Detected";
            ErrorHandler.showError(e, exceptionMessage, exceptionMessageTitle, 3);
        }
    }

    @Override
    public Point convertCoordinates(Object[] params) {
        double longitude = (Double)params[0];
        double latitude = (Double)params[1];
        int frameWidth = (Integer)params[2];
        int frameHeight = (Integer)params[3];
        int newLong = this.upperLeft.x < 0.0 ? (int)((double)frameWidth * Math.abs(longitude - this.upperLeft.x) / Math.abs(this.upperLeft.x - this.lowerRight.x)) : (int)((double)frameWidth * Math.abs(longitude - this.upperLeft.x) / Math.abs(this.upperLeft.x - this.lowerRight.x));
        int newLat = this.upperLeft.y > 0.0 ? (int)((double)frameHeight * Math.abs(this.upperLeft.y - latitude) / Math.abs(this.upperLeft.y - this.lowerRight.y)) : (int)((double)frameHeight * Math.abs(this.upperLeft.y - latitude) / Math.abs(this.lowerRight.y - this.upperLeft.y));
        return new Point(newLong, newLat);
    }

    public static String getMapByName() {
        return "RECTANGULAR";
    }
}

