/*
 * Decompiled with CFR 0.152.
 */
package model;

import model.Column;
import model.ModelIdentifier;
import model.storage.DataStorage;
import model.storage.Storage;
import model.util.SourceResult;

public abstract class Data {
    private ModelIdentifier identifier = null;
    private Column column = null;
    private double beginAge = 0.0;
    private double endAge = 0.0;
    private String uncertainty = null;
    private int priority = 0;
    private String popup = "";
    private boolean deleted = false;
    private String creationDate = "";
    private String lastModified = "";

    public Data() {
    }

    public Data(Column c, String database) {
        this.column = c;
        this.setDataIdentifier(new ModelIdentifier(0, database, 2));
    }

    public Data(Column c, SourceResult result) {
        this.column = c;
        this.setDataIdentifier(new ModelIdentifier(result.getInt("id"), result.getString("database"), 2));
        this.setBeginAge(result.getDouble("begin_age"));
        this.setEndAge(result.getDouble("end_age"));
        this.setUncertainty(result.getString("uncertainty"));
        this.setPriority(result.getInt("priority"));
        this.setPopup(result.getString("popup"));
        this.setDataDeleted(result.getBool("deleted"));
        this.setDataCreationDate(result.getString("creationDate"));
        this.setDataLastModified(result.getString("lastModified"));
    }

    public void save() {
        if (this.identifier == null) {
            return;
        }
        if (this.identifier.getId() == 0) {
            DataStorage.insert(this);
            this.getDataIdentifier().setId(Storage.getLastInsertId().getInt("id"));
        } else {
            DataStorage.update(this);
        }
    }

    public Column getColumn() {
        return this.column;
    }

    public double getBeginAge() {
        return this.beginAge;
    }

    public final void setBeginAge(double age) {
        this.beginAge = age;
    }

    public double getEndAge() {
        return this.endAge;
    }

    public final void setEndAge(double age) {
        this.endAge = age;
    }

    public final ModelIdentifier getDataIdentifier() {
        return this.identifier;
    }

    public abstract ModelIdentifier getIdentifier();

    public String getPopup() {
        return this.popup;
    }

    public int getPriority() {
        return this.priority;
    }

    public String getUncertainty() {
        return this.uncertainty;
    }

    public final void setDataIdentifier(ModelIdentifier identifier) {
        this.identifier = identifier;
    }

    public final void setPopup(String popup) {
        this.popup = popup;
    }

    public final void setPriority(int priority) {
        this.priority = priority;
    }

    public final void setUncertainty(String uncertainty) {
        this.uncertainty = uncertainty;
    }

    public boolean isDataDeleted() {
        return this.deleted;
    }

    public final void setDataDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public String getDataLastModified() {
        return this.lastModified;
    }

    private void setDataLastModified(String lastModified) {
        this.lastModified = lastModified;
    }

    public String getDataCreationDate() {
        return this.creationDate;
    }

    private void setDataCreationDate(String creationDate) {
        this.creationDate = creationDate;
    }

    public String toString() {
        return "DATA: [ Identifier( " + this.identifier.toString() + ") beginAge = " + this.getBeginAge() + " endAge = " + this.getEndAge() + " uncertainty = " + this.getUncertainty() + " priority = " + this.getPriority() + " popup = " + this.getPopup() + " deleted = " + this.isDataDeleted() + " creationDate = " + this.getDataCreationDate() + " lastModified = " + this.getDataLastModified() + "]";
    }
}

