/*
 * Decompiled with CFR 0.152.
 */
package model;

import java.util.ArrayList;
import java.util.List;
import model.Column;
import model.FreehandImageData;
import model.FreehandPolygonData;
import model.ModelIdentifier;
import model.storage.FreehandColumnStorage;
import model.storage.Storage;
import model.util.SourceResult;

public class FreehandColumn
extends Column {
    private ModelIdentifier identifier = null;
    private boolean deleted = false;
    private String creationDate = "";
    private String lastModified = "";

    public FreehandColumn(String database) {
        super(database);
        this.setIdentifier(new ModelIdentifier(0, database, 12));
    }

    public FreehandColumn(ModelIdentifier id, SourceResult result) {
        super(result);
        this.setIdentifier(id);
        this.setDeleted(result.getBool("deleted"));
        this.setCreationDate(result.getString("creationDate"));
        this.setLastModified(result.getString("lastModified"));
    }

    @Override
    public void save() {
        super.save();
        if (this.identifier == null) {
            return;
        }
        if (this.identifier.getId() == 0) {
            FreehandColumnStorage.insert(this);
            this.getIdentifier().setId(Storage.getLastInsertId().getInt("id"));
        } else {
            FreehandColumnStorage.update(this);
        }
    }

    @Override
    public ModelIdentifier getIdentifier() {
        return this.identifier;
    }

    @Override
    public final void setIdentifier(ModelIdentifier identifier) {
        this.identifier = identifier;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public final void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public String getLastModified() {
        return this.lastModified;
    }

    private void setLastModified(String lastModified) {
        this.lastModified = lastModified;
    }

    public String getCreationDate() {
        return this.creationDate;
    }

    private void setCreationDate(String creationDate) {
        this.creationDate = creationDate;
    }

    public List<FreehandImageData> getImageDataByAge(double top, double bottom) {
        return FreehandImageData.Factory.getByAge(this, top, bottom);
    }

    public List<FreehandPolygonData> getPolygonDataByAge(double top, double bottom) {
        return FreehandPolygonData.Factory.getByAge(this, top, bottom);
    }

    public static class Factory {
        public static List<FreehandColumn> getByTitle(String title) {
            List<SourceResult> results = FreehandColumnStorage.findByTitle(title);
            List<ModelIdentifier> ids = ModelIdentifier.Factory.translateSourceResult(results, 12);
            return Factory.getByIdentifiers(ids);
        }

        public static FreehandColumn getByIdentifier(ModelIdentifier id) {
            List<Object> freehandColumns = new ArrayList();
            ArrayList<ModelIdentifier> ids = new ArrayList<ModelIdentifier>();
            ids.add(id);
            freehandColumns = Factory.getByIdentifiers(ids);
            if (freehandColumns.isEmpty()) {
                return null;
            }
            return (FreehandColumn)freehandColumns.get(0);
        }

        public static List<FreehandColumn> getByIdentifiers(List<ModelIdentifier> ids) {
            ArrayList<FreehandColumn> freehandColumns = new ArrayList<FreehandColumn>();
            List<SourceResult> results = FreehandColumnStorage.load(ids);
            for (int i = 0; i < results.size(); ++i) {
                freehandColumns.add(new FreehandColumn(ids.get(i), results.get(i)));
            }
            return freehandColumns;
        }
    }
}

