/*
 * Decompiled with CFR 0.152.
 */
package model;

import java.util.ArrayList;
import java.util.List;
import model.Column;
import model.Data;
import model.FreehandColumn;
import model.FreehandPoint;
import model.ModelIdentifier;
import model.Pattern;
import model.storage.FreehandPointStorage;
import model.storage.FreehandPolygonDataStorage;
import model.storage.Storage;
import model.util.SourceResult;

public class FreehandPolygonData
extends Data {
    private ModelIdentifier identifier = null;
    private List<FreehandPoint> points = null;
    private boolean closed = false;
    private Pattern pattern = null;
    private boolean deleted = false;
    private String creationDate = "";
    private String lastModified = "";

    public FreehandPolygonData(FreehandColumn c, String database) {
        super((Column)c, database);
        this.setIdentifier(new ModelIdentifier(0, database, 14));
    }

    public FreehandPolygonData(FreehandColumn col, ModelIdentifier identifier, SourceResult result) {
        super((Column)col, result);
        this.setIdentifier(identifier);
        this.setClosed(result.getBool("closed"));
        this.setDeleted(result.getBool("deleted"));
        this.setCreationDate(result.getString("creationDate"));
        this.setLastModified(result.getString("lastModified"));
    }

    @Override
    public final void save() {
        super.save();
        if (this.identifier == null) {
            return;
        }
        if (this.identifier.getId() == 0) {
            for (FreehandPoint p : this.points) {
                FreehandPointStorage.insert(p);
            }
            FreehandPolygonDataStorage.insert(this);
            this.getIdentifier().setId(Storage.getLastInsertId().getInt("id"));
        } else {
            FreehandPolygonDataStorage.update(this);
        }
    }

    private void loadPoints() {
        if (this.points == null) {
            this.points = FreehandPoint.Factory.getByPolygon(this);
        }
    }

    private void loadPattern() {
        if (this.pattern == null) {
            this.pattern = Pattern.Factory.getByFreehandPolygon(this);
        }
    }

    @Override
    public ModelIdentifier getIdentifier() {
        return this.identifier;
    }

    public final void setIdentifier(ModelIdentifier identifier) {
        this.identifier = identifier;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public final void setClosed(boolean closed) {
        this.closed = closed;
    }

    public List<FreehandPoint> getPoints() {
        this.loadPoints();
        return this.points;
    }

    public FreehandPoint getPoint(int i) {
        this.loadPoints();
        return this.points.get(i);
    }

    public Pattern getPattern() {
        this.loadPattern();
        return this.pattern;
    }

    public final void setPattern(Pattern pattern) {
        this.pattern = pattern;
    }

    public void addPoint(FreehandPoint point) {
        this.loadPoints();
        this.points.add(point);
    }

    public void addPoints(List<FreehandPoint> points) {
        this.loadPoints();
        this.points.addAll(points);
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public final void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public String getLastModified() {
        return this.lastModified;
    }

    private void setLastModified(String lastModified) {
        this.lastModified = lastModified;
    }

    public String getCreationDate() {
        return this.creationDate;
    }

    private void setCreationDate(String creationDate) {
        this.creationDate = creationDate;
    }

    public static class Factory {
        public static FreehandPolygonData getByIdentifier(FreehandColumn c, ModelIdentifier id) {
            List<Object> freehandPolygonData = new ArrayList();
            ArrayList<ModelIdentifier> ids = new ArrayList<ModelIdentifier>();
            ids.add(id);
            freehandPolygonData = Factory.getByIdentifiers(c, ids);
            if (freehandPolygonData.isEmpty()) {
                return null;
            }
            return (FreehandPolygonData)freehandPolygonData.get(0);
        }

        public static List<FreehandPolygonData> getByIdentifiers(FreehandColumn col, List<ModelIdentifier> ids) {
            ArrayList<FreehandPolygonData> transectPolygonData = new ArrayList<FreehandPolygonData>();
            List<SourceResult> results = FreehandPolygonDataStorage.load(ids);
            for (int i = 0; i < results.size(); ++i) {
                transectPolygonData.add(new FreehandPolygonData(col, ids.get(i), results.get(i)));
            }
            return transectPolygonData;
        }

        public static List<FreehandPolygonData> getByAge(FreehandColumn col, double startAge, double endAge) {
            List<SourceResult> results = FreehandPolygonDataStorage.findByAge(col, startAge, endAge);
            List<ModelIdentifier> ids = ModelIdentifier.Factory.translateSourceResult(results, 14);
            return Factory.getByIdentifiers(col, ids);
        }
    }
}

