/*
 * Decompiled with CFR 0.152.
 */
package model;

import java.util.ArrayList;
import java.util.List;
import model.Column;
import model.ModelIdentifier;
import model.PointData;
import model.storage.PointColumnStorage;
import model.storage.Storage;
import model.util.SourceResult;

public class PointColumn
extends Column {
    private ModelIdentifier identifier = null;
    private boolean line = false;
    private String fillColor = "";
    private double rangeLow = 0.0;
    private double rangeHigh = 0.0;
    private boolean smoothed = false;
    private boolean deleted = false;
    private String creationDate = "";
    private String lastModified = "";

    public PointColumn(String database) {
        super(database);
        this.setIdentifier(new ModelIdentifier(0, database, 16));
    }

    public PointColumn(ModelIdentifier id, SourceResult result) {
        super(result);
        this.setIdentifier(id);
        this.setLine(result.getBool("line"));
        this.setFillColor(result.getString("fill_color"));
        this.setRangeLow(result.getDouble("range_low"));
        this.setRangeHigh(result.getDouble("range_high"));
        this.setSmoothed(result.getBool("smoothed"));
    }

    @Override
    public void save() {
        super.save();
        if (this.identifier == null) {
            return;
        }
        if (this.identifier.getId() == 0) {
            PointColumnStorage.insert(this);
            this.getIdentifier().setId(Storage.getLastInsertId().getInt("id"));
        } else {
            PointColumnStorage.update(this);
        }
    }

    public List<PointData> getDataByAge(double top, double bottom) {
        return PointData.Factory.getByAge(this, top, bottom);
    }

    @Override
    public ModelIdentifier getIdentifier() {
        return this.identifier;
    }

    @Override
    public final void setIdentifier(ModelIdentifier identifier) {
        this.identifier = identifier;
    }

    public String getFillColor() {
        return this.fillColor;
    }

    public final void setFillColor(String fillColor) {
        this.fillColor = fillColor;
    }

    public boolean isLine() {
        return this.line;
    }

    public final void setLine(boolean line) {
        this.line = line;
    }

    public double getRangeHigh() {
        return this.rangeHigh;
    }

    public final void setRangeHigh(double rangeHigh) {
        this.rangeHigh = rangeHigh;
    }

    public double getRangeLow() {
        return this.rangeLow;
    }

    public final void setRangeLow(double rangeLow) {
        this.rangeLow = rangeLow;
    }

    public boolean isSmoothed() {
        return this.smoothed;
    }

    public final void setSmoothed(boolean smoothed) {
        this.smoothed = smoothed;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public String getLastModified() {
        return this.lastModified;
    }

    private void setLastModified(String lastModified) {
        this.lastModified = lastModified;
    }

    public String getCreationDate() {
        return this.creationDate;
    }

    private void setCreationDate(String creationDate) {
        this.creationDate = creationDate;
    }

    public static class Factory {
        public static List<PointColumn> getByTitle(String title) {
            List<SourceResult> results = PointColumnStorage.findByTitle(title);
            List<ModelIdentifier> ids = ModelIdentifier.Factory.translateSourceResult(results, 16);
            return Factory.getByIdentifiers(ids);
        }

        public static PointColumn getByIdentifier(ModelIdentifier id) {
            List<Object> pointColumns = new ArrayList();
            ArrayList<ModelIdentifier> ids = new ArrayList<ModelIdentifier>();
            ids.add(id);
            pointColumns = Factory.getByIdentifiers(ids);
            if (pointColumns.isEmpty()) {
                return null;
            }
            return (PointColumn)pointColumns.get(0);
        }

        public static List<PointColumn> getByIdentifiers(List<ModelIdentifier> ids) {
            ArrayList<PointColumn> pointColumns = new ArrayList<PointColumn>();
            List<SourceResult> results = PointColumnStorage.load(ids);
            for (int i = 0; i < results.size(); ++i) {
                pointColumns.add(new PointColumn(ids.get(i), results.get(i)));
            }
            return pointColumns;
        }
    }
}

