/*
 * Decompiled with CFR 0.152.
 */
package model;

import java.util.ArrayList;
import java.util.List;
import model.Column;
import model.ModelIdentifier;
import model.RangeData;
import model.storage.RangeColumnStorage;
import model.storage.Storage;
import model.util.SourceResult;

public class RangeColumn
extends Column {
    private ModelIdentifier identifier = null;
    private boolean deleted = false;
    private String creationDate = "";
    private String lastModified = "";

    public RangeColumn(String database) {
        super(database);
        this.setIdentifier(new ModelIdentifier(0, database, 18));
    }

    public RangeColumn(ModelIdentifier id, SourceResult result) {
        super(result);
        this.setIdentifier(id);
        this.setDeleted(result.getBool("deleted"));
        this.setCreationDate(result.getString("creationDate"));
        this.setLastModified(result.getString("lastModified"));
    }

    @Override
    public final void save() {
        super.save();
        if (this.identifier == null) {
            return;
        }
        if (this.identifier.getId() == 0) {
            RangeColumnStorage.insert(this);
            this.getIdentifier().setId(Storage.getLastInsertId().getInt("id"));
        } else {
            RangeColumnStorage.update(this);
        }
    }

    @Override
    public ModelIdentifier getIdentifier() {
        return this.identifier;
    }

    @Override
    public final void setIdentifier(ModelIdentifier identifier) {
        this.identifier = identifier;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public final void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public String getLastModified() {
        return this.lastModified;
    }

    private void setLastModified(String lastModified) {
        this.lastModified = lastModified;
    }

    public String getCreationDate() {
        return this.creationDate;
    }

    private void setCreationDate(String creationDate) {
        this.creationDate = creationDate;
    }

    public List<RangeData> getDataByAge(double top, double bottom) {
        return RangeData.Factory.getByAge(this, top, bottom);
    }

    public static class Factory {
        public static List<RangeColumn> getByTitle(String title) {
            List<SourceResult> results = RangeColumnStorage.findByTitle(title);
            List<ModelIdentifier> ids = ModelIdentifier.Factory.translateSourceResult(results, 4);
            return Factory.getByIdentifiers(ids);
        }

        public static RangeColumn getByIdentifier(ModelIdentifier id) {
            List<Object> rangeColumns = new ArrayList();
            ArrayList<ModelIdentifier> ids = new ArrayList<ModelIdentifier>();
            ids.add(id);
            rangeColumns = Factory.getByIdentifiers(ids);
            if (rangeColumns.isEmpty()) {
                return null;
            }
            return (RangeColumn)rangeColumns.get(0);
        }

        public static List<RangeColumn> getByIdentifiers(List<ModelIdentifier> ids) {
            ArrayList<RangeColumn> rangeColumns = new ArrayList<RangeColumn>();
            List<SourceResult> results = RangeColumnStorage.load(ids);
            for (int i = 0; i < results.size(); ++i) {
                rangeColumns.add(new RangeColumn(ids.get(i), results.get(i)));
            }
            return rangeColumns;
        }
    }
}

