/*
 * Decompiled with CFR 0.152.
 */
package model;

import java.util.ArrayList;
import java.util.List;
import model.Column;
import model.Data;
import model.ModelIdentifier;
import model.RangeColumn;
import model.storage.RangeDataStorage;
import model.storage.Storage;
import model.util.SourceResult;

public class RangeData
extends Data {
    private ModelIdentifier identifier = null;
    private String label = "";
    private String abundance = "";
    private String color = "";
    private boolean deleted = false;
    private String creationDate = "";
    private String lastModified = "";

    public RangeData(RangeColumn c, String database) {
        super((Column)c, database);
        this.setIdentifier(new ModelIdentifier(0, database, 19));
    }

    public RangeData(RangeColumn c, ModelIdentifier id, SourceResult result) {
        super((Column)c, result);
        this.setIdentifier(id);
        this.setLabel(result.getString("label"));
        this.setAbundance(result.getString("abundance"));
        this.setColor(result.getString("color"));
        this.setDeleted(result.getBool("deleted"));
        this.setCreationDate(result.getString("creationDate"));
        this.setLastModified(result.getString("lastModified"));
    }

    @Override
    public final void save() {
        super.save();
        if (this.identifier == null) {
            return;
        }
        if (this.identifier.getId() == 0) {
            RangeDataStorage.insert(this);
            this.getIdentifier().setId(Storage.getLastInsertId().getInt("id"));
        } else {
            RangeDataStorage.update(this);
        }
    }

    @Override
    public ModelIdentifier getIdentifier() {
        return this.identifier;
    }

    public final void setIdentifier(ModelIdentifier identifier) {
        this.identifier = identifier;
    }

    public String getColor() {
        return this.color;
    }

    public final void setColor(String color) {
        this.color = color;
    }

    public String getAbundance() {
        return this.abundance;
    }

    public final void setAbundance(String abundance) {
        this.abundance = abundance;
    }

    public String getLabel() {
        return this.label;
    }

    public final void setLabel(String label) {
        this.label = label;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public final void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public String getLastModified() {
        return this.lastModified;
    }

    private void setLastModified(String lastModified) {
        this.lastModified = lastModified;
    }

    public String getCreationDate() {
        return this.creationDate;
    }

    private void setCreationDate(String creationDate) {
        this.creationDate = creationDate;
    }

    public static class Factory {
        public static RangeData getByIdentifier(RangeColumn c, ModelIdentifier id) {
            List<Object> rangeData = new ArrayList();
            ArrayList<ModelIdentifier> ids = new ArrayList<ModelIdentifier>();
            ids.add(id);
            rangeData = Factory.getByIdentifiers(c, ids);
            if (rangeData.isEmpty()) {
                return null;
            }
            return (RangeData)rangeData.get(0);
        }

        public static List<RangeData> getByIdentifiers(RangeColumn c, List<ModelIdentifier> ids) {
            ArrayList<RangeData> rangeData = new ArrayList<RangeData>();
            List<SourceResult> results = RangeDataStorage.load(ids);
            for (int i = 0; i < results.size(); ++i) {
                rangeData.add(new RangeData(c, ids.get(i), results.get(i)));
            }
            return rangeData;
        }

        public static List<RangeData> getByAge(RangeColumn c, double top, double bottom) {
            List<SourceResult> results = RangeDataStorage.findByAge(c, top, bottom);
            List<ModelIdentifier> ids = ModelIdentifier.Factory.translateSourceResult(results, 19);
            return Factory.getByIdentifiers(c, ids);
        }
    }
}

