/*
 * Decompiled with CFR 0.152.
 */
package model;

import java.util.ArrayList;
import java.util.List;
import model.Column;
import model.Data;
import model.ModelIdentifier;
import model.Pattern;
import model.TransectColumn;
import model.TransectLine;
import model.storage.Storage;
import model.storage.TransectPolygonDataStorage;
import model.util.SourceResult;

public class TransectPolygonData
extends Data {
    private ModelIdentifier identifier = null;
    private List<TransectLine> lines = null;
    private Pattern pattern = null;
    private boolean deleted = false;
    private String creationDate = "";
    private String lastModified = "";

    public TransectPolygonData(TransectColumn c, String database) {
        super((Column)c, database);
        this.setIdentifier(new ModelIdentifier(0, database, 23));
    }

    public TransectPolygonData(TransectColumn col, ModelIdentifier identifier, SourceResult result) {
        super((Column)col, result);
        this.setIdentifier(identifier);
        this.setDeleted(result.getBool("deleted"));
        this.setCreationDate(result.getString("creationDate"));
        this.setLastModified(result.getString("lastModified"));
    }

    @Override
    public final void save() {
        super.save();
        if (this.identifier == null) {
            return;
        }
        if (this.identifier.getId() == 0) {
            TransectPolygonDataStorage.insert(this);
            this.getIdentifier().setId(Storage.getLastInsertId().getInt("id"));
        } else {
            TransectPolygonDataStorage.update(this);
        }
    }

    private void loadLines() {
        if (this.lines == null) {
            this.lines = TransectLine.Factory.getByPolygon(this);
        }
    }

    private void loadPattern() {
        if (this.pattern == null) {
            this.pattern = Pattern.Factory.getByTransectPolygon(this);
        }
    }

    @Override
    public ModelIdentifier getIdentifier() {
        return this.identifier;
    }

    public final void setIdentifier(ModelIdentifier identifier) {
        this.identifier = identifier;
    }

    public Pattern getPattern() {
        this.loadPattern();
        return this.pattern;
    }

    public final void setPattern(Pattern pattern) {
        this.pattern = pattern;
    }

    public List<TransectLine> getLines() {
        this.loadLines();
        return this.lines;
    }

    public TransectLine getLine(int i) {
        this.loadLines();
        return this.lines.get(i);
    }

    public void addLine(TransectLine line) {
        this.loadLines();
        this.lines.add(line);
    }

    public void addLines(List<TransectLine> lines) {
        this.loadLines();
        this.lines.addAll(lines);
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public final void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public String getLastModified() {
        return this.lastModified;
    }

    private void setLastModified(String lastModified) {
        this.lastModified = lastModified;
    }

    public String getCreationDate() {
        return this.creationDate;
    }

    private void setCreationDate(String creationDate) {
        this.creationDate = creationDate;
    }

    public static class Factory {
        public static TransectPolygonData getByIdentifier(TransectColumn c, ModelIdentifier id) {
            List<Object> transectPolygonData = new ArrayList();
            ArrayList<ModelIdentifier> ids = new ArrayList<ModelIdentifier>();
            ids.add(id);
            transectPolygonData = Factory.getByIdentifiers(c, ids);
            if (transectPolygonData.isEmpty()) {
                return null;
            }
            return (TransectPolygonData)transectPolygonData.get(0);
        }

        public static List<TransectPolygonData> getByIdentifiers(TransectColumn col, List<ModelIdentifier> ids) {
            ArrayList<TransectPolygonData> transectPolygonData = new ArrayList<TransectPolygonData>();
            List<SourceResult> results = TransectPolygonDataStorage.load(ids);
            for (int i = 0; i < results.size(); ++i) {
                transectPolygonData.add(new TransectPolygonData(col, ids.get(i), results.get(i)));
            }
            return transectPolygonData;
        }

        public static List<TransectPolygonData> getByAge(TransectColumn col, double startAge, double endAge) {
            List<SourceResult> results = TransectPolygonDataStorage.findByAge(col, startAge, endAge);
            List<ModelIdentifier> ids = ModelIdentifier.Factory.translateSourceResult(results, 23);
            return Factory.getByIdentifiers(col, ids);
        }
    }
}

