/*
 * Decompiled with CFR 0.152.
 */
package model.storage;

import java.util.ArrayList;
import java.util.List;
import model.BlankColumn;
import model.ModelIdentifier;
import model.storage.ColumnStorage;
import model.storage.Query;
import model.util.SourceResult;

public class BlankColumnStorage
extends ColumnStorage {
    public static void insert(BlankColumn col) {
        Query query = new Query("INSERT INTO #.blank_columns               (id, columns_id)               VALUES (NULL, :columnid)");
        query.useDatabase(col.getColumnIdentifier().getDatabase());
        query.setInt("columnid", col.getColumnIdentifier().getId());
        query.executeUpdate();
        query.close();
    }

    public static void update(BlankColumn col) {
        Query query = new Query("UPDATE #.blank_columns         SET columns_id = :columnid         WHERE id = :id");
        query.setInt("id", col.getIdentifier().getId());
        query.useDatabase(col.getColumnIdentifier().getDatabase());
        query.setInt("columnid", col.getColumnIdentifier().getId());
        query.executeUpdate();
        query.close();
    }

    public static List<SourceResult> load(List<ModelIdentifier> ids) {
        ArrayList<SourceResult> results = new ArrayList();
        results = ColumnStorage.load(ids);
        Query query = new Query("SELECT bc.id               FROM #.blank_columns AS bc               WHERE bc.columns_id = :id");
        for (int i = 0; i < ids.size(); ++i) {
            ModelIdentifier id = ids.get(i);
            query.setInt("id", id.getId());
            query.useDatabase(id.getDatabase());
            ((SourceResult)results.get(i)).putAll(query.executeQuery().get(0));
        }
        query.close();
        return results;
    }

    public static List<SourceResult> findByTitle(String title) {
        Query query = new Query("SELECT '#' AS database, dc.id AS id               FROM #.columns AS col                 JOIN #.blank_columns AS blankcol ON (blankcol.columns_id = col.id)               WHERE col.title LIKE :title                 AND NOT blankcol.deleted                 AND NOT col.deleted                 AND col.overlay_id IS NULL");
        return query.executeQuery();
    }
}

