/*
 * Decompiled with CFR 0.152.
 */
package model.storage;

import java.util.ArrayList;
import java.util.List;
import model.FreehandColumn;
import model.FreehandPolygonData;
import model.ModelIdentifier;
import model.storage.DataStorage;
import model.storage.Query;
import model.util.SourceResult;

public class FreehandPolygonDataStorage
extends DataStorage {
    public static void insert(FreehandPolygonData data) {
        Query query = new Query("INSERT INTO #.freehand_polygons       (id, data_id, freehand_columns_id, closed, patterns_id,       deleted)       VALUES (NULL, :data_id, :freehand_columns_id,               :closed, :patterns_id, :deleted)");
        query.useDatabase(data.getIdentifier().getDatabase());
        query.setInt("freehand_columns_id", data.getColumn().getIdentifier().getId());
        query.setInt("data_id", data.getDataIdentifier().getId());
        query.setBoolean("closed", data.isClosed());
        query.setInt("patterns_id", data.getPattern().getIdentifier().getId());
        query.setBoolean("deleted", data.isDeleted());
        query.executeUpdate();
        query.close();
    }

    public static void update(FreehandPolygonData data) {
        Query query = new Query("UPDATE #.freehand_polygons       SET freehand_columns_id = :freehand_column_id,         closed = :closed, patterns_id = :patterns_id       WHERE id = :id");
        query.useDatabase(data.getIdentifier().getDatabase());
        query.setInt("id", data.getIdentifier().getId());
        query.setInt("freehand_column_id", data.getColumn().getIdentifier().getId());
        query.setBoolean("closed", data.isClosed());
        query.setInt("patterns_id", data.getPattern().getIdentifier().getId());
        query.executeUpdate();
        query.close();
    }

    public static List<SourceResult> load(List<ModelIdentifier> ids) {
        ArrayList<SourceResult> results = new ArrayList();
        results = DataStorage.load(ids);
        Query query = new Query("SELECT closed, deleted, last_modified, creation_date         FROM #.freehand_polygons         WHERE data_id = :id");
        for (int i = 0; i < ids.size(); ++i) {
            ModelIdentifier id = ids.get(i);
            query.useDatabase(id.getDatabase());
            query.setInt("id", id.getId());
            ((SourceResult)results.get(i)).putAll(query.executeQuery().get(0));
        }
        query.close();
        return results;
    }

    public static List<SourceResult> findByAge(FreehandColumn col, double top, double bottom) {
        Query query = new Query("SELECT '#' AS database, data.id       FROM #.data as data         JOIN #.freehand_polygons as freehandpoly ON ( data.id = freehandpoly.data_id)      WHERE freehandpoly.freehand_columns_id = :freehand_column_id         AND data.begin_age >= :begin_age         AND data.end_age <= :end_age         AND NOT data.deleted        AND NOT freehandpoly.deleted");
        query.useDatabase(col.getIdentifier().getDatabase());
        query.setInt("freehand_column_id", col.getIdentifier().getId());
        query.setDouble("begin_age", top);
        query.setDouble("end_age", bottom);
        List<SourceResult> results = query.executeQuery();
        query.close();
        return results;
    }
}

