/*
 * Decompiled with CFR 0.152.
 */
package model.util;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import managers.ErrorManager;

public class SourceResult
extends HashMap<String, Object> {
    public int getInt(String key) {
        if (super.get(key) == null) {
            return 0;
        }
        return (Integer)super.get(key);
    }

    public double getDouble(String key) {
        if (super.get(key) == null) {
            return 0.0;
        }
        return (Double)super.get(key);
    }

    public String getString(String key) {
        return (String)super.get(key);
    }

    public boolean getBool(String key) {
        return (Integer)super.get(key) == 1;
    }

    public void set(String key, Object data) {
        super.put(key, data);
    }

    public static List<SourceResult> translateResultSet(ResultSet rs) {
        ArrayList<SourceResult> results = new ArrayList<SourceResult>();
        ArrayList<String> columns = new ArrayList<String>();
        if (rs == null) {
            return results;
        }
        try {
            ResultSetMetaData metaData = rs.getMetaData();
            for (int i = 1; i <= metaData.getColumnCount(); ++i) {
                columns.add(metaData.getColumnName(i));
            }
            while (rs.next()) {
                SourceResult result = new SourceResult();
                for (String column : columns) {
                    result.set(column, rs.getObject(column));
                }
                results.add(result);
            }
        }
        catch (SQLException e) {
            ErrorManager.getInstance().exception(e, "Could not translate ResultSet to SourceResultSet");
            results.clear();
            return results;
        }
        return results;
    }
}

