/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.swing.svg;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.BridgeExtension;
import org.apache.batik.bridge.DefaultScriptSecurity;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.ExternalResourceSecurity;
import org.apache.batik.bridge.RelaxedExternalResourceSecurity;
import org.apache.batik.bridge.ScriptSecurity;
import org.apache.batik.bridge.UpdateManager;
import org.apache.batik.bridge.UpdateManagerEvent;
import org.apache.batik.bridge.UpdateManagerListener;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.ViewBox;
import org.apache.batik.bridge.svg12.SVG12BridgeContext;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.util.DOMUtilities;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.ext.awt.image.spi.ImageTagRegistry;
import org.apache.batik.gvt.CanvasGraphicsNode;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.event.AWTEventDispatcher;
import org.apache.batik.gvt.event.EventDispatcher;
import org.apache.batik.gvt.renderer.ImageRenderer;
import org.apache.batik.gvt.text.Mark;
import org.apache.batik.swing.gvt.AbstractJGVTComponent;
import org.apache.batik.swing.gvt.GVTTreeRendererEvent;
import org.apache.batik.swing.gvt.JGVTComponent;
import org.apache.batik.swing.gvt.JGVTComponentListener;
import org.apache.batik.swing.svg.AbstractJSVGComponent;
import org.apache.batik.swing.svg.GVTTreeBuilder;
import org.apache.batik.swing.svg.GVTTreeBuilderEvent;
import org.apache.batik.swing.svg.GVTTreeBuilderListener;
import org.apache.batik.swing.svg.LinkActivationEvent;
import org.apache.batik.swing.svg.LinkActivationListener;
import org.apache.batik.swing.svg.Messages;
import org.apache.batik.swing.svg.SVGDocumentLoader;
import org.apache.batik.swing.svg.SVGDocumentLoaderEvent;
import org.apache.batik.swing.svg.SVGDocumentLoaderListener;
import org.apache.batik.swing.svg.SVGLoadEventDispatcher;
import org.apache.batik.swing.svg.SVGLoadEventDispatcherEvent;
import org.apache.batik.swing.svg.SVGLoadEventDispatcherListener;
import org.apache.batik.swing.svg.SVGUpdateOverlay;
import org.apache.batik.swing.svg.SVGUserAgent;
import org.apache.batik.util.ParsedURL;
import org.apache.batik.util.RunnableQueue;
import org.apache.batik.util.SVGFeatureStrings;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGAElement;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGSVGElement;

public class AbstractJSVGComponent
extends JGVTComponent {
    public static final int AUTODETECT = 0;
    public static final int ALWAYS_DYNAMIC = 1;
    public static final int ALWAYS_STATIC = 2;
    public static final int ALWAYS_INTERACTIVE = 3;
    public static final String SCRIPT_ALERT = "script.alert";
    public static final String SCRIPT_PROMPT = "script.prompt";
    public static final String SCRIPT_CONFIRM = "script.confirm";
    public static final String BROKEN_LINK_TITLE = "broken.link.title";
    protected SVGDocumentLoader documentLoader;
    protected SVGDocumentLoader nextDocumentLoader;
    protected DocumentLoader loader;
    protected GVTTreeBuilder gvtTreeBuilder;
    protected GVTTreeBuilder nextGVTTreeBuilder;
    protected SVGLoadEventDispatcher svgLoadEventDispatcher;
    protected UpdateManager updateManager;
    protected UpdateManager nextUpdateManager;
    protected SVGDocument svgDocument;
    protected List svgDocumentLoaderListeners = new LinkedList();
    protected List gvtTreeBuilderListeners = new LinkedList();
    protected List svgLoadEventDispatcherListeners = new LinkedList();
    protected List linkActivationListeners = new LinkedList();
    protected List updateManagerListeners = new LinkedList();
    protected UserAgent userAgent;
    protected SVGUserAgent svgUserAgent;
    protected BridgeContext bridgeContext;
    protected String fragmentIdentifier;
    protected boolean isDynamicDocument;
    protected boolean isInteractiveDocument;
    protected boolean selfCallingDisableInteractions = false;
    protected boolean userSetDisableInteractions = false;
    protected int documentState;
    protected Dimension prevComponentSize;
    protected Runnable afterStopRunnable = null;
    protected SVGUpdateOverlay updateOverlay;
    protected boolean recenterOnResize = true;
    protected AffineTransform viewingTransform = null;
    protected int animationLimitingMode;
    protected float animationLimitingAmount;
    protected JSVGComponentListener jsvgComponentListener = new JSVGComponentListener();
    protected static final Set FEATURES = new HashSet();
    static /* synthetic */ Class class$org$apache$batik$swing$svg$AbstractJSVGComponent;

    public AbstractJSVGComponent() {
        this(null, false, false);
    }

    public AbstractJSVGComponent(SVGUserAgent sVGUserAgent, boolean bl, boolean bl2) {
        super(bl, bl2);
        this.svgUserAgent = sVGUserAgent;
        this.userAgent = new BridgeUserAgentWrapper(this.createUserAgent());
        this.addSVGDocumentLoaderListener((SVGListener)this.listener);
        this.addGVTTreeBuilderListener((SVGListener)this.listener);
        this.addSVGLoadEventDispatcherListener((SVGListener)this.listener);
        if (this.updateOverlay != null) {
            this.getOverlays().add(this.updateOverlay);
        }
    }

    public void dispose() {
        this.setSVGDocument(null);
    }

    public void setDisableInteractions(boolean bl) {
        super.setDisableInteractions(bl);
        if (!this.selfCallingDisableInteractions) {
            this.userSetDisableInteractions = true;
        }
    }

    public void clearUserSetDisableInteractions() {
        this.userSetDisableInteractions = false;
        this.updateZoomAndPanEnable(this.svgDocument);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateZoomAndPanEnable(Document document) {
        if (this.userSetDisableInteractions) {
            return;
        }
        if (document == null) {
            return;
        }
        try {
            Element element = document.getDocumentElement();
            String string = element.getAttributeNS(null, "zoomAndPan");
            boolean bl = "magnify".equals(string);
            this.selfCallingDisableInteractions = true;
            this.setDisableInteractions(!bl);
        }
        finally {
            this.selfCallingDisableInteractions = false;
        }
    }

    public boolean getRecenterOnResize() {
        return this.recenterOnResize;
    }

    public void setRecenterOnResize(boolean bl) {
        this.recenterOnResize = bl;
    }

    public boolean isDynamic() {
        return this.isDynamicDocument;
    }

    public boolean isInteractive() {
        return this.isInteractiveDocument;
    }

    public void setDocumentState(int n) {
        this.documentState = n;
    }

    public UpdateManager getUpdateManager() {
        if (this.svgLoadEventDispatcher != null) {
            return this.svgLoadEventDispatcher.getUpdateManager();
        }
        if (this.nextUpdateManager != null) {
            return this.nextUpdateManager;
        }
        return this.updateManager;
    }

    public void resumeProcessing() {
        if (this.updateManager != null) {
            this.updateManager.resume();
        }
    }

    public void suspendProcessing() {
        if (this.updateManager != null) {
            this.updateManager.suspend();
        }
    }

    public void stopProcessing() {
        this.nextDocumentLoader = null;
        this.nextGVTTreeBuilder = null;
        if (this.documentLoader != null) {
            this.documentLoader.halt();
        }
        if (this.gvtTreeBuilder != null) {
            this.gvtTreeBuilder.halt();
        }
        if (this.svgLoadEventDispatcher != null) {
            this.svgLoadEventDispatcher.halt();
        }
        if (this.nextUpdateManager != null) {
            this.nextUpdateManager.interrupt();
            this.nextUpdateManager = null;
        }
        if (this.updateManager != null) {
            this.updateManager.interrupt();
        }
        super.stopProcessing();
    }

    public void loadSVGDocument(String string) {
        String string2 = null;
        if (this.svgDocument != null) {
            string2 = this.svgDocument.getURL();
        }
        final ParsedURL parsedURL = new ParsedURL(string2, string);
        this.stopThenRun(new Runnable(){

            public void run() {
                String string = parsedURL.toString();
                AbstractJSVGComponent.this.fragmentIdentifier = parsedURL.getRef();
                AbstractJSVGComponent.this.loader = new DocumentLoader(AbstractJSVGComponent.this.userAgent);
                AbstractJSVGComponent.this.nextDocumentLoader = new SVGDocumentLoader(string, AbstractJSVGComponent.this.loader);
                AbstractJSVGComponent.this.nextDocumentLoader.setPriority(1);
                Iterator iterator = AbstractJSVGComponent.this.svgDocumentLoaderListeners.iterator();
                while (iterator.hasNext()) {
                    AbstractJSVGComponent.this.nextDocumentLoader.addSVGDocumentLoaderListener((SVGDocumentLoaderListener)iterator.next());
                }
                AbstractJSVGComponent.this.startDocumentLoader();
            }
        });
    }

    private void startDocumentLoader() {
        this.documentLoader = this.nextDocumentLoader;
        this.nextDocumentLoader = null;
        this.documentLoader.start();
    }

    public void setDocument(Document document) {
        if (document != null && !(document.getImplementation() instanceof SVGDOMImplementation)) {
            Document document2;
            DOMImplementation dOMImplementation = SVGDOMImplementation.getDOMImplementation();
            document = document2 = DOMUtilities.deepCloneDocument(document, dOMImplementation);
        }
        this.setSVGDocument((SVGDocument)document);
    }

    public void setSVGDocument(SVGDocument sVGDocument) {
        Object object;
        if (sVGDocument != null && !(sVGDocument.getImplementation() instanceof SVGDOMImplementation)) {
            object = SVGDOMImplementation.getDOMImplementation();
            Document document = DOMUtilities.deepCloneDocument(sVGDocument, (DOMImplementation)object);
            sVGDocument = (SVGDocument)document;
        }
        object = sVGDocument;
        this.stopThenRun(new Runnable((SVGDocument)object){
            private final /* synthetic */ SVGDocument val$svgdoc;
            {
                this.val$svgdoc = sVGDocument;
            }

            public void run() {
                AbstractJSVGComponent.this.installSVGDocument(this.val$svgdoc);
            }
        });
    }

    protected void stopThenRun(Runnable runnable) {
        if (this.afterStopRunnable != null) {
            this.afterStopRunnable = runnable;
            return;
        }
        this.afterStopRunnable = runnable;
        this.stopProcessing();
        if (this.documentLoader == null && this.gvtTreeBuilder == null && this.gvtTreeRenderer == null && this.svgLoadEventDispatcher == null && this.nextUpdateManager == null && this.updateManager == null) {
            Runnable runnable2 = this.afterStopRunnable;
            this.afterStopRunnable = null;
            runnable2.run();
        }
    }

    protected void installSVGDocument(SVGDocument sVGDocument) {
        this.svgDocument = sVGDocument;
        if (this.bridgeContext != null) {
            this.bridgeContext.dispose();
            this.bridgeContext = null;
        }
        this.releaseRenderingReferences();
        if (sVGDocument == null) {
            this.isDynamicDocument = false;
            this.isInteractiveDocument = false;
            this.disableInteractions = true;
            this.initialTransform = new AffineTransform();
            this.setRenderingTransform(this.initialTransform, false);
            Rectangle rectangle = this.getRenderRect();
            this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            return;
        }
        this.bridgeContext = this.createBridgeContext((SVGOMDocument)sVGDocument);
        switch (this.documentState) {
            case 2: {
                this.isDynamicDocument = false;
                this.isInteractiveDocument = false;
                break;
            }
            case 3: {
                this.isDynamicDocument = false;
                this.isInteractiveDocument = true;
                break;
            }
            case 1: {
                this.isDynamicDocument = true;
                this.isInteractiveDocument = true;
                break;
            }
            case 0: {
                this.isDynamicDocument = this.bridgeContext.isDynamicDocument(sVGDocument);
                boolean bl = this.isInteractiveDocument = this.isDynamicDocument || this.bridgeContext.isInteractiveDocument(sVGDocument);
            }
        }
        if (this.isInteractiveDocument) {
            if (this.isDynamicDocument) {
                this.bridgeContext.setDynamicState(2);
            } else {
                this.bridgeContext.setDynamicState(1);
            }
        }
        this.setBridgeContextAnimationLimitingMode();
        this.updateZoomAndPanEnable(sVGDocument);
        this.nextGVTTreeBuilder = new GVTTreeBuilder(sVGDocument, this.bridgeContext);
        this.nextGVTTreeBuilder.setPriority(1);
        Iterator iterator = this.gvtTreeBuilderListeners.iterator();
        while (iterator.hasNext()) {
            this.nextGVTTreeBuilder.addGVTTreeBuilderListener((GVTTreeBuilderListener)iterator.next());
        }
        this.initializeEventHandling();
        if (this.gvtTreeBuilder == null && this.documentLoader == null && this.gvtTreeRenderer == null && this.svgLoadEventDispatcher == null && this.updateManager == null) {
            this.startGVTTreeBuilder();
        }
    }

    protected void startGVTTreeBuilder() {
        this.gvtTreeBuilder = this.nextGVTTreeBuilder;
        this.nextGVTTreeBuilder = null;
        this.gvtTreeBuilder.start();
    }

    public SVGDocument getSVGDocument() {
        return this.svgDocument;
    }

    public Dimension2D getSVGDocumentSize() {
        return this.bridgeContext.getDocumentSize();
    }

    public String getFragmentIdentifier() {
        return this.fragmentIdentifier;
    }

    public void setFragmentIdentifier(String string) {
        this.fragmentIdentifier = string;
        if (this.computeRenderingTransform()) {
            this.scheduleGVTRendering();
        }
    }

    public void flushImageCache() {
        ImageTagRegistry imageTagRegistry = ImageTagRegistry.getRegistry();
        imageTagRegistry.flushCache();
    }

    public void setGraphicsNode(GraphicsNode graphicsNode, boolean bl) {
        Dimension2D dimension2D = this.bridgeContext.getDocumentSize();
        Dimension dimension = new Dimension((int)dimension2D.getWidth(), (int)dimension2D.getHeight());
        this.setMySize(dimension);
        SVGSVGElement sVGSVGElement = this.svgDocument.getRootElement();
        this.prevComponentSize = this.getSize();
        AffineTransform affineTransform = this.calculateViewingTransform(this.fragmentIdentifier, sVGSVGElement);
        CanvasGraphicsNode canvasGraphicsNode = this.getCanvasGraphicsNode(graphicsNode);
        canvasGraphicsNode.setViewingTransform(affineTransform);
        this.viewingTransform = null;
        this.initialTransform = new AffineTransform();
        this.setRenderingTransform(this.initialTransform, false);
        this.jsvgComponentListener.updateMatrix(this.initialTransform);
        this.addJGVTComponentListener(this.jsvgComponentListener);
        this.addComponentListener(this.jsvgComponentListener);
        super.setGraphicsNode(graphicsNode, bl);
    }

    protected BridgeContext createBridgeContext(SVGOMDocument sVGOMDocument) {
        if (this.loader == null) {
            this.loader = new DocumentLoader(this.userAgent);
        }
        BridgeContext bridgeContext = sVGOMDocument.isSVG12() ? new SVG12BridgeContext(this.userAgent, this.loader) : new BridgeContext(this.userAgent, this.loader);
        return bridgeContext;
    }

    protected void startSVGLoadEventDispatcher(GraphicsNode graphicsNode) {
        UpdateManager updateManager = new UpdateManager(this.bridgeContext, graphicsNode, this.svgDocument);
        this.svgLoadEventDispatcher = new SVGLoadEventDispatcher(graphicsNode, this.svgDocument, this.bridgeContext, updateManager);
        Iterator iterator = this.svgLoadEventDispatcherListeners.iterator();
        while (iterator.hasNext()) {
            this.svgLoadEventDispatcher.addSVGLoadEventDispatcherListener((SVGLoadEventDispatcherListener)iterator.next());
        }
        this.svgLoadEventDispatcher.start();
    }

    protected ImageRenderer createImageRenderer() {
        if (this.isDynamicDocument) {
            return this.rendererFactory.createDynamicImageRenderer();
        }
        return this.rendererFactory.createStaticImageRenderer();
    }

    public CanvasGraphicsNode getCanvasGraphicsNode() {
        return this.getCanvasGraphicsNode(this.gvtRoot);
    }

    protected CanvasGraphicsNode getCanvasGraphicsNode(GraphicsNode graphicsNode) {
        if (!(graphicsNode instanceof CompositeGraphicsNode)) {
            return null;
        }
        CompositeGraphicsNode compositeGraphicsNode = (CompositeGraphicsNode)graphicsNode;
        List list = compositeGraphicsNode.getChildren();
        if (list.size() == 0) {
            return null;
        }
        graphicsNode = (GraphicsNode)list.get(0);
        if (!(graphicsNode instanceof CanvasGraphicsNode)) {
            return null;
        }
        return (CanvasGraphicsNode)graphicsNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AffineTransform getViewingTransform() {
        AffineTransform affineTransform;
        AbstractJSVGComponent abstractJSVGComponent = this;
        synchronized (abstractJSVGComponent) {
            CanvasGraphicsNode canvasGraphicsNode;
            affineTransform = this.viewingTransform;
            if (affineTransform == null && (canvasGraphicsNode = this.getCanvasGraphicsNode()) != null) {
                affineTransform = canvasGraphicsNode.getViewingTransform();
            }
        }
        return affineTransform;
    }

    public AffineTransform getViewBoxTransform() {
        AffineTransform affineTransform = this.getRenderingTransform();
        affineTransform = affineTransform == null ? new AffineTransform() : new AffineTransform(affineTransform);
        AffineTransform affineTransform2 = this.getViewingTransform();
        if (affineTransform2 != null) {
            affineTransform.concatenate(affineTransform2);
        }
        return affineTransform;
    }

    protected boolean computeRenderingTransform() {
        if (this.svgDocument == null || this.gvtRoot == null) {
            return false;
        }
        boolean bl = this.updateRenderingTransform();
        this.initialTransform = new AffineTransform();
        if (!this.initialTransform.equals(this.getRenderingTransform())) {
            this.setRenderingTransform(this.initialTransform, false);
            bl = true;
        }
        return bl;
    }

    protected AffineTransform calculateViewingTransform(String string, SVGSVGElement sVGSVGElement) {
        Dimension dimension = this.getSize();
        if (dimension.width < 1) {
            dimension.width = 1;
        }
        if (dimension.height < 1) {
            dimension.height = 1;
        }
        return ViewBox.getViewTransform(string, sVGSVGElement, dimension.width, dimension.height, this.bridgeContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean updateRenderingTransform() {
        if (this.svgDocument == null || this.gvtRoot == null) {
            return false;
        }
        try {
            AffineTransform affineTransform;
            AffineTransform affineTransform2;
            AffineTransform affineTransform3;
            SVGSVGElement sVGSVGElement = this.svgDocument.getRootElement();
            Dimension dimension = this.getSize();
            Dimension dimension2 = this.prevComponentSize;
            if (dimension2 == null) {
                dimension2 = dimension;
            }
            this.prevComponentSize = dimension;
            if (dimension.width < 1) {
                dimension.width = 1;
            }
            if (dimension.height < 1) {
                dimension.height = 1;
            }
            if ((affineTransform3 = this.calculateViewingTransform(this.fragmentIdentifier, sVGSVGElement)).equals(affineTransform2 = this.getViewingTransform())) {
                return dimension2.width != dimension.width || dimension2.height != dimension.height;
            }
            if (!this.recenterOnResize) {
                return true;
            }
            Point2D point2D = new Point2D.Float((float)dimension2.width / 2.0f, (float)dimension2.height / 2.0f);
            AffineTransform affineTransform4 = this.getRenderingTransform();
            if (affineTransform4 != null) {
                try {
                    affineTransform = affineTransform4.createInverse();
                    point2D = affineTransform.transform(point2D, null);
                }
                catch (NoninvertibleTransformException noninvertibleTransformException) {
                    // empty catch block
                }
            }
            if (affineTransform2 != null) {
                try {
                    affineTransform = affineTransform2.createInverse();
                    point2D = affineTransform.transform(point2D, null);
                }
                catch (NoninvertibleTransformException noninvertibleTransformException) {
                    // empty catch block
                }
            }
            if (affineTransform3 != null) {
                point2D = affineTransform3.transform(point2D, null);
            }
            if (affineTransform4 != null) {
                point2D = affineTransform4.transform(point2D, null);
            }
            float f = (float)((double)((float)dimension.width / 2.0f) - point2D.getX());
            float f2 = (float)((double)((float)dimension.height / 2.0f) - point2D.getY());
            f = (int)(f < 0.0f ? (double)f - 0.5 : (double)f + 0.5);
            f2 = (int)(f2 < 0.0f ? (double)f2 - 0.5 : (double)f2 + 0.5);
            if (f != 0.0f || f2 != 0.0f) {
                affineTransform4.preConcatenate(AffineTransform.getTranslateInstance(f, f2));
                this.setRenderingTransform(affineTransform4, false);
            }
            Object object = this;
            synchronized (object) {
                this.viewingTransform = affineTransform3;
            }
            object = new Runnable(affineTransform3){
                AffineTransform myAT;
                CanvasGraphicsNode myCGN;
                private final /* synthetic */ AffineTransform val$at;
                {
                    this.myAT = this.val$at = affineTransform;
                    this.myCGN = AbstractJSVGComponent.this.getCanvasGraphicsNode();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    AbstractJSVGComponent abstractJSVGComponent = AbstractJSVGComponent.this;
                    synchronized (abstractJSVGComponent) {
                        this.myCGN.setViewingTransform(this.myAT);
                        if (AbstractJSVGComponent.this.viewingTransform == this.myAT) {
                            AbstractJSVGComponent.this.viewingTransform = null;
                        }
                    }
                }
            };
            UpdateManager updateManager = this.getUpdateManager();
            if (updateManager != null) {
                updateManager.getUpdateRunnableQueue().invokeLater((Runnable)object);
            } else {
                object.run();
            }
        }
        catch (BridgeException bridgeException) {
            this.userAgent.displayError(bridgeException);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderGVTTree() {
        class UpdateRenderingRunnable
        implements Runnable {
            AffineTransform at;
            boolean doubleBuf;
            boolean clearPaintTrans;
            Shape aoi;
            int width;
            int height;
            boolean active;

            public UpdateRenderingRunnable(AffineTransform affineTransform, boolean bl, boolean bl2, Shape shape, int n, int n2) {
                this.updateInfo(affineTransform, bl, bl2, shape, n, n2);
                this.active = true;
            }

            public void updateInfo(AffineTransform affineTransform, boolean bl, boolean bl2, Shape shape, int n, int n2) {
                this.at = affineTransform;
                this.doubleBuf = bl;
                this.clearPaintTrans = bl2;
                this.aoi = shape;
                this.width = n;
                this.height = n2;
                this.active = true;
            }

            public void deactivate() {
                this.active = false;
            }

            public void run() {
                if (!this.active) {
                    return;
                }
                AbstractJSVGComponent.this.updateManager.updateRendering(this.at, this.doubleBuf, this.clearPaintTrans, this.aoi, this.width, this.height);
            }
        }
        if (!this.isInteractiveDocument || this.updateManager == null || !this.updateManager.isRunning()) {
            super.renderGVTTree();
            return;
        }
        Rectangle rectangle = this.getRenderRect();
        if (this.gvtRoot == null || rectangle.width <= 0 || rectangle.height <= 0) {
            return;
        }
        AffineTransform affineTransform = null;
        try {
            affineTransform = this.renderingTransform.createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
        Shape shape = affineTransform == null ? rectangle : affineTransform.createTransformedShape(rectangle);
        RunnableQueue runnableQueue = this.updateManager.getUpdateRunnableQueue();
        Object object = runnableQueue.getIteratorLock();
        synchronized (object) {
            Iterator iterator = runnableQueue.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof UpdateRenderingRunnable)) continue;
                ((UpdateRenderingRunnable)e).deactivate();
            }
        }
        runnableQueue.invokeLater(new UpdateRenderingRunnable(this.renderingTransform, this.doubleBufferedRendering, true, shape, rectangle.width, rectangle.height));
    }

    protected void handleException(Exception exception) {
        this.userAgent.displayError(exception);
    }

    public void addSVGDocumentLoaderListener(SVGDocumentLoaderListener sVGDocumentLoaderListener) {
        this.svgDocumentLoaderListeners.add(sVGDocumentLoaderListener);
    }

    public void removeSVGDocumentLoaderListener(SVGDocumentLoaderListener sVGDocumentLoaderListener) {
        this.svgDocumentLoaderListeners.remove(sVGDocumentLoaderListener);
    }

    public void addGVTTreeBuilderListener(GVTTreeBuilderListener gVTTreeBuilderListener) {
        this.gvtTreeBuilderListeners.add(gVTTreeBuilderListener);
    }

    public void removeGVTTreeBuilderListener(GVTTreeBuilderListener gVTTreeBuilderListener) {
        this.gvtTreeBuilderListeners.remove(gVTTreeBuilderListener);
    }

    public void addSVGLoadEventDispatcherListener(SVGLoadEventDispatcherListener sVGLoadEventDispatcherListener) {
        this.svgLoadEventDispatcherListeners.add(sVGLoadEventDispatcherListener);
    }

    public void removeSVGLoadEventDispatcherListener(SVGLoadEventDispatcherListener sVGLoadEventDispatcherListener) {
        this.svgLoadEventDispatcherListeners.remove(sVGLoadEventDispatcherListener);
    }

    public void addLinkActivationListener(LinkActivationListener linkActivationListener) {
        this.linkActivationListeners.add(linkActivationListener);
    }

    public void removeLinkActivationListener(LinkActivationListener linkActivationListener) {
        this.linkActivationListeners.remove(linkActivationListener);
    }

    public void addUpdateManagerListener(UpdateManagerListener updateManagerListener) {
        this.updateManagerListeners.add(updateManagerListener);
    }

    public void removeUpdateManagerListener(UpdateManagerListener updateManagerListener) {
        this.updateManagerListeners.remove(updateManagerListener);
    }

    public void showAlert(String string) {
        JOptionPane.showMessageDialog(this, Messages.formatMessage(SCRIPT_ALERT, new Object[]{string}));
    }

    public String showPrompt(String string) {
        return JOptionPane.showInputDialog(this, (Object)Messages.formatMessage(SCRIPT_PROMPT, new Object[]{string}));
    }

    public String showPrompt(String string, String string2) {
        return (String)JOptionPane.showInputDialog(this, Messages.formatMessage(SCRIPT_PROMPT, new Object[]{string}), null, -1, null, null, string2);
    }

    public boolean showConfirm(String string) {
        return JOptionPane.showConfirmDialog(this, Messages.formatMessage(SCRIPT_CONFIRM, new Object[]{string}), "Confirm", 0) == 0;
    }

    public void setMySize(Dimension dimension) {
        this.setPreferredSize(dimension);
        this.invalidate();
    }

    public void setAnimationLimitingNone() {
        this.animationLimitingMode = 0;
        if (this.bridgeContext != null) {
            this.setBridgeContextAnimationLimitingMode();
        }
    }

    public void setAnimationLimitingCPU(float f) {
        this.animationLimitingMode = 1;
        this.animationLimitingAmount = f;
        if (this.bridgeContext != null) {
            this.setBridgeContextAnimationLimitingMode();
        }
    }

    public void setAnimationLimitingFPS(float f) {
        this.animationLimitingMode = 2;
        this.animationLimitingAmount = f;
        if (this.bridgeContext != null) {
            this.setBridgeContextAnimationLimitingMode();
        }
    }

    protected void setBridgeContextAnimationLimitingMode() {
        switch (this.animationLimitingMode) {
            case 0: {
                this.bridgeContext.setAnimationLimitingNone();
                break;
            }
            case 1: {
                this.bridgeContext.setAnimationLimitingCPU(this.animationLimitingAmount);
                break;
            }
            case 2: {
                this.bridgeContext.setAnimationLimitingFPS(this.animationLimitingAmount);
            }
        }
    }

    protected AbstractJGVTComponent.Listener createListener() {
        return new SVGListener();
    }

    protected UserAgent createUserAgent() {
        return new BridgeUserAgent();
    }

    static /* synthetic */ boolean access$1102(AbstractJSVGComponent abstractJSVGComponent, boolean bl) {
        abstractJSVGComponent.suspendInteractions = bl;
        return abstractJSVGComponent.suspendInteractions;
    }

    static /* synthetic */ boolean access$1200(AbstractJSVGComponent abstractJSVGComponent) {
        return abstractJSVGComponent.doubleBufferedRendering;
    }

    static /* synthetic */ BufferedImage access$1302(AbstractJSVGComponent abstractJSVGComponent, BufferedImage bufferedImage) {
        abstractJSVGComponent.image = bufferedImage;
        return abstractJSVGComponent.image;
    }

    static /* synthetic */ BufferedImage access$1402(AbstractJSVGComponent abstractJSVGComponent, BufferedImage bufferedImage) {
        abstractJSVGComponent.image = bufferedImage;
        return abstractJSVGComponent.image;
    }

    static /* synthetic */ AffineTransform access$1502(AbstractJSVGComponent abstractJSVGComponent, AffineTransform affineTransform) {
        abstractJSVGComponent.paintingTransform = affineTransform;
        return abstractJSVGComponent.paintingTransform;
    }

    static /* synthetic */ boolean access$1600(AbstractJSVGComponent abstractJSVGComponent) {
        return abstractJSVGComponent.doubleBufferedRendering;
    }

    static /* synthetic */ boolean access$1702(AbstractJSVGComponent abstractJSVGComponent, boolean bl) {
        abstractJSVGComponent.suspendInteractions = bl;
        return abstractJSVGComponent.suspendInteractions;
    }

    static /* synthetic */ AWTEventDispatcher access$1800(AbstractJSVGComponent abstractJSVGComponent) {
        return abstractJSVGComponent.eventDispatcher;
    }

    static /* synthetic */ AWTEventDispatcher access$1900(AbstractJSVGComponent abstractJSVGComponent) {
        return abstractJSVGComponent.eventDispatcher;
    }

    static /* synthetic */ AWTEventDispatcher access$2000(AbstractJSVGComponent abstractJSVGComponent) {
        return abstractJSVGComponent.eventDispatcher;
    }

    static /* synthetic */ AWTEventDispatcher access$2100(AbstractJSVGComponent abstractJSVGComponent) {
        return abstractJSVGComponent.eventDispatcher;
    }

    static /* synthetic */ AWTEventDispatcher access$2200(AbstractJSVGComponent abstractJSVGComponent) {
        return abstractJSVGComponent.eventDispatcher;
    }

    static /* synthetic */ AWTEventDispatcher access$2300(AbstractJSVGComponent abstractJSVGComponent) {
        return abstractJSVGComponent.eventDispatcher;
    }

    static /* synthetic */ AWTEventDispatcher access$2400(AbstractJSVGComponent abstractJSVGComponent) {
        return abstractJSVGComponent.eventDispatcher;
    }

    static /* synthetic */ AWTEventDispatcher access$2500(AbstractJSVGComponent abstractJSVGComponent) {
        return abstractJSVGComponent.eventDispatcher;
    }

    static /* synthetic */ AWTEventDispatcher access$2600(AbstractJSVGComponent abstractJSVGComponent) {
        return abstractJSVGComponent.eventDispatcher;
    }

    static /* synthetic */ AWTEventDispatcher access$2700(AbstractJSVGComponent abstractJSVGComponent) {
        return abstractJSVGComponent.eventDispatcher;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        SVGFeatureStrings.addSupportedFeatureStrings(FEATURES);
    }

    protected class BridgeUserAgent
    implements UserAgent {
        protected Map extensions = new HashMap();

        protected BridgeUserAgent() {
        }

        public Dimension2D getViewportSize() {
            return AbstractJSVGComponent.this.getSize();
        }

        public EventDispatcher getEventDispatcher() {
            return AbstractJSVGComponent.this.eventDispatcher;
        }

        public void displayError(String string) {
            if (AbstractJSVGComponent.this.svgUserAgent != null) {
                AbstractJSVGComponent.this.svgUserAgent.displayError(string);
            }
        }

        public void displayError(Exception exception) {
            if (AbstractJSVGComponent.this.svgUserAgent != null) {
                AbstractJSVGComponent.this.svgUserAgent.displayError(exception);
            }
        }

        public void displayMessage(String string) {
            if (AbstractJSVGComponent.this.svgUserAgent != null) {
                AbstractJSVGComponent.this.svgUserAgent.displayMessage(string);
            }
        }

        public void showAlert(String string) {
            if (AbstractJSVGComponent.this.svgUserAgent != null) {
                AbstractJSVGComponent.this.svgUserAgent.showAlert(string);
                return;
            }
            AbstractJSVGComponent.this.showAlert(string);
        }

        public String showPrompt(String string) {
            if (AbstractJSVGComponent.this.svgUserAgent != null) {
                return AbstractJSVGComponent.this.svgUserAgent.showPrompt(string);
            }
            return AbstractJSVGComponent.this.showPrompt(string);
        }

        public String showPrompt(String string, String string2) {
            if (AbstractJSVGComponent.this.svgUserAgent != null) {
                return AbstractJSVGComponent.this.svgUserAgent.showPrompt(string, string2);
            }
            return AbstractJSVGComponent.this.showPrompt(string, string2);
        }

        public boolean showConfirm(String string) {
            if (AbstractJSVGComponent.this.svgUserAgent != null) {
                return AbstractJSVGComponent.this.svgUserAgent.showConfirm(string);
            }
            return AbstractJSVGComponent.this.showConfirm(string);
        }

        public float getPixelUnitToMillimeter() {
            if (AbstractJSVGComponent.this.svgUserAgent != null) {
                return AbstractJSVGComponent.this.svgUserAgent.getPixelUnitToMillimeter();
            }
            return 0.26458332f;
        }

        public float getPixelToMM() {
            return this.getPixelUnitToMillimeter();
        }

        public String getDefaultFontFamily() {
            if (AbstractJSVGComponent.this.svgUserAgent != null) {
                return AbstractJSVGComponent.this.svgUserAgent.getDefaultFontFamily();
            }
            return "Arial, Helvetica, sans-serif";
        }

        public float getMediumFontSize() {
            if (AbstractJSVGComponent.this.svgUserAgent != null) {
                return AbstractJSVGComponent.this.svgUserAgent.getMediumFontSize();
            }
            return 228.59999f / (72.0f * this.getPixelUnitToMillimeter());
        }

        public float getLighterFontWeight(float f) {
            if (AbstractJSVGComponent.this.svgUserAgent != null) {
                return AbstractJSVGComponent.this.svgUserAgent.getLighterFontWeight(f);
            }
            int n = (int)((f + 50.0f) / 100.0f) * 100;
            switch (n) {
                case 100: {
                    return 100.0f;
                }
                case 200: {
                    return 100.0f;
                }
                case 300: {
                    return 200.0f;
                }
                case 400: {
                    return 300.0f;
                }
                case 500: {
                    return 400.0f;
                }
                case 600: {
                    return 400.0f;
                }
                case 700: {
                    return 400.0f;
                }
                case 800: {
                    return 400.0f;
                }
                case 900: {
                    return 400.0f;
                }
            }
            throw new IllegalArgumentException("Bad Font Weight: " + f);
        }

        public float getBolderFontWeight(float f) {
            if (AbstractJSVGComponent.this.svgUserAgent != null) {
                return AbstractJSVGComponent.this.svgUserAgent.getBolderFontWeight(f);
            }
            int n = (int)((f + 50.0f) / 100.0f) * 100;
            switch (n) {
                case 100: {
                    return 600.0f;
                }
                case 200: {
                    return 600.0f;
                }
                case 300: {
                    return 600.0f;
                }
                case 400: {
                    return 600.0f;
                }
                case 500: {
                    return 600.0f;
                }
                case 600: {
                    return 700.0f;
                }
                case 700: {
                    return 800.0f;
                }
                case 800: {
                    return 900.0f;
                }
                case 900: {
                    return 900.0f;
                }
            }
            throw new IllegalArgumentException("Bad Font Weight: " + f);
        }

        public String getLanguages() {
            if (AbstractJSVGComponent.this.svgUserAgent != null) {
                return AbstractJSVGComponent.this.svgUserAgent.getLanguages();
            }
            return "en";
        }

        public String getUserStyleSheetURI() {
            if (AbstractJSVGComponent.this.svgUserAgent != null) {
                return AbstractJSVGComponent.this.svgUserAgent.getUserStyleSheetURI();
            }
            return null;
        }

        public void openLink(SVGAElement sVGAElement) {
            ParsedURL parsedURL;
            String string = XLinkSupport.getXLinkShow(sVGAElement);
            String string2 = sVGAElement.getHref().getAnimVal();
            if (string.equals("new")) {
                this.fireLinkActivatedEvent(sVGAElement, string2);
                if (AbstractJSVGComponent.this.svgUserAgent != null) {
                    String string3 = AbstractJSVGComponent.this.svgDocument.getURL();
                    ParsedURL parsedURL2 = null;
                    if (sVGAElement.getOwnerDocument() != AbstractJSVGComponent.this.svgDocument) {
                        SVGDocument sVGDocument = (SVGDocument)sVGAElement.getOwnerDocument();
                        string2 = new ParsedURL(sVGDocument.getURL(), string2).toString();
                    }
                    parsedURL2 = new ParsedURL(string3, string2);
                    string2 = parsedURL2.toString();
                    AbstractJSVGComponent.this.svgUserAgent.openLink(string2, true);
                } else {
                    AbstractJSVGComponent.this.loadSVGDocument(string2);
                }
                return;
            }
            ParsedURL parsedURL3 = new ParsedURL(((SVGDocument)sVGAElement.getOwnerDocument()).getURL(), string2);
            string2 = parsedURL3.toString();
            if (AbstractJSVGComponent.this.svgDocument != null && parsedURL3.sameFile(parsedURL = new ParsedURL(AbstractJSVGComponent.this.svgDocument.getURL()))) {
                String string4 = parsedURL3.getRef();
                if (!(AbstractJSVGComponent.this.fragmentIdentifier == string4 || string4 != null && string4.equals(AbstractJSVGComponent.this.fragmentIdentifier))) {
                    AbstractJSVGComponent.this.fragmentIdentifier = string4;
                    if (AbstractJSVGComponent.this.computeRenderingTransform()) {
                        AbstractJSVGComponent.this.scheduleGVTRendering();
                    }
                }
                this.fireLinkActivatedEvent(sVGAElement, string2);
                return;
            }
            this.fireLinkActivatedEvent(sVGAElement, string2);
            if (AbstractJSVGComponent.this.svgUserAgent != null) {
                AbstractJSVGComponent.this.svgUserAgent.openLink(string2, false);
            } else {
                AbstractJSVGComponent.this.loadSVGDocument(string2);
            }
        }

        protected void fireLinkActivatedEvent(SVGAElement sVGAElement, String string) {
            Object[] objectArray = AbstractJSVGComponent.this.linkActivationListeners.toArray();
            if (objectArray.length > 0) {
                LinkActivationEvent linkActivationEvent = new LinkActivationEvent(AbstractJSVGComponent.this, sVGAElement, string);
                for (int i = 0; i < objectArray.length; ++i) {
                    LinkActivationListener linkActivationListener = (LinkActivationListener)objectArray[i];
                    linkActivationListener.linkActivated(linkActivationEvent);
                }
            }
        }

        public void setSVGCursor(Cursor cursor) {
            if (cursor != AbstractJSVGComponent.this.getCursor()) {
                AbstractJSVGComponent.this.setCursor(cursor);
            }
        }

        public void setTextSelection(Mark mark, Mark mark2) {
            AbstractJSVGComponent.this.select(mark, mark2);
        }

        public void deselectAll() {
            AbstractJSVGComponent.this.deselectAll();
        }

        public String getXMLParserClassName() {
            if (AbstractJSVGComponent.this.svgUserAgent != null) {
                return AbstractJSVGComponent.this.svgUserAgent.getXMLParserClassName();
            }
            return XMLResourceDescriptor.getXMLParserClassName();
        }

        public boolean isXMLParserValidating() {
            if (AbstractJSVGComponent.this.svgUserAgent != null) {
                return AbstractJSVGComponent.this.svgUserAgent.isXMLParserValidating();
            }
            return false;
        }

        public AffineTransform getTransform() {
            return AbstractJSVGComponent.this.renderingTransform;
        }

        public void setTransform(AffineTransform affineTransform) {
            AbstractJSVGComponent.this.setRenderingTransform(affineTransform);
        }

        public String getMedia() {
            if (AbstractJSVGComponent.this.svgUserAgent != null) {
                return AbstractJSVGComponent.this.svgUserAgent.getMedia();
            }
            return "screen";
        }

        public String getAlternateStyleSheet() {
            if (AbstractJSVGComponent.this.svgUserAgent != null) {
                return AbstractJSVGComponent.this.svgUserAgent.getAlternateStyleSheet();
            }
            return null;
        }

        public Point getClientAreaLocationOnScreen() {
            return AbstractJSVGComponent.this.getLocationOnScreen();
        }

        public boolean hasFeature(String string) {
            return FEATURES.contains(string);
        }

        public boolean supportExtension(String string) {
            if (AbstractJSVGComponent.this.svgUserAgent != null && AbstractJSVGComponent.this.svgUserAgent.supportExtension(string)) {
                return true;
            }
            return this.extensions.containsKey(string);
        }

        public void registerExtension(BridgeExtension bridgeExtension) {
            Iterator iterator = bridgeExtension.getImplementedExtensions();
            while (iterator.hasNext()) {
                this.extensions.put(iterator.next(), bridgeExtension);
            }
        }

        public void handleElement(Element element, Object object) {
            if (AbstractJSVGComponent.this.svgUserAgent != null) {
                AbstractJSVGComponent.this.svgUserAgent.handleElement(element, object);
            }
        }

        public ScriptSecurity getScriptSecurity(String string, ParsedURL parsedURL, ParsedURL parsedURL2) {
            if (AbstractJSVGComponent.this.svgUserAgent != null) {
                return AbstractJSVGComponent.this.svgUserAgent.getScriptSecurity(string, parsedURL, parsedURL2);
            }
            return new DefaultScriptSecurity(string, parsedURL, parsedURL2);
        }

        public void checkLoadScript(String string, ParsedURL parsedURL, ParsedURL parsedURL2) throws SecurityException {
            if (AbstractJSVGComponent.this.svgUserAgent != null) {
                AbstractJSVGComponent.this.svgUserAgent.checkLoadScript(string, parsedURL, parsedURL2);
            } else {
                ScriptSecurity scriptSecurity = this.getScriptSecurity(string, parsedURL, parsedURL2);
                if (scriptSecurity != null) {
                    scriptSecurity.checkLoadScript();
                }
            }
        }

        public ExternalResourceSecurity getExternalResourceSecurity(ParsedURL parsedURL, ParsedURL parsedURL2) {
            if (AbstractJSVGComponent.this.svgUserAgent != null) {
                return AbstractJSVGComponent.this.svgUserAgent.getExternalResourceSecurity(parsedURL, parsedURL2);
            }
            return new RelaxedExternalResourceSecurity(parsedURL, parsedURL2);
        }

        public void checkLoadExternalResource(ParsedURL parsedURL, ParsedURL parsedURL2) throws SecurityException {
            if (AbstractJSVGComponent.this.svgUserAgent != null) {
                AbstractJSVGComponent.this.svgUserAgent.checkLoadExternalResource(parsedURL, parsedURL2);
            } else {
                ExternalResourceSecurity externalResourceSecurity = this.getExternalResourceSecurity(parsedURL, parsedURL2);
                if (externalResourceSecurity != null) {
                    externalResourceSecurity.checkLoadExternalResource();
                }
            }
        }

        public SVGDocument getBrokenLinkDocument(Element element, String string, String string2) {
            Class clazz = class$org$apache$batik$swing$svg$AbstractJSVGComponent == null ? (class$org$apache$batik$swing$svg$AbstractJSVGComponent = AbstractJSVGComponent.class$("org.apache.batik.swing.svg.AbstractJSVGComponent")) : class$org$apache$batik$swing$svg$AbstractJSVGComponent;
            URL uRL = clazz.getResource("resources/BrokenLink.svg");
            if (uRL == null) {
                throw new BridgeException(AbstractJSVGComponent.this.bridgeContext, element, "uri.image.broken", new Object[]{string, string2});
            }
            DocumentLoader documentLoader = AbstractJSVGComponent.this.bridgeContext.getDocumentLoader();
            SVGDocument sVGDocument = null;
            try {
                sVGDocument = (SVGDocument)documentLoader.loadDocument(uRL.toString());
                if (sVGDocument == null) {
                    return sVGDocument;
                }
                DOMImplementation dOMImplementation = SVGDOMImplementation.getDOMImplementation();
                Element element2 = (sVGDocument = (SVGDocument)DOMUtilities.deepCloneDocument(sVGDocument, dOMImplementation)).getElementById("__More_About");
                if (element2 == null) {
                    return sVGDocument;
                }
                Element element3 = sVGDocument.createElementNS("http://www.w3.org/2000/svg", "title");
                String string3 = Messages.formatMessage(AbstractJSVGComponent.BROKEN_LINK_TITLE, null);
                element3.appendChild(sVGDocument.createTextNode(string3));
                Element element4 = sVGDocument.createElementNS("http://www.w3.org/2000/svg", "desc");
                element4.appendChild(sVGDocument.createTextNode(string2));
                element2.insertBefore(element4, element2.getFirstChild());
                element2.insertBefore(element3, element4);
            }
            catch (Exception exception) {
                throw new BridgeException(AbstractJSVGComponent.this.bridgeContext, element, exception, "uri.image.broken", new Object[]{string, string2});
            }
            return sVGDocument;
        }
    }

    protected static class BridgeUserAgentWrapper
    implements UserAgent {
        protected UserAgent userAgent;

        public BridgeUserAgentWrapper(UserAgent userAgent) {
            this.userAgent = userAgent;
        }

        public EventDispatcher getEventDispatcher() {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getEventDispatcher();
            }
            class Query
            implements Runnable {
                EventDispatcher result;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper bridgeUserAgentWrapper) {
                    this.this$0 = bridgeUserAgentWrapper;
                }

                public void run() {
                    this.result = this.this$0.userAgent.getEventDispatcher();
                }
            }
            Query query = new Query(this);
            this.invokeAndWait(query);
            return query.result;
        }

        public Dimension2D getViewportSize() {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getViewportSize();
            }
            class Query
            implements Runnable {
                Dimension2D result;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper bridgeUserAgentWrapper) {
                    this.this$0 = bridgeUserAgentWrapper;
                }

                public void run() {
                    this.result = this.this$0.userAgent.getViewportSize();
                }
            }
            Query query = new Query(this);
            this.invokeAndWait(query);
            return query.result;
        }

        public void displayError(Exception exception) {
            if (EventQueue.isDispatchThread()) {
                this.userAgent.displayError(exception);
            } else {
                EventQueue.invokeLater(new Runnable(this, exception){
                    private final /* synthetic */ Exception val$ex;
                    private final /* synthetic */ BridgeUserAgentWrapper this$0;
                    {
                        this.this$0 = bridgeUserAgentWrapper;
                        this.val$ex = exception;
                    }

                    public void run() {
                        this.this$0.userAgent.displayError(this.val$ex);
                    }
                });
            }
        }

        public void displayMessage(String string) {
            if (EventQueue.isDispatchThread()) {
                this.userAgent.displayMessage(string);
            } else {
                EventQueue.invokeLater(new Runnable(this, string){
                    private final /* synthetic */ String val$message;
                    private final /* synthetic */ BridgeUserAgentWrapper this$0;
                    {
                        this.this$0 = bridgeUserAgentWrapper;
                        this.val$message = string;
                    }

                    public void run() {
                        this.this$0.userAgent.displayMessage(this.val$message);
                    }
                });
            }
        }

        public void showAlert(String string) {
            if (EventQueue.isDispatchThread()) {
                this.userAgent.showAlert(string);
            } else {
                this.invokeAndWait(new Runnable(this, string){
                    private final /* synthetic */ String val$message;
                    private final /* synthetic */ BridgeUserAgentWrapper this$0;
                    {
                        this.this$0 = bridgeUserAgentWrapper;
                        this.val$message = string;
                    }

                    public void run() {
                        this.this$0.userAgent.showAlert(this.val$message);
                    }
                });
            }
        }

        public String showPrompt(String string) {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.showPrompt(string);
            }
            class Query
            implements Runnable {
                String result;
                private final /* synthetic */ String val$message;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper bridgeUserAgentWrapper, String string) {
                    this.this$0 = bridgeUserAgentWrapper;
                    this.val$message = string;
                }

                public void run() {
                    this.result = this.this$0.userAgent.showPrompt(this.val$message);
                }
            }
            Query query = new Query(this, string);
            this.invokeAndWait(query);
            return query.result;
        }

        public String showPrompt(String string, String string2) {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.showPrompt(string, string2);
            }
            class Query
            implements Runnable {
                String result;
                private final /* synthetic */ String val$message;
                private final /* synthetic */ String val$defaultValue;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper bridgeUserAgentWrapper, String string, String string2) {
                    this.this$0 = bridgeUserAgentWrapper;
                    this.val$message = string;
                    this.val$defaultValue = string2;
                }

                public void run() {
                    this.result = this.this$0.userAgent.showPrompt(this.val$message, this.val$defaultValue);
                }
            }
            Query query = new Query(this, string, string2);
            this.invokeAndWait(query);
            return query.result;
        }

        public boolean showConfirm(String string) {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.showConfirm(string);
            }
            class Query
            implements Runnable {
                boolean result;
                private final /* synthetic */ String val$message;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper bridgeUserAgentWrapper, String string) {
                    this.this$0 = bridgeUserAgentWrapper;
                    this.val$message = string;
                }

                public void run() {
                    this.result = this.this$0.userAgent.showConfirm(this.val$message);
                }
            }
            Query query = new Query(this, string);
            this.invokeAndWait(query);
            return query.result;
        }

        public float getPixelUnitToMillimeter() {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getPixelUnitToMillimeter();
            }
            class Query
            implements Runnable {
                float result;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper bridgeUserAgentWrapper) {
                    this.this$0 = bridgeUserAgentWrapper;
                }

                public void run() {
                    this.result = this.this$0.userAgent.getPixelUnitToMillimeter();
                }
            }
            Query query = new Query(this);
            this.invokeAndWait(query);
            return query.result;
        }

        public float getPixelToMM() {
            return this.getPixelUnitToMillimeter();
        }

        public String getDefaultFontFamily() {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getDefaultFontFamily();
            }
            class Query
            implements Runnable {
                String result;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper bridgeUserAgentWrapper) {
                    this.this$0 = bridgeUserAgentWrapper;
                }

                public void run() {
                    this.result = this.this$0.userAgent.getDefaultFontFamily();
                }
            }
            Query query = new Query(this);
            this.invokeAndWait(query);
            return query.result;
        }

        public float getMediumFontSize() {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getMediumFontSize();
            }
            class Query
            implements Runnable {
                float result;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper bridgeUserAgentWrapper) {
                    this.this$0 = bridgeUserAgentWrapper;
                }

                public void run() {
                    this.result = this.this$0.userAgent.getMediumFontSize();
                }
            }
            Query query = new Query(this);
            this.invokeAndWait(query);
            return query.result;
        }

        public float getLighterFontWeight(float f) {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getLighterFontWeight(f);
            }
            float f2 = f;
            class Query
            implements Runnable {
                float result;
                private final /* synthetic */ float val$ff;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper bridgeUserAgentWrapper, float f) {
                    this.this$0 = bridgeUserAgentWrapper;
                    this.val$ff = f;
                }

                public void run() {
                    this.result = this.this$0.userAgent.getLighterFontWeight(this.val$ff);
                }
            }
            Query query = new Query(this, f2);
            this.invokeAndWait(query);
            return query.result;
        }

        public float getBolderFontWeight(float f) {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getBolderFontWeight(f);
            }
            float f2 = f;
            class Query
            implements Runnable {
                float result;
                private final /* synthetic */ float val$ff;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper bridgeUserAgentWrapper, float f) {
                    this.this$0 = bridgeUserAgentWrapper;
                    this.val$ff = f;
                }

                public void run() {
                    this.result = this.this$0.userAgent.getBolderFontWeight(this.val$ff);
                }
            }
            Query query = new Query(this, f2);
            this.invokeAndWait(query);
            return query.result;
        }

        public String getLanguages() {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getLanguages();
            }
            class Query
            implements Runnable {
                String result;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper bridgeUserAgentWrapper) {
                    this.this$0 = bridgeUserAgentWrapper;
                }

                public void run() {
                    this.result = this.this$0.userAgent.getLanguages();
                }
            }
            Query query = new Query(this);
            this.invokeAndWait(query);
            return query.result;
        }

        public String getUserStyleSheetURI() {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getUserStyleSheetURI();
            }
            class Query
            implements Runnable {
                String result;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper bridgeUserAgentWrapper) {
                    this.this$0 = bridgeUserAgentWrapper;
                }

                public void run() {
                    this.result = this.this$0.userAgent.getUserStyleSheetURI();
                }
            }
            Query query = new Query(this);
            this.invokeAndWait(query);
            return query.result;
        }

        public void openLink(SVGAElement sVGAElement) {
            if (EventQueue.isDispatchThread()) {
                this.userAgent.openLink(sVGAElement);
            } else {
                EventQueue.invokeLater(new Runnable(this, sVGAElement){
                    private final /* synthetic */ SVGAElement val$elt;
                    private final /* synthetic */ BridgeUserAgentWrapper this$0;
                    {
                        this.this$0 = bridgeUserAgentWrapper;
                        this.val$elt = sVGAElement;
                    }

                    public void run() {
                        this.this$0.userAgent.openLink(this.val$elt);
                    }
                });
            }
        }

        public void setSVGCursor(Cursor cursor) {
            if (EventQueue.isDispatchThread()) {
                this.userAgent.setSVGCursor(cursor);
            } else {
                EventQueue.invokeLater(new Runnable(this, cursor){
                    private final /* synthetic */ Cursor val$cursor;
                    private final /* synthetic */ BridgeUserAgentWrapper this$0;
                    {
                        this.this$0 = bridgeUserAgentWrapper;
                        this.val$cursor = cursor;
                    }

                    public void run() {
                        this.this$0.userAgent.setSVGCursor(this.val$cursor);
                    }
                });
            }
        }

        public void setTextSelection(Mark mark, Mark mark2) {
            if (EventQueue.isDispatchThread()) {
                this.userAgent.setTextSelection(mark, mark2);
            } else {
                EventQueue.invokeLater(new Runnable(this, mark, mark2){
                    private final /* synthetic */ Mark val$start;
                    private final /* synthetic */ Mark val$end;
                    private final /* synthetic */ BridgeUserAgentWrapper this$0;
                    {
                        this.this$0 = bridgeUserAgentWrapper;
                        this.val$start = mark;
                        this.val$end = mark2;
                    }

                    public void run() {
                        this.this$0.userAgent.setTextSelection(this.val$start, this.val$end);
                    }
                });
            }
        }

        public void deselectAll() {
            if (EventQueue.isDispatchThread()) {
                this.userAgent.deselectAll();
            } else {
                EventQueue.invokeLater(new Runnable(this){
                    private final /* synthetic */ BridgeUserAgentWrapper this$0;
                    {
                        this.this$0 = bridgeUserAgentWrapper;
                    }

                    public void run() {
                        this.this$0.userAgent.deselectAll();
                    }
                });
            }
        }

        public String getXMLParserClassName() {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getXMLParserClassName();
            }
            class Query
            implements Runnable {
                String result;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper bridgeUserAgentWrapper) {
                    this.this$0 = bridgeUserAgentWrapper;
                }

                public void run() {
                    this.result = this.this$0.userAgent.getXMLParserClassName();
                }
            }
            Query query = new Query(this);
            this.invokeAndWait(query);
            return query.result;
        }

        public boolean isXMLParserValidating() {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.isXMLParserValidating();
            }
            class Query
            implements Runnable {
                boolean result;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper bridgeUserAgentWrapper) {
                    this.this$0 = bridgeUserAgentWrapper;
                }

                public void run() {
                    this.result = this.this$0.userAgent.isXMLParserValidating();
                }
            }
            Query query = new Query(this);
            this.invokeAndWait(query);
            return query.result;
        }

        public AffineTransform getTransform() {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getTransform();
            }
            class Query
            implements Runnable {
                AffineTransform result;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper bridgeUserAgentWrapper) {
                    this.this$0 = bridgeUserAgentWrapper;
                }

                public void run() {
                    this.result = this.this$0.userAgent.getTransform();
                }
            }
            Query query = new Query(this);
            this.invokeAndWait(query);
            return query.result;
        }

        public void setTransform(AffineTransform affineTransform) {
            if (EventQueue.isDispatchThread()) {
                this.userAgent.setTransform(affineTransform);
            } else {
                AffineTransform affineTransform2 = affineTransform;
                class Query
                implements Runnable {
                    private final /* synthetic */ AffineTransform val$affine;
                    private final /* synthetic */ BridgeUserAgentWrapper this$0;

                    Query(BridgeUserAgentWrapper bridgeUserAgentWrapper, AffineTransform affineTransform) {
                        this.this$0 = bridgeUserAgentWrapper;
                        this.val$affine = affineTransform;
                    }

                    public void run() {
                        this.this$0.userAgent.setTransform(this.val$affine);
                    }
                }
                Query query = new Query(this, affineTransform2);
                this.invokeAndWait(query);
            }
        }

        public String getMedia() {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getMedia();
            }
            class Query
            implements Runnable {
                String result;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper bridgeUserAgentWrapper) {
                    this.this$0 = bridgeUserAgentWrapper;
                }

                public void run() {
                    this.result = this.this$0.userAgent.getMedia();
                }
            }
            Query query = new Query(this);
            this.invokeAndWait(query);
            return query.result;
        }

        public String getAlternateStyleSheet() {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getAlternateStyleSheet();
            }
            class Query
            implements Runnable {
                String result;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper bridgeUserAgentWrapper) {
                    this.this$0 = bridgeUserAgentWrapper;
                }

                public void run() {
                    this.result = this.this$0.userAgent.getAlternateStyleSheet();
                }
            }
            Query query = new Query(this);
            this.invokeAndWait(query);
            return query.result;
        }

        public Point getClientAreaLocationOnScreen() {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getClientAreaLocationOnScreen();
            }
            class Query
            implements Runnable {
                Point result;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper bridgeUserAgentWrapper) {
                    this.this$0 = bridgeUserAgentWrapper;
                }

                public void run() {
                    this.result = this.this$0.userAgent.getClientAreaLocationOnScreen();
                }
            }
            Query query = new Query(this);
            this.invokeAndWait(query);
            return query.result;
        }

        public boolean hasFeature(String string) {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.hasFeature(string);
            }
            class Query
            implements Runnable {
                boolean result;
                private final /* synthetic */ String val$s;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper bridgeUserAgentWrapper, String string) {
                    this.this$0 = bridgeUserAgentWrapper;
                    this.val$s = string;
                }

                public void run() {
                    this.result = this.this$0.userAgent.hasFeature(this.val$s);
                }
            }
            Query query = new Query(this, string);
            this.invokeAndWait(query);
            return query.result;
        }

        public boolean supportExtension(String string) {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.supportExtension(string);
            }
            class Query
            implements Runnable {
                boolean result;
                private final /* synthetic */ String val$s;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper bridgeUserAgentWrapper, String string) {
                    this.this$0 = bridgeUserAgentWrapper;
                    this.val$s = string;
                }

                public void run() {
                    this.result = this.this$0.userAgent.supportExtension(this.val$s);
                }
            }
            Query query = new Query(this, string);
            this.invokeAndWait(query);
            return query.result;
        }

        public void registerExtension(BridgeExtension bridgeExtension) {
            if (EventQueue.isDispatchThread()) {
                this.userAgent.registerExtension(bridgeExtension);
            } else {
                EventQueue.invokeLater(new Runnable(this, bridgeExtension){
                    private final /* synthetic */ BridgeExtension val$ext;
                    private final /* synthetic */ BridgeUserAgentWrapper this$0;
                    {
                        this.this$0 = bridgeUserAgentWrapper;
                        this.val$ext = bridgeExtension;
                    }

                    public void run() {
                        this.this$0.userAgent.registerExtension(this.val$ext);
                    }
                });
            }
        }

        public void handleElement(Element element, Object object) {
            if (EventQueue.isDispatchThread()) {
                this.userAgent.handleElement(element, object);
            } else {
                EventQueue.invokeLater(new Runnable(this, element, object){
                    private final /* synthetic */ Element val$elt;
                    private final /* synthetic */ Object val$data;
                    private final /* synthetic */ BridgeUserAgentWrapper this$0;
                    {
                        this.this$0 = bridgeUserAgentWrapper;
                        this.val$elt = element;
                        this.val$data = object;
                    }

                    public void run() {
                        this.this$0.userAgent.handleElement(this.val$elt, this.val$data);
                    }
                });
            }
        }

        public ScriptSecurity getScriptSecurity(String string, ParsedURL parsedURL, ParsedURL parsedURL2) {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getScriptSecurity(string, parsedURL, parsedURL2);
            }
            String string2 = string;
            ParsedURL parsedURL3 = parsedURL;
            ParsedURL parsedURL4 = parsedURL2;
            class Query
            implements Runnable {
                ScriptSecurity result;
                private final /* synthetic */ String val$st;
                private final /* synthetic */ ParsedURL val$sPURL;
                private final /* synthetic */ ParsedURL val$dPURL;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper bridgeUserAgentWrapper, String string, ParsedURL parsedURL, ParsedURL parsedURL2) {
                    this.this$0 = bridgeUserAgentWrapper;
                    this.val$st = string;
                    this.val$sPURL = parsedURL;
                    this.val$dPURL = parsedURL2;
                }

                public void run() {
                    this.result = this.this$0.userAgent.getScriptSecurity(this.val$st, this.val$sPURL, this.val$dPURL);
                }
            }
            Query query = new Query(this, string2, parsedURL3, parsedURL4);
            this.invokeAndWait(query);
            return query.result;
        }

        public void checkLoadScript(String string, ParsedURL parsedURL, ParsedURL parsedURL2) throws SecurityException {
            if (EventQueue.isDispatchThread()) {
                this.userAgent.checkLoadScript(string, parsedURL, parsedURL2);
            } else {
                String string2 = string;
                ParsedURL parsedURL3 = parsedURL;
                ParsedURL parsedURL4 = parsedURL2;
                class Query
                implements Runnable {
                    SecurityException se;
                    private final /* synthetic */ String val$st;
                    private final /* synthetic */ ParsedURL val$sPURL;
                    private final /* synthetic */ ParsedURL val$dPURL;
                    private final /* synthetic */ BridgeUserAgentWrapper this$0;

                    Query(BridgeUserAgentWrapper bridgeUserAgentWrapper, String string, ParsedURL parsedURL, ParsedURL parsedURL2) {
                        this.this$0 = bridgeUserAgentWrapper;
                        this.val$st = string;
                        this.val$sPURL = parsedURL;
                        this.val$dPURL = parsedURL2;
                        this.se = null;
                    }

                    public void run() {
                        try {
                            this.this$0.userAgent.checkLoadScript(this.val$st, this.val$sPURL, this.val$dPURL);
                        }
                        catch (SecurityException securityException) {
                            this.se = securityException;
                        }
                    }
                }
                Query query = new Query(this, string2, parsedURL3, parsedURL4);
                this.invokeAndWait(query);
                if (query.se != null) {
                    query.se.fillInStackTrace();
                    throw query.se;
                }
            }
        }

        public ExternalResourceSecurity getExternalResourceSecurity(ParsedURL parsedURL, ParsedURL parsedURL2) {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getExternalResourceSecurity(parsedURL, parsedURL2);
            }
            ParsedURL parsedURL3 = parsedURL;
            ParsedURL parsedURL4 = parsedURL2;
            class Query
            implements Runnable {
                ExternalResourceSecurity result;
                private final /* synthetic */ ParsedURL val$rPURL;
                private final /* synthetic */ ParsedURL val$dPURL;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper bridgeUserAgentWrapper, ParsedURL parsedURL, ParsedURL parsedURL2) {
                    this.this$0 = bridgeUserAgentWrapper;
                    this.val$rPURL = parsedURL;
                    this.val$dPURL = parsedURL2;
                }

                public void run() {
                    this.result = this.this$0.userAgent.getExternalResourceSecurity(this.val$rPURL, this.val$dPURL);
                }
            }
            Query query = new Query(this, parsedURL3, parsedURL4);
            this.invokeAndWait(query);
            return query.result;
        }

        public void checkLoadExternalResource(ParsedURL parsedURL, ParsedURL parsedURL2) throws SecurityException {
            if (EventQueue.isDispatchThread()) {
                this.userAgent.checkLoadExternalResource(parsedURL, parsedURL2);
            } else {
                ParsedURL parsedURL3 = parsedURL;
                ParsedURL parsedURL4 = parsedURL2;
                class Query
                implements Runnable {
                    SecurityException se;
                    private final /* synthetic */ ParsedURL val$rPURL;
                    private final /* synthetic */ ParsedURL val$dPURL;
                    private final /* synthetic */ BridgeUserAgentWrapper this$0;

                    Query(BridgeUserAgentWrapper bridgeUserAgentWrapper, ParsedURL parsedURL, ParsedURL parsedURL2) {
                        this.this$0 = bridgeUserAgentWrapper;
                        this.val$rPURL = parsedURL;
                        this.val$dPURL = parsedURL2;
                    }

                    public void run() {
                        try {
                            this.this$0.userAgent.checkLoadExternalResource(this.val$rPURL, this.val$dPURL);
                        }
                        catch (SecurityException securityException) {
                            this.se = securityException;
                        }
                    }
                }
                Query query = new Query(this, parsedURL3, parsedURL4);
                this.invokeAndWait(query);
                if (query.se != null) {
                    query.se.fillInStackTrace();
                    throw query.se;
                }
            }
        }

        public SVGDocument getBrokenLinkDocument(Element element, String string, String string2) {
            if (EventQueue.isDispatchThread()) {
                return this.userAgent.getBrokenLinkDocument(element, string, string2);
            }
            class Query
            implements Runnable {
                SVGDocument doc;
                RuntimeException rex;
                private final /* synthetic */ Element val$e;
                private final /* synthetic */ String val$url;
                private final /* synthetic */ String val$msg;
                private final /* synthetic */ BridgeUserAgentWrapper this$0;

                Query(BridgeUserAgentWrapper bridgeUserAgentWrapper, Element element, String string, String string2) {
                    this.this$0 = bridgeUserAgentWrapper;
                    this.val$e = element;
                    this.val$url = string;
                    this.val$msg = string2;
                    this.rex = null;
                }

                public void run() {
                    try {
                        this.doc = this.this$0.userAgent.getBrokenLinkDocument(this.val$e, this.val$url, this.val$msg);
                    }
                    catch (RuntimeException runtimeException) {
                        this.rex = runtimeException;
                    }
                }
            }
            Query query = new Query(this, element, string, string2);
            this.invokeAndWait(query);
            if (query.rex != null) {
                throw query.rex;
            }
            return query.doc;
        }

        protected void invokeAndWait(Runnable runnable) {
            try {
                EventQueue.invokeAndWait(runnable);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected class SVGListener
    extends JGVTComponent.ExtendedListener
    implements SVGDocumentLoaderListener,
    GVTTreeBuilderListener,
    SVGLoadEventDispatcherListener,
    UpdateManagerListener {
        protected SVGListener() {
            super(AbstractJSVGComponent.this);
        }

        public void documentLoadingStarted(SVGDocumentLoaderEvent sVGDocumentLoaderEvent) {
        }

        public void documentLoadingCompleted(SVGDocumentLoaderEvent sVGDocumentLoaderEvent) {
            if (AbstractJSVGComponent.this.nextDocumentLoader != null) {
                AbstractJSVGComponent.this.startDocumentLoader();
                return;
            }
            AbstractJSVGComponent.this.documentLoader = null;
            if (AbstractJSVGComponent.this.afterStopRunnable != null) {
                EventQueue.invokeLater(AbstractJSVGComponent.this.afterStopRunnable);
                AbstractJSVGComponent.this.afterStopRunnable = null;
                return;
            }
            AbstractJSVGComponent.this.setSVGDocument(sVGDocumentLoaderEvent.getSVGDocument());
        }

        public void documentLoadingCancelled(SVGDocumentLoaderEvent sVGDocumentLoaderEvent) {
            if (AbstractJSVGComponent.this.nextDocumentLoader != null) {
                AbstractJSVGComponent.this.startDocumentLoader();
                return;
            }
            AbstractJSVGComponent.this.documentLoader = null;
            if (AbstractJSVGComponent.this.afterStopRunnable != null) {
                EventQueue.invokeLater(AbstractJSVGComponent.this.afterStopRunnable);
                AbstractJSVGComponent.this.afterStopRunnable = null;
                return;
            }
            if (AbstractJSVGComponent.this.nextGVTTreeBuilder != null) {
                AbstractJSVGComponent.this.startGVTTreeBuilder();
                return;
            }
        }

        public void documentLoadingFailed(SVGDocumentLoaderEvent sVGDocumentLoaderEvent) {
            if (AbstractJSVGComponent.this.nextDocumentLoader != null) {
                AbstractJSVGComponent.this.startDocumentLoader();
                return;
            }
            AbstractJSVGComponent.this.documentLoader = null;
            AbstractJSVGComponent.this.userAgent.displayError(((SVGDocumentLoader)sVGDocumentLoaderEvent.getSource()).getException());
            if (AbstractJSVGComponent.this.afterStopRunnable != null) {
                EventQueue.invokeLater(AbstractJSVGComponent.this.afterStopRunnable);
                AbstractJSVGComponent.this.afterStopRunnable = null;
                return;
            }
            if (AbstractJSVGComponent.this.nextGVTTreeBuilder != null) {
                AbstractJSVGComponent.this.startGVTTreeBuilder();
                return;
            }
        }

        public void gvtBuildStarted(GVTTreeBuilderEvent gVTTreeBuilderEvent) {
            AbstractJSVGComponent.this.removeJGVTComponentListener(AbstractJSVGComponent.this.jsvgComponentListener);
            AbstractJSVGComponent.this.removeComponentListener(AbstractJSVGComponent.this.jsvgComponentListener);
        }

        public void gvtBuildCompleted(GVTTreeBuilderEvent gVTTreeBuilderEvent) {
            if (AbstractJSVGComponent.this.nextGVTTreeBuilder != null) {
                AbstractJSVGComponent.this.startGVTTreeBuilder();
                return;
            }
            AbstractJSVGComponent.this.loader = null;
            AbstractJSVGComponent.this.gvtTreeBuilder = null;
            if (AbstractJSVGComponent.this.afterStopRunnable != null) {
                EventQueue.invokeLater(AbstractJSVGComponent.this.afterStopRunnable);
                AbstractJSVGComponent.this.afterStopRunnable = null;
                return;
            }
            if (AbstractJSVGComponent.this.nextDocumentLoader != null) {
                AbstractJSVGComponent.this.startDocumentLoader();
                return;
            }
            AbstractJSVGComponent.this.gvtRoot = null;
            if (AbstractJSVGComponent.this.isDynamicDocument && AbstractJSVGComponent.this.eventsEnabled) {
                AbstractJSVGComponent.this.startSVGLoadEventDispatcher(gVTTreeBuilderEvent.getGVTRoot());
            } else {
                if (AbstractJSVGComponent.this.isInteractiveDocument) {
                    AbstractJSVGComponent.this.nextUpdateManager = new UpdateManager(AbstractJSVGComponent.this.bridgeContext, gVTTreeBuilderEvent.getGVTRoot(), AbstractJSVGComponent.this.svgDocument);
                }
                AbstractJSVGComponent.this.setGraphicsNode(gVTTreeBuilderEvent.getGVTRoot(), false);
                AbstractJSVGComponent.this.scheduleGVTRendering();
            }
        }

        public void gvtBuildCancelled(GVTTreeBuilderEvent gVTTreeBuilderEvent) {
            if (AbstractJSVGComponent.this.nextGVTTreeBuilder != null) {
                AbstractJSVGComponent.this.startGVTTreeBuilder();
                return;
            }
            AbstractJSVGComponent.this.loader = null;
            AbstractJSVGComponent.this.gvtTreeBuilder = null;
            if (AbstractJSVGComponent.this.afterStopRunnable != null) {
                EventQueue.invokeLater(AbstractJSVGComponent.this.afterStopRunnable);
                AbstractJSVGComponent.this.afterStopRunnable = null;
                return;
            }
            if (AbstractJSVGComponent.this.nextDocumentLoader != null) {
                AbstractJSVGComponent.this.startDocumentLoader();
                return;
            }
            AbstractJSVGComponent.this.image = null;
            AbstractJSVGComponent.this.repaint();
        }

        public void gvtBuildFailed(GVTTreeBuilderEvent gVTTreeBuilderEvent) {
            if (AbstractJSVGComponent.this.nextGVTTreeBuilder != null) {
                AbstractJSVGComponent.this.startGVTTreeBuilder();
                return;
            }
            AbstractJSVGComponent.this.loader = null;
            AbstractJSVGComponent.this.gvtTreeBuilder = null;
            if (AbstractJSVGComponent.this.afterStopRunnable != null) {
                EventQueue.invokeLater(AbstractJSVGComponent.this.afterStopRunnable);
                AbstractJSVGComponent.this.afterStopRunnable = null;
                return;
            }
            if (AbstractJSVGComponent.this.nextDocumentLoader != null) {
                AbstractJSVGComponent.this.startDocumentLoader();
                return;
            }
            GraphicsNode graphicsNode = gVTTreeBuilderEvent.getGVTRoot();
            if (graphicsNode == null) {
                AbstractJSVGComponent.this.image = null;
                AbstractJSVGComponent.this.repaint();
            } else {
                AbstractJSVGComponent.this.setGraphicsNode(graphicsNode, false);
                AbstractJSVGComponent.this.computeRenderingTransform();
            }
            AbstractJSVGComponent.this.userAgent.displayError(((GVTTreeBuilder)gVTTreeBuilderEvent.getSource()).getException());
        }

        public void svgLoadEventDispatchStarted(SVGLoadEventDispatcherEvent sVGLoadEventDispatcherEvent) {
        }

        public void svgLoadEventDispatchCompleted(SVGLoadEventDispatcherEvent sVGLoadEventDispatcherEvent) {
            AbstractJSVGComponent.this.nextUpdateManager = AbstractJSVGComponent.this.svgLoadEventDispatcher.getUpdateManager();
            AbstractJSVGComponent.this.svgLoadEventDispatcher = null;
            if (AbstractJSVGComponent.this.afterStopRunnable != null) {
                AbstractJSVGComponent.this.nextUpdateManager.interrupt();
                AbstractJSVGComponent.this.nextUpdateManager = null;
                EventQueue.invokeLater(AbstractJSVGComponent.this.afterStopRunnable);
                AbstractJSVGComponent.this.afterStopRunnable = null;
                return;
            }
            if (AbstractJSVGComponent.this.nextGVTTreeBuilder != null) {
                AbstractJSVGComponent.this.nextUpdateManager.interrupt();
                AbstractJSVGComponent.this.nextUpdateManager = null;
                AbstractJSVGComponent.this.startGVTTreeBuilder();
                return;
            }
            if (AbstractJSVGComponent.this.nextDocumentLoader != null) {
                AbstractJSVGComponent.this.nextUpdateManager.interrupt();
                AbstractJSVGComponent.this.nextUpdateManager = null;
                AbstractJSVGComponent.this.startDocumentLoader();
                return;
            }
            AbstractJSVGComponent.this.setGraphicsNode(sVGLoadEventDispatcherEvent.getGVTRoot(), false);
            AbstractJSVGComponent.this.scheduleGVTRendering();
        }

        public void svgLoadEventDispatchCancelled(SVGLoadEventDispatcherEvent sVGLoadEventDispatcherEvent) {
            AbstractJSVGComponent.this.nextUpdateManager = AbstractJSVGComponent.this.svgLoadEventDispatcher.getUpdateManager();
            AbstractJSVGComponent.this.svgLoadEventDispatcher = null;
            AbstractJSVGComponent.this.nextUpdateManager.interrupt();
            AbstractJSVGComponent.this.nextUpdateManager = null;
            if (AbstractJSVGComponent.this.afterStopRunnable != null) {
                EventQueue.invokeLater(AbstractJSVGComponent.this.afterStopRunnable);
                AbstractJSVGComponent.this.afterStopRunnable = null;
                return;
            }
            if (AbstractJSVGComponent.this.nextGVTTreeBuilder != null) {
                AbstractJSVGComponent.this.startGVTTreeBuilder();
                return;
            }
            if (AbstractJSVGComponent.this.nextDocumentLoader != null) {
                AbstractJSVGComponent.this.startDocumentLoader();
                return;
            }
        }

        public void svgLoadEventDispatchFailed(SVGLoadEventDispatcherEvent sVGLoadEventDispatcherEvent) {
            AbstractJSVGComponent.this.nextUpdateManager = AbstractJSVGComponent.this.svgLoadEventDispatcher.getUpdateManager();
            AbstractJSVGComponent.this.svgLoadEventDispatcher = null;
            AbstractJSVGComponent.this.nextUpdateManager.interrupt();
            AbstractJSVGComponent.this.nextUpdateManager = null;
            if (AbstractJSVGComponent.this.afterStopRunnable != null) {
                EventQueue.invokeLater(AbstractJSVGComponent.this.afterStopRunnable);
                AbstractJSVGComponent.this.afterStopRunnable = null;
                return;
            }
            if (AbstractJSVGComponent.this.nextGVTTreeBuilder != null) {
                AbstractJSVGComponent.this.startGVTTreeBuilder();
                return;
            }
            if (AbstractJSVGComponent.this.nextDocumentLoader != null) {
                AbstractJSVGComponent.this.startDocumentLoader();
                return;
            }
            GraphicsNode graphicsNode = sVGLoadEventDispatcherEvent.getGVTRoot();
            if (graphicsNode == null) {
                AbstractJSVGComponent.this.image = null;
                AbstractJSVGComponent.this.repaint();
            } else {
                AbstractJSVGComponent.this.setGraphicsNode(graphicsNode, false);
                AbstractJSVGComponent.this.computeRenderingTransform();
            }
            AbstractJSVGComponent.this.userAgent.displayError(((SVGLoadEventDispatcher)sVGLoadEventDispatcherEvent.getSource()).getException());
        }

        public void gvtRenderingCompleted(GVTTreeRendererEvent gVTTreeRendererEvent) {
            super.gvtRenderingCompleted(gVTTreeRendererEvent);
            if (AbstractJSVGComponent.this.afterStopRunnable != null) {
                if (AbstractJSVGComponent.this.nextUpdateManager != null) {
                    AbstractJSVGComponent.this.nextUpdateManager.interrupt();
                    AbstractJSVGComponent.this.nextUpdateManager = null;
                }
                EventQueue.invokeLater(AbstractJSVGComponent.this.afterStopRunnable);
                AbstractJSVGComponent.this.afterStopRunnable = null;
                return;
            }
            if (AbstractJSVGComponent.this.nextGVTTreeBuilder != null) {
                if (AbstractJSVGComponent.this.nextUpdateManager != null) {
                    AbstractJSVGComponent.this.nextUpdateManager.interrupt();
                    AbstractJSVGComponent.this.nextUpdateManager = null;
                }
                AbstractJSVGComponent.this.startGVTTreeBuilder();
                return;
            }
            if (AbstractJSVGComponent.this.nextDocumentLoader != null) {
                if (AbstractJSVGComponent.this.nextUpdateManager != null) {
                    AbstractJSVGComponent.this.nextUpdateManager.interrupt();
                    AbstractJSVGComponent.this.nextUpdateManager = null;
                }
                AbstractJSVGComponent.this.startDocumentLoader();
                return;
            }
            if (AbstractJSVGComponent.this.nextUpdateManager != null) {
                AbstractJSVGComponent.this.updateManager = AbstractJSVGComponent.this.nextUpdateManager;
                AbstractJSVGComponent.this.nextUpdateManager = null;
                AbstractJSVGComponent.this.updateManager.addUpdateManagerListener(this);
                AbstractJSVGComponent.this.updateManager.manageUpdates(AbstractJSVGComponent.this.renderer);
            }
        }

        public void gvtRenderingCancelled(GVTTreeRendererEvent gVTTreeRendererEvent) {
            super.gvtRenderingCancelled(gVTTreeRendererEvent);
            if (AbstractJSVGComponent.this.afterStopRunnable != null) {
                if (AbstractJSVGComponent.this.nextUpdateManager != null) {
                    AbstractJSVGComponent.this.nextUpdateManager.interrupt();
                    AbstractJSVGComponent.this.nextUpdateManager = null;
                }
                EventQueue.invokeLater(AbstractJSVGComponent.this.afterStopRunnable);
                AbstractJSVGComponent.this.afterStopRunnable = null;
                return;
            }
            if (AbstractJSVGComponent.this.nextGVTTreeBuilder != null) {
                if (AbstractJSVGComponent.this.nextUpdateManager != null) {
                    AbstractJSVGComponent.this.nextUpdateManager.interrupt();
                    AbstractJSVGComponent.this.nextUpdateManager = null;
                }
                AbstractJSVGComponent.this.startGVTTreeBuilder();
                return;
            }
            if (AbstractJSVGComponent.this.nextDocumentLoader != null) {
                if (AbstractJSVGComponent.this.nextUpdateManager != null) {
                    AbstractJSVGComponent.this.nextUpdateManager.interrupt();
                    AbstractJSVGComponent.this.nextUpdateManager = null;
                }
                AbstractJSVGComponent.this.startDocumentLoader();
                return;
            }
        }

        public void gvtRenderingFailed(GVTTreeRendererEvent gVTTreeRendererEvent) {
            super.gvtRenderingFailed(gVTTreeRendererEvent);
            if (AbstractJSVGComponent.this.afterStopRunnable != null) {
                if (AbstractJSVGComponent.this.nextUpdateManager != null) {
                    AbstractJSVGComponent.this.nextUpdateManager.interrupt();
                    AbstractJSVGComponent.this.nextUpdateManager = null;
                }
                EventQueue.invokeLater(AbstractJSVGComponent.this.afterStopRunnable);
                AbstractJSVGComponent.this.afterStopRunnable = null;
                return;
            }
            if (AbstractJSVGComponent.this.nextGVTTreeBuilder != null) {
                if (AbstractJSVGComponent.this.nextUpdateManager != null) {
                    AbstractJSVGComponent.this.nextUpdateManager.interrupt();
                    AbstractJSVGComponent.this.nextUpdateManager = null;
                }
                AbstractJSVGComponent.this.startGVTTreeBuilder();
                return;
            }
            if (AbstractJSVGComponent.this.nextDocumentLoader != null) {
                if (AbstractJSVGComponent.this.nextUpdateManager != null) {
                    AbstractJSVGComponent.this.nextUpdateManager.interrupt();
                    AbstractJSVGComponent.this.nextUpdateManager = null;
                }
                AbstractJSVGComponent.this.startDocumentLoader();
                return;
            }
        }

        public void managerStarted(UpdateManagerEvent updateManagerEvent) {
            EventQueue.invokeLater(new Runnable(this, updateManagerEvent){
                private final /* synthetic */ UpdateManagerEvent val$e;
                private final /* synthetic */ SVGListener this$1;
                {
                    this.this$1 = sVGListener;
                    this.val$e = updateManagerEvent;
                }

                public void run() {
                    AbstractJSVGComponent.access$1102(SVGListener.access$1000(this.this$1), false);
                    Object[] objectArray = SVGListener.access$1000((SVGListener)this.this$1).updateManagerListeners.toArray();
                    if (objectArray.length > 0) {
                        for (int i = 0; i < objectArray.length; ++i) {
                            ((UpdateManagerListener)objectArray[i]).managerStarted(this.val$e);
                        }
                    }
                }
            });
        }

        public void managerSuspended(UpdateManagerEvent updateManagerEvent) {
            EventQueue.invokeLater(new Runnable(this, updateManagerEvent){
                private final /* synthetic */ UpdateManagerEvent val$e;
                private final /* synthetic */ SVGListener this$1;
                {
                    this.this$1 = sVGListener;
                    this.val$e = updateManagerEvent;
                }

                public void run() {
                    Object[] objectArray = SVGListener.access$1000((SVGListener)this.this$1).updateManagerListeners.toArray();
                    if (objectArray.length > 0) {
                        for (int i = 0; i < objectArray.length; ++i) {
                            ((UpdateManagerListener)objectArray[i]).managerSuspended(this.val$e);
                        }
                    }
                }
            });
        }

        public void managerResumed(UpdateManagerEvent updateManagerEvent) {
            EventQueue.invokeLater(new Runnable(this, updateManagerEvent){
                private final /* synthetic */ UpdateManagerEvent val$e;
                private final /* synthetic */ SVGListener this$1;
                {
                    this.this$1 = sVGListener;
                    this.val$e = updateManagerEvent;
                }

                public void run() {
                    Object[] objectArray = SVGListener.access$1000((SVGListener)this.this$1).updateManagerListeners.toArray();
                    if (objectArray.length > 0) {
                        for (int i = 0; i < objectArray.length; ++i) {
                            ((UpdateManagerListener)objectArray[i]).managerResumed(this.val$e);
                        }
                    }
                }
            });
        }

        public void managerStopped(UpdateManagerEvent updateManagerEvent) {
            EventQueue.invokeLater(new Runnable(this, updateManagerEvent){
                private final /* synthetic */ UpdateManagerEvent val$e;
                private final /* synthetic */ SVGListener this$1;
                {
                    this.this$1 = sVGListener;
                    this.val$e = updateManagerEvent;
                }

                public void run() {
                    SVGListener.access$1000((SVGListener)this.this$1).updateManager = null;
                    Object[] objectArray = SVGListener.access$1000((SVGListener)this.this$1).updateManagerListeners.toArray();
                    if (objectArray.length > 0) {
                        for (int i = 0; i < objectArray.length; ++i) {
                            ((UpdateManagerListener)objectArray[i]).managerStopped(this.val$e);
                        }
                    }
                    if (SVGListener.access$1000((SVGListener)this.this$1).afterStopRunnable != null) {
                        EventQueue.invokeLater(SVGListener.access$1000((SVGListener)this.this$1).afterStopRunnable);
                        SVGListener.access$1000((SVGListener)this.this$1).afterStopRunnable = null;
                        return;
                    }
                    if (SVGListener.access$1000((SVGListener)this.this$1).nextGVTTreeBuilder != null) {
                        SVGListener.access$1000(this.this$1).startGVTTreeBuilder();
                        return;
                    }
                    if (SVGListener.access$1000((SVGListener)this.this$1).nextDocumentLoader != null) {
                        AbstractJSVGComponent.access$000(SVGListener.access$1000(this.this$1));
                        return;
                    }
                }
            });
        }

        public void updateStarted(UpdateManagerEvent updateManagerEvent) {
            EventQueue.invokeLater(new Runnable(this, updateManagerEvent){
                private final /* synthetic */ UpdateManagerEvent val$e;
                private final /* synthetic */ SVGListener this$1;
                {
                    this.this$1 = sVGListener;
                    this.val$e = updateManagerEvent;
                }

                public void run() {
                    Object[] objectArray;
                    if (!AbstractJSVGComponent.access$1200(SVGListener.access$1000(this.this$1))) {
                        AbstractJSVGComponent.access$1302(SVGListener.access$1000(this.this$1), this.val$e.getImage());
                    }
                    if ((objectArray = SVGListener.access$1000((SVGListener)this.this$1).updateManagerListeners.toArray()).length > 0) {
                        for (int i = 0; i < objectArray.length; ++i) {
                            ((UpdateManagerListener)objectArray[i]).updateStarted(this.val$e);
                        }
                    }
                }
            });
        }

        public void updateCompleted(UpdateManagerEvent updateManagerEvent) {
            try {
                EventQueue.invokeAndWait(new Runnable(this, updateManagerEvent){
                    private final /* synthetic */ UpdateManagerEvent val$e;
                    private final /* synthetic */ SVGListener this$1;
                    {
                        this.this$1 = sVGListener;
                        this.val$e = updateManagerEvent;
                    }

                    public void run() {
                        List list;
                        AbstractJSVGComponent.access$1402(SVGListener.access$1000(this.this$1), this.val$e.getImage());
                        if (this.val$e.getClearPaintingTransform()) {
                            AbstractJSVGComponent.access$1502(SVGListener.access$1000(this.this$1), null);
                        }
                        if ((list = this.val$e.getDirtyAreas()) != null) {
                            Iterator<E> iterator = list.iterator();
                            while (iterator.hasNext()) {
                                Rectangle rectangle = (Rectangle)iterator.next();
                                if (SVGListener.access$1000((SVGListener)this.this$1).updateOverlay != null) {
                                    SVGListener.access$1000((SVGListener)this.this$1).updateOverlay.addRect(rectangle);
                                    rectangle = SVGListener.access$1000(this.this$1).getRenderRect();
                                }
                                if (AbstractJSVGComponent.access$1600(SVGListener.access$1000(this.this$1))) {
                                    SVGListener.access$1000(this.this$1).repaint(rectangle);
                                    continue;
                                }
                                SVGListener.access$1000(this.this$1).paintImmediately(rectangle);
                            }
                            if (SVGListener.access$1000((SVGListener)this.this$1).updateOverlay != null) {
                                SVGListener.access$1000((SVGListener)this.this$1).updateOverlay.endUpdate();
                            }
                        }
                        AbstractJSVGComponent.access$1702(SVGListener.access$1000(this.this$1), false);
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
            EventQueue.invokeLater(new Runnable(this, updateManagerEvent){
                private final /* synthetic */ UpdateManagerEvent val$e;
                private final /* synthetic */ SVGListener this$1;
                {
                    this.this$1 = sVGListener;
                    this.val$e = updateManagerEvent;
                }

                public void run() {
                    Object[] objectArray = SVGListener.access$1000((SVGListener)this.this$1).updateManagerListeners.toArray();
                    if (objectArray.length > 0) {
                        for (int i = 0; i < objectArray.length; ++i) {
                            ((UpdateManagerListener)objectArray[i]).updateCompleted(this.val$e);
                        }
                    }
                }
            });
        }

        public void updateFailed(UpdateManagerEvent updateManagerEvent) {
            EventQueue.invokeLater(new Runnable(this, updateManagerEvent){
                private final /* synthetic */ UpdateManagerEvent val$e;
                private final /* synthetic */ SVGListener this$1;
                {
                    this.this$1 = sVGListener;
                    this.val$e = updateManagerEvent;
                }

                public void run() {
                    Object[] objectArray = SVGListener.access$1000((SVGListener)this.this$1).updateManagerListeners.toArray();
                    if (objectArray.length > 0) {
                        for (int i = 0; i < objectArray.length; ++i) {
                            ((UpdateManagerListener)objectArray[i]).updateFailed(this.val$e);
                        }
                    }
                }
            });
        }

        protected void dispatchKeyTyped(KeyEvent keyEvent) {
            if (!AbstractJSVGComponent.this.isDynamicDocument) {
                super.dispatchKeyTyped(keyEvent);
                return;
            }
            if (AbstractJSVGComponent.this.updateManager != null && AbstractJSVGComponent.this.updateManager.isRunning()) {
                AbstractJSVGComponent.this.updateManager.getUpdateRunnableQueue().invokeLater(new Runnable(this, keyEvent){
                    private final /* synthetic */ KeyEvent val$e;
                    private final /* synthetic */ SVGListener this$1;
                    {
                        this.this$1 = sVGListener;
                        this.val$e = keyEvent;
                    }

                    public void run() {
                        AbstractJSVGComponent.access$1800(SVGListener.access$1000(this.this$1)).keyTyped(this.val$e);
                    }
                });
            }
        }

        protected void dispatchKeyPressed(KeyEvent keyEvent) {
            if (!AbstractJSVGComponent.this.isDynamicDocument) {
                super.dispatchKeyPressed(keyEvent);
                return;
            }
            if (AbstractJSVGComponent.this.updateManager != null && AbstractJSVGComponent.this.updateManager.isRunning()) {
                AbstractJSVGComponent.this.updateManager.getUpdateRunnableQueue().invokeLater(new Runnable(this, keyEvent){
                    private final /* synthetic */ KeyEvent val$e;
                    private final /* synthetic */ SVGListener this$1;
                    {
                        this.this$1 = sVGListener;
                        this.val$e = keyEvent;
                    }

                    public void run() {
                        AbstractJSVGComponent.access$1900(SVGListener.access$1000(this.this$1)).keyPressed(this.val$e);
                    }
                });
            }
        }

        protected void dispatchKeyReleased(KeyEvent keyEvent) {
            if (!AbstractJSVGComponent.this.isDynamicDocument) {
                super.dispatchKeyReleased(keyEvent);
                return;
            }
            if (AbstractJSVGComponent.this.updateManager != null && AbstractJSVGComponent.this.updateManager.isRunning()) {
                AbstractJSVGComponent.this.updateManager.getUpdateRunnableQueue().invokeLater(new Runnable(this, keyEvent){
                    private final /* synthetic */ KeyEvent val$e;
                    private final /* synthetic */ SVGListener this$1;
                    {
                        this.this$1 = sVGListener;
                        this.val$e = keyEvent;
                    }

                    public void run() {
                        AbstractJSVGComponent.access$2000(SVGListener.access$1000(this.this$1)).keyReleased(this.val$e);
                    }
                });
            }
        }

        protected void dispatchMouseClicked(MouseEvent mouseEvent) {
            if (!AbstractJSVGComponent.this.isInteractiveDocument) {
                super.dispatchMouseClicked(mouseEvent);
                return;
            }
            if (AbstractJSVGComponent.this.updateManager != null && AbstractJSVGComponent.this.updateManager.isRunning()) {
                AbstractJSVGComponent.this.updateManager.getUpdateRunnableQueue().invokeLater(new Runnable(this, mouseEvent){
                    private final /* synthetic */ MouseEvent val$e;
                    private final /* synthetic */ SVGListener this$1;
                    {
                        this.this$1 = sVGListener;
                        this.val$e = mouseEvent;
                    }

                    public void run() {
                        AbstractJSVGComponent.access$2100(SVGListener.access$1000(this.this$1)).mouseClicked(this.val$e);
                    }
                });
            }
        }

        protected void dispatchMousePressed(MouseEvent mouseEvent) {
            if (!AbstractJSVGComponent.this.isDynamicDocument) {
                super.dispatchMousePressed(mouseEvent);
                return;
            }
            if (AbstractJSVGComponent.this.updateManager != null && AbstractJSVGComponent.this.updateManager.isRunning()) {
                AbstractJSVGComponent.this.updateManager.getUpdateRunnableQueue().invokeLater(new Runnable(this, mouseEvent){
                    private final /* synthetic */ MouseEvent val$e;
                    private final /* synthetic */ SVGListener this$1;
                    {
                        this.this$1 = sVGListener;
                        this.val$e = mouseEvent;
                    }

                    public void run() {
                        AbstractJSVGComponent.access$2200(SVGListener.access$1000(this.this$1)).mousePressed(this.val$e);
                    }
                });
            }
        }

        protected void dispatchMouseReleased(MouseEvent mouseEvent) {
            if (!AbstractJSVGComponent.this.isDynamicDocument) {
                super.dispatchMouseReleased(mouseEvent);
                return;
            }
            if (AbstractJSVGComponent.this.updateManager != null && AbstractJSVGComponent.this.updateManager.isRunning()) {
                AbstractJSVGComponent.this.updateManager.getUpdateRunnableQueue().invokeLater(new Runnable(this, mouseEvent){
                    private final /* synthetic */ MouseEvent val$e;
                    private final /* synthetic */ SVGListener this$1;
                    {
                        this.this$1 = sVGListener;
                        this.val$e = mouseEvent;
                    }

                    public void run() {
                        AbstractJSVGComponent.access$2300(SVGListener.access$1000(this.this$1)).mouseReleased(this.val$e);
                    }
                });
            }
        }

        protected void dispatchMouseEntered(MouseEvent mouseEvent) {
            if (!AbstractJSVGComponent.this.isInteractiveDocument) {
                super.dispatchMouseEntered(mouseEvent);
                return;
            }
            if (AbstractJSVGComponent.this.updateManager != null && AbstractJSVGComponent.this.updateManager.isRunning()) {
                AbstractJSVGComponent.this.updateManager.getUpdateRunnableQueue().invokeLater(new Runnable(this, mouseEvent){
                    private final /* synthetic */ MouseEvent val$e;
                    private final /* synthetic */ SVGListener this$1;
                    {
                        this.this$1 = sVGListener;
                        this.val$e = mouseEvent;
                    }

                    public void run() {
                        AbstractJSVGComponent.access$2400(SVGListener.access$1000(this.this$1)).mouseEntered(this.val$e);
                    }
                });
            }
        }

        protected void dispatchMouseExited(MouseEvent mouseEvent) {
            if (!AbstractJSVGComponent.this.isInteractiveDocument) {
                super.dispatchMouseExited(mouseEvent);
                return;
            }
            if (AbstractJSVGComponent.this.updateManager != null && AbstractJSVGComponent.this.updateManager.isRunning()) {
                AbstractJSVGComponent.this.updateManager.getUpdateRunnableQueue().invokeLater(new Runnable(this, mouseEvent){
                    private final /* synthetic */ MouseEvent val$e;
                    private final /* synthetic */ SVGListener this$1;
                    {
                        this.this$1 = sVGListener;
                        this.val$e = mouseEvent;
                    }

                    public void run() {
                        AbstractJSVGComponent.access$2500(SVGListener.access$1000(this.this$1)).mouseExited(this.val$e);
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void dispatchMouseDragged(MouseEvent mouseEvent) {
            if (!AbstractJSVGComponent.this.isDynamicDocument) {
                super.dispatchMouseDragged(mouseEvent);
                return;
            }
            if (AbstractJSVGComponent.this.updateManager != null && AbstractJSVGComponent.this.updateManager.isRunning()) {
                class MouseDraggedRunnable
                implements Runnable {
                    MouseEvent event;
                    private final /* synthetic */ SVGListener this$1;

                    MouseDraggedRunnable(SVGListener sVGListener, MouseEvent mouseEvent) {
                        this.this$1 = sVGListener;
                        this.event = mouseEvent;
                    }

                    public void run() {
                        AbstractJSVGComponent.access$2600(SVGListener.access$1000(this.this$1)).mouseDragged(this.event);
                    }
                }
                RunnableQueue runnableQueue = AbstractJSVGComponent.this.updateManager.getUpdateRunnableQueue();
                Object object = runnableQueue.getIteratorLock();
                synchronized (object) {
                    Iterator iterator = runnableQueue.iterator();
                    while (iterator.hasNext()) {
                        Object e = iterator.next();
                        if (!(e instanceof MouseDraggedRunnable)) continue;
                        MouseDraggedRunnable mouseDraggedRunnable = (MouseDraggedRunnable)e;
                        MouseEvent mouseEvent2 = mouseDraggedRunnable.event;
                        if (mouseEvent2.getModifiers() == mouseEvent.getModifiers()) {
                            mouseDraggedRunnable.event = mouseEvent;
                        }
                        return;
                    }
                }
                runnableQueue.invokeLater(new MouseDraggedRunnable(this, mouseEvent));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void dispatchMouseMoved(MouseEvent mouseEvent) {
            if (!AbstractJSVGComponent.this.isInteractiveDocument) {
                super.dispatchMouseMoved(mouseEvent);
                return;
            }
            if (AbstractJSVGComponent.this.updateManager != null && AbstractJSVGComponent.this.updateManager.isRunning()) {
                class MouseMovedRunnable
                implements Runnable {
                    MouseEvent event;
                    private final /* synthetic */ SVGListener this$1;

                    MouseMovedRunnable(SVGListener sVGListener, MouseEvent mouseEvent) {
                        this.this$1 = sVGListener;
                        this.event = mouseEvent;
                    }

                    public void run() {
                        AbstractJSVGComponent.access$2700(SVGListener.access$1000(this.this$1)).mouseMoved(this.event);
                    }
                }
                RunnableQueue runnableQueue = AbstractJSVGComponent.this.updateManager.getUpdateRunnableQueue();
                int n = 0;
                Object object = runnableQueue.getIteratorLock();
                synchronized (object) {
                    Iterator iterator = runnableQueue.iterator();
                    while (iterator.hasNext()) {
                        Object e = iterator.next();
                        if (e instanceof MouseMovedRunnable) {
                            MouseMovedRunnable mouseMovedRunnable = (MouseMovedRunnable)e;
                            MouseEvent mouseEvent2 = mouseMovedRunnable.event;
                            if (mouseEvent2.getModifiers() == mouseEvent.getModifiers()) {
                                mouseMovedRunnable.event = mouseEvent;
                            }
                            return;
                        }
                        ++n;
                    }
                }
                runnableQueue.invokeLater(new MouseMovedRunnable(this, mouseEvent));
            }
        }

        static /* synthetic */ AbstractJSVGComponent access$1000(SVGListener sVGListener) {
            return sVGListener.AbstractJSVGComponent.this;
        }
    }

    protected class JSVGComponentListener
    extends ComponentAdapter
    implements JGVTComponentListener {
        float prevScale = 0.0f;
        float prevTransX = 0.0f;
        float prevTransY = 0.0f;

        protected JSVGComponentListener() {
        }

        public void componentResized(ComponentEvent componentEvent) {
            if (AbstractJSVGComponent.this.isDynamicDocument && AbstractJSVGComponent.this.updateManager != null && AbstractJSVGComponent.this.updateManager.isRunning()) {
                AbstractJSVGComponent.this.updateManager.getUpdateRunnableQueue().invokeLater(new Runnable(this){
                    private final /* synthetic */ JSVGComponentListener this$1;
                    {
                        this.this$1 = jSVGComponentListener;
                    }

                    public void run() {
                        try {
                            JSVGComponentListener.access$100((JSVGComponentListener)this.this$1).updateManager.dispatchSVGResizeEvent();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                });
            }
        }

        public void componentTransformChanged(ComponentEvent componentEvent) {
            boolean bl;
            AffineTransform affineTransform = AbstractJSVGComponent.this.getRenderingTransform();
            float f = (float)Math.sqrt(affineTransform.getDeterminant());
            float f2 = (float)affineTransform.getTranslateX();
            float f3 = (float)affineTransform.getTranslateY();
            boolean bl2 = f != this.prevScale;
            boolean bl3 = bl = f2 != this.prevTransX || f3 != this.prevTransY;
            if (AbstractJSVGComponent.this.isDynamicDocument && AbstractJSVGComponent.this.updateManager != null && AbstractJSVGComponent.this.updateManager.isRunning()) {
                AbstractJSVGComponent.this.updateManager.getUpdateRunnableQueue().invokeLater(new Runnable(this, bl2, bl){
                    private final /* synthetic */ boolean val$dispatchZoom;
                    private final /* synthetic */ boolean val$dispatchScroll;
                    private final /* synthetic */ JSVGComponentListener this$1;
                    {
                        this.this$1 = jSVGComponentListener;
                        this.val$dispatchZoom = bl;
                        this.val$dispatchScroll = bl2;
                    }

                    public void run() {
                        try {
                            if (this.val$dispatchZoom) {
                                JSVGComponentListener.access$100((JSVGComponentListener)this.this$1).updateManager.dispatchSVGZoomEvent();
                            }
                            if (this.val$dispatchScroll) {
                                JSVGComponentListener.access$100((JSVGComponentListener)this.this$1).updateManager.dispatchSVGScrollEvent();
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                });
            }
            this.prevScale = f;
            this.prevTransX = f2;
            this.prevTransY = f3;
        }

        public void updateMatrix(AffineTransform affineTransform) {
            this.prevScale = (float)Math.sqrt(affineTransform.getDeterminant());
            this.prevTransX = (float)affineTransform.getTranslateX();
            this.prevTransY = (float)affineTransform.getTranslateY();
        }

        static /* synthetic */ AbstractJSVGComponent access$100(JSVGComponentListener jSVGComponentListener) {
            return jSVGComponentListener.AbstractJSVGComponent.this;
        }
    }
}

