/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.net.URL;
import java.util.Vector;
import javax.swing.ImageIcon;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGSVGElement;
import util.FileUtils;

public class Util {
    public static double parseDouble(String s, double dflt) {
        try {
            double d = Double.parseDouble(s);
            return d;
        }
        catch (NumberFormatException nfe) {
            return dflt;
        }
        catch (NullPointerException npe) {
            return dflt;
        }
    }

    public static double parseDoubleLax(String s, double dflt) {
        try {
            char c;
            int i;
            s = s.trim();
            for (i = 0; i < s.length() && ((c = s.charAt(i)) == '1' || c == '2' || c == '3' || c == '4' || c == '5' || c == '6' || c == '7' || c == '8' || c == '9' || c == '0' || c == '.' || c == '-' && i == 0); ++i) {
            }
            s = s.substring(0, i);
            double d = Double.parseDouble(s);
            return d;
        }
        catch (NumberFormatException nfe) {
            return dflt;
        }
    }

    public static double parseLengthUnits(String s, double dflt) {
        return Util.parseDoubleLax(s, dflt);
    }

    public static double[] getDoubleArray(Vector v, int start, int end) {
        if (start < 0) {
            start = 0;
        }
        if (end < start) {
            end = start;
        }
        if (end > v.size()) {
            end = v.size();
        }
        double[] ret = new double[end - start];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (Double)v.elementAt(i + start);
        }
        return ret;
    }

    public static double[] getDoubleArray(Vector v) {
        return Util.getDoubleArray(v, 0, v.size());
    }

    public static boolean[] getBooleanArray(Vector v, int start, int end) {
        if (start < 0) {
            start = 0;
        }
        if (end < start) {
            end = start;
        }
        if (end > v.size()) {
            end = v.size();
        }
        boolean[] ret = new boolean[end - start];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (Boolean)v.elementAt(i + start);
        }
        return ret;
    }

    public static boolean[] getBooleanArray(Vector v) {
        return Util.getBooleanArray(v, 0, v.size());
    }

    public static String colorToHex(Color c) {
        return Integer.toHexString(c.getRed()) + Integer.toHexString(c.getGreen()) + Integer.toHexString(c.getBlue());
    }

    public static Dimension getImageDimensions(URL filename) {
        String ext = FileUtils.getExtension(filename);
        if (ext == null) {
            return null;
        }
        Dimension ret = new Dimension();
        if (ext.compareToIgnoreCase("svg") == 0) {
            try {
                SAXSVGDocumentFactory factory = new SAXSVGDocumentFactory(XMLResourceDescriptor.getXMLParserClassName());
                SVGDocument doc = (SVGDocument)factory.createDocument(filename.toString());
                SVGSVGElement root = doc.getRootElement();
                ret.width = (int)Util.parseDoubleLax(root.getAttribute("width"), -1.0);
                ret.height = (int)Util.parseDoubleLax(root.getAttribute("height"), -1.0);
                if (ret.width == -1 || ret.height == -1) {
                    return null;
                }
                return ret;
            }
            catch (Exception e) {
                return null;
            }
        }
        URL url = filename;
        if (url == null) {
            return null;
        }
        ImageIcon icon = new ImageIcon(url);
        if (icon.getImageLoadStatus() != 8) {
            return null;
        }
        ret.width = icon.getIconWidth();
        ret.height = icon.getIconHeight();
        return ret;
    }

    public static Point getGlobalCoord(Point local, Component c) {
        Point global = new Point(local);
        do {
            global.translate(c.getX(), c.getY());
        } while ((c = c.getParent()) != null);
        return global;
    }
}

