/*
 * Decompiled with CFR 0.152.
 */
package datastore;

import datastore.CollisionAvoider;
import datastore.Coloring;
import datastore.DataColumn;
import datastore.Datapoint;
import datastore.PointColumn;
import datastore.editor.DataSeries;
import datastore.editor.DataSteward;
import gui.ImageGenerator;
import gui.Language;
import gui.LinkProcessor;
import gui.PriorityFonts;
import gui.PriorityOptions;
import gui.Settings;
import gui.StringWrappingInfo;
import gui.TSCFont;
import gui.datamining.RollApply;
import gui.editor.SpreadSheet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import path.ResPath;
import util.FileUtils;

public class EventColumn
extends DataColumn
implements ActionListener {
    public boolean EVENT_PRIORITY_SET = false;
    private static final long serialVersionUID = 1L;
    public static String LINE_STYLE = "stroke-width: 0.5; stroke: black; fill: none;";
    public static String ARROW_STYLE = "stroke-width: 1; stroke: black; fill: black;";
    public static double LINE_WIDTH = 0.5;
    public static int FAD_ARROW_HEIGHT = 5;
    public static int LAD_ARROW_HEIGHT = 5;
    public static double ARROW_FIRST_STEP = 6.0;
    public static double ARROW_SECOND_STEP = 12.0;
    public static double ARROW_EVENT_STEP = 70.0;
    public static double ARROW_WIDTH = 5.0;
    public static double ARROW_HEIGHT = 4.0;
    public static double TEXT_MARGIN_WIDTH = 18.0;
    public static int FAD = 1;
    public static int LAD = 2;
    public static int EVENT = 2;
    public static int DRAW_EVENTS = 1;
    public static int DRAW_RANGES = 2;
    public static int orientation = 1;
    private int whichFrequency = -1;
    public int type = DRAW_EVENTS;
    public double eventsWidthBackup;
    public double[] newX;
    public double[] newY;
    EventColumn ec;
    JButton prioritySettings;
    PriorityOptions pOptions;
    PriorityFonts pFonts = new PriorityFonts();
    private JPanel eventFrequencyPanel;
    private JLabel bWindowSizeLabel;
    private JTextField bWindowSizeTextField;
    private JLabel bStepSizeLabel;
    private JTextField bStepSizeTextField;
    public JCheckBox bFADFreq;
    public JCheckBox bLADFreq;
    public JCheckBox bTurnoverFreq;
    private JLabel dualColComp;
    private JTextField myBaseColumn;
    private JTextField myOverlayColumn;
    private JButton secondChoose;
    public JCheckBox bOverlay;
    private JPanel settingsButtonPanel;
    private JLabel extendedSettingsText;
    private JButton bExtendedSettingsWindow;
    private JFrame extendedSettingsFrame;
    private JPanel extendedSettingsPanel;
    private JPanel settingsPanel;
    private JPanel dataMiningSettingsPanel;
    private JCheckBox bNumberOfEvents;
    private JLabel spacerLabel1;
    private JLabel spacerLabel2;
    private JLabel spacerLabel3;
    private JLabel spacerLabel4;
    private JLabel spacerLabel5;
    private JLabel extraRangeLabel;
    private JLabel dataMiningNote;
    public double windowSize = 2.0;
    public double stepSize = 1.0;
    public double[][] FADFrequencyResult;
    public double[][] LADFrequencyResult;
    public double[][] CombinedFrequencyResult;
    public static final String RANGE_LINE_STYLE = "stroke-width: 2; stroke: black;";
    public static final double RANGE_LINE_THICKNESS = 2.0;
    public static final double RANGE_LABEL_BOTTOM_MARGIN = 1.0;
    public static final double RANGE_LABEL_TOP_MARGIN = 2.0;
    public static final double RANGE_LABEL_PADDING = 2.0;
    public static final double RANGE_ENDPOINT_STALK_LENGTH = 10.0;
    public static final double RANGE_ENDPOINT_HEAD_WIDTH = 4.0;
    public static final String RANGE_ENDPOINT_STYLE = "stroke-width: 1; stroke: black;";
    double rangeWidth = 12.0;
    double maxRangeLabelHeight;
    SortedSet ranges = null;
    public int rangeSort = 1;
    protected int rangeSerial = 0;

    public EventColumn(String colName) {
        super(colName);
        this.iconPath = ResPath.getPath("icons.col_icon_event");
        this.setWidth(250.0);
        this.setColor(new Coloring(Color.white));
        this.setSelected(false);
    }

    public double getWindowSize() {
        String windowSize = this.bWindowSizeTextField.getText().toString();
        double res = Double.parseDouble(windowSize);
        return res;
    }

    public double getWindowSlide() {
        String windowSlide = this.bStepSizeTextField.getText().toString();
        double res = Double.parseDouble(windowSlide);
        return res;
    }

    @Override
    public JPanel getOptionsPanel() {
        if (this.optionsPanel == null) {
            this.optionsPanel = new JPanel();
            this.ec = this;
            GridBagLayout optionsPanelLayout = new GridBagLayout();
            optionsPanelLayout.rowWeights = new double[]{0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1};
            optionsPanelLayout.rowHeights = new int[]{4, 4, 4, 10, 10, 10, 10, 10};
            optionsPanelLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.1};
            optionsPanelLayout.columnWidths = new int[]{45, 60, 30, 20, 17};
            this.optionsPanel.setPreferredSize(new Dimension(30, 30));
            final EventColumn thisEC = this;
            this.settingsPanel = new JPanel();
            GridBagLayout settingsPanelLayout = new GridBagLayout();
            settingsPanelLayout.rowWeights = new double[]{0.01, 0.01};
            settingsPanelLayout.rowHeights = new int[]{9, 9};
            settingsPanelLayout.columnWeights = new double[]{0.1, 0.1, 0.0, 1.0};
            settingsPanelLayout.columnWidths = new int[]{45, 45, 200, 45};
            this.settingsPanel.setLayout(settingsPanelLayout);
            JPanel priorityPanel = new JPanel();
            priorityPanel.setLayout(new BoxLayout(priorityPanel, 1));
            JCheckBox priorityCB = new JCheckBox(Language.translate("Enable Priority Filtering", true));
            this.settingsPanel.add((Component)priorityCB, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.prioritySettings = new JButton(Language.translate("Priority Settings", true));
            this.prioritySettings.addActionListener(this);
            this.prioritySettings.setEnabled(this.EVENT_PRIORITY_SET);
            this.settingsPanel.add((Component)this.prioritySettings, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.extraRangeLabel = new JLabel();
            this.settingsPanel.add((Component)this.extraRangeLabel, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.extraRangeLabel.setText(Language.translate("Note: Ranges will set column width automatically.", true));
            this.extraRangeLabel.setLayout(null);
            this.settingsButtonPanel = new JPanel();
            GridBagLayout settingsButtonLayout = new GridBagLayout();
            settingsButtonLayout.rowWeights = new double[]{0.01, 0.01};
            settingsButtonLayout.rowHeights = new int[]{10, 10};
            settingsButtonLayout.columnWeights = new double[]{0.01, 0.01, 0.0, 1.0};
            settingsButtonLayout.columnWidths = new int[]{45, 45, 200, 45};
            this.settingsButtonPanel.setLayout(settingsButtonLayout);
            this.optionsPanel.add(this.settingsButtonPanel);
            this.extendedSettingsText = new JLabel();
            this.settingsButtonPanel.add((Component)this.extendedSettingsText, new GridBagConstraints(0, 0, 0, 0, 0.0, 0.0, 11, 10, new Insets(0, 0, 0, 0), 0, 0));
            this.extendedSettingsText.setText("   Previous event settings and new data mining options");
            this.extendedSettingsText.setFont(new Font("Ariel", 1, 8));
            this.extendedSettingsText.setForeground(Color.GRAY);
            this.bExtendedSettingsWindow = new JButton("Event Settings");
            this.settingsButtonPanel.add((Component)this.bExtendedSettingsWindow, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 10, new Insets(0, 0, 0, 0), 0, 0));
            this.bExtendedSettingsWindow.setBackground(Color.red);
            priorityCB.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent ie) {
                    EventColumn.this.EVENT_PRIORITY_SET = ((JCheckBox)ie.getItem()).isSelected();
                    EventColumn.this.prioritySettings.setEnabled(true);
                }
            });
            this.eventFrequencyPanel = new JPanel();
            GridBagLayout polarityPanelLayout = new GridBagLayout();
            polarityPanelLayout.rowWeights = new double[]{0.01, 0.01};
            polarityPanelLayout.rowHeights = new int[]{9, 9};
            polarityPanelLayout.columnWeights = new double[]{0.1, 0.1, 0.0, 1.0};
            polarityPanelLayout.columnWidths = new int[]{45, 45, 200, 45};
            this.eventFrequencyPanel.setLayout(polarityPanelLayout);
            this.spacerLabel3 = new JLabel();
            this.settingsPanel.add((Component)this.spacerLabel3, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.spacerLabel3.setText(Language.translate("   ", true));
            this.spacerLabel3.setLayout(null);
            this.spacerLabel1 = new JLabel();
            this.settingsPanel.add((Component)this.spacerLabel1, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.spacerLabel1.setText(Language.translate(" Data Mining Settings", true));
            this.spacerLabel1.setLayout(null);
            this.spacerLabel2 = new JLabel();
            this.settingsPanel.add((Component)this.spacerLabel2, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.spacerLabel2.setText(Language.translate(" _________________", true));
            this.spacerLabel2.setLayout(null);
            this.bWindowSizeLabel = new JLabel();
            this.settingsPanel.add((Component)this.bWindowSizeLabel, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.bWindowSizeLabel.setText(Language.translate(" Window Size :", true));
            this.bWindowSizeLabel.setLayout(null);
            this.bWindowSizeTextField = new JTextField();
            this.settingsPanel.add((Component)this.bWindowSizeTextField, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.bWindowSizeTextField.setText("2");
            this.bStepSizeLabel = new JLabel();
            this.settingsPanel.add((Component)this.bStepSizeLabel, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.bStepSizeLabel.setText(Language.translate(" Step Size:", true));
            this.bStepSizeLabel.setLayout(null);
            this.bStepSizeTextField = new JTextField();
            this.settingsPanel.add((Component)this.bStepSizeTextField, new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.bStepSizeTextField.setText("1");
            this.bFADFreq = new JCheckBox();
            this.settingsPanel.add((Component)this.bFADFreq, new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.bFADFreq.setText(Language.translate("Frequency of FAD", true));
            this.bFADFreq.setLayout(null);
            this.bLADFreq = new JCheckBox();
            this.settingsPanel.add((Component)this.bLADFreq, new GridBagConstraints(0, 10, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.bLADFreq.setText(Language.translate("Frequency of LAD", true));
            this.bLADFreq.setLayout(null);
            this.bTurnoverFreq = new JCheckBox();
            this.settingsPanel.add((Component)this.bTurnoverFreq, new GridBagConstraints(0, 11, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.bTurnoverFreq.setText(Language.translate("Combined Events", true));
            this.bTurnoverFreq.setLayout(null);
            this.dataMiningNote = new JLabel();
            this.settingsPanel.add((Component)this.dataMiningNote, new GridBagConstraints(0, 12, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.dataMiningNote.setText(Language.translate(" Note: Will add adjacent column", true));
            this.dataMiningNote.setFont(this.dataMiningNote.getFont().deriveFont(8.0f));
            this.dataMiningNote.setLayout(null);
            this.spacerLabel4 = new JLabel();
            this.settingsPanel.add((Component)this.spacerLabel4, new GridBagConstraints(0, 13, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.spacerLabel4.setText(Language.translate("   ", true));
            this.spacerLabel4.setLayout(null);
            this.dualColComp = new JLabel();
            this.settingsPanel.add((Component)this.dualColComp, new GridBagConstraints(0, 14, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.dualColComp.setText(Language.translate("Dual-Column Comparisons:", true));
            this.dualColComp.setLayout(null);
            this.spacerLabel5 = new JLabel();
            this.settingsPanel.add((Component)this.spacerLabel5, new GridBagConstraints(0, 14, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.spacerLabel5.setText(Language.translate(" _________________", true));
            this.spacerLabel5.setLayout(null);
            this.myBaseColumn = new JTextField();
            this.settingsPanel.add((Component)this.myBaseColumn, new GridBagConstraints(0, 15, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.myBaseColumn.setText(Settings.mySelectDC.name);
            this.myBaseColumn.setEditable(false);
            this.myOverlayColumn = new JTextField();
            this.settingsPanel.add((Component)this.myOverlayColumn, new GridBagConstraints(0, 16, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.myOverlayColumn.setText("Select column");
            this.myOverlayColumn.setEditable(false);
            this.secondChoose = new JButton();
            this.secondChoose.addActionListener(this);
            this.secondChoose.setText(Language.translate("Choose Second Column", true));
            this.settingsPanel.add((Component)this.secondChoose, new GridBagConstraints(0, 17, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.secondChoose.setLayout(null);
            this.bOverlay = new JCheckBox();
            this.settingsPanel.add((Component)this.bOverlay, new GridBagConstraints(0, 18, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.bOverlay.setText(Language.translate("Overlay", true));
            this.bOverlay.setLayout(null);
            this.bFADFreq.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent ie) {
                    if (((JCheckBox)ie.getItem()).isSelected()) {
                        EventColumn.this.bFADFreq.setSelected(true);
                        EventColumn.this.bLADFreq.setSelected(false);
                        EventColumn.this.bTurnoverFreq.setSelected(false);
                        EventColumn.this.bOverlay.setSelected(false);
                        EventColumn.this.dataMiningFunction = 0;
                        EventColumn.this.drawExtraColumn = true;
                        EventColumn.this.whichFrequency = 1;
                        EventColumn.this.windowSize = Double.parseDouble(EventColumn.this.bWindowSizeTextField.getText().toString());
                        EventColumn.this.stepSize = Double.parseDouble(EventColumn.this.bStepSizeTextField.getText().toString());
                        EventColumn.this.ec.extraColumnHeaderName = "FAD_Frequency";
                    }
                }
            });
            this.bLADFreq.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent ie) {
                    if (((JCheckBox)ie.getItem()).isSelected()) {
                        EventColumn.this.bLADFreq.setSelected(true);
                        EventColumn.this.bFADFreq.setSelected(false);
                        EventColumn.this.bTurnoverFreq.setSelected(false);
                        EventColumn.this.bOverlay.setSelected(false);
                        EventColumn.this.dataMiningFunction = 0;
                        EventColumn.this.drawExtraColumn = true;
                        EventColumn.this.whichFrequency = 2;
                        EventColumn.this.windowSize = Double.parseDouble(EventColumn.this.bWindowSizeTextField.getText().toString());
                        EventColumn.this.stepSize = Double.parseDouble(EventColumn.this.bStepSizeTextField.getText().toString());
                        EventColumn.this.ec.extraColumnHeaderName = "LAD_Frequency";
                    }
                }
            });
            this.bTurnoverFreq.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent ie) {
                    if (((JCheckBox)ie.getItem()).isSelected()) {
                        EventColumn.this.bTurnoverFreq.setSelected(true);
                        EventColumn.this.bLADFreq.setSelected(false);
                        EventColumn.this.bFADFreq.setSelected(false);
                        EventColumn.this.bOverlay.setSelected(false);
                        EventColumn.this.dataMiningFunction = 0;
                        EventColumn.this.drawMyOverlay = true;
                        EventColumn.this.drawExtraColumn = true;
                        EventColumn.this.whichFrequency = 3;
                        EventColumn.this.windowSize = Double.parseDouble(EventColumn.this.bWindowSizeTextField.getText().toString());
                        EventColumn.this.stepSize = Double.parseDouble(EventColumn.this.bStepSizeTextField.getText().toString());
                        EventColumn.this.ec.extraColumnHeaderName = "Combined_Frequency";
                    }
                }
            });
            this.bOverlay.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent ie) {
                    if (((JCheckBox)ie.getItem()).isSelected()) {
                        EventColumn.this.bOverlay.setSelected(true);
                        EventColumn.this.bTurnoverFreq.setSelected(false);
                        EventColumn.this.bLADFreq.setSelected(false);
                        EventColumn.this.bFADFreq.setSelected(false);
                        EventColumn.this.dataMiningFunction = 0;
                        EventColumn.this.drawMyOverlay = true;
                        EventColumn.this.drawExtraColumn = true;
                        EventColumn.this.whichFrequency = 4;
                        EventColumn.this.windowSize = Double.parseDouble(EventColumn.this.bWindowSizeTextField.getText().toString());
                        EventColumn.this.stepSize = Double.parseDouble(EventColumn.this.bStepSizeTextField.getText().toString());
                        EventColumn.this.ec.extraColumnHeaderName = "OVERLAY";
                    }
                }
            });
            this.bExtendedSettingsWindow.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EventColumn.this.extendedSettingsFrame = new JFrame("Extended Settings Window");
                    EventColumn.this.extendedSettingsFrame.setSize(500, 700);
                    EventColumn.this.extendedSettingsFrame.setVisible(true);
                    EventColumn.this.extendedSettingsPanel = new JPanel();
                    GridBagLayout extendedSettingsPanelLayout = new GridBagLayout();
                    extendedSettingsPanelLayout.rowWeights = new double[]{0.01, 0.01};
                    extendedSettingsPanelLayout.rowHeights = new int[]{10, 10};
                    extendedSettingsPanelLayout.columnWeights = new double[]{0.1, 0.1, 0.0, 1.0};
                    extendedSettingsPanelLayout.columnWidths = new int[]{45, 45, 100, 45};
                    EventColumn.this.extendedSettingsPanel.setLayout(extendedSettingsPanelLayout);
                    EventColumn.this.extendedSettingsPanel.add((Component)EventColumn.this.settingsPanel, new GridBagConstraints(0, 0, 0, 0, 0.0, 0.0, 18, 10, new Insets(0, 0, 0, 0), 0, 0));
                    EventColumn.this.extendedSettingsFrame.add(EventColumn.this.extendedSettingsPanel);
                }
            });
            this.settingsPanel.add(priorityPanel);
            URL imgURL = FileUtils.getURL(ResPath.getPath("icons.events"));
            JRadioButton eventsR = new JRadioButton("<html><table cellpadding=0><tr><td><img src=\"" + imgURL.toString() + "\"></td><td width=5></td><td>Events</td></tr></table></html>");
            imgURL = FileUtils.getURL(ResPath.getPath("icons.ranges"));
            JRadioButton rangesR = new JRadioButton("<html><table cellpadding=0><tr><td><img src=\"" + imgURL.toString() + "\"></td><td width=5></td><td>Ranges</td></tr></table></html>");
            ButtonGroup group = new ButtonGroup();
            group.add(eventsR);
            group.add(rangesR);
            this.settingsPanel.add((Component)eventsR, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.settingsPanel.add((Component)rangesR, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            JPanel sortPanel = new JPanel();
            sortPanel.setLayout(new BoxLayout(sortPanel, 1));
            sortPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 0));
            final JRadioButton firstR = new JRadioButton(Language.translate("First Occurrence", true));
            final JRadioButton lastR = new JRadioButton(Language.translate("Last Occurrence", true));
            final JRadioButton alphaR = new JRadioButton(Language.translate("Alphabetical", true));
            group = new ButtonGroup();
            group.add(firstR);
            group.add(lastR);
            group.add(alphaR);
            sortPanel.add(new JLabel("<html>" + Language.translate("sort by:", true) + "</html>"));
            sortPanel.add(firstR);
            sortPanel.add(lastR);
            sortPanel.add(alphaR);
            this.settingsPanel.add((Component)sortPanel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            eventsR.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent ie) {
                    if (((JRadioButton)ie.getItem()).isSelected()) {
                        thisEC.type = DRAW_EVENTS;
                        firstR.setEnabled(false);
                        lastR.setEnabled(false);
                        alphaR.setEnabled(false);
                    }
                }
            });
            rangesR.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent ie) {
                    if (((JRadioButton)ie.getItem()).isSelected()) {
                        thisEC.type = DRAW_RANGES;
                        firstR.setEnabled(true);
                        lastR.setEnabled(true);
                        alphaR.setEnabled(true);
                    }
                }
            });
            firstR.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent ie) {
                    if (((JRadioButton)ie.getItem()).isSelected()) {
                        thisEC.rangeSort = 1;
                    }
                }
            });
            lastR.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent ie) {
                    if (((JRadioButton)ie.getItem()).isSelected()) {
                        thisEC.rangeSort = 2;
                    }
                }
            });
            alphaR.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent ie) {
                    if (((JRadioButton)ie.getItem()).isSelected()) {
                        thisEC.rangeSort = 3;
                    }
                }
            });
            if (this.type == DRAW_EVENTS) {
                eventsR.setSelected(true);
            } else {
                rangesR.setSelected(true);
            }
            switch (this.rangeSort) {
                case 1: {
                    firstR.setSelected(true);
                    break;
                }
                case 2: {
                    lastR.setSelected(true);
                    break;
                }
                case 3: {
                    alphaR.setSelected(true);
                }
            }
        }
        return this.optionsPanel;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        if (source == this.prioritySettings) {
            this.pOptions = new PriorityOptions(this.pFonts);
            this.pOptions.addOptions(true);
            JOptionPane.showOptionDialog(this.optionsPanel, this.pOptions.getAddPanel(), Language.translate("Set Priority Fonts", true), 0, -1, null, new String[]{"Close"}, null);
        } else if (source == this.secondChoose && Settings.mySelectDC instanceof PointColumn) {
            PointColumn pc_old = (PointColumn)Settings.mySelectDC;
            this.myOverlayColumn.setText(pc_old.name);
            PointColumn pc_new = new PointColumn(pc_old.name + " copy");
            pc_new.pointType = pc_old.pointType;
            pc_new.drawPoints = pc_old.drawPoints;
            pc_new.drawLine = pc_old.drawLine;
            pc_new.lineColor = pc_old.lineColor;
            pc_new.drawFill = pc_old.drawFill;
            pc_new.drawSmooth = pc_old.drawSmooth;
            pc_new.minWindow = pc_old.minWindow;
            pc_new.maxWindow = pc_old.maxWindow;
            pc_new.data = pc_old.data;
            pc_new.initStep = pc_old.scaleStep;
            pc_new.scaleStep = pc_old.scaleStep;
            pc_new.fonts = pc_old.fonts;
            TSCFont myChosenFont = new TSCFont(pc_new.fonts.getFont(8));
            Color myColor = pc_old.lineColor;
            myChosenFont.setColor(myColor);
            pc_new.fonts.setFont(8, myChosenFont);
            pc_new.drawScale = true;
            pc_new.drawTitle = false;
            pc_new.keepCol = false;
            this.ec.addOverlay(pc_new);
        }
    }

    @Override
    public double getHeaderHeight(Settings settings, ImageGenerator ig) {
        super.getHeaderHeight(settings, ig);
        this.maxRangeLabelHeight = 0.0;
        if (this.type == DRAW_RANGES) {
            Iterator iter = this.ranges.iterator();
            int rangeCount = 0;
            while (iter.hasNext()) {
                Range r = (Range)iter.next();
                StringWrappingInfo testLabelSWI = ig.getSWIOneLine(r.name, this.fonts.getFont(9), 4, this.fileInfo);
                this.maxRangeLabelHeight = Math.max(this.maxRangeLabelHeight, testLabelSWI.getHeight());
                ++rangeCount;
            }
            this.myOwnHeaderHeight += this.maxRangeLabelHeight + 1.0 + 2.0;
        }
        this.myHeaderHeight = this.myOwnHeaderHeight;
        return this.myHeaderHeight;
    }

    @Override
    public void drawHeader(ImageGenerator ig, double startx, double starty, double width, double height, Settings settings) {
        if (this.myWidth < 0.0) {
            this.myWidth = this.getWidth(settings, ig, height);
        }
        if (this.myHeaderHeight < 0.0) {
            this.myHeaderHeight = this.getHeaderHeight(settings, ig);
        }
        ig.linkProc = this.fileInfo != null ? new LinkProcessor(this.fileInfo) : null;
        if (this.name.length() > 0 && this.drawTitle) {
            StringWrappingInfo myWrap = this.nameWrap;
            TSCFont myWrapHolder = this.fonts.getFont(0);
            double wrapSize = Math.floor(myWrapHolder.getSize());
            double myLayer = myWrap.getWidth() * (double)myWrap.getNumLines();
            double myThreshold = this.myWidth * 2.0;
            double wrapSize2 = wrapSize;
            String myString = this.name;
            String[] split = myString.split("(\\s)+");
            int myLength = 0;
            AffineTransform affinetransform = new AffineTransform();
            FontRenderContext frc = new FontRenderContext(affinetransform, true, true);
            Font font = new Font("Arial", 0, 14);
            int marker = 0;
            for (int x = 0; x < split.length; ++x) {
                int textwidth = (int)font.getStringBounds(split[x], frc).getWidth();
                if (textwidth <= myLength) continue;
                myLength = textwidth;
                marker = x;
            }
            if (myWrap.getNumLines() > 2 || (double)myLength >= this.nameWrap.getWidth()) {
                while (wrapSize > 6.0 && (myWrap.getNumLines() > 2 || (double)myLength >= this.nameWrap.getWidth())) {
                    myWrapHolder.setSize(wrapSize);
                    myWrap = ig.wrapString(this.name, this.myWidth, myWrapHolder, this.fileInfo);
                    myLayer = myWrap.getWidth() * (double)myWrap.getNumLines();
                    font = new Font("Arial", 0, (int)wrapSize);
                    myLength = (int)font.getStringBounds(split[marker], frc).getWidth();
                    wrapSize -= 1.0;
                }
            }
            ig.drawString(myWrap, startx, starty, width, height - this.maxRangeLabelHeight, 3);
            wrapSize = wrapSize2;
            myWrapHolder.setSize(wrapSize);
        }
        if (this.type == DRAW_RANGES) {
            Iterator iter = this.ranges.iterator();
            int rangeCount = 0;
            while (iter.hasNext()) {
                Range r = (Range)iter.next();
                StringWrappingInfo labelSWI = ig.getSWIOneLine(r.name, this.fonts.getFont(9), 4, this.fileInfo);
                ig.drawString(labelSWI, startx + (double)rangeCount * this.rangeWidth, starty + height - 1.0 - this.maxRangeLabelHeight, this.rangeWidth, this.maxRangeLabelHeight, 3);
                if (r.popup != null && settings.doPopups) {
                    ig.pushGrouping();
                    ig.doPopupThings(r.popup, this.fileInfo);
                    ig.drawRect(startx + (double)rangeCount * this.rangeWidth, starty + height - 1.0 - this.maxRangeLabelHeight, this.rangeWidth, this.maxRangeLabelHeight, "stroke-width: 0; opacity: 0.5; fill: red;");
                    ig.popGrouping();
                }
                ++rangeCount;
            }
        }
        if (this.popup != null && settings.doPopups) {
            ig.pushGrouping();
            ig.doPopupThings(this.popup, this.fileInfo);
            ig.drawRect(startx, starty, width, height, "stroke-width: 0; opacity: 0.5; fill: red;");
            ig.popGrouping();
        }
        if (this.drawMyOverlay) {
            this.drawHeaderOverlays(ig, startx, starty, width, height, settings);
        }
    }

    @Override
    public void drawData(ImageGenerator ig, double startx, double starty, double width, double height, Settings settings) {
        super.drawData(ig, startx, starty, width, height, settings);
        if (this.type == DRAW_RANGES) {
            this.drawRange(ig, startx, starty, width, height, settings);
            return;
        }
        Iterator iter = this.getDrawingData();
        ArrayList<Double> fadCount = new ArrayList<Double>();
        ArrayList<Double> ladCount = new ArrayList<Double>();
        ArrayList<Double> eventCount = new ArrayList<Double>();
        ArrayList<Double> combinedCount = new ArrayList<Double>();
        double unitToAgeFactor = height / (settings.baseAge - settings.topAge);
        double halfSpread = 1.0E-6;
        double ageLabelHeight = 0.0;
        if (this.drawAgeLabel) {
            FontMetrics fm = ig.getFontMetrics(this.fonts.getFont(1));
            ageLabelHeight = fm.getAscent();
        }
        CollisionAvoider fad_ca = new CollisionAvoider(0.0, height, Math.max((double)FAD_ARROW_HEIGHT, ageLabelHeight), width / 2.0 - TEXT_MARGIN_WIDTH, width / 2.0 - TEXT_MARGIN_WIDTH);
        CollisionAvoider lad_ca = new CollisionAvoider(0.0, height, Math.max((double)LAD_ARROW_HEIGHT, ageLabelHeight), width / 2.0 - TEXT_MARGIN_WIDTH, width / 2.0 - TEXT_MARGIN_WIDTH);
        fad_ca.setPrefBorrowDir(2);
        lad_ca.setPrefBorrowDir(3);
        CollisionAvoider cur_ca = new CollisionAvoider(0.0, height, Math.max((double)FAD_ARROW_HEIGHT, ageLabelHeight), width / 2.0 - TEXT_MARGIN_WIDTH, width / 2.0 - TEXT_MARGIN_WIDTH);
        while (iter.hasNext()) {
            Datapoint p = (Datapoint)iter.next();
            System.out.println("priority of " + p.label + " : " + p.priority);
            if (settings.isAbove(p.baseAge)) continue;
            if (settings.isBelow(p.baseAge)) break;
            if (((String)p.value).compareToIgnoreCase("LAD") == 0) {
                cur_ca = lad_ca;
                ladCount.add(p.baseAge);
                combinedCount.add(p.baseAge);
            } else if (((String)p.value).compareToIgnoreCase("FAD") == 0) {
                cur_ca = fad_ca;
                fadCount.add(p.baseAge);
                combinedCount.add(p.baseAge);
            } else if (((String)p.value).compareToIgnoreCase("EVENT") == 0) {
                cur_ca = fad_ca;
                eventCount.add(p.baseAge);
                combinedCount.add(p.baseAge);
            } else {
                cur_ca = fad_ca;
            }
            if (this.EVENT_PRIORITY_SET) {
                cur_ca.add(p, unitToAgeFactor * (p.baseAge - halfSpread - settings.topAge), unitToAgeFactor * (p.baseAge + halfSpread - settings.topAge), p.baseAge - halfSpread, p.baseAge + halfSpread, ig.getSWI(p.label, this.pFonts.getFont(p.priority), orientation, this.fileInfo));
                continue;
            }
            cur_ca.add(p, unitToAgeFactor * (p.baseAge - halfSpread - settings.topAge), unitToAgeFactor * (p.baseAge + halfSpread - settings.topAge), p.baseAge - halfSpread, p.baseAge + halfSpread, ig.getSWI(p.label, new TSCFont(this.fonts.getFont(5).getFamily(), this.fonts.getFont(5).getStyle(), this.fonts.getFont(5).getSize(), p.color), orientation, this.fileInfo));
        }
        if (this.drawMyOverlay) {
            this.drawOverlays(ig, startx, starty, width, height, settings);
        }
        if (this.drawExtraColumn) {
            int windows;
            double[] freqData;
            TreeSet newData = new TreeSet();
            Vector coordY = new Vector();
            if (this.whichFrequency == 1) {
                freqData = RollApply.listConversion(fadCount);
                windows = RollApply.numWindows(freqData, this.stepSize);
            } else if (this.whichFrequency == 2) {
                freqData = RollApply.listConversion(ladCount);
                windows = RollApply.numWindows(freqData, this.stepSize);
            } else if (this.whichFrequency == 3) {
                freqData = RollApply.listConversion(combinedCount);
                windows = RollApply.numWindows(freqData, this.stepSize);
            } else {
                freqData = RollApply.listConversion(combinedCount);
                windows = RollApply.numWindows(freqData, this.stepSize);
            }
            double[][] result = RollApply.frequency(freqData, windows, this.windowSize, this.stepSize);
            this.newX = result[0];
            this.newY = result[1];
            this.dataMiningColumnDrawing = true;
            this.drawExtraColumn = false;
        }
        boolean ladFull = false;
        boolean fadFull = false;
        if (fad_ca.getNumNodes() == 0) {
            lad_ca.setWidths(width - TEXT_MARGIN_WIDTH, width - TEXT_MARGIN_WIDTH);
            ladFull = true;
        } else if (lad_ca.getNumNodes() == 0) {
            fad_ca.setWidths(width - TEXT_MARGIN_WIDTH, width - TEXT_MARGIN_WIDTH);
            fadFull = true;
        }
        if (this.EVENT_PRIORITY_SET) {
            fad_ca.filter();
            lad_ca.filter();
        }
        fad_ca.fillHoles();
        fad_ca.pack();
        lad_ca.fillHoles();
        lad_ca.pack();
        if (!fadFull) {
            this.drawItems(ig, startx, starty, width / 2.0, height, settings, fad_ca, FAD, ageLabelHeight);
        } else {
            this.drawItems(ig, startx, starty, width, height, settings, fad_ca, FAD, ageLabelHeight);
        }
        if (!ladFull) {
            this.drawItems(ig, startx + width / 2.0, starty, width / 2.0, height, settings, lad_ca, LAD, ageLabelHeight);
        } else {
            this.drawItems(ig, startx, starty, width, height, settings, lad_ca, LAD, ageLabelHeight);
        }
        this.drawOverlays(ig, startx, starty, width, height, settings);
    }

    public void drawItems(ImageGenerator ig, double startx, double starty, double width, double height, Settings settings, CollisionAvoider ca, int type, double ageLabelHeight) {
        if (ca.getNumNodes() < 1) {
            return;
        }
        for (int i = 0; i < ca.getNumNodes(); ++i) {
            CollisionAvoider.Node node = ca.getAt(i);
            if (node.dp == null || node.dp.breaker) continue;
            this.drawItem(ig, startx, starty, width, height, settings, node, type, ageLabelHeight);
        }
    }

    protected void drawItem(ImageGenerator ig, double startx, double starty, double width, double height, Settings settings, CollisionAvoider.Node node, int type, double ageLabelHeight) {
        double labelX;
        int align;
        double[] tabX = new double[4];
        double[] tabY = new double[4];
        double[] arrowX = new double[3];
        double[] arrowY = new double[3];
        if (node.dp.value.toString().compareToIgnoreCase("EVENT") == 0) {
            tabX[0] = startx;
            tabX[1] = startx + ARROW_FIRST_STEP;
            tabX[2] = startx + ARROW_SECOND_STEP;
            tabX[3] = Math.min(startx + width * 0.3, startx + ARROW_EVENT_STEP);
            if (node.calcBase == node.origBase) {
                tabY[2] = tabY[3] = starty + node.origBase;
                tabY[1] = tabY[3];
                tabY[0] = tabY[3];
            } else {
                tabY[0] = tabY[1] = starty + node.origBase;
                tabY[2] = tabY[3] = starty + (node.calcBase + node.calcTop + node.swi.getHeight()) / 2.0;
            }
            arrowX[0] = arrowX[1] = tabX[3];
            arrowX[2] = arrowX[0] + ARROW_HEIGHT;
            arrowY[0] = tabY[3] + ARROW_WIDTH / 2.0;
            arrowY[1] = tabY[3] - ARROW_WIDTH / 2.0;
            arrowY[2] = (arrowY[0] + arrowY[1]) / 2.0;
            align = 1;
            labelX = startx + TEXT_MARGIN_WIDTH;
            StringWrappingInfo ageLabel = ig.getSWIOneLine(this.getAgeLabel(node.origBaseAge), this.fonts.getFont(1), 1, this.fileInfo);
            StringWrappingInfo uncertaintyLabel = ig.getSWIOneLine(this.getUncertaintyLabel(node), this.fonts.getFont(2), 1, this.fileInfo);
            if (this.drawAgeLabel) {
                ig.drawString(ageLabel, arrowX[2] + 10.0, starty + node.calcBase - ageLabelHeight, 20.0, ageLabelHeight, 3);
            }
            if (this.drawUncertaintyLabel) {
                ig.drawString(uncertaintyLabel, arrowX[2] + 10.0, starty + node.calcBase - ageLabelHeight, 20.0, ageLabelHeight, 3);
            }
        } else if (type == FAD) {
            tabX[0] = startx;
            tabX[1] = startx + ARROW_FIRST_STEP;
            tabX[2] = startx + ARROW_SECOND_STEP;
            tabX[3] = Math.min(startx + width * 0.3, startx + ARROW_EVENT_STEP);
            if (node.calcBase == node.origBase) {
                tabY[2] = tabY[3] = starty + node.origBase;
                tabY[1] = tabY[3];
                tabY[0] = tabY[3];
            } else {
                tabY[0] = tabY[1] = starty + node.origBase;
                tabY[2] = tabY[3] = starty + (node.calcBase + node.calcTop + node.swi.getHeight()) / 2.0;
            }
            arrowX[0] = tabX[3];
            arrowX[1] = arrowX[0] - ARROW_WIDTH;
            arrowX[2] = (arrowX[0] + arrowX[1]) / 2.0;
            arrowY[0] = arrowY[1] = tabY[3];
            arrowY[2] = arrowY[0] - ARROW_HEIGHT;
            align = 9;
            labelX = startx + TEXT_MARGIN_WIDTH;
            StringWrappingInfo ageLabel = ig.getSWIOneLine(this.getAgeLabel(node.origBaseAge), this.fonts.getFont(1), 1, this.fileInfo);
            StringWrappingInfo uncertaintyLabel = ig.getSWIOneLine(this.getUncertaintyLabel(node), this.fonts.getFont(2), 1, this.fileInfo);
            if (this.drawAgeLabel) {
                ig.drawString(ageLabel, arrowX[1] + 10.0, tabY[2] - ageLabelHeight, 20.0, ageLabelHeight, 3);
            }
            if (this.drawUncertaintyLabel) {
                ig.drawString(uncertaintyLabel, arrowX[1] + 10.0 + ageLabel.getWidth() + 5.0, tabY[2] - ageLabelHeight, 20.0, ageLabelHeight, 3);
            }
        } else {
            tabX[0] = startx + width;
            tabX[1] = startx + width - ARROW_FIRST_STEP;
            tabX[2] = startx + width - ARROW_SECOND_STEP;
            tabX[3] = Math.max(startx + width * 0.7, startx + width - ARROW_EVENT_STEP);
            if (node.calcTop == node.origTop) {
                tabY[2] = tabY[3] = starty + node.origTop;
                tabY[1] = tabY[3];
                tabY[0] = tabY[3];
            } else {
                tabY[0] = tabY[1] = starty + node.origTop;
                tabY[2] = tabY[3] = starty + (node.calcBase + node.calcTop - node.swi.getHeight()) / 2.0;
            }
            arrowX[0] = tabX[3];
            arrowX[1] = arrowX[0] + ARROW_WIDTH;
            arrowX[2] = (arrowX[0] + arrowX[1]) / 2.0;
            arrowY[0] = arrowY[1] = tabY[3];
            arrowY[2] = arrowY[0] + ARROW_HEIGHT;
            align = 8;
            labelX = startx;
            StringWrappingInfo ageLabel = ig.getSWIOneLine(this.getAgeLabel(node.origBaseAge), this.fonts.getFont(1), 1, this.fileInfo);
            StringWrappingInfo uncertaintyLabel = ig.getSWIOneLine(this.getUncertaintyLabel(node), this.fonts.getFont(2), 1, this.fileInfo);
            if (this.drawAgeLabel) {
                if (this.drawUncertaintyLabel) {
                    ig.drawString(ageLabel, arrowX[0] - ageLabel.getWidth() - uncertaintyLabel.getWidth() - 5.0 - 10.0, tabY[2] + LINE_WIDTH, ageLabel.getWidth(), ageLabelHeight, 1);
                } else {
                    ig.drawString(ageLabel, arrowX[0] - ageLabel.getWidth() - 10.0, tabY[2] + LINE_WIDTH, ageLabel.getWidth(), ageLabelHeight, 1);
                }
            }
            if (this.drawUncertaintyLabel) {
                ig.drawString(uncertaintyLabel, arrowX[0] - uncertaintyLabel.getWidth() - 10.0, tabY[2] + LINE_WIDTH, uncertaintyLabel.getWidth(), ageLabelHeight, 1);
            }
        }
        ig.drawPolyline(tabX, tabY, LINE_STYLE + Settings.getStroke(node.dp == null ? 1 : node.dp.lineType));
        ig.drawPolygon(arrowX, arrowY, ARROW_STYLE);
        if (node.dp.value.toString().compareToIgnoreCase("EVENT") == 0) {
            ig.drawString(node.swi, labelX, node.calcTop + starty, node.swi.getWidth(), node.getCalcHeight(), align, 3.0, 10, this.color.oneColor);
        } else {
            ig.drawString(node.swi, labelX, node.calcTop + starty, width - TEXT_MARGIN_WIDTH, node.getCalcHeight(), align, 3.0, 10, this.color.oneColor);
        }
        if (node.dp.popup != null && settings.doPopups) {
            ig.pushGrouping();
            ig.doPopupThings(node.dp.popup, this.fileInfo);
            if (node.dp.value.toString().compareToIgnoreCase("EVENT") == 0) {
                ig.drawRect(labelX, node.calcTop + starty, node.swi.getWidth(), node.getCalcHeight(), "stroke-width: 0; opacity: 0.5; fill: red;");
            } else {
                ig.drawRect(labelX, node.calcTop + starty, width - TEXT_MARGIN_WIDTH, node.getCalcHeight(), "stroke-width: 0; opacity: 0.5; fill: red;");
            }
            ig.popGrouping();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void drawRange(ImageGenerator ig, double startx, double starty, double width, double height, Settings settings) {
        iter = this.ranges.iterator();
        rangeCount = 0;
        while (iter.hasNext()) {
            block7: {
                r = (Range)iter.next();
                rangeStart = startx + (double)rangeCount * this.rangeWidth;
                rangeX = rangeStart + this.rangeWidth / 2.0;
                top = (r.top - settings.topAge) * settings.unitsPerMY + starty;
                base = (r.base - settings.topAge) * settings.unitsPerMY + starty;
                if (Double.isNaN(r.base) || Double.isNaN(r.top)) break block7;
                ig.drawLineYear(rangeX, r.base, rangeX, r.top, "stroke-width: 2; stroke: black;", starty);
                ** GOTO lbl32
            }
            if (Double.isNaN(r.base) && Double.isNaN(r.top)) {
                System.out.println("Error drawing range: How the heck! Both ends are NaN!");
            } else {
                if (Double.isNaN(r.base)) {
                    top = (r.top - settings.topAge) * settings.unitsPerMY + starty;
                    base = Math.min(top + 10.0, starty + height);
                    ig.drawLine(rangeX - 2.0, top, rangeX + 2.0, top, "stroke-width: 1; stroke: black;");
                    ig.drawLine(rangeX, base, rangeX, top, "stroke-width: 1; stroke: black;");
                } else if (Double.isNaN(r.top)) {
                    base = (r.base - settings.topAge) * settings.unitsPerMY + starty;
                    top = Math.max(base - 10.0, starty);
                    ig.drawLine(rangeX - 2.0, base, rangeX + 2.0, base, "stroke-width: 1; stroke: black;");
                    ig.drawLine(rangeX, base, rangeX, top, "stroke-width: 1; stroke: black;");
                }
lbl32:
                // 5 sources

                if (r.popup != null && settings.doPopups) {
                    ig.pushGrouping();
                    ig.doPopupThings(r.popup, this.fileInfo);
                    ig.drawRect(rangeStart, top, this.rangeWidth, base - top, "stroke-width: 0; opacity: 0.5; fill: red;");
                    ig.popGrouping();
                }
            }
            ++rangeCount;
        }
    }

    public void cleanupDrawing() {
        if (this.type == DRAW_RANGES) {
            this.myWidth = this.eventsWidthBackup;
        }
    }

    public void findRanges(int sortBy, double baseClip, double topClip) {
        Vector<RangeEndpoint> endpoints = new Vector<RangeEndpoint>(this.data.size());
        this.ranges = Collections.synchronizedSortedSet(new TreeSet(new RangeComparator(sortBy)));
        Iterator iter = this.getDrawingData();
        while (iter.hasNext()) {
            Datapoint p = (Datapoint)iter.next();
            StringTokenizer st = new StringTokenizer(p.label, ",");
            while (st.hasMoreTokens()) {
                String l = st.nextToken().trim();
                if (l.length() < 1) continue;
                RangeEndpoint re = new RangeEndpoint();
                re.age = p.baseAge;
                re.name = l;
                re.popup = p.popup;
                String pType = (String)p.value;
                if (pType.compareToIgnoreCase("LAD") == 0) {
                    re.top = true;
                } else {
                    if (pType.compareToIgnoreCase("FAD") != 0) continue;
                    re.top = false;
                }
                endpoints.add(re);
            }
        }
        for (RangeEndpoint re : endpoints) {
            if (re.used) continue;
            for (RangeEndpoint match : endpoints) {
                if (match.used || match.name.compareToIgnoreCase(re.name) != 0) continue;
                Range r = null;
                if (!re.top && match.top) {
                    r = new Range();
                    r.base = re.age;
                    r.top = match.age;
                    r.name = re.name;
                    r.popup = this.getPopup(re, match);
                }
                if (re.top && !match.top) {
                    r = new Range();
                    r.base = match.age;
                    r.top = re.age;
                    r.name = re.name;
                    r.popup = this.getPopup(re, match);
                }
                if (r == null) continue;
                re.used = true;
                match.used = true;
                if (r.base < topClip || r.top > baseClip) continue;
                if (r.base > baseClip) {
                    r.base = baseClip;
                }
                if (r.top < topClip) {
                    r.top = topClip;
                }
                this.ranges.add(r);
            }
        }
        for (RangeEndpoint re : endpoints) {
            if (re.used || re.age < topClip || re.age > baseClip) continue;
            Range r = new Range();
            if (re.top) {
                r.top = re.age;
                r.base = Double.NaN;
            } else {
                r.base = re.age;
                r.top = Double.NaN;
            }
            r.name = re.name;
            r.popup = this.getPopup(re, null);
            re.used = true;
            this.ranges.add(r);
        }
    }

    protected String getPopup(RangeEndpoint p1, RangeEndpoint p2) {
        String first = null;
        String last = null;
        if (p1 != null && p1.popup != null && p1.popup.trim().length() > 0) {
            if (!p1.top) {
                first = "First Occurrence:\r\n" + p1.popup;
            } else {
                last = "Last Occurrence:\r\n" + p1.popup;
            }
        }
        if (p2 != null && p2.popup != null && p2.popup.trim().length() > 0) {
            if (!p2.top) {
                first = "First Occurrence:\r\n" + p2.popup;
            } else {
                last = "Last Occurrence:\r\n" + p2.popup;
            }
        }
        if (first != null && last != null) {
            return first + "\r\n---\r\n" + last;
        }
        if (first != null && last == null) {
            return first;
        }
        if (first == null && last != null) {
            return last;
        }
        return null;
    }

    @Override
    public int getNumSeries() {
        return 3;
    }

    @Override
    public boolean canAlterSeries() {
        return false;
    }

    @Override
    public DataSeries getSeriesModel(int which) {
        DataSeries series = new DataSeries();
        switch (which) {
            case 0: {
                series.setSingle(new EventDataSteward("LAD"));
                break;
            }
            case 1: {
                series.setSingle(new EventDataSteward("FAD"));
                break;
            }
            case 2: {
                series.setSingle(new EventDataSteward("EVENT"));
                break;
            }
            default: {
                return null;
            }
        }
        return series;
    }

    @Override
    public String getSeriesName(int which) {
        switch (which) {
            case 0: {
                return "FAD";
            }
            case 1: {
                return "LAD";
            }
            case 2: {
                return "EVENT";
            }
        }
        return null;
    }

    @Override
    public double getWidth(Settings settings, ImageGenerator ig, double dataHeight) {
        if (this.type != DRAW_RANGES) {
            return this.myWidth;
        }
        this.eventsWidthBackup = this.myWidth;
        this.findRanges(this.rangeSort, settings.baseAge, settings.topAge);
        StringWrappingInfo testLabelSWI = ig.getSWIOneLine("The quick brown fox jumped over the lazy dog.", this.fonts.getFont(9), 4, this.fileInfo);
        this.rangeWidth = testLabelSWI.getWidth() + 2.0;
        this.myWidth = Math.ceil((double)this.ranges.size() * this.rangeWidth);
        if (this.myWidth < 20.0) {
            this.myWidth = 20.0;
        }
        return this.myWidth;
    }

    @Override
    public void readOneSetting(Element setting, Settings settings) {
        super.readOneSetting(setting, settings);
        String name = setting.getAttribute("name");
        if (name != null) {
            if (name.compareToIgnoreCase("type") == 0) {
                String t = Settings.getNodeTextContent(setting);
                this.type = t.compareToIgnoreCase("ranges") == 0 ? DRAW_RANGES : DRAW_EVENTS;
            } else if (name.compareToIgnoreCase("rangeSort") == 0) {
                String t = Settings.getNodeTextContent(setting);
                this.rangeSort = t.compareToIgnoreCase("first occurrence") == 0 ? 1 : (t.compareToIgnoreCase("last occurrence") == 0 ? 2 : (t.compareToIgnoreCase("alphabetical") == 0 ? 3 : 0));
            }
        }
    }

    @Override
    public void writeSettings(Element element, Document doc) {
        super.writeSettings(element, doc);
        Element typeE = Settings.createSimpleSetting(doc, "type", null);
        if (this.type == DRAW_EVENTS) {
            Settings.setNodeTextContent(typeE, "events", doc);
        } else {
            Settings.setNodeTextContent(typeE, "ranges", doc);
        }
        element.appendChild(typeE);
        Element rangeSortE = Settings.createSimpleSetting(doc, "rangeSort", null);
        switch (this.rangeSort) {
            case 1: {
                Settings.setNodeTextContent(rangeSortE, "first occurrence", doc);
                break;
            }
            case 2: {
                Settings.setNodeTextContent(rangeSortE, "last occurrence", doc);
                break;
            }
            case 3: {
                Settings.setNodeTextContent(rangeSortE, "alphabetical", doc);
                break;
            }
            default: {
                Settings.setNodeTextContent(rangeSortE, "other", doc);
            }
        }
        element.appendChild(rangeSortE);
    }

    public void writeSeries(Writer w, String series) throws IOException {
        boolean wroteHeader = false;
        Iterator iter = this.getData();
        while (iter.hasNext()) {
            Datapoint dp = (Datapoint)iter.next();
            if (((String)dp.value).compareToIgnoreCase(series) != 0) continue;
            if (!wroteHeader) {
                w.write(series + "\r\n");
                wroteHeader = true;
            }
            w.write("\t" + dp.label + "\t" + Double.toString(dp.baseAge) + "\t");
            switch (dp.lineType) {
                case 2: {
                    w.write("dashed\t");
                    break;
                }
                case 3: {
                    w.write("dotted\t");
                    break;
                }
                case 1: {
                    w.write("solid\t");
                    break;
                }
                default: {
                    w.write(9);
                }
            }
            if (dp.popup != null) {
                EventColumn.writeRichText(w, dp.popup);
            }
            w.write("\r\n");
        }
    }

    @Override
    public void write(Writer w) throws IOException {
        this.writeHeader(w, "event");
        this.writeSeries(w, "FAD");
        this.writeSeries(w, "LAD");
        this.writeSeries(w, "EVENT");
        this.writeOverlaysAndUnderlays(w);
    }

    public class TableInterpreter
    extends DataColumn.TableInterpreter {
        public String[] myNames = new String[]{"Label", "Age", "Line", "Popup"};
        public String[] myToolTips = new String[]{"Critter or event name", null, "Style of line", null};
        public Class[] myClasses = new Class[]{String.class, Double.class, DataColumn.TableInterpreter.LineType.class, String.class};

        public TableInterpreter() {
            this.names = this.myNames;
            this.classes = this.myClasses;
            this.toolTips = this.myToolTips;
        }

        @Override
        public void registerEditorsAndRenderers(SpreadSheet spread) {
            spread.setDefaultEditor(DataColumn.TableInterpreter.LineType.class, new DefaultCellEditor(new DataColumn.TableInterpreter.LineType().getComboBox()));
            spread.setDefaultRenderer(DataColumn.TableInterpreter.LineType.class, new DataColumn.TableInterpreter.LineType());
        }

        @Override
        public Object getValue(Datapoint p, int col) {
            switch (col) {
                case 0: {
                    return p.label;
                }
                case 1: {
                    return new Double(p.baseAge);
                }
                case 2: {
                    switch (p.lineType) {
                        case 2: {
                            return "dashed";
                        }
                        case 3: {
                            return "dotted";
                        }
                    }
                    return "";
                }
                case 3: {
                    return p.popup;
                }
            }
            return null;
        }

        @Override
        public void setValue(Datapoint p, Object value, int col) {
            if (value == null) {
                value = "";
            }
            switch (col) {
                case 0: {
                    p.label = value.toString();
                    if (p.label.compareTo("TOP") == 0) {
                        p.breaker = true;
                        break;
                    }
                    p.breaker = false;
                    break;
                }
                case 1: {
                    double age = Double.NaN;
                    if (value instanceof Double) {
                        age = (Double)value;
                    } else {
                        try {
                            age = Double.parseDouble(value.toString());
                        }
                        catch (Exception e) {
                            age = Double.NaN;
                        }
                    }
                    p.baseAge = !Double.isNaN(age) ? age : 0.0;
                    EventColumn.this.updateMinMaxAges();
                    break;
                }
                case 2: {
                    String s = value.toString().trim();
                    if (s.compareToIgnoreCase("dashed") == 0) {
                        p.lineType = 2;
                        break;
                    }
                    if (s.compareToIgnoreCase("dotted") == 0) {
                        p.lineType = 3;
                        break;
                    }
                    p.lineType = 1;
                    break;
                }
                case 3: {
                    p.popup = value.toString();
                }
            }
        }
    }

    protected class EventDataSteward
    extends DataSteward {
        String type;
        public static final int LAD = 1;
        public static final int FAD = 2;
        public static final int EVENT = 3;
        Vector v;

        @Override
        public void add(Datapoint o) {
            if (o instanceof Datapoint) {
                o.value = this.type;
            }
            super.add(o);
        }

        @Override
        public Vector getVector() {
            return this.v;
        }

        @Override
        public Iterator iterator() {
            return this.v.iterator();
        }

        @Override
        public int size() {
            return this.v.size();
        }

        public EventDataSteward(String type) {
            super(EventColumn.this.data, new TableInterpreter());
            this.v = new Vector();
            this.type = type;
            this.refreshVector();
        }

        protected void refreshVector() {
            this.v.removeAllElements();
            for (Datapoint p : EventColumn.this.data) {
                if (p.value.toString().compareToIgnoreCase(this.type) != 0) continue;
                this.v.add(p);
            }
        }
    }

    public static class RangeComparator
    implements Comparator {
        public static final int FIRST_OCCURANCE = 1;
        public static final int LAST_OCCURANCE = 2;
        public static final int ALPHABETICAL = 3;
        public static final int OTHER = 0;
        int type;

        public RangeComparator(int type) {
            this.type = type;
        }

        public int compare(Object arg0, Object arg1) {
            Range left = (Range)arg0;
            Range right = (Range)arg1;
            if (left == null || right == null) {
                return 0;
            }
            int result = this.compareByType(left, right, this.type);
            if (result == 0 && this.type == 1) {
                result = -this.compareByType(left, right, 2);
            } else if (result == 0 && this.type == 2) {
                result = -this.compareByType(left, right, 1);
            }
            if (result == 0 && this.type != 3) {
                result = this.compareByType(left, right, 3);
            }
            if (result == 0) {
                result = this.compareByType(left, right, 0);
            }
            return result;
        }

        public int compareByType(Range left, Range right, int type) {
            if (type == 1) {
                if (Double.isNaN(left.base) && Double.isNaN(right.base)) {
                    return 0;
                }
                if (Double.isNaN(left.base)) {
                    return -1;
                }
                if (Double.isNaN(right.base)) {
                    return 1;
                }
                double result = right.base - left.base;
                if (result > -1.0E-6 && result < 1.0E-6) {
                    return 0;
                }
                if (result > 0.0) {
                    return 1;
                }
                return -1;
            }
            if (type == 2) {
                if (Double.isNaN(left.top) && Double.isNaN(right.top)) {
                    return 0;
                }
                if (Double.isNaN(left.top)) {
                    return -1;
                }
                if (Double.isNaN(right.top)) {
                    return 1;
                }
                double result = left.top - right.top;
                if (result > -1.0E-6 && result < 1.0E-6) {
                    return 0;
                }
                if (result > 0.0) {
                    return 1;
                }
                return -1;
            }
            if (type == 3) {
                return left.name.compareToIgnoreCase(right.name);
            }
            return left.mySerial - right.mySerial;
        }
    }

    public class Range {
        double base = Double.NaN;
        double top = Double.NaN;
        String name;
        String popup;
        int mySerial;

        public Range() {
            this.mySerial = EventColumn.this.rangeSerial++;
        }
    }

    public class RangeEndpoint {
        double age;
        String name;
        String popup;
        boolean top = false;
        boolean used = false;
    }
}

