/*
 * Decompiled with CFR 0.152.
 */
package datastore;

import datastore.Coloring;
import datastore.DataColumn;
import datastore.Datapoint;
import datastore.EvTree;
import datastore.editor.DataSeries;
import datastore.editor.DataSteward;
import gui.ImageGenerator;
import gui.Language;
import gui.LinkProcessor;
import gui.RichText;
import gui.Settings;
import gui.StringWrappingInfo;
import gui.TSCFont;
import gui.TSCreator;
import gui.editor.ComboBoxRenderer;
import gui.editor.SpreadSheet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import path.ResPath;
import util.Debug;

public class RangeColumn
extends DataColumn
implements ActionListener {
    private static final long serialVersionUID = 1L;
    public static final int MIN_RANGE_COL_WIDTH = 50;
    private JButton saveTreeButton = null;
    private JButton analyzeTreeButton = null;
    public static final double RANGE_COLUMN_TITLE_PADDING = 10.0;
    public static final double RANGE_LABEL_BOTTOM_MARGIN = 1.0;
    public static final double RANGE_LABEL_TOP_MARGIN = 3.0;
    public static final double RANGE_TO_TOP_LABEL_MARGIN = 3.0;
    public static final double RANGE_TO_BOTTOM_LABEL_MARGIN = 3.0;
    public static final double RANGE_LABEL_TO_RANGE_MARGIN = 0.5;
    public static final double RANGE_PADDING = 2.0;
    public static double RANGE_LABEL_X_PADDING = 2.5;
    public static double RANGE_LABEL_Y_PADDING = 2.5;
    public static double AGE_LABEL_X_PADDING = 3.5;
    public static double AGE_LABEL_Y_PADDING = 0.0;
    public static final double PHENON_RANGE_LINE_STROKE_WIDTH = 2.0;
    public static final double RANGE_BOX_STROKE_WIDTH = 4.0;
    public static final double RANGE_BOX_EXTRA_WIDTH = 120.0;
    public static final double RANGE_CANVAS_START_PADDING = 30.0;
    public static final double WIDTH_FOR_SPECIES_BOX_INTERVAL = 50.0;
    public static final double PADDING_EVO_TREE = 2.0;
    public double MAXIMUM_PADDING = 1000.0;
    public double MINIMUM_PADDING = 100.0;
    public double TOTAL_RANGE_WIDTH = 0.0;
    public static final double RANGE_ARROW_STALK_LENGTH = 10.0;
    public static final double RANGE_ARROW_HEAD_LENGTH = 4.0;
    public static final double RANGE_ARROW_HEAD_WIDTH = 4.0;
    public static final double SAMPLE_RADIUS = 3.0;
    public static final double RANGE_ARROW_LENGTH = 2.5;
    public static final double RANGE_ARROW_VERTICAL_PADDING = 0.15;
    public static final RangeStyle style_sample = new RangeStyle(" stroke: black;", 1.0);
    public static final RangeStyle style_missing = new RangeStyle("", 0.0);
    public static final RangeStyle style_rare = new RangeStyle("stroke-dasharray:7,4; stroke: black;", 0.5);
    public static final RangeStyle style_conjectured = new RangeStyle("stroke-dasharray:2,2; stroke: black;", 0.5);
    public static final RangeStyle style_common = new RangeStyle(" stroke: black;", 0.75);
    public static final RangeStyle style_frequent = new RangeStyle(" stroke: black;", 2.5);
    public static final RangeStyle style_abundant = new RangeStyle(" stroke: black;", 5.0);
    public static final RangeStyle style_flood = new RangeStyle(" stroke: black;", 9.0);
    double maxRangeLabelHeaderHeight;
    protected SortedSet<Range> ranges = null;
    protected SortedSet<Range> rangesWithoutSplit = null;
    protected SortedSet<Range> phenonRanges = null;
    protected SortedSet<Range> extendedRanges = null;
    public int rangeSort = 1;
    public boolean hasTrees = false;
    public boolean drawTrees = true;
    public boolean drawLabelsInHeader = false;
    public boolean speciesPhenonTreeDrawing = false;
    public boolean sideBySideTreeStructure = false;
    public boolean integratedTreeStructure = false;
    public boolean enableAllBranches = false;
    public boolean hideBranchAncestors = true;
    public static String errMsg = "";
    public static JFrame errFamilyTree = null;
    public static JTextArea errFamilyTreeMessage = null;
    public static JButton errFamilyTreeButton = null;
    public static boolean ConserveSpace = false;
    private int minLocation = 0;
    public static boolean initialLoading = true;
    public static boolean speciesBoxBranchClicked = false;
    public static HashMap<String, String> circleDrawingLeftOrRight = new HashMap();
    private HashMap<Range, Boolean> phenonRangeStateMap = new HashMap();
    private LinkedList<RangeSize> assignedLocationList = null;
    public LabelLocation[] labelLocSearchOrder = new LabelLocation[]{LabelLocation.LEFT_SIDE, LabelLocation.RIGHT_SIDE, LabelLocation.TOP, LabelLocation.BOTTOM, LabelLocation.HEADER};
    protected String firstRangeForPath;
    protected String firstRangeName;
    protected String secondRangeName;
    protected boolean drawFirstRangePath = false;
    protected boolean drawSecondRangePath = false;
    protected boolean drawFirstToSecondRangePath = false;
    protected boolean drawAncestorPath;
    public Settings settings = null;
    private JTextField commonAncestorText;
    protected int rangePointSerial = 0;
    protected int rangeSerial = 0;
    private EvTree T;
    private EvTree.TreeNode tree;
    private RangePoint clickedBranchPoint = null;
    public static boolean exceptionHandling = false;
    public static String consolidatedPlottingErrs = "";

    @Override
    public void addData(Datapoint dp) {
        if (!(dp instanceof RCDatapoint)) {
            RCDatapoint rcd = new RCDatapoint(dp);
            dp = rcd;
        }
        super.addData(dp);
    }

    public RangeColumn(String colName) {
        super(colName);
        this.iconPath = ResPath.getPath("icons.col_icon_range");
        this.createDataSet(new Datapoint.LabelComparator());
        this.setColor(new Coloring(Color.white));
    }

    @Override
    public JPanel getOptionsPanel() {
        final RangeColumn thisRC = this;
        this.optionsPanel = new JPanel();
        this.optionsPanel.setLayout(new BoxLayout(this.optionsPanel, 1));
        JPanel treeOptionsPanel = new JPanel();
        treeOptionsPanel.setLayout(new BoxLayout(treeOptionsPanel, 1));
        this.saveTreeButton = new JButton(Language.translate("Save Tree", true));
        this.saveTreeButton.addActionListener(this);
        this.analyzeTreeButton = new JButton(Language.translate("Analyze", true));
        treeOptionsPanel.add(this.saveTreeButton);
        this.optionsPanel.add(treeOptionsPanel);
        JPanel sortPanel = new JPanel();
        sortPanel.setLayout(new BoxLayout(sortPanel, 1));
        sortPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        JRadioButton firstR = new JRadioButton(Language.translate("First Occurrence", true));
        JRadioButton lastR = new JRadioButton(Language.translate("Last Occurrence", true));
        JRadioButton alphaR = new JRadioButton(Language.translate("Alphabetical", true));
        ButtonGroup group = new ButtonGroup();
        group.add(firstR);
        group.add(lastR);
        group.add(alphaR);
        sortPanel.add(new JLabel("<html>" + Language.translate("sort by:", true) + "</html>"));
        sortPanel.add(firstR);
        sortPanel.add(lastR);
        sortPanel.add(alphaR);
        this.optionsPanel.add(sortPanel);
        firstR.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                if (((JRadioButton)ie.getItem()).isSelected()) {
                    thisRC.rangeSort = 1;
                }
            }
        });
        lastR.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                if (((JRadioButton)ie.getItem()).isSelected()) {
                    thisRC.rangeSort = 2;
                }
            }
        });
        alphaR.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                if (((JRadioButton)ie.getItem()).isSelected()) {
                    thisRC.rangeSort = 3;
                }
            }
        });
        switch (this.rangeSort) {
            case 1: {
                firstR.setSelected(true);
                break;
            }
            case 2: {
                lastR.setSelected(true);
                break;
            }
            case 3: {
                alphaR.setSelected(true);
            }
        }
        if (this.speciesPhenonTreeDrawing || this.sideBySideTreeStructure || this.integratedTreeStructure) {
            JPanel treeStructureTypePanel = new JPanel();
            treeStructureTypePanel.setLayout(new BoxLayout(treeStructureTypePanel, 1));
            treeStructureTypePanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 0));
            JRadioButton iR = new JRadioButton(Language.translate("Integrated Tree", true));
            JRadioButton sR = new JRadioButton(Language.translate("Side By Side Tree", true));
            ButtonGroup group2 = new ButtonGroup();
            group2.add(iR);
            group2.add(sR);
            treeStructureTypePanel.add(new JLabel("<html>" + Language.translate("Choose tree structure:", true) + "</html>"));
            treeStructureTypePanel.add(iR);
            treeStructureTypePanel.add(sR);
            this.optionsPanel.add(treeStructureTypePanel);
            sR.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent ie) {
                    if (((JRadioButton)ie.getItem()).isSelected()) {
                        thisRC.sideBySideTreeStructure = true;
                        thisRC.integratedTreeStructure = false;
                        thisRC.speciesPhenonTreeDrawing = false;
                    }
                }
            });
            iR.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent ie) {
                    if (((JRadioButton)ie.getItem()).isSelected()) {
                        thisRC.sideBySideTreeStructure = false;
                        thisRC.integratedTreeStructure = true;
                        thisRC.speciesPhenonTreeDrawing = true;
                    }
                }
            });
            if (this.speciesPhenonTreeDrawing || this.integratedTreeStructure) {
                iR.setSelected(true);
            } else {
                sR.setSelected(true);
            }
        } else {
            this.speciesPhenonTreeDrawing = false;
            this.integratedTreeStructure = false;
            this.sideBySideTreeStructure = false;
        }
        this.optionsPanel.add(new JLabel("<html>" + Language.translate("Branch Settings:", true) + "</html>"));
        final JCheckBox enableAllBranchesButton = new JCheckBox(Language.translate("Show All Branches", true));
        this.optionsPanel.add(enableAllBranchesButton);
        final JCheckBox hideBranchAncestorButton = new JCheckBox(Language.translate("Hide Ancestor Ranges", true));
        this.optionsPanel.add(hideBranchAncestorButton);
        enableAllBranchesButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                if (((JCheckBox)ie.getItem()).isSelected()) {
                    thisRC.enableAllBranches = true;
                    if (hideBranchAncestorButton.isSelected()) {
                        hideBranchAncestorButton.setSelected(false);
                    }
                } else {
                    thisRC.enableAllBranches = false;
                }
            }
        });
        hideBranchAncestorButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                if (((JCheckBox)ie.getItem()).isSelected()) {
                    thisRC.hideBranchAncestors = true;
                    if (enableAllBranchesButton.isSelected()) {
                        enableAllBranchesButton.setSelected(false);
                    }
                } else {
                    thisRC.hideBranchAncestors = false;
                }
            }
        });
        JPanel firstPathPanel = new JPanel();
        BoxLayout firstPathLayout = new BoxLayout(firstPathPanel, 1);
        firstPathPanel.setLayout(firstPathLayout);
        JLabel firstRangeLabel = new JLabel(Language.translate("Input first Range name:", true));
        final JTextField firstRangeText = new JTextField();
        JButton firstPathButton = new JButton(Language.translate("Show evolutionary history", true));
        firstPathPanel.add(firstRangeLabel);
        firstPathPanel.add(firstRangeText);
        firstPathPanel.add(firstPathButton);
        this.optionsPanel.add(firstPathPanel);
        firstPathButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                thisRC.firstRangeName = firstRangeText.getText();
                thisRC.drawFirstRangePath = true;
                thisRC.drawSecondRangePath = false;
                thisRC.drawFirstToSecondRangePath = false;
                thisRC.drawAncestorPath = false;
                if (!thisRC.firstRangeName.equals("")) {
                    Settings cfr_ignored_0 = thisRC.settings;
                    if (Settings.generateAction != null) {
                        enableAllBranchesButton.setSelected(false);
                        hideBranchAncestorButton.setSelected(false);
                        Settings cfr_ignored_1 = thisRC.settings;
                        Settings.generateAction.actionPerformed(null);
                    }
                } else {
                    JOptionPane.showMessageDialog(RangeColumn.this.optionsPanel, "No range name provided. Please input a range name in the text box.");
                }
            }
        });
        JPanel secondPathPanel = new JPanel();
        BoxLayout secondPathLayout = new BoxLayout(secondPathPanel, 1);
        secondPathPanel.setLayout(secondPathLayout);
        JLabel secondRangeLabel = new JLabel(Language.translate("Input second range name:", true));
        final JTextField secondRangeText = new JTextField();
        JButton secondPathButton = new JButton(Language.translate("Show evolutionary history", true));
        secondPathPanel.add(secondRangeLabel);
        secondPathPanel.add(secondRangeText);
        secondPathPanel.add(secondPathButton);
        this.optionsPanel.add(secondPathPanel);
        secondPathButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                thisRC.secondRangeName = secondRangeText.getText();
                thisRC.drawFirstRangePath = false;
                thisRC.drawSecondRangePath = true;
                thisRC.drawFirstToSecondRangePath = false;
                thisRC.drawAncestorPath = false;
                if (!thisRC.secondRangeName.equals("")) {
                    Settings cfr_ignored_0 = thisRC.settings;
                    if (Settings.generateAction != null) {
                        enableAllBranchesButton.setSelected(false);
                        hideBranchAncestorButton.setSelected(false);
                        Settings cfr_ignored_1 = thisRC.settings;
                        Settings.generateAction.actionPerformed(null);
                    }
                } else {
                    JOptionPane.showMessageDialog(RangeColumn.this.optionsPanel, "No range name provided. Please input a range name in the text box.");
                }
            }
        });
        JPanel thirdPathPanel = new JPanel();
        BoxLayout thirdPathLayout = new BoxLayout(thirdPathPanel, 1);
        thirdPathPanel.setLayout(thirdPathLayout);
        JButton thirdPathButton = new JButton(Language.translate("- Path from first to second Range ->", true));
        thirdPathPanel.add(thirdPathButton);
        thirdPathButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                thisRC.firstRangeName = firstRangeText.getText();
                thisRC.secondRangeName = secondRangeText.getText();
                thisRC.drawFirstRangePath = false;
                thisRC.drawSecondRangePath = false;
                thisRC.drawFirstToSecondRangePath = true;
                thisRC.drawAncestorPath = false;
                if (!thisRC.firstRangeName.equals("") && !thisRC.secondRangeName.equals("")) {
                    Settings cfr_ignored_0 = thisRC.settings;
                    if (Settings.generateAction != null) {
                        enableAllBranchesButton.setSelected(false);
                        hideBranchAncestorButton.setSelected(false);
                        Settings cfr_ignored_1 = thisRC.settings;
                        Settings.generateAction.actionPerformed(null);
                    }
                } else {
                    JOptionPane.showMessageDialog(RangeColumn.this.optionsPanel, "Either of the range names is missing. Please input a range name in the text box.");
                }
            }
        });
        JPanel fourthPathPanel = new JPanel();
        BoxLayout fourthPathLayout = new BoxLayout(fourthPathPanel, 1);
        fourthPathPanel.setLayout(fourthPathLayout);
        this.commonAncestorText = new JTextField();
        JButton commonAncestorPathButton = new JButton(Language.translate("Common ancestor of above ranges", true));
        JLabel commonAncestorLabel = new JLabel(Language.translate("Common Ancestor:", true));
        fourthPathPanel.add(commonAncestorPathButton);
        fourthPathPanel.add(commonAncestorLabel);
        fourthPathPanel.add(this.commonAncestorText);
        this.optionsPanel.add(fourthPathPanel);
        commonAncestorPathButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                thisRC.secondRangeName = secondRangeText.getText();
                thisRC.drawFirstRangePath = false;
                thisRC.drawSecondRangePath = false;
                thisRC.drawFirstToSecondRangePath = false;
                thisRC.drawAncestorPath = true;
                if (!thisRC.firstRangeName.equals("") && !thisRC.secondRangeName.equals("")) {
                    Settings cfr_ignored_0 = thisRC.settings;
                    if (Settings.generateAction != null) {
                        enableAllBranchesButton.setSelected(false);
                        hideBranchAncestorButton.setSelected(false);
                        Settings cfr_ignored_1 = thisRC.settings;
                        Settings.generateAction.actionPerformed(null);
                    }
                } else {
                    JOptionPane.showMessageDialog(RangeColumn.this.optionsPanel, "Either of the range names is missing. Please input a range name in the text box.");
                }
            }
        });
        return this.optionsPanel;
    }

    @Override
    public double getWidth(Settings settings, ImageGenerator ig, double dataHeight) {
        System.out.println("PRIORITY CHECK 0: running getWidth");
        Iterator iterParent = this.getDrawingData();
        while (iterParent.hasNext()) {
            RCDatapoint parentP = (RCDatapoint)iterParent.next();
            if (!parentP.label.contains(" <img") || parentP.speciesOrPhenon == null || !parentP.speciesOrPhenon.equalsIgnoreCase("phenon")) continue;
            this.speciesPhenonTreeDrawing = true;
            String parentPointName = parentP.label.split(" <img")[0];
            Iterator iterChild = this.getDrawingData();
            while (iterChild.hasNext()) {
                RCDatapoint childP = (RCDatapoint)iterChild.next();
                if (childP.label.contains(" <img") || !parentPointName.contains(childP.label)) continue;
                childP.speciesOrPhenon = parentP.speciesOrPhenon;
            }
        }
        double totalPadding = 0.0;
        if (!this.findRanges(settings, ig, this.rangeSort)) {
            return 0.0;
        }
        this.findMaxRangeLabelLocations(settings, 0.0, dataHeight, ig);
        this.derivebranchColors();
        this.assignedLocationList = null;
        this.minLocation = this.assignLocationAttributes();
        Iterator iter = this.ranges.iterator();
        Range range = null;
        Range myRange2 = null;
        Object testSWI = null;
        TSCFont rangeLabelFont = new TSCFont("Arial", 1, 12.0, new Color(255, 255, 255));
        TSCFont rangeLabelFontSmall = new TSCFont("Arial", 1, 10.0, new Color(255, 255, 255));
        while (iter.hasNext()) {
            range = (Range)iter.next();
            if (range.branchDisabled || range.subLabel == null) continue;
            range.subLabelSWI = ig.getSWIOneLine(range.subLabel, rangeLabelFont, 1, this.fileInfo);
            if (!(range.subLabelSWI.getWidth() > range.widthSubTree)) continue;
            range.subLabelSWI = ig.getSWIOneLine(range.subLabel, rangeLabelFontSmall, 1, this.fileInfo);
            if (!(range.subLabelSWI.getWidth() > range.widthSubTree)) continue;
            range.width = range.subLabelSWI.getWidth() - (range.widthSubTree - range.width);
        }
        if (this.speciesPhenonTreeDrawing) {
            for (Range rangeSpecies : this.ranges) {
                if (rangeSpecies.phenonsContainingSpecies.size() == 0) continue;
                for (Range rangePhenon : rangeSpecies.phenonsContainingSpecies) {
                    rangeSpecies.width += rangePhenon.width;
                }
                if (rangeSpecies.phenonsContainingSpecies.size() < 1) continue;
                rangeSpecies.width += 120.0;
            }
        }
        this.myWidth = 2.0;
        iter = this.ranges.iterator();
        range = null;
        if (ConserveSpace) {
            double minTop = 0.0;
            double maxBase = 0.0;
            block5: for (int i = 0; i < this.ranges.size(); ++i) {
                int j = i * -1;
                for (Range myRange2 : this.ranges) {
                    if (j != myRange2.location) continue;
                    double a2 = (myRange2.base - settings.topAge) * settings.unitsPerMY + 86.4931640625;
                    double b2 = (myRange2.top - settings.topAge) * settings.unitsPerMY + 86.4931640625;
                    double currentHeight = 0.0;
                    currentHeight = b2 < a2 - myRange2.nameHeight ? b2 : a2 - myRange2.nameHeight;
                    if (myRange2.branchDisabled || myRange2.disabled4Priority || !(myRange2.base > settings.topAge) || Double.isNaN(myRange2.base) || !(myRange2.top < settings.baseAge) || Double.isNaN(myRange2.top)) continue block5;
                    if (minTop == 0.0 && maxBase == 0.0) {
                        if (this.speciesPhenonTreeDrawing) {
                            if (!myRange2.isPhenonRange) {
                                this.myWidth += myRange2.getWidth() + this.RangeColumnWidthPadding + this.BranchSpacing;
                            }
                        } else {
                            this.myWidth += myRange2.getWidth() + this.RangeColumnWidthPadding + this.BranchSpacing;
                        }
                        totalPadding += 2.0;
                        minTop = currentHeight;
                        maxBase = a2;
                        continue block5;
                    }
                    if (minTop > a2) {
                        minTop = currentHeight;
                        continue block5;
                    }
                    if (currentHeight > maxBase) {
                        maxBase = a2;
                        continue block5;
                    }
                    if (this.speciesPhenonTreeDrawing) {
                        if (!myRange2.isPhenonRange) {
                            this.myWidth += myRange2.getWidth() + this.RangeColumnWidthPadding + this.BranchSpacing;
                        }
                    } else {
                        this.myWidth += myRange2.getWidth() + this.RangeColumnWidthPadding + this.BranchSpacing;
                    }
                    totalPadding += 2.0;
                    minTop = currentHeight;
                    maxBase = a2;
                    continue block5;
                }
            }
        } else {
            while (iter.hasNext()) {
                range = (Range)iter.next();
                if (range.branchDisabled || range.disabled4Priority || !(range.base > settings.topAge) || Double.isNaN(range.base) || !(range.top < settings.baseAge) || Double.isNaN(range.top)) continue;
                if (this.speciesPhenonTreeDrawing) {
                    if (!range.isPhenonRange) {
                        this.myWidth += range.getWidth() + this.RangeColumnWidthPadding + this.BranchSpacing;
                    }
                } else {
                    this.myWidth += range.getWidth() + this.RangeColumnWidthPadding + this.BranchSpacing;
                }
                if (-1.0 * range.getLineX() > 1.0) {
                    this.myWidth += -1.0 * range.getLineX();
                }
                totalPadding += 2.0;
            }
        }
        this.myWidth += this.MINIMUM_PADDING * 0.5;
        if (this.myWidth < 50.0) {
            this.myWidth = 50.0;
        }
        this.myWidth += 4.0;
        return this.myWidth;
    }

    protected void findMaxRangeLabelLocations(Settings settings, double starty, double height, ImageGenerator ig) {
        this.maxRangeLabelHeaderHeight = 0.0;
        Iterator iter = this.ranges.iterator();
        int rangeCount = 0;
        while (iter.hasNext()) {
            Range r = (Range)iter.next();
            StringWrappingInfo testLabelSWI = null;
            testLabelSWI = r.isPhenonRange ? ig.getSWIOneLine(r.name, this.fonts.getFont(9), 4, this.fileInfo) : ig.getSWIOneLine(r.name, this.fonts.getFont(14), 4, this.fileInfo);
            double labelHeight = 3.0 + testLabelSWI.getHeight() + 3.0;
            for (int locI = 0; locI < this.labelLocSearchOrder.length; ++locI) {
                if (this.labelLocSearchOrder[locI] == LabelLocation.TOP) {
                    double rangeTop = ImageGenerator.getYFromYear(r.top, starty, settings);
                    if (!(rangeTop - labelHeight > starty)) continue;
                    r.labelloc = LabelLocation.TOP;
                    break;
                }
                if (this.labelLocSearchOrder[locI] == LabelLocation.BOTTOM) {
                    double rangeBottom = ImageGenerator.getYFromYear(r.base, starty, settings);
                    if (!(rangeBottom + labelHeight < starty + height)) continue;
                    r.labelloc = LabelLocation.BOTTOM;
                    break;
                }
                if (this.labelLocSearchOrder[locI] == LabelLocation.LEFT_SIDE) {
                    if (labelHeight >= height) {
                        r.labelloc = LabelLocation.RESIZE;
                        break;
                    }
                    r.labelloc = LabelLocation.LEFT_SIDE;
                    break;
                }
                if (this.labelLocSearchOrder[locI] == LabelLocation.RIGHT_SIDE) {
                    if (labelHeight >= height) {
                        r.labelloc = LabelLocation.RESIZE;
                        break;
                    }
                    r.labelloc = LabelLocation.RIGHT_SIDE;
                    break;
                }
                this.maxRangeLabelHeaderHeight = Math.max(this.maxRangeLabelHeaderHeight, testLabelSWI.getHeight());
                r.labelloc = LabelLocation.HEADER;
                this.drawLabelsInHeader = true;
                break;
            }
            r.calculateWidth(ig);
            this.TOTAL_RANGE_WIDTH += r.width;
            ++rangeCount;
        }
    }

    protected void findMaxRangeLabelHeight(ImageGenerator ig) {
        this.maxRangeLabelHeaderHeight = 0.0;
        Iterator iter = this.ranges.iterator();
        int rangeCount = 0;
        while (iter.hasNext()) {
            Range r = (Range)iter.next();
            StringWrappingInfo testLabelSWI = null;
            testLabelSWI = r.isPhenonRange ? ig.getSWIOneLine(r.name, this.fonts.getFont(9), 4, this.fileInfo) : ig.getSWIOneLine(r.name, this.fonts.getFont(14), 4, this.fileInfo);
            this.maxRangeLabelHeaderHeight = Math.max(this.maxRangeLabelHeaderHeight, testLabelSWI.getHeight());
            ++rangeCount;
        }
    }

    @Override
    public double getHeaderHeight(Settings settings, ImageGenerator ig) {
        super.getHeaderHeight(settings, ig);
        if (this.maxRangeLabelHeaderHeight > 0.0) {
            this.myOwnHeaderHeight += this.maxRangeLabelHeaderHeight + 1.0 + 3.0;
        }
        this.myHeaderHeight = this.myOwnHeaderHeight;
        return this.myHeaderHeight;
    }

    @Override
    public void drawHeader(ImageGenerator ig, double startx, double starty, double width, double height, Settings settings) {
        System.out.println("PRIORITY CHECK 0: running drawHeader");
        if (this.myWidth < 0.0) {
            this.myWidth = this.getWidth(settings, ig, height);
        }
        if (this.myHeaderHeight < 0.0) {
            this.myHeaderHeight = this.getHeaderHeight(settings, ig);
        }
        ig.linkProc = this.fileInfo != null ? new LinkProcessor(this.fileInfo) : null;
        if (this.name.length() > 0 && this.drawTitle) {
            StringWrappingInfo myWrap = this.nameWrap;
            TSCFont myWrapHolder = this.fonts.getFont(0);
            double wrapSize = Math.floor(myWrapHolder.getSize());
            double myLayer = myWrap.getWidth() * (double)myWrap.getNumLines();
            double myThreshold = this.myWidth * 2.0;
            double wrapSize2 = wrapSize;
            String myString = this.name;
            String[] split = myString.split("(\\s)+");
            int myLength = 0;
            AffineTransform affinetransform = new AffineTransform();
            FontRenderContext frc = new FontRenderContext(affinetransform, true, true);
            Font font = new Font("Arial", 0, 14);
            int marker = 0;
            for (int x = 0; x < split.length; ++x) {
                int textwidth = (int)font.getStringBounds(split[x], frc).getWidth();
                if (textwidth <= myLength) continue;
                myLength = textwidth;
                marker = x;
            }
            if (myWrap.getNumLines() > 2 || (double)myLength >= this.nameWrap.getWidth()) {
                while (wrapSize > 6.0 && (myWrap.getNumLines() > 2 || (double)myLength >= this.nameWrap.getWidth())) {
                    myWrapHolder.setSize(wrapSize);
                    myWrap = ig.wrapString(this.name, this.myWidth, myWrapHolder, this.fileInfo);
                    myLayer = myWrap.getWidth() * (double)myWrap.getNumLines();
                    font = new Font("Arial", 0, (int)wrapSize);
                    myLength = (int)font.getStringBounds(split[marker], frc).getWidth();
                    wrapSize -= 1.0;
                }
            }
            ig.drawString(myWrap, startx, starty - 10.0, width, height - this.maxRangeLabelHeaderHeight - 3.0 - 1.0, 3);
            wrapSize = wrapSize2;
            myWrapHolder.setSize(wrapSize);
        }
        Iterator iter = this.ranges.iterator();
        double rangeStart = 2.0;
        while (iter.hasNext()) {
            Range r = (Range)iter.next();
            if (r.labelloc == LabelLocation.HEADER) {
                ig.drawString(r.nameSWI, startx + rangeStart, starty + height - 1.0 - this.maxRangeLabelHeaderHeight, r.getWidth(), this.maxRangeLabelHeaderHeight, 3);
                if (r.popup != null && settings.doPopups) {
                    ig.pushGrouping();
                    ig.doPopupThings(r.popup, this.fileInfo);
                    ig.drawRect(startx + rangeStart, starty + height - 1.0 - this.maxRangeLabelHeaderHeight, r.getWidth(), this.maxRangeLabelHeaderHeight, "stroke-width: 0; opacity: 0.5; fill: red;");
                    ig.popGrouping();
                }
            }
            rangeStart += r.getWidth() + 2.0;
        }
        if (this.popup != null && settings.doPopups) {
            ig.pushGrouping();
            ig.doPopupThings(this.popup, this.fileInfo);
            ig.drawRect(startx, starty, width, height, "stroke-width: 0; opacity: 0.5; fill: red;");
            ig.popGrouping();
        }
    }

    public static RangeStyle getRangeStyle(String type) {
        if (type.compareToIgnoreCase("sample") == 0) {
            return style_sample;
        }
        if (type.compareToIgnoreCase("missing") == 0) {
            return style_missing;
        }
        if (type.compareToIgnoreCase("rare") == 0) {
            return style_rare;
        }
        if (type.compareToIgnoreCase("conjectured") == 0) {
            return style_conjectured;
        }
        if (type.compareToIgnoreCase("common") == 0) {
            return style_common;
        }
        if (type.compareToIgnoreCase("frequent") == 0) {
            return style_frequent;
        }
        if (type.compareToIgnoreCase("abundant") == 0) {
            return style_abundant;
        }
        if (type.compareToIgnoreCase("flood") == 0) {
            return style_flood;
        }
        return style_frequent;
    }

    public boolean findSpecificRanges(Settings settings, boolean forPhenonRange, boolean choosePhenonRangeSet) {
        ArrayList<Range> ScratchRanges = new ArrayList<Range>();
        ArrayList<RangePoint> endpoints = new ArrayList<RangePoint>(this.data.size());
        this.getEndPoints(endpoints);
        boolean tmpIsPhenonRange = false;
        String tmpSpeciesNameWithFinalTop = null;
        Iterator iter = endpoints.iterator();
        boolean count = false;
        while (iter.hasNext()) {
            RangePoint rp = (RangePoint)iter.next();
            if (this.enableAllBranches || !this.enableAllBranches && !this.hideBranchAncestors && !rp.rcd.branchClicked) {
                System.out.println("PRIORITY CHECK: calling rp.setResetIncludeBranch!! enableAllBranches = " + this.enableAllBranches + ", hideBranchAncestors = " + this.hideBranchAncestors + ", rp.rcd.branchClicked = " + rp.rcd.branchClicked);
                rp.setResetIncludeBranch(false);
                if (rp.rcd.branchClicked) {
                    rp.rcd.branchClicked = false;
                }
            }
            if (!forPhenonRange && rp.rcd.speciesOrPhenon != null && rp.rcd.speciesOrPhenon.equals("phenon") || forPhenonRange && rp.rcd.speciesOrPhenon != null && !rp.rcd.speciesOrPhenon.equals("phenon") || forPhenonRange && rp.rcd.speciesOrPhenon == null || rp.used) continue;
            for (Range match : ScratchRanges) {
                if (!rp.name.split(" <img")[0].equalsIgnoreCase(match.name.split(" <img")[0])) {
                    if (rp.rcd.speciesOrPhenon == null || !rp.rcd.speciesOrPhenon.equals("phenon") || rp.rcd.speciesWithFinalTopOfPhenon == null) continue;
                    tmpIsPhenonRange = true;
                    tmpSpeciesNameWithFinalTop = rp.rcd.speciesWithFinalTopOfPhenon;
                    continue;
                }
                rp.used = true;
                if (rp.rcd.speciesOrPhenon != null && rp.rcd.speciesOrPhenon.equals("phenon")) {
                    if (rp.rcd.speciesWithFinalTopOfPhenon != null) {
                        match.isPhenonRange = true;
                        match.speciesNameWithFinalTop = rp.rcd.speciesWithFinalTopOfPhenon;
                        if (choosePhenonRangeSet) {
                            match.top = rp.age;
                        }
                    } else if (choosePhenonRangeSet && rp.age > match.base) {
                        match.base = rp.age;
                    }
                }
                if (!choosePhenonRangeSet) {
                    match.addPoint(rp);
                }
                match.branchDisabled = rp.rcd.notInclude;
                if (match.name.length() < rp.name.length()) {
                    match.name = rp.name;
                }
                if (rp.popup == null) continue;
                if (rp.rcd.branch) {
                    match.branchInfoTemp = match.branchInfoTemp + "<br><br><b>Branch Info. of " + rp.rcd.branchTo + ": </b>" + rp.popup;
                    continue;
                }
                match.popup = match.popup + "<br><br>" + rp.popup;
            }
            if (rp.used) continue;
            Range range = new Range();
            range.name = rp.name;
            if (rp.popup != null) {
                if (rp.rcd.branch) {
                    range.branchInfoTemp = range.branchInfoTemp + "<br><br><b>Branch Info. of " + rp.rcd.branchTo + ": </b>" + rp.popup;
                } else {
                    range.popup = rp.popup;
                }
            }
            rp.used = true;
            if (!choosePhenonRangeSet) {
                range.addPoint(rp);
            } else if (Double.isNaN(range.base)) {
                range.base = rp.age;
            }
            ScratchRanges.add(range);
        }
        for (Range r : ScratchRanges) {
            for (RangePoint rp : r.points) {
                if (rp.rcd.speciesOrPhenon == null || !rp.rcd.speciesOrPhenon.equals("phenon") || rp.rcd.speciesWithFinalTopOfPhenon == null) continue;
                r.isPhenonRange = true;
                r.speciesNameWithFinalTop = rp.rcd.speciesWithFinalTopOfPhenon;
            }
            if (r.flaggingBranchAboveErr) {
                for (Range.CriticalErrors error : r.flaggingBranchAboveMsg) {
                    consolidatedPlottingErrs = consolidatedPlottingErrs + "Range " + error.range + " has branch node at " + error.age + " Ma to " + error.branchTo + " above top age " + r.base + " Ma.\n";
                }
            }
            if (r.flaggingBranchBelowErr) {
                for (Range.CriticalErrors error : r.flaggingBranchBelowMsg) {
                    consolidatedPlottingErrs = consolidatedPlottingErrs + "Range " + error.range + " has branch node at " + error.age + " Ma to " + error.branchTo + " below base age " + r.base + " Ma.\n";
                }
            }
            if (choosePhenonRangeSet) {
                this.phenonRanges.add(r);
                continue;
            }
            this.ranges.add(r);
        }
        return true;
    }

    public boolean findRanges(Settings settings, ImageGenerator ig, int sortBy) {
        System.out.println("PRIORITY CHECK 0: running findRanges");
        Set tmpSavedExtendedRanges = null;
        this.ranges = Collections.synchronizedSortedSet(new TreeSet(new RangeComparator(sortBy)));
        this.rangesWithoutSplit = Collections.synchronizedSortedSet(new TreeSet(new RangeComparator(sortBy)));
        this.phenonRanges = Collections.synchronizedSortedSet(new TreeSet(new RangeComparator(sortBy)));
        this.extendedRanges = Collections.synchronizedSortedSet(new TreeSet(new RangeComparator(sortBy)));
        if (!this.findSpecificRanges(settings, false, false)) {
            return false;
        }
        this.linkRangeSets(false);
        if (this.speciesPhenonTreeDrawing) {
            this.extendRangeSets(settings);
            if (!this.findSpecificRanges(settings, true, false)) {
                return false;
            }
        }
        if (this.sideBySideTreeStructure) {
            this.speciesPhenonTreeDrawing = false;
            speciesBoxBranchClicked = false;
        } else if (this.speciesPhenonTreeDrawing) {
            this.integratedTreeStructure = true;
            this.speciesPhenonTreeDrawing = true;
        }
        if (this.speciesPhenonTreeDrawing) {
            this.rangesWithoutSplit = this.ranges;
            this.ranges = this.extendedRanges;
            this.linkRangeSets(true);
        } else {
            this.linkRangeSets(true);
            this.rangesWithoutSplit = this.ranges;
        }
        this.T = new EvTree();
        this.tree = new EvTree.TreeNode(this.T);
        Iterator itrr = this.ranges.iterator();
        Range firstR = null;
        while (itrr.hasNext()) {
            Range r = (Range)itrr.next();
            if (firstR == null) {
                firstR = r;
            }
            r.alreadyInsideTree = false;
        }
        this.tree = this.T.createTreeFromRanges(this.tree, null, firstR);
        if (this.speciesPhenonTreeDrawing) {
            for (Range r : this.extendedRanges) {
                if (r.isPhenonRange) continue;
                for (Range phenonRange : r.phenonsContainingSpecies) {
                    phenonRange.containedBySpeciesRange = r;
                }
            }
        }
        if (this.speciesPhenonTreeDrawing && speciesBoxBranchClicked && tmpSavedExtendedRanges != null && tmpSavedExtendedRanges.size() > 0) {
            speciesBoxBranchClicked = false;
            for (Range phenonRange : tmpSavedExtendedRanges) {
                if (!phenonRange.isPhenonRange) continue;
                for (Range r : this.extendedRanges) {
                    if (!phenonRange.name.equalsIgnoreCase(r.name) || phenonRange.top != r.top || phenonRange.base != r.base) continue;
                    r.branchDisabled = phenonRange.branchDisabled;
                    r.speciesBoxBranchIsVisible = phenonRange.speciesBoxBranchIsVisible;
                }
            }
        }
        if (this.extendedRanges != null && this.extendedRanges.size() > 0 && this.speciesPhenonTreeDrawing) {
            for (Range r : this.extendedRanges) {
                if (!r.isPhenonRange || !r.containedBySpeciesRange.branchDisabled) continue;
                this.phenonRangeStateMap.put(r, r.branchDisabled);
                r.branchDisabled = true;
            }
        }
        if (!consolidatedPlottingErrs.equals("")) {
            consolidatedPlottingErrs = "Could not proceed to Family Tree Plotting. Following errors present in datafile.\n" + consolidatedPlottingErrs + "\nIf a range has age NaN(Infinity) understand that its regular range points are not defined. The most common reason for this could be incorrect spelling between range & branch points\n";
            return false;
        }
        return true;
    }

    public void drawAgeLabelForRangePoint(ImageGenerator ig, Range range, RangePoint p, double rangeX, double startx, double starty, double height, Settings settings) {
        StringWrappingInfo swi = range.getAgeLabelSWI(p);
        double ageWidth = swi.getWidth();
        double ageHeight = swi.getHeight();
        double ageY = ImageGenerator.getYFromYear(p.age, starty, settings);
        if ((ageY -= ageHeight / 2.0) < starty) {
            ageY = starty;
        }
        if (ageY + ageHeight > starty + height) {
            ageY = starty + height - ageHeight;
        }
        if (range.labelloc == LabelLocation.LEFT_SIDE) {
            ig.drawString(swi, rangeX + AGE_LABEL_X_PADDING - range.getAgeLabelRightX() - ageWidth / 2.5, ageY - AGE_LABEL_Y_PADDING, ageWidth, ageHeight, 2);
        } else {
            ig.drawString(swi, rangeX - AGE_LABEL_X_PADDING + range.getAgeLabelRightX() + ageWidth, ageY - AGE_LABEL_Y_PADDING, ageWidth, ageHeight, 2);
        }
    }

    @Override
    public void drawData(ImageGenerator ig, double startx, double starty, double width, double height, Settings settings) {
        System.out.println("PRIORITY CHECK 0: running drawData");
        super.drawData(ig, startx, starty, width, height, settings);
        int tempRangeLocation = 0;
        Range range2 = null;
        Range rangeInRanges = null;
        double maxRangeX = 0.0;
        double myLineShift = 0.0;
        double overlapShift = 0.0;
        double rangeStart = startx + 2.0;
        double prevWidth = 0.0;
        double prevX = 0.0;
        double currentHeight = 0.0;
        double minTop = 0.0;
        double maxBase = 0.0;
        boolean isTop = false;
        Iterator iter = null;
        ArrayList blackListedRangesForPhenonRangeDrawing = new ArrayList();
        boolean nextHorizontalTopLineDrawing = true;
        Range prevSpeciesRange = null;
        Range prevPhenonRange = null;
        HashMap<String, Integer> phenonCountForCurrentRange = new HashMap<String, Integer>();
        HashMap<String, Integer> totalEnabledPhenonForCurrentRange = new HashMap<String, Integer>();
        String prevRangeName = null;
        for (Range speciesRange : this.extendedRanges) {
            if (speciesRange.isPhenonRange) continue;
            phenonCountForCurrentRange.put(speciesRange.name.split(" <img")[0], 0);
            int totalEnabledPhenon = 0;
            for (Range r : speciesRange.phenonsContainingSpecies) {
                if (r.branchDisabled) continue;
                ++totalEnabledPhenon;
            }
            totalEnabledPhenonForCurrentRange.put(speciesRange.name.split(" <img")[0], totalEnabledPhenon);
        }
        while (true) {
            double rangeX = 0.0;
            double lineX = 0.0;
            double myWidth = 0.0;
            double maxWidth = 0.0;
            ArrayList<Range> rangesCurrLocation = null;
            if (tempRangeLocation < this.minLocation) break;
            iter = this.speciesPhenonTreeDrawing ? this.extendedRanges.iterator() : (this.rangesWithoutSplit != null ? this.rangesWithoutSplit.iterator() : this.ranges.iterator());
            boolean count = false;
            while (iter.hasNext()) {
                rangeInRanges = (Range)iter.next();
                if (!(tempRangeLocation == rangeInRanges.location & !rangeInRanges.branchDisabled) || rangeInRanges.disabled4Priority) continue;
                lineX = rangeInRanges.getLineX();
                myWidth = rangeInRanges.getWidth();
                if (rangesCurrLocation == null) {
                    rangesCurrLocation = new ArrayList<Range>();
                }
                rangesCurrLocation.add(rangeInRanges);
                if (rangeX < rangeStart + lineX) {
                    rangeX = rangeStart + lineX;
                    myLineShift = 0.0;
                }
                if (!(myWidth > maxWidth) || rangeInRanges.base < settings.topAge + 1.0E-6 && !Double.isNaN(rangeInRanges.base) || rangeInRanges.branchBase < settings.topAge + 1.0E-6 && !Double.isNaN(rangeInRanges.branchBase) || rangeInRanges.top > settings.baseAge - 1.0E-6 && !Double.isNaN(rangeInRanges.top) || rangeInRanges.branchTop > settings.baseAge - 1.0E-6 && !Double.isNaN(rangeInRanges.branchTop)) continue;
                maxWidth = myWidth;
            }
            --tempRangeLocation;
            if (rangesCurrLocation == null) continue;
            Iterator iterRangeCurrLocation = null;
            for (Range range2 : rangesCurrLocation) {
                double curTopAge = settings.topAge;
                boolean nextIsTop = true;
                Iterator pointIter = range2.points.iterator();
                RCDatapoint lastUsedRCD = null;
                if (!range2.isPhenonRange && this.speciesPhenonTreeDrawing) {
                    rangeX += range2.nameWidth;
                }
                prevPhenonRange = null;
                double myTopHeight = this.getHeightTop(range2, starty, height, settings) - RANGE_LABEL_Y_PADDING;
                double myBaseHeight = myTopHeight + range2.nameHeight;
                RangePoint bp = (RangePoint)range2.points.first();
                isTop = true;
                while (pointIter.hasNext()) {
                    RangePoint p = (RangePoint)pointIter.next();
                    if ((p.rcd.branch || p.rcd.notInclude) && (p.rcd.type == null || !p.rcd.type.equalsIgnoreCase("TOP") && !p.rcd.type.equalsIgnoreCase("common") && !p.rcd.type.equalsIgnoreCase("frequent") && !p.rcd.type.equalsIgnoreCase("flood") && !p.rcd.type.equalsIgnoreCase("abundant"))) continue;
                    lastUsedRCD = p.rcd;
                    if (p.type.compareToIgnoreCase("sample") == 0) {
                        if (p.age > settings.baseAge || p.age < settings.topAge) continue;
                        ig.drawCircle(rangeX, ImageGenerator.getYFromYear(p.age, starty, settings), 3.0, "fill: black;");
                        continue;
                    }
                    if (nextIsTop) {
                        nextIsTop = false;
                        if (!(p.age > curTopAge)) continue;
                        curTopAge = p.age;
                        continue;
                    }
                    double base = p.age;
                    if (base < settings.topAge) continue;
                    if (base > settings.baseAge) {
                        base = settings.baseAge;
                    }
                    RangeStyle style = RangeColumn.getRangeStyle(p.type);
                    if (p.rcd != null && p.rcd.type != null && p.rcd.type.compareToIgnoreCase("sample") == 0) {
                        style.style = " stroke: " + range2.branchColor + ";";
                        style.width = 1.0;
                        AGE_LABEL_X_PADDING = 6.0;
                    } else if (p.rcd != null && p.rcd.type != null && p.rcd.type.compareToIgnoreCase("missing") == 0) {
                        style.style = "";
                        style.width = 0.0;
                        AGE_LABEL_X_PADDING = 3.5;
                    } else if (p.rcd != null && p.rcd.type != null && p.rcd.type.compareToIgnoreCase("rare") == 0) {
                        style.style = "stroke-dasharray:7,4; stroke: " + range2.branchColor + ";";
                        style.width = 0.5;
                        AGE_LABEL_X_PADDING = 4.0;
                    } else if (p.rcd != null && p.rcd.type != null && p.rcd.type.compareToIgnoreCase("conjectured") == 0) {
                        style.style = "stroke-dasharray:2,2; stroke: " + range2.branchColor + ";";
                        style.width = 0.5;
                        AGE_LABEL_X_PADDING = 4.0;
                    } else if (p.rcd != null && p.rcd.type != null && p.rcd.type.compareToIgnoreCase("common") == 0) {
                        style.style = " stroke: " + range2.branchColor + ";";
                        style.width = 0.75;
                        AGE_LABEL_X_PADDING = 6.0;
                    } else if (p.rcd != null && p.rcd.type != null && p.rcd.type.compareToIgnoreCase("frequent") == 0) {
                        style.style = " stroke: " + range2.branchColor + ";";
                        style.width = 1.5;
                        AGE_LABEL_X_PADDING = 7.0;
                    } else if (p.rcd != null && p.rcd.type != null && p.rcd.type.compareToIgnoreCase("abundant") == 0) {
                        style.style = " stroke: " + range2.branchColor + ";";
                        style.width = 3.0;
                        AGE_LABEL_X_PADDING = 8.0;
                    } else if (p.rcd != null && p.rcd.type != null && p.rcd.type.compareToIgnoreCase("flood") == 0) {
                        style.style = " stroke: " + range2.branchColor + ";";
                        style.width = 6.0;
                        AGE_LABEL_X_PADDING = 9.0;
                    } else {
                        style.style = " stroke: " + range2.branchColor + ";";
                        style.width = 0.75;
                    }
                    if (this.sideBySideTreeStructure) {
                        this.speciesPhenonTreeDrawing = false;
                        this.integratedTreeStructure = false;
                    } else if (this.integratedTreeStructure) {
                        this.speciesPhenonTreeDrawing = true;
                        this.integratedTreeStructure = true;
                    }
                    if (range2.name != prevRangeName) {
                        rangeX += 30.0;
                    }
                    if (!range2.isPhenonRange && this.integratedTreeStructure) {
                        double rectWidth;
                        prevRangeName = range2.name;
                        Iterator<Range> iterPhenonCounter = range2.phenonsContainingSpecies.iterator();
                        int totalPhenon = range2.phenonsContainingSpecies.size();
                        int enabledPhenonCounter = 0;
                        while (iterPhenonCounter.hasNext()) {
                            Range pR = iterPhenonCounter.next();
                            if (pR.branchDisabled) continue;
                            ++enabledPhenonCounter;
                        }
                        double rangeXForOtherSide = rangeX + range2.width - range2.nameWidth - 50.0;
                        double tmpRectWidth = rectWidth = rangeXForOtherSide - rangeX;
                        if (enabledPhenonCounter == 0 && totalPhenon != 0) {
                            rectWidth /= (double)totalPhenon;
                        } else if (totalPhenon != enabledPhenonCounter) {
                            rectWidth = rectWidth / (double)totalPhenon * (double)enabledPhenonCounter;
                        }
                        String styleStr = style.getStyle();
                        String fillColor = styleStr.substring(styleStr.indexOf("rgb"), styleStr.length());
                        String rectStyle = styleStr + " fill: " + fillColor + " opacity: 0.2;";
                        ig.drawRectYear(rangeX, curTopAge, rectWidth, base - curTopAge, rectStyle, starty);
                        range2.rangeWidth = rectWidth;
                        int strokeWidthIdx = styleStr.indexOf("stroke-width");
                        String beforeStrokeWidth = styleStr.substring(0, strokeWidthIdx);
                        String fromStrokeWidthStr = styleStr.substring(strokeWidthIdx, styleStr.length());
                        int firstSemiColonAfterStrokeWidthIdx = fromStrokeWidthStr.indexOf(";");
                        String afterStrokeWidth = styleStr.substring(strokeWidthIdx + firstSemiColonAfterStrokeWidthIdx + 1, styleStr.length());
                        String lineStyle = beforeStrokeWidth + "stroke-width: " + style.getWidth() + ";" + afterStrokeWidth;
                        ig.drawLineYear(rangeX, base, rangeX, curTopAge, lineStyle, starty);
                        double newRangeXForOtherSide = rangeXForOtherSide - (tmpRectWidth - rectWidth);
                        ig.drawLineYear(newRangeXForOtherSide, base, newRangeXForOtherSide, curTopAge, lineStyle, starty);
                        range2.rangeWidth = newRangeXForOtherSide - rangeX;
                        if (nextHorizontalTopLineDrawing) {
                            ig.drawLineYear(rangeX, curTopAge, newRangeXForOtherSide, curTopAge, lineStyle, starty);
                        } else {
                            nextHorizontalTopLineDrawing = true;
                        }
                        if (range2.base != p.age && (p.rcd.type.compareToIgnoreCase("sample") == 0 || p.rcd.type.compareToIgnoreCase("missing") == 0 || p.rcd.type.compareToIgnoreCase("rare") == 0 || p.rcd.type.compareToIgnoreCase("conjectured") == 0 || p.rcd.type.compareToIgnoreCase("abundant") == 0 || p.rcd.type.compareToIgnoreCase("flood") == 0)) {
                            nextHorizontalTopLineDrawing = false;
                        }
                        ig.drawLineYear(rangeX, base, newRangeXForOtherSide, base, lineStyle, starty);
                        if (rangeX > maxRangeX) {
                            maxRangeX = rangeX;
                        }
                        if (this.drawAgeLabel) {
                            String bpS = Double.toString(bp.age);
                            String beforeDecimal = bpS.split("\\.")[0];
                            int bpL = beforeDecimal.length() + 2;
                            String pS = Double.toString(p.age);
                            beforeDecimal = pS.split("\\.")[0];
                            int pL = beforeDecimal.length() + 2;
                            int pd = Math.abs(bpL - pL);
                            double fontSize = Math.floor(this.fonts.getFont(1).getSize());
                            boolean fPd = false;
                            if (pd > 0) {
                                fPd = true;
                            }
                            if (range2.baseSymbol != 4) {
                                this.drawAgeLabelForRangePoint(ig, range2, p, rangeX - this.RangeColumnRangeAgeLabelPadding, startx, starty, height, settings);
                            }
                            if (bp != null && bp.rcd != null && bp.rcd.type != null && bp.rcd.type.equals("TOP") && range2.topSymbol != 3 && bp.age != 0.0) {
                                this.drawAgeLabelForRangePoint(ig, range2, bp, rangeX - this.RangeColumnRangeAgeLabelPadding + (double)(pd * 2) + (double)fPd * ((fontSize - 6.0) / 3.0), startx, starty, height, settings);
                            }
                        }
                    } else if (range2.isPhenonRange && this.integratedTreeStructure && !range2.branchDisabled) {
                        prevRangeName = range2.name;
                        for (Range speciesRange : this.ranges) {
                            if (speciesRange.isPhenonRange) continue;
                            for (String usedSpeciesRangeName : blackListedRangesForPhenonRangeDrawing) {
                                if (!usedSpeciesRangeName.equals(speciesRange.name.split(" <img")[0])) continue;
                            }
                            for (Range phenonRange : speciesRange.phenonsContainingSpecies) {
                                String rName = range2.name.split(" <img")[0];
                                String speciesRangeName = speciesRange.name.split(" <img")[0];
                                String phenonRangeName = phenonRange.name.split(" <img")[0];
                                if (!rName.equals(phenonRangeName) || phenonRange.base != range2.base || phenonRange.top != range2.top) continue;
                                if (prevPhenonRange == null || range2.base != prevPhenonRange.base && range2.top != prevPhenonRange.top) {
                                    Iterator<Range> iterPhenonCounter = speciesRange.phenonsContainingSpecies.iterator();
                                    int totalPhenon = speciesRange.phenonsContainingSpecies.size();
                                    int enabledPhenonCounter = 0;
                                    while (iterPhenonCounter.hasNext()) {
                                        Range pR = iterPhenonCounter.next();
                                        if (pR.branchDisabled) continue;
                                        ++enabledPhenonCounter;
                                    }
                                    double speciesRangeWidth = speciesRange.width * 0.92 - speciesRange.nameWidth - 50.0;
                                    if (enabledPhenonCounter == 0 && totalPhenon != 0) {
                                        speciesRangeWidth /= (double)totalPhenon;
                                    } else if (totalPhenon != enabledPhenonCounter) {
                                        speciesRangeWidth = speciesRangeWidth / (double)totalPhenon * (double)enabledPhenonCounter;
                                    }
                                    int tmpTotalEnabledPhenon = (Integer)totalEnabledPhenonForCurrentRange.get(speciesRangeName);
                                    double unitWidth = speciesRangeWidth / ((double)tmpTotalEnabledPhenon * 1.2);
                                    rangeX = speciesRange.rangeXCanvas + speciesRangeWidth / 2.0;
                                    int nthPhenon = (Integer)phenonCountForCurrentRange.get(speciesRangeName) + 1;
                                    phenonCountForCurrentRange.put(speciesRangeName, nthPhenon);
                                    if (tmpTotalEnabledPhenon % 2 == 0) {
                                        rangeX = nthPhenon <= tmpTotalEnabledPhenon ? rangeX - (double)(tmpTotalEnabledPhenon / 2 - nthPhenon) * speciesRangeWidth / (double)tmpTotalEnabledPhenon - speciesRangeWidth / (double)(2 * tmpTotalEnabledPhenon) : rangeX - (double)(nthPhenon - tmpTotalEnabledPhenon / 2 - 1) * speciesRangeWidth / (double)tmpTotalEnabledPhenon + speciesRangeWidth / (double)(2 * tmpTotalEnabledPhenon);
                                    } else if ((double)nthPhenon != Math.ceil((double)tmpTotalEnabledPhenon / 2.0)) {
                                        rangeX = nthPhenon <= tmpTotalEnabledPhenon / 2 ? (rangeX -= (double)(tmpTotalEnabledPhenon / 2 - nthPhenon + 1) * speciesRangeWidth / (double)tmpTotalEnabledPhenon) : (rangeX += (double)(nthPhenon - tmpTotalEnabledPhenon / 2 - 1) * speciesRangeWidth / (double)tmpTotalEnabledPhenon);
                                    }
                                    prevPhenonRange = range2;
                                    prevPhenonRange.rangeXCanvas = rangeX;
                                }
                                if (prevSpeciesRange != null) continue;
                                prevSpeciesRange = new Range(speciesRange);
                            }
                        }
                        String styleStr = style.getStyle();
                        int strokeWidthIdx = styleStr.indexOf("stroke-width");
                        String beforeStrokeWidth = styleStr.substring(0, strokeWidthIdx);
                        String fromStrokeWidthStr = styleStr.substring(strokeWidthIdx, styleStr.length());
                        int firstSemiColonAfterStrokeWidthIdx = fromStrokeWidthStr.indexOf(";");
                        String afterStrokeWidth = styleStr.substring(strokeWidthIdx + firstSemiColonAfterStrokeWidthIdx + 1, styleStr.length());
                        String lineStyle = beforeStrokeWidth + "stroke-width: " + style.getWidth() + ";" + afterStrokeWidth;
                        ig.drawLineYear(rangeX, base, rangeX, curTopAge, lineStyle, starty);
                        if (!range2.branchDisabled) {
                            if (range2.topSymbol == 0 && range2.top >= settings.topAge) {
                                double mar = 6.0;
                                double r = 4.0;
                                ig.drawCircleYear(rangeX, range2.top, starty - mar, r, "stroke: red; stroke-width:1; fill: rgb(255,0,0);", p, false);
                                r = 3.0;
                                ig.drawCircleYear(rangeX, range2.top, starty - mar, r, "stroke: red; stroke-width:1; fill: rgb(255,255,255);", p, false);
                            } else if (range2.topSymbol == 1 && range2.top >= settings.topAge) {
                                if (curTopAge >= settings.topAge) {
                                    double r = 5.0;
                                    String rlineStyle = "stroke: red; stroke-width:2; fill: rgb(255,0,0);";
                                    ig.drawCrossYear(rangeX, range2.top, starty, r, rlineStyle, p, false);
                                }
                            } else if (range2.topSymbol == 3 && range2.top >= settings.topAge) {
                                double[] x = new double[3];
                                double[] y = new double[3];
                                double length = 2.5;
                                x[0] = rangeX - length;
                                x[1] = rangeX;
                                x[2] = rangeX + length;
                                y[0] = range2.top + Math.sqrt(2.0) * length * 0.05;
                                y[1] = range2.top;
                                y[2] = range2.top + Math.sqrt(2.0) * length * 0.05;
                                if (y[1] >= settings.topAge) {
                                    ig.drawArrowWithPolygon(x, y, "stroke: red; stroke-width:1; fill: rgb(255,0,0);", starty);
                                }
                            }
                            if (range2.baseSymbol == 2 && (double)range2.baseSymbol <= settings.baseAge && !p.rcd.branch) {
                                if (range2.base <= settings.baseAge) {
                                    ig.drawRectYear(rangeX - 5.0, range2.base, 10.0, 0.0625, "stroke: red; stroke-width:1; fill: rgb(255,0,0);", starty);
                                }
                            } else if (range2.baseSymbol == 4 && (double)range2.baseSymbol <= settings.baseAge) {
                                double[] x = new double[3];
                                double[] y = new double[3];
                                double length = 2.5;
                                x[0] = rangeX - length;
                                x[1] = rangeX;
                                x[2] = rangeX + length;
                                y[0] = range2.base + Math.sqrt(2.0) * length * 0.05 - 0.15;
                                y[1] = range2.base - 0.15;
                                y[2] = range2.base + Math.sqrt(2.0) * length * 0.05 - 0.15;
                                if (y[1] <= settings.baseAge) {
                                    ig.drawArrowWithPolygon(x, y, "stroke: red; stroke-width:1; fill: rgb(255,0,0);", starty);
                                }
                            }
                        }
                        if (this.drawAgeLabel) {
                            String bpS = Double.toString(bp.age);
                            String beforeDecimal = bpS.split("\\.")[0];
                            int bpL = beforeDecimal.length() + 2;
                            String pS = Double.toString(p.age);
                            beforeDecimal = pS.split("\\.")[0];
                            int pL = beforeDecimal.length() + 2;
                            int pd = Math.abs(bpL - pL);
                            double fontSize = Math.floor(this.fonts.getFont(1).getSize());
                            boolean fPd = false;
                            if (pd > 0) {
                                fPd = true;
                            }
                            if (range2.baseSymbol != 4) {
                                this.drawAgeLabelForRangePoint(ig, range2, p, rangeX - this.RangeColumnRangeAgeLabelPadding, startx, starty, height, settings);
                            }
                            if (bp != null && bp.rcd != null && bp.rcd.type != null && range2.topSymbol != 3 && bp.age != 0.0) {
                                this.drawAgeLabelForRangePoint(ig, range2, bp, rangeX - this.RangeColumnRangeAgeLabelPadding + (double)(pd * 2) + (double)fPd * ((fontSize - 6.0) / 3.0), startx, starty, height, settings);
                            }
                        }
                    } else {
                        if (prevX > rangeX) {
                            rangeX = prevX;
                        }
                        if (prevRangeName != range2.name && prevRangeName != null) {
                            rangeX = prevX + prevWidth + overlapShift + this.BranchSpacing;
                        }
                        double a1 = (bp.age - settings.topAge) * settings.unitsPerMY + starty;
                        double b1 = (p.age - settings.topAge) * settings.unitsPerMY + starty;
                        if (a1 > myTopHeight && a1 < myBaseHeight || b1 > myTopHeight && b1 < myBaseHeight) {
                            if (0.5 * style.getWidth() > myLineShift) {
                                myLineShift = 0.5 * style.getWidth();
                            }
                        } else if ((myTopHeight > a1 && myTopHeight < b1 || myBaseHeight > a1 && myBaseHeight < b1) && 0.5 * style.getWidth() > myLineShift) {
                            myLineShift = 0.5 * style.getWidth();
                        }
                        if (ConserveSpace) {
                            double b2 = (range2.top - settings.topAge) * settings.unitsPerMY + starty;
                            double a2 = (range2.base - settings.topAge) * settings.unitsPerMY + starty;
                            currentHeight = b2 < a2 - range2.nameHeight ? b2 : a2 - range2.nameHeight;
                            if (minTop == 0.0 && maxBase == 0.0) {
                                minTop = currentHeight;
                                maxBase = a2;
                            } else if (minTop > a2) {
                                rangeX = prevX;
                                minTop = currentHeight;
                            } else if (currentHeight > maxBase) {
                                rangeX = prevX;
                                maxBase = a2;
                            } else {
                                minTop = currentHeight;
                                maxBase = a2;
                            }
                        }
                        ig.drawLineYear(rangeX, base, rangeX, curTopAge, style.getStyle(), starty);
                        if (range2.top < settings.baseAge && range2.base > settings.topAge && !Double.isNaN(range2.top) && !Double.isNaN(range2.base)) {
                            prevX = rangeX;
                            prevRangeName = range2.name;
                            prevWidth = range2.width;
                        }
                        if (this.drawAgeLabel) {
                            String bpS = Double.toString(bp.age);
                            String beforeDecimal = bpS.split("\\.")[0];
                            int bpL = beforeDecimal.length() + 2;
                            String pS = Double.toString(p.age);
                            beforeDecimal = pS.split("\\.")[0];
                            int pL = beforeDecimal.length() + 2;
                            int pd = Math.abs(bpL - pL);
                            double fontSize = Math.floor(this.fonts.getFont(1).getSize());
                            boolean fPd = false;
                            if (pd > 0) {
                                fPd = true;
                            }
                            if (p.age < settings.baseAge && p.age > settings.topAge && !Double.isNaN(p.age)) {
                                this.drawAgeLabelForRangePoint(ig, range2, p, rangeX - this.RangeColumnRangeAgeLabelPadding, startx, starty, height, settings);
                            }
                            if (bp != null && bp.rcd != null && bp.rcd.type != null && bp.rcd.type.equals("TOP")) {
                                if (bp.age != 0.0 && bp.age > settings.topAge && bp.age < settings.baseAge) {
                                    this.drawAgeLabelForRangePoint(ig, range2, bp, rangeX - this.RangeColumnRangeAgeLabelPadding + (double)(pd * 2) + (double)fPd * ((fontSize - 6.0) / 3.0), startx, starty, height, settings);
                                } else if (range2.top >= settings.topAge && range2.top < settings.baseAge) {
                                    double mar = 6.0;
                                    double r = 4.0;
                                    ig.drawCircleYear(rangeX, range2.top, starty - mar, r, "stroke: red; stroke-width:1; fill: rgb(255,0,0);", p, false);
                                    r = 3.0;
                                    ig.drawCircleYear(rangeX, range2.top, starty - mar, r, "stroke: red; stroke-width:1; fill: rgb(255,255,255);", p, false);
                                }
                            } else if (bp.rcd.type == null && isTop) {
                                if (bp.age != 0.0 && bp.age > settings.topAge && bp.age < settings.baseAge) {
                                    this.drawAgeLabelForRangePoint(ig, range2, bp, rangeX - this.RangeColumnRangeAgeLabelPadding + (double)(pd * 2) + (double)fPd * ((fontSize - 6.0) / 3.0), startx, starty, height, settings);
                                }
                                isTop = false;
                            }
                        }
                    }
                    range2.rangeXCanvas = rangeX;
                    range2.baseofRange = base;
                    curTopAge = base;
                    bp = p;
                }
                if (range2.base < settings.topAge + 1.0E-6 && !Double.isNaN(range2.base) || range2.top > settings.baseAge - 1.0E-6 && !Double.isNaN(range2.top)) continue;
                if (!range2.branchDisabled) {
                    if (myLineShift > 1.0) {
                        rangeX += myLineShift;
                        overlapShift = myLineShift;
                    }
                    boolean drawLabelHere = false;
                    boolean resize = false;
                    double textX = Double.NaN;
                    double textY = Double.NaN;
                    switch (range2.labelloc) {
                        case TOP: {
                            textX = rangeX - range2.nameWidth / 2.0;
                            textY = ImageGenerator.getYFromYear(range2.top, starty, settings) - 3.0 - range2.nameHeight;
                            drawLabelHere = true;
                            break;
                        }
                        case BOTTOM: {
                            textX = rangeX - range2.nameWidth / 2.0;
                            textY = ImageGenerator.getYFromYear(range2.base, starty, settings) + 3.0;
                            drawLabelHere = true;
                            break;
                        }
                        case LEFT_SIDE: {
                            textX = rangeX - range2.rangeWidth / 2.0 + 0.5;
                            textY = ImageGenerator.getYFromYear(range2.base, starty, settings) - 1.0 - range2.nameHeight;
                            if (textY + 3.0 + range2.nameHeight + 1.0 > starty + height) {
                                textY = starty + height - (3.0 + range2.nameHeight + 1.0);
                            }
                            if (textY < starty + 3.0) {
                                textY = starty + 3.0;
                            }
                            drawLabelHere = true;
                            break;
                        }
                        case RIGHT_SIDE: {
                            textX = rangeX + range2.rangeWidth / 2.0 + 0.5;
                            textY = ImageGenerator.getYFromYear(range2.base, starty, settings) - 1.0 - range2.nameHeight;
                            if (textY + 3.0 + range2.nameHeight + 1.0 > starty + height) {
                                textY = starty + height - (3.0 + range2.nameHeight + 1.0);
                            }
                            if (textY < starty + 3.0) {
                                textY = starty + 3.0;
                            }
                            drawLabelHere = true;
                            break;
                        }
                        case RESIZE: {
                            textX = rangeX + range2.rangeWidth / 2.0 + 0.5;
                            textY = starty + height - (3.0 + range2.nameHeight + 1.0);
                            resize = true;
                            drawLabelHere = true;
                        }
                    }
                    if (drawLabelHere) {
                        if (Double.isNaN(textX)) {
                            Debug.critical("incorrectly calculated label coordinates in range column!");
                        }
                        if (!range2.isPhenonRange && this.integratedTreeStructure) {
                            double textXForOtherSide = rangeX + range2.rangeWidth;
                            ig.drawString(range2.nameSWI, textXForOtherSide + RANGE_LABEL_X_PADDING, textY - RANGE_LABEL_Y_PADDING, range2.nameWidth, range2.nameHeight, 3, textY, 12, this.color.getColor(lastUsedRCD.baseAge, lastUsedRCD.baseAge));
                            if ((range2.popup != "" || range2.branchInfoTemp != "") && settings.doPopups) {
                                ig.pushGrouping();
                                ig.doPopupThings(range2.popup + range2.branchInfoTemp, this.fileInfo, this);
                                ig.drawRect(textXForOtherSide + RANGE_LABEL_X_PADDING, textY - RANGE_LABEL_Y_PADDING, range2.nameWidth, range2.nameHeight, "stroke-width: 0; opacity: 0.5; fill: red;");
                                ig.popGrouping();
                            }
                        } else if (range2.isPhenonRange && this.integratedTreeStructure) {
                            try {
                                ig.drawString(range2.nameSWI, textX + RANGE_LABEL_X_PADDING, textY - RANGE_LABEL_Y_PADDING, range2.nameWidth, range2.nameHeight, 3, textY, 12, this.color.getColor(lastUsedRCD.baseAge, lastUsedRCD.baseAge));
                            }
                            catch (NullPointerException e) {
                                System.out.println(e.getMessage());
                            }
                            if ((range2.popup != "" || range2.branchInfoTemp != "") && settings.doPopups) {
                                ig.pushGrouping();
                                ig.doPopupThings(range2.popup + range2.branchInfoTemp, this.fileInfo);
                                ig.drawRect(textX + RANGE_LABEL_X_PADDING, textY - RANGE_LABEL_Y_PADDING, range2.nameWidth, range2.nameHeight, "stroke-width: 0; opacity: 0.5; fill: red;");
                                ig.popGrouping();
                            }
                        } else {
                            try {
                                if (resize) {
                                    ig.drawString(range2.nameSWI, textX + RANGE_LABEL_X_PADDING, textY - RANGE_LABEL_Y_PADDING, range2.nameWidth, range2.nameHeight, 3, textY, 12, this.color.getColor(lastUsedRCD.baseAge, lastUsedRCD.baseAge), resize);
                                } else {
                                    ig.drawString(range2.nameSWI, textX + RANGE_LABEL_X_PADDING, textY - RANGE_LABEL_Y_PADDING, range2.nameWidth, range2.nameHeight, 3, textY, 12, this.color.getColor(lastUsedRCD.baseAge, lastUsedRCD.baseAge));
                                }
                            }
                            catch (NullPointerException e) {
                                System.out.println(e.getMessage());
                            }
                            if ((range2.popup != "" || range2.branchInfoTemp != "") && settings.doPopups) {
                                ig.pushGrouping();
                                ig.doPopupThings(range2.popup + range2.branchInfoTemp, this.fileInfo);
                                ig.drawRect(textX, textY, range2.nameWidth, range2.nameHeight, "stroke-width: 0; opacity: 0.5; fill: red;");
                                ig.popGrouping();
                            }
                        }
                    }
                }
                Iterator iterUpdate = null;
                iterUpdate = this.speciesPhenonTreeDrawing ? this.extendedRanges.iterator() : (this.rangesWithoutSplit != null ? this.rangesWithoutSplit.iterator() : this.ranges.iterator());
                Range ru = null;
                while (iterUpdate.hasNext()) {
                    ru = (Range)iterUpdate.next();
                    if (ru.name != range2.name || ru.base != range2.base || ru.top != range2.top || ru.points.size() != range2.points.size()) continue;
                    ru.width = range2.width;
                    ru.rangeWidth = range2.width;
                    ru.rangeXCanvas = range2.rangeXCanvas;
                    ru.lineX = range2.lineX;
                    ru.widthSubTree = range2.widthSubTree;
                }
            }
            rangeStart += maxWidth + 2.0;
        }
        this.drawBranches(ig, startx, starty, width, height, settings);
        if (this.speciesPhenonTreeDrawing && this.phenonRangeStateMap != null) {
            for (Range phenonRange : this.extendedRanges) {
                if (!phenonRange.isPhenonRange || !this.phenonRangeStateMap.containsKey(phenonRange)) continue;
                phenonRange.branchDisabled = this.phenonRangeStateMap.get(phenonRange);
            }
        }
    }

    private double getHeightTop(Range myRange, double starty, double height, Settings settings) {
        double myYHeight = 0.0;
        switch (myRange.labelloc) {
            case TOP: {
                myYHeight = ImageGenerator.getYFromYear(myRange.top, starty, settings) - 3.0 - myRange.nameHeight;
                break;
            }
            case BOTTOM: {
                myYHeight = ImageGenerator.getYFromYear(myRange.base, starty, settings) + 3.0;
                break;
            }
            case LEFT_SIDE: {
                myYHeight = ImageGenerator.getYFromYear(myRange.base, starty, settings) - 1.0 - myRange.nameHeight;
                if (myYHeight + 3.0 + myRange.nameHeight + 1.0 > starty + height) {
                    myYHeight = starty + height - (3.0 + myRange.nameHeight + 1.0);
                }
                if (!(myYHeight < starty + 3.0)) break;
                myYHeight = starty + 3.0;
                break;
            }
            case RIGHT_SIDE: {
                myYHeight = ImageGenerator.getYFromYear(myRange.base, starty, settings) - 1.0 - myRange.nameHeight;
                if (myYHeight + 3.0 + myRange.nameHeight + 1.0 > starty + height) {
                    myYHeight = starty + height - (3.0 + myRange.nameHeight + 1.0);
                }
                if (!(myYHeight < starty + 3.0)) break;
                myYHeight = starty + 3.0;
                break;
            }
            case RESIZE: {
                myYHeight = starty + height - (3.0 + myRange.nameHeight + 1.0);
            }
        }
        return myYHeight;
    }

    @Override
    public int getNumSeries() {
        return 1;
    }

    @Override
    public boolean canAlterSeries() {
        return false;
    }

    @Override
    public DataSeries getSeriesModel(int which) {
        if (which != 0) {
            return null;
        }
        DataSeries series = new DataSeries();
        series.setSingle(new DataSteward(this.data, new TableInterpreter()));
        return series;
    }

    @Override
    public String getSeriesName(int which) {
        if (which != 0) {
            return null;
        }
        return "Ranges";
    }

    @Override
    public void readOneSetting(Element setting, Settings settings) {
        super.readOneSetting(setting, settings);
        String attrname = setting.getAttribute("name");
        if (attrname != null && attrname.compareToIgnoreCase("rangeSort") == 0) {
            String t = Settings.getNodeTextContent(setting);
            this.rangeSort = t.compareToIgnoreCase("first occurrence") == 0 ? 1 : (t.compareToIgnoreCase("last occurrence") == 0 ? 2 : (t.compareToIgnoreCase("alphabetical") == 0 ? 3 : 0));
        }
    }

    @Override
    public void writeSettings(Element element, Document doc) {
        super.writeSettings(element, doc);
        Element rangeSortE = Settings.createSimpleSetting(doc, "rangeSort", null);
        switch (this.rangeSort) {
            case 1: {
                Settings.setNodeTextContent(rangeSortE, "first occurrence", doc);
                break;
            }
            case 2: {
                Settings.setNodeTextContent(rangeSortE, "last occurrence", doc);
                break;
            }
            case 3: {
                Settings.setNodeTextContent(rangeSortE, "alphabetical", doc);
                break;
            }
            default: {
                Settings.setNodeTextContent(rangeSortE, "other", doc);
            }
        }
        element.appendChild(rangeSortE);
    }

    @Override
    public void write(Writer w) throws IOException {
        this.writeHeader(w, "range");
        Iterator iter = this.getData();
        while (iter.hasNext()) {
            RCDatapoint dp = (RCDatapoint)iter.next();
            w.write("\t" + dp.label + "\t" + Double.toString(dp.baseAge));
            if (dp.type != null) {
                w.write("\t" + dp.type.toString());
            }
            w.write("\r\n");
        }
        this.writeOverlaysAndUnderlays(w);
    }

    public void linkRangeSets(boolean forPhenonRange) {
        System.out.println("PRIORITY CHECK 0: running linkRangeSets");
        Iterator iterParent = this.ranges.iterator();
        Iterator iter2 = null;
        Iterator iter3 = null;
        Iterator<Range> iterChild = null;
        Range rangeParent = null;
        Range branchClickedRangeParent = null;
        Range rangeChild = null;
        RangePoint point2 = null;
        boolean found = false;
        try {
            String rname;
            String[] pathS;
            String path;
            block2: while (iterParent.hasNext()) {
                rangeParent = (Range)iterParent.next();
                for (RangePoint point2 : rangeParent.points) {
                    if (point2.rcd.speciesOrPhenon != null && point2.rcd.speciesOrPhenon.equalsIgnoreCase("phenon") && point2.rcd.speciesWithFinalTopOfPhenon != null) {
                        rangeParent.isPhenonRange = true;
                        rangeParent.speciesNameWithFinalTop = point2.rcd.speciesWithFinalTopOfPhenon;
                    }
                    if (forPhenonRange ? !rangeParent.isPhenonRange : rangeParent.isPhenonRange) continue block2;
                    found = false;
                    System.out.println("PRIORITY CHECK 1: before if point.rcd.branch");
                    if (!point2.rcd.branch) continue;
                    System.out.println("PRIORITY CHECK 2: inside if point.rcd.branch");
                    iterChild = this.ranges.iterator();
                    while (iterChild.hasNext()) {
                        System.out.println("PRIORITY CHECK 3: inside while iterChild.hasNext()");
                        rangeChild = iterChild.next();
                        if (!point2.rcd.branchTo.equalsIgnoreCase(rangeChild.name.split(" <img")[0])) continue;
                        System.out.println("PRIORITY CHECK 4: inside if branch to <img");
                        if (rangeChild.base > point2.age) {
                            System.out.println("PRIORITY CHECK 5: inside if rangeChild.base");
                            for (RangePoint rangePoint : rangeChild.points) {
                            }
                            errMsg = errMsg + this.name + "\nBase age " + rangeChild.base + " of Child " + rangeChild.name + " is lower than Branch age " + point2.age + " at Parent " + point2.name + "\n";
                        }
                        if (rangeParent.children == null) {
                            rangeParent.children = new ArrayList<Range>();
                        }
                        rangeParent.children.add(rangeChild);
                        rangeChild.parent = rangeParent;
                        rangeChild.branchColor = rangeParent.branchColor;
                        rangeChild.rangePrio = point2.rcd.branchPrio;
                        rangeChild.branchDisabled = point2.rcd.notInclude;
                        rangeChild.overridePriority = point2.rcd.overridePriority || rangeParent.overridePriority;
                        System.out.println("PRIORITY CHECKL overridePriority is " + rangeChild.overridePriority + ", from OR of point.rcd.overridePriority = " + point2.rcd.overridePriority + ", and rangeParent.overridePriority = " + rangeParent.overridePriority);
                        rangeChild.disabled4Priority = rangeChild.rangePrio < this.priorityVal && this.priorityEnable && !rangeChild.overridePriority;
                        System.out.println("PRIORITY CHECK: disabled4Priority = " + rangeChild.disabled4Priority + ", rangePrio = " + rangeChild.rangePrio + ", this.priorityVal = " + this.priorityVal + ", this.priorityEnable = " + this.priorityEnable + ", rangeChild.overridePriority = " + rangeChild.overridePriority);
                        point2.childRange = rangeChild;
                        if (point2.rcd.subLabel != null) {
                            rangeChild.subLabel = point2.rcd.subLabel;
                        }
                        found = true;
                        break;
                    }
                    if (!found) {
                        point2.childOutofRange = true;
                    }
                    if (!point2.rcd.branchClicked) continue;
                    point2.setResetIncludeBranch(true);
                    this.clickedBranchPoint = point2;
                    branchClickedRangeParent = rangeParent;
                }
            }
            if (this.drawAncestorPath && this.clickedBranchPoint == null) {
                ArrayList<String> pathA = null;
                pathA = this.T.getPathArrayFromRootToCommonAncestor(this.tree, this.firstRangeName, this.secondRangeName);
                if (pathA == null || pathA.size() == 0) {
                    JOptionPane.showMessageDialog(this.getOptionsPanel(), "Could not find common ancestor.");
                }
                String commonAncestor = pathA.get(pathA.size() - 1);
                this.commonAncestorText.setText(commonAncestor);
                pathA.remove(pathA.size() - 1);
                Iterator iterRP = this.ranges.iterator();
                Range cA = null;
                while (iterRP.hasNext()) {
                    Range r = (Range)iterRP.next();
                    String rname2 = r.name.split(" <img")[0];
                    if (!rname2.equalsIgnoreCase(commonAncestor)) continue;
                    cA = r;
                    for (RangePoint crp : cA.points) {
                        if (!crp.rcd.branch || this.clickedBranchPoint != null) continue;
                        crp.setResetIncludeBranch(true);
                        this.clickedBranchPoint = crp;
                        branchClickedRangeParent = r;
                        this.hideBranchAncestors = true;
                    }
                }
            }
            if (this.clickedBranchPoint != null && this.clickedBranchPoint.childRange != null && this.clickedBranchPoint.childRange.parent != null && !this.enableAllBranches && this.hideBranchAncestors) {
                Range cr = this.clickedBranchPoint.childRange.parent.parent;
                while (cr != null) {
                    cr.branchDisabled = true;
                    for (RangePoint crp : cr.points) {
                        if (!crp.rcd.branch) continue;
                        crp.setResetIncludeBranch(true);
                        crp.childRange.branchDisabled = true;
                    }
                    cr = cr.parent;
                }
            }
            iterParent = this.ranges.iterator();
            while (this.clickedBranchPoint != null && iterParent.hasNext()) {
                rangeParent = (Range)iterParent.next();
                if (this.hideBranchAncestors && !this.enableAllBranches && rangeParent == branchClickedRangeParent) {
                    rangeParent.branchDisabled = false;
                }
                if (rangeParent.children == null) continue;
                iterChild = rangeParent.children.iterator();
                while (iterChild.hasNext()) {
                    if (this.hideBranchAncestors && rangeParent != branchClickedRangeParent && rangeParent.branchDisabled && !this.enableAllBranches || rangeParent.branchDisabled && !this.enableAllBranches && !this.hideBranchAncestors) {
                        iterChild.next().branchDisabled = true;
                        continue;
                    }
                    if (rangeParent == branchClickedRangeParent && this.hideBranchAncestors) {
                        iterChild.next().branchDisabled = false;
                        continue;
                    }
                    iterChild.next();
                }
            }
            if (this.drawAncestorPath && this.hideBranchAncestors && this.clickedBranchPoint != null) {
                this.hideBranchAncestors = false;
                this.drawAncestorPath = false;
            }
            this.clickedBranchPoint = null;
            branchClickedRangeParent = null;
            if (this.drawFirstRangePath) {
                path = this.T.getPathToNode(this.tree, this.firstRangeName);
                pathS = path.split("->");
                for (Range r : this.ranges) {
                    rname = r.name.split(" <img")[0];
                    boolean inPath = false;
                    for (int k = 0; k < pathS.length; ++k) {
                        if (!rname.equals(pathS[k])) continue;
                        inPath = true;
                    }
                    if (inPath) {
                        r.branchDisabled = false;
                        continue;
                    }
                    r.branchDisabled = true;
                }
                this.drawFirstRangePath = false;
            } else if (this.drawSecondRangePath) {
                path = this.T.getPathToNode(this.tree, this.secondRangeName);
                pathS = path.split("->");
                for (Range r : this.ranges) {
                    rname = r.name.split(" <img")[0];
                    boolean inPath = false;
                    for (int k = 0; k < pathS.length; ++k) {
                        if (!rname.equals(pathS[k])) continue;
                        inPath = true;
                    }
                    if (inPath) {
                        r.branchDisabled = false;
                        continue;
                    }
                    r.branchDisabled = true;
                }
                this.drawSecondRangePath = false;
            } else if (this.drawFirstToSecondRangePath && (path = this.T.getPathFromNodeToNode(this.tree, this.firstRangeName, this.secondRangeName)) != null && !path.equals("")) {
                pathS = path.split("->");
                for (Range r : this.ranges) {
                    rname = r.name.split(" <img")[0];
                    boolean inPath = false;
                    for (int k = 0; k < pathS.length; ++k) {
                        if (!rname.equals(pathS[k])) continue;
                        inPath = true;
                    }
                    if (inPath) {
                        r.branchDisabled = false;
                        continue;
                    }
                    r.branchDisabled = true;
                }
                this.drawFirstToSecondRangePath = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void getEndPoints(List<RangePoint> endpoints) {
        Iterator iter = this.getDrawingData();
        while (iter.hasNext()) {
            RCDatapoint p = (RCDatapoint)iter.next();
            StringTokenizer st = null;
            st = !this.speciesPhenonTreeDrawing ? new StringTokenizer(p.label, ";") : new StringTokenizer(p.label, ",");
            while (st.hasMoreTokens()) {
                String l = st.nextToken().trim();
                if (l.length() < 1) continue;
                RangePoint rp = new RangePoint();
                rp.age = p.baseAge;
                rp.name = l;
                if (rp.popup == null) {
                    rp.popup = p.popup;
                }
                String pType = "";
                if (p.type != null) {
                    pType = p.type.toString();
                }
                if (pType.compareToIgnoreCase("LAD") == 0) {
                    rp.top = true;
                } else if (pType.compareToIgnoreCase("FAD") == 0) {
                    rp.top = false;
                }
                rp.type = pType;
                rp.rcd = p;
                endpoints.add(rp);
            }
        }
    }

    public void addPointsToSplittedPhenon(Range speciesRange, Range splittedPhenon, boolean forBase, boolean isSplit) {
        ArrayList<RangePoint> endpoints = new ArrayList<RangePoint>(this.data.size());
        this.getEndPoints(endpoints);
        RangePoint closestPointBelow = null;
        Double closeness = Double.POSITIVE_INFINITY;
        SortedSet<RangePoint> savedPoints = Collections.synchronizedSortedSet(new TreeSet(new RangePointComparator()));
        for (RangePoint rrp : endpoints) {
            if (!rrp.name.split(" <img")[0].equalsIgnoreCase(splittedPhenon.name.split(" <img")[0])) continue;
            savedPoints.add(rrp);
        }
        boolean basePointExists = false;
        boolean topPointExists = false;
        RangePoint tmpBasePoint = null;
        RangePoint tmpTopPoint = null;
        for (RangePoint p : endpoints) {
            if (p.rcd.speciesOrPhenon == null || !p.rcd.speciesOrPhenon.equals("phenon") || !p.name.split(" <img")[0].equals(splittedPhenon.name.split(" <img")[0])) continue;
            if (p.age == splittedPhenon.base) {
                basePointExists = true;
                tmpBasePoint = p.copy();
                if (tmpBasePoint.rcd.type == null) {
                    tmpBasePoint.rcd.type = "common";
                }
            }
            if (p.age != splittedPhenon.top) continue;
            topPointExists = true;
            tmpTopPoint = p.copy();
            if (tmpTopPoint.rcd.type == null || !tmpTopPoint.rcd.type.equals("branch") && !tmpTopPoint.rcd.type.equals("TOP")) {
                tmpTopPoint.rcd.type = "TOP";
                continue;
            }
            if (tmpTopPoint.rcd.type == null || !tmpTopPoint.rcd.type.equals("branch")) continue;
            tmpTopPoint.rcd.type = "TOP";
            tmpTopPoint.rcd.branch = false;
            tmpTopPoint.rcd.branchTo = null;
            tmpTopPoint.rcd.branchColor = null;
            tmpTopPoint.rcd.branchLabel = null;
            tmpTopPoint.rcd.branchPrio = 0;
        }
        for (RangePoint p : endpoints) {
            if (p.name.split(" <img")[0].equals(splittedPhenon.name.split(" <img")[0]) && p.age <= splittedPhenon.base && p.age >= splittedPhenon.top) {
                boolean pointExists = false;
                for (RangePoint rpp : splittedPhenon.points) {
                    if (rpp.age != p.age || rpp.rcd.branchTo != p.rcd.branchTo) continue;
                    pointExists = true;
                    if (rpp.age == splittedPhenon.top && rpp.rcd.type == null) {
                        rpp.rcd.type = "TOP";
                    }
                    if (rpp.age != splittedPhenon.base || rpp.rcd.type != null) continue;
                    rpp.rcd.type = "common";
                }
                if (!pointExists) {
                    if (basePointExists && tmpBasePoint.age == p.age && tmpBasePoint.name == p.name) {
                        for (RangePoint op : savedPoints) {
                            if (op.rcd.branch || !(op.age >= tmpBasePoint.age) || !op.rcd.type.equalsIgnoreCase("flood") && !op.rcd.type.equalsIgnoreCase("abundant")) continue;
                            tmpBasePoint.rcd.type = op.rcd.type;
                            break;
                        }
                        splittedPhenon.addPoint(tmpBasePoint);
                    } else if (topPointExists && tmpTopPoint.age == p.age && tmpTopPoint.name == p.name) {
                        splittedPhenon.addPoint(tmpTopPoint);
                    } else {
                        for (RangePoint op : savedPoints) {
                            if (p.rcd.branch || op.rcd.branch || !(op.age >= p.age) || !op.rcd.type.equalsIgnoreCase("flood") && !op.rcd.type.equalsIgnoreCase("abundant")) continue;
                            p.rcd.type = op.rcd.type;
                            break;
                        }
                        splittedPhenon.addPoint(p);
                    }
                }
            }
            if (!isSplit || !p.name.split(" <img")[0].equals(splittedPhenon.name.split(" <img")[0])) continue;
            if (!basePointExists && forBase) {
                if (!(p.age >= splittedPhenon.base && Math.abs(p.age - splittedPhenon.base) < closeness) && closeness != null) continue;
                closeness = Math.abs(p.age - splittedPhenon.base);
                closestPointBelow = p.copy();
                closestPointBelow.age = splittedPhenon.base;
                if (tmpBasePoint != null && tmpBasePoint.type == "branch") {
                    closestPointBelow.rcd.type = "branch";
                } else {
                    if (closestPointBelow.rcd.type == null || closestPointBelow.rcd.type.equals("")) {
                        closestPointBelow.rcd.type = "common";
                    }
                    if (closestPointBelow.rcd.branch) {
                        closestPointBelow.rcd.branch = false;
                        closestPointBelow.rcd.branchTo = null;
                        closestPointBelow.rcd.branchLabel = null;
                        closestPointBelow.rcd.branchPrio = 0;
                        closestPointBelow.rcd.branchColor = null;
                    }
                }
                closestPointBelow.rcd.baseAge = splittedPhenon.base;
                continue;
            }
            if (topPointExists || forBase || !(p.age >= splittedPhenon.top && Math.abs(p.age - splittedPhenon.top) < closeness) && closeness != null) continue;
            closeness = Math.abs(p.age - splittedPhenon.top);
            closestPointBelow = p.copy();
            closestPointBelow.age = splittedPhenon.top;
            closestPointBelow.rcd.splitPhenonBranch = true;
            if (tmpTopPoint != null && tmpTopPoint.type == "branch") {
                closestPointBelow.rcd.type = "branch";
                continue;
            }
            closestPointBelow.rcd.type = "TOP";
            if (!closestPointBelow.rcd.branch) continue;
            closestPointBelow.rcd.branch = false;
            closestPointBelow.rcd.branchTo = null;
            closestPointBelow.rcd.branchLabel = null;
            closestPointBelow.rcd.branchPrio = 0;
            closestPointBelow.rcd.branchColor = null;
        }
        if (closestPointBelow != null) {
            for (RangePoint op : savedPoints) {
                if (op.rcd.branch || !(op.age >= closestPointBelow.age) || !op.rcd.type.equalsIgnoreCase("flood") && !op.rcd.type.equalsIgnoreCase("abundant")) continue;
                closestPointBelow.rcd.type = op.rcd.type;
                break;
            }
            splittedPhenon.addPoint(closestPointBelow);
        }
    }

    public void extendRangeSets(Settings settings) {
        this.findSpecificRanges(settings, true, true);
        block0: for (Range rangePhenon : this.phenonRanges) {
            if (!rangePhenon.isPhenonRange) continue;
            String speciesToSearch = rangePhenon.speciesNameWithFinalTop;
            Iterator iterSpecies = this.ranges.iterator();
            Range rangeSpecies = null;
            while (iterSpecies.hasNext()) {
                rangeSpecies = (Range)iterSpecies.next();
                if (rangeSpecies.isPhenonRange || !speciesToSearch.equalsIgnoreCase(rangeSpecies.name.split(" <img")[0])) continue;
            }
            Range splittedPhenon = new Range(rangePhenon);
            splittedPhenon.top = rangePhenon.top;
            splittedPhenon.topSymbol = splittedPhenon.top == 0.0 ? 0 : 1;
            Range tmpRange = null;
            Range r = rangeSpecies;
            boolean isSplit = false;
            do {
                if (splittedPhenon.base > r.base) {
                    splittedPhenon.base = r.base;
                    splittedPhenon.baseSymbol = 4;
                    splittedPhenon.branchColor = r.branchColor;
                    r.phenonsContainingSpecies.add(splittedPhenon);
                    splittedPhenon.points.clear();
                    this.addPointsToSplittedPhenon(r, splittedPhenon, true, true);
                    boolean topRangePointExists = false;
                    for (RangePoint rpp : splittedPhenon.points) {
                        if (rpp.age != splittedPhenon.top) continue;
                        topRangePointExists = true;
                    }
                    if (!topRangePointExists) {
                        this.addPointsToSplittedPhenon(r, splittedPhenon, false, true);
                    }
                } else {
                    splittedPhenon.base = rangePhenon.base;
                    for (Range pR : this.phenonRanges) {
                        if (!pR.name.contains(splittedPhenon.name)) continue;
                        splittedPhenon.baseSymbol = 2;
                    }
                    r.phenonsContainingSpecies.add(splittedPhenon);
                    splittedPhenon.points.clear();
                    this.addPointsToSplittedPhenon(r, splittedPhenon, false, isSplit);
                    for (RangePoint rp : splittedPhenon.points) {
                        if (!rp.rcd.splitPhenonBranch) continue;
                        splittedPhenon.children.add(tmpRange);
                        rp.childRange = tmpRange;
                        if (splittedPhenon.baseSymbol == 2) continue;
                        splittedPhenon.baseSymbol = -1;
                    }
                    this.extendedRanges.add(splittedPhenon);
                    isSplit = false;
                    continue block0;
                }
                this.extendedRanges.add(splittedPhenon);
                tmpRange = splittedPhenon;
                splittedPhenon = new Range(rangePhenon);
                splittedPhenon.top = r.base;
                splittedPhenon.topSymbol = 3;
                r = r.parent;
                isSplit = true;
            } while (r.parent != null);
        }
        for (Range r : this.ranges) {
            if (r.isPhenonRange) continue;
            this.extendedRanges.add(r);
        }
    }

    private void derivebranchColors() {
        Iterator iterRange = null;
        iterRange = this.speciesPhenonTreeDrawing ? this.extendedRanges.iterator() : this.ranges.iterator();
        Range range = null;
        Iterator points = null;
        RangePoint p2 = null;
        while (iterRange.hasNext()) {
            range = (Range)iterRange.next();
            for (RangePoint p2 : range.points) {
                if (p2.rcd.branch && !p2.childOutofRange || this.speciesPhenonTreeDrawing && p2.rcd.splitPhenonBranch) {
                    if (p2.rcd.branchColor != null) {
                        p2.childRange.branchColor = Coloring.getStyleRGB(p2.rcd.branchColor);
                    } else if (range.branchColor != null) {
                        if (p2.childRange != null) {
                            p2.childRange.branchColor = range.branchColor;
                        }
                    } else {
                        p2.childRange.branchColor = "rgb(0,0,0)";
                    }
                    Iterator iterPhenonRange = null;
                    iterPhenonRange = this.speciesPhenonTreeDrawing ? this.extendedRanges.iterator() : this.ranges.iterator();
                    while (iterPhenonRange.hasNext()) {
                        Range phenonRange = (Range)iterPhenonRange.next();
                        if (!phenonRange.isPhenonRange || p2.childRange == null || !p2.childRange.name.equals(phenonRange.name) || phenonRange.parent != null) continue;
                        if (p2.rcd.branchColor != null) {
                            phenonRange.branchColor = Coloring.getStyleRGB(p2.rcd.branchColor);
                            continue;
                        }
                        if (range.branchColor != null) {
                            phenonRange.branchColor = range.branchColor;
                            continue;
                        }
                        phenonRange.branchColor = "rgb(0,0,0)";
                    }
                    continue;
                }
                if (p2.rcd.branch || p2.rcd.branchColor != null || range.branchColor == null || p2.childRange == null) continue;
                p2.childRange.branchColor = range.branchColor;
            }
        }
    }

    private int assignLocationAttributes() {
        Iterator rangeIterator = this.ranges.iterator();
        Range rootRange = null;
        int minLocation = Integer.MAX_VALUE;
        while (rangeIterator.hasNext()) {
            rootRange = (Range)rangeIterator.next();
            if (rootRange.rangeTraversed4Location || rootRange.location != Integer.MAX_VALUE || rootRange.branchDisabled) continue;
            minLocation = rootRange.locAttribute(minLocation);
        }
        return minLocation;
    }

    private void drawBranches(ImageGenerator ig, double startx, double starty, double widthOrig, double heightOrig, Settings settings) {
        Iterator iterRange = this.ranges.iterator();
        Range range = null;
        Iterator points = null;
        RangePoint p2 = null;
        double startXsubLabel = 0.0;
        double startYsubLabel = 0.0;
        double width = 0.0;
        RangeStyle style = new RangeStyle("stroke-dasharray:7,4; stroke: black;", 1.0);
        while (iterRange.hasNext()) {
            range = (Range)iterRange.next();
            if (range.branchDisabled || range.disabled4Priority) continue;
            for (RangePoint p2 : range.points) {
                if (!(p2.rcd.branch & !p2.childOutofRange)) continue;
                double rangeXParent = range.rangeXCanvas;
                double baseYParent = p2.age;
                double rangeXChild = p2.childRange.rangeXCanvas;
                double baseYChild = p2.childRange.baseofRange;
                style.style = p2.rcd.branchLabel != null ? (p2.rcd.branchLabel.equalsIgnoreCase("dashed") ? "stroke-dasharray:7,4;" : (p2.rcd.branchLabel.equalsIgnoreCase("dotted") ? "stroke-dasharray:2,2;" : "")) : "";
                style.style = p2.rcd.branchColor != null ? style.style + " stroke: " + Coloring.getStyleRGB(p2.rcd.branchColor) + ";" : style.style + " stroke: " + range.branchColor + ";";
                Iterator<Range> iterPhenonCounter = range.phenonsContainingSpecies.iterator();
                int totalPhenon = range.phenonsContainingSpecies.size();
                int enabledPhenonCounter = 0;
                while (iterPhenonCounter.hasNext()) {
                    Range pR = iterPhenonCounter.next();
                    if (pR.branchDisabled) continue;
                    ++enabledPhenonCounter;
                }
                if (!p2.childRange.branchDisabled && !p2.childRange.disabled4Priority) {
                    if (p2.childRange.base < settings.topAge + 1.0E-6 && !Double.isNaN(p2.childRange.base) || p2.childRange.top > settings.baseAge - 1.0E-6 && !Double.isNaN(p2.childRange.top)) continue;
                    if (!range.isPhenonRange && this.speciesPhenonTreeDrawing) {
                        if (p2.childRange.rangeXCanvas < range.rangeXCanvas) {
                            Iterator<Range> iterChildPhenonCounter = p2.childRange.phenonsContainingSpecies.iterator();
                            int totalChildPhenon = p2.childRange.phenonsContainingSpecies.size();
                            int enabledChildPhenonCounter = 0;
                            while (iterChildPhenonCounter.hasNext()) {
                                Range pR = iterChildPhenonCounter.next();
                                if (pR.branchDisabled) continue;
                                ++enabledChildPhenonCounter;
                            }
                            double rectWidth = p2.childRange.width;
                            if (enabledChildPhenonCounter == 0 && totalChildPhenon != 0) {
                                rectWidth /= (double)totalChildPhenon;
                            } else if (totalChildPhenon != enabledChildPhenonCounter) {
                                rectWidth = rectWidth / (double)totalChildPhenon * (double)enabledChildPhenonCounter;
                            }
                            double rangeXShiftedWithSpeciesBox = rangeXChild + rectWidth - p2.childRange.nameWidth - 50.0;
                            String styleStr = style.getStyle();
                            int strokeWidthIdx = styleStr.indexOf("stroke-width");
                            String beforeStrokeWidth = styleStr.substring(0, strokeWidthIdx);
                            String fromStrokeWidthStr = styleStr.substring(strokeWidthIdx, styleStr.length());
                            int firstSemiColonAfterStrokeWidthIdx = fromStrokeWidthStr.indexOf(";");
                            String afterStrokeWidth = styleStr.substring(strokeWidthIdx + firstSemiColonAfterStrokeWidthIdx + 1, styleStr.length());
                            String lineStyle = beforeStrokeWidth + "stroke-width: " + style.getWidth() + "; stroke-dasharray: 7,4; " + afterStrokeWidth;
                            ig.drawLineYear(rangeXShiftedWithSpeciesBox, baseYParent, rangeXParent, baseYChild, lineStyle, starty);
                        } else {
                            double rectWidth = range.width - range.nameWidth - 50.0;
                            double rangeXShiftedWithSpeciesBox = 0.0;
                            if (enabledPhenonCounter == 0 && totalPhenon != 0) {
                                rectWidth /= (double)totalPhenon;
                            } else if (totalPhenon != enabledPhenonCounter) {
                                rectWidth = rectWidth / (double)totalPhenon * (double)enabledPhenonCounter;
                            }
                            rangeXShiftedWithSpeciesBox = rangeXParent + rectWidth;
                            String styleStr = style.getStyle();
                            int strokeWidthIdx = styleStr.indexOf("stroke-width");
                            String beforeStrokeWidth = styleStr.substring(0, strokeWidthIdx);
                            String fromStrokeWidthStr = styleStr.substring(strokeWidthIdx, styleStr.length());
                            int firstSemiColonAfterStrokeWidthIdx = fromStrokeWidthStr.indexOf(";");
                            String afterStrokeWidth = styleStr.substring(strokeWidthIdx + firstSemiColonAfterStrokeWidthIdx + 1, styleStr.length());
                            String lineStyle = beforeStrokeWidth + "stroke-width: " + style.getWidth() + "; stroke-dasharray: 7,4; " + afterStrokeWidth;
                            ig.drawLineYear(rangeXShiftedWithSpeciesBox, baseYParent, rangeXChild, baseYChild, lineStyle, starty);
                        }
                    } else {
                        String styleStr = style.getStyle();
                        int strokeWidthIdx = styleStr.indexOf("stroke-width");
                        String beforeStrokeWidth = styleStr.substring(0, strokeWidthIdx);
                        String fromStrokeWidthStr = styleStr.substring(strokeWidthIdx, styleStr.length());
                        int firstSemiColonAfterStrokeWidthIdx = fromStrokeWidthStr.indexOf(";");
                        String afterStrokeWidth = styleStr.substring(strokeWidthIdx + firstSemiColonAfterStrokeWidthIdx + 1, styleStr.length());
                        String lineStyle = beforeStrokeWidth + "stroke-width: " + style.getWidth() + "; stroke-dasharray: 7,4; " + afterStrokeWidth;
                        ig.drawLineYear(rangeXParent, baseYParent, rangeXChild, baseYChild, lineStyle, starty);
                    }
                    if (p2.rcd.subLabel != null) {
                        width = Math.max(p2.childRange.subLabelSWI.getWidth(), p2.childRange.widthSubTree);
                        startXsubLabel = Math.max(startx, rangeXChild - width / 2.0);
                        startYsubLabel = (baseYParent + baseYChild) / 2.0;
                        if (!range.isPhenonRange && this.speciesPhenonTreeDrawing) {
                            double newStartXsubLabel = startXsubLabel;
                            ig.drawStringabsolute(p2.childRange.subLabelSWI, newStartXsubLabel, startYsubLabel, starty + 5.0, width, p2.childRange.subLabelSWI.getHeight(), 2, p2.rcd.branchColor);
                        } else {
                            ig.drawStringabsolute(p2.childRange.subLabelSWI, startXsubLabel, startYsubLabel, starty, width, p2.childRange.subLabelSWI.getHeight(), 2, p2.rcd.branchColor);
                        }
                    }
                }
                ig.pushGrouping();
                String bpS = Double.toString(p2.age);
                String beforeDecimal = bpS.split("\\.")[0];
                int bpL = beforeDecimal.length() + 2;
                String pS = Double.toString(p2.age);
                beforeDecimal = pS.split("\\.")[0];
                int pL = beforeDecimal.length() + 2;
                int pd = Math.abs(bpL - pL);
                double fontSize = Math.floor(this.fonts.getFont(1).getSize());
                boolean fPd = false;
                if (pd > 0) {
                    fPd = true;
                }
                if (!range.isPhenonRange && this.speciesPhenonTreeDrawing) {
                    double rectWidth = range.width - range.nameWidth - 50.0;
                    double rangeXShiftedWithSpeciesBox = 0.0;
                    if (enabledPhenonCounter == 0 && totalPhenon != 0) {
                        rectWidth /= (double)totalPhenon;
                    } else if (totalPhenon != enabledPhenonCounter) {
                        rectWidth = rectWidth / (double)totalPhenon * (double)enabledPhenonCounter;
                    }
                    rangeXShiftedWithSpeciesBox = rangeXParent + rectWidth;
                    if (baseYParent >= settings.topAge && baseYParent <= settings.baseAge) {
                        if (p2.childRange.rangeXCanvas > range.rangeXCanvas) {
                            p2.childRange.branchedAsLeftOrRight = "right";
                            ig.drawCircleYear(rangeXShiftedWithSpeciesBox, baseYParent, starty, 4.0, "stroke-width: 0; opacity: 0.5; fill: red;", p2, p2.childRange.branchDisabled || p2.childRange.disabled4Priority);
                            if (this.drawAgeLabel) {
                                this.drawAgeLabelForRangePoint(ig, range, p2, rangeXShiftedWithSpeciesBox - this.RangeColumnRangeAgeLabelPadding + (double)(pd * 2) + (double)fPd * ((fontSize - 6.0) / 3.0), startx, starty, heightOrig, settings);
                            }
                        } else if (p2.childRange.branchDisabled) {
                            if (circleDrawingLeftOrRight.size() > 0) {
                                if (circleDrawingLeftOrRight.get(p2.rcd.branchTo) == "right") {
                                    ig.drawCircleYear(rangeXShiftedWithSpeciesBox, baseYParent, starty, 4.0, "stroke-width: 0; opacity: 0.5; fill: red;", p2, p2.childRange.branchDisabled || p2.childRange.disabled4Priority);
                                    if (this.drawAgeLabel) {
                                        this.drawAgeLabelForRangePoint(ig, range, p2, rangeXShiftedWithSpeciesBox - this.RangeColumnRangeAgeLabelPadding + (double)(pd * 2) + (double)fPd * ((fontSize - 6.0) / 3.0), startx, starty, heightOrig, settings);
                                    }
                                } else if (circleDrawingLeftOrRight.get(p2.rcd.branchTo) == "left") {
                                    ig.drawCircleYear(rangeXParent, baseYParent, starty, 4.0, "stroke-width: 0; opacity: 0.5; fill: red;", p2, p2.childRange.branchDisabled || p2.childRange.disabled4Priority);
                                    if (this.drawAgeLabel) {
                                        this.drawAgeLabelForRangePoint(ig, range, p2, rangeXParent - this.RangeColumnRangeAgeLabelPadding + (double)(pd * 2) + (double)fPd * ((fontSize - 6.0) / 3.0), startx, starty, heightOrig, settings);
                                    }
                                }
                            }
                        } else {
                            p2.childRange.branchedAsLeftOrRight = "left";
                            ig.drawCircleYear(rangeXParent, baseYParent, starty, 4.0, "stroke-width: 0; opacity: 0.5; fill: red;", p2, p2.childRange.branchDisabled || p2.childRange.disabled4Priority);
                            if (this.drawAgeLabel) {
                                this.drawAgeLabelForRangePoint(ig, range, p2, rangeXParent - this.RangeColumnRangeAgeLabelPadding + (double)(pd * 2) + (double)fPd * ((fontSize - 6.0) / 3.0), startx, starty, heightOrig, settings);
                            }
                        }
                    }
                } else if (baseYParent >= settings.topAge && baseYParent <= settings.baseAge) {
                    ig.drawCircleYear(rangeXParent, baseYParent, starty, 4.0, "stroke-width: 0; opacity: 0.5; fill: red;", p2, p2.childRange.branchDisabled || p2.childRange.disabled4Priority);
                    if (this.drawAgeLabel) {
                        this.drawAgeLabelForRangePoint(ig, range, p2, rangeXParent - this.RangeColumnRangeAgeLabelPadding + (double)(pd * 2) + (double)fPd * ((fontSize - 6.0) / 3.0), startx, starty, heightOrig, settings);
                    }
                }
                ig.popGrouping();
            }
        }
    }

    public static void errorFamilyTree(String errMsg) {
        if (errFamilyTree == null) {
            errFamilyTree = new JFrame("Errors in Family Tree Display");
            SpringLayout layout = new SpringLayout();
            errFamilyTree.setLayout(layout);
            errFamilyTree.setDefaultCloseOperation(1);
            errFamilyTree.setSize(400, 220);
            errFamilyTreeMessage = new JTextArea(errMsg);
            errFamilyTreeMessage.setEditable(false);
            errFamilyTreeMessage.setWrapStyleWord(true);
            errFamilyTreeMessage.setLineWrap(true);
            errFamilyTreeMessage.setSize(new Dimension(380, 200));
            errFamilyTreeButton = new JButton("OK");
            errFamilyTreeButton.setSize(new Dimension(50, 20));
            errFamilyTreeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Object item = e.getSource();
                    if (item == errFamilyTreeButton) {
                        errFamilyTree.setVisible(false);
                    }
                }
            });
            errFamilyTree.add(errFamilyTreeMessage);
            errFamilyTree.add(errFamilyTreeButton);
            layout.putConstraint("West", (Component)errFamilyTreeMessage, 10, "West", (Component)errFamilyTree);
            layout.putConstraint("North", (Component)errFamilyTreeMessage, 10, "North", (Component)errFamilyTree);
            layout.putConstraint("West", (Component)errFamilyTreeButton, 170, "West", (Component)errFamilyTreeMessage);
            layout.putConstraint("North", (Component)errFamilyTreeButton, 30, "South", (Component)errFamilyTreeMessage);
            Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
            int w = RangeColumn.errFamilyTree.getSize().width;
            int h = RangeColumn.errFamilyTree.getSize().height;
            int x = (dim.width - w) / 2;
            int y = (dim.height - h) / 2;
            errFamilyTree.setLocation(x, y);
            errFamilyTree.setVisible(true);
        } else {
            errFamilyTree.setVisible(true);
        }
    }

    public static void clearErrMsgFT() {
        errFamilyTree = null;
        errFamilyTreeMessage = null;
        errFamilyTreeButton = null;
        errMsg = "";
    }

    public File openSaveTreeFileDialog() {
        FileDialog fileChooser = new FileDialog(new Frame(), "Save tree", 1);
        fileChooser.setFilenameFilter(new FilenameFilter(){

            @Override
            public boolean accept(File directory, String filename) {
                return filename.endsWith(".nwk") || filename.endsWith(".newick") || filename.endsWith(".nex") || filename.endsWith(".nexus") || filename.endsWith(".tre");
            }
        });
        fileChooser.setFile("tree.nwk");
        fileChooser.setVisible(true);
        File selFile = null;
        if (fileChooser.getFile() != null && !fileChooser.getFile().isEmpty()) {
            selFile = new File(fileChooser.getDirectory() + fileChooser.getFile());
        }
        return selFile;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        File selFile;
        Object source = e.getSource();
        if (source == this.saveTreeButton && this.ranges != null && (selFile = this.openSaveTreeFileDialog()) != null) {
            String nwk = this.T.convertToNewickFormat(this.tree, null);
            String nex = this.T.convertToNexusFormat(this.tree, null);
            String txt = this.T.convertNewickToTSC(nwk);
            String fpath = selFile.getAbsolutePath() + ".nwk";
            String fpath2 = selFile.getAbsolutePath() + ".nex";
            String fpath3 = selFile.getAbsolutePath() + ".txt";
            try {
                BufferedWriter writer = new BufferedWriter(new FileWriter(fpath));
                writer.write(nwk);
                writer.close();
                writer = new BufferedWriter(new FileWriter(fpath2));
                writer.write(nex);
                writer.close();
                writer = new BufferedWriter(new FileWriter(fpath3));
                writer.write(txt);
                writer.close();
            }
            catch (FileNotFoundException e1) {
                e1.printStackTrace();
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }
    }

    public class TableInterpreter
    extends DataColumn.TableInterpreter {
        public String[] myNames;
        public String[] myToolTips;
        public Class[] myClasses;

        public TableInterpreter() {
            super(RangeColumn.this);
            this.myNames = new String[]{"Critter", "Age", "Point Type"};
            this.myToolTips = new String[]{"Critter this range point is for", "Base age at this range point", "Specifies how the interval for which this point is the base will be drawn"};
            this.myClasses = new Class[]{String.class, Double.class, PointType.class};
            this.names = this.myNames;
            this.classes = this.myClasses;
            this.toolTips = this.myToolTips;
        }

        @Override
        public void registerEditorsAndRenderers(SpreadSheet spread) {
            spread.setDefaultEditor(PointType.class, new DefaultCellEditor(new PointType().getComboBox()));
        }

        @Override
        public Object getValue(Datapoint p, int col) {
            switch (col) {
                case 0: {
                    return p.label;
                }
                case 1: {
                    return new Double(p.baseAge);
                }
                case 2: {
                    return ((RCDatapoint)p).type;
                }
                case 3: {
                    return p.popup;
                }
            }
            return null;
        }

        @Override
        public void setValue(Datapoint p, Object value, int col) {
            if (value == null) {
                value = "";
            }
            switch (col) {
                case 0: {
                    p.label = value.toString();
                    if (p.label.compareTo("TOP") == 0) {
                        p.breaker = true;
                        break;
                    }
                    p.breaker = false;
                    break;
                }
                case 1: {
                    double age = Double.NaN;
                    if (value instanceof Double) {
                        age = (Double)value;
                    } else {
                        try {
                            age = Double.parseDouble(value.toString());
                        }
                        catch (Exception e) {
                            age = Double.NaN;
                        }
                    }
                    p.baseAge = !Double.isNaN(age) ? age : 0.0;
                    RangeColumn.this.updateMinMaxAges();
                    break;
                }
                case 2: {
                    ((RCDatapoint)p).setType(value.toString());
                }
            }
        }

        public class PointType
        extends ComboBoxRenderer {
            private static final long serialVersionUID = 1L;

            public PointType() {
                super(new String[]{"sample", "LAD", "missing", "rare", "conjectured", "common", "frequent", "abundant", "flood"});
            }
        }
    }

    protected static class RangeComparator
    implements Comparator {
        public static final int FIRST_OCCURANCE = 1;
        public static final int LAST_OCCURANCE = 2;
        public static final int ALPHABETICAL = 3;
        public static final int OTHER = 0;
        int type;

        public RangeComparator(int type) {
            this.type = type;
        }

        public int compare(Object arg0, Object arg1) {
            Range left = (Range)arg0;
            Range right = (Range)arg1;
            if (left == null || right == null) {
                return 0;
            }
            int result = this.compareByType(left, right, this.type);
            if (result == 0 && this.type == 1) {
                result = -this.compareByType(left, right, 2);
            } else if (result == 0 && this.type == 2) {
                result = -this.compareByType(left, right, 1);
            }
            if (result == 0 && this.type != 3) {
                result = this.compareByType(left, right, 3);
            }
            if (result == 0) {
                result = this.compareByType(left, right, 0);
            }
            return result;
        }

        public int compareByType(Range left, Range right, int type) {
            if (type == 1) {
                if (Double.isNaN(left.base) && Double.isNaN(right.base)) {
                    return 0;
                }
                if (Double.isNaN(left.base)) {
                    return -1;
                }
                if (Double.isNaN(right.base)) {
                    return 1;
                }
                double result = right.base - left.base;
                if (result > -1.0E-6 && result < 1.0E-6) {
                    return 0;
                }
                if (result > 0.0) {
                    return 1;
                }
                return -1;
            }
            if (type == 2) {
                if (Double.isNaN(left.top) && Double.isNaN(right.top)) {
                    return 0;
                }
                if (Double.isNaN(left.top)) {
                    return -1;
                }
                if (Double.isNaN(right.top)) {
                    return 1;
                }
                double result = left.top - right.top;
                if (result > -1.0E-6 && result < 1.0E-6) {
                    return 0;
                }
                if (result > 0.0) {
                    return 1;
                }
                return -1;
            }
            if (type == 3) {
                return left.name.compareToIgnoreCase(right.name);
            }
            return left.mySerial - right.mySerial;
        }
    }

    public class Range {
        double base = Double.NaN;
        double top = Double.NaN;
        String name;
        String popup = "";
        int mySerial;
        SortedSet points = Collections.synchronizedSortedSet(new TreeSet(new RangePointComparator()));
        Map ageLabelSWIs;
        StringWrappingInfo nameSWI;
        double width = 0.0;
        double widthSubTree = 0.0;
        double lineX = 0.0;
        double ageLabelRightX = 0.0;
        Range parent = null;
        Range containedBySpeciesRange = null;
        List<Range> children = new ArrayList<Range>();
        int location = Integer.MAX_VALUE;
        boolean rangeTraversed4Location = false;
        double rangeXCanvas;
        double baseofRange;
        boolean branchDisabled = false;
        boolean disabled4Priority = false;
        boolean overridePriority = false;
        private int rangePrio = 10;
        String branchInfoTemp = "";
        public ArrayList<CriticalErrors> flaggingBranchBelowMsg = new ArrayList();
        public ArrayList<CriticalErrors> flaggingBranchAboveMsg = new ArrayList();
        private boolean flaggingBranchBelowErr = false;
        private boolean flaggingBranchAboveErr = false;
        public double branchBase = Double.NaN;
        public double branchTop = Double.NaN;
        public String branchColor = "rgb(0,0,0)";
        String subLabel = null;
        StringWrappingInfo subLabelSWI;
        double rangeWidth = 0.0;
        double nameWidth;
        double nameHeight;
        LabelLocation labelloc = LabelLocation.UNDECIDED;
        public boolean alreadyInsideTree = false;
        public boolean isPhenonRange = false;
        public String speciesNameWithFinalTop = null;
        public ArrayList<Range> phenonsContainingSpecies = new ArrayList();
        public String branchedAsLeftOrRight = null;
        public int topSymbol;
        public int baseSymbol;
        public static final int PHENON_FINAL_TOP_LIVING_SYMBOL = 0;
        public static final int PHENON_FINAL_TOP_SYMBOL = 1;
        public static final int PHENON_BASE_SYMBOL = 2;
        public static final int PHENON_TOP_CONTINUATION_SYMBOL = 3;
        public static final int PHENON_BASE_CONTINUATION_SYMBOL = 4;
        public boolean speciesBoxBranchIsVisible = true;

        public Range() {
            this.mySerial = RangeColumn.this.rangeSerial++;
            if (RangeColumn.this.drawAgeLabel) {
                this.ageLabelSWIs = Collections.synchronizedMap(new HashMap());
            }
        }

        public Range(Range r) {
            this.ageLabelRightX = r.ageLabelRightX;
            this.ageLabelSWIs = r.ageLabelSWIs != null && !r.ageLabelSWIs.isEmpty() ? Collections.synchronizedMap(r.ageLabelSWIs) : r.ageLabelSWIs;
            this.base = r.base;
            this.baseofRange = r.baseofRange;
            this.baseSymbol = r.baseSymbol;
            this.branchBase = r.branchBase;
            this.branchColor = r.branchColor;
            this.branchDisabled = r.branchDisabled;
            this.branchInfoTemp = r.branchInfoTemp;
            this.branchTop = r.branchTop;
            if (r.children != null) {
                for (Range rn : r.children) {
                    this.children.add(rn);
                }
            }
            this.containedBySpeciesRange = r.containedBySpeciesRange;
            this.disabled4Priority = r.disabled4Priority;
            this.flaggingBranchAboveErr = r.flaggingBranchAboveErr;
            if (r.flaggingBranchAboveMsg != null) {
                for (CriticalErrors ce : r.flaggingBranchAboveMsg) {
                    this.flaggingBranchAboveMsg.add(ce);
                }
            }
            this.flaggingBranchBelowErr = r.flaggingBranchAboveErr;
            if (r.flaggingBranchBelowMsg != null) {
                for (CriticalErrors ce : r.flaggingBranchBelowMsg) {
                    this.flaggingBranchBelowMsg.add(ce);
                }
            }
            this.isPhenonRange = r.isPhenonRange;
            this.labelloc = r.labelloc;
            this.lineX = r.lineX;
            this.location = r.location;
            this.mySerial = r.mySerial;
            this.name = r.name;
            this.nameHeight = r.nameHeight;
            this.nameSWI = r.nameSWI;
            this.nameWidth = r.nameWidth;
            this.overridePriority = r.overridePriority;
            this.parent = r.parent;
            if (r.points != null && !r.points.isEmpty()) {
                for (RangePoint p : r.points) {
                    this.points.add(p);
                }
            } else {
                this.points = r.points;
            }
            this.popup = r.popup;
            this.rangePrio = r.rangePrio;
            this.rangeTraversed4Location = r.rangeTraversed4Location;
            this.rangeWidth = r.rangeWidth;
            this.rangeXCanvas = r.rangeXCanvas;
            this.speciesNameWithFinalTop = r.speciesNameWithFinalTop;
            if (r.phenonsContainingSpecies != null && !r.phenonsContainingSpecies.isEmpty()) {
                for (Range tr : r.phenonsContainingSpecies) {
                    this.phenonsContainingSpecies.add(tr);
                }
            }
            this.subLabel = r.subLabel;
            this.subLabelSWI = r.subLabelSWI;
            this.top = r.top;
            this.topSymbol = r.topSymbol;
            this.width = r.width;
            this.widthSubTree = r.widthSubTree;
        }

        public void addPoint(RangePoint p) {
            CriticalErrors error;
            Iterator<CriticalErrors> iter;
            if (Double.isNaN(this.base) || p.age > this.base || p.rcd.branch) {
                if (p.rcd.branch) {
                    if (Double.isNaN(this.branchBase) || p.age > this.branchBase) {
                        this.branchBase = p.age;
                    }
                    if (Double.isNaN(this.base) || p.age > this.base) {
                        this.flaggingBranchBelowErr = true;
                        if (this.flaggingBranchBelowMsg == null) {
                            this.flaggingBranchBelowMsg = new ArrayList();
                        }
                        this.flaggingBranchBelowMsg.add(new CriticalErrors(p.age, p.name.split(" <img")[0], p.rcd.branchTo));
                    }
                } else {
                    this.base = p.age;
                    if (this.flaggingBranchBelowMsg != null) {
                        iter = this.flaggingBranchBelowMsg.iterator();
                        while (iter.hasNext()) {
                            error = iter.next();
                            if (!(error.age <= p.age)) continue;
                            iter.remove();
                        }
                        if (this.flaggingBranchBelowMsg.isEmpty()) {
                            this.flaggingBranchBelowErr = false;
                        }
                    } else {
                        this.flaggingBranchBelowErr = false;
                    }
                }
            }
            if (Double.isNaN(this.top) || p.age < this.top || p.rcd.branch) {
                if (p.rcd.branch) {
                    if (Double.isNaN(this.branchTop) || p.age < this.branchTop) {
                        this.branchTop = p.age;
                    }
                    if (Double.isNaN(this.top) || p.age < this.top) {
                        this.flaggingBranchAboveErr = true;
                        if (this.flaggingBranchAboveMsg == null) {
                            this.flaggingBranchAboveMsg = new ArrayList();
                        }
                        this.flaggingBranchAboveMsg.add(new CriticalErrors(p.age, p.name.split(" <img")[0], p.rcd.branchTo));
                    }
                } else {
                    this.top = p.age;
                    if (this.flaggingBranchAboveMsg != null) {
                        iter = this.flaggingBranchAboveMsg.iterator();
                        while (iter.hasNext()) {
                            error = iter.next();
                            if (!(error.age >= p.age)) continue;
                            iter.remove();
                        }
                        if (this.flaggingBranchAboveMsg.isEmpty()) {
                            this.flaggingBranchAboveErr = false;
                        }
                    } else {
                        this.flaggingBranchAboveErr = false;
                    }
                }
            }
            this.points.add(p);
            this.rangeWidth = Math.max(this.rangeWidth, RangeColumn.getRangeStyle((String)p.type).width);
        }

        public void setNotIncludeBranch() {
            this.branchDisabled = !this.branchDisabled;
        }

        public boolean getNotIncludeBranch() {
            boolean integratedTreeDrawing = false;
            if (RangeColumn.this.rangesWithoutSplit.size() < RangeColumn.this.extendedRanges.size()) {
                integratedTreeDrawing = true;
            }
            if (integratedTreeDrawing && !this.isPhenonRange) {
                speciesBoxBranchClicked = true;
                LinkedList<Range> speciesRangeQueue = new LinkedList<Range>();
                speciesRangeQueue.add(this);
                while (!speciesRangeQueue.isEmpty()) {
                    Range thisRange = (Range)speciesRangeQueue.poll();
                    for (Range childSpeciesRange : thisRange.children) {
                        speciesRangeQueue.add(childSpeciesRange);
                    }
                    if (thisRange.phenonsContainingSpecies.size() <= 0) continue;
                    for (Range phenonRange : thisRange.phenonsContainingSpecies) {
                        for (Range r : RangeColumn.this.extendedRanges) {
                            if (!r.isPhenonRange || !phenonRange.name.equalsIgnoreCase(r.name) || phenonRange.top != r.top || phenonRange.base != r.base) continue;
                            r.branchDisabled = r.speciesBoxBranchIsVisible;
                            r.speciesBoxBranchIsVisible = !r.speciesBoxBranchIsVisible;
                        }
                    }
                }
            }
            return !this.branchDisabled && !this.disabled4Priority;
        }

        public double calculateWidth(ImageGenerator ig) {
            double maxAgeLabelWidth = 0.0;
            this.nameSWI = !this.isPhenonRange ? ig.getSWIOneLine(this.name, RangeColumn.this.fonts.getFont(14), 4, RangeColumn.this.fileInfo) : ig.getSWIOneLine(this.name, RangeColumn.this.fonts.getFont(9), 4, RangeColumn.this.fileInfo);
            if (RangeColumn.this.drawAgeLabel) {
                for (RangePoint p : this.points) {
                    StringWrappingInfo swi = ig.getSWIOneLine(RangeColumn.this.getAgeLabel(p.age), RangeColumn.this.fonts.getFont(1), 1, RangeColumn.this.fileInfo);
                    this.ageLabelSWIs.put(p, swi);
                    double lwidth = swi.getWidth();
                    if (!(lwidth > maxAgeLabelWidth)) continue;
                    maxAgeLabelWidth = lwidth;
                }
            }
            this.nameWidth = this.nameSWI.getWidth();
            this.nameHeight = this.nameSWI.getHeight();
            double rangePlusAgeLabels = this.rangeWidth + maxAgeLabelWidth;
            this.ageLabelRightX = maxAgeLabelWidth;
            if (this.labelloc == LabelLocation.LEFT_SIDE || this.labelloc == LabelLocation.RESIZE) {
                this.lineX = this.ageLabelRightX - this.rangeWidth / 2.0;
                this.width = rangePlusAgeLabels + 0.5 + this.nameWidth;
            } else if (this.labelloc == LabelLocation.RIGHT_SIDE || this.labelloc == LabelLocation.RESIZE) {
                this.lineX = this.ageLabelRightX + this.rangeWidth / 2.0;
                this.width = rangePlusAgeLabels + 0.5 + this.nameWidth;
            } else {
                this.lineX = this.ageLabelRightX + Math.max(this.rangeWidth / 2.0, this.nameWidth / 2.0);
                this.width = Math.max(this.nameWidth, rangePlusAgeLabels);
            }
            if (!this.isPhenonRange) {
                this.width += this.nameWidth + 50.0;
            }
            return this.width;
        }

        public double getWidth() {
            return this.width;
        }

        public double getLineX() {
            return this.lineX;
        }

        public double getAgeLabelRightX() {
            return this.ageLabelRightX;
        }

        public StringWrappingInfo getAgeLabelSWI(RangePoint p) {
            StringWrappingInfo prevSWI = (StringWrappingInfo)this.ageLabelSWIs.get(p);
            String ages = prevSWI.s.getOriginalString();
            StringWrappingInfo newSWI = prevSWI;
            String[] splittedString = ages.split("\\.");
            if (splittedString.length > 0) {
                String beforeDecS = splittedString[0];
                String newAge = "";
                if (splittedString.length == 2) {
                    String afterDecS = splittedString[1];
                    if (afterDecS.length() == 1) {
                        afterDecS = afterDecS + "0";
                    } else if (afterDecS.length() == 0) {
                        afterDecS = afterDecS + "00";
                    }
                    newAge = beforeDecS + "." + afterDecS;
                } else if (splittedString.length == 1) {
                    newAge = beforeDecS + ".00";
                }
                if (newAge != "") {
                    newSWI = new StringWrappingInfo(prevSWI.g, new RichText(newAge, null), prevSWI.origFont, prevSWI.getOrientation());
                    newSWI.makeOneLine();
                    newSWI.useOriginalLineBreaks();
                }
            }
            return newSWI;
        }

        public int locAttribute(int upperbound) {
            int i;
            this.widthSubTree = 0.0;
            int numChilds = this.children != null ? this.children.size() : 0;
            int minLocation = upperbound;
            Range range = null;
            for (i = 0; i < numChilds; i += 2) {
                range = this.children.get((numChilds - i - 1) / 2 * 2);
                if (range.branchDisabled) continue;
                minLocation = range.locAttribute(minLocation);
                if (!(this.widthSubTree < range.width)) continue;
                this.widthSubTree = range.width;
            }
            int count = 0;
            if (!this.disabled4Priority) {
                this.location = minLocation == Integer.MAX_VALUE ? 0 : minLocation + count - 1;
                if (count == 0) {
                    minLocation = this.location;
                }
                this.widthSubTree += this.width;
            }
            this.rangeTraversed4Location = true;
            double widthSubTreeRight = 0.0;
            for (i = 1; i < numChilds; i += 2) {
                range = this.children.get(i);
                if (range.branchDisabled) continue;
                minLocation = range.locAttribute(minLocation);
                if (!(widthSubTreeRight < range.width)) continue;
                widthSubTreeRight = range.width;
            }
            this.widthSubTree += widthSubTreeRight;
            return minLocation;
        }

        public void printRangeInfo() {
            System.out.println("Name = " + this.name);
            System.out.println("Base = " + this.base);
            System.out.println("Top =" + this.top);
            if (this.containedBySpeciesRange != null) {
                System.out.println("Contained by Species Range = " + this.containedBySpeciesRange.name);
            }
            System.out.println("Number of Phenons = " + this.phenonsContainingSpecies.size());
            System.out.println("Number of Points = " + this.points.size());
            Iterator iterPoint = this.points.iterator();
            int count = 0;
            while (iterPoint.hasNext()) {
                RangePoint p = (RangePoint)iterPoint.next();
                System.out.println("--- Point " + ++count + ":");
                p.printRangePointInfo();
                System.out.println();
            }
            System.out.println("Age Label Right X = " + this.ageLabelRightX);
            System.out.println("Base Of Range = " + this.baseofRange);
            System.out.println("Base Symbol = " + this.baseSymbol);
            System.out.println("Branch Base = " + this.branchBase);
            System.out.println("Branch Color = " + this.branchColor);
            System.out.println("Branch Info Temp = " + this.branchInfoTemp);
            System.out.println("Branch Top = " + this.branchTop);
            System.out.println("Line X = " + this.lineX);
            System.out.println("Location = " + this.location);
            System.out.println("My Serial = " + this.mySerial);
            System.out.println("Name Height = " + this.nameHeight);
            System.out.println("Name Width = " + this.nameWidth);
            System.out.println("Popup = " + this.popup);
            System.out.println("Range Priority = " + this.rangePrio);
            System.out.println("Range Width = " + this.rangeWidth);
            System.out.println("Range X Canvas = " + this.rangeXCanvas);
            System.out.println("Species Name With Final Top = " + this.speciesNameWithFinalTop);
            System.out.println("SubLabel = " + this.subLabel);
            System.out.println("Top Symbol = " + this.topSymbol);
            System.out.println("Width = " + this.width);
            System.out.println("Width Sub Tree = " + this.widthSubTree);
            System.out.println();
        }

        public class CriticalErrors {
            double age = Double.NaN;
            public String range = "";
            public String branchTo = "";

            public CriticalErrors(double age, String parent, String child) {
                this.age = age;
                this.range = parent;
                this.branchTo = child;
            }
        }
    }

    protected static class RangePointComparator
    implements Comparator {
        protected RangePointComparator() {
        }

        public int compare(Object arg0, Object arg1) {
            RangePoint left = (RangePoint)arg0;
            RangePoint right = (RangePoint)arg1;
            if (left == null || right == null) {
                return 0;
            }
            double result = left.age - right.age;
            if (result == 0.0 || result > 0.0 && result < 1.0E-6 || result < 0.0 && result > -1.0E-6) {
                return left.mySerial - right.mySerial;
            }
            if (result < 0.0) {
                return -1;
            }
            return 1;
        }
    }

    public class RangePoint
    implements HyperlinkListener {
        double age;
        String type;
        String name;
        String popup;
        boolean top = false;
        boolean used = false;
        int mySerial = 0;
        public Range childRange = null;
        protected boolean childOutofRange = false;
        public RCDatapoint rcd = null;
        public JFrame popupFrame = null;
        public JEditorPane contentPane = null;

        public RangePoint() {
            this.mySerial = RangeColumn.this.rangePointSerial++;
        }

        public RangePoint copy() {
            RangePoint ret = new RangePoint();
            ret.age = this.age;
            ret.childOutofRange = this.childOutofRange;
            ret.childRange = this.childRange;
            ret.contentPane = this.contentPane;
            ret.mySerial = ++RangeColumn.this.rangePointSerial;
            ret.name = this.name;
            ret.popup = this.popup;
            ret.popupFrame = this.popupFrame;
            ret.rcd = this.rcd.copy();
            ret.top = this.top;
            ret.type = this.type;
            ret.used = this.used;
            return ret;
        }

        public void printRangePointInfo() {
            System.out.println("Age = " + this.age);
            System.out.println("Type = " + this.type);
            System.out.println("Name = " + this.name);
            System.out.println("Popup = " + this.popup);
            System.out.println("Top = " + this.top);
            System.out.println("Used = " + this.used);
            System.out.println("My Serial = " + this.mySerial);
            System.out.println("Child Range = " + this.childRange);
            System.out.println("Child Out Of Range = " + this.childOutofRange);
            System.out.println("RCDataPoint = " + this.rcd);
            System.out.println("RCDataPointInfo = ");
            this.rcd.printDataPointInfo();
        }

        public void setResetIncludeBranch(boolean notInclude) {
            System.out.println("PRIORITY CHECK: setResetIncludeBranch started, notInclude = " + notInclude);
            if (this.rcd != null) {
                this.rcd.notInclude = notInclude;
            }
            if (!notInclude) {
                System.out.println("PRIORITY CHECK: setResetIncludeBranch notInclude is FALSE, setting rcd.overridePriority to TRUE");
                this.rcd.overridePriority = true;
            } else {
                this.rcd.overridePriority = false;
            }
        }

        public void handlePopUps(int xCoordinate, int yCoordinate) {
            if (this.popupFrame == null) {
                this.popupFrame = new JFrame("Branch Info");
                this.popupFrame.setDefaultCloseOperation(1);
                this.popupFrame.setSize(300, 200);
                this.popupFrame.setLocation(xCoordinate, yCoordinate + 100);
                this.contentPane = new JEditorPane();
                this.contentPane.setEditable(false);
                this.contentPane.setContentType("text/html");
                if (this.popup == null) {
                    this.popup = "No Branch Information present in Datapack";
                }
                this.contentPane.setText(this.popup);
                this.contentPane.addHyperlinkListener(this);
                this.popupFrame.getContentPane().add(this.contentPane);
                this.popupFrame.setVisible(true);
            } else if (this.popupFrame.isVisible()) {
                this.popupFrame.setVisible(false);
            } else {
                this.popupFrame.setVisible(true);
            }
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent event) {
            if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                TSCreator.launchBrowser(event.getURL().toExternalForm());
            }
        }
    }

    public static class RangeStyle {
        protected String style;
        protected double width;

        public RangeStyle(String style, double width) {
            this.style = style;
            this.width = width;
        }

        public String getStyle() {
            return "stroke-width: " + this.width + "; " + this.style;
        }

        public double getWidth() {
            return this.width;
        }
    }

    public static enum LabelLocation {
        HEADER,
        LEFT_SIDE,
        RIGHT_SIDE,
        TOP,
        BOTTOM,
        RESIZE,
        UNDECIDED;

    }

    protected class RangeSize {
        protected Double base;
        protected Double top;
        protected Double maxWidth;
        protected Range range = null;

        RangeSize(Double base, Double top, Double maxWidth, Range range) {
            this.base = base;
            this.top = top;
            this.range = range;
            this.maxWidth = maxWidth;
        }
    }

    public static class RCDatapoint
    extends Datapoint {
        public String type;
        public String speciesOrPhenon = null;
        public String speciesWithFinalTopOfPhenon = null;
        public boolean branch = false;
        public boolean branchClicked = false;
        public String branchTo = null;
        public String subLabel = null;
        public String branchLabel = null;
        public Color branchColor = null;
        public int branchPrio = 10;
        public boolean notInclude = false;
        public boolean overridePriority = false;
        public boolean splitPhenonBranch = false;

        public RCDatapoint() {
        }

        public RCDatapoint(Datapoint dp) {
            super(dp);
        }

        @Override
        public RCDatapoint copy() {
            RCDatapoint ret = new RCDatapoint(this);
            ret.type = this.type;
            ret.branch = this.branch;
            ret.branchClicked = this.branchClicked;
            ret.branchTo = this.branchTo;
            ret.subLabel = this.subLabel;
            ret.branchLabel = this.branchLabel;
            ret.branchColor = this.branchColor;
            ret.branchPrio = this.branchPrio;
            return ret;
        }

        public void setType(String type) {
            if (type == null) {
                type = null;
                this.branch = false;
                return;
            }
            if (type.toLowerCase().startsWith("branch")) {
                this.branch = true;
                type = "branch";
            } else {
                this.type = type;
            }
        }

        public void printDataPointInfo() {
            System.out.println();
            System.out.println("Printing Data Point Info.");
            System.out.println("Base age =" + this.baseAge);
            System.out.println("Branch label =" + this.branchLabel);
            System.out.println("Branch priority =" + this.branchPrio);
            System.out.println("Branch clicked =" + this.branchClicked);
            System.out.println("Branch to =" + this.branchTo);
            System.out.println("Direction =" + this.direction);
            System.out.println("Label =" + this.label);
            System.out.println("Line Type =" + this.lineType);
            System.out.println("Serial = " + this.mySerial);
            System.out.println("Popup = " + this.popup);
            System.out.println("Priority = " + this.priority);
            System.out.println("Section = " + this.section);
            System.out.println("Series = " + this.series);
            System.out.println("SpeciesOrPhenon = " + this.speciesOrPhenon);
            System.out.println("SpeciesWithFinalTop = " + this.speciesWithFinalTopOfPhenon);
            System.out.println("SubLabel = " + this.subLabel);
            System.out.println("Type = " + this.type);
            System.out.println("uncertainty = " + this.uncertainty);
            System.out.println("*****Range Data Point Info Printing Completed.*****");
            System.out.println();
        }
    }
}

