/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.ErrorHandler;
import gui.WorkerThread;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import util.FileUtils;

public class TSCAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    ActionListener listener;
    Object lock = null;
    static EnablerThread enablerThread = null;
    Enabler enabler = null;
    List doWhenDone = null;
    protected String origText;
    protected String origIconFile;
    protected String origDescription;
    protected char origAccelerator;
    protected boolean origHadAccelerator = false;

    public TSCAction(ActionListener listener, String text, String iconFile, String description) {
        super(text, FileUtils.getImageIcon(iconFile));
        this.listener = listener;
        this.putValue("ShortDescription", description);
        this.origText = text;
        this.origIconFile = iconFile;
        this.origDescription = description;
    }

    public TSCAction(ActionListener listener, String text, String iconFile, String description, char accelerator) {
        this(listener, text, iconFile, description);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke((int)accelerator, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.origAccelerator = accelerator;
        this.origHadAccelerator = true;
    }

    public TSCAction(ActionListener listener, TSCAction copyFrom) {
        this(listener, copyFrom.origText, copyFrom.origIconFile, copyFrom.origDescription);
        if (copyFrom.origHadAccelerator) {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke((int)copyFrom.origAccelerator, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            this.origAccelerator = copyFrom.origAccelerator;
            this.origHadAccelerator = true;
        }
    }

    public void useThread(Object lockObject) {
        this.lock = lockObject;
    }

    public void doWhenDone(TSCAction a) {
        if (this.doWhenDone == null) {
            this.doWhenDone = Collections.synchronizedList(new Vector());
        }
        this.doWhenDone.add(a);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.lock == null) {
            this.doAction();
        } else {
            WorkerThread wt = new WorkerThread(this);
            wt.start();
        }
    }

    public void doAction() {
        try {
            ActionEvent evt = new ActionEvent(this, 1001, null);
            this.listener.actionPerformed(evt);
        }
        catch (Exception ex) {
            ErrorHandler.showError(ex, null, "Error", 3);
        }
        if (this.doWhenDone != null) {
            Iterator iter = this.doWhenDone.iterator();
            while (iter.hasNext()) {
                TSCAction a = (TSCAction)iter.next();
                a.actionPerformed(null);
                iter.remove();
            }
        }
    }

    public void setText(String t) {
        this.putValue("Name", t);
    }

    public void setDescription(String t) {
        this.putValue("ShortDescription", t);
    }

    public String getText() {
        return this.getValue("Name").toString();
    }

    public void setTimedEnabler(Enabler en) {
        this.enabler = en;
        if (enablerThread == null) {
            enablerThread = new EnablerThread();
            enablerThread.start();
        }
        enablerThread.addAction(this);
    }

    protected void queryEnablers() {
        this.setEnabled(this.enabler.isEnabled());
    }

    protected static class EnablerThread
    extends Thread {
        Vector actions = new Vector();

        public EnablerThread() {
            super("TSCAction.EnablerThread");
        }

        public void addAction(TSCAction a) {
            this.actions.remove(a);
            this.actions.add(a);
        }

        @Override
        public void run() {
            block2: while (true) {
                try {
                    EnablerThread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Iterator iter = this.actions.iterator();
                while (true) {
                    if (!iter.hasNext()) continue block2;
                    TSCAction a = (TSCAction)iter.next();
                    a.queryEnablers();
                }
                break;
            }
        }
    }

    public static interface Enabler {
        public boolean isEnabled();
    }
}

