/*
 * Decompiled with CFR 0.152.
 */
package gui;

import com.google.gson.stream.JsonWriter;
import datastore.Coloring;
import datastore.DataColumn;
import datastore.DatafileCrypto;
import datastore.Datastore;
import datastore.MetaColumn;
import datastore.loader.ParseException;
import datastore.loader.SimpleCharStream;
import gui.ActivationChecker;
import gui.AutoGenOptions;
import gui.ColumnImageGenerator;
import gui.ErrorHandler;
import gui.ExtensionFileFilter;
import gui.GTSVersion;
import gui.HTMLViewerDialog;
import gui.HeaderPanel;
import gui.ImageGenerator;
import gui.ImageSizeDialog;
import gui.LASConverter;
import gui.LASConverterGUI;
import gui.Language;
import gui.PasswordDialog;
import gui.PatternViewer;
import gui.RasterSave;
import gui.Settings;
import gui.TSCAction;
import gui.TSCLinkActivationListener;
import gui.TSCSVGCanvas;
import gui.TSCSVGScrollPane;
import gui.UnicodeInputStream;
import gui.WebsiteInfoDialog;
import gui.crossplot.CrossplotFrame;
import gui.editor.DataEditor;
import gui.settings.SelectedTimes;
import gui.transect.TemplateGen;
import gui.transect.TemplateLoader;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.SpringLayout;
import javax.swing.UIManager;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.text.html.HTMLDocument;
import map.MapInformation;
import org.apache.batik.swing.gvt.GVTTreeRendererAdapter;
import org.apache.batik.swing.gvt.GVTTreeRendererEvent;
import org.apache.batik.swing.svg.GVTTreeBuilderAdapter;
import org.apache.batik.swing.svg.GVTTreeBuilderEvent;
import org.apache.batik.swing.svg.SVGDocumentLoaderAdapter;
import org.apache.batik.swing.svg.SVGDocumentLoaderEvent;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGDocument;
import path.ResPath;
import util.CSVReader;
import util.Converter;
import util.Dater;
import util.Debug;
import util.FileUtils;
import util.HTMLPreprocessor;
import util.JavaVMOptions;
import util.ProgramInfo;

public class TSCreator
extends JApplet
implements ActionListener {
    public static final String MD5_HASH_OF_PASSWORD = "97aefc1fe31b8e1872308de56bd4eb39";
    public static boolean REQUIRE_PASSWORD = false;
    public static boolean PASSWORD_ENTERED_CORRECTLY = false;
    public static boolean ENABLE_3D = false;
    public static boolean ENABLE_DATAPACK_ENCRYPTION = true;
    public static final String MAX_MEMORY = "1G";
    public static final int NUMBER_CHARS_LIMIT_PUBLIC = 3000;
    public static final int NUMBER_DATAPACKS_LIMIT_PUBLIC = 3;
    private static int numDatapacksAdded = 0;
    private JFrame getPRO = null;
    private JTextArea getPROMessage = null;
    private JButton getPROButton = null;
    public static final int DEBUGLEVEL = 1;
    public static String DEFAULT_DATA_FILE = ResPath.getRootlessPath("datapacks.default_data_filename");
    public static String DATAPACK_INFO = ResPath.getRootlessPath("datapacks.datapack_info");
    public static String BUILT_IN_DATA_FILE = null;
    public static boolean command_line_datapack_flag = false;
    public static List<String> command_line_datapacks = null;
    public static int command_line_datapack_id = 0;
    public static String SETTINGS_FILE = null;
    public static boolean command_line_settings_flag = false;
    public static final String DEFAULT_COLORING_FILE = ResPath.getPath("settings_xml.coloring");
    public static String DEFAULT_SETTINGS_FILE = ResPath.getPath("settings_xml.default_settings");
    public static boolean SAVE_COMPLETE_SETTINGS = false;
    public static String autoSaveFile = null;
    public static AutoGenOptions autoGenOptions = null;
    public static boolean isApplet = false;
    public static boolean isActivationRequired = false;
    public static String activationVersionString = null;
    public static boolean allowDefaultDatafilePasswordCancel = false;
    public static final int NORMAL = 1;
    public static final int SUCCESS = 2;
    public static final int ERROR = 3;
    public static final int WARNING = 4;
    public static final int GENERATING = 1;
    public static final int LOADING = 2;
    public static final int SAVING = 3;
    public static volatile TSCreator curCreator = null;
    public static final boolean showMapStuff = true;
    public static boolean showSearchPane = false;
    public static Datastore db;
    public DataEditor editor = null;
    public static File fileChooserPath;
    public static Settings settings;
    public static Settings settings1;
    public static boolean topFlag;
    public static boolean baseFlag;
    public static boolean vertFlag;
    public CrossplotFrame crossplotFrame;
    TSCSVGCanvas displayCanvas;
    TSCSVGScrollPane displayCanvasPane;
    public SVGDocument svgImage;
    ImageGenerator ig = null;
    ColumnImageGenerator columnImageGenerator = null;
    JToolBar toolBar;
    JPanel mainView;
    JEditorPane htmlView;
    CardLayout mainViewLayout;
    public static JFrame tscFrame;
    Container contentPane;
    JPanel displayPanel;
    JPanel topPanel;
    JLabel info;
    File selFile = null;
    String extension = null;
    String[] pathArray = null;
    public static File depthFile;
    public static String depthFileUnits;
    public static boolean TIMELINE;
    public TSCAction loadReplaceWithBuiltInAction = new TSCAction(this, Language.translate("Replace Data with Default Datapack", true), null, Language.translate("Load data that came with the program while clearing everything currently loaded.", true));
    public TSCAction loadAddWithBuiltInAction = new TSCAction(this, Language.translate("Re-add Default Datapack", true), null, Language.translate("Load data from built in datapack and append to the currently loaded data set.", true));
    public TSCAction loadAddFromFileAction = new TSCAction(this, Language.translate("Add Datapack", true), null, Language.translate("Load data from a file and append to the currently loaded data set.", true));
    public TSCAction loadReplaceWithFileAction = new TSCAction(this, Language.translate("Replace Data with Datapack", true), null, Language.translate("Load data from a file while clearing everything currently loaded.", true));
    public TSCAction clearAction = new TSCAction(this, Language.translate("Clear", true), null, Language.translate("Clear the currently loaded data.", true));
    public TSCAction viewPatternsAction = new TSCAction(this, Language.translate("View Loaded Patterns", true), null, Language.translate("Shows the currently available patterns.", true));
    public TSCAction addPatternsAction = new TSCAction(this, Language.translate("Add Patterns", true), null, Language.translate("Adds patterns from the selected.", true));
    public TSCAction showGTSversion = new TSCAction(this, Language.translate("GTS Version", true), null, Language.translate("Shows what Geological Time Scale is used.", true));
    public TSCAction saveAsAction = new TSCAction(this, Language.translate("Save Datapack As", true), null, Language.translate("Save current data into a single datapack.", true));
    public TSCAction saveAsJsonAction = new TSCAction(this, Language.translate("Save Datapack As Json", true), null, Language.translate("Save current data into a single datapack in json.", true));
    public TSCAction saveSVGAction = new TSCAction(this, Language.translate("Save SVG", true), null, Language.translate("Save the generated image to an SVG file.", true));
    public TSCAction saveRasterAction = new TSCAction(this, Language.translate("Save Bitmap (PNG/JPG)", true), null, Language.translate("Save the generated image to a raster bitmap file.", true));
    public TSCAction savePDFAction = new TSCAction(this, Language.translate("Save PDF", true), null, Language.translate("Save the generated image to a PDF file.", true));
    public TSCAction exitAction = new TSCAction(this, Language.translate("Exit", true), null, Language.translate("Exit", true));
    public TSCAction loadDefaultColoringAction = new TSCAction(this, Language.translate("Load Default Colorings", true), null, Language.translate("Load the default USGS and UNESCO color schemes.", true));
    protected TSCAction appletDoAfterLoading = new TSCAction(this, Language.translate("applet do after loading", true), null, Language.translate("Run this if this is an applet and we're done loading the datafile.", true));
    public TSCAction encryptDataAction = new TSCAction(this, Language.translate("Protect a datafile...", true), null, Language.translate("Password protect a datafile.", true));
    public TSCAction convertDataPackAction = new TSCAction(this, Language.translate("Convert Datapack to sqlite database...", true), null, Language.translate("Convert datapack to sqlite database.", true));
    public TSCAction editDataAction = new TSCAction(this, Language.translate("Edit column data...", true), null, Language.translate("View/Edit the raw column data.", true));
    public TSCAction saveTemplateAction = new TSCAction(this, Language.translate("Save Transect Template...", true), null, Language.translate("Create and export an SVG image which can be used as a template to create a transect column in a graphical drawing program.", true));
    public TSCAction loadTemplateAction = new TSCAction(this, Language.translate("Load Transect Column from Template...", true), null, "");
    public TSCAction editCrittersAction = new TSCAction(this, Language.translate("Edit Fossils...", true), null, Language.translate("View/Edit the raw column data.", true));
    public TSCAction createCrossplotAction = new TSCAction(this, Language.translate("Create Crossplot", true), null, Language.translate("Create an Age/Depth plot.", true));
    public TSCAction addSomeRascFileAction = null;
    public TSCAction settingsAction = new TSCAction(this, Language.translate("Settings...", true), null, Language.translate("Show the settings dialog box.", true));
    public TSCAction generateAction = new TSCAction(this, Language.translate("Generate Chart", true), null, Language.translate("Generate the image based on the current settings.", true));
    public TSCAction imageSizeAction = new TSCAction(this, Language.translate("Image Size", true), null, Language.translate("View/Change the physical size of the generated image.", true));
    public TSCAction zoomInAction = new TSCAction(this, Language.translate("Zoom In", true), ResPath.getPath("icons.zoomin"), Language.translate("Zoom in on the image.", true));
    public TSCAction zoomOutAction = new TSCAction(this, Language.translate("Zoom Out", true), ResPath.getPath("icons.zoomout"), Language.translate("Zoom out of the image.", true));
    public TSCAction actualSizeAction = new TSCAction(this, Language.translate("Actual Size", true), ResPath.getPath("icons.zoom100"), Language.translate("Set the zoom to 100%.", true));
    public TSCAction fitToWindowAction = new TSCAction(this, Language.translate("Fit to Window", true), ResPath.getPath("icons.zoomfit"), Language.translate("Zoom fit. Zoom such that the entire image is visible.", true));
    public TSCAction showLine = new TSCAction(this, Language.translate("Enable Line Check", true), ResPath.getPath("icons.showline"), Language.translate("Time Line On/Off", true));
    public TSCAction quickstartAction = new TSCAction(this, Language.translate("Quick Start Guide", true), null, Language.translate("A short guide for getting something to show up.", true));
    public TSCAction tourAction = new TSCAction(this, Language.translate("Tour", true), null, Language.translate("A somewhat longer guide for getting something to show up.", true));
    public TSCAction contactAction = new TSCAction(this, Language.translate("Contact Us", true), null, Language.translate("A contact box that pulls up contact info for our system", true));
    public TSCAction featureInfoAction = new TSCAction(this, Language.translate("Features reference", true), null, Language.translate("An in-depth look at the options of the program.", true));
    public TSCAction licenseAction = new TSCAction(this, Language.translate("Software License", true), null, Language.translate("License for using this software.", true));
    public TSCAction fileFormatInfoAction = new TSCAction(this, Language.translate("File Format info", true), null, Language.translate("Information about how the file format for the data file is set up.", true));
    public TSCAction websiteInfoAction = new TSCAction(this, Language.translate("Website...", true), null, Language.translate("Link to your page on the TSCreator website.", true));
    public TSCAction aboutAction = new TSCAction(this, Language.translate("About", true), null, Language.translate("Version info and copyright.", true));
    public static final int MIN_SERVER_THREADS = 1;
    public static final int MAX_SERVER_THREADS = 4;
    public static String SERVER_NEW_SETTINGS;
    public static String SERVER_TEMP_SETTINGS;
    public static String SERVER_USED_SETTINGS;
    public static String SERVER_OUTPUT_SETTINGS;
    public static String SERVER_PDF_OUTPUT;
    public static int NUMBER_OF_THREADS;
    public static String SERVER_COL_PACKS;
    public static String SERVER_COL_OUTPUT;
    public static boolean REWRITE_COLUMN_PACK;
    public static String columnpackIn;
    public static String columnpackOut;
    public static boolean NODE_MODE;
    public static boolean VM_ALREADY_SPAWNED;
    public static boolean DESKTOP_VERSION;
    public static boolean containsOptionalFlags;
    public static final Object lock;
    public static boolean testingMode;
    public static int myOrder;
    HeaderPanel hp;
    File tempOut = null;
    String tempOutLoc;
    File tempIn = null;
    LASConverterGUI lg = null;
    public JMenu forum = new JMenu(Language.translate("Forum", true));
    private int numCharsInDatapack = -1;
    private int numLinesInDatapack = -1;
    private boolean evTreeColumnExists = false;
    String whitespace_chars = "\\u0009\\u000A\\u000B\\u000C\\u000D\\u0020\\u0085\\u00A0\\u1680\\u180E\\u2000\\u2001\\u2002\\u2003\\u2004\\u2005\\u2006\\u2007\\u2008\\u2009\\u200A\\u2028\\u2029\\u202F\\u205F\\u3000";
    String whitespace_charclass = "[" + this.whitespace_chars + "]";
    private boolean encryptedDatapack = false;

    public TSCreator(boolean isApplet) {
        try {
            this.initialize();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public TSCreator() {
        if (!isApplet) {
            this.getContentPane().add(new JLabel("<html>This is a standalone application version of TSCreator. It cannot be used as a Java applet.</html>"));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void initialize() throws Exception {
        curCreator = this;
        if (autoSaveFile != null) {
            String format;
            if (autoGenOptions == null && BUILT_IN_DATA_FILE == null) {
                autoGenOptions = new AutoGenOptions();
            }
            this.loadDefaultColoring();
            this.loadDefaultData();
            this.generateImage();
            if (this.svgImage == null) {
                System.out.println("There was an error generating the image. Quitting.");
                TSCreator.exit();
            }
            RasterSave.RasterSaveOptions autoRasterSaveOptions = null;
            if (BUILT_IN_DATA_FILE == null) {
                autoRasterSaveOptions = autoGenOptions.getRasterSaveOptions(this.svgImage);
            }
            if ((format = FileUtils.getExtension(autoSaveFile)) == null) {
                System.out.println("Please use an extension on the output file so TSC knows what format to write. Got: " + autoSaveFile);
                TSCreator.exit();
            }
            try {
                if (BUILT_IN_DATA_FILE == null && autoRasterSaveOptions != null) {
                    this.saveToFile(autoSaveFile, format.toUpperCase(), autoRasterSaveOptions);
                } else {
                    this.saveToFile(autoSaveFile, format.toUpperCase(), null);
                }
            }
            catch (Exception e) {
                System.out.println("Error writing output: " + e.getMessage());
                TSCreator.exit();
            }
            catch (OutOfMemoryError e) {
                System.out.println("Out of memory! You can increase the amount of memory available to TSC using the -Xmx JVM switch. For example, 'java -Xmx1g -jar TSC.jar' will give TSC 1GB of RAM.");
                TSCreator.exit();
            }
            TSCreator.exit();
        }
        this.generateAction.useThread(this);
        this.loadAddFromFileAction.useThread(this);
        this.loadAddWithBuiltInAction.useThread(this);
        this.loadReplaceWithBuiltInAction.useThread(this);
        this.loadReplaceWithFileAction.useThread(this);
        if (isApplet) {
            this.contentPane = this.getContentPane();
        } else {
            tscFrame = new JFrame("Time Scale Creator");
            tscFrame.setDefaultCloseOperation(3);
            tscFrame.setSize(720, 750);
            this.contentPane = tscFrame.getContentPane();
        }
        this.displayPanel = new JPanel();
        this.topPanel = new JPanel();
        this.topPanel.setLayout(new BoxLayout(this.topPanel, 0));
        this.addWidgets();
        if (!isApplet) {
            this.addMenu();
        }
        if (!isApplet && !ProgramInfo.isPublic()) {
            showSearchPane = true;
        }
        this.contentPane.add((Component)this.topPanel, "North");
        this.mainViewLayout = new CardLayout();
        this.mainView = new JPanel(this.mainViewLayout);
        this.displayCanvas = new TSCSVGCanvas();
        this.displayCanvasPane = new TSCSVGScrollPane(this.displayCanvas);
        this.mainView.add((Component)this.displayCanvasPane, "displayCanvas");
        this.displayCanvas.addSVGDocumentLoaderListener(new SVGDocumentLoaderAdapter(){

            @Override
            public void documentLoadingStarted(SVGDocumentLoaderEvent e) {
                TSCreator.showInLabel(Language.translate("Rendering Image: Loading...", true), 1);
            }

            @Override
            public void documentLoadingCompleted(SVGDocumentLoaderEvent e) {
                TSCreator.showInLabel(Language.translate("Document Loaded.", true), 1);
            }

            @Override
            public void documentLoadingFailed(SVGDocumentLoaderEvent e) {
                TSCreator.showInLabel(Language.translate("Rendering Failed 1", true), 3);
                TSCreator.this.bigError(true);
            }
        });
        this.displayCanvas.addGVTTreeBuilderListener(new GVTTreeBuilderAdapter(){

            @Override
            public void gvtBuildStarted(GVTTreeBuilderEvent e) {
                TSCreator.showInLabel(Language.translate("Rendering Image: Building...", true), 1);
            }

            @Override
            public void gvtBuildCompleted(GVTTreeBuilderEvent e) {
                TSCreator.showInLabel(Language.translate("Build Done.", true), 1);
            }

            @Override
            public void gvtBuildFailed(GVTTreeBuilderEvent e) {
                TSCreator.showInLabel(Language.translate("Rendering Failed 2", true), 3);
                TSCreator.this.bigError(true);
            }
        });
        this.displayCanvas.addGVTTreeRendererListener(new GVTTreeRendererAdapter(){

            @Override
            public void gvtRenderingPrepare(GVTTreeRendererEvent e) {
                TSCreator.showInLabel(Language.translate("Rendering Image: Rendering...", true), 1);
            }

            @Override
            public void gvtRenderingCompleted(GVTTreeRendererEvent e) {
                TSCreator.showInLabel("Successfully Rendered", 2);
                TSCreator.this.displayCanvasPane.zoomToPreviousZoom();
                Runtime.getRuntime().gc();
            }

            @Override
            public void gvtRenderingFailed(GVTTreeRendererEvent e) {
                TSCreator.showInLabel(Language.translate("Rendering Failed 3", true), 3);
                TSCreator.this.bigError(true);
            }
        });
        this.displayCanvas.clearLinkListeners();
        this.displayCanvas.addLinkActivationListener(new TSCLinkActivationListener());
        this.htmlView = new JEditorPane();
        this.htmlView.setEditable(false);
        this.htmlView.setContentType("text/html");
        this.htmlView.addHyperlinkListener(new TSCLinkActivationListener());
        this.htmlView.setText(HTMLPreprocessor.process(ResPath.getPath("html.introscreen")));
        this.htmlView.addHyperlinkListener(new TSCLinkActivationListener());
        ((HTMLDocument)this.htmlView.getDocument()).setBase(HTMLPreprocessor.getGlobalBaseDirectory());
        HTMLDocument doc = (HTMLDocument)this.htmlView.getDocument();
        if (doc.getBase() != null) {
            Debug.print("HTMLDocument base for introscreen = " + doc.getBase().toString());
        } else {
            Debug.print("HTMLDocument base for introscreen = null.");
        }
        this.mainView.add((Component)new JScrollPane(this.htmlView), "htmlView");
        this.contentPane.add(this.mainView);
        this.mainViewLayout.show(this.mainView, "htmlView");
        this.loadSuccessful(false);
        this.saveSVGAction.setEnabled(false);
        this.saveRasterAction.setEnabled(false);
        this.savePDFAction.setEnabled(false);
        this.imageSizeAction.setEnabled(false);
        this.zoomInAction.setEnabled(false);
        this.zoomOutAction.setEnabled(false);
        this.actualSizeAction.setEnabled(false);
        this.fitToWindowAction.setEnabled(false);
        this.showLine.setEnabled(false);
        if (!isApplet) {
            tscFrame.setVisible(true);
        }
        this.loadDefaultColoringAction.actionPerformed(null);
        TSCreator.logAndShow(Language.translate("Loading built-in data...", true), 1);
        this.clearData();
        numDatapacksAdded = 0;
        this.loadDefaultData();
        File settingsFileCheck = new File(Settings.settingsBackupFile);
        settingsFileCheck.deleteOnExit();
        if (settingsFileCheck.exists()) {
            Settings.saveBackup(settingsFileCheck);
        }
        Object object = lock;
        synchronized (object) {
            lock.notifyAll();
        }
    }

    private void addWidgets() {
        this.info = new JLabel("", 2);
        this.info.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.toolBar = new JToolBar("Main");
        this.toolBar.setFloatable(false);
        this.toolBar.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.toolBar.add(this.settingsAction);
        this.toolBar.add(this.generateAction);
        this.toolBar.addSeparator();
        this.toolBar.add(this.zoomInAction);
        this.toolBar.add(this.zoomOutAction);
        this.toolBar.add(this.actualSizeAction);
        this.toolBar.add(this.fitToWindowAction);
        this.toolBar.add(this.showLine);
        this.toolBar.addSeparator();
        if (this.addSomeRascFileAction != null) {
            this.toolBar.add(this.addSomeRascFileAction);
        }
        this.topPanel.add(this.toolBar);
        this.topPanel.add(this.info);
    }

    private void addMenu() {
        JMenuBar menuBar = new JMenuBar();
        JMenu file = new JMenu(Language.translate("File", true));
        JMenu data = new JMenu(Language.translate("Data", true));
        JMenu image = new JMenu(Language.translate("Image", true));
        JMenu help = new JMenu(Language.translate("Help", true));
        JMenu contact = new JMenu(Language.translate("Contact", true));
        menuBar.add(file);
        file.add(this.loadReplaceWithBuiltInAction);
        file.add(this.loadAddWithBuiltInAction);
        file.add(this.loadAddFromFileAction);
        file.add(this.loadReplaceWithFileAction);
        if (!ProgramInfo.isPublic()) {
            file.addSeparator();
        }
        file.add(this.viewPatternsAction);
        file.add(this.addPatternsAction);
        file.addSeparator();
        file.add(this.showGTSversion);
        file.addSeparator();
        file.add(this.saveSVGAction);
        file.add(this.savePDFAction);
        file.add(this.saveRasterAction);
        if (!isApplet) {
            file.addSeparator();
            file.add(this.exitAction);
        }
        if (!ProgramInfo.isPublic()) {
            menuBar.add(data);
            data.add(this.encryptDataAction);
            data.addSeparator();
            data.add(this.saveTemplateAction);
            data.add(this.loadTemplateAction);
            data.add(this.convertDataPackAction);
            this.convertDataPackAction.setEnabled(false);
        }
        menuBar.add(image);
        image.add(this.settingsAction);
        image.add(this.generateAction);
        image.addSeparator();
        image.add(this.imageSizeAction);
        image.addSeparator();
        image.add(this.zoomInAction);
        image.add(this.zoomOutAction);
        image.add(this.actualSizeAction);
        image.add(this.fitToWindowAction);
        image.add(this.showLine);
        JMenu crossplotMenu = new JMenu(Language.translate("Crossplot", true));
        crossplotMenu.add(this.createCrossplotAction);
        menuBar.add(crossplotMenu);
        menuBar.add(help);
        help.add(Language.languageSelectionPanel());
        help.add(this.quickstartAction);
        help.add(this.tourAction);
        help.add(this.featureInfoAction);
        help.add(this.licenseAction);
        help.add(this.fileFormatInfoAction);
        if (!ProgramInfo.isPublic()) {
            help.addSeparator();
            help.add(this.websiteInfoAction);
            help.addSeparator();
        }
        help.add(this.aboutAction);
        menuBar.add(contact);
        contact.add(this.contactAction);
        menuBar.add(this.forum);
        this.forum.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    try {
                        URI uri = new URI("https://timescalecreator.org/forum/forum.php");
                        Desktop.getDesktop().browse(uri);
                    }
                    catch (URISyntaxException e1) {
                        e1.printStackTrace();
                    }
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
            }
        });
        if (isApplet) {
            this.setJMenuBar(menuBar);
        } else {
            tscFrame.setJMenuBar(menuBar);
        }
    }

    public void loadDefaultColoring() {
        try {
            Coloring.readColoring(FileUtils.getInputStream(DEFAULT_COLORING_FILE));
        }
        catch (Exception e) {
            ErrorHandler.showError(e, null, "Error loading color schemes!", 3);
        }
    }

    public DataColumn.FileInfo figureOutWhichDefaultDataWeAreUsing() {
        DataColumn.FileInfo fileInfo = new DataColumn.FileInfo();
        StringTokenizer tk = new StringTokenizer(BUILT_IN_DATA_FILE, ",");
        while (tk.hasMoreElements()) {
            String attempt = tk.nextToken();
            try {
                InputStream is = FileUtils.getInputStream(attempt, true);
                is.close();
            }
            catch (Exception e) {
                continue;
            }
            fileInfo.loadPath = attempt;
            fileInfo.resource = true;
            URL base = FileUtils.getURL(attempt);
            String baseS = base.toString();
            fileInfo.workingDir = baseS = baseS.replaceAll("/[^/]*?\\z", "/");
            try {
                fileInfo.baseURL = new URL(baseS);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            fileInfo.ensureTrailingSlashes();
            Debug.print("Datafile base directory = " + fileInfo.workingDir);
            Debug.print("Datafile base URL = " + fileInfo.baseURL);
            return fileInfo;
        }
        return null;
    }

    public void loadDefaultData() throws Exception {
        boolean dataLoadSuccess = false;
        try {
            if (db == null) {
                db = new Datastore();
                settings = new Settings(db);
                settings.addTSObj(this);
                settings.setGenerateAction(this.generateAction);
                db.addBasicColumns();
            } else if (settings == null) {
                settings = new Settings(db);
                settings.addTSObj(this);
                settings.setGenerateAction(this.generateAction);
            }
            if (CrossplotFrame.crossplot != null) {
                CrossplotFrame.crossplot.clearAllPoints();
            }
            this.doUIChanges(2, true, false);
            if (NODE_MODE) {
                this.loadDatapackFile(new File(BUILT_IN_DATA_FILE));
            } else {
                DataColumn.FileInfo fileInfo = this.figureOutWhichDefaultDataWeAreUsing();
                if (fileInfo == null) {
                    throw new Exception("Default datafile missing!");
                }
                if (!this.loadEncrypted(fileInfo, true)) {
                    throw new Exception("Nothing Loaded.");
                }
            }
            TSCreator.db.rootColumn.setParentFontManager(TSCreator.settings.fonts);
            settings.dataAdded();
            double changedTopAge = TSCreator.settings.topAge;
            double changedBaseAge = TSCreator.settings.baseAge;
            double changedVertScale = TSCreator.settings.scale;
            this.applyDefaultSettings();
            if (NODE_MODE && command_line_datapack_flag && command_line_datapacks != null) {
                while (command_line_datapack_id < command_line_datapacks.size()) {
                    ++numDatapacksAdded;
                    this.loadDataFromFile(false, false);
                }
                if (command_line_settings_flag) {
                    this.applyDefaultSettings();
                }
            }
            if (TSCreator.settings.changedDefaultTopAge) {
                String topString = Double.toString(changedTopAge);
                topFlag = true;
                if (topFlag) {
                    settings.setTopAge(db.getCurrentUnits(), topString);
                    settings.timesChanged(0, db.getCurrentUnits());
                }
            }
            if (TSCreator.settings.changedDefaultBaseAge) {
                String baseString = Double.toString(changedBaseAge);
                baseFlag = true;
                if (baseFlag) {
                    settings.setBaseAge(db.getCurrentUnits(), baseString);
                    settings.timesChanged(0, db.getCurrentUnits());
                }
            }
            if (TSCreator.settings.changedDefaultScale) {
                String vertScale = Double.toString(changedVertScale);
                vertFlag = true;
                if (vertFlag) {
                    settings.setVertScale(db.getCurrentUnits(), vertScale);
                    settings.timesChanged(2, db.getCurrentUnits());
                }
            }
            if (SETTINGS_FILE != null) {
                settings.setupWrite(SETTINGS_FILE);
            }
            TSCreator.logAndShow(Language.translate("Data loaded successfully!", true), 2);
            this.loadSuccessful(true);
        }
        catch (Exception e) {
            TSCreator.logAndShow(Language.translate("Unable to load datafile!", true), 3);
            if (e.getMessage().equals("Public Limit Reached")) {
                this.showGetProPopup();
            }
            ErrorHandler.showError(e, null, "Error loading data file!", 3);
        }
        this.doUIChanges(2, false, false);
        this.getStaticSettings();
    }

    public void applyDefaultSettings() {
        if (autoGenOptions != null) {
            settings.setFromAutoGenOptions(autoGenOptions);
            settings.grayOutEmptyColumns();
            db.setAutomaticGenSettings(settings, autoGenOptions);
        }
        if (FileUtils.doesFileExist(DEFAULT_SETTINGS_FILE)) {
            if (!TSCreator.settings.isPopulated && autoGenOptions == null) {
                settings.populate(db);
            }
            settings.setupRead(DEFAULT_SETTINGS_FILE);
        }
        settings.printTimeSelections();
    }

    public void saveDataAsJson() throws Exception {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        FileNameExtensionFilter filter = new FileNameExtensionFilter("*json", "json");
        chooser.setFileFilter(filter);
        int returnVal = chooser.showSaveDialog(tscFrame);
        if (returnVal == 0) {
            String absolutePath = FileUtils.appendExtension(chooser.getSelectedFile().getAbsolutePath(), "json");
            JsonWriter writer = new JsonWriter((Writer)new FileWriter(absolutePath));
            db.writeToJson(writer);
            writer.close();
            TSCreator.logAndShow(Language.translate("Saved data to ", true) + absolutePath, 2);
        }
    }

    public void saveDataAs() throws Exception {
        int returnVal;
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(2);
        FileNameExtensionFilter filter = new FileNameExtensionFilter("*.txt, *.zip", "txt", "zip");
        chooser.setFileFilter(filter);
        if (fileChooserPath != null) {
            chooser.setCurrentDirectory(fileChooserPath);
        }
        if ((returnVal = chooser.showSaveDialog(tscFrame)) == 0) {
            String absolutePath = FileUtils.appendExtension(chooser.getSelectedFile().getAbsolutePath(), "txt");
            fileChooserPath = chooser.getCurrentDirectory();
            String backupOutPath = ENABLE_DATAPACK_ENCRYPTION ? absolutePath + ".bkp" : absolutePath;
            TSCreator.logAndShow(Language.translate("Saving data to ", true) + absolutePath, 1);
            BufferedWriter bw = new BufferedWriter(new FileWriter(backupOutPath));
            db.write(bw);
            bw.close();
            if (ENABLE_DATAPACK_ENCRYPTION) {
                FileInputStream fis = new FileInputStream(backupOutPath);
                FileOutputStream fos = new FileOutputStream(absolutePath);
                DatafileCrypto.HeaderInfo hi = new DatafileCrypto.HeaderInfo();
                hi.message = null;
                String error = DatafileCrypto.encrypt(fos, fis, null, hi);
                if (error == null) {
                    fis.close();
                    fos.close();
                    TSCreator.logAndShow(Language.translate("Saved data to ", true) + absolutePath, 2);
                } else {
                    TSCreator.logAndShow(Language.translate("Error while protecting file: ", true) + error, 3);
                    fis.close();
                    fos.close();
                }
                File tempFileHandle = new File(backupOutPath);
                tempFileHandle.delete();
            } else {
                TSCreator.logAndShow(Language.translate("Saved data to ", true) + absolutePath, 2);
            }
        }
    }

    public File openLoadFileChooser() {
        FileDialog fileChooser = new FileDialog((Frame)tscFrame, "Choose Datapack to Load", 0);
        fileChooser.setFilenameFilter(new FilenameFilter(){

            @Override
            public boolean accept(File directory, String filename) {
                return filename.endsWith(".txt") || filename.endsWith(".tre") || filename.endsWith(".nwk") || filename.endsWith(".newick") || filename.endsWith(".nex") || filename.endsWith(".nexus") || filename.endsWith(".dpk") || filename.endsWith(".mdpk") || filename.endsWith(".map") || filename.endsWith(".zip") || filename.endsWith(".las");
            }
        });
        fileChooser.setVisible(true);
        File selFile = null;
        if (fileChooser.getFile() != null && !fileChooser.getFile().isEmpty()) {
            selFile = new File(fileChooser.getDirectory() + fileChooser.getFile());
        }
        return selFile;
    }

    public void loadLASFile(boolean clearCurrent, boolean addDefault) {
        this.tempIn = this.selFile;
        this.lg = new LASConverterGUI(this.selFile.getAbsolutePath(), this);
        this.lg.f.setVisible(true);
        class MyActionListener
        implements ActionListener {
            private TSCreator tsObj;
            private boolean clearCurrent;
            private boolean addDefault;
            private Datastore db;
            private LASConverterGUI lg;

            public MyActionListener(TSCreator tsObj, Datastore db, boolean clearCurrent, boolean addDefault, LASConverterGUI lg) {
                this.tsObj = tsObj;
                this.clearCurrent = clearCurrent;
                this.addDefault = addDefault;
                this.db = db;
                this.lg = lg;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
            }
        }
        this.lg.OKButtonTop.addActionListener(new MyActionListener(this, db, clearCurrent, addDefault, this.lg){
            {
                super(tsObj, db, clearCurrent, addDefault, lg);
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                String fileName = TSCreator.this.OKButtonActionPerformed(evt);
                TSCreator.this.selFile = new File(fileName);
                if (TSCreator.this.selFile != null) {
                    TSCreator.logAndShow("Loading datapack :: " + TSCreator.this.selFile.getName(), 2);
                    ErrorHandler.log("Loading data from " + TSCreator.this.selFile.getAbsolutePath());
                    if (ProgramInfo.isPublic() && ProgramInfo.isSavingEnabled()) {
                        TSCreator.this.savePDFAction.setText(TSCreator.this.savePDFAction.getText() + " (Disabled by Demo)");
                        TSCreator.this.savePDFAction.setEnabled(false);
                        TSCreator.this.saveRasterAction.setText(TSCreator.this.saveRasterAction.getText() + " (Disabled by Demo)");
                        TSCreator.this.saveRasterAction.setEnabled(false);
                        TSCreator.this.saveSVGAction.setText(TSCreator.this.saveSVGAction.getText() + " (Disabled by Demo)");
                        TSCreator.this.saveSVGAction.setEnabled(false);
                        ProgramInfo.setSavingEnabled(false);
                    }
                    try {
                        if (((MyActionListener)this).clearCurrent) {
                            TSCreator.this.clearData();
                        }
                        if (((MyActionListener)this).db == null || ((MyActionListener)this).clearCurrent) {
                            db = new Datastore();
                            ((MyActionListener)this).db = db;
                            settings = new Settings(((MyActionListener)this).db);
                            settings.addTSObj(((MyActionListener)this).tsObj);
                            settings.setGenerateAction(TSCreator.this.generateAction);
                            ((MyActionListener)this).db.addBasicColumns();
                            TSCreator.this.loadDatapackFile(TSCreator.this.selFile);
                            topFlag = true;
                            baseFlag = true;
                            vertFlag = true;
                            if (vertFlag) {
                                settings.setVertScale(db.getCurrentUnits(), Double.toString(TSCreator.settings1.scale));
                            }
                            if (topFlag || baseFlag) {
                                settings.setTopAge(db.getCurrentUnits(), Double.toString(TSCreator.settings1.topAge));
                                settings.setBaseAge(db.getCurrentUnits(), Double.toString(TSCreator.settings1.baseAge));
                            }
                            ((MyActionListener)this).db.rootColumn.setParentFontManager(TSCreator.settings.fonts);
                            settings.dataAdded();
                        } else {
                            topFlag = true;
                            baseFlag = true;
                            vertFlag = true;
                            TSCreator.this.loadDatapackFile(TSCreator.this.selFile);
                            if (vertFlag) {
                                settings.setVertScale(db.getCurrentUnits(), Double.toString(TSCreator.settings1.scale));
                            }
                            if (topFlag || baseFlag) {
                                settings.setTopAge(db.getCurrentUnits(), Double.toString(TSCreator.settings1.topAge));
                                settings.setBaseAge(db.getCurrentUnits(), Double.toString(TSCreator.settings1.baseAge));
                            }
                            settings.dataAdded();
                        }
                    }
                    catch (Exception e) {
                        TSCreator.showInLabel(Language.translate("Error loading data file!", true), 3);
                        String errorMsgList = "";
                        if (TSCreator.db.errorList.size() > 0) {
                            Iterator iter = TSCreator.db.errorList.iterator();
                            while (iter.hasNext()) {
                                errorMsgList = errorMsgList + "\n" + (String)iter.next();
                            }
                            errorMsgList = errorMsgList + "\n";
                            ErrorHandler.showError(errorMsgList + e.getLocalizedMessage(), "Error loading file!", 3);
                        } else {
                            ErrorHandler.showError(null, "Error loading data file!", 3);
                        }
                        TSCreator.this.doUIChanges(2, false, true);
                    }
                    TSCreator.this.lg.f.dispose();
                }
            }
        });
        this.lg.OKButtonBottom.addActionListener(new MyActionListener(this, db, clearCurrent, addDefault, this.lg){
            {
                super(tsObj, db, clearCurrent, addDefault, lg);
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                String fileName = TSCreator.this.OKButtonActionPerformed(evt);
                TSCreator.this.selFile = new File(fileName);
                if (TSCreator.this.selFile != null) {
                    TSCreator.logAndShow("Loading datapack :: " + TSCreator.this.selFile.getName(), 2);
                    ErrorHandler.log("Loading data from " + TSCreator.this.selFile.getAbsolutePath());
                    if (ProgramInfo.isPublic() && ProgramInfo.isSavingEnabled()) {
                        TSCreator.this.savePDFAction.setText(TSCreator.this.savePDFAction.getText() + " (Disabled by Demo)");
                        TSCreator.this.savePDFAction.setEnabled(false);
                        TSCreator.this.saveRasterAction.setText(TSCreator.this.saveRasterAction.getText() + " (Disabled by Demo)");
                        TSCreator.this.saveRasterAction.setEnabled(false);
                        TSCreator.this.saveSVGAction.setText(TSCreator.this.saveSVGAction.getText() + " (Disabled by Demo)");
                        TSCreator.this.saveSVGAction.setEnabled(false);
                        ProgramInfo.setSavingEnabled(false);
                    }
                    try {
                        if (((MyActionListener)this).clearCurrent) {
                            TSCreator.this.clearData();
                        }
                        if (((MyActionListener)this).db == null || ((MyActionListener)this).clearCurrent) {
                            db = new Datastore();
                            ((MyActionListener)this).db = db;
                            settings = new Settings(((MyActionListener)this).db);
                            settings.addTSObj(((MyActionListener)this).tsObj);
                            settings.setGenerateAction(TSCreator.this.generateAction);
                            ((MyActionListener)this).db.addBasicColumns();
                            topFlag = true;
                            baseFlag = true;
                            vertFlag = true;
                            TSCreator.this.loadDatapackFile(TSCreator.this.selFile);
                            if (vertFlag) {
                                settings.setVertScale(db.getCurrentUnits(), Double.toString(TSCreator.settings1.scale));
                            }
                            if (topFlag || baseFlag) {
                                settings.setTopAge(db.getCurrentUnits(), Double.toString(TSCreator.settings1.topAge));
                                settings.setBaseAge(db.getCurrentUnits(), Double.toString(TSCreator.settings1.baseAge));
                            }
                            ((MyActionListener)this).db.rootColumn.setParentFontManager(TSCreator.settings.fonts);
                            settings.dataAdded();
                        } else {
                            topFlag = true;
                            baseFlag = true;
                            vertFlag = true;
                            TSCreator.this.loadDatapackFile(TSCreator.this.selFile);
                            if (vertFlag) {
                                settings.setVertScale(db.getCurrentUnits(), Double.toString(TSCreator.settings1.scale));
                            }
                            if (topFlag || baseFlag) {
                                settings.setTopAge(db.getCurrentUnits(), Double.toString(TSCreator.settings1.topAge));
                                settings.setBaseAge(db.getCurrentUnits(), Double.toString(TSCreator.settings1.baseAge));
                            }
                            settings.dataAdded();
                        }
                    }
                    catch (Exception e) {
                        TSCreator.showInLabel(Language.translate("Error loading data file!", true), 3);
                        String errorMsgList = "";
                        if (TSCreator.db.errorList.size() > 0) {
                            Iterator iter = TSCreator.db.errorList.iterator();
                            while (iter.hasNext()) {
                                errorMsgList = errorMsgList + "\n" + (String)iter.next();
                            }
                            errorMsgList = errorMsgList + "\n";
                            ErrorHandler.showError(errorMsgList + e.getLocalizedMessage(), "Error loading file!", 3);
                        } else {
                            ErrorHandler.showError(null, "Error loading data file!", 3);
                        }
                        TSCreator.this.doUIChanges(2, false, true);
                    }
                    TSCreator.this.lg.f.dispose();
                }
            }
        });
    }

    public void loadDataFromFile(boolean clearCurrent, boolean addDefault) throws Exception {
        if (addDefault) {
            this.selFile = new File(BUILT_IN_DATA_FILE);
        } else if (!NODE_MODE) {
            this.selFile = this.openLoadFileChooser();
        } else {
            System.out.println(command_line_datapacks.get(command_line_datapack_id));
            this.selFile = new File(command_line_datapacks.get(command_line_datapack_id));
            ++command_line_datapack_id;
        }
        if (this.selFile != null) {
            this.pathArray = this.selFile.getAbsolutePath().split("\\.");
            this.extension = this.pathArray[this.pathArray.length - 1];
        }
        if (this.extension != null && this.extension.equals("las")) {
            this.loadLASFile(clearCurrent, addDefault);
        } else if (this.selFile != null) {
            TSCreator.logAndShow("Loading datapack :: " + this.selFile.getName(), 2);
            ErrorHandler.log("Loading data from " + this.selFile.getAbsolutePath());
            if (ProgramInfo.isPublic() && ProgramInfo.isSavingEnabled()) {
                this.savePDFAction.setText(this.savePDFAction.getText() + " (Disabled by Demo)");
                this.savePDFAction.setEnabled(false);
                this.saveRasterAction.setText(this.saveRasterAction.getText() + " (Disabled by Demo)");
                this.saveRasterAction.setEnabled(false);
                this.saveSVGAction.setText(this.saveSVGAction.getText() + " (Disabled by Demo)");
                this.saveSVGAction.setEnabled(false);
                ProgramInfo.setSavingEnabled(false);
            }
            try {
                if (clearCurrent) {
                    this.clearData();
                }
                if (db == null || clearCurrent) {
                    db = new Datastore();
                    settings = new Settings(db);
                    settings.addTSObj(this);
                    settings.setGenerateAction(this.generateAction);
                    db.addBasicColumns();
                    myOrder = 0;
                    MetaColumn.flamer = 0;
                    topFlag = true;
                    baseFlag = true;
                    vertFlag = true;
                    this.loadDatapackFile(this.selFile);
                    String topString = Double.toString(TSCreator.settings.topAge);
                    String baseString = Double.toString(TSCreator.settings.baseAge);
                    String vertScale = Double.toString(TSCreator.settings.scale);
                    if (vertFlag) {
                        settings.setVertScale(db.getCurrentUnits(), vertScale);
                    }
                    if (topFlag || baseFlag) {
                        settings.setTopAge(db.getCurrentUnits(), topString);
                        settings.setBaseAge(db.getCurrentUnits(), baseString);
                    }
                    TSCreator.db.rootColumn.setParentFontManager(TSCreator.settings.fonts);
                    settings.dataAdded();
                } else {
                    topFlag = true;
                    baseFlag = true;
                    vertFlag = true;
                    this.loadDatapackFile(this.selFile);
                    String topString = Double.toString(TSCreator.settings.topAge);
                    String baseString = Double.toString(TSCreator.settings.baseAge);
                    String vertScale = Double.toString(TSCreator.settings.scale);
                    if (vertFlag) {
                        settings.setVertScale(db.getCurrentUnits(), vertScale);
                    }
                    if (topFlag || baseFlag) {
                        settings.setTopAge(db.getCurrentUnits(), topString);
                        settings.setBaseAge(db.getCurrentUnits(), baseString);
                    }
                    settings.dataAdded();
                }
            }
            catch (Exception e) {
                TSCreator.showInLabel(Language.translate("Error loading data file!", true), 3);
                String errorMsgList = "";
                if (TSCreator.db.errorList.size() > 0) {
                    Iterator iter = TSCreator.db.errorList.iterator();
                    while (iter.hasNext()) {
                        errorMsgList = errorMsgList + "\n" + (String)iter.next();
                    }
                    errorMsgList = errorMsgList + "\n";
                    ErrorHandler.showError(errorMsgList + e.getLocalizedMessage(), "Error loading file!", 3);
                } else {
                    ErrorHandler.showError(null, "Error loading data file!", 3);
                }
                this.doUIChanges(2, false, true);
            }
        }
    }

    public void addDatapack(File server_datapack) throws Exception {
        try {
            if (db == null) {
                db = new Datastore();
                settings = new Settings(db);
                settings.addTSObj(this);
                settings.setGenerateAction(this.generateAction);
                db.addBasicColumns();
            }
            this.loadDatapackFile(server_datapack);
        }
        catch (Exception e) {
            TSCreator.showInLabel(Language.translate("Error loading data file!", true), 3);
            ErrorHandler.showError(e, null, "Error loading file!", 3);
        }
    }

    public void loadDatapackFile(File selFile) throws Exception {
        this.setFlagsOptions(selFile);
        if (depthFile == null) {
            this.checkForDepthFile(selFile);
        }
        this.doUIChanges(2, true, false);
        String path = selFile.getAbsolutePath();
        String extension = FileUtils.getExtension(selFile.getName());
        File extractDir = null;
        DataColumn.FileInfo fileInfo = new DataColumn.FileInfo();
        boolean dataLoadSuccess = false;
        try {
            if (extension.compareToIgnoreCase("zip") == 0) {
                File metapack;
                ZipFile zipFile = new ZipFile(path);
                extractDir = File.createTempFile(selFile.getName(), null);
                extractDir.delete();
                if (extractDir == null || !extractDir.mkdir()) {
                    throw new Exception("Unable to extract zip file to temporary directory.");
                }
                extractDir.deleteOnExit();
                if (!TSCreator.extractZip(zipFile, extractDir, true)) {
                    throw new Exception("Unable to extract zip file to temporary directory.");
                }
                List<File> listOfFiles = Arrays.asList(extractDir.listFiles());
                HashMap<String, File> sortedList = new HashMap<String, File>();
                for (int i = 0; i < listOfFiles.size(); ++i) {
                    File currentFile = listOfFiles.get(i);
                    String ext = FileUtils.getExtension(currentFile.getName());
                    if (ext == null) continue;
                    sortedList.put(currentFile.getName(), currentFile);
                }
                boolean hasMetapack = false;
                if (sortedList.containsKey("Metapack.txt") && TSCreator.isDatapackInfoFile(metapack = (File)sortedList.get("Metapack.txt"))) {
                    try {
                        String line;
                        BufferedReader br = new BufferedReader(new FileReader(metapack));
                        while ((line = br.readLine()) != null) {
                            File currentFile;
                            String ext;
                            if (line.equalsIgnoreCase("DATAPACK-INFO") || !sortedList.containsKey(line) || (ext = FileUtils.getExtension((currentFile = (File)sortedList.get(line)).getName())) == null) continue;
                            if (ext.equalsIgnoreCase("txt") && !MapInformation.isMapFile(currentFile) && !TSCreator.isDatapackInfoFile(currentFile)) {
                                this.loadDatapackFile(currentFile);
                                continue;
                            }
                            if (!ext.equalsIgnoreCase("zip")) continue;
                            this.loadDatapackFile(currentFile);
                        }
                        hasMetapack = true;
                        br.close();
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(tscFrame, "Error Parsing Metapack", "Parsing Error", 2);
                    }
                }
                if (!hasMetapack) {
                    for (int i = 0; i < listOfFiles.size(); ++i) {
                        File currentFile = listOfFiles.get(i);
                        String ext = FileUtils.getExtension(currentFile.getName());
                        if (ext == null) continue;
                        if (ext.equalsIgnoreCase("txt") && !MapInformation.isMapFile(currentFile) && !TSCreator.isDatapackInfoFile(currentFile)) {
                            this.loadDatapackFile(currentFile);
                            continue;
                        }
                        if (!ext.equalsIgnoreCase("zip")) continue;
                        this.loadDatapackFile(currentFile);
                    }
                }
            } else if (extension.equalsIgnoreCase("map")) {
                try {
                    this.doUIChanges(2, true, false);
                    if (!this.parseMapPack(selFile)) {
                        TSCreator.logAndShow(Language.translate("No map data loaded.  Please input a proper .map file with data.", true), 4);
                        this.doUIChanges(2, false, false);
                        return;
                    }
                    settings.mapDataAdded();
                    TSCreator.logAndShow(Language.translate("Map Data loaded successfully!", true), 2);
                    this.loadSuccessful(true);
                }
                catch (Exception e) {
                    TSCreator.showInLabel(Language.translate("Error loading map file!", true), 3);
                    ErrorHandler.showError(e, null, "Error map file!", 3);
                }
                this.doUIChanges(2, false, false);
            } else {
                fileInfo.workingDir = selFile.getParentFile().toString();
                fileInfo.baseURL = new URL("file:" + selFile.getParentFile().getAbsolutePath());
                fileInfo.loadPath = path;
                fileInfo.resource = false;
                fileInfo.ensureTrailingSlashes();
                if (extension.compareToIgnoreCase("dat") == 0) {
                    fileInfo.encrypted = false;
                    db.loadRASC(fileInfo);
                } else if (extension.equalsIgnoreCase("svg")) {
                    new TemplateLoader(tscFrame, selFile.getAbsolutePath(), db);
                } else if (extension.equalsIgnoreCase("json")) {
                    db.loadJSON(fileInfo);
                } else if (extension.equalsIgnoreCase("nwk") || extension.equalsIgnoreCase("newick") || extension.equalsIgnoreCase("tre")) {
                    db.loadNewick(fileInfo);
                } else if (extension.equalsIgnoreCase("nex") || extension.equalsIgnoreCase("nexus")) {
                    db.loadNexus(fileInfo);
                } else if ((extension.equalsIgnoreCase("txt") || extension.equalsIgnoreCase("dpk") || extension.equalsIgnoreCase("mdpk")) && !this.loadEncrypted(fileInfo, false)) {
                    throw new Exception("Nothing Loaded.");
                }
            }
            TSCreator.db.rootColumn.setParentFontManager(TSCreator.settings.fonts);
            settings.dataAdded();
            TSCreator.logAndShow(selFile.getName() + ":: Data loaded successfully!", 2);
            this.loadSuccessful(true);
        }
        catch (Exception e) {
            TSCreator.logAndShow(selFile.getName() + ":: Unable to load datafile!", 3);
            e.printStackTrace();
            if (e.getMessage().equals("Public Limit Reached")) {
                this.showGetProPopup();
            }
            String errorMsgList = "";
            if (TSCreator.db.errorList.size() > 0) {
                Iterator iter = TSCreator.db.errorList.iterator();
                while (iter.hasNext()) {
                    errorMsgList = errorMsgList + "\n" + (String)iter.next();
                }
                errorMsgList = errorMsgList + "\n";
                ErrorHandler.showError(errorMsgList + e.getLocalizedMessage(), "Error loading file!", 3);
            }
            ErrorHandler.showError(e.getLocalizedMessage(), "Error loading data file!", 3);
        }
        this.doUIChanges(2, false, false);
    }

    private void checkForDepthFile(File file) {
        block3: {
            try {
                String[] value;
                String extension = FileUtils.getExtension(file.getName());
                if (!extension.equalsIgnoreCase("txt")) break block3;
                CSVReader reader = new CSVReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"), '\t');
                depthFile = null;
                for (int i = 0; (value = reader.readNext()) != null && i < 10; ++i) {
                    if (!value[0].equalsIgnoreCase("age units:") || value[1].equalsIgnoreCase("ma")) continue;
                    depthFile = file;
                    depthFileUnits = value[1];
                    break;
                }
            }
            catch (Exception e) {
                Debug.print(e.getMessage());
            }
        }
    }

    private void showGetProPopup() {
        if (this.getPRO == null) {
            this.getPRO = new JFrame("Get A Pro Version.");
            SpringLayout layout = new SpringLayout();
            this.getPRO.setLayout(layout);
            this.getPRO.setDefaultCloseOperation(1);
            this.getPRO.setSize(400, 220);
            this.getPROMessage = new JTextArea("We're sorry, but this version does not support three or more non-encrypted external files that exceed 3000 characters each.  Please contact us about getting a Pro version via the \"contact us\" at www.tscreator.org. Thank you.");
            this.getPROMessage.setEditable(false);
            this.getPROMessage.setWrapStyleWord(true);
            this.getPROMessage.setLineWrap(true);
            this.getPROMessage.setSize(new Dimension(380, 200));
            this.getPROButton = new JButton("OK");
            this.getPROButton.setSize(new Dimension(50, 20));
            this.getPROButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Object item = e.getSource();
                    if (item == TSCreator.this.getPROButton) {
                        TSCreator.this.getPRO.setVisible(false);
                    }
                }
            });
            this.getPRO.add(this.getPROMessage);
            this.getPRO.add(this.getPROButton);
            layout.putConstraint("West", (Component)this.getPROMessage, 10, "West", (Component)this.getPRO);
            layout.putConstraint("North", (Component)this.getPROMessage, 10, "North", (Component)this.getPRO);
            layout.putConstraint("West", (Component)this.getPROButton, 170, "West", (Component)this.getPROMessage);
            layout.putConstraint("North", (Component)this.getPROButton, 30, "South", (Component)this.getPROMessage);
            Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
            int w = this.getPRO.getSize().width;
            int h = this.getPRO.getSize().height;
            int x = (dim.width - w) / 2;
            int y = (dim.height - h) / 2;
            this.getPRO.setLocation(x, y);
            this.getPRO.setVisible(true);
        } else {
            this.getPRO.setVisible(true);
        }
    }

    private boolean parseMapPack(File mapPack) throws Exception {
        ZipFile zipFile = new ZipFile(mapPack);
        File tempDir = null;
        Vector<MapInformation> mapsToAdd = new Vector<MapInformation>();
        Vector<File> datapacksToAdd = new Vector<File>();
        Vector<File> mappacksToAdd = new Vector<File>();
        tempDir = File.createTempFile(mapPack.getName(), null);
        tempDir.delete();
        if (tempDir == null || !tempDir.mkdir()) {
            throw new Exception("Unable to extract zip file to temporary directory.");
        }
        tempDir.deleteOnExit();
        if (!TSCreator.extractZip(zipFile, tempDir, true)) {
            throw new Exception("Unable to extract zip file to temporary directory.");
        }
        File[] listOfFiles = tempDir.listFiles();
        for (int i = 0; i < listOfFiles.length; ++i) {
            File currentFile = listOfFiles[i];
            String extension = FileUtils.getExtension(currentFile.getName());
            if (extension == null) continue;
            if (extension.equalsIgnoreCase("txt") && MapInformation.isMapFile(currentFile)) {
                MapInformation map = MapInformation.MapParseFromFile(currentFile.getAbsolutePath());
                mapsToAdd.add(map);
                continue;
            }
            if (extension.equalsIgnoreCase("map")) {
                mappacksToAdd.add(currentFile);
                continue;
            }
            if (!extension.equalsIgnoreCase("txt") && !extension.equalsIgnoreCase("dpk") && !extension.equalsIgnoreCase("zip")) continue;
            datapacksToAdd.add(currentFile);
        }
        for (File f : datapacksToAdd) {
            this.loadDatapackFile(f);
        }
        for (File f : mappacksToAdd) {
            this.parseMapPack(f);
        }
        for (MapInformation mi : mapsToAdd) {
            db.addMap(mi.getMapName(), mi);
        }
        return !mapsToAdd.isEmpty() || !datapacksToAdd.isEmpty();
    }

    public int checkevTreeColumnExistsAndCalculateCharNums(InputStream input, DataColumn.FileInfo fileInfo) throws ParseException {
        String enc = null;
        UnicodeInputStream uin = new UnicodeInputStream(input, enc);
        if ((enc = uin.getEncoding()) == null) {
            enc = System.getProperty("os.name").contains("Mac OS X") ? "macroman" : "windows-1252";
        }
        HashMap<Integer, String> evTreeColumnMap = new HashMap<Integer, String>();
        HashMap<Integer, Integer> evTreeColumnMapStart = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> evTreeColumnMapEnd = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> evTreeColumnCharCount = new HashMap<Integer, Integer>();
        int evTreeTotalCharCount = -1;
        try {
            SimpleCharStream stream = new SimpleCharStream((InputStream)uin, enc, 1, 1);
            String s = stream.toString();
            String dString = "";
            StringBuilder line = new StringBuilder();
            int ln = 0;
            int ci = 0;
            int nln = 0;
            String[] matchColumnChars = new String[]{"\trange\t", "\trange-overlay\t", "\trange-underlay\t", "\trange-only\t", "\tchron\t", "\tchron-overlay\t", "\tchron-underlay", "\tchron-only\t", "\tfacies\t", "\tfacies-overlay\t", "\tfacies-underlay\t", "\tfacies-only\t", "\tblank\t", "\tblank-overlay\t", "\tblank-underlay\t", "\tblank-only\t", "\tblock\t", "\tblock-overlay\t", "\tblock-underlay\t", "\tblock-only\t", "\tevent\t", "\tevent-overlay\t", "\tevent-underlay\t", "\tevent-only\t", "\tpoint\t", "\tpoint-overlay\t", "\tpoint-underlay\t", "\tpoint-only\t", "\tsequence\t", "\tsequence-overlay\t", "\tsequence-underlay\t", "\tsequence-only\t", "\ttrend\t", "\ttrend-overlay\t", "\ttrend-underlay\t", "\ttrend-only\t", "\taverage\t", "\taverage-overlay\t", "\taverage-underlay\t", "\taverage-only\t", "\ttransect\t", "\ttransect-overlay\t", "\ttransect-underlay\t", "\ttransect-only\t", "\tfreehand\t", "\tfreehand-underlay\t", "\tfreehand-overlay\t", "\tfreehand-only\t", "\t:\t"};
            int evTreeColumnID = 0;
            int evTreeCharCount = 0;
            boolean evTreeColumnStartRow = false;
            boolean evTreeColumnStart = false;
            try {
                char c = stream.readChar();
                ++ci;
                while (true) {
                    line.append(c);
                    if (!evTreeColumnStartRow && (line.toString().contains(matchColumnChars[0]) || line.toString().contains(matchColumnChars[1]) || line.toString().contains(matchColumnChars[2]) || line.toString().contains(matchColumnChars[3]))) {
                        evTreeColumnStartRow = true;
                        evTreeColumnStart = true;
                        this.evTreeColumnExists = true;
                        evTreeColumnMap.put(evTreeColumnID, line.toString());
                        evTreeColumnMapStart.put(evTreeColumnID, ln);
                    }
                    if (evTreeColumnStart) {
                        ++evTreeCharCount;
                    }
                    if (c == '\n' || c == '\r') {
                        if (evTreeColumnStart) {
                            for (int ix = 4; ix < matchColumnChars.length; ++ix) {
                                String oc = matchColumnChars[ix];
                                if (!line.toString().contains(oc)) continue;
                                evTreeColumnMapEnd.put(evTreeColumnID, ln - 1);
                                evTreeColumnCharCount.put(evTreeColumnID, evTreeCharCount -= line.length() - 1);
                                evTreeTotalCharCount += evTreeCharCount;
                                evTreeCharCount = 0;
                                evTreeColumnStart = false;
                                ++evTreeColumnID;
                                break;
                            }
                        }
                        if (evTreeColumnStartRow) {
                            evTreeColumnStartRow = false;
                        }
                        dString = dString + new String(line);
                        ++ln;
                        String newLine = line.toString().replaceAll(this.whitespace_charclass, "");
                        if (newLine.length() == 0) {
                            ++nln;
                        }
                        line = new StringBuilder();
                    }
                    c = stream.readChar();
                    ++ci;
                }
            }
            catch (IOException e) {
                if (evTreeColumnStart) {
                    evTreeColumnMapEnd.put(evTreeColumnID, ln - 1);
                    evTreeColumnCharCount.put(evTreeColumnID, evTreeCharCount);
                    evTreeTotalCharCount += evTreeCharCount;
                    evTreeCharCount = 0;
                    evTreeColumnStart = false;
                    ++evTreeColumnID;
                }
                System.out.println("Reached end of datapack while calculating the character numbers for evolutionary tree columns.");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.numCharsInDatapack = ci - nln;
            this.numLinesInDatapack = ln - nln;
            System.out.println("Number of characters in datapack = " + this.numCharsInDatapack);
            System.out.println("Number of lines in datapack = " + this.numLinesInDatapack);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return evTreeTotalCharCount;
    }

    private int getEVTreeColumnCharCount(DataColumn.FileInfo fileInfo) throws Exception, ParseException {
        InputStream in = FileUtils.getInputStream(fileInfo.loadPath, fileInfo.resource);
        int evTreeTotalCharCount = -1;
        try {
            evTreeTotalCharCount = this.checkevTreeColumnExistsAndCalculateCharNums(in, fileInfo);
        }
        catch (ParseException e) {
            in.close();
            throw e;
        }
        if (in != null) {
            in.close();
        }
        return evTreeTotalCharCount;
    }

    protected boolean loadEncrypted(DataColumn.FileInfo fileInfo, boolean defaultPack) throws Exception {
        int totalRead;
        boolean violatedLimitPublic = false;
        ParseException getMsg = null;
        try {
            fileInfo.encrypted = false;
            if (!ProgramInfo.isPublic() || defaultPack) {
                if (db != null) {
                    db.load(fileInfo);
                    return true;
                }
                return false;
            }
            String extension = FileUtils.getExtension(fileInfo.loadPath);
            int count = 0;
            int evTreeColumnCharCount = 0;
            InputStream in = FileUtils.getInputStream(fileInfo.loadPath, fileInfo.resource);
            this.encryptedDatapack = !DatafileCrypto.isDecryptedFile(in);
            in.close();
            if (!defaultPack && extension.equalsIgnoreCase("txt") && !this.encryptedDatapack) {
                evTreeColumnCharCount = this.getEVTreeColumnCharCount(fileInfo);
            }
            if (!defaultPack && extension.equalsIgnoreCase("txt") && !this.encryptedDatapack) {
                count = this.numCharsInFile(fileInfo.loadPath);
                count -= evTreeColumnCharCount;
            }
            this.numCharsInDatapack = -1;
            this.numLinesInDatapack = -1;
            this.evTreeColumnExists = false;
            this.encryptedDatapack = false;
            if (defaultPack || count <= 3000) {
                if (numDatapacksAdded < 3) {
                    db.load(fileInfo);
                    ++numDatapacksAdded;
                    return true;
                }
            } else {
                violatedLimitPublic = true;
                TSCreator.logAndShow(Language.translate("Cannot load unencrpted large files in Public Version", true), 3);
                throw new Exception("Public Limit Reached");
            }
            violatedLimitPublic = true;
        }
        catch (ParseException e) {
            getMsg = e;
        }
        InputStream in = FileUtils.getInputStream(fileInfo.loadPath, fileInfo.resource);
        if (in.available() <= 0) {
            throw new Exception("invalid file");
        }
        byte[] encFileContents = new byte[in.available()];
        if (encFileContents == null) {
            throw new Exception("Not enough memory to decrypt file!");
        }
        try {
            int read;
            for (totalRead = read = in.read(encFileContents, 0, encFileContents.length); totalRead < encFileContents.length && in.available() > 0 && (read = in.read(encFileContents, totalRead, encFileContents.length - totalRead)) != -1; totalRead += read) {
            }
        }
        catch (Exception ioe) {
            throw new Exception("IO error: " + ioe.getMessage());
        }
        if (totalRead != encFileContents.length) {
            throw new Exception("Entire datafile couldn't be read. Read " + totalRead + " of " + encFileContents.length);
        }
        in.close();
        in = new ByteArrayInputStream(encFileContents);
        DatafileCrypto.HeaderInfo hi = DatafileCrypto.readEncryptedHeader(in);
        if (hi == null) {
            if (!ProgramInfo.isPublic()) {
                throw getMsg;
            }
            if (violatedLimitPublic) {
                TSCreator.logAndShow(Language.translate("Cannot load unencrpted large files in Public Version", true), 3);
                throw new Exception("Public Limit Reached");
            }
            throw getMsg;
        }
        boolean found = false;
        int contentStart = 0;
        for (int i = 3; i < encFileContents.length && i < 5000; ++i) {
            if (encFileContents[i - 3] != 13 || encFileContents[i - 2] != 10 || encFileContents[i - 1] != 13 || encFileContents[i] != 10) continue;
            found = true;
            in.close();
            contentStart = i + 1;
            break;
        }
        if (!found) {
            throw new Exception("unknown file");
        }
        MessageDigest md = DatafileCrypto.getIntegrityHashFunction();
        md.update(encFileContents, contentStart, encFileContents.length - contentStart);
        byte[] encryptedHash = md.digest();
        if (hi.integrityHash == null || !DatafileCrypto.verifyHash(hi.integrityHash, encryptedHash)) {
            throw new Exception("The integrity of the datafile could not be verified.\r\nheader:    " + DatafileCrypto.byteToHexString(hi.integrityHash) + "\r\ncontents: " + DatafileCrypto.byteToHexString(encryptedHash));
        }
        in = new ByteArrayInputStream(encFileContents, contentStart, encFileContents.length);
        Cipher cipher = DatafileCrypto.getCipher(null, hi, false);
        CipherInputStream cryptIn = new CipherInputStream(in, cipher);
        do {
            if (DatafileCrypto.isDecryptedFile(cryptIn)) {
                cryptIn = null;
                in.close();
                cipher = DatafileCrypto.getCipher(null, hi, false);
                byte[] decryptedContents = cipher.doFinal(encFileContents, contentStart, encFileContents.length - contentStart);
                if (decryptedContents == null) {
                    throw new Exception("Not enough memory to decrypt file!");
                }
                in = new ByteArrayInputStream(decryptedContents);
                fileInfo.encrypted = true;
                db.load(in, fileInfo);
                return true;
            }
            cryptIn = null;
            in.close();
            in = new ByteArrayInputStream(encFileContents, contentStart, encFileContents.length);
            cipher = DatafileCrypto.getCipher(null, hi, false);
            cryptIn = new CipherInputStream(in, cipher);
            if (FileUtils.getExtension(fileInfo.loadPath).compareToIgnoreCase("dpk") != 0) continue;
            byte[] decryptedContents = cipher.doFinal(encFileContents, contentStart, encFileContents.length - contentStart);
            if (decryptedContents == null) {
                throw new Exception("Not enough memory to decrypt file!");
            }
            in = new ByteArrayInputStream(decryptedContents);
            byte[] b = new byte[in.available()];
            int len = in.read(b, 0, b.length);
            File temp = File.createTempFile("tempDataTSC", ".zip");
            FileOutputStream fos = new FileOutputStream(temp);
            while (len != -1) {
                fos.write(b, 0, len);
                len = in.read(b);
            }
            fos.close();
            this.loadDatapackFile(temp);
            return true;
        } while (FileUtils.getExtension(fileInfo.loadPath).compareToIgnoreCase("mdpk") != 0);
        byte[] decryptedContents = cipher.doFinal(encFileContents, contentStart, encFileContents.length - contentStart);
        if (decryptedContents == null) {
            throw new Exception("Not enough memory to decrypt file!");
        }
        in = new ByteArrayInputStream(decryptedContents);
        byte[] b = new byte[in.available()];
        int len = in.read(b, 0, b.length);
        File temp = File.createTempFile("tempMapTSC", ".map");
        FileOutputStream fos = new FileOutputStream(temp);
        while (len != -1) {
            fos.write(b, 0, len);
            len = in.read(b);
        }
        fos.close();
        try {
            this.doUIChanges(2, true, false);
            if (!this.parseMapPack(temp)) {
                TSCreator.logAndShow(Language.translate("No map data loaded.  Please input a proper .map file with data.", true), 4);
                this.doUIChanges(2, false, false);
                return false;
            }
            settings.mapDataAdded();
            TSCreator.logAndShow(Language.translate("Map Data loaded successfully!", true), 2);
            this.loadSuccessful(true);
        }
        catch (Exception e) {
            TSCreator.showInLabel(Language.translate("Error loading map file!", true), 3);
            ErrorHandler.showError(e, null, "Error map file!", 3);
        }
        this.doUIChanges(2, false, false);
        return true;
    }

    private int numCharsInFile(String filename) throws IOException {
        int numChars = 0;
        try {
            InputStream in = FileUtils.getInputStream(filename, true);
            byte[] encFileContents = new byte[in.available()];
            if (encFileContents == null) {
                throw new Exception("Not enough memory to decrypt file!");
            }
            numChars = encFileContents.length;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return numChars;
    }

    public void encryptDatafile() {
        int returnVal;
        JFileChooser chooser = new JFileChooser();
        ExtensionFileFilter eff = new ExtensionFileFilter();
        eff.setDescription("TSCreator files with extension (*.txt, *.zip, *.map)");
        eff.addExtension("txt", true);
        eff.addExtension("zip", true);
        eff.addExtension("map", true);
        chooser.setFileFilter(eff);
        if (fileChooserPath != null) {
            chooser.setCurrentDirectory(fileChooserPath);
        }
        if ((returnVal = chooser.showOpenDialog(tscFrame)) == 0) {
            fileChooserPath = chooser.getCurrentDirectory();
            try {
                String inPath = chooser.getSelectedFile().getAbsolutePath();
                FileInputStream fis = new FileInputStream(inPath);
                if (FileUtils.getExtension(inPath).equalsIgnoreCase("txt") && !DatafileCrypto.isDecryptedFile(fis)) {
                    ErrorHandler.messageBox("The selected file does not appear to be a TSCreator datafile.", "Cannot protect file", 3);
                    return;
                }
                fis.close();
                DatafileCrypto.HeaderInfo hi = new DatafileCrypto.HeaderInfo();
                hi.message = null;
                returnVal = chooser.showSaveDialog(tscFrame);
                if (returnVal == 0) {
                    FileOutputStream fos;
                    String outPath;
                    fis = new FileInputStream(inPath);
                    if (FileUtils.getExtension(inPath).equalsIgnoreCase("txt")) {
                        outPath = FileUtils.appendExtension(chooser.getSelectedFile().getAbsolutePath(), "txt");
                        fos = new FileOutputStream(outPath);
                    } else if (FileUtils.getExtension(inPath).equalsIgnoreCase("map")) {
                        outPath = FileUtils.appendExtension(chooser.getSelectedFile().getAbsolutePath(), "mdpk");
                        fos = new FileOutputStream(outPath);
                    } else {
                        outPath = FileUtils.appendExtension(chooser.getSelectedFile().getAbsolutePath(), "dpk");
                        fos = new FileOutputStream(outPath);
                    }
                    String error = DatafileCrypto.encrypt(fos, fis, null, hi);
                    if (error == null) {
                        TSCreator.logAndShow(Language.translate("Protected file created successfully!", true), 2);
                    } else {
                        TSCreator.logAndShow(Language.translate("Error while protecting file: ", true) + error, 3);
                    }
                    fis.close();
                    fos.close();
                }
            }
            catch (FileNotFoundException e) {
                TSCreator.logAndShow(Language.translate("File not found!", true), 3);
                ErrorHandler.showError(e, null, "File not found!", 3);
            }
            catch (IOException e) {
                TSCreator.logAndShow(Language.translate("IO Error!", true), 3);
                ErrorHandler.showError(e, null, "I/O Error!", 3);
            }
        }
    }

    public void showSettings() {
        if (!TSCreator.settings.isPopulated) {
            settings.populate(db);
        }
        settings.setVisible(true);
    }

    public void clearSettings() {
        if (settings != null) {
            settings.setVisible(false);
            settings = null;
        }
    }

    public void clearData() {
        if (settings != null) {
            settings.setVisible(false);
            settings = null;
        }
        if (this.editor != null) {
            this.editor.setVisible(false);
            this.editor = null;
        }
        if (this.crossplotFrame != null) {
            CrossplotFrame.crossplot.clearAllPoints();
            this.crossplotFrame.setVisible(false);
            this.crossplotFrame = null;
        }
        this.ig = null;
        this.columnImageGenerator = null;
        db = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateImage() {
        Settings settingsBackup;
        DataColumn dc;
        Iterator<DataColumn> subRootIter;
        ImageGenerator derp;
        block16: {
            if (!settings.isValidToGenerate()) {
                if (autoGenOptions == null) {
                    this.showSettings();
                }
                System.out.println("Settings is not valid to generate chart.");
                return;
            }
            derp = new ImageGenerator(TSCreator.db.rootColumn, settings, TSCreator.db.patMan);
            subRootIter = derp.rootCol.getSubColumns();
            while (subRootIter.hasNext()) {
                dc = subRootIter.next();
                settingsBackup = settings.getReadOnlySettings(dc.unit);
                if (!dc.isOutcrop) continue;
                settings.setTopAge(dc.unit, Double.toString(-settingsBackup.topAge));
                settings.setBaseAge(dc.unit, Double.toString(-settingsBackup.baseAge));
                settings.timesChanged(0, dc.unit);
            }
            this.doUIChanges(1, true, false);
            if (this.mainView != null) {
                this.mainViewLayout.show(this.mainView, "displayCanvas");
            }
            TSCreator.logAndShow(Language.translate("Generating Image...", true), 1);
            try {
                if (!NODE_MODE) {
                    this.displayCanvasPane.retainZoom(true);
                }
                if (this.displayCanvas != null) {
                    this.displayCanvas.setDocument(null);
                }
                this.ig = new ImageGenerator(TSCreator.db.rootColumn, settings, TSCreator.db.patMan);
                this.columnImageGenerator = new ColumnImageGenerator(TSCreator.db.rootColumn, settings, TSCreator.db.patMan);
                this.svgImage = this.ig.drawImage();
            }
            catch (ImageGenerator.NoColumnsToDrawException e) {
                TSCreator.showInLabel(Language.translate("Error! No columns selected", true), 3);
                ErrorHandler.showError(null, e.getMessage(), "Error! No columns selected", 3);
                this.bigError(false);
                this.doUIChanges(1, false, true);
                this.columnImageGenerator = null;
                this.ig = null;
                return;
            }
            catch (Exception e) {
                TSCreator.showInLabel(Language.translate("Internal error while generating!", true), 3);
                ErrorHandler.showError(e, null, "Internal error while generating!", 3);
                this.bigError(false);
                this.doUIChanges(1, false, true);
                this.columnImageGenerator = null;
                this.ig = null;
                return;
            }
            catch (OutOfMemoryError oeme) {
                TSCreator.logAndShow(Language.translate("Out of Memory!", true), 3);
                this.bigError(false);
                this.doUIChanges(1, false, true);
                this.columnImageGenerator = null;
                this.ig = null;
                return;
            }
            try {
                if (this.displayCanvas == null) break block16;
                TSCreator.logAndShow(Language.translate("Displaying Image...", true), 2);
                this.displayCanvas.setDocument(this.svgImage);
                TSCreator.logAndShow(Language.translate("Image generated! (please wait for it to appear)", true), 2);
                Object oeme = lock;
                synchronized (oeme) {
                    lock.notifyAll();
                }
            }
            catch (OutOfMemoryError oeme) {
                TSCreator.logAndShow(Language.translate("Out of Memory.", true), 3);
                this.bigError(true);
            }
        }
        this.doUIChanges(1, false, false);
        subRootIter = derp.rootCol.getSubColumns();
        while (subRootIter.hasNext()) {
            dc = subRootIter.next();
            settingsBackup = settings.getReadOnlySettings(dc.unit);
            if (!dc.isOutcrop) continue;
            settings.setTopAge(dc.unit, Double.toString(-settingsBackup.topAge));
            settings.setBaseAge(dc.unit, Double.toString(-settingsBackup.baseAge));
            settings.timesChanged(0, dc.unit);
        }
    }

    public void doUIChanges(int action, boolean gen, boolean error) {
        settings.showGenerating(gen);
        this.loadReplaceWithBuiltInAction.setEnabled(!gen);
        this.loadAddWithBuiltInAction.setEnabled(!gen);
        this.loadAddFromFileAction.setEnabled(!gen);
        this.loadReplaceWithFileAction.setEnabled(!gen);
        this.generateAction.setEnabled(!gen);
        this.settingsAction.setEnabled(!gen);
        this.editDataAction.setEnabled(!gen);
        this.saveTemplateAction.setEnabled(!gen);
        this.loadTemplateAction.setEnabled(!gen);
        this.createCrossplotAction.setEnabled(!gen);
        switch (action) {
            case 1: {
                this.saveSVGAction.setEnabled(!gen && !error);
                this.saveRasterAction.setEnabled(!gen && !error);
                this.savePDFAction.setEnabled(!gen && !error);
                this.imageSizeAction.setEnabled(!gen && !error);
                this.zoomInAction.setEnabled(!gen && !error);
                this.zoomOutAction.setEnabled(!gen && !error);
                this.actualSizeAction.setEnabled(!gen && !error);
                this.fitToWindowAction.setEnabled(!gen && !error);
                this.showLine.setEnabled(!gen && !error);
                break;
            }
            case 2: {
                this.saveSVGAction.setEnabled(false);
                this.saveRasterAction.setEnabled(false);
                this.savePDFAction.setEnabled(false);
                this.imageSizeAction.setEnabled(false);
                this.zoomInAction.setEnabled(false);
                this.zoomOutAction.setEnabled(false);
                this.actualSizeAction.setEnabled(false);
                this.fitToWindowAction.setEnabled(false);
                this.showLine.setEnabled(false);
                break;
            }
            case 3: {
                this.saveSVGAction.setEnabled(!gen);
                this.saveRasterAction.setEnabled(!gen);
                this.savePDFAction.setEnabled(!gen);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadSuccessful(boolean tf) {
        this.settingsAction.setEnabled(tf);
        this.generateAction.setEnabled(tf);
        Object object = lock;
        synchronized (object) {
            lock.notifyAll();
        }
    }

    public void addPatterns() throws Exception {
        int returnVal;
        JFileChooser chooser = new JFileChooser();
        ExtensionFileFilter eff = new ExtensionFileFilter();
        eff.setDescription("Patterns (*.svg)");
        eff.addExtension("svg", true);
        chooser.setFileFilter(eff);
        if (fileChooserPath != null) {
            chooser.setCurrentDirectory(fileChooserPath);
        }
        if ((returnVal = chooser.showOpenDialog(tscFrame)) == 0) {
            String path = chooser.getSelectedFile().getAbsolutePath();
            ErrorHandler.log("Loading patterns from " + path);
            fileChooserPath = chooser.getCurrentDirectory();
            TSCreator.db.patMan.readPatternsFromSVG(path, false);
            TSCreator.logAndShow(Language.translate("Done reading patterns.", true), 1);
        }
    }

    public void save(String format, RasterSave.RasterSaveOptions rasterOptions) {
        if (format.compareTo("SVG") != 0 && format.compareTo("PDF") != 0 && format.compareTo("PNG") != 0 && format.compareTo("JPG") != 0 && format.compareTo("RASTER") != 0) {
            return;
        }
        Element timelabel = this.ig.doc.getElementById("TimeLineLabel");
        Element timelabel_up = this.ig.doc.getElementById("TimeLineLabelUp");
        Element timelabel_down = this.ig.doc.getElementById("TimeLineLabelDown");
        if (timelabel != null && !TIMELINE) {
            timelabel.setAttributeNS(null, "visibility", "hidden");
            timelabel_up.setAttributeNS(null, "visibility", "hidden");
            timelabel_down.setAttributeNS(null, "visibility", "hidden");
        }
        JFileChooser chooser = new JFileChooser();
        ExtensionFileFilter effPNG = new ExtensionFileFilter();
        ExtensionFileFilter effJPG = new ExtensionFileFilter();
        if (format.compareTo("RASTER") == 0) {
            effPNG.setDescription("PNG file (*.png)");
            effPNG.addExtension("png", true);
            effJPG.setDescription("JPEG file (*.jpg)");
            effJPG.addExtension("jpg", true);
            effJPG.addExtension("jpeg", true);
            chooser.addChoosableFileFilter(effJPG);
            chooser.setFileFilter(effPNG);
        } else {
            ExtensionFileFilter eff = new ExtensionFileFilter();
            eff.setDescription(format + " file (*." + format.toLowerCase() + ")");
            eff.addExtension(format.toLowerCase(), true);
            chooser.setFileFilter(eff);
        }
        int returnVal = chooser.showSaveDialog(tscFrame);
        if (returnVal == 0) {
            int reply;
            String absolutePath;
            File f;
            if (format.compareTo("RASTER") == 0) {
                ExtensionFileFilter eff;
                String ext = FileUtils.getExtension(chooser.getSelectedFile().getName());
                format = ext == null ? ((eff = (ExtensionFileFilter)chooser.getFileFilter()) == effPNG ? "PNG" : "JPG") : (ext.compareToIgnoreCase("PNG") == 0 ? "PNG" : "JPG");
            }
            if ((f = new File(absolutePath = FileUtils.appendExtension(chooser.getSelectedFile().getAbsolutePath(), format.toLowerCase()))).exists() && !f.isDirectory() && (reply = JOptionPane.showConfirmDialog(null, "A file with the same name already exists, are you sure you want to overwrite it?", "Overwrite", 0)) == 1) {
                this.save(format, rasterOptions);
                return;
            }
            TSCreator.logAndShow("Writing " + format + " to " + absolutePath + "...", 1);
            try {
                if (format.compareToIgnoreCase("PDF") == 0) {
                    this.saveToFile(FileUtils.appendExtension(absolutePath, "svg"), "SVG", rasterOptions);
                }
                this.saveToFile(absolutePath, format, rasterOptions);
            }
            catch (Exception e) {
                ErrorHandler.showError(e, null, "Error writing " + format, 3);
                TSCreator.showInLabel("", 3);
                return;
            }
            catch (OutOfMemoryError oome) {
                TSCreator.logAndShow(Language.translate("Error writing ", true) + format + Language.translate("! Out of memory!", true), 3);
                return;
            }
            TSCreator.logAndShow(format + Language.translate(" file successfully written.", true), 2);
        }
    }

    public void saveToFile(String absolutePath, String format, RasterSave.RasterSaveOptions rasterOptions) throws Exception {
        if (format.compareToIgnoreCase("SVG") == 0) {
            OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(absolutePath), "UTF-8");
            this.ig.write(fw);
            fw.close();
        } else if (format.compareToIgnoreCase("PDF") == 0) {
            FileOutputStream fw = new FileOutputStream(absolutePath);
            this.ig.writePDF(fw);
            ((OutputStream)fw).close();
        } else if (format.compareToIgnoreCase("PNG") == 0) {
            FileOutputStream fw = new FileOutputStream(absolutePath);
            this.ig.writePNG(fw, rasterOptions.width, rasterOptions.height);
            fw.close();
        } else if (format.compareToIgnoreCase("JPG") == 0 || format.compareToIgnoreCase("JPEG") == 0) {
            FileOutputStream fw = new FileOutputStream(absolutePath);
            this.ig.writeJPG(fw, rasterOptions.width, rasterOptions.height);
            fw.close();
        }
    }

    public static boolean extractZip(ZipFile zip, File dir, boolean deleteOnExit) {
        if (!dir.isDirectory()) {
            return false;
        }
        Enumeration<? extends ZipEntry> entries = zip.entries();
        String slash = System.getProperty("file.separator");
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String path = dir + slash + entry.getName();
            File f = new File(path);
            if (entry.isDirectory()) {
                f.mkdirs();
                if (!deleteOnExit) continue;
                f.deleteOnExit();
                continue;
            }
            try {
                File fdir = f.getParentFile();
                if (!fdir.exists()) {
                    fdir.mkdirs();
                    if (deleteOnExit) {
                        fdir.deleteOnExit();
                    }
                }
                f.createNewFile();
                if (deleteOnExit) {
                    f.deleteOnExit();
                }
                FileOutputStream fos = new FileOutputStream(f);
                InputStream is = zip.getInputStream(entry);
                byte[] b = new byte[10240];
                while (is.available() > 0) {
                    int read = is.read(b);
                    fos.write(b, 0, read);
                }
            }
            catch (IOException e) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object e = evt.getSource();
        String confirmMessage1 = "Are you sure to replace current datapack with default datapack?";
        String confirmMessage2 = "Are you sure to replace current datapack with new datapack?";
        String title = "Replace Confirmation";
        try {
            if (e != null) {
                if (e == this.loadReplaceWithBuiltInAction) {
                    int reply = JOptionPane.showConfirmDialog(null, confirmMessage1, title, 0);
                    if (reply == 0) {
                        this.clearData();
                        numDatapacksAdded = 0;
                        this.loadDefaultData();
                    }
                } else if (e == this.loadAddWithBuiltInAction) {
                    this.clearSettings();
                    this.loadDefaultData();
                } else if (e == this.loadReplaceWithFileAction) {
                    int reply = JOptionPane.showConfirmDialog(null, confirmMessage2, title, 0);
                    if (reply == 0) {
                        numDatapacksAdded = 0;
                        System.gc();
                        this.loadDataFromFile(true, false);
                    }
                } else if (e == this.loadAddFromFileAction) {
                    this.loadDataFromFile(false, false);
                } else if (e == this.saveAsAction) {
                    this.saveDataAs();
                } else if (e == this.saveAsJsonAction) {
                    this.saveDataAsJson();
                } else if (e != this.clearAction) {
                    if (e == this.viewPatternsAction) {
                        new PatternViewer(TSCreator.db.patMan).setVisible(true);
                    } else if (e == this.addPatternsAction) {
                        this.addPatterns();
                    } else if (e == this.showGTSversion) {
                        GTSVersion v = new GTSVersion(tscFrame);
                        v.setVisible(true);
                    } else if (e == this.saveSVGAction) {
                        if (ProgramInfo.isPublic() && ProgramInfo.isSavingEnabled() || !ProgramInfo.isPublic()) {
                            this.save("SVG", null);
                        }
                    } else if (e == this.saveRasterAction) {
                        if (ProgramInfo.isPublic() && ProgramInfo.isSavingEnabled() || !ProgramInfo.isPublic()) {
                            RasterSave rs = new RasterSave(tscFrame, this.svgImage, this.displayCanvas.getCurrentZoomRatio(), this);
                            rs.setVisible(true);
                        }
                    } else if (e == this.savePDFAction) {
                        if (ProgramInfo.isPublic() && ProgramInfo.isSavingEnabled() || !ProgramInfo.isPublic()) {
                            this.save("PDF", null);
                        }
                    } else if (e == this.encryptDataAction) {
                        this.encryptDatafile();
                    } else if (e == this.convertDataPackAction) {
                        Converter conv = new Converter();
                        Converter.running = false;
                        conv.initGUI();
                    } else if (e == this.editDataAction) {
                        if (this.editor == null) {
                            this.editor = new DataEditor(db, this);
                        }
                        this.editor.setVisible(true);
                    } else if (e == this.saveTemplateAction) {
                        TemplateGen gen = new TemplateGen(tscFrame);
                        gen.setVisible(true);
                    } else if (e == this.loadTemplateAction) {
                        int returnVal;
                        JFileChooser chooser = new JFileChooser();
                        ExtensionFileFilter eff = new ExtensionFileFilter();
                        eff.setDescription("Patterns (*.svg)");
                        eff.addExtension("svg", true);
                        chooser.setFileFilter(eff);
                        if (fileChooserPath != null) {
                            chooser.setCurrentDirectory(fileChooserPath);
                        }
                        if ((returnVal = chooser.showOpenDialog(this)) == 0) {
                            String path = chooser.getSelectedFile().getAbsolutePath();
                            fileChooserPath = chooser.getCurrentDirectory();
                            new TemplateLoader(tscFrame, path, db);
                        }
                    } else if (e == this.createCrossplotAction) {
                        this.crossplotFrame = new CrossplotFrame(curCreator);
                        CrossplotFrame.crossplot.clearAllPoints();
                        this.crossplotFrame.setVisible(true);
                    } else if (e == this.addSomeRascFileAction) {
                        DataColumn.FileInfo fileInfo = new DataColumn.FileInfo();
                        fileInfo.loadPath = "F:\\QSCreator\\rasc\\14CEN.DAT";
                        db.loadRASC(fileInfo);
                    } else if (e == this.exitAction) {
                        System.exit(0);
                    } else if (e == this.loadDefaultColoringAction) {
                        this.loadDefaultColoring();
                    } else if (e == this.settingsAction) {
                        this.showSettings();
                    } else if (e == this.generateAction) {
                        this.generateImage();
                    } else if (e == this.imageSizeAction) {
                        ImageSizeDialog d = new ImageSizeDialog(tscFrame, this.svgImage);
                        d.setVisible(true);
                    } else if (e == this.zoomInAction) {
                        this.displayCanvasPane.zoomBy(1.25);
                    } else if (e == this.zoomOutAction) {
                        this.displayCanvasPane.zoomBy(0.8);
                    } else if (e == this.actualSizeAction) {
                        this.displayCanvasPane.resetTransform();
                        this.displayCanvasPane.recenter();
                    } else if (e == this.fitToWindowAction) {
                        this.displayCanvasPane.zoomToFit();
                    } else if (e == this.showLine) {
                        TIMELINE = !TIMELINE;
                        Element timeline = this.ig.doc.getElementById("timeline");
                        Element timeline_up = this.ig.doc.getElementById("timeline_up");
                        Element timeline_down = this.ig.doc.getElementById("timeline_down");
                        Element timelabel = this.ig.doc.getElementById("TimeLineLabel");
                        Element timelabel_up = this.ig.doc.getElementById("TimeLineLabelUp");
                        Element timelabel_down = this.ig.doc.getElementById("TimeLineLabelDown");
                        if (timeline != null && timelabel != null) {
                            timeline.setAttribute("style", "stroke-opacity: 0;");
                            timeline_up.setAttribute("style", "stroke-opacity: 0;");
                            timeline_down.setAttribute("style", "stroke-opacity: 0;");
                            timelabel.setAttribute("style", "fill-opacity: 0;");
                            timelabel_up.setAttribute("style", "fill-opacity: 0;");
                            timelabel_down.setAttribute("style", "fill-opacity: 0;");
                            if (TIMELINE) {
                                timeline.setAttribute("style", "stroke: red; stroke-opacity: 0.5;");
                                timeline_up.setAttribute("style", "stroke: red; stroke-opacity: 0.5;");
                                timeline_down.setAttribute("style", "stroke: red; stroke-opacity: 0.5;");
                                timelabel.setAttribute("style", "font-family: verdana; fill: red; fill-opacity: 0.7;");
                                timelabel_up.setAttribute("style", "font-family: verdana; fill: red; fill-opacity: 0.7;");
                                timelabel_down.setAttribute("style", "font-family: verdana; fill: red; fill-opacity: 0.7;");
                            }
                        }
                    } else if (e == this.quickstartAction) {
                        new HTMLViewerDialog("Quick Start Guide", ResPath.getPath("html.quickstart"), 600, 400, null).setVisible(true);
                    } else if (e == this.tourAction) {
                        new HTMLViewerDialog("Tour", ResPath.getPath("html.tour"), 600, 400, null).setVisible(true);
                    } else if (e == this.featureInfoAction) {
                        new HTMLViewerDialog("Features", ResPath.getPath("html.features_summary"), 1000, 500, null).setVisible(true);
                    } else if (e == this.licenseAction) {
                        new HTMLViewerDialog("License", ResPath.getPath("html.license"), 650, 400).setVisible(true);
                    } else if (e == this.fileFormatInfoAction) {
                        new HTMLViewerDialog("File Format Info", ResPath.getPath("html.file_format_guide"), 600, 500, null).setVisible(true);
                    } else if (e == this.contactAction) {
                        HTMLViewerDialog HDia = new HTMLViewerDialog("Contact", ResPath.getPath("html.contact"), 450, 560, null);
                        HDia.setVisible(true);
                        HDia.setResizable(false);
                    } else if (e == this.websiteInfoAction) {
                        new WebsiteInfoDialog(tscFrame).setVisible(true);
                    } else if (e == this.aboutAction) {
                        new HTMLViewerDialog("About", ResPath.getPath("html.about"), 600, 350).setVisible(true);
                    } else if (e == this.appletDoAfterLoading) {
                        this.appletDoAfterLoading();
                    }
                }
            }
        }
        catch (Exception ex) {
            ErrorHandler.showError(ex, null, "Unknown error", 3);
        }
    }

    public void bigError(boolean canSave) {
        this.svgImage = null;
        this.displayCanvas.setDocument(null);
        this.saveSVGAction.setEnabled(canSave);
        this.savePDFAction.setEnabled(canSave);
        this.imageSizeAction.setEnabled(false);
        this.zoomInAction.setEnabled(true);
        this.zoomOutAction.setEnabled(true);
        this.actualSizeAction.setEnabled(true);
        this.fitToWindowAction.setEnabled(true);
        this.showLine.setEnabled(true);
        this.htmlView.setEditable(false);
        this.htmlView.setContentType("text/html");
        String filename = ResPath.getPath("html.bigerror-cansave");
        if (!canSave) {
            filename = ResPath.getPath("html.bigerror-cannotsave");
        }
        this.htmlView.setText(HTMLPreprocessor.process(filename));
        this.mainViewLayout.show(this.mainView, "htmlView");
        Runtime.getRuntime().gc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void showInLabel(String s, int type) {
        if (curCreator == null) {
            return;
        }
        if (TSCreator.curCreator.info == null) {
            return;
        }
        JLabel jLabel = TSCreator.curCreator.info;
        synchronized (jLabel) {
            switch (type) {
                case 2: {
                    TSCreator.curCreator.info.setForeground(new Color(0, 128, 0));
                    break;
                }
                case 4: {
                    TSCreator.curCreator.info.setForeground(new Color(128, 128, 0));
                    break;
                }
                case 3: {
                    TSCreator.curCreator.info.setForeground(new Color(128, 0, 0));
                    break;
                }
                default: {
                    TSCreator.curCreator.info.setForeground(new Color(0, 0, 0));
                }
            }
            TSCreator.curCreator.info.setText(s);
        }
    }

    public static void logAndShow(String s, int type) {
        TSCreator.showInLabel(s, type);
        ErrorHandler.log(s, type);
    }

    public static void launchBrowser(String url) {
        try {
            ErrorHandler.log("launching " + url, 5);
            Desktop.getDesktop().browse(URI.create(url));
        }
        catch (Exception e) {
            TSCreator.logAndShow(Language.translate("Error launching browser.", true), 3);
        }
    }

    public static void exit() {
        System.exit(1);
    }

    @Override
    public void init() {
        if (!isApplet) {
            return;
        }
        try {
            String datafileParam = this.getParameter("datafile");
            if (datafileParam != null) {
                ErrorHandler.log("Setting datafile from parameter to: " + datafileParam);
                DEFAULT_DATA_FILE = datafileParam;
            }
        }
        catch (Exception datafileParam) {
            // empty catch block
        }
        this.loadReplaceWithBuiltInAction.doWhenDone(this.appletDoAfterLoading);
        try {
            this.initialize();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        curCreator = this;
    }

    protected void appletDoAfterLoading() {
        try {
            String topAge = this.getParameter("topage");
            String baseAge = this.getParameter("baseage");
            if (topAge != null && baseAge != null) {
                settings.setTopAge(db.getCurrentUnits(), topAge);
                settings.setBaseAge(db.getCurrentUnits(), baseAge);
            }
        }
        catch (Exception topAge) {
            // empty catch block
        }
        try {
            String generateParam = this.getParameter("generate");
            boolean generate = Boolean.parseBoolean(generateParam);
            if (generate) {
                this.generateAction.actionPerformed(null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    public static boolean isApplet() {
        return isApplet;
    }

    public static void activationSucceeded() {
        TSCreator.startTSC();
    }

    public static void activationFailed() {
        System.exit(1);
    }

    public static void main(String[] args) {
        if (args != null) {
            boolean exit = false;
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equalsIgnoreCase("-proifpro")) {
                    System.out.println(ProgramInfo.isPublic() ? "" : "PRO");
                    exit = true;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-version")) {
                    Debug.turnOffDebugMessages();
                    System.out.println(ProgramInfo.get("TSC_VERSION_NUMBER"));
                    Debug.turnOnDebugMessages();
                    exit = true;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-d")) {
                    if (args.length == i + 1) continue;
                    BUILT_IN_DATA_FILE = args[i + 1];
                    command_line_datapack_flag = true;
                    System.out.println("Using datafile: " + BUILT_IN_DATA_FILE);
                    command_line_datapacks = new ArrayList<String>();
                    int n = 2;
                    String nextArg = args[i + n];
                    while (nextArg.length() > 1 && !nextArg.contains("-")) {
                        command_line_datapacks.add(nextArg);
                        nextArg = args[i + ++n];
                    }
                    System.out.println(command_line_datapacks.size());
                    continue;
                }
                if (args[i].equalsIgnoreCase("-ss")) {
                    if (args.length == i + 1) continue;
                    SETTINGS_FILE = args[i + 1];
                    command_line_settings_flag = true;
                    System.out.println("Saving settings to: " + SETTINGS_FILE);
                    continue;
                }
                if (args[i].equalsIgnoreCase("-o")) {
                    if (args.length == i + 1) {
                        System.out.println("-o switch requires a file.");
                        TSCreator.exit();
                    }
                    autoSaveFile = args[i + 1];
                    System.out.println("Will save to: " + autoSaveFile);
                    continue;
                }
                if (args[i].equalsIgnoreCase("-oo")) {
                    if (autoGenOptions == null) {
                        autoGenOptions = new AutoGenOptions();
                    }
                    if (args.length == i + 1) {
                        System.out.println("-oo switch requires an argument");
                        TSCreator.exit();
                        continue;
                    }
                    if (autoGenOptions.parseCommandLineArgument(args[i + 1])) continue;
                    System.out.println("Unknown switch -oo " + args[i + 1] + "\r\nQuitting.");
                    TSCreator.exit();
                    continue;
                }
                if (args[i].equalsIgnoreCase("-s")) {
                    if (args.length == i + 1) {
                        System.out.println("-s switch requires a file.");
                        TSCreator.exit();
                    }
                    DEFAULT_SETTINGS_FILE = args[i + 1];
                    command_line_settings_flag = true;
                    System.out.println("Using settings file: " + DEFAULT_SETTINGS_FILE);
                    continue;
                }
                if (args[i].equalsIgnoreCase("-node")) {
                    System.out.println("Running node...");
                    NODE_MODE = true;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-rw")) {
                    try {
                        REWRITE_COLUMN_PACK = true;
                        columnpackIn = args[i + 1];
                        columnpackOut = args[i + 2];
                    }
                    catch (Exception e) {
                        System.out.println("Usage : -rw file1 file2");
                        TSCreator.exit();
                    }
                    continue;
                }
                if (args[i].equalsIgnoreCase("-testing")) {
                    testingMode = true;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-h")) {
                    String help = "TSCreator command line options:\r\n -h                  - This help screen\r\n -d file             - Datapack to load at startup.\r\n -ss file            - Save Settings.\r\n -d file             - Datapack to load at startup.\r\n -s file             - Settings file to load at startup.\r\n -o file             - Output file. This causes TSCreator to load its data, immediately generate an image, save it to this file, and quit. Can be combined with the -d, -s, and -oo options for generating automated charts on the fly.\r\n -oo option          - Output Option, combined with one of the following. Multiple -oo options are ok. Allows basic control over settings to use with -o. \r\n -server num         - Starts the server mode for the web interface tsCreatorLite with num number of threads.\r\n -rw  file1 file2    - Rewrites the columnpack with information such as column description minAge and maxAge.\r\n -node           - Runs TSCreator for node application\r\n\n -testing\t\t\t- Runs TSCreator without restarting JVM. \r\n\n" + AutoGenOptions.getSupportedCommandLineArgumentOptions();
                    System.out.println(help);
                    TSCreator.exit();
                    continue;
                }
                if (args[i].equalsIgnoreCase("-pass") || !args[i].equalsIgnoreCase("-alreadySpawned")) continue;
                VM_ALREADY_SPAWNED = true;
            }
            if (exit) {
                return;
            }
        }
        if (autoGenOptions != null) {
            autoGenOptions.finishUp();
        }
        if (!testingMode) {
            try {
                String vmBits = System.getProperty("sun.arch.data.model");
                if (vmBits.equals("64")) {
                    JavaVMOptions.start("2048m", args, VM_ALREADY_SPAWNED);
                } else {
                    JavaVMOptions.start("1024m", args, VM_ALREADY_SPAWNED);
                }
            }
            catch (IOException e) {
                System.out.println("FATAL ERROR: could not spawn new Java VM!");
                e.printStackTrace();
            }
        }
        if (REQUIRE_PASSWORD) {
            PasswordDialog.requirePassword(MD5_HASH_OF_PASSWORD);
        }
        ResPath.initializeDependentData();
        if (BUILT_IN_DATA_FILE == null) {
            BUILT_IN_DATA_FILE = ResPath.getPath("datapacks.builtin_data");
            Debug.print("Built-in datapack is: " + BUILT_IN_DATA_FILE);
        }
        try {
            String nativeLF = UIManager.getSystemLookAndFeelClassName();
            UIManager.setLookAndFeel(nativeLF);
        }
        catch (Exception nativeLF) {
            // empty catch block
        }
        if (isApplet) {
            ErrorHandler.showError("This version of TSCreator is a Java applet and cannot be run as a standalone application.", "TSCreator PRO APPLET", 3);
            return;
        }
        Calendar c = Dater.getExpireDate();
        if (!Dater.isOk(c)) {
            System.out.println("This trial version of TSCreator is expired.");
            ErrorHandler.messageBox("This trial version of TSCreator is expired.", "Trial Expired", 3);
            return;
        }
        try {
            System.out.println("Available heap memory: " + Runtime.getRuntime().maxMemory() + " bytes.");
        }
        catch (NoSuchMethodError i) {
            // empty catch block
        }
        if (isActivationRequired) {
            ActivationChecker ac = new ActivationChecker(null, ProgramInfo.get("TSC_VERSION"));
            ac.pack();
            ac.setVisible(true);
        } else {
            TSCreator.startTSC();
        }
    }

    protected static void startTSC() {
        new TSCreator(false);
    }

    public ColumnImageGenerator getColumnImageGenerator() {
        return new ColumnImageGenerator(TSCreator.db.rootColumn, settings, TSCreator.db.patMan);
    }

    public static boolean isDatapackInfoFile(File file) {
        boolean result = false;
        try {
            BufferedReader br = new BufferedReader(new FileReader(file));
            String line = br.readLine();
            if (line.startsWith("DATAPACK-INFO")) {
                result = true;
            }
            br.close();
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    public Settings getStaticSettings() {
        settings1 = settings;
        return settings1;
    }

    public static void setSettings(SelectedTimes st) {
        if (settings != null) {
            settings1 = settings;
        } else {
            new TSCreator();
            settings1 = settings;
        }
        TSCreator.settings.baseAge = TSCreator.settings1.baseAge = st.baseAge;
        TSCreator.settings.topAge = TSCreator.settings1.topAge = st.topAge;
    }

    public void setFlagsOptions(File file) {
        try {
            String extension = FileUtils.getExtension(file.getName());
            if (extension.equalsIgnoreCase("txt")) {
                CSVReader reader = new CSVReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"), '\t');
                String key = "";
                depthFile = null;
                boolean i = false;
                String[] value = reader.readNext();
                key = value[0];
                containsOptionalFlags = key.compareToIgnoreCase("Default chronostrat:") == 0 || key.compareToIgnoreCase("format version:") == 0 || key.compareToIgnoreCase("outcrop:") == 0 || key.compareToIgnoreCase("date:") == 0 || key.compareToIgnoreCase("age units:") == 0 || key.compareToIgnoreCase("default chronotrat") == 0 || key.compareToIgnoreCase("chart title:") == 0 || key.compareToIgnoreCase("interval column:") == 0 || key.compareToIgnoreCase("settop:") == 0 || key.compareToIgnoreCase("setbase:") == 0 || key.compareToIgnoreCase("setscale:") == 0 || key.compareToIgnoreCase("TSCreator Encrypted Datafile") == 0;
            }
        }
        catch (Exception e) {
            Debug.print(e.getMessage());
        }
    }

    public String OKButtonActionPerformed(ActionEvent evt) {
        LASConverter lscv = new LASConverter();
        ArrayList<String> contentList = new ArrayList();
        ArrayList<List<String>> fileList = new ArrayList();
        ArrayList<String> units = new ArrayList();
        List<Object> maxPoints = new ArrayList();
        ArrayList<String> titleList = new ArrayList();
        ArrayList<String> widthList = new ArrayList();
        ArrayList<String> colorList = new ArrayList();
        ArrayList<String> pointList = new ArrayList();
        ArrayList<String> lineList = new ArrayList();
        ArrayList<String> fillList = new ArrayList();
        ArrayList<String> lowList = new ArrayList();
        ArrayList<String> highList = new ArrayList();
        ArrayList<String> smoothedList = new ArrayList();
        titleList = this.lg.getTitleList();
        widthList = this.lg.getWidthList();
        colorList = this.lg.getColorList();
        pointList = this.lg.getPointList();
        lineList = this.lg.getLineList();
        fillList = this.lg.getFillList();
        lowList = this.lg.getLowList();
        highList = this.lg.getHighList();
        smoothedList = this.lg.getSmoothedList();
        try {
            JFileChooser saveFileChooser = new JFileChooser();
            saveFileChooser.setFileFilter(new FileNameExtensionFilter(".txt", ".txt"));
            String saveFileName = this.tempIn.getName().split("\\.")[0];
            saveFileChooser.setSelectedFile(new File(saveFileName));
            if (saveFileChooser.showSaveDialog(this) == 0) {
                this.tempOut = saveFileChooser.getSelectedFile();
                this.tempOutLoc = this.tempOut.getAbsolutePath();
                if (!this.tempOutLoc.endsWith(".txt")) {
                    this.tempOutLoc = this.tempOutLoc + ".txt";
                }
            }
            contentList = lscv.readfile(this.tempIn.getAbsolutePath());
            List<String> header = lscv.getHeader(contentList);
            fileList = lscv.fileProcessing(contentList, header);
            units = lscv.getUnits(contentList);
            maxPoints = lscv.getMaxPoint(fileList);
            String ageUnit = this.lg.hp.ageUnitText.getText();
            double top = Double.parseDouble(this.lg.hp.topText.getText());
            double base = Double.parseDouble(this.lg.hp.baseText.getText());
            double scale = Double.parseDouble(this.lg.hp.scaleText.getText());
            String title = this.lg.hp.titleText.getText();
            lscv.writeFile(fileList, this.tempOutLoc, units, ageUnit, titleList, widthList, colorList, pointList, lineList, fillList, lowList, highList, smoothedList, top, base, scale, title);
            return this.tempOutLoc;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Temporary file creation failed!");
            e.printStackTrace();
            return null;
        }
    }

    static {
        fileChooserPath = null;
        topFlag = true;
        baseFlag = true;
        vertFlag = true;
        TIMELINE = false;
        SERVER_NEW_SETTINGS = ProgramInfo.get("SERVER_NEW_SETTINGS");
        SERVER_TEMP_SETTINGS = ProgramInfo.get("SERVER_TEMP_SETTINGS");
        SERVER_USED_SETTINGS = ProgramInfo.get("SERVER_USED_SETTINGS");
        SERVER_OUTPUT_SETTINGS = ProgramInfo.get("SERVER_OUTPUT_SETTINGS");
        SERVER_PDF_OUTPUT = ProgramInfo.get("SERVER_PDF_OUTPUT");
        SERVER_COL_PACKS = ProgramInfo.get("SERVER_COL_PACKS");
        SERVER_COL_OUTPUT = ProgramInfo.get("SERVER_COL_OUTPUT");
        REWRITE_COLUMN_PACK = false;
        NODE_MODE = false;
        VM_ALREADY_SPAWNED = false;
        DESKTOP_VERSION = true;
        containsOptionalFlags = true;
        lock = new Object();
        testingMode = false;
        myOrder = 0;
    }
}

