/*
 * Decompiled with CFR 0.152.
 */
package map;

import java.awt.Color;
import java.awt.Point;

public abstract class MapLocation {
    public static Color COLOR_AVAILABLE = Color.white;
    public static Color COLOR_SELECTED = Color.green;
    public static Color COLOR_INFORMATIONAL = Color.gray;
    public static Color COLOR_NO_INTERVAL_DATA = Color.red;
    public static Color COLOR_NO_INTERVAL_DATA_TRANSPARENT = new Color(1.0f, 1.0f, 1.0f, 0.0f);
    private Point center;
    private boolean selected = false;
    String locationName;
    private String note;
    public double longitude;
    public double latitude;

    private MapLocation(double longitude, double latitude) {
        this(longitude, latitude, "");
    }

    public MapLocation(double longitude, double latitude, String name) {
        this.latitude = latitude;
        this.longitude = longitude;
        this.locationName = name;
    }

    public MapLocation(double longitude, double latitude, String name, String note) {
        this.latitude = latitude;
        this.longitude = longitude;
        this.locationName = name;
        if (note == null) {
            note = "";
        }
        this.note = note;
    }

    public String getNote() {
        if (this.note == null) {
            this.note = "";
        }
        return this.note;
    }

    public String getLocationName() {
        return this.locationName;
    }

    public void setLocationName(String locationName) {
        this.locationName = locationName;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public void setCenter(Point dot) {
        this.center = dot;
    }

    public Point getCenter() {
        return this.center;
    }

    public void changeSelected() {
        if (this.selected) {
            this.setSelected(false);
        } else {
            this.setSelected(true);
        }
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean isSelected() {
        return this.selected;
    }
}

