/*
 * Decompiled with CFR 0.152.
 */
package model;

import java.util.ArrayList;
import java.util.List;
import model.Column;
import model.Data;
import model.ModelIdentifier;
import model.PointColumn;
import model.storage.PointDataStorage;
import model.storage.Storage;
import model.util.SourceResult;

public class PointData
extends Data {
    private ModelIdentifier identifier = null;
    private double xValue;
    private double ageValue;
    private boolean deleted = false;
    private String creationDate = "";
    private String lastModified = "";

    public PointData(PointColumn c, String database) {
        super((Column)c, database);
        this.setIdentifier(new ModelIdentifier(0, database, 17));
    }

    public PointData(PointColumn c, ModelIdentifier id, SourceResult result) {
        super((Column)c, result);
        this.setIdentifier(id);
        this.setxValue(result.getDouble("x_value"));
        this.setDeleted(result.getBool("deleted"));
        this.setCreationDate(result.getString("creationDate"));
        this.setLastModified(result.getString("lastModified"));
    }

    @Override
    public final void save() {
        super.save();
        if (this.identifier == null) {
            return;
        }
        if (this.identifier.getId() == 0) {
            PointDataStorage.insert(this);
            this.getIdentifier().setId(Storage.getLastInsertId().getInt("id"));
        } else {
            PointDataStorage.update(this);
        }
    }

    @Override
    public ModelIdentifier getIdentifier() {
        return this.identifier;
    }

    public final void setIdentifier(ModelIdentifier identifier) {
        this.identifier = identifier;
    }

    public double getxValue() {
        return this.xValue;
    }

    public final void setxValue(double xValue) {
        this.xValue = xValue;
    }

    public double getAgeValue() {
        return this.ageValue;
    }

    public final void setAgeValue(double ageValue) {
        this.ageValue = ageValue;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public final void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public String getLastModified() {
        return this.lastModified;
    }

    private void setLastModified(String lastModified) {
        this.lastModified = lastModified;
    }

    public String getCreationDate() {
        return this.creationDate;
    }

    private void setCreationDate(String creationDate) {
        this.creationDate = creationDate;
    }

    public static class Factory {
        public static PointData getByIdentifier(PointColumn c, ModelIdentifier id) {
            List<Object> pointData = new ArrayList();
            ArrayList<ModelIdentifier> ids = new ArrayList<ModelIdentifier>();
            ids.add(id);
            pointData = Factory.getByIdentifiers(c, ids);
            if (pointData.isEmpty()) {
                return null;
            }
            return (PointData)pointData.get(0);
        }

        public static List<PointData> getByIdentifiers(PointColumn c, List<ModelIdentifier> ids) {
            ArrayList<PointData> pointData = new ArrayList<PointData>();
            List<SourceResult> results = PointDataStorage.load(ids);
            for (int i = 0; i < results.size(); ++i) {
                pointData.add(new PointData(c, ids.get(i), results.get(i)));
            }
            return pointData;
        }

        public static List<PointData> getByAge(PointColumn c, double top, double bottom) {
            List<SourceResult> results = PointDataStorage.findByAge(c, top, bottom);
            List<ModelIdentifier> ids = ModelIdentifier.Factory.translateSourceResult(results, 17);
            return Factory.getByIdentifiers(c, ids);
        }
    }
}

