/*
 * Decompiled with CFR 0.152.
 */
package model.storage;

import java.util.ArrayList;
import java.util.List;
import model.ChronColumn;
import model.ModelIdentifier;
import model.storage.ColumnStorage;
import model.storage.Query;
import model.util.SourceResult;

public class ChronColumnStorage
extends ColumnStorage {
    public static void insert(ChronColumn col) {
        Query query = new Query("INSERT INTO #.chron_columns (id,                 columns_id, series_width, deleted)               VALUES (NULL, :columnid, :series_width, :deleted)");
        query.useDatabase(col.getColumnIdentifier().getDatabase());
        query.setInt("columnid", col.getColumnIdentifier().getId());
        query.setDouble("series_width", col.getSeriesWidth());
        query.setBoolean("deleted", col.isDeleted());
        query.executeUpdate();
        query.close();
    }

    public static void update(ChronColumn col) {
        Query query = new Query("UPDATE #.chron_columns         SET columns_id = :columnid,           series_width = :series_width         WHERE id = :id");
        query.useDatabase(col.getColumnIdentifier().getDatabase());
        query.setInt("id", col.getIdentifier().getId());
        query.setDouble("series_width", col.getSeriesWidth());
        query.setInt("columnid", col.getColumnIdentifier().getId());
        query.executeUpdate();
        query.close();
    }

    public static List<SourceResult> load(List<ModelIdentifier> ids) {
        ArrayList<SourceResult> results = new ArrayList<SourceResult>();
        ArrayList<ModelIdentifier> colids = new ArrayList<ModelIdentifier>();
        Query query = new Query("SELECT '#' as database, columns_id as id, series_width,                     deleted, last_modified, creation_date               FROM #.chron_columns               WHERE id = :id");
        for (ModelIdentifier id : ids) {
            query.setInt("id", id.getId());
            query.useDatabase(id.getDatabase());
            SourceResult result = query.executeQuery().get(0);
            results.add(result);
            colids.add(ModelIdentifier.Factory.translateSourceResult(result, 1));
        }
        query.close();
        ColumnStorage.load(results, colids);
        return results;
    }

    public static List<SourceResult> findByTitle(String title) {
        Query query = new Query("SELECT '#' AS database, chroncol.id               FROM #.columns AS col                 JOIN #.chron_columns AS chroncol ON (chroncol.columns_id = col.id)               WHERE col.title LIKE :title                 AND NOT chroncol.deleted                 AND NOT col.deleted                 AND col.overlay_id IS NULL");
        query.setString("title", title);
        return query.executeQuery();
    }
}

