//flags and global variables used in the program
var lMouseDraggingX = true;
var lMouseDraggingY = true;
var doubleClick = true;
var showLimitingBox = true;
var hideModelPoints = false;
var hidetimeLines = false;
var markerPoints = false;
var showPopups = false;
var cdtType = 1;

var prevX = 0;
var prevY = 0;
var currX = 0;
var currY = 0;

var X1 = 0;
var Y1 = 0;
var X2 = 0;
var Y2 = 0;

var markerX = 0;
var markerY = 0;
var markerComment = null;
var markerTypeInfo = null;

var pointsList = null;
var count = 0;
var timeLineX = null;
var timeLabelX = null;
var timeLineY = null;
var timeLabelY = null;

var crossplotGroup = null;
var markerGroup = null;
var lineGroup = null;
var modelGroup = null;
var fadGroup = null;
var ladGroup = null;

var minX = null;
var maxX = null;
var scaleX = null;
var topAgeX = null;
var baseAgeX = null;
var topLimitX = null;
var baseLimitX = null;

var minY = null;
var maxY = null;
var scaleY = null;
var topAgeY = null;
var baseAgeY = null;
var topLimitY = null;
var baseLimitY = null;

var limitingBox = null;

var timelinesGroup = null;
var timelabelsGroup = null;

var defaultScale = 1;
var currScale = 1;

var Popup = null;
var box = null;
var text = null;
var title = null;
var note = null;

var modelFill = null;
var markerFill = null;

var defaultType = 0;
var fadType = 1;
var ladType = 2;

var markerType = 0;
var modelType = 0;
var columnType = 0;

var textsize = 15; //set default size to 15
var pointRadius = 7; // set default radius to 7
var lineStroke = 3; // set default stroke width to 3
var strokeWidth = 2;

var SVGDoc = null;
var SVGRoot = null;
var SVGViewBox = null;

var labelWidth = 100;
/*	Function that is executed on load. 
 *	All the events are added in this function.
 *	All the elements are obtained here.
 */
 
function Init(evt) {
    pointsList = new Array();

    SVGDoc = evt.target.ownerDocument;
    SVGRoot = SVGDoc.documentElement;

    // Get TimeLine Elements.
    timeLineX = SVGDoc.getElementById("timelineX");
    timeLabelX = SVGDoc.getElementById("TimeLineLabelX");
    timeLineY = SVGDoc.getElementById("timelineY");
    timeLabelY = SVGDoc.getElementById("TimeLineLabelY");

    // Get group Elements
    crossplotGroup = SVGDoc.getElementById("CrossPlot");
    markerGroup = SVGDoc.getElementById("CrossPlotMarkers");
    lineGroup = SVGDoc.getElementById("CrossPlotLines");
    modelGroup = SVGDoc.getElementById("CrossPlotModels");
    fadGroup = SVGDoc.getElementById("CrossPlotFADLines");
    ladGroup = SVGDoc.getElementById("CrossPlotLADLines");
    //
    modelFill = modelGroup.getAttribute("fill-color");
    markerFill = markerGroup.getAttribute("fill-color");

    // Get X axis data
    minX = Number(timeLineX.getAttribute("minX"));
    maxX = Number(timeLineX.getAttribute("maxX"));
    scaleX = Number(timeLineX.getAttribute("vertScale"));
    topAgeX = Number(timeLineX.getAttribute("topAge"));
    baseAgeX = Number(timeLineX.getAttribute("baseAge"));
    topLimitX = Number(timeLineX.getAttribute("topLimit"));
    baseLimitX = Number(timeLineX.getAttribute("baseLimit"));

    // Get Y axis data.
    minY = Number(timeLineY.getAttribute("minY"));
    maxY = Number(timeLineY.getAttribute("maxY"));
    scaleY = Number(timeLineY.getAttribute("vertScale"));
    topAgeY = Number(timeLineY.getAttribute("topAge"));
    baseAgeY = Number(timeLineY.getAttribute("baseAge"));
    topLimitY = Number(timeLineY.getAttribute("topLimit"));
    baseLimitY = Number(timeLineY.getAttribute("baseLimit"));

    limitingBox = SVGDoc.getElementById("CrossplotLimitingBox");

    timelinesGroup = SVGDoc.getElementById("CrossPlotTimeLines");
    timelabelsGroup = SVGDoc.getElementById("CrossPlotTimeLabels");

    prevScale = 1/SVGRoot.currentScale;
    currScale = 1/SVGRoot.currentScale;

    Popup = SVGDoc.getElementById("CrossplotPopup");
    box = SVGDoc.getElementById("CrossplotPopupBox");
    text = SVGDoc.getElementById("CrossplotPopupText");
    title = SVGDoc.getElementById("PopupTextTitle");
    note = SVGDoc.getElementById("PopupTextNote");

    // Adding mouse event listeners.
    SVGRoot.addEventListener('click', mouseClicked, false);
    SVGRoot.addEventListener('mousemove', mouseMove, false);
    SVGRoot.addEventListener('mouseover', mouseOver, false);
    SVGRoot.addEventListener('mousedown', mouseDown, false);
    SVGRoot.addEventListener('mouseup', mouseUp, false);
    SVGRoot.addEventListener('keypress', keyPressed, false);

    // auto scale on load.
    autoScalePlot(evt);
}

/*
 * This function is fired on mouse down.
 * Checks the bounds for model points.
 */
function mouseDown(evt) {
    var x = parseInt(timeLineX.getAttribute("x1"));
    var y = parseInt(timeLineY.getAttribute("y1"));
    var index = new Array();
    var p1 =SVGRoot.createSVGPoint();
    var p2 =SVGRoot.createSVGPoint();
    timelinesGroup.setAttributeNS(null,"style","stroke: red;stroke-opacity:0.5;");
    timelabelsGroup.setAttributeNS(null,"style","font-size: 10;fill: red; fill-opacity:0.7;");
    if (markerPoints) {
        return;
    }
    p1 = getPrevPointIndex(x) != -1 ? pointsList[getPrevPointIndex(x)] : null;
    p2 = getNextPointIndex(x) != -1 ? pointsList[getNextPointIndex(x)] : null;
    if (((p2 != null && y > p2.y) || (p1 != null && y < p1.y))
        || (x < agetoX(topLimitX) || x > agetoX(baseLimitX)) || (y < depthtoY(topLimitY) || y > depthtoY(baseLimitY))) {
        timelinesGroup.setAttributeNS(null,"style","stroke: gray;stroke-opacity:0.5;");
        timelabelsGroup.setAttributeNS(null,"style","font-size: 10;fill: gray; fill-opacity:0.7;");
    }
}

/*
 * Function triggered on MouseUp.
 */
function mouseUp(evt) {
    timelinesGroup.setAttributeNS(null,"style","stroke: red;stroke-opacity:0.5;");
    timelabelsGroup.setAttributeNS(null,"style","font-size: 10;fill: red; fill-opacity:0.7;");
}

/*
 * This function autoscales the crossplot with the change in zoom.
 */
function autoScalePlot(evt){
//
    defaultScale = Math.round(1/Number(SVGRoot.getAttribute("doc-scale")));
//
    currScale = 1/SVGRoot.currentScale;
    var type = 0;

    textsize = Math.round(20*defaultScale) < 20 ? 20 : Math.round(20*defaultScale);
    pointRadius = Math.round(3*defaultScale*currScale) < 3 ? 3 : Math.round(3*defaultScale*currScale);
    lineStroke = Math.round(2*defaultScale*currScale) < 2 ? 2 : Math.round(2*defaultScale*currScale);
    strokeWidth = Math.round(defaultScale*currScale) < 1 ? 1 : Math.round(defaultScale*currScale);

    var modelsList = modelGroup.childNodes;
    for (var i = 0; i < modelsList.length; i++) {
        var currPoint = modelsList.item(i);
        currPoint.setAttributeNS(null,'r',pointRadius);
        currPoint.setAttributeNS(null,'stroke-width',strokeWidth);
    }
    
    var markerList = markerGroup.childNodes;
    for (var i = 0; i < markerList.length; i++) {
        var currPoint = markerList.item(i);
        currPoint.setAttributeNS(null,'r',pointRadius);
        currPoint.setAttributeNS(null,'stroke-width',strokeWidth);
        var type = parseInt(currPoint.getAttribute('type'));
        if (type == 1) {
            drawFAD(currPoint.getAttribute('cx'),currPoint.getAttribute('cy'));
            removeLAD(currPoint.getAttribute('cx'),currPoint.getAttribute('cy'));
        } else if (type == 2) {
            drawLAD(currPoint.getAttribute('cx'),currPoint.getAttribute('cy'));
            removeFAD(currPoint.getAttribute('cx'),currPoint.getAttribute('cy'));
        }
    }

    var fadList = fadGroup.childNodes;
    for (var i = 0; i < fadList.length; i++) {
        var fad = fadList.item(i);
        var y= Number(fad.getAttribute('y')) - pointRadius - 2*strokeWidth;
        var x1= Number(fad.getAttribute('x')) - 2*pointRadius;
        var x2= Number(fad.getAttribute('x')) + 2*pointRadius;
        fad.setAttributeNS(null,'stroke-width',2*strokeWidth);
        fad.setAttributeNS(null,'x1',x1);
        fad.setAttributeNS(null,'x2',x2);
        fad.setAttributeNS(null,'y1',y);
        fad.setAttributeNS(null,'y2',y);
    }

    var ladList = ladGroup.childNodes;
    for (var i = 0; i < ladList.length; i++) {
        var lad = ladList.item(i);
        var y= Number(lad.getAttribute('y')) + pointRadius + 2*strokeWidth;
        var x1= Number(lad.getAttribute('x')) - 2*pointRadius;
        var x2= Number(lad.getAttribute('x')) + 2*pointRadius;
        lad.setAttributeNS(null,'stroke-width',2*strokeWidth);
        lad.setAttributeNS(null,'x1',x1);
        lad.setAttributeNS(null,'x2',x2);
        lad.setAttributeNS(null,'y1',y);
        lad.setAttributeNS(null,'y2',y);
    }

    var lines = lineGroup.childNodes;
    for (var i = 0; i < lines.length; i++) {
        var currLine = lines.item(i);
        currLine.setAttributeNS(null,'stroke-width',lineStroke);
    }

    timeLineX.setAttributeNS(null,'stroke-width',lineStroke);
    timeLineY.setAttributeNS(null,'stroke-width',lineStroke);
    timeLabelX.setAttributeNS(null,'font-size',textsize*currScale < 20 ? 20 : Math.round(textsize*currScale));
    timeLabelY.setAttributeNS(null,'font-size',textsize*currScale < 20 ? 20 : Math.round(textsize*currScale));

    text.setAttributeNS(null,"x", textsize);
    text.setAttributeNS(null,"y", textsize + 10);
    text.setAttributeNS(null,'font-size',textsize);

    title.setAttributeNS(null,"x", textsize);
    note.setAttributeNS(null,"x", textsize);
    note.setAttributeNS(null,"dy", 1.5*textsize);

    var limitWidth = agetoX(baseLimitX) - agetoX(topLimitX);
    var limitHeight = depthtoY(baseLimitY) - depthtoY(topLimitY);
    limitingBox.setAttributeNS(null,"x", agetoX(topLimitX));
    limitingBox.setAttributeNS(null,"y", depthtoY(topLimitY));
    limitingBox.setAttributeNS(null,"width", limitWidth);
    limitingBox.setAttributeNS(null,"height", limitHeight);
    limitingBox.setAttributeNS(null,"stroke-width", lineStroke);
}

/*
 *  This functions updates the models list.
 */
function updatePointsList() {
    pointsList.length = 0;
    var cdtList = modelGroup.childNodes;
    if (cdtList.length < 1) {
        return;
    }
    for (var i = 0; i < cdtList.length; i++) {
        var currPoint = SVGRoot.createSVGPoint();
        currPoint.x = cdtList.item(i).getAttribute("cx");
        currPoint.y = cdtList.item(i).getAttribute("cy");
        pointsList[i] = currPoint;
    }
    pointsList.sort(sortPoints);
}

/*
 *  This functions updates the markers Color.
 */
function updateMarkerColors() {
    var cdtList = markerGroup.childNodes;
    if (cdtList.length < 1) {
        return;
    }
    for (var i = 0; i < cdtList.length; i++) {
        cdtList.item(i).setAttributeNS(null,"fill", markerFill.toString());
    }
}

/*
 *  This functions updates the models Color.
 */
function updateModelColors() {
    var cdtList = modelGroup.childNodes;
    if (cdtList.length < 1) {
        return;
    }
    for (var i = 0; i < cdtList.length; i++) {
        cdtList.item(i).setAttributeNS(null,"fill", modelFill.toString());
    }
}

/*
 * This function removes all the lines on the crossplot
 */
function removeAllLines() {
    while(lineGroup.hasChildNodes()){
        lineGroup.removeChild(lineGroup.lastChild);
    }
}

/* Action performed when the corrosponding keys ae pressed*/
function keyPressed(evt) {
    var chCode = evt.charCode? evt.charCode : evt.keyCode;
    if (chCode == 120 || chCode == 88) {
        lMouseDraggingX = !lMouseDraggingX;
    }

    if (chCode == 121 || chCode == 89) {
        lMouseDraggingY = !lMouseDraggingY;
    }
    if (chCode == 32) {
        hideModelPoints = !hideModelPoints;
        modelGroup.setAttributeNS(null,"visibility",hideModelPoints ? "hidden" : "visible");
    }
    if (chCode == 72 || chCode == 104) {
        hidetimeLines = !hidetimeLines;
        timelinesGroup.setAttributeNS(null,"visibility", hidetimeLines ? "hidden": "visible");
        timelabelsGroup.setAttributeNS(null,"visibility", hidetimeLines  ? "hidden": "visible");
    }
    if (chCode == 79 || chCode == 111) {
        markerPoints = !markerPoints;
        crossplotGroup.setAttributeNS(null,"CdtType", markerPoints ? 0 : 1);
        cdtType = markerPoints ? 0 : 1;
    }
    if (chCode == 80 || chCode == 112) {
        showPopups = !showPopups;
        Popup.setAttributeNS(null,'showPopup', showPopups);
    }
    if (chCode == 66 || chCode == 98) {
        showLimitingBox = !showLimitingBox;
        limitingBox.setAttributeNS(null,"visibility",showLimitingBox ? "visible" : "hidden");
    }
}

//When cursor enters the svg the following function executes.
function mouseOver(evt) {
    autoScalePlot(evt);
    hidetimeLines = (timelinesGroup.getAttribute('visibility') == 'hidden');
    showLimitingBox = (limitingBox.getAttribute("visibility") == "visible");
    plot();
    cdtType = crossplotGroup.getAttribute("CdtType");
    markerPoints = false;
    if (cdtType == 0) {
        markerPoints = true;
    }

    modelFill = modelGroup.getAttribute("fill-color");
    markerFill = markerGroup.getAttribute("fill-color");

    modelType = parseInt(modelGroup.getAttribute("type"));
    markerType = parseInt(markerGroup.getAttribute("type"));
}

function mouseClicked(evt) {
    var X = parseInt(timeLineX.getAttribute("x1"));
    var Y = parseInt(timeLineY.getAttribute("y1"));
    currX = X;
    currY = Y;
    var point = SVGDoc.getElementById("dot(" + X + ")");
    if (doubleClick){
        doubleClick = false;
        if(currX == prevX && currY == prevY){
            if (markerPoints){
                drawMarker(X,Y);
            }
            else{
                if(insideCircle(X, Y, markerX, markerY)){
                    drawPoint(markerX,markerY, markerComment, markerTypeInfo);
                }
                else if(insideRect(X,Y, markerX, markerY)){
                  	drawPoint(markerX, markerY, markerComment, markerTypeInfo);
                }
                else{
                    drawPoint(X,Y, null, null);
                }
            }
            doubleClick = true;
        }
    }
    if(!doubleClick){
        prevX = currX;
        prevY = currY;
    }
    doubleClick = !doubleClick;
}

function insideCircle(x, y, circleX, circleY){
    var distance = Math.sqrt((circleX - x) * (circleX - x) + (circleY - y) * (circleY - y));
    return distance < pointRadius ? true : false;
}

function insideRect(x, y, rectX, rectY){
    if(x > rectX - 15 && x < rectX + 15 && y > rectY - 15 && y < rectY + 15 ) {
        return true;
    }
    else {
        return false;
    }
}

function mouseMove(evt) {
    var X = parseInt(timeLineX.getAttribute("x1"));
    var Y = parseInt(timeLineY.getAttribute("y1"));
    var p = SVGRoot.createSVGPoint();

    evt = evt || window.event;
    p.x = evt.clientX;
    p.y = evt.clientY;
    try {
        if (evt.pageX || evt.pageY) {
            p.x = evt.pageX;
            p.y = evt.pageY;
        }
        else{
            p.x = evt.clientX + (SVGRoot.scrollLeft + SVGDoc.body.scrollLeft);
            p.y = evt.clientY + (SVGRoot.scrollTop + SVGDoc.body.scrollTop);
        }
    }
    catch (e){}

    var m = timeLineY.getScreenCTM();
    p = p.matrixTransform(m.inverse());
    var currX = minX;
    var currY = minY;
    if (lMouseDraggingY){
        if (timeLineY){
            if (p.y > minY) {
                currY = p.y;
            }
            if (p.y > maxY) {
                currY = maxY;
            }
            timeLineY.setAttributeNS(null,"y1", currY);
            timeLineY.setAttributeNS(null,"y2", currY);
        }
    }
    if (timeLabelY) {
        var Y = parseInt(timeLineY.getAttribute("y1"));
        showCurrAgeY(p.x,Y);
    }
    if (lMouseDraggingX){
        if (timeLineX){
            if (p.x > minX) {
                currX = p.x;
            }
            if (p.x > maxX) {
                currX = maxX;
            }

            timeLineX.setAttributeNS(null,"x1", currX);
            timeLineX.setAttributeNS(null,"x2", currX);
        }
    }
    if (timeLabelX) {
        var X = parseInt(timeLineX.getAttribute("x1"));
        showCurrAgeX(X,p.y);
    }
}

function showCurrAgeY(x, y) {
    if(timeLabelY && timeLineY) {
        var currY = minY;
        var labelY = x + labelWidth;
        if (y > minY){
            currY = y;
        }

        if (y > maxY) {
            currY = maxY;
        }
        if (labelY + labelWidth > maxX) {
            labelY = labelY - 2*labelWidth;
        }
        var currAge = topAgeY + ((currY - minY)/scaleY);
        timeLabelY.setAttributeNS(null,"x", labelY);
        timeLabelY.setAttributeNS(null,"y",currY - textsize*0.1);
        timeLabelY.firstChild.nodeValue = Math.round(currAge*1000)/1000;
    }
    return Math.round(currAge*1000)/1000;
}

function showCurrAgeX(x,y) {
    if(timeLabelX && timeLineX) {
        var currX = minX;
        if (x > minX){
            currX = x;
        }
        if (x > maxX) {
            currX = maxX;
        }

        var labelX = currX + textsize*0.1;

        var currAge = topAgeX + ((currX - minX)/scaleX);
        timeLabelX.setAttributeNS(null,"x", labelX);
        timeLabelX.setAttributeNS(null,"y", y - textsize);
        timeLabelX.firstChild.nodeValue = Math.round(currAge*1000)/1000;
    }
    return Math.round(currAge*1000)/1000;
}

function drawMarker(x,y) {
    var point = SVGDoc.getElementById("dot(" + x +"," + y + ")");

    if (point) {
        markerGroup.removeChild(point);
        removeFAD(x,y);
        removeLAD(x,y);
    }
    else {
        var dot = SVGDoc.createElementNS("http://www.w3.org/2000/svg", "circle");
        dot.setAttributeNS(null,"id" ,"dot(" + x +"," + y + ")");
        dot.setAttributeNS(null,"onmousemove", 'showPopup(evt)');
        dot.setAttributeNS(null,"onmouseout", 'hidePopup(evt)');
        dot.setAttributeNS(null,"onclick", 'pointClicked(evt)');
        dot.setAttributeNS(null,"cx", parseInt(x));
        dot.setAttributeNS(null,"cy", parseInt(y));
        dot.setAttributeNS(null,"r", pointRadius);
        dot.setAttributeNS(null,"age", showCurrAgeX(x,y));
        dot.setAttributeNS(null,"depth", showCurrAgeY(x,y));
        dot.setAttributeNS(null, "stroke", "black");
        dot.setAttributeNS(null, "stroke-width", strokeWidth);
        dot.setAttributeNS(null,"fill",markerFill.toString());
        dot.setAttributeNS(null,"fill-color",markerFill.toString());
        dot.setAttributeNS(null,"comment", 'This is an "Age/Depth Marker"');
        dot.setAttributeNS(null,"type", markerType);
        markerGroup.appendChild(dot);
        if(markerType == 1) {
            drawFAD(x,y);
        } else if (markerType == 2) {
            drawLAD(x,y);
        }
    }
}

function removeLAD(x,y) {
    var line = SVGDoc.getElementById("fadline("+x+","+y+")");
    if (line) {
        fadGroup.removeChild(line);
    }
}

function drawLAD(x,y) {
    var x1 = x - 2*pointRadius;
    var x2 = x + 2*pointRadius;
    var y1 = y - pointRadius - 2*strokeWidth;
    var y2 = y - pointRadius - 2*strokeWidth;

    var line = SVGDoc.getElementById("fadline("+x+","+y+")");
    if (line) {
        return;
    }
    var line = SVGDoc.createElementNS("http://www.w3.org/2000/svg", "line");
    line.setAttributeNS(null,"id","fadline("+x+","+y+")");
    line.setAttributeNS(null,"x1",x1);
    line.setAttributeNS(null,"y1",y1);
    line.setAttributeNS(null,"x2",x2);
    line.setAttributeNS(null,"y2",y2);
    line.setAttributeNS(null,"x",x);
    line.setAttributeNS(null,"y",y);
    line.setAttributeNS(null,"stroke-width",lineStroke);
    fadGroup.appendChild(line);
}

function removeFAD(x,y) {
    var line = SVGDoc.getElementById("ladline("+x+","+y+")");
    if (line) {
        ladGroup.removeChild(line);
    }
}

function drawFAD(x,y) {
    var x1 = x - 2*pointRadius;
    var x2 = x + 2*pointRadius;
    var y1 = y + pointRadius + 2*strokeWidth;
    var y2 = y + pointRadius + 2*strokeWidth;

    var line = SVGDoc.getElementById("ladline("+x+","+y+")");
    if (line) {
        return;
    }
    var line = SVGDoc.createElementNS("http://www.w3.org/2000/svg", "line");
    line.setAttributeNS(null,"id","ladline("+x+","+y+")");
    line.setAttributeNS(null,"x1",x1);
    line.setAttributeNS(null,"y1",y1);
    line.setAttributeNS(null,"x2",x2);
    line.setAttributeNS(null,"y2",y2);
    line.setAttributeNS(null,"x",x);
    line.setAttributeNS(null,"y",y);
    line.setAttributeNS(null,"stroke-width",lineStroke);
    ladGroup.appendChild(line);
}

function drawPoint(x, y, Comment, TypeInfo) {
    var point = SVGDoc.getElementById("dot(" + x + ")");
    var p1 = SVGRoot.createSVGPoint();
    var p2 = SVGRoot.createSVGPoint();
    
    updatePointsList();
    p1 = getPrevPointIndex(x) != -1 ? pointsList[getPrevPointIndex(x)] : null;
    p2 = getNextPointIndex(x) != -1 ? pointsList[getNextPointIndex(x)] : null;
    if (((p2 != null && y > p2.y) || (p1 != null && y < p1.y))
        || (x < agetoX(topLimitX) || x > agetoX(baseLimitX)) || (y < depthtoY(topLimitY) || y > depthtoY(baseLimitY))) {
        return;
    }

    if (point) {
        removePoint(x,y);
        plot();
        return;
    }
    addPoint(x, y, Comment, TypeInfo);

    plot();
}

function drawRect(x, y, Comment, TypeInfo) {
    var rect = SVGDoc.getElementById("dot(" + x + ")");
    var p1 = SVGRoot.createSVGPoint();
    var p2 =SVGRoot.createSVGPoint();
    
    updatePointsList();
    p1 = getPrevPointIndex(x) != -1 ? pointsList[getPrevPointIndex(x)] : null;
    p2 = getNextPointIndex(x) != -1 ? pointsList[getNextPointIndex(x)] : null;
    if (((p2 != null && y > p2.y) || (p1 != null && y < p1.y))
        || (x < agetoX(topLimitX) || x > agetoX(baseLimitX)) || (y < depthtoY(topLimitY) || y > depthtoY(baseLimitY))) {
        return;
    }

    if (rect) {
        removeRect(x,y);
        plot();
        return;
    }
    addRect(x, y, Comment, TypeInfo);

    plot();
}

function addRect(x,y, Comment, TypeInfo) {
    var dot = SVGDoc.createElementNS("http://www.w3.org/2000/svg", "rect");
    dot.setAttributeNS(null,"id", "dot(" + x + ")");
    dot.setAttributeNS(null,"onmousemove", 'showPopup(evt)');
    dot.setAttributeNS(null,"onmouseout", 'hidePopup(evt)');
    dot.setAttributeNS(null,"onclick", 'pointClicked(evt)');
    dot.setAttributeNS(null,"x", parseInt(x));
    dot.setAttributeNS(null,"y", parseInt(y));
    dot.setAttributeNS(null,"cx", parseInt(x));
    dot.setAttributeNS(null,"cy", parseInt(y));
    dot.setAttributeNS(null,"r", pointRadius);
    dot.setAttributeNS(null, "stroke", "black");
    dot.setAttributeNS(null, "stroke-width", strokeWidth);
    dot.setAttributeNS(null,"age", showCurrAgeX(x,y));
    dot.setAttributeNS(null,"depth", showCurrAgeY(x,y));
    dot.setAttributeNS(null,"fill",modelFill.toString());
    dot.setAttributeNS(null,"fill-color",modelFill.toString());
    if(Comment == null){
        dot.setAttributeNS(null,"comment", 'This is an "Age/Depth Model"');
    }
    else{
        if(TypeInfo == null){
            dot.setAttributeNS(null,"comment", Comment + "- Circle");
        }
        else{
            dot.setAttributeNS(null,"comment", Comment + "-" + TypeInfo);
        }
    }
    dot.setAttributeNS(null,"type", defaultType);
    dot.setAttributeNS(null,"columnType", "1");
    modelGroup.appendChild(dot);
}

function removeRect(x,y){
    var point = SVGDoc.getElementById("dot(" + x + ")");
    var pY = parseInt(point.getAttribute("cy"));
    modelGroup.removeChild(point);
    if (pY != y) {
        addRect(x,y);
    }
    plot();
}

function addPoint(x,y, Comment, TypeInfo) {
    var dot = SVGDoc.createElementNS("http://www.w3.org/2000/svg", "circle");
    dot.setAttributeNS(null,"id", "dot(" + x + ")");
    dot.setAttributeNS(null,"onmousemove", 'showPopup(evt)');
    dot.setAttributeNS(null,"onmouseout", 'hidePopup(evt)');
    dot.setAttributeNS(null,"onclick", 'pointClicked(evt)');
    dot.setAttributeNS(null,"cx", parseInt(x));
    dot.setAttributeNS(null,"cy", parseInt(y));
    dot.setAttributeNS(null,"r", pointRadius);
    dot.setAttributeNS(null, "stroke", "black");
    dot.setAttributeNS(null, "stroke-width", strokeWidth);
    dot.setAttributeNS(null,"age", showCurrAgeX(x,y));
    dot.setAttributeNS(null,"depth", showCurrAgeY(x,y));
    dot.setAttributeNS(null,"fill",modelFill.toString());
    dot.setAttributeNS(null,"fill-color",modelFill.toString());
    if(Comment == null){
        dot.setAttributeNS(null,"comment", 'This is an "Age/Depth Model"');
    }
    else{
        if(TypeInfo == null){
            dot.setAttributeNS(null,"comment", Comment + "- Circle");
        }
        else{
            dot.setAttributeNS(null,"comment", Comment + "-" + TypeInfo);
        }
    }
    dot.setAttributeNS(null,"type", defaultType);
    dot.setAttributeNS(null,"columnType", "0");
    modelGroup.appendChild(dot);
}

function removePoint(x,y) {
    var point = SVGDoc.getElementById("dot(" + x + ")");
    var pY = parseInt(point.getAttribute("cy"));
    modelGroup.removeChild(point);
    if (pY != y) {
        addPoint(x,y);
    }
    plot();
}

function sortPoints(a, b) {
    if(a.x == b.x) {
        return 1;
    }
    return a.x - b.x;
}

function drawLine(x1,y1,x2,y2) {
    var line = SVGDoc.getElementById("line("+x1+","+y1+ ","+x2+","+y2 + ")");
    if (line) {
        return;
    }
    var line = SVGDoc.createElementNS("http://www.w3.org/2000/svg", "line");
    line.setAttributeNS(null,"id","line("+x1+","+y1+ ","+x2+","+y2 + ")");
    line.setAttributeNS(null,"x1",x1);
    line.setAttributeNS(null,"y1",y1);
    line.setAttributeNS(null,"x2",x2);
    line.setAttributeNS(null,"y2",y2);
    line.setAttributeNS(null,"stroke-width",lineStroke);
    lineGroup.appendChild(line);
}

function plot() {
    removeAllLines();
    updatePointsList();
    for (var i = 1; i < pointsList.length; i++) {
        var x1 = parseInt(pointsList[i-1].x);
        var y1 = parseInt(pointsList[i-1].y);
        var x2 = parseInt(pointsList[i].x);
        var y2 = parseInt(pointsList[i].y);
        drawLine(x1,y1,x2,y2);
    }
}


function getIndexOf(x) {
    for(var i = 0; i < pointsList.length; i++) {
        if(pointsList[i].x == x) {
            return i;
        }
    }
}

function getPrevPointIndex(x) {
    for(var i = 0; i < pointsList.length; i++) {
        if(pointsList[i].x >= x && pointsList.length > 0) {
            return i - 1;
        }
    }
    return i == 0 ? -1 : pointsList.length - 1;
}

function getNextPointIndex(x) {
    for(var i = 0; i < pointsList.length; i++) {
        if(pointsList[i].x == x && i < pointsList.length - 1) {
            return i + 1;
        }
        if(pointsList[i].x > x) {
            return i;
        }
    }
    return -1;
}

function showPopup(evt) {
    var Scale = 1/SVGRoot.currentScale;

    var src = evt.target;

    var x = parseInt(src.getAttribute('cx'));
    var y = parseInt(src.getAttribute('cy'));
    var age = src.getAttribute('age');
    var depth = src.getAttribute('depth');
    var comment = src.getAttribute('comment');
    var markertype = src.getAttribute("type");

    box.setAttributeNS(null, 'transform', 'scale(' + Scale + ',' + Scale + ')' );
    text.setAttributeNS(null, 'transform', 'scale(' + Scale + ',' + Scale + ')' );

    src.setAttributeNS(null,'fill','red');
    title.firstChild.nodeValue = 'Age: ' + showCurrAgeX(x,y) + ' , ' + 'Depth: ' + showCurrAgeY(x,y);
    note.firstChild.nodeValue = comment;

    var boxD = text.getBBox();

    box.setAttributeNS(null,'width', Number(boxD.width) + 2*textsize);
    box.setAttributeNS(null,'height', Number(boxD.height) + 2*textsize);

    showPopups = (Popup.getAttribute('showPopup') == 'true');

    Popup.setAttributeNS(null, 'transform', 'translate(' + (x + 5) + ',' + (y + 5) + ')');
    Popup.setAttributeNS(null, 'visibility', showPopups ? 'visible' : 'hidden');

    markerX = x;
    markerY = y;
    markerComment = comment;
    if(markertype == 1){
        markerTypeInfo = "BASE(FAD)";
    }
    else if(markertype == 2){
        markerTypeInfo = "TOP(LAD)";
    }
    else{
        markerTypeInfo = "Circle";
    }

}

function hidePopup(evt) {
    var src = evt.target;
    var parent = src.parentNode.getAttribute('id');

    src.setAttributeNS(null,'fill',src.getAttribute('fill-color'));
    Popup.setAttributeNS(null, 'visibility', 'hidden');

    markerX = 0;
    markerY = 0;
    markerComment = null;
    markerTypeInfo = null;
}

function pointClicked(evt) {
    var src = evt.target;
    var parent = src.parentNode.getAttribute('id');

    Popup.setAttributeNS(null, 'visibility', 'hidden');

    if ((parent == 'CrossPlotMarkers') & markerPoints) {
        markerGroup.removeChild(src) ;
        removeFAD(src.getAttribute('cx'),src.getAttribute('cy'));
        removeLAD(src.getAttribute('cx'),src.getAttribute('cy'));
    } else {
        modelGroup.removeChild(src);
    }
    plot();
}

function agetoX(age){
    var x = 0;
    x = minX + (age > topAgeX ? Math.round((age - topAgeX) * scaleX) : 0);
    x = x > maxX ? maxX : x;
    return x;
}

function depthtoY(depth) {
    var y = 0;
    y = minY + (depth > topAgeY ? Math.round((depth - topAgeY) * scaleY) : 0);
    y = y > maxY ? maxY : y;
    return y;
}

function getDigits(num) {
    var i = 0;
    var dig = num;
    while (dig > 0) {
        dig = dig/10;
        i++;
    }
    return i;
}