-- These are a few changes I would make --- much of it is Andrewism however...

-- SQLite turns constraints off by default --
PRAGMA foreign_keys = ON;

-- I don't like naming the id column based on the table name. Its annoyingly
-- redundant... The other columns do not follow this naming scheme either
-- If you have a SQL statement which works on one table then it will be
-- referred to as 'id' and if its a statement with more then one table then the
-- column will be referred to as 'tablename'.'id' (such as datapacks.id)
-- Link table columns use the name: tablename_id
-- This is by far an Andrewism I just like consistent naming so I don't have to
-- look it up. At least make the id named exactly after the tablename like:
-- datapacks_id


--Datapack things--
CREATE TABLE datapacks (
 --packid INTEGER PRIMARY KEY,
  id INTEGER PRIMARY KEY,
  name TEXT,
  format_version FLOAT,
  date DATETIME,
  age_units TEXT,
  default_chronostrat TEXT,
  chart_title TEXT,
  interval_column TEXT, --not sure what this even is yet
  deleted BOOL DEFAULT FALSE,
  creation_date DATETIME DEFAULT CURRENT_TIMESTAMP,
  last_modified DATETIME DEFAULT CURRENT_TIMESTAMP
);
CREATE TRIGGER update_datapacks AFTER UPDATE ON datapacks
  BEGIN
    UPDATE datapacks SET last_modified = DATETIME('NOW')
    WHERE packid = new.packid;
  END;

--CREATE TABLE datapack_relations (
-- With a lot of link tables putting the names of the tables which are being
-- linked can be helpful and understanding the structure 4 months later
CREATE TABLE lnk_datapacks_drawables (
-- Link table id's are not very useful... the PK could be better used
-- Of course if the idea is to set deleted = 1 when you want to delete it
-- and then make a NEW row if the link is reestablished then this wont work and
-- you will need a 'id' field and the index below can't be unique -- this would
-- allow you to make the same link twice and sqlite wont care.....
-- datapack_lnkid INTEGER PRIMARY KEY,
  datapacks_id INTEGER NOT NULL,
  drawable_columns_id INTEGER NOT NULL,
  deleted BOOL DEFAULT FALSE,
  creation_date DATETIME DEFAULT CURRENT_TIMESTAMP,
  last_modified DATETIME DEFAULT CURRENT_TIMESTAMP,
  -- Make the primary key the two ids we are linking
  PRIMARY KEY ( datapacks_id, drawable_columns_id ),
  -- Setup foreign key constraints
  FOREIGN KEY ( datapacks_id ) REFERENCES datapacks ( id ) ON DELETE RESTRICT ON UPDATE CASCADE,
  FOREIGN KEY ( drawable_columns_id ) REFERENCES drawable_columns ( colid ) ON DELETE RESTRICT ON UPDATE CASCADE
);
-- This index is backwards of the new Primary Key for joins that direction
CREATE UNIQUE INDEX 'drawable_columns_id_datapacks_id' ON lnk_datapacks_drawables
	( drawable_columns_id, datapacks_id );
CREATE TRIGGER update_lnk_datapacks_drawables AFTER UPDATE ON lnk_datapacks_drawables 
  BEGIN
    UPDATE lnk_datapacks_drawables SET last_modified = DATETIME('NOW')
    WHERE datapacks_id = new.datapacks_id 
	  AND drawable_columns_id = new.drawable_columns_id;
  END;


-- And so on and so on and so on ....

--General things--
CREATE TABLE drawable_columns (
  colid INTEGER PRIMARY KEY,
  title TEXT,
  width FLOAT,
  color TEXT,
  default_show_title BOOL,
  on_off BOOL,
  popup_text TEXT,
  deleted BOOL DEFAULT FALSE,
  creation_date DATETIME DEFAULT CURRENT_TIMESTAMP,
  last_modified DATETIME DEFAULT CURRENT_TIMESTAMP
);
CREATE TRIGGER update_drawable_columns AFTER UPDATE ON drawable_columns
  BEGIN
    UPDATE drawable_columns SET last_modified = DATETIME('NOW')
    WHERE colid = new.colid;
  END;

CREATE TABLE groups ( --Sort of a column but not exactly
  groupid INTEGER PRIMARY KEY,
  parentid INTEGER,
  colid INTEGER,
  deleted BOOL DEFAULT FALSE,
  creation_date DATETIME DEFAULT CURRENT_TIMESTAMP,
  last_modified DATETIME DEFAULT CURRENT_TIMESTAMP
);
CREATE TRIGGER update_groups AFTER UPDATE ON groups
  BEGIN
    UPDATE groups SET last_modified = DATETIME('NOW')
    WHERE groupid = new.groupid;
  END;


--BLank things--
CREATE TABLE blank_columns (
  blankid INTEGER PRIMARY KEY,
  colid INTEGER NOT NULL,
  deleted BOOL DEFAULT FALSE,
  creation_date DATETIME DEFAULT CURRENT_TIMESTAMP,
  last_modified DATETIME DEFAULT CURRENT_TIMESTAMP
);
CREATE TRIGGER update_blank_columns AFTER UPDATE ON blank_columns
  BEGIN
    UPDATE blank_columns SET last_modified = DATETIME('NOW')
    WHERE blankid = new.blankid;
  END;


--Facies things--
CREATE TABLE facies_columns (
  faciesid INTEGER PRIMARY KEY,
  colid INTEGER NOT NULL,
  series_width FLOAT, --this thing is dumb
  deleted BOOL DEFAULT FALSE,
  creation_date DATETIME DEFAULT CURRENT_TIMESTAMP,
  last_modified DATETIME DEFAULT CURRENT_TIMESTAMP
);
CREATE TRIGGER update_facies_columns AFTER UPDATE ON facies_columns
  BEGIN
    UPDATE facies_columns SET last_modified = DATETIME('NOW')
    WHERE faciesid = new.faciesid;
  END;

CREATE TABLE facies_subcolumns (
  facies_subcolumid INTEGER PRIMARY KEY,
  colid INTEGER NOT NULL,
  patternid INTEGER,
  label TEXT,
  age FLOAT,
  deleted BOOL DEFAULT FALSE,
  creation_date DATETIME DEFAULT CURRENT_TIMESTAMP,
  last_modified DATETIME DEFAULT CURRENT_TIMESTAMP,
  FOREIGN KEY(colid) REFERENCES general_columns(colid),
  FOREIGN KEY(patternid) REFERENCES svg_patterns(patternid)
);
CREATE TRIGGER update_facies_subcolumns AFTER UPDATE ON facies_subcolumns
  BEGIN
    UPDATE facies_subcolumns SET last_modified = DATETIME('NOW')
    WHERE facies_subcolumnid = new.facies_subcolumnid;
  END;

CREATE TABLE svg_patterns (
  id INTEGER PRIMARY KEY,
  name TEXT,
  svg_data TEXT,
  width FLOAT,
  deleted BOOL DEFAULT FALSE,
  creation_date DATETIME DEFAULT CURRENT_TIMESTAMP,
  last_modified DATETIME DEFAULT CURRENT_TIMESTAMP
);
CREATE TRIGGER update_svg_patterns AFTER UPDATE ON svg_patterns
  BEGIN
    UPDATE svg_patterns SET last_modified = DATETIME('NOW')
    WHERE id = new.id;
  END;


--Event things--
CREATE TABLE event_columns (
  eventid INTEGER PRIMARY KEY,
  colid INTEGER NOT NULL,
  deleted BOOL DEFAULT FALSE,
  creation_date DATETIME DEFAULT CURRENT_TIMESTAMP,
  last_modified DATETIME DEFAULT CURRENT_TIMESTAMP
);
CREATE TRIGGER update_event_columns AFTER UPDATE ON event_columns
  BEGIN
    UPDATE event_columns SET last_modified = DATETIME('NOW')
    WHERE eventid = new.eventid;
  END;

CREATE TABLE event_data (
  event_dataid INTEGER PRIMARY KEY,
  eventid INTEGER NOT NULL,
  label TEXT,
  age FLOAT,
  linestyle TEXT, --enums don't exist in SQLite, look for a better way
  type TEXT, --this would ideally be an enum too
  deleted BOOL DEFAULT FALSE,
  creation_date DATETIME DEFAULT CURRENT_TIMESTAMP,
  last_modified DATETIME DEFAULT CURRENT_TIMESTAMP
);
CREATE TRIGGER update_event_data AFTER UPDATE ON event_data
  BEGIN
    UPDATE event_data SET last_modified = DATETIME('NOW')
    WHERE event_dataid = new.event_dataid;
  END;


--Sequence/Trend things--
CREATE TABLE sequence_columns (
  sequenceid INTEGER PRIMARY KEY,
  colid INTEGER NOT NULL,
  deleted BOOL DEFAULT FALSE,
  creation_date DATETIME DEFAULT CURRENT_TIMESTAMP,
  last_modified DATETIME DEFAULT CURRENT_TIMESTAMP
);
CREATE TRIGGER update_sequence_columns AFTER UPDATE ON sequence_columns
  BEGIN
    UPDATE sequence_columns SET last_modified = DATETIME('NOW')
    WHERE sequenceid = new.sequenceid;
  END;

CREATE TABLE sequence_data (
  sequence_dataid INTEGER PRIMARY KEY,
  sequenceid INTEGER NOT NULL,
  label TEXT,
  trend BOOL, --true is trend false if sequence
  sb BOOL, --true is sequence boundary, false is maximum flooding surface
  age FLOAT,
  severity TEXT, --enum
  deleted BOOL DEFAULT FALSE,
  creation_date DATETIME DEFAULT CURRENT_TIMESTAMP,
  last_modified DATETIME DEFAULT CURRENT_TIMESTAMP
);
CREATE TRIGGER update_sequence_data AFTER UPDATE ON sequence_data
  BEGIN
    UPDATE sequence_data SET last_modified = DATETIME('NOW')
    WHERE sequence_dataid = new.sequence_dataid;
  END;


--Block things--
CREATE TABLE block_columns (
  blockid INTEGER PRIMARY KEY,
  colid INTEGER NOT NULL,
  deleted BOOL DEFAULT FALSE,
  creation_date DATETIME DEFAULT CURRENT_TIMESTAMP,
  last_modified DATETIME DEFAULT CURRENT_TIMESTAMP
);
CREATE TRIGGER update_block_columns AFTER UPDATE ON block_columns
  BEGIN
    UPDATE block_columns SET last_modified = DATETIME('NOW')
    WHERE blockid = new.blockid;
  END;

CREATE TABLE block_data (
  block_dataid INTEGER PRIMARY KEY,
  blockid INTEGER NOT NULL,
  label TEXT, --TOP just means no label
  age FLOAT,
  linestyle TEXT, --enum
  deleted BOOL DEFAULT FALSE,
  creation_date DATETIME DEFAULT CURRENT_TIMESTAMP,
  last_modified DATETIME DEFAULT CURRENT_TIMESTAMP
);
CREATE TRIGGER update_block_data AFTER UPDATE ON block_data
  BEGIN
    UPDATE block_data SET last_modified = DATETIME('NOW')
    WHERE block_dataid = new.block_dataid;
  END;


--Range things--
CREATE TABLE range_columns (
  rangeid INTEGER PRIMARY KEY,
  colid INTEGER NOT NULL,
  deleted BOOL DEFAULT FALSE,
  creation_date DATETIME DEFAULT CURRENT_TIMESTAMP,
  last_modified DATETIME DEFAULT CURRENT_TIMESTAMP
);
CREATE TRIGGER update_range_columns AFTER UPDATE ON range_columns
  BEGIN
    UPDATE range_columns SET last_modified = DATETIME('NOW')
    WHERE rangeid = new.rangeid;
  END;

CREATE TABLE range_data (
  range_dataid INTEGER PRIMARY KEY,
  rangeid INTEGER NOT NULL,
  label TEXT,
  age FLOAT,
  abundance TEXT, --enum
  deleted BOOL DEFAULT FALSE,
  creation_date DATETIME DEFAULT CURRENT_TIMESTAMP,
  last_modified DATETIME DEFAULT CURRENT_TIMESTAMP
);
CREATE TRIGGER update_range_data AFTER UPDATE ON range_data
  BEGIN
    UPDATE range_data SET last_modified = DATETIME('NOW')
    WHERE range_dataid = new.range_dataid;
  END;


--Chron things--
CREATE TABLE chron_columns (
  chronid INTEGER PRIMARY KEY,
  colid INTEGER NOT NULL,
  series_width FLOAT,
  deleted BOOL DEFAULT FALSE,
  creation_date DATETIME DEFAULT CURRENT_TIMESTAMP,
  last_modified DATETIME DEFAULT CURRENT_TIMESTAMP
);
CREATE TRIGGER update_chron_columns AFTER UPDATE ON chron_columns
  BEGIN
    UPDATE chron_columns SET last_modified = DATETIME('NOW')
    WHERE chronid = new.chronid;
  END;

CREATE TABLE chron_data (
  chron_dataid INTEGER PRIMARY KEY,
  chronid INTEGER NOT NULL,
  polarity TEXT,
  label TEXT,
  age FLOAT,
  deleted BOOL DEFAULT FALSE,
  creation_date DATETIME DEFAULT CURRENT_TIMESTAMP,
  last_modified DATETIME DEFAULT CURRENT_TIMESTAMP
);
CREATE TRIGGER update_chron_data AFTER UPDATE ON chron_data
  BEGIN
    UPDATE chron_data SET last_modified = DATETIME('NOW')
    WHERE chron_dataid = new.chron_dataid;
  END;


--Point things--
CREATE TABLE point_columns (
  pointid INTEGER PRIMARY KEY,
  colid INTEGER NOT NULL,
  prev_colid INTEGER, --column this one will overlay or NULL if regular column
  line BOOL,
  fill_color TEXT,
  range_low FLOAT,
  range_high FLOAT,
  smoothed BOOL,
  deleted BOOL DEFAULT FALSE,
  creation_date DATETIME DEFAULT CURRENT_TIMESTAMP,
  last_modified DATETIME DEFAULT CURRENT_TIMESTAMP
);
CREATE TRIGGER update_point_columns AFTER UPDATE ON point_columns
  BEGIN
    UPDATE point_columns SET last_modified = DATETIME('NOW')
    WHERE pointid = new.pointid;
  END;

CREATE TABLE point_data (
  point_dataid INTEGER PRIMARY KEY,
  pointid INTEGER NOT NULL,
  age FLOAT,
  x_value FLOAT,
  deleted BOOL DEFAULT FALSE,
  creation_date DATETIME DEFAULT CURRENT_TIMESTAMP,
  last_modified DATETIME DEFAULT CURRENT_TIMESTAMP
);
CREATE TRIGGER update_point_data AFTER UPDATE ON point_data
  BEGIN
    UPDATE point_data SET last_modified = DATETIME('NOW')
    WHERE point_dataid = new.point_dataid;
  END;


--Freehand things--
CREATE TABLE freehand_columns (
  freehandid INTEGER PRIMARY KEY,
  colid INTEGER NOT NULL,
  type TEXT, --enum
  prev_colid INTEGER, --the column this one will overlay
  deleted BOOL DEFAULT FALSE,
  creation_date DATETIME DEFAULT CURRENT_TIMESTAMP,
  last_modified DATETIME DEFAULT CURRENT_TIMESTAMP
);
CREATE TRIGGER update_freehand_columns AFTER UPDATE ON freehand_columns
  BEGIN
    UPDATE freehand_columns SET last_modified = DATETIME('NOW')
    WHERE freehandid = new.freehandid;
  END;

CREATE TABLE freehand_data (
  freehand_dataid INTEGER PRIMARY KEY,
  freehandid INTEGER NOT NULL,
  image BLOB,
  top_age FLOAT,
  base_age FLOAT,
  x_type TEXT, --enum
  y_type TEXT, --enum
  y_top_age FLOAT,
  y_base_age FLOAT,
  deleted BOOL DEFAULT FALSE,
  creation_date DATETIME DEFAULT CURRENT_TIMESTAMP,
  last_modified DATETIME DEFAULT CURRENT_TIMESTAMP
);
CREATE TRIGGER update_freehand_data AFTER UPDATE ON freehand_data
  BEGIN
    UPDATE freehand_data SET last_modified = DATETIME('NOW')
    WHERE freehand_dataid = new.freehand_dataid;
  END;


--Transect things--
CREATE TABLE transect_columns (
  transectid INTEGER PRIMARY KEY,
  colid INTEGER NOT NULL,
  deleted BOOL DEFAULT FALSE,
  creation_date DATETIME DEFAULT CURRENT_TIMESTAMP,
  last_modified DATETIME DEFAULT CURRENT_TIMESTAMP
);
CREATE TRIGGER update_transect_columns AFTER UPDATE ON transect_columns
  BEGIN
    UPDATE transect_columns SET last_modified = DATETIME('NOW')
    WHERE transectid = new.transectid;
  END;

CREATE TABLE transect_lines (
  lineid INTEGER PRIMARY KEY,
  transectid INTEGER NOT NULL,
  x1 FLOAT,
  x2 FLOAT,
  y1 FLOAT,
  y2 FLOAT,
  deleted BOOL DEFAULT FALSE,
  creation_date DATETIME DEFAULT CURRENT_TIMESTAMP,
  last_modified DATETIME DEFAULT CURRENT_TIMESTAMP
);
CREATE TRIGGER update_transect_lines AFTER UPDATE ON transect_lines
  BEGIN
    UPDATE transect_lines SET last_modified = DATETIME('NOW')
    WHERE lineid = new.lineid;
  END;

CREATE TABLE transect_fills (
  fillid INTEGER PRIMARY KEY,
  transectid INTEGER NOT NULL,
  x_coord FLOAT,
  y_coord FLOAT,
  patternid INTEGER,
  deleted BOOL DEFAULT FALSE,
  creation_date DATETIME DEFAULT CURRENT_TIMESTAMP,
  last_modified DATETIME DEFAULT CURRENT_TIMESTAMP
);
CREATE TRIGGER update_transect_fills AFTER UPDATE ON transect_fills
  BEGIN
    UPDATE transect_fills SET last_modified = DATETIME('NOW')
    WHERE fillid = new.fillid;
  END;


--Mappack things--
CREATE TABLE mappacks (
  mapid INTEGER PRIMARY KEY,
  version FLOAT,
  name TEXT,
  image BLOB,
  note TEXT,
  coord_type TEXT,
  upper_left_lon FLOAT,
  upper_left_alt FLOAT,
  lower_right_lon FLOAT,
  lower_right_at FLOAT,
  parent_map TEXT, --not sure what this parent nonsense is
  parent_coord_type TEXT,
  parent_upper_left_lon FLOAT,
  parent_upper_left_alt FLOAT,
  parent_lower_right_lon FLOAT,
  parent_lower_right_at FLOAT,
  deleted BOOL DEFAULT FALSE,
  creation_date DATETIME DEFAULT CURRENT_TIMESTAMP,
  last_modified DATETIME DEFAULT CURRENT_TIMESTAMP
);
CREATE TRIGGER update_mappacks AFTER UPDATE ON mappacks
  BEGIN
    UPDATE mappacks SET last_modified = DATETIME('NOW')
    WHERE mapid = new.mapid;
  END;

CREATE TABLE map_columns (
  map_columnid INTEGER PRIMARY KEY,
  mapid INTEGER NOT NULL,
  name TEXT,
  lat FLOAT,
  lon FLOAT,
  note TEXT,
  info_point BOOL,
  deleted BOOL DEFAULT FALSE,
  creation_date DATETIME DEFAULT CURRENT_TIMESTAMP,
  last_modified DATETIME DEFAULT CURRENT_TIMESTAMP
);
CREATE TRIGGER update_map_columns AFTER UPDATE ON map_columns
  BEGIN
    UPDATE map_columns SET last_modified = DATETIME('NOW')
    WHERE map_columnid = new.map_columnid;
  END;

CREATE TABLE map_transects (
  map_transectid INTEGER PRIMARY KEY,
  mapid INTEGER NOT NULL,
  name TEXT,
  start_loc INTEGER NOT NULL, --a map_columnid
  end_loc INTEGER NOT NULL, --a map_columnid
  note TEXT,
  deleted BOOL DEFAULT FALSE,
  creation_date DATETIME DEFAULT CURRENT_TIMESTAMP,
  last_modified DATETIME DEFAULT CURRENT_TIMESTAMP
);
CREATE TRIGGER update_map_transects AFTER UPDATE ON map_transects
  BEGIN
    UPDATE map_tansects SET last_modified = DATETIME('NOW')
    WHERE map_transectid = new.map_transectid;
  END;

